// Copyright (C) 2022 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//	http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package apex

import (
	"android/soong/android"
	"strings"
)

// This file contains the bp2build integration for the apex package.

// Export constants as Starlark using bp2build to Bazel.
func BazelApexToolchainVars() string {
	content := []string{
		"# GENERATED BY SOONG. DO NOT EDIT.",
		"default_manifest_version = " + android.DefaultUpdatableModuleVersion, // constants.go is different in every branch.
	}
	return strings.Join(content, "\n")
}
