// Copyright 2020 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        v3.21.12
// source: sbox.proto

package sbox_proto

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A set of commands to run in a sandbox.
type Manifest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of commands to run in the sandbox.
	Commands []*Command `protobuf:"bytes,1,rep,name=commands" json:"commands,omitempty"`
	// If set, GCC-style dependency files from any command that references __SBOX_DEPFILE__ will be
	// merged into the given output file relative to the $PWD when sbox was started.
	OutputDepfile *string `protobuf:"bytes,2,opt,name=output_depfile,json=outputDepfile" json:"output_depfile,omitempty"`
}

func (x *Manifest) Reset() {
	*x = Manifest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sbox_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Manifest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Manifest) ProtoMessage() {}

func (x *Manifest) ProtoReflect() protoreflect.Message {
	mi := &file_sbox_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Manifest.ProtoReflect.Descriptor instead.
func (*Manifest) Descriptor() ([]byte, []int) {
	return file_sbox_proto_rawDescGZIP(), []int{0}
}

func (x *Manifest) GetCommands() []*Command {
	if x != nil {
		return x.Commands
	}
	return nil
}

func (x *Manifest) GetOutputDepfile() string {
	if x != nil && x.OutputDepfile != nil {
		return *x.OutputDepfile
	}
	return ""
}

// SandboxManifest describes a command to run in the sandbox.
type Command struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of copy rules to run before the sandboxed command.  The from field is relative to the
	// $PWD when sbox was run, the to field is relative to the top of the temporary sandbox directory.
	CopyBefore []*Copy `protobuf:"bytes,1,rep,name=copy_before,json=copyBefore" json:"copy_before,omitempty"`
	// If true, change the working directory to the top of the temporary sandbox directory before
	// running the command.  If false, leave the working directory where it was when sbox was started.
	Chdir *bool `protobuf:"varint,2,opt,name=chdir" json:"chdir,omitempty"`
	// The command to run.
	Command *string `protobuf:"bytes,3,req,name=command" json:"command,omitempty"`
	// A list of copy rules to run after the sandboxed command.  The from field is relative to the
	// top of the temporary sandbox directory, the to field is relative to the $PWD when sbox was run.
	CopyAfter []*Copy `protobuf:"bytes,4,rep,name=copy_after,json=copyAfter" json:"copy_after,omitempty"`
	// An optional hash of the input files to ensure the textproto files and the sbox rule reruns
	// when the lists of inputs changes, even if the inputs are not on the command line.
	InputHash *string `protobuf:"bytes,5,opt,name=input_hash,json=inputHash" json:"input_hash,omitempty"`
	// A list of files that will be copied before the sandboxed command, and whose contents should be
	// copied as if they were listed in copy_before.
	RspFiles []*RspFile `protobuf:"bytes,6,rep,name=rsp_files,json=rspFiles" json:"rsp_files,omitempty"`
	// The environment variables that will be set or unset while running the command.
	// Also see dont_inherit_env.
	Env []*EnvironmentVariable `protobuf:"bytes,7,rep,name=env" json:"env,omitempty"`
	// By default, all environment variables are inherited from the calling process, but may be
	// replaced or unset by env. If dont_inherit_env is set, no environment variables will be
	// inherited, and instead only the variables in env will be defined.
	DontInheritEnv *bool `protobuf:"varint,8,opt,name=dont_inherit_env,json=dontInheritEnv" json:"dont_inherit_env,omitempty"`
}

func (x *Command) Reset() {
	*x = Command{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sbox_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Command) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Command) ProtoMessage() {}

func (x *Command) ProtoReflect() protoreflect.Message {
	mi := &file_sbox_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Command.ProtoReflect.Descriptor instead.
func (*Command) Descriptor() ([]byte, []int) {
	return file_sbox_proto_rawDescGZIP(), []int{1}
}

func (x *Command) GetCopyBefore() []*Copy {
	if x != nil {
		return x.CopyBefore
	}
	return nil
}

func (x *Command) GetChdir() bool {
	if x != nil && x.Chdir != nil {
		return *x.Chdir
	}
	return false
}

func (x *Command) GetCommand() string {
	if x != nil && x.Command != nil {
		return *x.Command
	}
	return ""
}

func (x *Command) GetCopyAfter() []*Copy {
	if x != nil {
		return x.CopyAfter
	}
	return nil
}

func (x *Command) GetInputHash() string {
	if x != nil && x.InputHash != nil {
		return *x.InputHash
	}
	return ""
}

func (x *Command) GetRspFiles() []*RspFile {
	if x != nil {
		return x.RspFiles
	}
	return nil
}

func (x *Command) GetEnv() []*EnvironmentVariable {
	if x != nil {
		return x.Env
	}
	return nil
}

func (x *Command) GetDontInheritEnv() bool {
	if x != nil && x.DontInheritEnv != nil {
		return *x.DontInheritEnv
	}
	return false
}

type EnvironmentVariable struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the environment variable
	Name *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	// Types that are assignable to State:
	//
	//	*EnvironmentVariable_Value
	//	*EnvironmentVariable_Unset
	//	*EnvironmentVariable_Inherit
	State isEnvironmentVariable_State `protobuf_oneof:"state"`
}

func (x *EnvironmentVariable) Reset() {
	*x = EnvironmentVariable{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sbox_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnvironmentVariable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnvironmentVariable) ProtoMessage() {}

func (x *EnvironmentVariable) ProtoReflect() protoreflect.Message {
	mi := &file_sbox_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnvironmentVariable.ProtoReflect.Descriptor instead.
func (*EnvironmentVariable) Descriptor() ([]byte, []int) {
	return file_sbox_proto_rawDescGZIP(), []int{2}
}

func (x *EnvironmentVariable) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (m *EnvironmentVariable) GetState() isEnvironmentVariable_State {
	if m != nil {
		return m.State
	}
	return nil
}

func (x *EnvironmentVariable) GetValue() string {
	if x, ok := x.GetState().(*EnvironmentVariable_Value); ok {
		return x.Value
	}
	return ""
}

func (x *EnvironmentVariable) GetUnset() bool {
	if x, ok := x.GetState().(*EnvironmentVariable_Unset); ok {
		return x.Unset
	}
	return false
}

func (x *EnvironmentVariable) GetInherit() bool {
	if x, ok := x.GetState().(*EnvironmentVariable_Inherit); ok {
		return x.Inherit
	}
	return false
}

type isEnvironmentVariable_State interface {
	isEnvironmentVariable_State()
}

type EnvironmentVariable_Value struct {
	// The value to set the environment variable to.
	Value string `protobuf:"bytes,2,opt,name=value,oneof"`
}

type EnvironmentVariable_Unset struct {
	// This environment variable should be unset in the command.
	Unset bool `protobuf:"varint,3,opt,name=unset,oneof"`
}

type EnvironmentVariable_Inherit struct {
	// This environment variable should be inherited from the parent process.
	// Can be combined with dont_inherit_env to only inherit certain environment
	// variables.
	Inherit bool `protobuf:"varint,4,opt,name=inherit,oneof"`
}

func (*EnvironmentVariable_Value) isEnvironmentVariable_State() {}

func (*EnvironmentVariable_Unset) isEnvironmentVariable_State() {}

func (*EnvironmentVariable_Inherit) isEnvironmentVariable_State() {}

// Copy describes a from-to pair of files to copy.  The paths may be relative, the root that they
// are relative to is specific to the context the Copy is used in and will be different for
// from and to.
type Copy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	From *string `protobuf:"bytes,1,req,name=from" json:"from,omitempty"`
	To   *string `protobuf:"bytes,2,req,name=to" json:"to,omitempty"`
	// If true, make the file executable after copying it.
	Executable *bool `protobuf:"varint,3,opt,name=executable" json:"executable,omitempty"`
}

func (x *Copy) Reset() {
	*x = Copy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sbox_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Copy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Copy) ProtoMessage() {}

func (x *Copy) ProtoReflect() protoreflect.Message {
	mi := &file_sbox_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Copy.ProtoReflect.Descriptor instead.
func (*Copy) Descriptor() ([]byte, []int) {
	return file_sbox_proto_rawDescGZIP(), []int{3}
}

func (x *Copy) GetFrom() string {
	if x != nil && x.From != nil {
		return *x.From
	}
	return ""
}

func (x *Copy) GetTo() string {
	if x != nil && x.To != nil {
		return *x.To
	}
	return ""
}

func (x *Copy) GetExecutable() bool {
	if x != nil && x.Executable != nil {
		return *x.Executable
	}
	return false
}

// RspFile describes an rspfile that should be copied into the sandbox directory.
type RspFile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The path to the rsp file.
	File *string `protobuf:"bytes,1,req,name=file" json:"file,omitempty"`
	// A list of path mappings that should be applied to each file listed in the rsp file.
	PathMappings []*PathMapping `protobuf:"bytes,2,rep,name=path_mappings,json=pathMappings" json:"path_mappings,omitempty"`
}

func (x *RspFile) Reset() {
	*x = RspFile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sbox_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RspFile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RspFile) ProtoMessage() {}

func (x *RspFile) ProtoReflect() protoreflect.Message {
	mi := &file_sbox_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RspFile.ProtoReflect.Descriptor instead.
func (*RspFile) Descriptor() ([]byte, []int) {
	return file_sbox_proto_rawDescGZIP(), []int{4}
}

func (x *RspFile) GetFile() string {
	if x != nil && x.File != nil {
		return *x.File
	}
	return ""
}

func (x *RspFile) GetPathMappings() []*PathMapping {
	if x != nil {
		return x.PathMappings
	}
	return nil
}

// PathMapping describes a mapping from a path outside the sandbox to the path inside the sandbox.
type PathMapping struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	From *string `protobuf:"bytes,1,req,name=from" json:"from,omitempty"`
	To   *string `protobuf:"bytes,2,req,name=to" json:"to,omitempty"`
}

func (x *PathMapping) Reset() {
	*x = PathMapping{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sbox_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PathMapping) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PathMapping) ProtoMessage() {}

func (x *PathMapping) ProtoReflect() protoreflect.Message {
	mi := &file_sbox_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PathMapping.ProtoReflect.Descriptor instead.
func (*PathMapping) Descriptor() ([]byte, []int) {
	return file_sbox_proto_rawDescGZIP(), []int{5}
}

func (x *PathMapping) GetFrom() string {
	if x != nil && x.From != nil {
		return *x.From
	}
	return ""
}

func (x *PathMapping) GetTo() string {
	if x != nil && x.To != nil {
		return *x.To
	}
	return ""
}

var File_sbox_proto protoreflect.FileDescriptor

var file_sbox_proto_rawDesc = []byte{
	0x0a, 0x0a, 0x73, 0x62, 0x6f, 0x78, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x04, 0x73, 0x62,
	0x6f, 0x78, 0x22, 0x5c, 0x0a, 0x08, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x12, 0x29,
	0x0a, 0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x0d, 0x2e, 0x73, 0x62, 0x6f, 0x78, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x52,
	0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x5f, 0x64, 0x65, 0x70, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x44, 0x65, 0x70, 0x66, 0x69, 0x6c, 0x65,
	0x22, 0xb3, 0x02, 0x0a, 0x07, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x2b, 0x0a, 0x0b,
	0x63, 0x6f, 0x70, 0x79, 0x5f, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x0a, 0x2e, 0x73, 0x62, 0x6f, 0x78, 0x2e, 0x43, 0x6f, 0x70, 0x79, 0x52, 0x0a, 0x63,
	0x6f, 0x70, 0x79, 0x42, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x68, 0x64,
	0x69, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x63, 0x68, 0x64, 0x69, 0x72, 0x12,
	0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x18, 0x03, 0x20, 0x02, 0x28, 0x09,
	0x52, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x29, 0x0a, 0x0a, 0x63, 0x6f, 0x70,
	0x79, 0x5f, 0x61, 0x66, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0a, 0x2e,
	0x73, 0x62, 0x6f, 0x78, 0x2e, 0x43, 0x6f, 0x70, 0x79, 0x52, 0x09, 0x63, 0x6f, 0x70, 0x79, 0x41,
	0x66, 0x74, 0x65, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x68, 0x61,
	0x73, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x48,
	0x61, 0x73, 0x68, 0x12, 0x2a, 0x0a, 0x09, 0x72, 0x73, 0x70, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x73,
	0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x73, 0x62, 0x6f, 0x78, 0x2e, 0x52, 0x73,
	0x70, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x08, 0x72, 0x73, 0x70, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x12,
	0x2b, 0x0a, 0x03, 0x65, 0x6e, 0x76, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x73,
	0x62, 0x6f, 0x78, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x56,
	0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x03, 0x65, 0x6e, 0x76, 0x12, 0x28, 0x0a, 0x10,
	0x64, 0x6f, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x68, 0x65, 0x72, 0x69, 0x74, 0x5f, 0x65, 0x6e, 0x76,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x64, 0x6f, 0x6e, 0x74, 0x49, 0x6e, 0x68, 0x65,
	0x72, 0x69, 0x74, 0x45, 0x6e, 0x76, 0x22, 0x7e, 0x0a, 0x13, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x16, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x16, 0x0a, 0x05, 0x75, 0x6e, 0x73,
	0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x05, 0x75, 0x6e, 0x73, 0x65,
	0x74, 0x12, 0x1a, 0x0a, 0x07, 0x69, 0x6e, 0x68, 0x65, 0x72, 0x69, 0x74, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x08, 0x48, 0x00, 0x52, 0x07, 0x69, 0x6e, 0x68, 0x65, 0x72, 0x69, 0x74, 0x42, 0x07, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x22, 0x4a, 0x0a, 0x04, 0x43, 0x6f, 0x70, 0x79, 0x12, 0x12,
	0x0a, 0x04, 0x66, 0x72, 0x6f, 0x6d, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x04, 0x66, 0x72,
	0x6f, 0x6d, 0x12, 0x0e, 0x0a, 0x02, 0x74, 0x6f, 0x18, 0x02, 0x20, 0x02, 0x28, 0x09, 0x52, 0x02,
	0x74, 0x6f, 0x12, 0x1e, 0x0a, 0x0a, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x22, 0x55, 0x0a, 0x07, 0x52, 0x73, 0x70, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x04, 0x66, 0x69, 0x6c,
	0x65, 0x12, 0x36, 0x0a, 0x0d, 0x70, 0x61, 0x74, 0x68, 0x5f, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x73, 0x62, 0x6f, 0x78, 0x2e,
	0x50, 0x61, 0x74, 0x68, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x0c, 0x70, 0x61, 0x74,
	0x68, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x31, 0x0a, 0x0b, 0x50, 0x61, 0x74,
	0x68, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x66, 0x72, 0x6f, 0x6d,
	0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x04, 0x66, 0x72, 0x6f, 0x6d, 0x12, 0x0e, 0x0a, 0x02,
	0x74, 0x6f, 0x18, 0x02, 0x20, 0x02, 0x28, 0x09, 0x52, 0x02, 0x74, 0x6f, 0x42, 0x23, 0x5a, 0x21,
	0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2f, 0x73, 0x6f, 0x6f, 0x6e, 0x67, 0x2f, 0x63, 0x6d,
	0x64, 0x2f, 0x73, 0x62, 0x6f, 0x78, 0x2f, 0x73, 0x62, 0x6f, 0x78, 0x5f, 0x70, 0x72, 0x6f, 0x74,
	0x6f,
}

var (
	file_sbox_proto_rawDescOnce sync.Once
	file_sbox_proto_rawDescData = file_sbox_proto_rawDesc
)

func file_sbox_proto_rawDescGZIP() []byte {
	file_sbox_proto_rawDescOnce.Do(func() {
		file_sbox_proto_rawDescData = protoimpl.X.CompressGZIP(file_sbox_proto_rawDescData)
	})
	return file_sbox_proto_rawDescData
}

var file_sbox_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_sbox_proto_goTypes = []interface{}{
	(*Manifest)(nil),            // 0: sbox.Manifest
	(*Command)(nil),             // 1: sbox.Command
	(*EnvironmentVariable)(nil), // 2: sbox.EnvironmentVariable
	(*Copy)(nil),                // 3: sbox.Copy
	(*RspFile)(nil),             // 4: sbox.RspFile
	(*PathMapping)(nil),         // 5: sbox.PathMapping
}
var file_sbox_proto_depIdxs = []int32{
	1, // 0: sbox.Manifest.commands:type_name -> sbox.Command
	3, // 1: sbox.Command.copy_before:type_name -> sbox.Copy
	3, // 2: sbox.Command.copy_after:type_name -> sbox.Copy
	4, // 3: sbox.Command.rsp_files:type_name -> sbox.RspFile
	2, // 4: sbox.Command.env:type_name -> sbox.EnvironmentVariable
	5, // 5: sbox.RspFile.path_mappings:type_name -> sbox.PathMapping
	6, // [6:6] is the sub-list for method output_type
	6, // [6:6] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_sbox_proto_init() }
func file_sbox_proto_init() {
	if File_sbox_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_sbox_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Manifest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sbox_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Command); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sbox_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EnvironmentVariable); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sbox_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Copy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sbox_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RspFile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sbox_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PathMapping); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_sbox_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*EnvironmentVariable_Value)(nil),
		(*EnvironmentVariable_Unset)(nil),
		(*EnvironmentVariable_Inherit)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_sbox_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_sbox_proto_goTypes,
		DependencyIndexes: file_sbox_proto_depIdxs,
		MessageInfos:      file_sbox_proto_msgTypes,
	}.Build()
	File_sbox_proto = out.File
	file_sbox_proto_rawDesc = nil
	file_sbox_proto_goTypes = nil
	file_sbox_proto_depIdxs = nil
}
