# Build Android Platform on Remote Build Execution

Soong is integrated with Google's Remote Build Execution(RBE) service, which
implements the
[Remote Executaion API](https://github.com/bazelbuild/remote-apis).

With RBE enabled, it can speed up the Android Platform builds by distributing
build actions through a worker pool sharing a central cache of build results.

## Configuration

To enable RBE, you need to set several environment variables before triggering
the build. You can set them through a
[environment variables config file](https://android.googlesource.com/platform/build/soong/+/main/README.md#environment-variables-config-file).
As an example, [build/soong/docs/rbe.json](rbe.json) is a config that enables
RBE in the build. Once the config file is created, you need to let Soong load
the config file by specifying `ANDROID_BUILD_ENVIRONMENT_CONFIG_DIR` environment
variable and `ANDROID_BUILD_ENVIRONMENT_CONFIG` environment variable. The
following command starts Soong with [build/soong/docs/rbe.json](rbe.json)
loaded:

```shell
ANDROID_BUILD_ENVIRONMENT_CONFIG=rbe \
ANDROID_BUILD_ENVIRONMENT_CONFIG_DIR=build/soong/doc \
  build/soong/soong_ui.bash
```

### Configuration Explanation

Below a brief explanation of each field in
[build/soong/docs/rbe.json](rbe.json):

##### USE\_RBE:
If set to 1, enable RBE for the build.

##### RBE\_CXX\_EXEC\_STRATEGY / RBE\_JAVAC\_EXEC\_STRATEGY / RBE\_R8\_EXEC\_STRATEGY / RBE\_D8\_EXEC\_STRATEGY:

Sets strategies for C++/javac/r8/d8 action types. Available options are
(**Note**: all options will update the remote cache if the right permissions to
update cache are given to the user.):

*   **local**: Only execute locally.
*   **remote**: Only execute remotely.
*   **remote_local_fallback**: Try executing remotely and fall back to local
    execution if failed.
*   **racing**: Race remote execution and local execution and use the earlier
    result.

##### RBE\_JAVAC / RBE\_R8 / RBE\_D8

If set to 1, enable javac/r8/d8 support. C++ compilation is enabled by default.

##### RBE\_service / RBE\_instance

The remote execution service endpoint and instance ID to target when calling
remote execution via gRPC to execute actions.

##### RBE\_DIR

Where to find remote client binaries (rewrapper, reproxy)

##### RBE\_use\_application\_default\_credentials

reclient uses
[application default credentials](https://cloud.google.com/sdk/gcloud/reference/auth/application-default/login)
for autentication, as generated by `gcloud auth application-default login`

##### RBE\_log\_dir/RBE\_proxy\_log\_dir/RBE\_output\_dir

Logs generated by rewrapper and reproxy will go here.
