// Copyright 2019 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.9.1
// source: build_error.proto

package build_error_proto

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type BuildError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of error messages of the overall build. The error messages
	// are not associated with a build action.
	ErrorMessages []string `protobuf:"bytes,1,rep,name=error_messages,json=errorMessages" json:"error_messages,omitempty"`
	// List of build action errors.
	ActionErrors []*BuildActionError `protobuf:"bytes,2,rep,name=action_errors,json=actionErrors" json:"action_errors,omitempty"`
}

func (x *BuildError) Reset() {
	*x = BuildError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_error_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BuildError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BuildError) ProtoMessage() {}

func (x *BuildError) ProtoReflect() protoreflect.Message {
	mi := &file_build_error_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BuildError.ProtoReflect.Descriptor instead.
func (*BuildError) Descriptor() ([]byte, []int) {
	return file_build_error_proto_rawDescGZIP(), []int{0}
}

func (x *BuildError) GetErrorMessages() []string {
	if x != nil {
		return x.ErrorMessages
	}
	return nil
}

func (x *BuildError) GetActionErrors() []*BuildActionError {
	if x != nil {
		return x.ActionErrors
	}
	return nil
}

// Build is composed of a list of build action. There can be a set of build
// actions that can failed.
type BuildActionError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Description of the command.
	Description *string `protobuf:"bytes,1,opt,name=description" json:"description,omitempty"`
	// The command name that raised the error.
	Command *string `protobuf:"bytes,2,opt,name=command" json:"command,omitempty"`
	// The command output stream.
	Output *string `protobuf:"bytes,3,opt,name=output" json:"output,omitempty"`
	// List of artifacts (i.e. files) that was produced by the command.
	Artifacts []string `protobuf:"bytes,4,rep,name=artifacts" json:"artifacts,omitempty"`
	// The error string produced by the build action.
	Error *string `protobuf:"bytes,5,opt,name=error" json:"error,omitempty"`
}

func (x *BuildActionError) Reset() {
	*x = BuildActionError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_error_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BuildActionError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BuildActionError) ProtoMessage() {}

func (x *BuildActionError) ProtoReflect() protoreflect.Message {
	mi := &file_build_error_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BuildActionError.ProtoReflect.Descriptor instead.
func (*BuildActionError) Descriptor() ([]byte, []int) {
	return file_build_error_proto_rawDescGZIP(), []int{1}
}

func (x *BuildActionError) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *BuildActionError) GetCommand() string {
	if x != nil && x.Command != nil {
		return *x.Command
	}
	return ""
}

func (x *BuildActionError) GetOutput() string {
	if x != nil && x.Output != nil {
		return *x.Output
	}
	return ""
}

func (x *BuildActionError) GetArtifacts() []string {
	if x != nil {
		return x.Artifacts
	}
	return nil
}

func (x *BuildActionError) GetError() string {
	if x != nil && x.Error != nil {
		return *x.Error
	}
	return ""
}

var File_build_error_proto protoreflect.FileDescriptor

var file_build_error_proto_rawDesc = []byte{
	0x0a, 0x11, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x11, 0x73, 0x6f, 0x6f, 0x6e, 0x67, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x7d, 0x0a, 0x0a, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x45,
	0x72, 0x72, 0x6f, 0x72, 0x12, 0x25, 0x0a, 0x0e, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x12, 0x48, 0x0a, 0x0d, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x23, 0x2e, 0x73, 0x6f, 0x6f, 0x6e, 0x67, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x0c, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45,
	0x72, 0x72, 0x6f, 0x72, 0x73, 0x22, 0x9a, 0x01, 0x0a, 0x10, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x1c,
	0x0a, 0x09, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x09, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x12, 0x14, 0x0a, 0x05,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x42, 0x2b, 0x5a, 0x29, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2f, 0x73, 0x6f,
	0x6f, 0x6e, 0x67, 0x2f, 0x75, 0x69, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2f, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
}

var (
	file_build_error_proto_rawDescOnce sync.Once
	file_build_error_proto_rawDescData = file_build_error_proto_rawDesc
)

func file_build_error_proto_rawDescGZIP() []byte {
	file_build_error_proto_rawDescOnce.Do(func() {
		file_build_error_proto_rawDescData = protoimpl.X.CompressGZIP(file_build_error_proto_rawDescData)
	})
	return file_build_error_proto_rawDescData
}

var file_build_error_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_build_error_proto_goTypes = []interface{}{
	(*BuildError)(nil),       // 0: soong_build_error.BuildError
	(*BuildActionError)(nil), // 1: soong_build_error.BuildActionError
}
var file_build_error_proto_depIdxs = []int32{
	1, // 0: soong_build_error.BuildError.action_errors:type_name -> soong_build_error.BuildActionError
	1, // [1:1] is the sub-list for method output_type
	1, // [1:1] is the sub-list for method input_type
	1, // [1:1] is the sub-list for extension type_name
	1, // [1:1] is the sub-list for extension extendee
	0, // [0:1] is the sub-list for field type_name
}

func init() { file_build_error_proto_init() }
func file_build_error_proto_init() {
	if File_build_error_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_build_error_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BuildError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_build_error_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BuildActionError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_build_error_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_build_error_proto_goTypes,
		DependencyIndexes: file_build_error_proto_depIdxs,
		MessageInfos:      file_build_error_proto_msgTypes,
	}.Build()
	File_build_error_proto = out.File
	file_build_error_proto_rawDesc = nil
	file_build_error_proto_goTypes = nil
	file_build_error_proto_depIdxs = nil
}
