// Messages describing APK Set's table of contents (toc.pb entry).
// Please be advised that the ultimate source is at
// https://github.com/google/bundletool/tree/master/src/main/proto
// so you have been warned.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.9.1
// source: commands.proto

package bundle_proto

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type DeliveryType int32

const (
	DeliveryType_UNKNOWN_DELIVERY_TYPE DeliveryType = 0
	DeliveryType_INSTALL_TIME          DeliveryType = 1
	DeliveryType_ON_DEMAND             DeliveryType = 2
	DeliveryType_FAST_FOLLOW           DeliveryType = 3
)

// Enum value maps for DeliveryType.
var (
	DeliveryType_name = map[int32]string{
		0: "UNKNOWN_DELIVERY_TYPE",
		1: "INSTALL_TIME",
		2: "ON_DEMAND",
		3: "FAST_FOLLOW",
	}
	DeliveryType_value = map[string]int32{
		"UNKNOWN_DELIVERY_TYPE": 0,
		"INSTALL_TIME":          1,
		"ON_DEMAND":             2,
		"FAST_FOLLOW":           3,
	}
)

func (x DeliveryType) Enum() *DeliveryType {
	p := new(DeliveryType)
	*p = x
	return p
}

func (x DeliveryType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DeliveryType) Descriptor() protoreflect.EnumDescriptor {
	return file_commands_proto_enumTypes[0].Descriptor()
}

func (DeliveryType) Type() protoreflect.EnumType {
	return &file_commands_proto_enumTypes[0]
}

func (x DeliveryType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DeliveryType.Descriptor instead.
func (DeliveryType) EnumDescriptor() ([]byte, []int) {
	return file_commands_proto_rawDescGZIP(), []int{0}
}

type SystemApkMetadata_SystemApkType int32

const (
	SystemApkMetadata_UNSPECIFIED_VALUE SystemApkMetadata_SystemApkType = 0
	// Uncompressed APK for system image.
	SystemApkMetadata_SYSTEM SystemApkMetadata_SystemApkType = 1
	// Stub APK for compressed APK in the system image
	// (contains only android manifest).
	SystemApkMetadata_SYSTEM_STUB SystemApkMetadata_SystemApkType = 2
	// Compressed APK for system image.
	SystemApkMetadata_SYSTEM_COMPRESSED SystemApkMetadata_SystemApkType = 3
)

// Enum value maps for SystemApkMetadata_SystemApkType.
var (
	SystemApkMetadata_SystemApkType_name = map[int32]string{
		0: "UNSPECIFIED_VALUE",
		1: "SYSTEM",
		2: "SYSTEM_STUB",
		3: "SYSTEM_COMPRESSED",
	}
	SystemApkMetadata_SystemApkType_value = map[string]int32{
		"UNSPECIFIED_VALUE": 0,
		"SYSTEM":            1,
		"SYSTEM_STUB":       2,
		"SYSTEM_COMPRESSED": 3,
	}
)

func (x SystemApkMetadata_SystemApkType) Enum() *SystemApkMetadata_SystemApkType {
	p := new(SystemApkMetadata_SystemApkType)
	*p = x
	return p
}

func (x SystemApkMetadata_SystemApkType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SystemApkMetadata_SystemApkType) Descriptor() protoreflect.EnumDescriptor {
	return file_commands_proto_enumTypes[1].Descriptor()
}

func (SystemApkMetadata_SystemApkType) Type() protoreflect.EnumType {
	return &file_commands_proto_enumTypes[1]
}

func (x SystemApkMetadata_SystemApkType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SystemApkMetadata_SystemApkType.Descriptor instead.
func (SystemApkMetadata_SystemApkType) EnumDescriptor() ([]byte, []int) {
	return file_commands_proto_rawDescGZIP(), []int{10, 0}
}

// Describes the output of the "build-apks" command.
type BuildApksResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The package name of this app.
	PackageName string `protobuf:"bytes,4,opt,name=package_name,json=packageName,proto3" json:"package_name,omitempty"`
	// List of the created variants.
	Variant []*Variant `protobuf:"bytes,1,rep,name=variant,proto3" json:"variant,omitempty"`
	// Metadata about BundleTool used to build the APKs.
	Bundletool *Bundletool `protobuf:"bytes,2,opt,name=bundletool,proto3" json:"bundletool,omitempty"`
	// List of the created asset slices.
	AssetSliceSet []*AssetSliceSet `protobuf:"bytes,3,rep,name=asset_slice_set,json=assetSliceSet,proto3" json:"asset_slice_set,omitempty"`
	// Information about local testing mode.
	LocalTestingInfo *LocalTestingInfo `protobuf:"bytes,5,opt,name=local_testing_info,json=localTestingInfo,proto3" json:"local_testing_info,omitempty"`
}

func (x *BuildApksResult) Reset() {
	*x = BuildApksResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BuildApksResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BuildApksResult) ProtoMessage() {}

func (x *BuildApksResult) ProtoReflect() protoreflect.Message {
	mi := &file_commands_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BuildApksResult.ProtoReflect.Descriptor instead.
func (*BuildApksResult) Descriptor() ([]byte, []int) {
	return file_commands_proto_rawDescGZIP(), []int{0}
}

func (x *BuildApksResult) GetPackageName() string {
	if x != nil {
		return x.PackageName
	}
	return ""
}

func (x *BuildApksResult) GetVariant() []*Variant {
	if x != nil {
		return x.Variant
	}
	return nil
}

func (x *BuildApksResult) GetBundletool() *Bundletool {
	if x != nil {
		return x.Bundletool
	}
	return nil
}

func (x *BuildApksResult) GetAssetSliceSet() []*AssetSliceSet {
	if x != nil {
		return x.AssetSliceSet
	}
	return nil
}

func (x *BuildApksResult) GetLocalTestingInfo() *LocalTestingInfo {
	if x != nil {
		return x.LocalTestingInfo
	}
	return nil
}

// Variant is a group of APKs that covers a part of the device configuration
// space. APKs from multiple variants are never combined on one device.
type Variant struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Variant-level targeting.
	// This targeting is fairly high-level and each APK has its own targeting as
	// well.
	Targeting *VariantTargeting `protobuf:"bytes,1,opt,name=targeting,proto3" json:"targeting,omitempty"`
	// Set of APKs, one set per module.
	ApkSet []*ApkSet `protobuf:"bytes,2,rep,name=apk_set,json=apkSet,proto3" json:"apk_set,omitempty"`
	// Number of the variant, starting at 0 (unless overridden).
	// A device will receive APKs from the first variant that matches the device
	// configuration, with higher variant numbers having priority over lower
	// variant numbers.
	VariantNumber uint32 `protobuf:"varint,3,opt,name=variant_number,json=variantNumber,proto3" json:"variant_number,omitempty"`
}

func (x *Variant) Reset() {
	*x = Variant{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Variant) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Variant) ProtoMessage() {}

func (x *Variant) ProtoReflect() protoreflect.Message {
	mi := &file_commands_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Variant.ProtoReflect.Descriptor instead.
func (*Variant) Descriptor() ([]byte, []int) {
	return file_commands_proto_rawDescGZIP(), []int{1}
}

func (x *Variant) GetTargeting() *VariantTargeting {
	if x != nil {
		return x.Targeting
	}
	return nil
}

func (x *Variant) GetApkSet() []*ApkSet {
	if x != nil {
		return x.ApkSet
	}
	return nil
}

func (x *Variant) GetVariantNumber() uint32 {
	if x != nil {
		return x.VariantNumber
	}
	return 0
}

// Represents a module.
// For pre-L devices multiple modules (possibly all) may be merged into one.
type ApkSet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ModuleMetadata *ModuleMetadata `protobuf:"bytes,1,opt,name=module_metadata,json=moduleMetadata,proto3" json:"module_metadata,omitempty"`
	// APKs.
	ApkDescription []*ApkDescription `protobuf:"bytes,2,rep,name=apk_description,json=apkDescription,proto3" json:"apk_description,omitempty"`
}

func (x *ApkSet) Reset() {
	*x = ApkSet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApkSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApkSet) ProtoMessage() {}

func (x *ApkSet) ProtoReflect() protoreflect.Message {
	mi := &file_commands_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApkSet.ProtoReflect.Descriptor instead.
func (*ApkSet) Descriptor() ([]byte, []int) {
	return file_commands_proto_rawDescGZIP(), []int{2}
}

func (x *ApkSet) GetModuleMetadata() *ModuleMetadata {
	if x != nil {
		return x.ModuleMetadata
	}
	return nil
}

func (x *ApkSet) GetApkDescription() []*ApkDescription {
	if x != nil {
		return x.ApkDescription
	}
	return nil
}

type ModuleMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Module name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Indicates the delivery type (e.g. on-demand) of the module.
	DeliveryType DeliveryType `protobuf:"varint,6,opt,name=delivery_type,json=deliveryType,proto3,enum=android.bundle.DeliveryType" json:"delivery_type,omitempty"`
	// Indicates whether this module is marked "instant".
	IsInstant bool `protobuf:"varint,3,opt,name=is_instant,json=isInstant,proto3" json:"is_instant,omitempty"`
	// Names of the modules that this module directly depends on.
	// Each module implicitly depends on the base module.
	Dependencies []string `protobuf:"bytes,4,rep,name=dependencies,proto3" json:"dependencies,omitempty"`
	// The targeting that makes a conditional module installed.
	// Relevant only for Split APKs.
	Targeting *ModuleTargeting `protobuf:"bytes,5,opt,name=targeting,proto3" json:"targeting,omitempty"`
	// Deprecated. Please use delivery_type.
	//
	// Deprecated: Do not use.
	OnDemandDeprecated bool `protobuf:"varint,2,opt,name=on_demand_deprecated,json=onDemandDeprecated,proto3" json:"on_demand_deprecated,omitempty"`
}

func (x *ModuleMetadata) Reset() {
	*x = ModuleMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModuleMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModuleMetadata) ProtoMessage() {}

func (x *ModuleMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_commands_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModuleMetadata.ProtoReflect.Descriptor instead.
func (*ModuleMetadata) Descriptor() ([]byte, []int) {
	return file_commands_proto_rawDescGZIP(), []int{3}
}

func (x *ModuleMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ModuleMetadata) GetDeliveryType() DeliveryType {
	if x != nil {
		return x.DeliveryType
	}
	return DeliveryType_UNKNOWN_DELIVERY_TYPE
}

func (x *ModuleMetadata) GetIsInstant() bool {
	if x != nil {
		return x.IsInstant
	}
	return false
}

func (x *ModuleMetadata) GetDependencies() []string {
	if x != nil {
		return x.Dependencies
	}
	return nil
}

func (x *ModuleMetadata) GetTargeting() *ModuleTargeting {
	if x != nil {
		return x.Targeting
	}
	return nil
}

// Deprecated: Do not use.
func (x *ModuleMetadata) GetOnDemandDeprecated() bool {
	if x != nil {
		return x.OnDemandDeprecated
	}
	return false
}

// Set of asset slices belonging to a single asset module.
type AssetSliceSet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Module level metadata.
	AssetModuleMetadata *AssetModuleMetadata `protobuf:"bytes,1,opt,name=asset_module_metadata,json=assetModuleMetadata,proto3" json:"asset_module_metadata,omitempty"`
	// Asset slices.
	ApkDescription []*ApkDescription `protobuf:"bytes,2,rep,name=apk_description,json=apkDescription,proto3" json:"apk_description,omitempty"`
}

func (x *AssetSliceSet) Reset() {
	*x = AssetSliceSet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AssetSliceSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AssetSliceSet) ProtoMessage() {}

func (x *AssetSliceSet) ProtoReflect() protoreflect.Message {
	mi := &file_commands_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AssetSliceSet.ProtoReflect.Descriptor instead.
func (*AssetSliceSet) Descriptor() ([]byte, []int) {
	return file_commands_proto_rawDescGZIP(), []int{4}
}

func (x *AssetSliceSet) GetAssetModuleMetadata() *AssetModuleMetadata {
	if x != nil {
		return x.AssetModuleMetadata
	}
	return nil
}

func (x *AssetSliceSet) GetApkDescription() []*ApkDescription {
	if x != nil {
		return x.ApkDescription
	}
	return nil
}

type AssetModuleMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Module name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Indicates the delivery type for persistent install.
	DeliveryType DeliveryType `protobuf:"varint,4,opt,name=delivery_type,json=deliveryType,proto3,enum=android.bundle.DeliveryType" json:"delivery_type,omitempty"`
	// Metadata for instant installs.
	InstantMetadata *InstantMetadata `protobuf:"bytes,3,opt,name=instant_metadata,json=instantMetadata,proto3" json:"instant_metadata,omitempty"`
	// Deprecated. Use delivery_type.
	//
	// Deprecated: Do not use.
	OnDemandDeprecated bool `protobuf:"varint,2,opt,name=on_demand_deprecated,json=onDemandDeprecated,proto3" json:"on_demand_deprecated,omitempty"`
}

func (x *AssetModuleMetadata) Reset() {
	*x = AssetModuleMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AssetModuleMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AssetModuleMetadata) ProtoMessage() {}

func (x *AssetModuleMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_commands_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AssetModuleMetadata.ProtoReflect.Descriptor instead.
func (*AssetModuleMetadata) Descriptor() ([]byte, []int) {
	return file_commands_proto_rawDescGZIP(), []int{5}
}

func (x *AssetModuleMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AssetModuleMetadata) GetDeliveryType() DeliveryType {
	if x != nil {
		return x.DeliveryType
	}
	return DeliveryType_UNKNOWN_DELIVERY_TYPE
}

func (x *AssetModuleMetadata) GetInstantMetadata() *InstantMetadata {
	if x != nil {
		return x.InstantMetadata
	}
	return nil
}

// Deprecated: Do not use.
func (x *AssetModuleMetadata) GetOnDemandDeprecated() bool {
	if x != nil {
		return x.OnDemandDeprecated
	}
	return false
}

type InstantMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates whether this module is marked "instant".
	IsInstant bool `protobuf:"varint,1,opt,name=is_instant,json=isInstant,proto3" json:"is_instant,omitempty"`
	// Indicates the delivery type for instant install.
	DeliveryType DeliveryType `protobuf:"varint,3,opt,name=delivery_type,json=deliveryType,proto3,enum=android.bundle.DeliveryType" json:"delivery_type,omitempty"`
	// Deprecated. Use delivery_type.
	//
	// Deprecated: Do not use.
	OnDemandDeprecated bool `protobuf:"varint,2,opt,name=on_demand_deprecated,json=onDemandDeprecated,proto3" json:"on_demand_deprecated,omitempty"`
}

func (x *InstantMetadata) Reset() {
	*x = InstantMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstantMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstantMetadata) ProtoMessage() {}

func (x *InstantMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_commands_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstantMetadata.ProtoReflect.Descriptor instead.
func (*InstantMetadata) Descriptor() ([]byte, []int) {
	return file_commands_proto_rawDescGZIP(), []int{6}
}

func (x *InstantMetadata) GetIsInstant() bool {
	if x != nil {
		return x.IsInstant
	}
	return false
}

func (x *InstantMetadata) GetDeliveryType() DeliveryType {
	if x != nil {
		return x.DeliveryType
	}
	return DeliveryType_UNKNOWN_DELIVERY_TYPE
}

// Deprecated: Do not use.
func (x *InstantMetadata) GetOnDemandDeprecated() bool {
	if x != nil {
		return x.OnDemandDeprecated
	}
	return false
}

type ApkDescription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Targeting *ApkTargeting `protobuf:"bytes,1,opt,name=targeting,proto3" json:"targeting,omitempty"`
	// Path to the APK file.
	// BEGIN-INTERNAL
	// The path may be a blobkey if the proto is not constructed by bundletool.
	// END-INTERNAL
	Path string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	// Types that are assignable to ApkMetadataOneofValue:
	//	*ApkDescription_SplitApkMetadata
	//	*ApkDescription_StandaloneApkMetadata
	//	*ApkDescription_InstantApkMetadata
	//	*ApkDescription_SystemApkMetadata
	//	*ApkDescription_AssetSliceMetadata
	//	*ApkDescription_ApexApkMetadata
	ApkMetadataOneofValue isApkDescription_ApkMetadataOneofValue `protobuf_oneof:"apk_metadata_oneof_value"`
}

func (x *ApkDescription) Reset() {
	*x = ApkDescription{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApkDescription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApkDescription) ProtoMessage() {}

func (x *ApkDescription) ProtoReflect() protoreflect.Message {
	mi := &file_commands_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApkDescription.ProtoReflect.Descriptor instead.
func (*ApkDescription) Descriptor() ([]byte, []int) {
	return file_commands_proto_rawDescGZIP(), []int{7}
}

func (x *ApkDescription) GetTargeting() *ApkTargeting {
	if x != nil {
		return x.Targeting
	}
	return nil
}

func (x *ApkDescription) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (m *ApkDescription) GetApkMetadataOneofValue() isApkDescription_ApkMetadataOneofValue {
	if m != nil {
		return m.ApkMetadataOneofValue
	}
	return nil
}

func (x *ApkDescription) GetSplitApkMetadata() *SplitApkMetadata {
	if x, ok := x.GetApkMetadataOneofValue().(*ApkDescription_SplitApkMetadata); ok {
		return x.SplitApkMetadata
	}
	return nil
}

func (x *ApkDescription) GetStandaloneApkMetadata() *StandaloneApkMetadata {
	if x, ok := x.GetApkMetadataOneofValue().(*ApkDescription_StandaloneApkMetadata); ok {
		return x.StandaloneApkMetadata
	}
	return nil
}

func (x *ApkDescription) GetInstantApkMetadata() *SplitApkMetadata {
	if x, ok := x.GetApkMetadataOneofValue().(*ApkDescription_InstantApkMetadata); ok {
		return x.InstantApkMetadata
	}
	return nil
}

func (x *ApkDescription) GetSystemApkMetadata() *SystemApkMetadata {
	if x, ok := x.GetApkMetadataOneofValue().(*ApkDescription_SystemApkMetadata); ok {
		return x.SystemApkMetadata
	}
	return nil
}

func (x *ApkDescription) GetAssetSliceMetadata() *SplitApkMetadata {
	if x, ok := x.GetApkMetadataOneofValue().(*ApkDescription_AssetSliceMetadata); ok {
		return x.AssetSliceMetadata
	}
	return nil
}

func (x *ApkDescription) GetApexApkMetadata() *ApexApkMetadata {
	if x, ok := x.GetApkMetadataOneofValue().(*ApkDescription_ApexApkMetadata); ok {
		return x.ApexApkMetadata
	}
	return nil
}

type isApkDescription_ApkMetadataOneofValue interface {
	isApkDescription_ApkMetadataOneofValue()
}

type ApkDescription_SplitApkMetadata struct {
	// Set only for Split APKs.
	SplitApkMetadata *SplitApkMetadata `protobuf:"bytes,3,opt,name=split_apk_metadata,json=splitApkMetadata,proto3,oneof"`
}

type ApkDescription_StandaloneApkMetadata struct {
	// Set only for standalone APKs.
	StandaloneApkMetadata *StandaloneApkMetadata `protobuf:"bytes,4,opt,name=standalone_apk_metadata,json=standaloneApkMetadata,proto3,oneof"`
}

type ApkDescription_InstantApkMetadata struct {
	// Set only for Instant split APKs.
	InstantApkMetadata *SplitApkMetadata `protobuf:"bytes,5,opt,name=instant_apk_metadata,json=instantApkMetadata,proto3,oneof"`
}

type ApkDescription_SystemApkMetadata struct {
	// Set only for system APKs.
	SystemApkMetadata *SystemApkMetadata `protobuf:"bytes,6,opt,name=system_apk_metadata,json=systemApkMetadata,proto3,oneof"`
}

type ApkDescription_AssetSliceMetadata struct {
	// Set only for asset slices.
	AssetSliceMetadata *SplitApkMetadata `protobuf:"bytes,7,opt,name=asset_slice_metadata,json=assetSliceMetadata,proto3,oneof"`
}

type ApkDescription_ApexApkMetadata struct {
	// Set only for APEX APKs.
	ApexApkMetadata *ApexApkMetadata `protobuf:"bytes,8,opt,name=apex_apk_metadata,json=apexApkMetadata,proto3,oneof"`
}

func (*ApkDescription_SplitApkMetadata) isApkDescription_ApkMetadataOneofValue() {}

func (*ApkDescription_StandaloneApkMetadata) isApkDescription_ApkMetadataOneofValue() {}

func (*ApkDescription_InstantApkMetadata) isApkDescription_ApkMetadataOneofValue() {}

func (*ApkDescription_SystemApkMetadata) isApkDescription_ApkMetadataOneofValue() {}

func (*ApkDescription_AssetSliceMetadata) isApkDescription_ApkMetadataOneofValue() {}

func (*ApkDescription_ApexApkMetadata) isApkDescription_ApkMetadataOneofValue() {}

// Holds data specific to Split APKs.
type SplitApkMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SplitId string `protobuf:"bytes,1,opt,name=split_id,json=splitId,proto3" json:"split_id,omitempty"`
	// Indicates whether this APK is the master split of the module.
	IsMasterSplit bool `protobuf:"varint,2,opt,name=is_master_split,json=isMasterSplit,proto3" json:"is_master_split,omitempty"`
}

func (x *SplitApkMetadata) Reset() {
	*x = SplitApkMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SplitApkMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SplitApkMetadata) ProtoMessage() {}

func (x *SplitApkMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_commands_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SplitApkMetadata.ProtoReflect.Descriptor instead.
func (*SplitApkMetadata) Descriptor() ([]byte, []int) {
	return file_commands_proto_rawDescGZIP(), []int{8}
}

func (x *SplitApkMetadata) GetSplitId() string {
	if x != nil {
		return x.SplitId
	}
	return ""
}

func (x *SplitApkMetadata) GetIsMasterSplit() bool {
	if x != nil {
		return x.IsMasterSplit
	}
	return false
}

// Holds data specific to Standalone APKs.
type StandaloneApkMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Names of the modules fused in this standalone APK.
	FusedModuleName []string `protobuf:"bytes,1,rep,name=fused_module_name,json=fusedModuleName,proto3" json:"fused_module_name,omitempty"`
}

func (x *StandaloneApkMetadata) Reset() {
	*x = StandaloneApkMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StandaloneApkMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StandaloneApkMetadata) ProtoMessage() {}

func (x *StandaloneApkMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_commands_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StandaloneApkMetadata.ProtoReflect.Descriptor instead.
func (*StandaloneApkMetadata) Descriptor() ([]byte, []int) {
	return file_commands_proto_rawDescGZIP(), []int{9}
}

func (x *StandaloneApkMetadata) GetFusedModuleName() []string {
	if x != nil {
		return x.FusedModuleName
	}
	return nil
}

// Holds data specific to system APKs.
type SystemApkMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Names of the modules fused in this system APK.
	FusedModuleName []string `protobuf:"bytes,1,rep,name=fused_module_name,json=fusedModuleName,proto3" json:"fused_module_name,omitempty"`
	// Indicates whether the APK is uncompressed system APK, stub APK or
	// compressed system APK.
	SystemApkType SystemApkMetadata_SystemApkType `protobuf:"varint,2,opt,name=system_apk_type,json=systemApkType,proto3,enum=android.bundle.SystemApkMetadata_SystemApkType" json:"system_apk_type,omitempty"`
}

func (x *SystemApkMetadata) Reset() {
	*x = SystemApkMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SystemApkMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SystemApkMetadata) ProtoMessage() {}

func (x *SystemApkMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_commands_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SystemApkMetadata.ProtoReflect.Descriptor instead.
func (*SystemApkMetadata) Descriptor() ([]byte, []int) {
	return file_commands_proto_rawDescGZIP(), []int{10}
}

func (x *SystemApkMetadata) GetFusedModuleName() []string {
	if x != nil {
		return x.FusedModuleName
	}
	return nil
}

func (x *SystemApkMetadata) GetSystemApkType() SystemApkMetadata_SystemApkType {
	if x != nil {
		return x.SystemApkType
	}
	return SystemApkMetadata_UNSPECIFIED_VALUE
}

// Holds data specific to APEX APKs.
type ApexApkMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for processing of APKs embedded in an APEX image.
	ApexEmbeddedApkConfig []*ApexEmbeddedApkConfig `protobuf:"bytes,1,rep,name=apex_embedded_apk_config,json=apexEmbeddedApkConfig,proto3" json:"apex_embedded_apk_config,omitempty"`
}

func (x *ApexApkMetadata) Reset() {
	*x = ApexApkMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApexApkMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApexApkMetadata) ProtoMessage() {}

func (x *ApexApkMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_commands_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApexApkMetadata.ProtoReflect.Descriptor instead.
func (*ApexApkMetadata) Descriptor() ([]byte, []int) {
	return file_commands_proto_rawDescGZIP(), []int{11}
}

func (x *ApexApkMetadata) GetApexEmbeddedApkConfig() []*ApexEmbeddedApkConfig {
	if x != nil {
		return x.ApexEmbeddedApkConfig
	}
	return nil
}

type LocalTestingInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates if the bundle is built in local testing mode.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// The local testing path, as specified in the base manifest.
	// This refers to the relative path on the external directory of the app where
	// APKs will be pushed for local testing.
	// Set only if local testing is enabled.
	LocalTestingPath string `protobuf:"bytes,2,opt,name=local_testing_path,json=localTestingPath,proto3" json:"local_testing_path,omitempty"`
}

func (x *LocalTestingInfo) Reset() {
	*x = LocalTestingInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LocalTestingInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocalTestingInfo) ProtoMessage() {}

func (x *LocalTestingInfo) ProtoReflect() protoreflect.Message {
	mi := &file_commands_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocalTestingInfo.ProtoReflect.Descriptor instead.
func (*LocalTestingInfo) Descriptor() ([]byte, []int) {
	return file_commands_proto_rawDescGZIP(), []int{12}
}

func (x *LocalTestingInfo) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *LocalTestingInfo) GetLocalTestingPath() string {
	if x != nil {
		return x.LocalTestingPath
	}
	return ""
}

var File_commands_proto protoreflect.FileDescriptor

var file_commands_proto_rawDesc = []byte{
	0x0a, 0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x0e, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65,
	0x1a, 0x0c, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x0f,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0xba, 0x02, 0x0a, 0x0f, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x41, 0x70, 0x6b, 0x73, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x31, 0x0a, 0x07, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69,
	0x64, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74,
	0x52, 0x07, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x12, 0x3a, 0x0a, 0x0a, 0x62, 0x75, 0x6e,
	0x64, 0x6c, 0x65, 0x74, 0x6f, 0x6f, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x42,
	0x75, 0x6e, 0x64, 0x6c, 0x65, 0x74, 0x6f, 0x6f, 0x6c, 0x52, 0x0a, 0x62, 0x75, 0x6e, 0x64, 0x6c,
	0x65, 0x74, 0x6f, 0x6f, 0x6c, 0x12, 0x45, 0x0a, 0x0f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x73,
	0x6c, 0x69, 0x63, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d,
	0x2e, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e,
	0x41, 0x73, 0x73, 0x65, 0x74, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x53, 0x65, 0x74, 0x52, 0x0d, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x53, 0x65, 0x74, 0x12, 0x4e, 0x0a, 0x12,
	0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x6e,
	0x66, 0x6f, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x61, 0x6e, 0x64, 0x72, 0x6f,
	0x69, 0x64, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x54,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x10, 0x6c, 0x6f, 0x63, 0x61,
	0x6c, 0x54, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0xa1, 0x01, 0x0a,
	0x07, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x12, 0x3e, 0x0a, 0x09, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x61, 0x6e,
	0x64, 0x72, 0x6f, 0x69, 0x64, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x56, 0x61, 0x72,
	0x69, 0x61, 0x6e, 0x74, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x09, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x2f, 0x0a, 0x07, 0x61, 0x70, 0x6b, 0x5f,
	0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x61, 0x6e, 0x64, 0x72,
	0x6f, 0x69, 0x64, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x41, 0x70, 0x6b, 0x53, 0x65,
	0x74, 0x52, 0x06, 0x61, 0x70, 0x6b, 0x53, 0x65, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x76, 0x61, 0x72,
	0x69, 0x61, 0x6e, 0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x0d, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72,
	0x22, 0x9a, 0x01, 0x0a, 0x06, 0x41, 0x70, 0x6b, 0x53, 0x65, 0x74, 0x12, 0x47, 0x0a, 0x0f, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2e, 0x62,
	0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x52, 0x0e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x47, 0x0a, 0x0f, 0x61, 0x70, 0x6b, 0x5f, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e,
	0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x41,
	0x70, 0x6b, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x61,
	0x70, 0x6b, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9f, 0x02,
	0x0a, 0x0e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x41, 0x0a, 0x0d, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1c, 0x2e, 0x61, 0x6e,
	0x64, 0x72, 0x6f, 0x69, 0x64, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x44, 0x65, 0x6c,
	0x69, 0x76, 0x65, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c, 0x64, 0x65, 0x6c, 0x69, 0x76,
	0x65, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x73, 0x5f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x69, 0x73, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0c, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64,
	0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x64, 0x65,
	0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x12, 0x3d, 0x0a, 0x09, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e,
	0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x4d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x09,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x34, 0x0a, 0x14, 0x6f, 0x6e, 0x5f,
	0x64, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x02, 0x18, 0x01, 0x52, 0x12, 0x6f, 0x6e, 0x44,
	0x65, 0x6d, 0x61, 0x6e, 0x64, 0x44, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x22,
	0xb1, 0x01, 0x0a, 0x0d, 0x41, 0x73, 0x73, 0x65, 0x74, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x53, 0x65,
	0x74, 0x12, 0x57, 0x0a, 0x15, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x23, 0x2e, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c,
	0x65, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x13, 0x61, 0x73, 0x73, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x47, 0x0a, 0x0f, 0x61, 0x70,
	0x6b, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2e, 0x62, 0x75,
	0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x41, 0x70, 0x6b, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x61, 0x70, 0x6b, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0xee, 0x01, 0x0a, 0x13, 0x41, 0x73, 0x73, 0x65, 0x74, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x41, 0x0a, 0x0d, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1c, 0x2e, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64,
	0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x0c, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x4a, 0x0a, 0x10, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x5f, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x61,
	0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x34,
	0x0a, 0x14, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x70, 0x72,
	0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x02, 0x18, 0x01,
	0x52, 0x12, 0x6f, 0x6e, 0x44, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x44, 0x65, 0x70, 0x72, 0x65, 0x63,
	0x61, 0x74, 0x65, 0x64, 0x22, 0xa9, 0x01, 0x0a, 0x0f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x73, 0x5f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x69, 0x73,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x12, 0x41, 0x0a, 0x0d, 0x64, 0x65, 0x6c, 0x69, 0x76,
	0x65, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1c,
	0x2e, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e,
	0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c, 0x64, 0x65,
	0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x34, 0x0a, 0x14, 0x6f, 0x6e,
	0x5f, 0x64, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74,
	0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x02, 0x18, 0x01, 0x52, 0x12, 0x6f, 0x6e,
	0x44, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x44, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64,
	0x22, 0xff, 0x04, 0x0a, 0x0e, 0x41, 0x70, 0x6b, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x3a, 0x0a, 0x09, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x69, 0x6e, 0x67,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64,
	0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x41, 0x70, 0x6b, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x69, 0x6e, 0x67, 0x52, 0x09, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x12,
	0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70,
	0x61, 0x74, 0x68, 0x12, 0x50, 0x0a, 0x12, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x5f, 0x61, 0x70, 0x6b,
	0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x20, 0x2e, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65,
	0x2e, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x41, 0x70, 0x6b, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x48, 0x00, 0x52, 0x10, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x41, 0x70, 0x6b, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5f, 0x0a, 0x17, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x6c,
	0x6f, 0x6e, 0x65, 0x5f, 0x61, 0x70, 0x6b, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64,
	0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x6c, 0x6f,
	0x6e, 0x65, 0x41, 0x70, 0x6b, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52,
	0x15, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x6c, 0x6f, 0x6e, 0x65, 0x41, 0x70, 0x6b, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x54, 0x0a, 0x14, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x74, 0x5f, 0x61, 0x70, 0x6b, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2e, 0x62,
	0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x41, 0x70, 0x6b, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x12, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x74, 0x41, 0x70, 0x6b, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x53, 0x0a, 0x13,
	0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x61, 0x70, 0x6b, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x61, 0x6e, 0x64, 0x72,
	0x6f, 0x69, 0x64, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x53, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x41, 0x70, 0x6b, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x11,
	0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x41, 0x70, 0x6b, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x54, 0x0a, 0x14, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x73, 0x6c, 0x69, 0x63, 0x65,
	0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x20, 0x2e, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65,
	0x2e, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x41, 0x70, 0x6b, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x48, 0x00, 0x52, 0x12, 0x61, 0x73, 0x73, 0x65, 0x74, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x4d, 0x0a, 0x11, 0x61, 0x70, 0x65, 0x78, 0x5f,
	0x61, 0x70, 0x6b, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2e, 0x62, 0x75, 0x6e,
	0x64, 0x6c, 0x65, 0x2e, 0x41, 0x70, 0x65, 0x78, 0x41, 0x70, 0x6b, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x0f, 0x61, 0x70, 0x65, 0x78, 0x41, 0x70, 0x6b, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x1a, 0x0a, 0x18, 0x61, 0x70, 0x6b, 0x5f, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x6f, 0x6e, 0x65, 0x6f, 0x66, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x22, 0x55, 0x0a, 0x10, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x41, 0x70, 0x6b, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x19, 0x0a, 0x08, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x49,
	0x64, 0x12, 0x26, 0x0a, 0x0f, 0x69, 0x73, 0x5f, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x73,
	0x70, 0x6c, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x69, 0x73, 0x4d, 0x61,
	0x73, 0x74, 0x65, 0x72, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x22, 0x49, 0x0a, 0x15, 0x53, 0x74, 0x61,
	0x6e, 0x64, 0x61, 0x6c, 0x6f, 0x6e, 0x65, 0x41, 0x70, 0x6b, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x2a, 0x0a, 0x11, 0x66, 0x75, 0x73, 0x65, 0x64, 0x5f, 0x6d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x66,
	0x75, 0x73, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x4a, 0x04,
	0x08, 0x02, 0x10, 0x03, 0x22, 0xf4, 0x01, 0x0a, 0x11, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x41,
	0x70, 0x6b, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x2a, 0x0a, 0x11, 0x66, 0x75,
	0x73, 0x65, 0x64, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x66, 0x75, 0x73, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x57, 0x0a, 0x0f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x5f, 0x61, 0x70, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2f, 0x2e, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65,
	0x2e, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x41, 0x70, 0x6b, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x41, 0x70, 0x6b, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x0d, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x41, 0x70, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x22,
	0x5a, 0x0a, 0x0d, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x41, 0x70, 0x6b, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x15, 0x0a, 0x11, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x5f,
	0x56, 0x41, 0x4c, 0x55, 0x45, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x59, 0x53, 0x54, 0x45,
	0x4d, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x53, 0x59, 0x53, 0x54, 0x45, 0x4d, 0x5f, 0x53, 0x54,
	0x55, 0x42, 0x10, 0x02, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x59, 0x53, 0x54, 0x45, 0x4d, 0x5f, 0x43,
	0x4f, 0x4d, 0x50, 0x52, 0x45, 0x53, 0x53, 0x45, 0x44, 0x10, 0x03, 0x22, 0x71, 0x0a, 0x0f, 0x41,
	0x70, 0x65, 0x78, 0x41, 0x70, 0x6b, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5e,
	0x0a, 0x18, 0x61, 0x70, 0x65, 0x78, 0x5f, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f,
	0x61, 0x70, 0x6b, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c,
	0x65, 0x2e, 0x41, 0x70, 0x65, 0x78, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x41, 0x70,
	0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x15, 0x61, 0x70, 0x65, 0x78, 0x45, 0x6d, 0x62,
	0x65, 0x64, 0x64, 0x65, 0x64, 0x41, 0x70, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x5a,
	0x0a, 0x10, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x54, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x2c, 0x0a, 0x12,
	0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x61,
	0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x54,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x61, 0x74, 0x68, 0x2a, 0x5b, 0x0a, 0x0c, 0x44, 0x65,
	0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x55, 0x4e,
	0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x44, 0x45, 0x4c, 0x49, 0x56, 0x45, 0x52, 0x59, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4c, 0x4c,
	0x5f, 0x54, 0x49, 0x4d, 0x45, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x4f, 0x4e, 0x5f, 0x44, 0x45,
	0x4d, 0x41, 0x4e, 0x44, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x46, 0x41, 0x53, 0x54, 0x5f, 0x46,
	0x4f, 0x4c, 0x4c, 0x4f, 0x57, 0x10, 0x03, 0x42, 0x41, 0x0a, 0x12, 0x63, 0x6f, 0x6d, 0x2e, 0x61,
	0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x5a, 0x2b, 0x61,
	0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2f, 0x73, 0x6f, 0x6f, 0x6e, 0x67, 0x2f, 0x63, 0x6d, 0x64,
	0x2f, 0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x5f, 0x61, 0x70, 0x6b, 0x73, 0x2f, 0x62, 0x75,
	0x6e, 0x64, 0x6c, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_commands_proto_rawDescOnce sync.Once
	file_commands_proto_rawDescData = file_commands_proto_rawDesc
)

func file_commands_proto_rawDescGZIP() []byte {
	file_commands_proto_rawDescOnce.Do(func() {
		file_commands_proto_rawDescData = protoimpl.X.CompressGZIP(file_commands_proto_rawDescData)
	})
	return file_commands_proto_rawDescData
}

var file_commands_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_commands_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_commands_proto_goTypes = []interface{}{
	(DeliveryType)(0),                    // 0: android.bundle.DeliveryType
	(SystemApkMetadata_SystemApkType)(0), // 1: android.bundle.SystemApkMetadata.SystemApkType
	(*BuildApksResult)(nil),              // 2: android.bundle.BuildApksResult
	(*Variant)(nil),                      // 3: android.bundle.Variant
	(*ApkSet)(nil),                       // 4: android.bundle.ApkSet
	(*ModuleMetadata)(nil),               // 5: android.bundle.ModuleMetadata
	(*AssetSliceSet)(nil),                // 6: android.bundle.AssetSliceSet
	(*AssetModuleMetadata)(nil),          // 7: android.bundle.AssetModuleMetadata
	(*InstantMetadata)(nil),              // 8: android.bundle.InstantMetadata
	(*ApkDescription)(nil),               // 9: android.bundle.ApkDescription
	(*SplitApkMetadata)(nil),             // 10: android.bundle.SplitApkMetadata
	(*StandaloneApkMetadata)(nil),        // 11: android.bundle.StandaloneApkMetadata
	(*SystemApkMetadata)(nil),            // 12: android.bundle.SystemApkMetadata
	(*ApexApkMetadata)(nil),              // 13: android.bundle.ApexApkMetadata
	(*LocalTestingInfo)(nil),             // 14: android.bundle.LocalTestingInfo
	(*Bundletool)(nil),                   // 15: android.bundle.Bundletool
	(*VariantTargeting)(nil),             // 16: android.bundle.VariantTargeting
	(*ModuleTargeting)(nil),              // 17: android.bundle.ModuleTargeting
	(*ApkTargeting)(nil),                 // 18: android.bundle.ApkTargeting
	(*ApexEmbeddedApkConfig)(nil),        // 19: android.bundle.ApexEmbeddedApkConfig
}
var file_commands_proto_depIdxs = []int32{
	3,  // 0: android.bundle.BuildApksResult.variant:type_name -> android.bundle.Variant
	15, // 1: android.bundle.BuildApksResult.bundletool:type_name -> android.bundle.Bundletool
	6,  // 2: android.bundle.BuildApksResult.asset_slice_set:type_name -> android.bundle.AssetSliceSet
	14, // 3: android.bundle.BuildApksResult.local_testing_info:type_name -> android.bundle.LocalTestingInfo
	16, // 4: android.bundle.Variant.targeting:type_name -> android.bundle.VariantTargeting
	4,  // 5: android.bundle.Variant.apk_set:type_name -> android.bundle.ApkSet
	5,  // 6: android.bundle.ApkSet.module_metadata:type_name -> android.bundle.ModuleMetadata
	9,  // 7: android.bundle.ApkSet.apk_description:type_name -> android.bundle.ApkDescription
	0,  // 8: android.bundle.ModuleMetadata.delivery_type:type_name -> android.bundle.DeliveryType
	17, // 9: android.bundle.ModuleMetadata.targeting:type_name -> android.bundle.ModuleTargeting
	7,  // 10: android.bundle.AssetSliceSet.asset_module_metadata:type_name -> android.bundle.AssetModuleMetadata
	9,  // 11: android.bundle.AssetSliceSet.apk_description:type_name -> android.bundle.ApkDescription
	0,  // 12: android.bundle.AssetModuleMetadata.delivery_type:type_name -> android.bundle.DeliveryType
	8,  // 13: android.bundle.AssetModuleMetadata.instant_metadata:type_name -> android.bundle.InstantMetadata
	0,  // 14: android.bundle.InstantMetadata.delivery_type:type_name -> android.bundle.DeliveryType
	18, // 15: android.bundle.ApkDescription.targeting:type_name -> android.bundle.ApkTargeting
	10, // 16: android.bundle.ApkDescription.split_apk_metadata:type_name -> android.bundle.SplitApkMetadata
	11, // 17: android.bundle.ApkDescription.standalone_apk_metadata:type_name -> android.bundle.StandaloneApkMetadata
	10, // 18: android.bundle.ApkDescription.instant_apk_metadata:type_name -> android.bundle.SplitApkMetadata
	12, // 19: android.bundle.ApkDescription.system_apk_metadata:type_name -> android.bundle.SystemApkMetadata
	10, // 20: android.bundle.ApkDescription.asset_slice_metadata:type_name -> android.bundle.SplitApkMetadata
	13, // 21: android.bundle.ApkDescription.apex_apk_metadata:type_name -> android.bundle.ApexApkMetadata
	1,  // 22: android.bundle.SystemApkMetadata.system_apk_type:type_name -> android.bundle.SystemApkMetadata.SystemApkType
	19, // 23: android.bundle.ApexApkMetadata.apex_embedded_apk_config:type_name -> android.bundle.ApexEmbeddedApkConfig
	24, // [24:24] is the sub-list for method output_type
	24, // [24:24] is the sub-list for method input_type
	24, // [24:24] is the sub-list for extension type_name
	24, // [24:24] is the sub-list for extension extendee
	0,  // [0:24] is the sub-list for field type_name
}

func init() { file_commands_proto_init() }
func file_commands_proto_init() {
	if File_commands_proto != nil {
		return
	}
	file_config_proto_init()
	file_targeting_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_commands_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BuildApksResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Variant); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApkSet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModuleMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AssetSliceSet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AssetModuleMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstantMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApkDescription); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SplitApkMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StandaloneApkMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SystemApkMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApexApkMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LocalTestingInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_commands_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*ApkDescription_SplitApkMetadata)(nil),
		(*ApkDescription_StandaloneApkMetadata)(nil),
		(*ApkDescription_InstantApkMetadata)(nil),
		(*ApkDescription_SystemApkMetadata)(nil),
		(*ApkDescription_AssetSliceMetadata)(nil),
		(*ApkDescription_ApexApkMetadata)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_commands_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_commands_proto_goTypes,
		DependencyIndexes: file_commands_proto_depIdxs,
		EnumInfos:         file_commands_proto_enumTypes,
		MessageInfos:      file_commands_proto_msgTypes,
	}.Build()
	File_commands_proto = out.File
	file_commands_proto_rawDesc = nil
	file_commands_proto_goTypes = nil
	file_commands_proto_depIdxs = nil
}
