// Copyright 2017 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v3.21.12
// source: frontend.proto

package ninja_frontend

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Status_Message_Level int32

const (
	Status_Message_INFO    Status_Message_Level = 0
	Status_Message_WARNING Status_Message_Level = 1
	Status_Message_ERROR   Status_Message_Level = 2
	Status_Message_DEBUG   Status_Message_Level = 3
)

// Enum value maps for Status_Message_Level.
var (
	Status_Message_Level_name = map[int32]string{
		0: "INFO",
		1: "WARNING",
		2: "ERROR",
		3: "DEBUG",
	}
	Status_Message_Level_value = map[string]int32{
		"INFO":    0,
		"WARNING": 1,
		"ERROR":   2,
		"DEBUG":   3,
	}
)

func (x Status_Message_Level) Enum() *Status_Message_Level {
	p := new(Status_Message_Level)
	*p = x
	return p
}

func (x Status_Message_Level) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Status_Message_Level) Descriptor() protoreflect.EnumDescriptor {
	return file_frontend_proto_enumTypes[0].Descriptor()
}

func (Status_Message_Level) Type() protoreflect.EnumType {
	return &file_frontend_proto_enumTypes[0]
}

func (x Status_Message_Level) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *Status_Message_Level) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = Status_Message_Level(num)
	return nil
}

// Deprecated: Use Status_Message_Level.Descriptor instead.
func (Status_Message_Level) EnumDescriptor() ([]byte, []int) {
	return file_frontend_proto_rawDescGZIP(), []int{0, 5, 0}
}

type Status struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TotalEdges    *Status_TotalEdges    `protobuf:"bytes,1,opt,name=total_edges,json=totalEdges" json:"total_edges,omitempty"`
	BuildStarted  *Status_BuildStarted  `protobuf:"bytes,2,opt,name=build_started,json=buildStarted" json:"build_started,omitempty"`
	BuildFinished *Status_BuildFinished `protobuf:"bytes,3,opt,name=build_finished,json=buildFinished" json:"build_finished,omitempty"`
	EdgeStarted   *Status_EdgeStarted   `protobuf:"bytes,4,opt,name=edge_started,json=edgeStarted" json:"edge_started,omitempty"`
	EdgeFinished  *Status_EdgeFinished  `protobuf:"bytes,5,opt,name=edge_finished,json=edgeFinished" json:"edge_finished,omitempty"`
	Message       *Status_Message       `protobuf:"bytes,6,opt,name=message" json:"message,omitempty"`
}

func (x *Status) Reset() {
	*x = Status{}
	if protoimpl.UnsafeEnabled {
		mi := &file_frontend_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Status) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Status) ProtoMessage() {}

func (x *Status) ProtoReflect() protoreflect.Message {
	mi := &file_frontend_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Status.ProtoReflect.Descriptor instead.
func (*Status) Descriptor() ([]byte, []int) {
	return file_frontend_proto_rawDescGZIP(), []int{0}
}

func (x *Status) GetTotalEdges() *Status_TotalEdges {
	if x != nil {
		return x.TotalEdges
	}
	return nil
}

func (x *Status) GetBuildStarted() *Status_BuildStarted {
	if x != nil {
		return x.BuildStarted
	}
	return nil
}

func (x *Status) GetBuildFinished() *Status_BuildFinished {
	if x != nil {
		return x.BuildFinished
	}
	return nil
}

func (x *Status) GetEdgeStarted() *Status_EdgeStarted {
	if x != nil {
		return x.EdgeStarted
	}
	return nil
}

func (x *Status) GetEdgeFinished() *Status_EdgeFinished {
	if x != nil {
		return x.EdgeFinished
	}
	return nil
}

func (x *Status) GetMessage() *Status_Message {
	if x != nil {
		return x.Message
	}
	return nil
}

type Status_TotalEdges struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// New value for total edges in the build.
	TotalEdges *uint32 `protobuf:"varint,1,opt,name=total_edges,json=totalEdges" json:"total_edges,omitempty"`
}

func (x *Status_TotalEdges) Reset() {
	*x = Status_TotalEdges{}
	if protoimpl.UnsafeEnabled {
		mi := &file_frontend_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Status_TotalEdges) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Status_TotalEdges) ProtoMessage() {}

func (x *Status_TotalEdges) ProtoReflect() protoreflect.Message {
	mi := &file_frontend_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Status_TotalEdges.ProtoReflect.Descriptor instead.
func (*Status_TotalEdges) Descriptor() ([]byte, []int) {
	return file_frontend_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Status_TotalEdges) GetTotalEdges() uint32 {
	if x != nil && x.TotalEdges != nil {
		return *x.TotalEdges
	}
	return 0
}

type Status_BuildStarted struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of jobs Ninja will run in parallel.
	Parallelism *uint32 `protobuf:"varint,1,opt,name=parallelism" json:"parallelism,omitempty"`
	// Verbose value passed to ninja.
	Verbose *bool `protobuf:"varint,2,opt,name=verbose" json:"verbose,omitempty"`
	// Critical path's running time in milliseconds
	CriticalPathTime *uint32 `protobuf:"varint,3,opt,name=critical_path_time,json=criticalPathTime" json:"critical_path_time,omitempty"`
	// Total running time of every need-to-build edge in milliseconds
	EstimatedTotalTime *uint32 `protobuf:"varint,4,opt,name=estimated_total_time,json=estimatedTotalTime" json:"estimated_total_time,omitempty"`
}

func (x *Status_BuildStarted) Reset() {
	*x = Status_BuildStarted{}
	if protoimpl.UnsafeEnabled {
		mi := &file_frontend_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Status_BuildStarted) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Status_BuildStarted) ProtoMessage() {}

func (x *Status_BuildStarted) ProtoReflect() protoreflect.Message {
	mi := &file_frontend_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Status_BuildStarted.ProtoReflect.Descriptor instead.
func (*Status_BuildStarted) Descriptor() ([]byte, []int) {
	return file_frontend_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Status_BuildStarted) GetParallelism() uint32 {
	if x != nil && x.Parallelism != nil {
		return *x.Parallelism
	}
	return 0
}

func (x *Status_BuildStarted) GetVerbose() bool {
	if x != nil && x.Verbose != nil {
		return *x.Verbose
	}
	return false
}

func (x *Status_BuildStarted) GetCriticalPathTime() uint32 {
	if x != nil && x.CriticalPathTime != nil {
		return *x.CriticalPathTime
	}
	return 0
}

func (x *Status_BuildStarted) GetEstimatedTotalTime() uint32 {
	if x != nil && x.EstimatedTotalTime != nil {
		return *x.EstimatedTotalTime
	}
	return 0
}

type Status_BuildFinished struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Status_BuildFinished) Reset() {
	*x = Status_BuildFinished{}
	if protoimpl.UnsafeEnabled {
		mi := &file_frontend_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Status_BuildFinished) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Status_BuildFinished) ProtoMessage() {}

func (x *Status_BuildFinished) ProtoReflect() protoreflect.Message {
	mi := &file_frontend_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Status_BuildFinished.ProtoReflect.Descriptor instead.
func (*Status_BuildFinished) Descriptor() ([]byte, []int) {
	return file_frontend_proto_rawDescGZIP(), []int{0, 2}
}

type Status_EdgeStarted struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Edge identification number, unique to a Ninja run.
	Id *uint32 `protobuf:"varint,1,opt,name=id" json:"id,omitempty"`
	// Edge start time in milliseconds since Ninja started.
	StartTime *uint32 `protobuf:"varint,2,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// List of edge inputs.
	Inputs []string `protobuf:"bytes,3,rep,name=inputs" json:"inputs,omitempty"`
	// List of edge outputs.
	Outputs []string `protobuf:"bytes,4,rep,name=outputs" json:"outputs,omitempty"`
	// Description field from the edge.
	Desc *string `protobuf:"bytes,5,opt,name=desc" json:"desc,omitempty"`
	// Command field from the edge.
	Command *string `protobuf:"bytes,6,opt,name=command" json:"command,omitempty"`
	// Edge uses console.
	Console *bool `protobuf:"varint,7,opt,name=console" json:"console,omitempty"`
}

func (x *Status_EdgeStarted) Reset() {
	*x = Status_EdgeStarted{}
	if protoimpl.UnsafeEnabled {
		mi := &file_frontend_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Status_EdgeStarted) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Status_EdgeStarted) ProtoMessage() {}

func (x *Status_EdgeStarted) ProtoReflect() protoreflect.Message {
	mi := &file_frontend_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Status_EdgeStarted.ProtoReflect.Descriptor instead.
func (*Status_EdgeStarted) Descriptor() ([]byte, []int) {
	return file_frontend_proto_rawDescGZIP(), []int{0, 3}
}

func (x *Status_EdgeStarted) GetId() uint32 {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return 0
}

func (x *Status_EdgeStarted) GetStartTime() uint32 {
	if x != nil && x.StartTime != nil {
		return *x.StartTime
	}
	return 0
}

func (x *Status_EdgeStarted) GetInputs() []string {
	if x != nil {
		return x.Inputs
	}
	return nil
}

func (x *Status_EdgeStarted) GetOutputs() []string {
	if x != nil {
		return x.Outputs
	}
	return nil
}

func (x *Status_EdgeStarted) GetDesc() string {
	if x != nil && x.Desc != nil {
		return *x.Desc
	}
	return ""
}

func (x *Status_EdgeStarted) GetCommand() string {
	if x != nil && x.Command != nil {
		return *x.Command
	}
	return ""
}

func (x *Status_EdgeStarted) GetConsole() bool {
	if x != nil && x.Console != nil {
		return *x.Console
	}
	return false
}

type Status_EdgeFinished struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Edge identification number, unique to a Ninja run.
	Id *uint32 `protobuf:"varint,1,opt,name=id" json:"id,omitempty"`
	// Edge end time in milliseconds since Ninja started.
	EndTime *uint32 `protobuf:"varint,2,opt,name=end_time,json=endTime" json:"end_time,omitempty"`
	// Exit status (0 for success).
	Status *int32 `protobuf:"zigzag32,3,opt,name=status" json:"status,omitempty"`
	// Edge output, may contain ANSI codes.
	Output *string `protobuf:"bytes,4,opt,name=output" json:"output,omitempty"`
	// Number of milliseconds spent executing in user mode
	UserTime *uint32 `protobuf:"varint,5,opt,name=user_time,json=userTime" json:"user_time,omitempty"`
	// Number of milliseconds spent executing in kernel mode
	SystemTime *uint32 `protobuf:"varint,6,opt,name=system_time,json=systemTime" json:"system_time,omitempty"`
	// Max resident set size in kB
	MaxRssKb *uint64 `protobuf:"varint,7,opt,name=max_rss_kb,json=maxRssKb" json:"max_rss_kb,omitempty"`
	// Minor page faults
	MinorPageFaults *uint64 `protobuf:"varint,8,opt,name=minor_page_faults,json=minorPageFaults" json:"minor_page_faults,omitempty"`
	// Major page faults
	MajorPageFaults *uint64 `protobuf:"varint,9,opt,name=major_page_faults,json=majorPageFaults" json:"major_page_faults,omitempty"`
	// IO input in kB
	IoInputKb *uint64 `protobuf:"varint,10,opt,name=io_input_kb,json=ioInputKb" json:"io_input_kb,omitempty"`
	// IO output in kB
	IoOutputKb *uint64 `protobuf:"varint,11,opt,name=io_output_kb,json=ioOutputKb" json:"io_output_kb,omitempty"`
	// Voluntary context switches
	VoluntaryContextSwitches *uint64 `protobuf:"varint,12,opt,name=voluntary_context_switches,json=voluntaryContextSwitches" json:"voluntary_context_switches,omitempty"`
	// Involuntary context switches
	InvoluntaryContextSwitches *uint64 `protobuf:"varint,13,opt,name=involuntary_context_switches,json=involuntaryContextSwitches" json:"involuntary_context_switches,omitempty"`
	// Arbitrary tags for build system profiling (module names and types, rule
	// names, etc). Format of the string is implementation defined.
	Tags *string `protobuf:"bytes,14,opt,name=tags" json:"tags,omitempty"`
}

func (x *Status_EdgeFinished) Reset() {
	*x = Status_EdgeFinished{}
	if protoimpl.UnsafeEnabled {
		mi := &file_frontend_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Status_EdgeFinished) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Status_EdgeFinished) ProtoMessage() {}

func (x *Status_EdgeFinished) ProtoReflect() protoreflect.Message {
	mi := &file_frontend_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Status_EdgeFinished.ProtoReflect.Descriptor instead.
func (*Status_EdgeFinished) Descriptor() ([]byte, []int) {
	return file_frontend_proto_rawDescGZIP(), []int{0, 4}
}

func (x *Status_EdgeFinished) GetId() uint32 {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return 0
}

func (x *Status_EdgeFinished) GetEndTime() uint32 {
	if x != nil && x.EndTime != nil {
		return *x.EndTime
	}
	return 0
}

func (x *Status_EdgeFinished) GetStatus() int32 {
	if x != nil && x.Status != nil {
		return *x.Status
	}
	return 0
}

func (x *Status_EdgeFinished) GetOutput() string {
	if x != nil && x.Output != nil {
		return *x.Output
	}
	return ""
}

func (x *Status_EdgeFinished) GetUserTime() uint32 {
	if x != nil && x.UserTime != nil {
		return *x.UserTime
	}
	return 0
}

func (x *Status_EdgeFinished) GetSystemTime() uint32 {
	if x != nil && x.SystemTime != nil {
		return *x.SystemTime
	}
	return 0
}

func (x *Status_EdgeFinished) GetMaxRssKb() uint64 {
	if x != nil && x.MaxRssKb != nil {
		return *x.MaxRssKb
	}
	return 0
}

func (x *Status_EdgeFinished) GetMinorPageFaults() uint64 {
	if x != nil && x.MinorPageFaults != nil {
		return *x.MinorPageFaults
	}
	return 0
}

func (x *Status_EdgeFinished) GetMajorPageFaults() uint64 {
	if x != nil && x.MajorPageFaults != nil {
		return *x.MajorPageFaults
	}
	return 0
}

func (x *Status_EdgeFinished) GetIoInputKb() uint64 {
	if x != nil && x.IoInputKb != nil {
		return *x.IoInputKb
	}
	return 0
}

func (x *Status_EdgeFinished) GetIoOutputKb() uint64 {
	if x != nil && x.IoOutputKb != nil {
		return *x.IoOutputKb
	}
	return 0
}

func (x *Status_EdgeFinished) GetVoluntaryContextSwitches() uint64 {
	if x != nil && x.VoluntaryContextSwitches != nil {
		return *x.VoluntaryContextSwitches
	}
	return 0
}

func (x *Status_EdgeFinished) GetInvoluntaryContextSwitches() uint64 {
	if x != nil && x.InvoluntaryContextSwitches != nil {
		return *x.InvoluntaryContextSwitches
	}
	return 0
}

func (x *Status_EdgeFinished) GetTags() string {
	if x != nil && x.Tags != nil {
		return *x.Tags
	}
	return ""
}

type Status_Message struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Message priority level (DEBUG, INFO, WARNING, ERROR).
	Level *Status_Message_Level `protobuf:"varint,1,opt,name=level,enum=ninja.Status_Message_Level,def=0" json:"level,omitempty"`
	// Info/warning/error message from Ninja.
	Message *string `protobuf:"bytes,2,opt,name=message" json:"message,omitempty"`
}

// Default values for Status_Message fields.
const (
	Default_Status_Message_Level = Status_Message_INFO
)

func (x *Status_Message) Reset() {
	*x = Status_Message{}
	if protoimpl.UnsafeEnabled {
		mi := &file_frontend_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Status_Message) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Status_Message) ProtoMessage() {}

func (x *Status_Message) ProtoReflect() protoreflect.Message {
	mi := &file_frontend_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Status_Message.ProtoReflect.Descriptor instead.
func (*Status_Message) Descriptor() ([]byte, []int) {
	return file_frontend_proto_rawDescGZIP(), []int{0, 5}
}

func (x *Status_Message) GetLevel() Status_Message_Level {
	if x != nil && x.Level != nil {
		return *x.Level
	}
	return Default_Status_Message_Level
}

func (x *Status_Message) GetMessage() string {
	if x != nil && x.Message != nil {
		return *x.Message
	}
	return ""
}

var File_frontend_proto protoreflect.FileDescriptor

var file_frontend_proto_rawDesc = []byte{
	0x0a, 0x0e, 0x66, 0x72, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x05, 0x6e, 0x69, 0x6e, 0x6a, 0x61, 0x22, 0xa9, 0x0b, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x12, 0x39, 0x0a, 0x0b, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x65, 0x64, 0x67, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x6e, 0x69, 0x6e, 0x6a, 0x61, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x45, 0x64, 0x67, 0x65,
	0x73, 0x52, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x45, 0x64, 0x67, 0x65, 0x73, 0x12, 0x3f, 0x0a,
	0x0d, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x6e, 0x69, 0x6e, 0x6a, 0x61, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x53, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64,
	0x52, 0x0c, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x53, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x12, 0x42,
	0x0a, 0x0e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x66, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6e, 0x69, 0x6e, 0x6a, 0x61, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x46, 0x69, 0x6e, 0x69, 0x73,
	0x68, 0x65, 0x64, 0x52, 0x0d, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68,
	0x65, 0x64, 0x12, 0x3c, 0x0a, 0x0c, 0x65, 0x64, 0x67, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x6e, 0x69, 0x6e, 0x6a, 0x61,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x45, 0x64, 0x67, 0x65, 0x53, 0x74, 0x61, 0x72,
	0x74, 0x65, 0x64, 0x52, 0x0b, 0x65, 0x64, 0x67, 0x65, 0x53, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64,
	0x12, 0x3f, 0x0a, 0x0d, 0x65, 0x64, 0x67, 0x65, 0x5f, 0x66, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65,
	0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x6e, 0x69, 0x6e, 0x6a, 0x61, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x45, 0x64, 0x67, 0x65, 0x46, 0x69, 0x6e, 0x69, 0x73,
	0x68, 0x65, 0x64, 0x52, 0x0c, 0x65, 0x64, 0x67, 0x65, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65,
	0x64, 0x12, 0x2f, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x15, 0x2e, 0x6e, 0x69, 0x6e, 0x6a, 0x61, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x1a, 0x2d, 0x0a, 0x0a, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x45, 0x64, 0x67, 0x65, 0x73,
	0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x65, 0x64, 0x67, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x45, 0x64, 0x67, 0x65,
	0x73, 0x1a, 0xaa, 0x01, 0x0a, 0x0c, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x53, 0x74, 0x61, 0x72, 0x74,
	0x65, 0x64, 0x12, 0x20, 0x0a, 0x0b, 0x70, 0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x69, 0x73,
	0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x70, 0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65,
	0x6c, 0x69, 0x73, 0x6d, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x62, 0x6f, 0x73, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x76, 0x65, 0x72, 0x62, 0x6f, 0x73, 0x65, 0x12, 0x2c,
	0x0a, 0x12, 0x63, 0x72, 0x69, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x10, 0x63, 0x72, 0x69, 0x74,
	0x69, 0x63, 0x61, 0x6c, 0x50, 0x61, 0x74, 0x68, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x30, 0x0a, 0x14,
	0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x12, 0x65, 0x73, 0x74, 0x69,
	0x6d, 0x61, 0x74, 0x65, 0x64, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x0f,
	0x0a, 0x0d, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x1a,
	0xb6, 0x01, 0x0a, 0x0b, 0x45, 0x64, 0x67, 0x65, 0x53, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x12,
	0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x02, 0x69, 0x64, 0x12,
	0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x16,
	0x0a, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73,
	0x12, 0x12, 0x0a, 0x04, 0x64, 0x65, 0x73, 0x63, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x64, 0x65, 0x73, 0x63, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x18,
	0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x73, 0x6f, 0x6c, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x07, 0x63, 0x6f, 0x6e, 0x73, 0x6f, 0x6c, 0x65, 0x1a, 0xf3, 0x03, 0x0a, 0x0c, 0x45, 0x64, 0x67,
	0x65, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x02, 0x69, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x65, 0x6e, 0x64,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x65, 0x6e, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x11, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x16, 0x0a, 0x06,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x0a, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x73, 0x73, 0x5f, 0x6b, 0x62,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08, 0x6d, 0x61, 0x78, 0x52, 0x73, 0x73, 0x4b, 0x62,
	0x12, 0x2a, 0x0a, 0x11, 0x6d, 0x69, 0x6e, 0x6f, 0x72, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0f, 0x6d, 0x69, 0x6e,
	0x6f, 0x72, 0x50, 0x61, 0x67, 0x65, 0x46, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x2a, 0x0a, 0x11,
	0x6d, 0x61, 0x6a, 0x6f, 0x72, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0f, 0x6d, 0x61, 0x6a, 0x6f, 0x72, 0x50, 0x61,
	0x67, 0x65, 0x46, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x1e, 0x0a, 0x0b, 0x69, 0x6f, 0x5f, 0x69,
	0x6e, 0x70, 0x75, 0x74, 0x5f, 0x6b, 0x62, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x69,
	0x6f, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x4b, 0x62, 0x12, 0x20, 0x0a, 0x0c, 0x69, 0x6f, 0x5f, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x6b, 0x62, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0a,
	0x69, 0x6f, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x4b, 0x62, 0x12, 0x3c, 0x0a, 0x1a, 0x76, 0x6f,
	0x6c, 0x75, 0x6e, 0x74, 0x61, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f,
	0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x65, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x04, 0x52, 0x18,
	0x76, 0x6f, 0x6c, 0x75, 0x6e, 0x74, 0x61, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x53, 0x77, 0x69, 0x74, 0x63, 0x68, 0x65, 0x73, 0x12, 0x40, 0x0a, 0x1c, 0x69, 0x6e, 0x76, 0x6f,
	0x6c, 0x75, 0x6e, 0x74, 0x61, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f,
	0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x65, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x04, 0x52, 0x1a,
	0x69, 0x6e, 0x76, 0x6f, 0x6c, 0x75, 0x6e, 0x74, 0x61, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x53, 0x77, 0x69, 0x74, 0x63, 0x68, 0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x61,
	0x67, 0x73, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x1a, 0x92,
	0x01, 0x0a, 0x07, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x37, 0x0a, 0x05, 0x6c, 0x65,
	0x76, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1b, 0x2e, 0x6e, 0x69, 0x6e, 0x6a,
	0x61, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x2e, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x3a, 0x04, 0x49, 0x4e, 0x46, 0x4f, 0x52, 0x05, 0x6c, 0x65,
	0x76, 0x65, 0x6c, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x34, 0x0a,
	0x05, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x08, 0x0a, 0x04, 0x49, 0x4e, 0x46, 0x4f, 0x10, 0x00,
	0x12, 0x0b, 0x0a, 0x07, 0x57, 0x41, 0x52, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x09, 0x0a,
	0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x44, 0x45, 0x42, 0x55,
	0x47, 0x10, 0x03, 0x42, 0x2a, 0x48, 0x03, 0x5a, 0x26, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64,
	0x2f, 0x73, 0x6f, 0x6f, 0x6e, 0x67, 0x2f, 0x75, 0x69, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x2f, 0x6e, 0x69, 0x6e, 0x6a, 0x61, 0x5f, 0x66, 0x72, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x64,
}

var (
	file_frontend_proto_rawDescOnce sync.Once
	file_frontend_proto_rawDescData = file_frontend_proto_rawDesc
)

func file_frontend_proto_rawDescGZIP() []byte {
	file_frontend_proto_rawDescOnce.Do(func() {
		file_frontend_proto_rawDescData = protoimpl.X.CompressGZIP(file_frontend_proto_rawDescData)
	})
	return file_frontend_proto_rawDescData
}

var file_frontend_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_frontend_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_frontend_proto_goTypes = []interface{}{
	(Status_Message_Level)(0),    // 0: ninja.Status.Message.Level
	(*Status)(nil),               // 1: ninja.Status
	(*Status_TotalEdges)(nil),    // 2: ninja.Status.TotalEdges
	(*Status_BuildStarted)(nil),  // 3: ninja.Status.BuildStarted
	(*Status_BuildFinished)(nil), // 4: ninja.Status.BuildFinished
	(*Status_EdgeStarted)(nil),   // 5: ninja.Status.EdgeStarted
	(*Status_EdgeFinished)(nil),  // 6: ninja.Status.EdgeFinished
	(*Status_Message)(nil),       // 7: ninja.Status.Message
}
var file_frontend_proto_depIdxs = []int32{
	2, // 0: ninja.Status.total_edges:type_name -> ninja.Status.TotalEdges
	3, // 1: ninja.Status.build_started:type_name -> ninja.Status.BuildStarted
	4, // 2: ninja.Status.build_finished:type_name -> ninja.Status.BuildFinished
	5, // 3: ninja.Status.edge_started:type_name -> ninja.Status.EdgeStarted
	6, // 4: ninja.Status.edge_finished:type_name -> ninja.Status.EdgeFinished
	7, // 5: ninja.Status.message:type_name -> ninja.Status.Message
	0, // 6: ninja.Status.Message.level:type_name -> ninja.Status.Message.Level
	7, // [7:7] is the sub-list for method output_type
	7, // [7:7] is the sub-list for method input_type
	7, // [7:7] is the sub-list for extension type_name
	7, // [7:7] is the sub-list for extension extendee
	0, // [0:7] is the sub-list for field type_name
}

func init() { file_frontend_proto_init() }
func file_frontend_proto_init() {
	if File_frontend_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_frontend_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Status); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_frontend_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Status_TotalEdges); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_frontend_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Status_BuildStarted); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_frontend_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Status_BuildFinished); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_frontend_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Status_EdgeStarted); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_frontend_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Status_EdgeFinished); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_frontend_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Status_Message); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_frontend_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_frontend_proto_goTypes,
		DependencyIndexes: file_frontend_proto_depIdxs,
		EnumInfos:         file_frontend_proto_enumTypes,
		MessageInfos:      file_frontend_proto_msgTypes,
	}.Build()
	File_frontend_proto = out.File
	file_frontend_proto_rawDesc = nil
	file_frontend_proto_goTypes = nil
	file_frontend_proto_depIdxs = nil
}
