// Copyright 2022 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v3.9.1
// source: symbols_map.proto

package symbols_map_proto

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Type is the valid types of a mapping.
type Mapping_Type int32

const (
	// ELF denotes a mapping from an elf build ID to an unstripped elf file.
	Mapping_ELF Mapping_Type = 0
	// R8 denotes a mapping from an R8 dictionary hash to an R8 dictionary.
	Mapping_R8 Mapping_Type = 1
)

// Enum value maps for Mapping_Type.
var (
	Mapping_Type_name = map[int32]string{
		0: "ELF",
		1: "R8",
	}
	Mapping_Type_value = map[string]int32{
		"ELF": 0,
		"R8":  1,
	}
)

func (x Mapping_Type) Enum() *Mapping_Type {
	p := new(Mapping_Type)
	*p = x
	return p
}

func (x Mapping_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Mapping_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_symbols_map_proto_enumTypes[0].Descriptor()
}

func (Mapping_Type) Type() protoreflect.EnumType {
	return &file_symbols_map_proto_enumTypes[0]
}

func (x Mapping_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *Mapping_Type) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = Mapping_Type(num)
	return nil
}

// Deprecated: Use Mapping_Type.Descriptor instead.
func (Mapping_Type) EnumDescriptor() ([]byte, []int) {
	return file_symbols_map_proto_rawDescGZIP(), []int{0, 0}
}

type Mapping struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// identifier is a unique identifier of a location, generally the hash of the file.  For an
	// elf file it is the elf build ID, for an R8 dictionary it is the hash from the comments in the
	// top of the file.  It may be empty if no hash could be extracted from the file.
	Identifier *string `protobuf:"bytes,1,opt,name=identifier" json:"identifier,omitempty"`
	// location is the path to the file with the given identifier.  The location should be valid
	// both on the local disk and in the distributed symbols.zip or proguard_dict.zip files.
	Location *string `protobuf:"bytes,2,opt,name=location" json:"location,omitempty"`
	// type is the type of the mapping, either ELF or R8.
	Type *Mapping_Type `protobuf:"varint,3,opt,name=type,enum=symbols_map.Mapping_Type" json:"type,omitempty"`
}

func (x *Mapping) Reset() {
	*x = Mapping{}
	if protoimpl.UnsafeEnabled {
		mi := &file_symbols_map_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mapping) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mapping) ProtoMessage() {}

func (x *Mapping) ProtoReflect() protoreflect.Message {
	mi := &file_symbols_map_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mapping.ProtoReflect.Descriptor instead.
func (*Mapping) Descriptor() ([]byte, []int) {
	return file_symbols_map_proto_rawDescGZIP(), []int{0}
}

func (x *Mapping) GetIdentifier() string {
	if x != nil && x.Identifier != nil {
		return *x.Identifier
	}
	return ""
}

func (x *Mapping) GetLocation() string {
	if x != nil && x.Location != nil {
		return *x.Location
	}
	return ""
}

func (x *Mapping) GetType() Mapping_Type {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return Mapping_ELF
}

type Mappings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Mappings []*Mapping `protobuf:"bytes,4,rep,name=mappings" json:"mappings,omitempty"`
}

func (x *Mappings) Reset() {
	*x = Mappings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_symbols_map_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mappings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mappings) ProtoMessage() {}

func (x *Mappings) ProtoReflect() protoreflect.Message {
	mi := &file_symbols_map_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mappings.ProtoReflect.Descriptor instead.
func (*Mappings) Descriptor() ([]byte, []int) {
	return file_symbols_map_proto_rawDescGZIP(), []int{1}
}

func (x *Mappings) GetMappings() []*Mapping {
	if x != nil {
		return x.Mappings
	}
	return nil
}

var File_symbols_map_proto protoreflect.FileDescriptor

var file_symbols_map_proto_rawDesc = []byte{
	0x0a, 0x11, 0x73, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x73, 0x5f, 0x6d, 0x61, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x0b, 0x73, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x73, 0x5f, 0x6d, 0x61, 0x70,
	0x22, 0x8d, 0x01, 0x0a, 0x07, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x1e, 0x0a, 0x0a,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x12, 0x1a, 0x0a, 0x08,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2d, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x19, 0x2e, 0x73, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x73,
	0x5f, 0x6d, 0x61, 0x70, 0x2e, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x17, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x07, 0x0a, 0x03, 0x45, 0x4c, 0x46, 0x10, 0x00, 0x12, 0x06, 0x0a, 0x02, 0x52, 0x38, 0x10, 0x01,
	0x22, 0x3c, 0x0a, 0x08, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x30, 0x0a, 0x08,
	0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14,
	0x2e, 0x73, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x73, 0x5f, 0x6d, 0x61, 0x70, 0x2e, 0x4d, 0x61, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x52, 0x08, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x31,
	0x5a, 0x2f, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2f, 0x73, 0x6f, 0x6f, 0x6e, 0x67, 0x2f,
	0x63, 0x6d, 0x64, 0x2f, 0x73, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x73, 0x5f, 0x6d, 0x61, 0x70, 0x2f,
	0x73, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x73, 0x5f, 0x6d, 0x61, 0x70, 0x5f, 0x70, 0x72, 0x6f, 0x74,
	0x6f,
}

var (
	file_symbols_map_proto_rawDescOnce sync.Once
	file_symbols_map_proto_rawDescData = file_symbols_map_proto_rawDesc
)

func file_symbols_map_proto_rawDescGZIP() []byte {
	file_symbols_map_proto_rawDescOnce.Do(func() {
		file_symbols_map_proto_rawDescData = protoimpl.X.CompressGZIP(file_symbols_map_proto_rawDescData)
	})
	return file_symbols_map_proto_rawDescData
}

var file_symbols_map_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_symbols_map_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_symbols_map_proto_goTypes = []interface{}{
	(Mapping_Type)(0), // 0: symbols_map.Mapping.Type
	(*Mapping)(nil),   // 1: symbols_map.Mapping
	(*Mappings)(nil),  // 2: symbols_map.Mappings
}
var file_symbols_map_proto_depIdxs = []int32{
	0, // 0: symbols_map.Mapping.type:type_name -> symbols_map.Mapping.Type
	1, // 1: symbols_map.Mappings.mappings:type_name -> symbols_map.Mapping
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_symbols_map_proto_init() }
func file_symbols_map_proto_init() {
	if File_symbols_map_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_symbols_map_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Mapping); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_symbols_map_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Mappings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_symbols_map_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_symbols_map_proto_goTypes,
		DependencyIndexes: file_symbols_map_proto_depIdxs,
		EnumInfos:         file_symbols_map_proto_enumTypes,
		MessageInfos:      file_symbols_map_proto_msgTypes,
	}.Build()
	File_symbols_map_proto = out.File
	file_symbols_map_proto_rawDesc = nil
	file_symbols_map_proto_goTypes = nil
	file_symbols_map_proto_depIdxs = nil
}
