# Checks that some critical dexpreopt output files are installed.

# Inputs:
# DISABLE_DEXPREOPT_CHECK: True if the check should be disabled.
# PRODUCT_PACKAGES: The list of packages to be installed for the product.
# ALL_DEFAULT_INSTALLED_MODULES: The full list of modules going to be installed.
# DEXPREOPT_SYSTEMSERVER_ARTIFACTS: The list of compilation artifacts of system server jars, which
# 	is generated by Soong in dexpreopt_check.go.

ifneq (true,$(DISABLE_DEXPREOPT_CHECK))
  # Skip the check if the system server is not installed for the product.
  ifneq (,$(filter services,$(PRODUCT_PACKAGES)))
    $(call maybe-print-list-and-error,\
      $(filter-out $(ALL_DEFAULT_INSTALLED_MODULES),$(DEXPREOPT_SYSTEMSERVER_ARTIFACTS)),\
      Missing compilation artifacts. Dexpreopting is not working for some system server jars. See \
      https://cs.android.com/android/platform/superproject/+/master:build/make/core/tasks/README.dex_preopt_check.md \
    )
  endif
endif
