/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

static data_1_1_t<float, float> g_coshf_intel_data[] = {
  { // Entry 0
    0x1.2ae06100e62be904fdb5bc85681d5aaep11,
    -0x1.0f1fb2p3
  },
  { // Entry 1
    0x1.2ae06100e62be904fdb5bc85681d5aaep11,
    0x1.0f1fb2p3
  },
  { // Entry 2
    0x1.0000000000000000000c87785d6188p0,
    -0x1.405f90p-38
  },
  { // Entry 3
    0x1.0000000000000000000c87785d6188p0,
    0x1.405f90p-38
  },
  { // Entry 4
    0x1.4f1fe6fffd055403a0afa5f61f7ad456p122,
    -0x1.561b10p6
  },
  { // Entry 5
    0x1.4f1fe6fffd055403a0afa5f61f7ad456p122,
    0x1.561b10p6
  },
  { // Entry 6
    0x1.d2f2227ae4dd65b581071b0f40467c30p122,
    -0x1.576ebcp6
  },
  { // Entry 7
    0x1.d2f2227ae4dd65b581071b0f40467c30p122,
    0x1.576ebcp6
  },
  { // Entry 8
    0x1.936b41047c7f4ef20acbfc3ab28adde1p7,
    -0x1.7fff80p2
  },
  { // Entry 9
    0x1.936b41047c7f4ef20acbfc3ab28adde1p7,
    0x1.7fff80p2
  },
  { // Entry 10
    0x1.0000017f58437ac57be86eaf878afddap0,
    -0x1.bb06ccp-12
  },
  { // Entry 11
    0x1.0000017f58437ac57be86eaf878afddap0,
    0x1.bb06ccp-12
  },
  { // Entry 12
    0x1.fbacf4ca702a97945d7c7d78c0bdad47p8,
    -0x1.bb1240p2
  },
  { // Entry 13
    0x1.fbacf4ca702a97945d7c7d78c0bdad47p8,
    0x1.bb1240p2
  },
  { // Entry 14
    0x1.0000017fb2c9b9e288983fa06ce62b04p0,
    -0x1.bb3b18p-12
  },
  { // Entry 15
    0x1.0000017fb2c9b9e288983fa06ce62b04p0,
    0x1.bb3b18p-12
  },
  { // Entry 16
    0x1.0000070003551fecea0dae6d0551de10p0,
    -0x1.deef12p-11
  },
  { // Entry 17
    0x1.0000070003551fecea0dae6d0551de10p0,
    0x1.deef12p-11
  },
  { // Entry 18
    0x1.01fe2b000874d8917b3a73fd080542f7p0,
    -0x1.fec090p-4
  },
  { // Entry 19
    0x1.01fe2b000874d8917b3a73fd080542f7p0,
    0x1.fec090p-4
  },
  { // Entry 20
    0x1.0000000000200000000000aaaaaaaaaap0,
    0x1.p-21
  },
  { // Entry 21
    0x1.0000000000200000000000aaaaaaaaaap0,
    -0x1.p-21
  },
  { // Entry 22
    0x1.p0,
    0x1.p-149
  },
  { // Entry 23
    0x1.p0,
    -0x1.p-149
  },
  { // Entry 24
    0x1.0000000000000000000020000080p0,
    0x1.000002p-41
  },
  { // Entry 25
    0x1.0000000000000000000020000080p0,
    -0x1.000002p-41
  },
  { // Entry 26
    0x1.749f1f059aafac3e3ae482f732034f99p10,
    0x1.00000ap3
  },
  { // Entry 27
    0x1.749f1f059aafac3e3ae482f732034f99p10,
    -0x1.00000ap3
  },
  { // Entry 28
    0x1.080ab13efd4e998566b0693a9a7731a8p0,
    0x1.00000ep-2
  },
  { // Entry 29
    0x1.080ab13efd4e998566b0693a9a7731a8p0,
    -0x1.00000ep-2
  },
  { // Entry 30
    0x1.0200ab01986c25f1377dd85169c7ccf5p0,
    0x1.000010p-3
  },
  { // Entry 31
    0x1.0200ab01986c25f1377dd85169c7ccf5p0,
    -0x1.000010p-3
  },
  { // Entry 32
    0x1.e190fd0d6db8db09b5aad2f89bb2ad76p1,
    0x1.000060p1
  },
  { // Entry 33
    0x1.e190fd0d6db8db09b5aad2f89bb2ad76p1,
    -0x1.000060p1
  },
  { // Entry 34
    0x1.b4f4eaff04f265d5f55aecad94412877p4,
    0x1.0000f0p2
  },
  { // Entry 35
    0x1.b4f4eaff04f265d5f55aecad94412877p4,
    -0x1.0000f0p2
  },
  { // Entry 36
    0x1.76112f028a8233c6be52ddd0d11dd50fp10,
    0x1.001fc2p3
  },
  { // Entry 37
    0x1.76112f028a8233c6be52ddd0d11dd50fp10,
    -0x1.001fc2p3
  },
  { // Entry 38
    0x1.e203bf2a6f104d990d9610afb6c8b014p1,
    0x1.0020p1
  },
  { // Entry 39
    0x1.e203bf2a6f104d990d9610afb6c8b014p1,
    -0x1.0020p1
  },
  { // Entry 40
    0x1.080cc501591cc669c4cc8cd1a5891727p0,
    0x1.0020f0p-2
  },
  { // Entry 41
    0x1.080cc501591cc669c4cc8cd1a5891727p0,
    -0x1.0020f0p-2
  },
  { // Entry 42
    0x1.7d15790923fc59b8d7d10a8c5d3adc48p10,
    0x1.00b8p3
  },
  { // Entry 43
    0x1.7d15790923fc59b8d7d10a8c5d3adc48p10,
    -0x1.00b8p3
  },
  { // Entry 44
    0x1.00818500020c06cedbd38d34eee6ab54p0,
    0x1.0179p-4
  },
  { // Entry 45
    0x1.00818500020c06cedbd38d34eee6ab54p0,
    -0x1.0179p-4
  },
  { // Entry 46
    0x1.8d17e7030b8e9690e01964bd2c8be94bp0,
    0x1.01bfc2p0
  },
  { // Entry 47
    0x1.8d17e7030b8e9690e01964bd2c8be94bp0,
    -0x1.01bfc2p0
  },
  { // Entry 48
    0x1.8e34430073e0e9199e68ad3bca9ed793p10,
    0x1.0220p3
  },
  { // Entry 49
    0x1.8e34430073e0e9199e68ad3bca9ed793p10,
    -0x1.0220p3
  },
  { // Entry 50
    0x1.93dc630008b669187e515dc7aa42f486p0,
    0x1.0760p0
  },
  { // Entry 51
    0x1.93dc630008b669187e515dc7aa42f486p0,
    -0x1.0760p0
  },
  { // Entry 52
    0x1.bf1abedb9fcde794ba793b6b505eb17bp22,
    0x1.08p4
  },
  { // Entry 53
    0x1.bf1abedb9fcde794ba793b6b505eb17bp22,
    -0x1.08p4
  },
  { // Entry 54
    0x1.89acdf26f99012ec527c5ea1162aa095p46,
    0x1.0810eep5
  },
  { // Entry 55
    0x1.89acdf26f99012ec527c5ea1162aa095p46,
    -0x1.0810eep5
  },
  { // Entry 56
    0x1.9506d202339691daa92242c890d53037p0,
    0x1.0854p0
  },
  { // Entry 57
    0x1.9506d202339691daa92242c890d53037p0,
    -0x1.0854p0
  },
  { // Entry 58
    0x1.97a75b0008810be285110dcff331ac17p0,
    0x1.0a759cp0
  },
  { // Entry 59
    0x1.97a75b0008810be285110dcff331ac17p0,
    -0x1.0a759cp0
  },
  { // Entry 60
    0x1.a229dffff61e1494787d29ddf23b0a5cp0,
    0x1.12c4p0
  },
  { // Entry 61
    0x1.a229dffff61e1494787d29ddf23b0a5cp0,
    -0x1.12c4p0
  },
  { // Entry 62
    0x1.a308650a09916a1f65dd2e3040dac8e6p0,
    0x1.1370p0
  },
  { // Entry 63
    0x1.a308650a09916a1f65dd2e3040dac8e6p0,
    -0x1.1370p0
  },
  { // Entry 64
    0x1.af7c88b59f8cb90273d971210f9ebaf1p0,
    0x1.1cd4p0
  },
  { // Entry 65
    0x1.af7c88b59f8cb90273d971210f9ebaf1p0,
    -0x1.1cd4p0
  },
  { // Entry 66
    0x1.b145deddd4b7287e0976b134aaea1e59p0,
    0x1.1e24p0
  },
  { // Entry 67
    0x1.b145deddd4b7287e0976b134aaea1e59p0,
    -0x1.1e24p0
  },
  { // Entry 68
    0x1.000002802632eecaa00848be2e43e7e8p0,
    0x1.1e4004p-11
  },
  { // Entry 69
    0x1.000002802632eecaa00848be2e43e7e8p0,
    -0x1.1e4004p-11
  },
  { // Entry 70
    0x1.00000280ae0c9376d02c0ee2eec07b9cp0,
    0x1.1e5e62p-11
  },
  { // Entry 71
    0x1.00000280ae0c9376d02c0ee2eec07b9cp0,
    -0x1.1e5e62p-11
  },
  { // Entry 72
    0x1.000a0d419b4ad7325cced6e3df2432b7p0,
    0x1.1ef4p-6
  },
  { // Entry 73
    0x1.000a0d419b4ad7325cced6e3df2432b7p0,
    -0x1.1ef4p-6
  },
  { // Entry 74
    0x1.b267ed723f88f82136ba366db2171548p0,
    0x1.1ef8p0
  },
  { // Entry 75
    0x1.b267ed723f88f82136ba366db2171548p0,
    -0x1.1ef8p0
  },
  { // Entry 76
    0x1.d7fd050e42bfb9da524bda1b668ed20ep24,
    0x1.1f0c1cp4
  },
  { // Entry 77
    0x1.d7fd050e42bfb9da524bda1b668ed20ep24,
    -0x1.1f0c1cp4
  },
  { // Entry 78
    0x1.02b05b0000fe430b8ec0ab0008934320p0,
    0x1.2892c0p-3
  },
  { // Entry 79
    0x1.02b05b0000fe430b8ec0ab0008934320p0,
    -0x1.2892c0p-3
  },
  { // Entry 80
    0x1.b56d7b0019ebe1980a88bfc98b96f903p5,
    0x1.2c733cp2
  },
  { // Entry 81
    0x1.b56d7b0019ebe1980a88bfc98b96f903p5,
    -0x1.2c733cp2
  },
  { // Entry 82
    0x1.2dde070027e555af93bf4b3a296fe1e4p0,
    0x1.2e16d8p-1
  },
  { // Entry 83
    0x1.2dde070027e555af93bf4b3a296fe1e4p0,
    -0x1.2e16d8p-1
  },
  { // Entry 84
    0x1.0bbbe7000001e6b3b455efdab53e4ee4p0,
    0x1.34de30p-2
  },
  { // Entry 85
    0x1.0bbbe7000001e6b3b455efdab53e4ee4p0,
    -0x1.34de30p-2
  },
  { // Entry 86
    0x1.d6daeadc0aa386a2df7fee2f9b758bdbp0,
    0x1.38p0
  },
  { // Entry 87
    0x1.d6daeadc0aa386a2df7fee2f9b758bdbp0,
    -0x1.38p0
  },
  { // Entry 88
    0x1.ec7e880bf432acf0cdb3055c89eca119p0,
    0x1.459506p0
  },
  { // Entry 89
    0x1.ec7e880bf432acf0cdb3055c89eca119p0,
    -0x1.459506p0
  },
  { // Entry 90
    0x1.9a74150aa235ee7c81eb0c8a84e5756ep2,
    0x1.45cf6ap1
  },
  { // Entry 91
    0x1.9a74150aa235ee7c81eb0c8a84e5756ep2,
    -0x1.45cf6ap1
  },
  { // Entry 92
    0x1.f7c601c26a0aab07acb3aed129529860p116,
    0x1.4719c6p6
  },
  { // Entry 93
    0x1.f7c601c26a0aab07acb3aed129529860p116,
    -0x1.4719c6p6
  },
  { // Entry 94
    0x1.feb75137e73fc5511a1cdda1ce6ea73bp116,
    0x1.4727cap6
  },
  { // Entry 95
    0x1.feb75137e73fc5511a1cdda1ce6ea73bp116,
    -0x1.4727cap6
  },
  { // Entry 96
    0x1.392fe100303ac2c0f653a3ac40bb345ep0,
    0x1.5028p-1
  },
  { // Entry 97
    0x1.392fe100303ac2c0f653a3ac40bb345ep0,
    -0x1.5028p-1
  },
  { // Entry 98
    0x1.7eca310b2cc18f1b14012b1aba75d191p6,
    0x1.5046a4p2
  },
  { // Entry 99
    0x1.7eca310b2cc18f1b14012b1aba75d191p6,
    -0x1.5046a4p2
  },
  { // Entry 100
    0x1.03b968ffff0215bfacc70c1cc8cbeb01p0,
    0x1.5cea44p-3
  },
  { // Entry 101
    0x1.03b968ffff0215bfacc70c1cc8cbeb01p0,
    -0x1.5cea44p-3
  },
  { // Entry 102
    0x1.fbdabac97ac130517ca085001de97a8dp6,
    0x1.625ebcp2
  },
  { // Entry 103
    0x1.fbdabac97ac130517ca085001de97a8dp6,
    -0x1.625ebcp2
  },
  { // Entry 104
    0x1.ffe308fff60483750a8a66c93e16da96p126,
    0x1.62e3f6p6
  },
  { // Entry 105
    0x1.ffe308fff60483750a8a66c93e16da96p126,
    -0x1.62e3f6p6
  },
  { // Entry 106
    0x1.0021063836b49dcc89e4c5aab5e911d1p127,
    0x1.62e4b4p6
  },
  { // Entry 107
    0x1.0021063836b49dcc89e4c5aab5e911d1p127,
    -0x1.62e4b4p6
  },
  { // Entry 108
    0x1.03dd38ffff0116b4128076a495ccd814p0,
    0x1.636444p-3
  },
  { // Entry 109
    0x1.03dd38ffff0116b4128076a495ccd814p0,
    -0x1.636444p-3
  },
  { // Entry 110
    0x1.3887c59fb04d434e609610c148d9b8cep127,
    0x1.63b080p6
  },
  { // Entry 111
    0x1.3887c59fb04d434e609610c148d9b8cep127,
    -0x1.63b080p6
  },
  { // Entry 112
    0x1.f40a2c6c7e4eec4c0ed1fae32d255e23p127,
    0x1.6591c4p6
  },
  { // Entry 113
    0x1.f40a2c6c7e4eec4c0ed1fae32d255e23p127,
    -0x1.6591c4p6
  },
  { // Entry 114
    0x1.ff70ec400b9c2d8dee878e30b56339bep127,
    0x1.65a8dap6
  },
  { // Entry 115
    0x1.ff70ec400b9c2d8dee878e30b56339bep127,
    -0x1.65a8dap6
  },
  { // Entry 116
    0x1.00fe75ffffa2579f73eddb26932641adp0,
    0x1.68d502p-4
  },
  { // Entry 117
    0x1.00fe75ffffa2579f73eddb26932641adp0,
    -0x1.68d502p-4
  },
  { // Entry 118
    0x1.00000100034d4d82cc659ba42fd9eee7p0,
    0x1.6a0c3cp-12
  },
  { // Entry 119
    0x1.00000100034d4d82cc659ba42fd9eee7p0,
    -0x1.6a0c3cp-12
  },
  { // Entry 120
    0x1.0437b0ffff6fc3960703849d04864d19p0,
    0x1.733eaap-3
  },
  { // Entry 121
    0x1.0437b0ffff6fc3960703849d04864d19p0,
    -0x1.733eaap-3
  },
  { // Entry 122
    0x1.00045900028b76cee4330cc36105004cp0,
    0x1.797124p-7
  },
  { // Entry 123
    0x1.00045900028b76cee4330cc36105004cp0,
    -0x1.797124p-7
  },
  { // Entry 124
    0x1.11aeed0000fda977f1d894606c13127ep0,
    0x1.7a730cp-2
  },
  { // Entry 125
    0x1.11aeed0000fda977f1d894606c13127ep0,
    -0x1.7a730cp-2
  },
  { // Entry 126
    0x1.01182efffcd14b33d45c900ed03e5b8dp0,
    0x1.7a9e50p-4
  },
  { // Entry 127
    0x1.01182efffcd14b33d45c900ed03e5b8dp0,
    -0x1.7a9e50p-4
  },
  { // Entry 128
    0x1.046a6700030d4af8985007e85b4af3a7p0,
    0x1.7bd6b6p-3
  },
  { // Entry 129
    0x1.046a6700030d4af8985007e85b4af3a7p0,
    -0x1.7bd6b6p-3
  },
  { // Entry 130
    0x1.5df91cfff86f7210fa16368df0698fa9p16,
    0x1.8313eap3
  },
  { // Entry 131
    0x1.5df91cfff86f7210fa16368df0698fa9p16,
    -0x1.8313eap3
  },
  { // Entry 132
    0x1.049b050001c808a9415533afc7a84886p0,
    0x1.83e5a8p-3
  },
  { // Entry 133
    0x1.049b050001c808a9415533afc7a84886p0,
    -0x1.83e5a8p-3
  },
  { // Entry 134
    0x1.04b1a500027f89a1b0fe4148983e18a2p0,
    0x1.87970cp-3
  },
  { // Entry 135
    0x1.04b1a500027f89a1b0fe4148983e18a2p0,
    -0x1.87970cp-3
  },
  { // Entry 136
    0x1.982aa4f9d6ecf2daf29ef6311c7db8e1p16,
    0x1.88p3
  },
  { // Entry 137
    0x1.982aa4f9d6ecf2daf29ef6311c7db8e1p16,
    -0x1.88p3
  },
  { // Entry 138
    0x1.d501950e8ef23c5acbb78e6bf7a4441cp7,
    0x1.89a39ep2
  },
  { // Entry 139
    0x1.d501950e8ef23c5acbb78e6bf7a4441cp7,
    -0x1.89a39ep2
  },
  { // Entry 140
    0x1.dab77d041ed5ae09f1194336e1dfeca4p16,
    0x1.8cd558p3
  },
  { // Entry 141
    0x1.dab77d041ed5ae09f1194336e1dfeca4p16,
    -0x1.8cd558p3
  },
  { // Entry 142
    0x1.0013770002a06bda5ded556406e34a54p0,
    0x1.8f4f3ep-6
  },
  { // Entry 143
    0x1.0013770002a06bda5ded556406e34a54p0,
    -0x1.8f4f3ep-6
  },
  { // Entry 144
    0x1.014a8c000001724bcf21bcc9cd4ef647p0,
    0x1.9b3716p-4
  },
  { // Entry 145
    0x1.014a8c000001724bcf21bcc9cd4ef647p0,
    -0x1.9b3716p-4
  },
  { // Entry 146
    0x1.92c1df0aa08c8949d2dbfb61712636eap3,
    0x1.9cb164p1
  },
  { // Entry 147
    0x1.92c1df0aa08c8949d2dbfb61712636eap3,
    -0x1.9cb164p1
  },
  { // Entry 148
    0x1.5b2598fffffe38fde28ab3e6f6c93922p0,
    0x1.a4299cp-1
  },
  { // Entry 149
    0x1.5b2598fffffe38fde28ab3e6f6c93922p0,
    -0x1.a4299cp-1
  },
  { // Entry 150
    0x1.056ea5020eb4607e8800e56175b95427p0,
    0x1.a52932p-3
  },
  { // Entry 151
    0x1.056ea5020eb4607e8800e56175b95427p0,
    -0x1.a52932p-3
  },
  { // Entry 152
    0x1.16928f0000bf926291ed9efa582cceabp0,
    0x1.aaeae4p-2
  },
  { // Entry 153
    0x1.16928f0000bf926291ed9efa582cceabp0,
    -0x1.aaeae4p-2
  },
  { // Entry 154
    0x1.01731affff02859bd1fc2e3d3d5c6afcp0,
    0x1.b3b0fcp-4
  },
  { // Entry 155
    0x1.01731affff02859bd1fc2e3d3d5c6afcp0,
    -0x1.b3b0fcp-4
  },
  { // Entry 156
    0x1.fc3b5ac8614a73e8394fe9e1bf341a5dp3,
    0x1.ba8aa8p1
  },
  { // Entry 157
    0x1.fc3b5ac8614a73e8394fe9e1bf341a5dp3,
    -0x1.ba8aa8p1
  },
  { // Entry 158
    0x1.fcb698cebefbdde087f940e13637b997p3,
    0x1.baa9bep1
  },
  { // Entry 159
    0x1.fcb698cebefbdde087f940e13637b997p3,
    -0x1.baa9bep1
  },
  { // Entry 160
    0x1.0062890000000a2005177a360b8dafadp0,
    0x1.c12a50p-5
  },
  { // Entry 161
    0x1.0062890000000a2005177a360b8dafadp0,
    -0x1.c12a50p-5
  },
  { // Entry 162
    0x1.861ce90a2cd945e2796a70034a062f90p1,
    0x1.c78c2cp0
  },
  { // Entry 163
    0x1.861ce90a2cd945e2796a70034a062f90p1,
    -0x1.c78c2cp0
  },
  { // Entry 164
    0x1.0000196200326194f36f87a9a10954bcp0,
    0x1.c7fffep-10
  },
  { // Entry 165
    0x1.0000196200326194f36f87a9a10954bcp0,
    -0x1.c7fffep-10
  },
  { // Entry 166
    0x1.1a6044ffff019be7fe431534c1e1e91cp0,
    0x1.ccef52p-2
  },
  { // Entry 167
    0x1.1a6044ffff019be7fe431534c1e1e91cp0,
    -0x1.ccef52p-2
  },
  { // Entry 168
    0x1.908de10afd9f5aa0badc075a8aa14ccfp1,
    0x1.ceb1c0p0
  },
  { // Entry 169
    0x1.908de10afd9f5aa0badc075a8aa14ccfp1,
    -0x1.ceb1c0p0
  },
  { // Entry 170
    0x1.a060ab08be7164a09546b5ce15970e38p1,
    0x1.d9239cp0
  },
  { // Entry 171
    0x1.a060ab08be7164a09546b5ce15970e38p1,
    -0x1.d9239cp0
  },
  { // Entry 172
    0x1.d344e10e8bcea00ac4844a3448be9a5ep9,
    0x1.e21ff0p2
  },
  { // Entry 173
    0x1.d344e10e8bcea00ac4844a3448be9a5ep9,
    -0x1.e21ff0p2
  },
  { // Entry 174
    0x1.01dbabfffffdc890992101e9e0230177p0,
    0x1.ed342ap-4
  },
  { // Entry 175
    0x1.01dbabfffffdc890992101e9e0230177p0,
    -0x1.ed342ap-4
  },
  { // Entry 176
    0x1.75caa702ac31fcaca703cb767e704732p21,
    0x1.f4169ap3
  },
  { // Entry 177
    0x1.75caa702ac31fcaca703cb767e704732p21,
    -0x1.f4169ap3
  },
  { // Entry 178
    0x1.2d11ceffa73d603eca961e07fbcd0749p89,
    0x1.f45dp5
  },
  { // Entry 179
    0x1.2d11ceffa73d603eca961e07fbcd0749p89,
    -0x1.f45dp5
  },
  { // Entry 180
    0x1.00001f0200613f54e018eaccc7690671p0,
    0x1.f7fffep-10
  },
  { // Entry 181
    0x1.00001f0200613f54e018eaccc7690671p0,
    -0x1.f7fffep-10
  },
  { // Entry 182
    0x1.fe8bfd38762490c7f68e80a4bdf3a17dp89,
    0x1.f896a2p5
  },
  { // Entry 183
    0x1.fe8bfd38762490c7f68e80a4bdf3a17dp89,
    -0x1.f896a2p5
  },
  { // Entry 184
    0x1.d6cfcac57d6baaa29de57c93e576abc5p1,
    0x1.f9fffep0
  },
  { // Entry 185
    0x1.d6cfcac57d6baaa29de57c93e576abc5p1,
    -0x1.f9fffep0
  },
  { // Entry 186
    0x1.ddbfa30e4771719e07c1da78c0971b46p1,
    0x1.fde37ep0
  },
  { // Entry 187
    0x1.ddbfa30e4771719e07c1da78c0971b46p1,
    -0x1.fde37ep0
  },
  { // Entry 188
    0x1.007f0aff9995a3000c7c95095a06f71dp0,
    0x1.fdfffep-5
  },
  { // Entry 189
    0x1.007f0aff9995a3000c7c95095a06f71dp0,
    -0x1.fdfffep-5
  },
  { // Entry 190
    0x1.207137000101ef6a6756beb0ea45b857p0,
    0x1.fe3b2ep-2
  },
  { // Entry 191
    0x1.207137000101ef6a6756beb0ea45b857p0,
    -0x1.fe3b2ep-2
  },
  { // Entry 192
    0x1.6f8f53c3ebac6dfffe8a9b6e088ac07fp10,
    0x1.ff1ffep2
  },
  { // Entry 193
    0x1.6f8f53c3ebac6dfffe8a9b6e088ac07fp10,
    -0x1.ff1ffep2
  },
  { // Entry 194
    0x1.b261741c4fb3f1036d9f845f3564af2dp4,
    0x1.ff3ffep1
  },
  { // Entry 195
    0x1.b261741c4fb3f1036d9f845f3564af2dp4,
    -0x1.ff3ffep1
  },
  { // Entry 196
    0x1.3d59d2d8b22b41c2bb6334c9be7be902p91,
    0x1.ffdffep5
  },
  { // Entry 197
    0x1.3d59d2d8b22b41c2bb6334c9be7be902p91,
    -0x1.ffdffep5
  },
  { // Entry 198
    0x1.e1559d035ec13f82913aeeb61fab20d4p1,
    0x1.ffe0p0
  },
  { // Entry 199
    0x1.e1559d035ec13f82913aeeb61fab20d4p1,
    -0x1.ffe0p0
  },
  { // Entry 200
    0x1.1f0508e3c8278fe10a2e8c9020c8176dp45,
    0x1.fffc7ep4
  },
  { // Entry 201
    0x1.1f0508e3c8278fe10a2e8c9020c8176dp45,
    -0x1.fffc7ep4
  },
  { // Entry 202
    0x1.0f13feffff8e14e72398e58d6258a1dcp22,
    0x1.fffcd8p3
  },
  { // Entry 203
    0x1.0f13feffff8e14e72398e58d6258a1dcp22,
    -0x1.fffcd8p3
  },
  { // Entry 204
    0x1.e18dcd02b202413a4a76037efe716feep1,
    0x1.fffefep0
  },
  { // Entry 205
    0x1.e18dcd02b202413a4a76037efe716feep1,
    -0x1.fffefep0
  },
  { // Entry 206
    0x1.1f3661fed887e1ea6b1c49c86e62c65cp45,
    0x1.ffff3ep4
  },
  { // Entry 207
    0x1.1f3661fed887e1ea6b1c49c86e62c65cp45,
    -0x1.ffff3ep4
  },
  { // Entry 208
    0x1.20ac14ff94619db4d2e40af1cf118f50p0,
    0x1.ffffe6p-2
  },
  { // Entry 209
    0x1.20ac14ff94619db4d2e40af1cf118f50p0,
    -0x1.ffffe6p-2
  },
  { // Entry 210
    0x1.000001fffff8aaaaad6c16d05ca5ba42p0,
    0x1.fffffcp-12
  },
  { // Entry 211
    0x1.000001fffff8aaaaad6c16d05ca5ba42p0,
    -0x1.fffffcp-12
  },
  { // Entry 212
    0x1.1c74a6ffff27037aed89be799ae87d89p0,
    0x1.de7314p-2
  },
  { // Entry 213
    0x1.1c74a6ffff27037aed89be799ae87d89p0,
    -0x1.de7314p-2
  },
  { // Entry 214
    0x1.p0,
    0.0
  },
  { // Entry 215
    0x1.00a7413964dddf629669c3500f708459p0,
    0x1.24924ap-4
  },
  { // Entry 216
    0x1.00a7413964dddf629669c3500f708459p0,
    -0x1.24924ap-4
  },
  { // Entry 217
    0x1.029ddf71e67714aabadecb6c34881466p0,
    0x1.24924ap-3
  },
  { // Entry 218
    0x1.029ddf71e67714aabadecb6c34881466p0,
    -0x1.24924ap-3
  },
  { // Entry 219
    0x1.05e66b72f920ca534e1daa0b86a4e7ebp0,
    0x1.b6db70p-3
  },
  { // Entry 220
    0x1.05e66b72f920ca534e1daa0b86a4e7ebp0,
    -0x1.b6db70p-3
  },
  { // Entry 221
    0x1.0a852f7ad288abd0695c503777bc0195p0,
    0x1.24924ap-2
  },
  { // Entry 222
    0x1.0a852f7ad288abd0695c503777bc0195p0,
    -0x1.24924ap-2
  },
  { // Entry 223
    0x1.10803510fe36a3f7c842ab6a75c8b006p0,
    0x1.6db6dcp-2
  },
  { // Entry 224
    0x1.10803510fe36a3f7c842ab6a75c8b006p0,
    -0x1.6db6dcp-2
  },
  { // Entry 225
    0x1.17df4cc2d21000190b5383b6becd7becp0,
    0x1.b6db6ep-2
  },
  { // Entry 226
    0x1.17df4cc2d21000190b5383b6becd7becp0,
    -0x1.b6db6ep-2
  },
  { // Entry 227
    0x1.20ac1862ae8d0645823a4f060800e88cp0,
    0x1.p-1
  },
  { // Entry 228
    0x1.20ac1862ae8d0645823a4f060800e88cp0,
    -0x1.p-1
  },
  { // Entry 229
    0x1.20ac1862ae8d0645823a4f060800e88cp0,
    0x1.p-1
  },
  { // Entry 230
    0x1.20ac1862ae8d0645823a4f060800e88cp0,
    -0x1.p-1
  },
  { // Entry 231
    0x1.2af217eb37e2369650003997bb02d72cp0,
    0x1.24924ap-1
  },
  { // Entry 232
    0x1.2af217eb37e2369650003997bb02d72cp0,
    -0x1.24924ap-1
  },
  { // Entry 233
    0x1.36beb7b3f8f237e48efcda7fba85def5p0,
    0x1.492494p-1
  },
  { // Entry 234
    0x1.36beb7b3f8f237e48efcda7fba85def5p0,
    -0x1.492494p-1
  },
  { // Entry 235
    0x1.442162b93f2d4967b2bac87d988998cap0,
    0x1.6db6dep-1
  },
  { // Entry 236
    0x1.442162b93f2d4967b2bac87d988998cap0,
    -0x1.6db6dep-1
  },
  { // Entry 237
    0x1.532b9688fe84749d71a9627934d00a05p0,
    0x1.924928p-1
  },
  { // Entry 238
    0x1.532b9688fe84749d71a9627934d00a05p0,
    -0x1.924928p-1
  },
  { // Entry 239
    0x1.63f0fa1d8b27abf7928a83538f1fb402p0,
    0x1.b6db72p-1
  },
  { // Entry 240
    0x1.63f0fa1d8b27abf7928a83538f1fb402p0,
    -0x1.b6db72p-1
  },
  { // Entry 241
    0x1.7687778b78c8571fbd5f4165fc052aefp0,
    0x1.db6dbcp-1
  },
  { // Entry 242
    0x1.7687778b78c8571fbd5f4165fc052aefp0,
    -0x1.db6dbcp-1
  },
  { // Entry 243
    0x1.8b07551d9f5504c2bd28100196a4f66ap0,
    0x1.p0
  },
  { // Entry 244
    0x1.8b07551d9f5504c2bd28100196a4f66ap0,
    -0x1.p0
  },
  { // Entry 245
    0x1.p0,
    0.0
  },
  { // Entry 246
    0x1.0009a148a4a36317b768fa180d3b7eb3p0,
    0x1.18de5ap-6
  },
  { // Entry 247
    0x1.0009a148a4a36317b768fa180d3b7eb3p0,
    -0x1.18de5ap-6
  },
  { // Entry 248
    0x1.002685dc0bfd9abdddd455b13ea887d9p0,
    0x1.18de5ap-5
  },
  { // Entry 249
    0x1.002685dc0bfd9abdddd455b13ea887d9p0,
    -0x1.18de5ap-5
  },
  { // Entry 250
    0x1.0056afe719b255038e559e394cf4b79ep0,
    0x1.a54d88p-5
  },
  { // Entry 251
    0x1.0056afe719b255038e559e394cf4b79ep0,
    -0x1.a54d88p-5
  },
  { // Entry 252
    0x1.009a2308369a4cbf9683178ebb9d9c79p0,
    0x1.18de5ap-4
  },
  { // Entry 253
    0x1.009a2308369a4cbf9683178ebb9d9c79p0,
    -0x1.18de5ap-4
  },
  { // Entry 254
    0x1.00f0e45304846d3a9b651810b40ff363p0,
    0x1.5f15f0p-4
  },
  { // Entry 255
    0x1.00f0e45304846d3a9b651810b40ff363p0,
    -0x1.5f15f0p-4
  },
  { // Entry 256
    0x1.015afa4e6af7cc67145b966628015d41p0,
    0x1.a54d86p-4
  },
  { // Entry 257
    0x1.015afa4e6af7cc67145b966628015d41p0,
    -0x1.a54d86p-4
  },
  { // Entry 258
    0x1.01d86cf5a15f8cd3898947526a322461p0,
    0x1.eb851cp-4
  },
  { // Entry 259
    0x1.01d86cf5a15f8cd3898947526a322461p0,
    -0x1.eb851cp-4
  },
  { // Entry 260
    0x1.01d86cf97ac630fce74cd5d5243b3b2fp0,
    0x1.eb851ep-4
  },
  { // Entry 261
    0x1.01d86cf97ac630fce74cd5d5243b3b2fp0,
    -0x1.eb851ep-4
  },
  { // Entry 262
    0x1.02068cf11e341bea4584e926b9b87a5cp0,
    0x1.01767ep-3
  },
  { // Entry 263
    0x1.02068cf11e341bea4584e926b9b87a5cp0,
    -0x1.01767ep-3
  },
  { // Entry 264
    0x1.0236d50ea15f24974c4f2f784695f8f3p0,
    0x1.0d2a6cp-3
  },
  { // Entry 265
    0x1.0236d50ea15f24974c4f2f784695f8f3p0,
    -0x1.0d2a6cp-3
  },
  { // Entry 266
    0x1.026945bd2fc314aa539bd2b0a1344e6ap0,
    0x1.18de5ap-3
  },
  { // Entry 267
    0x1.026945bd2fc314aa539bd2b0a1344e6ap0,
    -0x1.18de5ap-3
  },
  { // Entry 268
    0x1.029ddf68b9ecab97a543140ab7bc196ap0,
    0x1.249248p-3
  },
  { // Entry 269
    0x1.029ddf68b9ecab97a543140ab7bc196ap0,
    -0x1.249248p-3
  },
  { // Entry 270
    0x1.02d4a281cfc743376f69f8b9b0167a5ep0,
    0x1.304636p-3
  },
  { // Entry 271
    0x1.02d4a281cfc743376f69f8b9b0167a5ep0,
    -0x1.304636p-3
  },
  { // Entry 272
    0x1.030d8f7da18db0864f478300e780a951p0,
    0x1.3bfa24p-3
  },
  { // Entry 273
    0x1.030d8f7da18db0864f478300e780a951p0,
    -0x1.3bfa24p-3
  },
  { // Entry 274
    0x1.0348a6d600c50ac4ab832e474121e8b1p0,
    0x1.47ae12p-3
  },
  { // Entry 275
    0x1.0348a6d600c50ac4ab832e474121e8b1p0,
    -0x1.47ae12p-3
  },
  { // Entry 276
    0x1.0348a6e049689d30b2d20b0135f3fee4p0,
    0x1.47ae14p-3
  },
  { // Entry 277
    0x1.0348a6e049689d30b2d20b0135f3fee4p0,
    -0x1.47ae14p-3
  },
  { // Entry 278
    0x1.0a19d6dfd42b9ebd573de2bdeff3362ep0,
    0x1.1eb852p-2
  },
  { // Entry 279
    0x1.0a19d6dfd42b9ebd573de2bdeff3362ep0,
    -0x1.1eb852p-2
  },
  { // Entry 280
    0x1.14c128bc2baac3f4f83f16b43fc69324p0,
    0x1.99999ap-2
  },
  { // Entry 281
    0x1.14c128bc2baac3f4f83f16b43fc69324p0,
    -0x1.99999ap-2
  },
  { // Entry 282
    0x1.2365ee3fd57c998640a3796967b6c022p0,
    0x1.0a3d70p-1
  },
  { // Entry 283
    0x1.2365ee3fd57c998640a3796967b6c022p0,
    -0x1.0a3d70p-1
  },
  { // Entry 284
    0x1.363e33f5565998f1b5221773f03eea8bp0,
    0x1.47ae14p-1
  },
  { // Entry 285
    0x1.363e33f5565998f1b5221773f03eea8bp0,
    -0x1.47ae14p-1
  },
  { // Entry 286
    0x1.4d8f8734eeb43c686239fc3930bfba17p0,
    0x1.851eb8p-1
  },
  { // Entry 287
    0x1.4d8f8734eeb43c686239fc3930bfba17p0,
    -0x1.851eb8p-1
  },
  { // Entry 288
    0x1.69aff7bc5d60108b348ed38b803eb445p0,
    0x1.c28f5cp-1
  },
  { // Entry 289
    0x1.69aff7bc5d60108b348ed38b803eb445p0,
    -0x1.c28f5cp-1
  },
  { // Entry 290
    0x1.8b07551d9f5504c2bd28100196a4f66ap0,
    0x1.p0
  },
  { // Entry 291
    0x1.8b07551d9f5504c2bd28100196a4f66ap0,
    -0x1.p0
  },
  { // Entry 292
    0x1.8b07551d9f5504c2bd28100196a4f66ap0,
    0x1.p0
  },
  { // Entry 293
    0x1.8b07551d9f5504c2bd28100196a4f66ap0,
    -0x1.p0
  },
  { // Entry 294
    0x1.96953e5f15bebb0924d95e56e73390d3p3,
    0x1.9de826p1
  },
  { // Entry 295
    0x1.96953e5f15bebb0924d95e56e73390d3p3,
    -0x1.9de826p1
  },
  { // Entry 296
    0x1.d9a541d64593911611959440ebb98fd2p6,
    0x1.5de826p2
  },
  { // Entry 297
    0x1.d9a541d64593911611959440ebb98fd2p6,
    -0x1.5de826p2
  },
  { // Entry 298
    0x1.144daf73b05567a8ab0aec06359687bap10,
    0x1.ecdc38p2
  },
  { // Entry 299
    0x1.144daf73b05567a8ab0aec06359687bap10,
    -0x1.ecdc38p2
  },
  { // Entry 300
    0x1.425f2a5819d974b4f9180a62110d48cbp13,
    0x1.3de826p3
  },
  { // Entry 301
    0x1.425f2a5819d974b4f9180a62110d48cbp13,
    -0x1.3de826p3
  },
  { // Entry 302
    0x1.781f001bd3e350656b057368a4313822p16,
    0x1.856230p3
  },
  { // Entry 303
    0x1.781f001bd3e350656b057368a4313822p16,
    -0x1.856230p3
  },
  { // Entry 304
    0x1.b6d506c59eb76d627415a6c9ee480b4fp19,
    0x1.ccdc3ap3
  },
  { // Entry 305
    0x1.b6d506c59eb76d627415a6c9ee480b4fp19,
    -0x1.ccdc3ap3
  },
  { // Entry 306
    0x1.ffffc188aceab11124fe9a02b928f7d8p22,
    0x1.0a2b22p4
  },
  { // Entry 307
    0x1.ffffc188aceab11124fe9a02b928f7d8p22,
    -0x1.0a2b22p4
  },
  { // Entry 308
    0x1.ffffc107c9f093819e76e37c08510f7cp14,
    0x1.62e42cp3
  },
  { // Entry 309
    0x1.ffffc107c9f093819e76e37c08510f7cp14,
    -0x1.62e42cp3
  },
  { // Entry 310
    0x1.ffffe107c700d006790970a8222e21d8p14,
    0x1.62e42ep3
  },
  { // Entry 311
    0x1.ffffe107c700d006790970a8222e21d8p14,
    -0x1.62e42ep3
  },
  { // Entry 312
    0x1.00000083e30886362db194a7754d1c73p15,
    0x1.62e430p3
  },
  { // Entry 313
    0x1.00000083e30886362db194a7754d1c73p15,
    -0x1.62e430p3
  },
  { // Entry 314
    0x1.0000f04181beb2dc0da3230eba1ddad8p7,
    0x1.62e42cp2
  },
  { // Entry 315
    0x1.0000f04181beb2dc0da3230eba1ddad8p7,
    -0x1.62e42cp2
  },
  { // Entry 316
    0x1.0000f8417960be0c77cfbad2eff76201p7,
    0x1.62e42ep2
  },
  { // Entry 317
    0x1.0000f8417960be0c77cfbad2eff76201p7,
    -0x1.62e42ep2
  },
  { // Entry 318
    0x1.000100417142c97af25aac1bff8f3466p7,
    0x1.62e430p2
  },
  { // Entry 319
    0x1.000100417142c97af25aac1bff8f3466p7,
    -0x1.62e430p2
  },
  { // Entry 320
    0x1.00fff82898287284d209c2639aecd8ebp3,
    0x1.62e42cp1
  },
  { // Entry 321
    0x1.00fff82898287284d209c2639aecd8ebp3,
    -0x1.62e42cp1
  },
  { // Entry 322
    0x1.00fffc249810ddeb04d17e9fa71cc514p3,
    0x1.62e42ep1
  },
  { // Entry 323
    0x1.00fffc249810ddeb04d17e9fa71cc514p3,
    -0x1.62e42ep1
  },
  { // Entry 324
    0x1.0100002098095950f9e2bbfefca756b6p3,
    0x1.62e430p1
  },
  { // Entry 325
    0x1.0100002098095950f9e2bbfefca756b6p3,
    -0x1.62e430p1
  },
  { // Entry 326
    0x1.0ffffc4f56a336e3739f7e70b0a17ffcp1,
    0x1.62e42cp0
  },
  { // Entry 327
    0x1.0ffffc4f56a336e3739f7e70b0a17ffcp1,
    -0x1.62e42cp0
  },
  { // Entry 328
    0x1.0ffffe2f569cf9a7ca3f579d60a5bafap1,
    0x1.62e42ep0
  },
  { // Entry 329
    0x1.0ffffe2f569cf9a7ca3f579d60a5bafap1,
    -0x1.62e42ep0
  },
  { // Entry 330
    0x1.1000000f569afc6c199c8b3f61f3c735p1,
    0x1.62e430p0
  },
  { // Entry 331
    0x1.1000000f569afc6c199c8b3f61f3c735p1,
    -0x1.62e430p0
  },
  { // Entry 332
    0x1.3ffffe8622a6d075816c2559de31a12ep0,
    0x1.62e42cp-1
  },
  { // Entry 333
    0x1.3ffffe8622a6d075816c2559de31a12ep0,
    -0x1.62e42cp-1
  },
  { // Entry 334
    0x1.3fffff4622a4faaf3eeaf3be7155a93cp0,
    0x1.62e42ep-1
  },
  { // Entry 335
    0x1.3fffff4622a4faaf3eeaf3be7155a93cp0,
    -0x1.62e42ep-1
  },
  { // Entry 336
    0x1.4000000622a464e8fbafe4c819d39acfp0,
    0x1.62e430p-1
  },
  { // Entry 337
    0x1.4000000622a464e8fbafe4c819d39acfp0,
    -0x1.62e430p-1
  },
  { // Entry 338
    0x1.0f876c74e688b38ec8cc993bed72c369p0,
    0x1.62e42cp-2
  },
  { // Entry 339
    0x1.0f876c74e688b38ec8cc993bed72c369p0,
    -0x1.62e42cp-2
  },
  { // Entry 340
    0x1.0f876ca227c51ce5c5f21e4840d6475ap0,
    0x1.62e42ep-2
  },
  { // Entry 341
    0x1.0f876ca227c51ce5c5f21e4840d6475ap0,
    -0x1.62e42ep-2
  },
  { // Entry 342
    0x1.0f876ccf6901ca1e9e402d45dcdd46afp0,
    0x1.62e430p-2
  },
  { // Entry 343
    0x1.0f876ccf6901ca1e9e402d45dcdd46afp0,
    -0x1.62e430p-2
  },
  { // Entry 344
    0x1.03da6ea1097c3f9cd57e7b65bc92ecc4p0,
    0x1.62e42cp-3
  },
  { // Entry 345
    0x1.03da6ea1097c3f9cd57e7b65bc92ecc4p0,
    -0x1.62e42cp-3
  },
  { // Entry 346
    0x1.03da6eac2ed8a2cdd0fa87a50311cc5dp0,
    0x1.62e42ep-3
  },
  { // Entry 347
    0x1.03da6eac2ed8a2cdd0fa87a50311cc5dp0,
    -0x1.62e42ep-3
  },
  { // Entry 348
    0x1.03da6eb75435163c736156d1d3d3308ep0,
    0x1.62e430p-3
  },
  { // Entry 349
    0x1.03da6eb75435163c736156d1d3d3308ep0,
    -0x1.62e430p-3
  },
  { // Entry 350
    0x1.00f62552627bf74a0ad4ba77e8ab78a2p0,
    0x1.62e42cp-4
  },
  { // Entry 351
    0x1.00f62552627bf74a0ad4ba77e8ab78a2p0,
    -0x1.62e42cp-4
  },
  { // Entry 352
    0x1.00f625552927bf649d646b851be50016p0,
    0x1.62e42ep-4
  },
  { // Entry 353
    0x1.00f625552927bf649d646b851be50016p0,
    -0x1.62e42ep-4
  },
  { // Entry 354
    0x1.00f62557efd38b8308897136ee1d709ep0,
    0x1.62e430p-4
  },
  { // Entry 355
    0x1.00f62557efd38b8308897136ee1d709ep0,
    -0x1.62e430p-4
  },
  { // Entry 356
    0x1.003d81f101375095ca54e321283ef77bp0,
    0x1.62e42cp-5
  },
  { // Entry 357
    0x1.003d81f101375095ca54e321283ef77bp0,
    -0x1.62e42cp-5
  },
  { // Entry 358
    0x1.003d81f1b2b79cf13e8af72bdc1a3a96p0,
    0x1.62e42ep-5
  },
  { // Entry 359
    0x1.003d81f1b2b79cf13e8af72bdc1a3a96p0,
    -0x1.62e42ep-5
  },
  { // Entry 360
    0x1.003d81f26437ea4cf042fce94792844bp0,
    0x1.62e430p-5
  },
  { // Entry 361
    0x1.003d81f26437ea4cf042fce94792844bp0,
    -0x1.62e430p-5
  },
  { // Entry 362
    0x1.000f60060df0bdbdb94a9aa61dfeb8e8p0,
    0x1.62e42cp-6
  },
  { // Entry 363
    0x1.000f60060df0bdbdb94a9aa61dfeb8e8p0,
    -0x1.62e42cp-6
  },
  { // Entry 364
    0x1.000f60063a4e26b757e72d4936a13599p0,
    0x1.62e42ep-6
  },
  { // Entry 365
    0x1.000f60063a4e26b757e72d4936a13599p0,
    -0x1.62e42ep-6
  },
  { // Entry 366
    0x1.000f600666ab8ff0fa5bc17ae2cd6176p0,
    0x1.62e430p-6
  },
  { // Entry 367
    0x1.000f600666ab8ff0fa5bc17ae2cd6176p0,
    -0x1.62e430p-6
  },
  { // Entry 368
    0x1.00000105c611505e7f74a30e6d20e850p31,
    -0x1.62e430p4
  },
  { // Entry 369
    0x1.00000105c611505e7f74a30e6d20e850p31,
    0x1.62e430p4
  },
  { // Entry 370
    0x1.ffffc20b8fe12f121740ea8acb959525p30,
    -0x1.62e42ep4
  },
  { // Entry 371
    0x1.ffffc20b8fe12f121740ea8acb959525p30,
    0x1.62e42ep4
  },
  { // Entry 372
    0x1.ffff820b9b9fbc6f5ddabe5f5d55c831p30,
    -0x1.62e42cp4
  },
  { // Entry 373
    0x1.ffff820b9b9fbc6f5ddabe5f5d55c831p30,
    0x1.62e42cp4
  },
  { // Entry 374
    0x1.00000083e30886362db194a7754d1c73p15,
    -0x1.62e430p3
  },
  { // Entry 375
    0x1.00000083e30886362db194a7754d1c73p15,
    0x1.62e430p3
  },
  { // Entry 376
    0x1.ffffe107c700d006790970a8222e21d8p14,
    -0x1.62e42ep3
  },
  { // Entry 377
    0x1.ffffe107c700d006790970a8222e21d8p14,
    0x1.62e42ep3
  },
  { // Entry 378
    0x1.ffffc107c9f093819e76e37c08510f7cp14,
    -0x1.62e42cp3
  },
  { // Entry 379
    0x1.ffffc107c9f093819e76e37c08510f7cp14,
    0x1.62e42cp3
  },
  { // Entry 380
    0x1.000100417142c97af25aac1bff8f3466p7,
    -0x1.62e430p2
  },
  { // Entry 381
    0x1.000100417142c97af25aac1bff8f3466p7,
    0x1.62e430p2
  },
  { // Entry 382
    0x1.0000f8417960be0c77cfbad2eff76201p7,
    -0x1.62e42ep2
  },
  { // Entry 383
    0x1.0000f8417960be0c77cfbad2eff76201p7,
    0x1.62e42ep2
  },
  { // Entry 384
    0x1.0000f04181beb2dc0da3230eba1ddad8p7,
    -0x1.62e42cp2
  },
  { // Entry 385
    0x1.0000f04181beb2dc0da3230eba1ddad8p7,
    0x1.62e42cp2
  },
  { // Entry 386
    0x1.0100002098095950f9e2bbfefca756b6p3,
    -0x1.62e430p1
  },
  { // Entry 387
    0x1.0100002098095950f9e2bbfefca756b6p3,
    0x1.62e430p1
  },
  { // Entry 388
    0x1.00fffc249810ddeb04d17e9fa71cc514p3,
    -0x1.62e42ep1
  },
  { // Entry 389
    0x1.00fffc249810ddeb04d17e9fa71cc514p3,
    0x1.62e42ep1
  },
  { // Entry 390
    0x1.00fff82898287284d209c2639aecd8ebp3,
    -0x1.62e42cp1
  },
  { // Entry 391
    0x1.00fff82898287284d209c2639aecd8ebp3,
    0x1.62e42cp1
  },
  { // Entry 392
    0x1.1000000f569afc6c199c8b3f61f3c735p1,
    -0x1.62e430p0
  },
  { // Entry 393
    0x1.1000000f569afc6c199c8b3f61f3c735p1,
    0x1.62e430p0
  },
  { // Entry 394
    0x1.0ffffe2f569cf9a7ca3f579d60a5bafap1,
    -0x1.62e42ep0
  },
  { // Entry 395
    0x1.0ffffe2f569cf9a7ca3f579d60a5bafap1,
    0x1.62e42ep0
  },
  { // Entry 396
    0x1.0ffffc4f56a336e3739f7e70b0a17ffcp1,
    -0x1.62e42cp0
  },
  { // Entry 397
    0x1.0ffffc4f56a336e3739f7e70b0a17ffcp1,
    0x1.62e42cp0
  },
  { // Entry 398
    0x1.4000000622a464e8fbafe4c819d39acfp0,
    -0x1.62e430p-1
  },
  { // Entry 399
    0x1.4000000622a464e8fbafe4c819d39acfp0,
    0x1.62e430p-1
  },
  { // Entry 400
    0x1.3fffff4622a4faaf3eeaf3be7155a93cp0,
    -0x1.62e42ep-1
  },
  { // Entry 401
    0x1.3fffff4622a4faaf3eeaf3be7155a93cp0,
    0x1.62e42ep-1
  },
  { // Entry 402
    0x1.3ffffe8622a6d075816c2559de31a12ep0,
    -0x1.62e42cp-1
  },
  { // Entry 403
    0x1.3ffffe8622a6d075816c2559de31a12ep0,
    0x1.62e42cp-1
  },
  { // Entry 404
    0x1.0f876ccf6901ca1e9e402d45dcdd46afp0,
    -0x1.62e430p-2
  },
  { // Entry 405
    0x1.0f876ccf6901ca1e9e402d45dcdd46afp0,
    0x1.62e430p-2
  },
  { // Entry 406
    0x1.0f876ca227c51ce5c5f21e4840d6475ap0,
    -0x1.62e42ep-2
  },
  { // Entry 407
    0x1.0f876ca227c51ce5c5f21e4840d6475ap0,
    0x1.62e42ep-2
  },
  { // Entry 408
    0x1.0f876c74e688b38ec8cc993bed72c369p0,
    -0x1.62e42cp-2
  },
  { // Entry 409
    0x1.0f876c74e688b38ec8cc993bed72c369p0,
    0x1.62e42cp-2
  },
  { // Entry 410
    0x1.03da6eb75435163c736156d1d3d3308ep0,
    -0x1.62e430p-3
  },
  { // Entry 411
    0x1.03da6eb75435163c736156d1d3d3308ep0,
    0x1.62e430p-3
  },
  { // Entry 412
    0x1.03da6eac2ed8a2cdd0fa87a50311cc5dp0,
    -0x1.62e42ep-3
  },
  { // Entry 413
    0x1.03da6eac2ed8a2cdd0fa87a50311cc5dp0,
    0x1.62e42ep-3
  },
  { // Entry 414
    0x1.03da6ea1097c3f9cd57e7b65bc92ecc4p0,
    -0x1.62e42cp-3
  },
  { // Entry 415
    0x1.03da6ea1097c3f9cd57e7b65bc92ecc4p0,
    0x1.62e42cp-3
  },
  { // Entry 416
    0x1.00f62557efd38b8308897136ee1d709ep0,
    -0x1.62e430p-4
  },
  { // Entry 417
    0x1.00f62557efd38b8308897136ee1d709ep0,
    0x1.62e430p-4
  },
  { // Entry 418
    0x1.00f625552927bf649d646b851be50016p0,
    -0x1.62e42ep-4
  },
  { // Entry 419
    0x1.00f625552927bf649d646b851be50016p0,
    0x1.62e42ep-4
  },
  { // Entry 420
    0x1.00f62552627bf74a0ad4ba77e8ab78a2p0,
    -0x1.62e42cp-4
  },
  { // Entry 421
    0x1.00f62552627bf74a0ad4ba77e8ab78a2p0,
    0x1.62e42cp-4
  },
  { // Entry 422
    0x1.003d81f26437ea4cf042fce94792844bp0,
    -0x1.62e430p-5
  },
  { // Entry 423
    0x1.003d81f26437ea4cf042fce94792844bp0,
    0x1.62e430p-5
  },
  { // Entry 424
    0x1.003d81f1b2b79cf13e8af72bdc1a3a96p0,
    -0x1.62e42ep-5
  },
  { // Entry 425
    0x1.003d81f1b2b79cf13e8af72bdc1a3a96p0,
    0x1.62e42ep-5
  },
  { // Entry 426
    0x1.003d81f101375095ca54e321283ef77bp0,
    -0x1.62e42cp-5
  },
  { // Entry 427
    0x1.003d81f101375095ca54e321283ef77bp0,
    0x1.62e42cp-5
  },
  { // Entry 428
    0x1.p0,
    -0x1.p-149
  },
  { // Entry 429
    0x1.p0,
    0x1.p-149
  },
  { // Entry 430
    0x1.p0,
    0.0
  },
  { // Entry 431
    0x1.p0,
    0x1.p-149
  },
  { // Entry 432
    0x1.p0,
    -0x1.p-149
  },
  { // Entry 433
    0x1.01d86cf5a15f8cd3898947526a322461p0,
    0x1.eb851cp-4
  },
  { // Entry 434
    0x1.01d86cf5a15f8cd3898947526a322461p0,
    -0x1.eb851cp-4
  },
  { // Entry 435
    0x1.01d86cf97ac630fce74cd5d5243b3b2fp0,
    0x1.eb851ep-4
  },
  { // Entry 436
    0x1.01d86cf97ac630fce74cd5d5243b3b2fp0,
    -0x1.eb851ep-4
  },
  { // Entry 437
    0x1.01d86cfd542cd92da6c44a42f7099d65p0,
    0x1.eb8520p-4
  },
  { // Entry 438
    0x1.01d86cfd542cd92da6c44a42f7099d65p0,
    -0x1.eb8520p-4
  },
  { // Entry 439
    0x1.20ac181ffb4ceac216e8b489c48dd3dfp0,
    0x1.fffffep-2
  },
  { // Entry 440
    0x1.20ac181ffb4ceac216e8b489c48dd3dfp0,
    -0x1.fffffep-2
  },
  { // Entry 441
    0x1.20ac1862ae8d0645823a4f060800e88cp0,
    0x1.p-1
  },
  { // Entry 442
    0x1.20ac1862ae8d0645823a4f060800e88cp0,
    -0x1.p-1
  },
  { // Entry 443
    0x1.20ac18e8150e15cd6b3833b87109804fp0,
    0x1.000002p-1
  },
  { // Entry 444
    0x1.20ac18e8150e15cd6b3833b87109804fp0,
    -0x1.000002p-1
  },
  { // Entry 445
    0x1.8b0753f0c559855acf5f13552a0c357bp0,
    0x1.fffffep-1
  },
  { // Entry 446
    0x1.8b0753f0c559855acf5f13552a0c357bp0,
    -0x1.fffffep-1
  },
  { // Entry 447
    0x1.8b07551d9f5504c2bd28100196a4f66ap0,
    0x1.p0
  },
  { // Entry 448
    0x1.8b07551d9f5504c2bd28100196a4f66ap0,
    -0x1.p0
  },
  { // Entry 449
    0x1.8b0757775350a4a8993fc156eb4fc808p0,
    0x1.000002p0
  },
  { // Entry 450
    0x1.8b0757775350a4a8993fc156eb4fc808p0,
    -0x1.000002p0
  },
  { // Entry 451
    0x1.ab5aa630eb432545b54cdaf7f455210cp30,
    0x1.5ffffep4
  },
  { // Entry 452
    0x1.ab5aa630eb432545b54cdaf7f455210cp30,
    -0x1.5ffffep4
  },
  { // Entry 453
    0x1.ab5adb9c435ff81e18afca372828a676p30,
    0x1.60p4
  },
  { // Entry 454
    0x1.ab5adb9c435ff81e18afca372828a676p30,
    -0x1.60p4
  },
  { // Entry 455
    0x1.ab5b1107a22a3664ed2273254e849a81p30,
    0x1.600002p4
  },
  { // Entry 456
    0x1.ab5b1107a22a3664ed2273254e849a81p30,
    -0x1.600002p4
  },
  { // Entry 457
    0x1.226aceedc3b97c2a7eac95e7562be263p32,
    0x1.6ffffep4
  },
  { // Entry 458
    0x1.226aceedc3b97c2a7eac95e7562be263p32,
    -0x1.6ffffep4
  },
  { // Entry 459
    0x1.226af33b1fdc0a57bd4b4ab2311b5cdfp32,
    0x1.70p4
  },
  { // Entry 460
    0x1.226af33b1fdc0a57bd4b4ab2311b5cdfp32,
    -0x1.70p4
  },
  { // Entry 461
    0x1.226b178880884451e86af2dfaf4ed9e0p32,
    0x1.700002p4
  },
  { // Entry 462
    0x1.226b178880884451e86af2dfaf4ed9e0p32,
    -0x1.700002p4
  },
  { // Entry 463
    0x1.ffff8188b8b99accb59239a999795cedp22,
    0x1.0a2b20p4
  },
  { // Entry 464
    0x1.ffff8188b8b99accb59239a999795cedp22,
    -0x1.0a2b20p4
  },
  { // Entry 465
    0x1.ffffc188aceab11124fe9a02b928f7d8p22,
    0x1.0a2b22p4
  },
  { // Entry 466
    0x1.ffffc188aceab11124fe9a02b928f7d8p22,
    -0x1.0a2b22p4
  },
  { // Entry 467
    0x1.000000c4548de32ddb90a7e53a66ba0ap23,
    0x1.0a2b24p4
  },
  { // Entry 468
    0x1.000000c4548de32ddb90a7e53a66ba0ap23,
    -0x1.0a2b24p4
  },
  { // Entry 469
    0x1.ffffc2c458b36e7e18cb1f214e7b10ffp10,
    0x1.0a2b20p3
  },
  { // Entry 470
    0x1.ffffc2c458b36e7e18cb1f214e7b10ffp10,
    -0x1.0a2b20p3
  },
  { // Entry 471
    0x1.ffffe2c4559fb3e81fbe2bbb12e12ae1p10,
    0x1.0a2b22p3
  },
  { // Entry 472
    0x1.ffffe2c4559fb3e81fbe2bbb12e12ae1p10,
    -0x1.0a2b22p3
  },
  { // Entry 473
    0x1.000001622a45fc9a75838159b3d10509p11,
    0x1.0a2b24p3
  },
  { // Entry 474
    0x1.000001622a45fc9a75838159b3d10509p11,
    -0x1.0a2b24p3
  },
  { // Entry 475
    0x1.fffed83ee2532ac846bdff097cd2f43bp127,
    0x1.65a9f6p6
  },
  { // Entry 476
    0x1.fffed83ee2532ac846bdff097cd2f43bp127,
    -0x1.65a9f6p6
  },
  { // Entry 477
    0x1.ffffd83e8e7281a45e432bd58cbbc38ap127,
    0x1.65a9f8p6
  },
  { // Entry 478
    0x1.ffffd83e8e7281a45e432bd58cbbc38ap127,
    -0x1.65a9f8p6
  },
  { // Entry 479
    HUGE_VALF,
    0x1.65a9fap6
  },
  { // Entry 480
    HUGE_VALF,
    -0x1.65a9fap6
  },
  { // Entry 481
    HUGE_VALF,
    -0x1.65a9fap6
  },
  { // Entry 482
    HUGE_VALF,
    0x1.65a9fap6
  },
  { // Entry 483
    0x1.ffffd83e8e7281a45e432bd58cbbc38ap127,
    -0x1.65a9f8p6
  },
  { // Entry 484
    0x1.ffffd83e8e7281a45e432bd58cbbc38ap127,
    0x1.65a9f8p6
  },
  { // Entry 485
    0x1.fffed83ee2532ac846bdff097cd2f43bp127,
    -0x1.65a9f6p6
  },
  { // Entry 486
    0x1.fffed83ee2532ac846bdff097cd2f43bp127,
    0x1.65a9f6p6
  },
  { // Entry 487
    0x1.0000000000000007fffff0000008000ap0,
    0x1.fffffep-31
  },
  { // Entry 488
    0x1.0000000000000007fffff0000008000ap0,
    -0x1.fffffep-31
  },
  { // Entry 489
    0x1.0000000000000008000000000000000ap0,
    0x1.p-30
  },
  { // Entry 490
    0x1.0000000000000008000000000000000ap0,
    -0x1.p-30
  },
  { // Entry 491
    0x1.0000000000000008000020000020000ap0,
    0x1.000002p-30
  },
  { // Entry 492
    0x1.0000000000000008000020000020000ap0,
    -0x1.000002p-30
  },
  { // Entry 493
    0x1.00000001fffffc00aaaca80016c56b8ep0,
    0x1.fffffep-16
  },
  { // Entry 494
    0x1.00000001fffffc00aaaca80016c56b8ep0,
    -0x1.fffffep-16
  },
  { // Entry 495
    0x1.0000000200000000aaaaaaaac16c16c1p0,
    0x1.p-15
  },
  { // Entry 496
    0x1.0000000200000000aaaaaaaac16c16c1p0,
    -0x1.p-15
  },
  { // Entry 497
    0x1.0000000200000800aab2b00016d16d27p0,
    0x1.000002p-15
  },
  { // Entry 498
    0x1.0000000200000800aab2b00016d16d27p0,
    -0x1.000002p-15
  },
  { // Entry 499
    0x1.0008000a9ab0306483e877d147f6d18ap0,
    0x1.fffffep-7
  },
  { // Entry 500
    0x1.0008000a9ab0306483e877d147f6d18ap0,
    -0x1.fffffep-7
  },
  { // Entry 501
    0x1.0008000aaab05b0750755149bcdca034p0,
    0x1.p-6
  },
  { // Entry 502
    0x1.0008000aaab05b0750755149bcdca034p0,
    -0x1.p-6
  },
  { // Entry 503
    0x1.0008000acab0b07ceb0f063ba7bbfa54p0,
    0x1.000002p-6
  },
  { // Entry 504
    0x1.0008000acab0b07ceb0f063ba7bbfa54p0,
    -0x1.000002p-6
  },
  { // Entry 505
    0x1.002000aa6c14187902aad2ffba74cf2cp0,
    0x1.fffffep-6
  },
  { // Entry 506
    0x1.002000aa6c14187902aad2ffba74cf2cp0,
    -0x1.fffffep-6
  },
  { // Entry 507
    0x1.002000aaac16c30c31eaf1bbb1901947p0,
    0x1.p-5
  },
  { // Entry 508
    0x1.002000aaac16c30c31eaf1bbb1901947p0,
    -0x1.p-5
  },
  { // Entry 509
    0x1.002000ab2c1c18f2a86baf44b183af72p0,
    0x1.000002p-5
  },
  { // Entry 510
    0x1.002000ab2c1c18f2a86baf44b183af72p0,
    -0x1.000002p-5
  },
  { // Entry 511
    0x1.00800aaa05874ed7b7cf8f4b5e6fdb38p0,
    0x1.fffffep-5
  },
  { // Entry 512
    0x1.00800aaa05874ed7b7cf8f4b5e6fdb38p0,
    -0x1.fffffep-5
  },
  { // Entry 513
    0x1.00800aab05b1fb245198050937bb0368p0,
    0x1.p-4
  },
  { // Entry 514
    0x1.00800aab05b1fb245198050937bb0368p0,
    -0x1.p-4
  },
  { // Entry 515
    0x1.00800aad060756bf0548f2962af04df6p0,
    0x1.000002p-4
  },
  { // Entry 516
    0x1.00800aad060756bf0548f2962af04df6p0,
    -0x1.000002p-4
  },
  { // Entry 517
    0x1.0200aabd6b0bbcb062a61f361828f822p0,
    0x1.fffffep-4
  },
  { // Entry 518
    0x1.0200aabd6b0bbcb062a61f361828f822p0,
    -0x1.fffffep-4
  },
  { // Entry 519
    0x1.0200aac16db6edec960cd51207e46c1ep0,
    0x1.p-3
  },
  { // Entry 520
    0x1.0200aac16db6edec960cd51207e46c1ep0,
    -0x1.p-3
  },
  { // Entry 521
    0x1.0200aac9730d5c7d04db61f9275b83fap0,
    0x1.000002p-3
  },
  { // Entry 522
    0x1.0200aac9730d5c7d04db61f9275b83fap0,
    -0x1.000002p-3
  },
  { // Entry 523
    0x1.080ab04c7b478d4cb3110d491046c9c9p0,
    0x1.fffffep-3
  },
  { // Entry 524
    0x1.080ab04c7b478d4cb3110d491046c9c9p0,
    -0x1.fffffep-3
  },
  { // Entry 525
    0x1.080ab05ca6145edcde90399c8713a384p0,
    0x1.p-2
  },
  { // Entry 526
    0x1.080ab05ca6145edcde90399c8713a384p0,
    -0x1.p-2
  },
  { // Entry 527
    0x1.080ab07cfbae337f36a0f41414d9d0c8p0,
    0x1.000002p-2
  },
  { // Entry 528
    0x1.080ab07cfbae337f36a0f41414d9d0c8p0,
    -0x1.000002p-2
  },
  { // Entry 529
    0x1.e18f9d3eb3b30ed6335c902418fb7234p1,
    0x1.fffffep0
  },
  { // Entry 530
    0x1.e18f9d3eb3b30ed6335c902418fb7234p1,
    -0x1.fffffep0
  },
  { // Entry 531
    0x1.e18fa0df2d9bc29327f717774d0c0661p1,
    0x1.p1
  },
  { // Entry 532
    0x1.e18fa0df2d9bc29327f717774d0c0661p1,
    -0x1.p1
  },
  { // Entry 533
    0x1.e18fa8202183bcc8aa243133423f76ffp1,
    0x1.000002p1
  },
  { // Entry 534
    0x1.e18fa8202183bcc8aa243133423f76ffp1,
    -0x1.000002p1
  },
  { // Entry 535
    0x1.b4ee7ebb55f4cbc854b082e732092507p4,
    0x1.fffffep1
  },
  { // Entry 536
    0x1.b4ee7ebb55f4cbc854b082e732092507p4,
    -0x1.fffffep1
  },
  { // Entry 537
    0x1.b4ee858de3e80061c6a51dddf960f317p4,
    0x1.p2
  },
  { // Entry 538
    0x1.b4ee858de3e80061c6a51dddf960f317p4,
    -0x1.p2
  },
  { // Entry 539
    0x1.b4ee93330020564e2251f0a10e247060p4,
    0x1.000002p2
  },
  { // Entry 540
    0x1.b4ee93330020564e2251f0a10e247060p4,
    -0x1.000002p2
  },
  { // Entry 541
    0x1.749e9eeeffed4d8079070cc441b07e51p10,
    0x1.fffffep2
  },
  { // Entry 542
    0x1.749e9eeeffed4d8079070cc441b07e51p10,
    -0x1.fffffep2
  },
  { // Entry 543
    0x1.749eaa93f4e76110d5a587e50e4d3dc3p10,
    0x1.p3
  },
  { // Entry 544
    0x1.749eaa93f4e76110d5a587e50e4d3dc3p10,
    -0x1.p3
  },
  { // Entry 545
    0x1.749ec1dddff2ff3467178750bda1362bp10,
    0x1.000002p3
  },
  { // Entry 546
    0x1.749ec1dddff2ff3467178750bda1362bp10,
    -0x1.000002p3
  },
  { // Entry 547
    0x1.0f2eac1794bcba9969899739333d575dp22,
    0x1.fffffep3
  },
  { // Entry 548
    0x1.0f2eac1794bcba9969899739333d575dp22,
    -0x1.fffffep3
  },
  { // Entry 549
    0x1.0f2ebd0a8005cb3d9b4f414186aba4d7p22,
    0x1.p4
  },
  { // Entry 550
    0x1.0f2ebd0a8005cb3d9b4f414186aba4d7p22,
    -0x1.p4
  },
  { // Entry 551
    0x1.0f2edef059c578ce114742bef842a70bp22,
    0x1.000002p4
  },
  { // Entry 552
    0x1.0f2edef059c578ce114742bef842a70bp22,
    -0x1.000002p4
  },
  { // Entry 553
    0x1.1f43d8dc3908b8ed87a5abe34855b461p45,
    0x1.fffffep4
  },
  { // Entry 554
    0x1.1f43d8dc3908b8ed87a5abe34855b461p45,
    -0x1.fffffep4
  },
  { // Entry 555
    0x1.1f43fcc4b662c7d8478840268449bc25p45,
    0x1.p5
  },
  { // Entry 556
    0x1.1f43fcc4b662c7d8478840268449bc25p45,
    -0x1.p5
  },
  { // Entry 557
    0x1.1f444495be8e1616a1e5e396b9caac6bp45,
    0x1.000002p5
  },
  { // Entry 558
    0x1.1f444495be8e1616a1e5e396b9caac6bp45,
    -0x1.000002p5
  },
  { // Entry 559
    0x1.4259323902dbc6e62e3e07ce26cd904cp91,
    0x1.fffffep5
  },
  { // Entry 560
    0x1.4259323902dbc6e62e3e07ce26cd904cp91,
    -0x1.fffffep5
  },
  { // Entry 561
    0x1.425982cf597cd205ce3d5b4edb031756p91,
    0x1.p6
  },
  { // Entry 562
    0x1.425982cf597cd205ce3d5b4edb031756p91,
    -0x1.p6
  },
  { // Entry 563
    0x1.425a23fc432fb5d556006a4d8e7ee11bp91,
    0x1.000002p6
  },
  { // Entry 564
    0x1.425a23fc432fb5d556006a4d8e7ee11bp91,
    -0x1.000002p6
  },
  { // Entry 565
    HUGE_VALF,
    -0x1.fffffep127
  },
  { // Entry 566
    HUGE_VALF,
    0x1.fffffep127
  },
  { // Entry 567
    HUGE_VALF,
    0x1.fffffep127
  },
  { // Entry 568
    HUGE_VALF,
    -0x1.fffffep127
  },
  { // Entry 569
    HUGE_VALF,
    HUGE_VALF
  },
  { // Entry 570
    HUGE_VALF,
    0x1.fffffep127
  },
  { // Entry 571
    HUGE_VALF,
    0x1.fffffcp127
  },
  { // Entry 572
    0x1.72f14a1ced856a7e65c1607d36ef64b3p3,
    0x1.921fb6p1
  },
  { // Entry 573
    0x1.412cc380da7cb6987dff68ad77932f5dp1,
    0x1.921fb6p0
  },
  { // Entry 574
    0x1.8b0757775350a4a8993fc156eb4fc808p0,
    0x1.000002p0
  },
  { // Entry 575
    0x1.8b07551d9f5504c2bd28100196a4f66ap0,
    0x1.p0
  },
  { // Entry 576
    0x1.8b0753f0c559855acf5f13552a0c357bp0,
    0x1.fffffep-1
  },
  { // Entry 577
    0x1.5319951fdd08d95643a6762c2beffae2p0,
    0x1.921fb6p-1
  },
  { // Entry 578
    0x1.p0,
    0x1.000002p-126
  },
  { // Entry 579
    0x1.p0,
    0x1.p-126
  },
  { // Entry 580
    0x1.p0,
    0x1.fffffcp-127
  },
  { // Entry 581
    0x1.p0,
    0x1.fffff8p-127
  },
  { // Entry 582
    0x1.p0,
    0x1.p-148
  },
  { // Entry 583
    0x1.p0,
    0x1.p-149
  },
  { // Entry 584
    0x1.p0,
    0.0f
  },
  { // Entry 585
    0x1.p0,
    -0.0f
  },
  { // Entry 586
    0x1.p0,
    -0x1.p-149
  },
  { // Entry 587
    0x1.p0,
    -0x1.p-148
  },
  { // Entry 588
    0x1.p0,
    -0x1.fffff8p-127
  },
  { // Entry 589
    0x1.p0,
    -0x1.fffffcp-127
  },
  { // Entry 590
    0x1.p0,
    -0x1.p-126
  },
  { // Entry 591
    0x1.p0,
    -0x1.000002p-126
  },
  { // Entry 592
    0x1.5319951fdd08d95643a6762c2beffae2p0,
    -0x1.921fb6p-1
  },
  { // Entry 593
    0x1.8b0753f0c559855acf5f13552a0c357bp0,
    -0x1.fffffep-1
  },
  { // Entry 594
    0x1.8b07551d9f5504c2bd28100196a4f66ap0,
    -0x1.p0
  },
  { // Entry 595
    0x1.8b0757775350a4a8993fc156eb4fc808p0,
    -0x1.000002p0
  },
  { // Entry 596
    0x1.412cc380da7cb6987dff68ad77932f5dp1,
    -0x1.921fb6p0
  },
  { // Entry 597
    0x1.72f14a1ced856a7e65c1607d36ef64b3p3,
    -0x1.921fb6p1
  },
  { // Entry 598
    HUGE_VALF,
    -0x1.fffffcp127
  },
  { // Entry 599
    HUGE_VALF,
    -0x1.fffffep127
  },
  { // Entry 600
    HUGE_VALF,
    -HUGE_VALF
  },
  { // Entry 601
    0x1.ffffd83e8e7281a45e432bd58cbbc38ap127,
    0x1.65a9f8p6
  },
  { // Entry 602
    0x1.ffffd83e8e7281a45e432bd58cbbc38ap127,
    -0x1.65a9f8p6
  },
  { // Entry 603
    HUGE_VALF,
    0x1.65a9fap6
  },
  { // Entry 604
    HUGE_VALF,
    -0x1.65a9fap6
  }
};
