/*
 * This file is auto-generated. Modifications will be lost.
 *
 * See https://android.googlesource.com/platform/bionic/+/master/libc/kernel/
 * for more information.
 */
#ifndef __LINUX_NL80211_H
#define __LINUX_NL80211_H
#include <linux/types.h>
#define NL80211_GENL_NAME "nl80211"
#define NL80211_MULTICAST_GROUP_CONFIG "config"
#define NL80211_MULTICAST_GROUP_SCAN "scan"
#define NL80211_MULTICAST_GROUP_REG "regulatory"
#define NL80211_MULTICAST_GROUP_MLME "mlme"
#define NL80211_MULTICAST_GROUP_VENDOR "vendor"
#define NL80211_MULTICAST_GROUP_NAN "nan"
#define NL80211_MULTICAST_GROUP_TESTMODE "testmode"
#define NL80211_EDMG_BW_CONFIG_MIN 4
#define NL80211_EDMG_BW_CONFIG_MAX 15
#define NL80211_EDMG_CHANNELS_MIN 1
#define NL80211_EDMG_CHANNELS_MAX 0x3c
enum nl80211_commands {
  NL80211_CMD_UNSPEC,
  NL80211_CMD_GET_WIPHY,
  NL80211_CMD_SET_WIPHY,
  NL80211_CMD_NEW_WIPHY,
  NL80211_CMD_DEL_WIPHY,
  NL80211_CMD_GET_INTERFACE,
  NL80211_CMD_SET_INTERFACE,
  NL80211_CMD_NEW_INTERFACE,
  NL80211_CMD_DEL_INTERFACE,
  NL80211_CMD_GET_KEY,
  NL80211_CMD_SET_KEY,
  NL80211_CMD_NEW_KEY,
  NL80211_CMD_DEL_KEY,
  NL80211_CMD_GET_BEACON,
  NL80211_CMD_SET_BEACON,
  NL80211_CMD_START_AP,
  NL80211_CMD_NEW_BEACON = NL80211_CMD_START_AP,
  NL80211_CMD_STOP_AP,
  NL80211_CMD_DEL_BEACON = NL80211_CMD_STOP_AP,
  NL80211_CMD_GET_STATION,
  NL80211_CMD_SET_STATION,
  NL80211_CMD_NEW_STATION,
  NL80211_CMD_DEL_STATION,
  NL80211_CMD_GET_MPATH,
  NL80211_CMD_SET_MPATH,
  NL80211_CMD_NEW_MPATH,
  NL80211_CMD_DEL_MPATH,
  NL80211_CMD_SET_BSS,
  NL80211_CMD_SET_REG,
  NL80211_CMD_REQ_SET_REG,
  NL80211_CMD_GET_MESH_CONFIG,
  NL80211_CMD_SET_MESH_CONFIG,
  NL80211_CMD_SET_MGMT_EXTRA_IE,
  NL80211_CMD_GET_REG,
  NL80211_CMD_GET_SCAN,
  NL80211_CMD_TRIGGER_SCAN,
  NL80211_CMD_NEW_SCAN_RESULTS,
  NL80211_CMD_SCAN_ABORTED,
  NL80211_CMD_REG_CHANGE,
  NL80211_CMD_AUTHENTICATE,
  NL80211_CMD_ASSOCIATE,
  NL80211_CMD_DEAUTHENTICATE,
  NL80211_CMD_DISASSOCIATE,
  NL80211_CMD_MICHAEL_MIC_FAILURE,
  NL80211_CMD_REG_BEACON_HINT,
  NL80211_CMD_JOIN_IBSS,
  NL80211_CMD_LEAVE_IBSS,
  NL80211_CMD_TESTMODE,
  NL80211_CMD_CONNECT,
  NL80211_CMD_ROAM,
  NL80211_CMD_DISCONNECT,
  NL80211_CMD_SET_WIPHY_NETNS,
  NL80211_CMD_GET_SURVEY,
  NL80211_CMD_NEW_SURVEY_RESULTS,
  NL80211_CMD_SET_PMKSA,
  NL80211_CMD_DEL_PMKSA,
  NL80211_CMD_FLUSH_PMKSA,
  NL80211_CMD_REMAIN_ON_CHANNEL,
  NL80211_CMD_CANCEL_REMAIN_ON_CHANNEL,
  NL80211_CMD_SET_TX_BITRATE_MASK,
  NL80211_CMD_REGISTER_FRAME,
  NL80211_CMD_REGISTER_ACTION = NL80211_CMD_REGISTER_FRAME,
  NL80211_CMD_FRAME,
  NL80211_CMD_ACTION = NL80211_CMD_FRAME,
  NL80211_CMD_FRAME_TX_STATUS,
  NL80211_CMD_ACTION_TX_STATUS = NL80211_CMD_FRAME_TX_STATUS,
  NL80211_CMD_SET_POWER_SAVE,
  NL80211_CMD_GET_POWER_SAVE,
  NL80211_CMD_SET_CQM,
  NL80211_CMD_NOTIFY_CQM,
  NL80211_CMD_SET_CHANNEL,
  NL80211_CMD_SET_WDS_PEER,
  NL80211_CMD_FRAME_WAIT_CANCEL,
  NL80211_CMD_JOIN_MESH,
  NL80211_CMD_LEAVE_MESH,
  NL80211_CMD_UNPROT_DEAUTHENTICATE,
  NL80211_CMD_UNPROT_DISASSOCIATE,
  NL80211_CMD_NEW_PEER_CANDIDATE,
  NL80211_CMD_GET_WOWLAN,
  NL80211_CMD_SET_WOWLAN,
  NL80211_CMD_START_SCHED_SCAN,
  NL80211_CMD_STOP_SCHED_SCAN,
  NL80211_CMD_SCHED_SCAN_RESULTS,
  NL80211_CMD_SCHED_SCAN_STOPPED,
  NL80211_CMD_SET_REKEY_OFFLOAD,
  NL80211_CMD_PMKSA_CANDIDATE,
  NL80211_CMD_TDLS_OPER,
  NL80211_CMD_TDLS_MGMT,
  NL80211_CMD_UNEXPECTED_FRAME,
  NL80211_CMD_PROBE_CLIENT,
  NL80211_CMD_REGISTER_BEACONS,
  NL80211_CMD_UNEXPECTED_4ADDR_FRAME,
  NL80211_CMD_SET_NOACK_MAP,
  NL80211_CMD_CH_SWITCH_NOTIFY,
  NL80211_CMD_START_P2P_DEVICE,
  NL80211_CMD_STOP_P2P_DEVICE,
  NL80211_CMD_CONN_FAILED,
  NL80211_CMD_SET_MCAST_RATE,
  NL80211_CMD_SET_MAC_ACL,
  NL80211_CMD_RADAR_DETECT,
  NL80211_CMD_GET_PROTOCOL_FEATURES,
  NL80211_CMD_UPDATE_FT_IES,
  NL80211_CMD_FT_EVENT,
  NL80211_CMD_CRIT_PROTOCOL_START,
  NL80211_CMD_CRIT_PROTOCOL_STOP,
  NL80211_CMD_GET_COALESCE,
  NL80211_CMD_SET_COALESCE,
  NL80211_CMD_CHANNEL_SWITCH,
  NL80211_CMD_VENDOR,
  NL80211_CMD_SET_QOS_MAP,
  NL80211_CMD_ADD_TX_TS,
  NL80211_CMD_DEL_TX_TS,
  NL80211_CMD_GET_MPP,
  NL80211_CMD_JOIN_OCB,
  NL80211_CMD_LEAVE_OCB,
  NL80211_CMD_CH_SWITCH_STARTED_NOTIFY,
  NL80211_CMD_TDLS_CHANNEL_SWITCH,
  NL80211_CMD_TDLS_CANCEL_CHANNEL_SWITCH,
  NL80211_CMD_WIPHY_REG_CHANGE,
  NL80211_CMD_ABORT_SCAN,
  NL80211_CMD_START_NAN,
  NL80211_CMD_STOP_NAN,
  NL80211_CMD_ADD_NAN_FUNCTION,
  NL80211_CMD_DEL_NAN_FUNCTION,
  NL80211_CMD_CHANGE_NAN_CONFIG,
  NL80211_CMD_NAN_MATCH,
  NL80211_CMD_SET_MULTICAST_TO_UNICAST,
  NL80211_CMD_UPDATE_CONNECT_PARAMS,
  NL80211_CMD_SET_PMK,
  NL80211_CMD_DEL_PMK,
  NL80211_CMD_PORT_AUTHORIZED,
  NL80211_CMD_RELOAD_REGDB,
  NL80211_CMD_EXTERNAL_AUTH,
  NL80211_CMD_STA_OPMODE_CHANGED,
  NL80211_CMD_CONTROL_PORT_FRAME,
  NL80211_CMD_GET_FTM_RESPONDER_STATS,
  NL80211_CMD_PEER_MEASUREMENT_START,
  NL80211_CMD_PEER_MEASUREMENT_RESULT,
  NL80211_CMD_PEER_MEASUREMENT_COMPLETE,
  NL80211_CMD_NOTIFY_RADAR,
  NL80211_CMD_UPDATE_OWE_INFO,
  NL80211_CMD_PROBE_MESH_LINK,
  NL80211_CMD_SET_TID_CONFIG,
  NL80211_CMD_UNPROT_BEACON,
  NL80211_CMD_CONTROL_PORT_FRAME_TX_STATUS,
  NL80211_CMD_SET_SAR_SPECS,
  NL80211_CMD_OBSS_COLOR_COLLISION,
  NL80211_CMD_COLOR_CHANGE_REQUEST,
  NL80211_CMD_COLOR_CHANGE_STARTED,
  NL80211_CMD_COLOR_CHANGE_ABORTED,
  NL80211_CMD_COLOR_CHANGE_COMPLETED,
  NL80211_CMD_SET_FILS_AAD,
  NL80211_CMD_ASSOC_COMEBACK,
  NL80211_CMD_ADD_LINK,
  NL80211_CMD_REMOVE_LINK,
  NL80211_CMD_ADD_LINK_STA,
  NL80211_CMD_MODIFY_LINK_STA,
  NL80211_CMD_REMOVE_LINK_STA,
  NL80211_CMD_SET_HW_TIMESTAMP,
  NL80211_CMD_LINKS_REMOVED,
  __NL80211_CMD_AFTER_LAST,
  NL80211_CMD_MAX = __NL80211_CMD_AFTER_LAST - 1
};
#define NL80211_CMD_SET_BSS NL80211_CMD_SET_BSS
#define NL80211_CMD_SET_MGMT_EXTRA_IE NL80211_CMD_SET_MGMT_EXTRA_IE
#define NL80211_CMD_REG_CHANGE NL80211_CMD_REG_CHANGE
#define NL80211_CMD_AUTHENTICATE NL80211_CMD_AUTHENTICATE
#define NL80211_CMD_ASSOCIATE NL80211_CMD_ASSOCIATE
#define NL80211_CMD_DEAUTHENTICATE NL80211_CMD_DEAUTHENTICATE
#define NL80211_CMD_DISASSOCIATE NL80211_CMD_DISASSOCIATE
#define NL80211_CMD_REG_BEACON_HINT NL80211_CMD_REG_BEACON_HINT
#define NL80211_ATTR_FEATURE_FLAGS NL80211_ATTR_FEATURE_FLAGS
#define NL80211_CMD_GET_MESH_PARAMS NL80211_CMD_GET_MESH_CONFIG
#define NL80211_CMD_SET_MESH_PARAMS NL80211_CMD_SET_MESH_CONFIG
#define NL80211_MESH_SETUP_VENDOR_PATH_SEL_IE NL80211_MESH_SETUP_IE
enum nl80211_attrs {
  NL80211_ATTR_UNSPEC,
  NL80211_ATTR_WIPHY,
  NL80211_ATTR_WIPHY_NAME,
  NL80211_ATTR_IFINDEX,
  NL80211_ATTR_IFNAME,
  NL80211_ATTR_IFTYPE,
  NL80211_ATTR_MAC,
  NL80211_ATTR_KEY_DATA,
  NL80211_ATTR_KEY_IDX,
  NL80211_ATTR_KEY_CIPHER,
  NL80211_ATTR_KEY_SEQ,
  NL80211_ATTR_KEY_DEFAULT,
  NL80211_ATTR_BEACON_INTERVAL,
  NL80211_ATTR_DTIM_PERIOD,
  NL80211_ATTR_BEACON_HEAD,
  NL80211_ATTR_BEACON_TAIL,
  NL80211_ATTR_STA_AID,
  NL80211_ATTR_STA_FLAGS,
  NL80211_ATTR_STA_LISTEN_INTERVAL,
  NL80211_ATTR_STA_SUPPORTED_RATES,
  NL80211_ATTR_STA_VLAN,
  NL80211_ATTR_STA_INFO,
  NL80211_ATTR_WIPHY_BANDS,
  NL80211_ATTR_MNTR_FLAGS,
  NL80211_ATTR_MESH_ID,
  NL80211_ATTR_STA_PLINK_ACTION,
  NL80211_ATTR_MPATH_NEXT_HOP,
  NL80211_ATTR_MPATH_INFO,
  NL80211_ATTR_BSS_CTS_PROT,
  NL80211_ATTR_BSS_SHORT_PREAMBLE,
  NL80211_ATTR_BSS_SHORT_SLOT_TIME,
  NL80211_ATTR_HT_CAPABILITY,
  NL80211_ATTR_SUPPORTED_IFTYPES,
  NL80211_ATTR_REG_ALPHA2,
  NL80211_ATTR_REG_RULES,
  NL80211_ATTR_MESH_CONFIG,
  NL80211_ATTR_BSS_BASIC_RATES,
  NL80211_ATTR_WIPHY_TXQ_PARAMS,
  NL80211_ATTR_WIPHY_FREQ,
  NL80211_ATTR_WIPHY_CHANNEL_TYPE,
  NL80211_ATTR_KEY_DEFAULT_MGMT,
  NL80211_ATTR_MGMT_SUBTYPE,
  NL80211_ATTR_IE,
  NL80211_ATTR_MAX_NUM_SCAN_SSIDS,
  NL80211_ATTR_SCAN_FREQUENCIES,
  NL80211_ATTR_SCAN_SSIDS,
  NL80211_ATTR_GENERATION,
  NL80211_ATTR_BSS,
  NL80211_ATTR_REG_INITIATOR,
  NL80211_ATTR_REG_TYPE,
  NL80211_ATTR_SUPPORTED_COMMANDS,
  NL80211_ATTR_FRAME,
  NL80211_ATTR_SSID,
  NL80211_ATTR_AUTH_TYPE,
  NL80211_ATTR_REASON_CODE,
  NL80211_ATTR_KEY_TYPE,
  NL80211_ATTR_MAX_SCAN_IE_LEN,
  NL80211_ATTR_CIPHER_SUITES,
  NL80211_ATTR_FREQ_BEFORE,
  NL80211_ATTR_FREQ_AFTER,
  NL80211_ATTR_FREQ_FIXED,
  NL80211_ATTR_WIPHY_RETRY_SHORT,
  NL80211_ATTR_WIPHY_RETRY_LONG,
  NL80211_ATTR_WIPHY_FRAG_THRESHOLD,
  NL80211_ATTR_WIPHY_RTS_THRESHOLD,
  NL80211_ATTR_TIMED_OUT,
  NL80211_ATTR_USE_MFP,
  NL80211_ATTR_STA_FLAGS2,
  NL80211_ATTR_CONTROL_PORT,
  NL80211_ATTR_TESTDATA,
  NL80211_ATTR_PRIVACY,
  NL80211_ATTR_DISCONNECTED_BY_AP,
  NL80211_ATTR_STATUS_CODE,
  NL80211_ATTR_CIPHER_SUITES_PAIRWISE,
  NL80211_ATTR_CIPHER_SUITE_GROUP,
  NL80211_ATTR_WPA_VERSIONS,
  NL80211_ATTR_AKM_SUITES,
  NL80211_ATTR_REQ_IE,
  NL80211_ATTR_RESP_IE,
  NL80211_ATTR_PREV_BSSID,
  NL80211_ATTR_KEY,
  NL80211_ATTR_KEYS,
  NL80211_ATTR_PID,
  NL80211_ATTR_4ADDR,
  NL80211_ATTR_SURVEY_INFO,
  NL80211_ATTR_PMKID,
  NL80211_ATTR_MAX_NUM_PMKIDS,
  NL80211_ATTR_DURATION,
  NL80211_ATTR_COOKIE,
  NL80211_ATTR_WIPHY_COVERAGE_CLASS,
  NL80211_ATTR_TX_RATES,
  NL80211_ATTR_FRAME_MATCH,
  NL80211_ATTR_ACK,
  NL80211_ATTR_PS_STATE,
  NL80211_ATTR_CQM,
  NL80211_ATTR_LOCAL_STATE_CHANGE,
  NL80211_ATTR_AP_ISOLATE,
  NL80211_ATTR_WIPHY_TX_POWER_SETTING,
  NL80211_ATTR_WIPHY_TX_POWER_LEVEL,
  NL80211_ATTR_TX_FRAME_TYPES,
  NL80211_ATTR_RX_FRAME_TYPES,
  NL80211_ATTR_FRAME_TYPE,
  NL80211_ATTR_CONTROL_PORT_ETHERTYPE,
  NL80211_ATTR_CONTROL_PORT_NO_ENCRYPT,
  NL80211_ATTR_SUPPORT_IBSS_RSN,
  NL80211_ATTR_WIPHY_ANTENNA_TX,
  NL80211_ATTR_WIPHY_ANTENNA_RX,
  NL80211_ATTR_MCAST_RATE,
  NL80211_ATTR_OFFCHANNEL_TX_OK,
  NL80211_ATTR_BSS_HT_OPMODE,
  NL80211_ATTR_KEY_DEFAULT_TYPES,
  NL80211_ATTR_MAX_REMAIN_ON_CHANNEL_DURATION,
  NL80211_ATTR_MESH_SETUP,
  NL80211_ATTR_WIPHY_ANTENNA_AVAIL_TX,
  NL80211_ATTR_WIPHY_ANTENNA_AVAIL_RX,
  NL80211_ATTR_SUPPORT_MESH_AUTH,
  NL80211_ATTR_STA_PLINK_STATE,
  NL80211_ATTR_WOWLAN_TRIGGERS,
  NL80211_ATTR_WOWLAN_TRIGGERS_SUPPORTED,
  NL80211_ATTR_SCHED_SCAN_INTERVAL,
  NL80211_ATTR_INTERFACE_COMBINATIONS,
  NL80211_ATTR_SOFTWARE_IFTYPES,
  NL80211_ATTR_REKEY_DATA,
  NL80211_ATTR_MAX_NUM_SCHED_SCAN_SSIDS,
  NL80211_ATTR_MAX_SCHED_SCAN_IE_LEN,
  NL80211_ATTR_SCAN_SUPP_RATES,
  NL80211_ATTR_HIDDEN_SSID,
  NL80211_ATTR_IE_PROBE_RESP,
  NL80211_ATTR_IE_ASSOC_RESP,
  NL80211_ATTR_STA_WME,
  NL80211_ATTR_SUPPORT_AP_UAPSD,
  NL80211_ATTR_ROAM_SUPPORT,
  NL80211_ATTR_SCHED_SCAN_MATCH,
  NL80211_ATTR_MAX_MATCH_SETS,
  NL80211_ATTR_PMKSA_CANDIDATE,
  NL80211_ATTR_TX_NO_CCK_RATE,
  NL80211_ATTR_TDLS_ACTION,
  NL80211_ATTR_TDLS_DIALOG_TOKEN,
  NL80211_ATTR_TDLS_OPERATION,
  NL80211_ATTR_TDLS_SUPPORT,
  NL80211_ATTR_TDLS_EXTERNAL_SETUP,
  NL80211_ATTR_DEVICE_AP_SME,
  NL80211_ATTR_DONT_WAIT_FOR_ACK,
  NL80211_ATTR_FEATURE_FLAGS,
  NL80211_ATTR_PROBE_RESP_OFFLOAD,
  NL80211_ATTR_PROBE_RESP,
  NL80211_ATTR_DFS_REGION,
  NL80211_ATTR_DISABLE_HT,
  NL80211_ATTR_HT_CAPABILITY_MASK,
  NL80211_ATTR_NOACK_MAP,
  NL80211_ATTR_INACTIVITY_TIMEOUT,
  NL80211_ATTR_RX_SIGNAL_DBM,
  NL80211_ATTR_BG_SCAN_PERIOD,
  NL80211_ATTR_WDEV,
  NL80211_ATTR_USER_REG_HINT_TYPE,
  NL80211_ATTR_CONN_FAILED_REASON,
  NL80211_ATTR_AUTH_DATA,
  NL80211_ATTR_VHT_CAPABILITY,
  NL80211_ATTR_SCAN_FLAGS,
  NL80211_ATTR_CHANNEL_WIDTH,
  NL80211_ATTR_CENTER_FREQ1,
  NL80211_ATTR_CENTER_FREQ2,
  NL80211_ATTR_P2P_CTWINDOW,
  NL80211_ATTR_P2P_OPPPS,
  NL80211_ATTR_LOCAL_MESH_POWER_MODE,
  NL80211_ATTR_ACL_POLICY,
  NL80211_ATTR_MAC_ADDRS,
  NL80211_ATTR_MAC_ACL_MAX,
  NL80211_ATTR_RADAR_EVENT,
  NL80211_ATTR_EXT_CAPA,
  NL80211_ATTR_EXT_CAPA_MASK,
  NL80211_ATTR_STA_CAPABILITY,
  NL80211_ATTR_STA_EXT_CAPABILITY,
  NL80211_ATTR_PROTOCOL_FEATURES,
  NL80211_ATTR_SPLIT_WIPHY_DUMP,
  NL80211_ATTR_DISABLE_VHT,
  NL80211_ATTR_VHT_CAPABILITY_MASK,
  NL80211_ATTR_MDID,
  NL80211_ATTR_IE_RIC,
  NL80211_ATTR_CRIT_PROT_ID,
  NL80211_ATTR_MAX_CRIT_PROT_DURATION,
  NL80211_ATTR_PEER_AID,
  NL80211_ATTR_COALESCE_RULE,
  NL80211_ATTR_CH_SWITCH_COUNT,
  NL80211_ATTR_CH_SWITCH_BLOCK_TX,
  NL80211_ATTR_CSA_IES,
  NL80211_ATTR_CNTDWN_OFFS_BEACON,
  NL80211_ATTR_CNTDWN_OFFS_PRESP,
  NL80211_ATTR_RXMGMT_FLAGS,
  NL80211_ATTR_STA_SUPPORTED_CHANNELS,
  NL80211_ATTR_STA_SUPPORTED_OPER_CLASSES,
  NL80211_ATTR_HANDLE_DFS,
  NL80211_ATTR_SUPPORT_5_MHZ,
  NL80211_ATTR_SUPPORT_10_MHZ,
  NL80211_ATTR_OPMODE_NOTIF,
  NL80211_ATTR_VENDOR_ID,
  NL80211_ATTR_VENDOR_SUBCMD,
  NL80211_ATTR_VENDOR_DATA,
  NL80211_ATTR_VENDOR_EVENTS,
  NL80211_ATTR_QOS_MAP,
  NL80211_ATTR_MAC_HINT,
  NL80211_ATTR_WIPHY_FREQ_HINT,
  NL80211_ATTR_MAX_AP_ASSOC_STA,
  NL80211_ATTR_TDLS_PEER_CAPABILITY,
  NL80211_ATTR_SOCKET_OWNER,
  NL80211_ATTR_CSA_C_OFFSETS_TX,
  NL80211_ATTR_MAX_CSA_COUNTERS,
  NL80211_ATTR_TDLS_INITIATOR,
  NL80211_ATTR_USE_RRM,
  NL80211_ATTR_WIPHY_DYN_ACK,
  NL80211_ATTR_TSID,
  NL80211_ATTR_USER_PRIO,
  NL80211_ATTR_ADMITTED_TIME,
  NL80211_ATTR_SMPS_MODE,
  NL80211_ATTR_OPER_CLASS,
  NL80211_ATTR_MAC_MASK,
  NL80211_ATTR_WIPHY_SELF_MANAGED_REG,
  NL80211_ATTR_EXT_FEATURES,
  NL80211_ATTR_SURVEY_RADIO_STATS,
  NL80211_ATTR_NETNS_FD,
  NL80211_ATTR_SCHED_SCAN_DELAY,
  NL80211_ATTR_REG_INDOOR,
  NL80211_ATTR_MAX_NUM_SCHED_SCAN_PLANS,
  NL80211_ATTR_MAX_SCAN_PLAN_INTERVAL,
  NL80211_ATTR_MAX_SCAN_PLAN_ITERATIONS,
  NL80211_ATTR_SCHED_SCAN_PLANS,
  NL80211_ATTR_PBSS,
  NL80211_ATTR_BSS_SELECT,
  NL80211_ATTR_STA_SUPPORT_P2P_PS,
  NL80211_ATTR_PAD,
  NL80211_ATTR_IFTYPE_EXT_CAPA,
  NL80211_ATTR_MU_MIMO_GROUP_DATA,
  NL80211_ATTR_MU_MIMO_FOLLOW_MAC_ADDR,
  NL80211_ATTR_SCAN_START_TIME_TSF,
  NL80211_ATTR_SCAN_START_TIME_TSF_BSSID,
  NL80211_ATTR_MEASUREMENT_DURATION,
  NL80211_ATTR_MEASUREMENT_DURATION_MANDATORY,
  NL80211_ATTR_MESH_PEER_AID,
  NL80211_ATTR_NAN_MASTER_PREF,
  NL80211_ATTR_BANDS,
  NL80211_ATTR_NAN_FUNC,
  NL80211_ATTR_NAN_MATCH,
  NL80211_ATTR_FILS_KEK,
  NL80211_ATTR_FILS_NONCES,
  NL80211_ATTR_MULTICAST_TO_UNICAST_ENABLED,
  NL80211_ATTR_BSSID,
  NL80211_ATTR_SCHED_SCAN_RELATIVE_RSSI,
  NL80211_ATTR_SCHED_SCAN_RSSI_ADJUST,
  NL80211_ATTR_TIMEOUT_REASON,
  NL80211_ATTR_FILS_ERP_USERNAME,
  NL80211_ATTR_FILS_ERP_REALM,
  NL80211_ATTR_FILS_ERP_NEXT_SEQ_NUM,
  NL80211_ATTR_FILS_ERP_RRK,
  NL80211_ATTR_FILS_CACHE_ID,
  NL80211_ATTR_PMK,
  NL80211_ATTR_SCHED_SCAN_MULTI,
  NL80211_ATTR_SCHED_SCAN_MAX_REQS,
  NL80211_ATTR_WANT_1X_4WAY_HS,
  NL80211_ATTR_PMKR0_NAME,
  NL80211_ATTR_PORT_AUTHORIZED,
  NL80211_ATTR_EXTERNAL_AUTH_ACTION,
  NL80211_ATTR_EXTERNAL_AUTH_SUPPORT,
  NL80211_ATTR_NSS,
  NL80211_ATTR_ACK_SIGNAL,
  NL80211_ATTR_CONTROL_PORT_OVER_NL80211,
  NL80211_ATTR_TXQ_STATS,
  NL80211_ATTR_TXQ_LIMIT,
  NL80211_ATTR_TXQ_MEMORY_LIMIT,
  NL80211_ATTR_TXQ_QUANTUM,
  NL80211_ATTR_HE_CAPABILITY,
  NL80211_ATTR_FTM_RESPONDER,
  NL80211_ATTR_FTM_RESPONDER_STATS,
  NL80211_ATTR_TIMEOUT,
  NL80211_ATTR_PEER_MEASUREMENTS,
  NL80211_ATTR_AIRTIME_WEIGHT,
  NL80211_ATTR_STA_TX_POWER_SETTING,
  NL80211_ATTR_STA_TX_POWER,
  NL80211_ATTR_SAE_PASSWORD,
  NL80211_ATTR_TWT_RESPONDER,
  NL80211_ATTR_HE_OBSS_PD,
  NL80211_ATTR_WIPHY_EDMG_CHANNELS,
  NL80211_ATTR_WIPHY_EDMG_BW_CONFIG,
  NL80211_ATTR_VLAN_ID,
  NL80211_ATTR_HE_BSS_COLOR,
  NL80211_ATTR_IFTYPE_AKM_SUITES,
  NL80211_ATTR_TID_CONFIG,
  NL80211_ATTR_CONTROL_PORT_NO_PREAUTH,
  NL80211_ATTR_PMK_LIFETIME,
  NL80211_ATTR_PMK_REAUTH_THRESHOLD,
  NL80211_ATTR_RECEIVE_MULTICAST,
  NL80211_ATTR_WIPHY_FREQ_OFFSET,
  NL80211_ATTR_CENTER_FREQ1_OFFSET,
  NL80211_ATTR_SCAN_FREQ_KHZ,
  NL80211_ATTR_HE_6GHZ_CAPABILITY,
  NL80211_ATTR_FILS_DISCOVERY,
  NL80211_ATTR_UNSOL_BCAST_PROBE_RESP,
  NL80211_ATTR_S1G_CAPABILITY,
  NL80211_ATTR_S1G_CAPABILITY_MASK,
  NL80211_ATTR_SAE_PWE,
  NL80211_ATTR_RECONNECT_REQUESTED,
  NL80211_ATTR_SAR_SPEC,
  NL80211_ATTR_DISABLE_HE,
  NL80211_ATTR_OBSS_COLOR_BITMAP,
  NL80211_ATTR_COLOR_CHANGE_COUNT,
  NL80211_ATTR_COLOR_CHANGE_COLOR,
  NL80211_ATTR_COLOR_CHANGE_ELEMS,
  NL80211_ATTR_MBSSID_CONFIG,
  NL80211_ATTR_MBSSID_ELEMS,
  NL80211_ATTR_RADAR_BACKGROUND,
  NL80211_ATTR_AP_SETTINGS_FLAGS,
  NL80211_ATTR_EHT_CAPABILITY,
  NL80211_ATTR_DISABLE_EHT,
  NL80211_ATTR_MLO_LINKS,
  NL80211_ATTR_MLO_LINK_ID,
  NL80211_ATTR_MLD_ADDR,
  NL80211_ATTR_MLO_SUPPORT,
  NL80211_ATTR_MAX_NUM_AKM_SUITES,
  NL80211_ATTR_EML_CAPABILITY,
  NL80211_ATTR_MLD_CAPA_AND_OPS,
  NL80211_ATTR_TX_HW_TIMESTAMP,
  NL80211_ATTR_RX_HW_TIMESTAMP,
  NL80211_ATTR_TD_BITMAP,
  NL80211_ATTR_PUNCT_BITMAP,
  NL80211_ATTR_MAX_HW_TIMESTAMP_PEERS,
  NL80211_ATTR_HW_TIMESTAMP_ENABLED,
  NL80211_ATTR_EMA_RNR_ELEMS,
  NL80211_ATTR_MLO_LINK_DISABLED,
  __NL80211_ATTR_AFTER_LAST,
  NUM_NL80211_ATTR = __NL80211_ATTR_AFTER_LAST,
  NL80211_ATTR_MAX = __NL80211_ATTR_AFTER_LAST - 1
};
#define NL80211_ATTR_SCAN_GENERATION NL80211_ATTR_GENERATION
#define NL80211_ATTR_MESH_PARAMS NL80211_ATTR_MESH_CONFIG
#define NL80211_ATTR_IFACE_SOCKET_OWNER NL80211_ATTR_SOCKET_OWNER
#define NL80211_ATTR_SAE_DATA NL80211_ATTR_AUTH_DATA
#define NL80211_ATTR_CSA_C_OFF_BEACON NL80211_ATTR_CNTDWN_OFFS_BEACON
#define NL80211_ATTR_CSA_C_OFF_PRESP NL80211_ATTR_CNTDWN_OFFS_PRESP
#define NL80211_CMD_CONNECT NL80211_CMD_CONNECT
#define NL80211_ATTR_HT_CAPABILITY NL80211_ATTR_HT_CAPABILITY
#define NL80211_ATTR_BSS_BASIC_RATES NL80211_ATTR_BSS_BASIC_RATES
#define NL80211_ATTR_WIPHY_TXQ_PARAMS NL80211_ATTR_WIPHY_TXQ_PARAMS
#define NL80211_ATTR_WIPHY_FREQ NL80211_ATTR_WIPHY_FREQ
#define NL80211_ATTR_WIPHY_CHANNEL_TYPE NL80211_ATTR_WIPHY_CHANNEL_TYPE
#define NL80211_ATTR_MGMT_SUBTYPE NL80211_ATTR_MGMT_SUBTYPE
#define NL80211_ATTR_IE NL80211_ATTR_IE
#define NL80211_ATTR_REG_INITIATOR NL80211_ATTR_REG_INITIATOR
#define NL80211_ATTR_REG_TYPE NL80211_ATTR_REG_TYPE
#define NL80211_ATTR_FRAME NL80211_ATTR_FRAME
#define NL80211_ATTR_SSID NL80211_ATTR_SSID
#define NL80211_ATTR_AUTH_TYPE NL80211_ATTR_AUTH_TYPE
#define NL80211_ATTR_REASON_CODE NL80211_ATTR_REASON_CODE
#define NL80211_ATTR_CIPHER_SUITES_PAIRWISE NL80211_ATTR_CIPHER_SUITES_PAIRWISE
#define NL80211_ATTR_CIPHER_SUITE_GROUP NL80211_ATTR_CIPHER_SUITE_GROUP
#define NL80211_ATTR_WPA_VERSIONS NL80211_ATTR_WPA_VERSIONS
#define NL80211_ATTR_AKM_SUITES NL80211_ATTR_AKM_SUITES
#define NL80211_ATTR_KEY NL80211_ATTR_KEY
#define NL80211_ATTR_KEYS NL80211_ATTR_KEYS
#define NL80211_ATTR_FEATURE_FLAGS NL80211_ATTR_FEATURE_FLAGS
#define NL80211_WIPHY_NAME_MAXLEN 64
#define NL80211_MAX_SUPP_RATES 32
#define NL80211_MAX_SUPP_HT_RATES 77
#define NL80211_MAX_SUPP_REG_RULES 128
#define NL80211_TKIP_DATA_OFFSET_ENCR_KEY 0
#define NL80211_TKIP_DATA_OFFSET_TX_MIC_KEY 16
#define NL80211_TKIP_DATA_OFFSET_RX_MIC_KEY 24
#define NL80211_HT_CAPABILITY_LEN 26
#define NL80211_VHT_CAPABILITY_LEN 12
#define NL80211_HE_MIN_CAPABILITY_LEN 16
#define NL80211_HE_MAX_CAPABILITY_LEN 54
#define NL80211_MAX_NR_CIPHER_SUITES 5
#define NL80211_MAX_NR_AKM_SUITES 2
#define NL80211_EHT_MIN_CAPABILITY_LEN 13
#define NL80211_EHT_MAX_CAPABILITY_LEN 51
#define NL80211_MIN_REMAIN_ON_CHANNEL_TIME 10
#define NL80211_SCAN_RSSI_THOLD_OFF - 300
#define NL80211_CQM_TXE_MAX_INTVL 1800
enum nl80211_iftype {
  NL80211_IFTYPE_UNSPECIFIED,
  NL80211_IFTYPE_ADHOC,
  NL80211_IFTYPE_STATION,
  NL80211_IFTYPE_AP,
  NL80211_IFTYPE_AP_VLAN,
  NL80211_IFTYPE_WDS,
  NL80211_IFTYPE_MONITOR,
  NL80211_IFTYPE_MESH_POINT,
  NL80211_IFTYPE_P2P_CLIENT,
  NL80211_IFTYPE_P2P_GO,
  NL80211_IFTYPE_P2P_DEVICE,
  NL80211_IFTYPE_OCB,
  NL80211_IFTYPE_NAN,
  NUM_NL80211_IFTYPES,
  NL80211_IFTYPE_MAX = NUM_NL80211_IFTYPES - 1
};
enum nl80211_sta_flags {
  __NL80211_STA_FLAG_INVALID,
  NL80211_STA_FLAG_AUTHORIZED,
  NL80211_STA_FLAG_SHORT_PREAMBLE,
  NL80211_STA_FLAG_WME,
  NL80211_STA_FLAG_MFP,
  NL80211_STA_FLAG_AUTHENTICATED,
  NL80211_STA_FLAG_TDLS_PEER,
  NL80211_STA_FLAG_ASSOCIATED,
  __NL80211_STA_FLAG_AFTER_LAST,
  NL80211_STA_FLAG_MAX = __NL80211_STA_FLAG_AFTER_LAST - 1
};
enum nl80211_sta_p2p_ps_status {
  NL80211_P2P_PS_UNSUPPORTED = 0,
  NL80211_P2P_PS_SUPPORTED,
  NUM_NL80211_P2P_PS_STATUS,
};
#define NL80211_STA_FLAG_MAX_OLD_API NL80211_STA_FLAG_TDLS_PEER
struct nl80211_sta_flag_update {
  __u32 mask;
  __u32 set;
} __attribute__((packed));
enum nl80211_he_gi {
  NL80211_RATE_INFO_HE_GI_0_8,
  NL80211_RATE_INFO_HE_GI_1_6,
  NL80211_RATE_INFO_HE_GI_3_2,
};
enum nl80211_he_ltf {
  NL80211_RATE_INFO_HE_1XLTF,
  NL80211_RATE_INFO_HE_2XLTF,
  NL80211_RATE_INFO_HE_4XLTF,
};
enum nl80211_he_ru_alloc {
  NL80211_RATE_INFO_HE_RU_ALLOC_26,
  NL80211_RATE_INFO_HE_RU_ALLOC_52,
  NL80211_RATE_INFO_HE_RU_ALLOC_106,
  NL80211_RATE_INFO_HE_RU_ALLOC_242,
  NL80211_RATE_INFO_HE_RU_ALLOC_484,
  NL80211_RATE_INFO_HE_RU_ALLOC_996,
  NL80211_RATE_INFO_HE_RU_ALLOC_2x996,
};
enum nl80211_eht_gi {
  NL80211_RATE_INFO_EHT_GI_0_8,
  NL80211_RATE_INFO_EHT_GI_1_6,
  NL80211_RATE_INFO_EHT_GI_3_2,
};
enum nl80211_eht_ru_alloc {
  NL80211_RATE_INFO_EHT_RU_ALLOC_26,
  NL80211_RATE_INFO_EHT_RU_ALLOC_52,
  NL80211_RATE_INFO_EHT_RU_ALLOC_52P26,
  NL80211_RATE_INFO_EHT_RU_ALLOC_106,
  NL80211_RATE_INFO_EHT_RU_ALLOC_106P26,
  NL80211_RATE_INFO_EHT_RU_ALLOC_242,
  NL80211_RATE_INFO_EHT_RU_ALLOC_484,
  NL80211_RATE_INFO_EHT_RU_ALLOC_484P242,
  NL80211_RATE_INFO_EHT_RU_ALLOC_996,
  NL80211_RATE_INFO_EHT_RU_ALLOC_996P484,
  NL80211_RATE_INFO_EHT_RU_ALLOC_996P484P242,
  NL80211_RATE_INFO_EHT_RU_ALLOC_2x996,
  NL80211_RATE_INFO_EHT_RU_ALLOC_2x996P484,
  NL80211_RATE_INFO_EHT_RU_ALLOC_3x996,
  NL80211_RATE_INFO_EHT_RU_ALLOC_3x996P484,
  NL80211_RATE_INFO_EHT_RU_ALLOC_4x996,
};
enum nl80211_rate_info {
  __NL80211_RATE_INFO_INVALID,
  NL80211_RATE_INFO_BITRATE,
  NL80211_RATE_INFO_MCS,
  NL80211_RATE_INFO_40_MHZ_WIDTH,
  NL80211_RATE_INFO_SHORT_GI,
  NL80211_RATE_INFO_BITRATE32,
  NL80211_RATE_INFO_VHT_MCS,
  NL80211_RATE_INFO_VHT_NSS,
  NL80211_RATE_INFO_80_MHZ_WIDTH,
  NL80211_RATE_INFO_80P80_MHZ_WIDTH,
  NL80211_RATE_INFO_160_MHZ_WIDTH,
  NL80211_RATE_INFO_10_MHZ_WIDTH,
  NL80211_RATE_INFO_5_MHZ_WIDTH,
  NL80211_RATE_INFO_HE_MCS,
  NL80211_RATE_INFO_HE_NSS,
  NL80211_RATE_INFO_HE_GI,
  NL80211_RATE_INFO_HE_DCM,
  NL80211_RATE_INFO_HE_RU_ALLOC,
  NL80211_RATE_INFO_320_MHZ_WIDTH,
  NL80211_RATE_INFO_EHT_MCS,
  NL80211_RATE_INFO_EHT_NSS,
  NL80211_RATE_INFO_EHT_GI,
  NL80211_RATE_INFO_EHT_RU_ALLOC,
  NL80211_RATE_INFO_S1G_MCS,
  NL80211_RATE_INFO_S1G_NSS,
  NL80211_RATE_INFO_1_MHZ_WIDTH,
  NL80211_RATE_INFO_2_MHZ_WIDTH,
  NL80211_RATE_INFO_4_MHZ_WIDTH,
  NL80211_RATE_INFO_8_MHZ_WIDTH,
  NL80211_RATE_INFO_16_MHZ_WIDTH,
  __NL80211_RATE_INFO_AFTER_LAST,
  NL80211_RATE_INFO_MAX = __NL80211_RATE_INFO_AFTER_LAST - 1
};
enum nl80211_sta_bss_param {
  __NL80211_STA_BSS_PARAM_INVALID,
  NL80211_STA_BSS_PARAM_CTS_PROT,
  NL80211_STA_BSS_PARAM_SHORT_PREAMBLE,
  NL80211_STA_BSS_PARAM_SHORT_SLOT_TIME,
  NL80211_STA_BSS_PARAM_DTIM_PERIOD,
  NL80211_STA_BSS_PARAM_BEACON_INTERVAL,
  __NL80211_STA_BSS_PARAM_AFTER_LAST,
  NL80211_STA_BSS_PARAM_MAX = __NL80211_STA_BSS_PARAM_AFTER_LAST - 1
};
enum nl80211_sta_info {
  __NL80211_STA_INFO_INVALID,
  NL80211_STA_INFO_INACTIVE_TIME,
  NL80211_STA_INFO_RX_BYTES,
  NL80211_STA_INFO_TX_BYTES,
  NL80211_STA_INFO_LLID,
  NL80211_STA_INFO_PLID,
  NL80211_STA_INFO_PLINK_STATE,
  NL80211_STA_INFO_SIGNAL,
  NL80211_STA_INFO_TX_BITRATE,
  NL80211_STA_INFO_RX_PACKETS,
  NL80211_STA_INFO_TX_PACKETS,
  NL80211_STA_INFO_TX_RETRIES,
  NL80211_STA_INFO_TX_FAILED,
  NL80211_STA_INFO_SIGNAL_AVG,
  NL80211_STA_INFO_RX_BITRATE,
  NL80211_STA_INFO_BSS_PARAM,
  NL80211_STA_INFO_CONNECTED_TIME,
  NL80211_STA_INFO_STA_FLAGS,
  NL80211_STA_INFO_BEACON_LOSS,
  NL80211_STA_INFO_T_OFFSET,
  NL80211_STA_INFO_LOCAL_PM,
  NL80211_STA_INFO_PEER_PM,
  NL80211_STA_INFO_NONPEER_PM,
  NL80211_STA_INFO_RX_BYTES64,
  NL80211_STA_INFO_TX_BYTES64,
  NL80211_STA_INFO_CHAIN_SIGNAL,
  NL80211_STA_INFO_CHAIN_SIGNAL_AVG,
  NL80211_STA_INFO_EXPECTED_THROUGHPUT,
  NL80211_STA_INFO_RX_DROP_MISC,
  NL80211_STA_INFO_BEACON_RX,
  NL80211_STA_INFO_BEACON_SIGNAL_AVG,
  NL80211_STA_INFO_TID_STATS,
  NL80211_STA_INFO_RX_DURATION,
  NL80211_STA_INFO_PAD,
  NL80211_STA_INFO_ACK_SIGNAL,
  NL80211_STA_INFO_ACK_SIGNAL_AVG,
  NL80211_STA_INFO_RX_MPDUS,
  NL80211_STA_INFO_FCS_ERROR_COUNT,
  NL80211_STA_INFO_CONNECTED_TO_GATE,
  NL80211_STA_INFO_TX_DURATION,
  NL80211_STA_INFO_AIRTIME_WEIGHT,
  NL80211_STA_INFO_AIRTIME_LINK_METRIC,
  NL80211_STA_INFO_ASSOC_AT_BOOTTIME,
  NL80211_STA_INFO_CONNECTED_TO_AS,
  __NL80211_STA_INFO_AFTER_LAST,
  NL80211_STA_INFO_MAX = __NL80211_STA_INFO_AFTER_LAST - 1
};
#define NL80211_STA_INFO_DATA_ACK_SIGNAL_AVG NL80211_STA_INFO_ACK_SIGNAL_AVG
enum nl80211_tid_stats {
  __NL80211_TID_STATS_INVALID,
  NL80211_TID_STATS_RX_MSDU,
  NL80211_TID_STATS_TX_MSDU,
  NL80211_TID_STATS_TX_MSDU_RETRIES,
  NL80211_TID_STATS_TX_MSDU_FAILED,
  NL80211_TID_STATS_PAD,
  NL80211_TID_STATS_TXQ_STATS,
  NUM_NL80211_TID_STATS,
  NL80211_TID_STATS_MAX = NUM_NL80211_TID_STATS - 1
};
enum nl80211_txq_stats {
  __NL80211_TXQ_STATS_INVALID,
  NL80211_TXQ_STATS_BACKLOG_BYTES,
  NL80211_TXQ_STATS_BACKLOG_PACKETS,
  NL80211_TXQ_STATS_FLOWS,
  NL80211_TXQ_STATS_DROPS,
  NL80211_TXQ_STATS_ECN_MARKS,
  NL80211_TXQ_STATS_OVERLIMIT,
  NL80211_TXQ_STATS_OVERMEMORY,
  NL80211_TXQ_STATS_COLLISIONS,
  NL80211_TXQ_STATS_TX_BYTES,
  NL80211_TXQ_STATS_TX_PACKETS,
  NL80211_TXQ_STATS_MAX_FLOWS,
  NUM_NL80211_TXQ_STATS,
  NL80211_TXQ_STATS_MAX = NUM_NL80211_TXQ_STATS - 1
};
enum nl80211_mpath_flags {
  NL80211_MPATH_FLAG_ACTIVE = 1 << 0,
  NL80211_MPATH_FLAG_RESOLVING = 1 << 1,
  NL80211_MPATH_FLAG_SN_VALID = 1 << 2,
  NL80211_MPATH_FLAG_FIXED = 1 << 3,
  NL80211_MPATH_FLAG_RESOLVED = 1 << 4,
};
enum nl80211_mpath_info {
  __NL80211_MPATH_INFO_INVALID,
  NL80211_MPATH_INFO_FRAME_QLEN,
  NL80211_MPATH_INFO_SN,
  NL80211_MPATH_INFO_METRIC,
  NL80211_MPATH_INFO_EXPTIME,
  NL80211_MPATH_INFO_FLAGS,
  NL80211_MPATH_INFO_DISCOVERY_TIMEOUT,
  NL80211_MPATH_INFO_DISCOVERY_RETRIES,
  NL80211_MPATH_INFO_HOP_COUNT,
  NL80211_MPATH_INFO_PATH_CHANGE,
  __NL80211_MPATH_INFO_AFTER_LAST,
  NL80211_MPATH_INFO_MAX = __NL80211_MPATH_INFO_AFTER_LAST - 1
};
enum nl80211_band_iftype_attr {
  __NL80211_BAND_IFTYPE_ATTR_INVALID,
  NL80211_BAND_IFTYPE_ATTR_IFTYPES,
  NL80211_BAND_IFTYPE_ATTR_HE_CAP_MAC,
  NL80211_BAND_IFTYPE_ATTR_HE_CAP_PHY,
  NL80211_BAND_IFTYPE_ATTR_HE_CAP_MCS_SET,
  NL80211_BAND_IFTYPE_ATTR_HE_CAP_PPE,
  NL80211_BAND_IFTYPE_ATTR_HE_6GHZ_CAPA,
  NL80211_BAND_IFTYPE_ATTR_VENDOR_ELEMS,
  NL80211_BAND_IFTYPE_ATTR_EHT_CAP_MAC,
  NL80211_BAND_IFTYPE_ATTR_EHT_CAP_PHY,
  NL80211_BAND_IFTYPE_ATTR_EHT_CAP_MCS_SET,
  NL80211_BAND_IFTYPE_ATTR_EHT_CAP_PPE,
  __NL80211_BAND_IFTYPE_ATTR_AFTER_LAST,
  NL80211_BAND_IFTYPE_ATTR_MAX = __NL80211_BAND_IFTYPE_ATTR_AFTER_LAST - 1
};
enum nl80211_band_attr {
  __NL80211_BAND_ATTR_INVALID,
  NL80211_BAND_ATTR_FREQS,
  NL80211_BAND_ATTR_RATES,
  NL80211_BAND_ATTR_HT_MCS_SET,
  NL80211_BAND_ATTR_HT_CAPA,
  NL80211_BAND_ATTR_HT_AMPDU_FACTOR,
  NL80211_BAND_ATTR_HT_AMPDU_DENSITY,
  NL80211_BAND_ATTR_VHT_MCS_SET,
  NL80211_BAND_ATTR_VHT_CAPA,
  NL80211_BAND_ATTR_IFTYPE_DATA,
  NL80211_BAND_ATTR_EDMG_CHANNELS,
  NL80211_BAND_ATTR_EDMG_BW_CONFIG,
  NL80211_BAND_ATTR_S1G_MCS_NSS_SET,
  NL80211_BAND_ATTR_S1G_CAPA,
  __NL80211_BAND_ATTR_AFTER_LAST,
  NL80211_BAND_ATTR_MAX = __NL80211_BAND_ATTR_AFTER_LAST - 1
};
#define NL80211_BAND_ATTR_HT_CAPA NL80211_BAND_ATTR_HT_CAPA
enum nl80211_wmm_rule {
  __NL80211_WMMR_INVALID,
  NL80211_WMMR_CW_MIN,
  NL80211_WMMR_CW_MAX,
  NL80211_WMMR_AIFSN,
  NL80211_WMMR_TXOP,
  __NL80211_WMMR_LAST,
  NL80211_WMMR_MAX = __NL80211_WMMR_LAST - 1
};
enum nl80211_frequency_attr {
  __NL80211_FREQUENCY_ATTR_INVALID,
  NL80211_FREQUENCY_ATTR_FREQ,
  NL80211_FREQUENCY_ATTR_DISABLED,
  NL80211_FREQUENCY_ATTR_NO_IR,
  __NL80211_FREQUENCY_ATTR_NO_IBSS,
  NL80211_FREQUENCY_ATTR_RADAR,
  NL80211_FREQUENCY_ATTR_MAX_TX_POWER,
  NL80211_FREQUENCY_ATTR_DFS_STATE,
  NL80211_FREQUENCY_ATTR_DFS_TIME,
  NL80211_FREQUENCY_ATTR_NO_HT40_MINUS,
  NL80211_FREQUENCY_ATTR_NO_HT40_PLUS,
  NL80211_FREQUENCY_ATTR_NO_80MHZ,
  NL80211_FREQUENCY_ATTR_NO_160MHZ,
  NL80211_FREQUENCY_ATTR_DFS_CAC_TIME,
  NL80211_FREQUENCY_ATTR_INDOOR_ONLY,
  NL80211_FREQUENCY_ATTR_IR_CONCURRENT,
  NL80211_FREQUENCY_ATTR_NO_20MHZ,
  NL80211_FREQUENCY_ATTR_NO_10MHZ,
  NL80211_FREQUENCY_ATTR_WMM,
  NL80211_FREQUENCY_ATTR_NO_HE,
  NL80211_FREQUENCY_ATTR_OFFSET,
  NL80211_FREQUENCY_ATTR_1MHZ,
  NL80211_FREQUENCY_ATTR_2MHZ,
  NL80211_FREQUENCY_ATTR_4MHZ,
  NL80211_FREQUENCY_ATTR_8MHZ,
  NL80211_FREQUENCY_ATTR_16MHZ,
  NL80211_FREQUENCY_ATTR_NO_320MHZ,
  NL80211_FREQUENCY_ATTR_NO_EHT,
  __NL80211_FREQUENCY_ATTR_AFTER_LAST,
  NL80211_FREQUENCY_ATTR_MAX = __NL80211_FREQUENCY_ATTR_AFTER_LAST - 1
};
#define NL80211_FREQUENCY_ATTR_MAX_TX_POWER NL80211_FREQUENCY_ATTR_MAX_TX_POWER
#define NL80211_FREQUENCY_ATTR_PASSIVE_SCAN NL80211_FREQUENCY_ATTR_NO_IR
#define NL80211_FREQUENCY_ATTR_NO_IBSS NL80211_FREQUENCY_ATTR_NO_IR
#define NL80211_FREQUENCY_ATTR_NO_IR NL80211_FREQUENCY_ATTR_NO_IR
#define NL80211_FREQUENCY_ATTR_GO_CONCURRENT NL80211_FREQUENCY_ATTR_IR_CONCURRENT
enum nl80211_bitrate_attr {
  __NL80211_BITRATE_ATTR_INVALID,
  NL80211_BITRATE_ATTR_RATE,
  NL80211_BITRATE_ATTR_2GHZ_SHORTPREAMBLE,
  __NL80211_BITRATE_ATTR_AFTER_LAST,
  NL80211_BITRATE_ATTR_MAX = __NL80211_BITRATE_ATTR_AFTER_LAST - 1
};
enum nl80211_reg_initiator {
  NL80211_REGDOM_SET_BY_CORE,
  NL80211_REGDOM_SET_BY_USER,
  NL80211_REGDOM_SET_BY_DRIVER,
  NL80211_REGDOM_SET_BY_COUNTRY_IE,
};
enum nl80211_reg_type {
  NL80211_REGDOM_TYPE_COUNTRY,
  NL80211_REGDOM_TYPE_WORLD,
  NL80211_REGDOM_TYPE_CUSTOM_WORLD,
  NL80211_REGDOM_TYPE_INTERSECTION,
};
enum nl80211_reg_rule_attr {
  __NL80211_REG_RULE_ATTR_INVALID,
  NL80211_ATTR_REG_RULE_FLAGS,
  NL80211_ATTR_FREQ_RANGE_START,
  NL80211_ATTR_FREQ_RANGE_END,
  NL80211_ATTR_FREQ_RANGE_MAX_BW,
  NL80211_ATTR_POWER_RULE_MAX_ANT_GAIN,
  NL80211_ATTR_POWER_RULE_MAX_EIRP,
  NL80211_ATTR_DFS_CAC_TIME,
  __NL80211_REG_RULE_ATTR_AFTER_LAST,
  NL80211_REG_RULE_ATTR_MAX = __NL80211_REG_RULE_ATTR_AFTER_LAST - 1
};
enum nl80211_sched_scan_match_attr {
  __NL80211_SCHED_SCAN_MATCH_ATTR_INVALID,
  NL80211_SCHED_SCAN_MATCH_ATTR_SSID,
  NL80211_SCHED_SCAN_MATCH_ATTR_RSSI,
  NL80211_SCHED_SCAN_MATCH_ATTR_RELATIVE_RSSI,
  NL80211_SCHED_SCAN_MATCH_ATTR_RSSI_ADJUST,
  NL80211_SCHED_SCAN_MATCH_ATTR_BSSID,
  NL80211_SCHED_SCAN_MATCH_PER_BAND_RSSI,
  __NL80211_SCHED_SCAN_MATCH_ATTR_AFTER_LAST,
  NL80211_SCHED_SCAN_MATCH_ATTR_MAX = __NL80211_SCHED_SCAN_MATCH_ATTR_AFTER_LAST - 1
};
#define NL80211_ATTR_SCHED_SCAN_MATCH_SSID NL80211_SCHED_SCAN_MATCH_ATTR_SSID
enum nl80211_reg_rule_flags {
  NL80211_RRF_NO_OFDM = 1 << 0,
  NL80211_RRF_NO_CCK = 1 << 1,
  NL80211_RRF_NO_INDOOR = 1 << 2,
  NL80211_RRF_NO_OUTDOOR = 1 << 3,
  NL80211_RRF_DFS = 1 << 4,
  NL80211_RRF_PTP_ONLY = 1 << 5,
  NL80211_RRF_PTMP_ONLY = 1 << 6,
  NL80211_RRF_NO_IR = 1 << 7,
  __NL80211_RRF_NO_IBSS = 1 << 8,
  NL80211_RRF_AUTO_BW = 1 << 11,
  NL80211_RRF_IR_CONCURRENT = 1 << 12,
  NL80211_RRF_NO_HT40MINUS = 1 << 13,
  NL80211_RRF_NO_HT40PLUS = 1 << 14,
  NL80211_RRF_NO_80MHZ = 1 << 15,
  NL80211_RRF_NO_160MHZ = 1 << 16,
  NL80211_RRF_NO_HE = 1 << 17,
  NL80211_RRF_NO_320MHZ = 1 << 18,
  NL80211_RRF_NO_EHT = 1 << 19,
};
#define NL80211_RRF_PASSIVE_SCAN NL80211_RRF_NO_IR
#define NL80211_RRF_NO_IBSS NL80211_RRF_NO_IR
#define NL80211_RRF_NO_IR NL80211_RRF_NO_IR
#define NL80211_RRF_NO_HT40 (NL80211_RRF_NO_HT40MINUS | NL80211_RRF_NO_HT40PLUS)
#define NL80211_RRF_GO_CONCURRENT NL80211_RRF_IR_CONCURRENT
#define NL80211_RRF_NO_IR_ALL (NL80211_RRF_NO_IR | __NL80211_RRF_NO_IBSS)
enum nl80211_dfs_regions {
  NL80211_DFS_UNSET = 0,
  NL80211_DFS_FCC = 1,
  NL80211_DFS_ETSI = 2,
  NL80211_DFS_JP = 3,
};
enum nl80211_user_reg_hint_type {
  NL80211_USER_REG_HINT_USER = 0,
  NL80211_USER_REG_HINT_CELL_BASE = 1,
  NL80211_USER_REG_HINT_INDOOR = 2,
};
enum nl80211_survey_info {
  __NL80211_SURVEY_INFO_INVALID,
  NL80211_SURVEY_INFO_FREQUENCY,
  NL80211_SURVEY_INFO_NOISE,
  NL80211_SURVEY_INFO_IN_USE,
  NL80211_SURVEY_INFO_TIME,
  NL80211_SURVEY_INFO_TIME_BUSY,
  NL80211_SURVEY_INFO_TIME_EXT_BUSY,
  NL80211_SURVEY_INFO_TIME_RX,
  NL80211_SURVEY_INFO_TIME_TX,
  NL80211_SURVEY_INFO_TIME_SCAN,
  NL80211_SURVEY_INFO_PAD,
  NL80211_SURVEY_INFO_TIME_BSS_RX,
  NL80211_SURVEY_INFO_FREQUENCY_OFFSET,
  __NL80211_SURVEY_INFO_AFTER_LAST,
  NL80211_SURVEY_INFO_MAX = __NL80211_SURVEY_INFO_AFTER_LAST - 1
};
#define NL80211_SURVEY_INFO_CHANNEL_TIME NL80211_SURVEY_INFO_TIME
#define NL80211_SURVEY_INFO_CHANNEL_TIME_BUSY NL80211_SURVEY_INFO_TIME_BUSY
#define NL80211_SURVEY_INFO_CHANNEL_TIME_EXT_BUSY NL80211_SURVEY_INFO_TIME_EXT_BUSY
#define NL80211_SURVEY_INFO_CHANNEL_TIME_RX NL80211_SURVEY_INFO_TIME_RX
#define NL80211_SURVEY_INFO_CHANNEL_TIME_TX NL80211_SURVEY_INFO_TIME_TX
enum nl80211_mntr_flags {
  __NL80211_MNTR_FLAG_INVALID,
  NL80211_MNTR_FLAG_FCSFAIL,
  NL80211_MNTR_FLAG_PLCPFAIL,
  NL80211_MNTR_FLAG_CONTROL,
  NL80211_MNTR_FLAG_OTHER_BSS,
  NL80211_MNTR_FLAG_COOK_FRAMES,
  NL80211_MNTR_FLAG_ACTIVE,
  __NL80211_MNTR_FLAG_AFTER_LAST,
  NL80211_MNTR_FLAG_MAX = __NL80211_MNTR_FLAG_AFTER_LAST - 1
};
enum nl80211_mesh_power_mode {
  NL80211_MESH_POWER_UNKNOWN,
  NL80211_MESH_POWER_ACTIVE,
  NL80211_MESH_POWER_LIGHT_SLEEP,
  NL80211_MESH_POWER_DEEP_SLEEP,
  __NL80211_MESH_POWER_AFTER_LAST,
  NL80211_MESH_POWER_MAX = __NL80211_MESH_POWER_AFTER_LAST - 1
};
enum nl80211_meshconf_params {
  __NL80211_MESHCONF_INVALID,
  NL80211_MESHCONF_RETRY_TIMEOUT,
  NL80211_MESHCONF_CONFIRM_TIMEOUT,
  NL80211_MESHCONF_HOLDING_TIMEOUT,
  NL80211_MESHCONF_MAX_PEER_LINKS,
  NL80211_MESHCONF_MAX_RETRIES,
  NL80211_MESHCONF_TTL,
  NL80211_MESHCONF_AUTO_OPEN_PLINKS,
  NL80211_MESHCONF_HWMP_MAX_PREQ_RETRIES,
  NL80211_MESHCONF_PATH_REFRESH_TIME,
  NL80211_MESHCONF_MIN_DISCOVERY_TIMEOUT,
  NL80211_MESHCONF_HWMP_ACTIVE_PATH_TIMEOUT,
  NL80211_MESHCONF_HWMP_PREQ_MIN_INTERVAL,
  NL80211_MESHCONF_HWMP_NET_DIAM_TRVS_TIME,
  NL80211_MESHCONF_HWMP_ROOTMODE,
  NL80211_MESHCONF_ELEMENT_TTL,
  NL80211_MESHCONF_HWMP_RANN_INTERVAL,
  NL80211_MESHCONF_GATE_ANNOUNCEMENTS,
  NL80211_MESHCONF_HWMP_PERR_MIN_INTERVAL,
  NL80211_MESHCONF_FORWARDING,
  NL80211_MESHCONF_RSSI_THRESHOLD,
  NL80211_MESHCONF_SYNC_OFFSET_MAX_NEIGHBOR,
  NL80211_MESHCONF_HT_OPMODE,
  NL80211_MESHCONF_HWMP_PATH_TO_ROOT_TIMEOUT,
  NL80211_MESHCONF_HWMP_ROOT_INTERVAL,
  NL80211_MESHCONF_HWMP_CONFIRMATION_INTERVAL,
  NL80211_MESHCONF_POWER_MODE,
  NL80211_MESHCONF_AWAKE_WINDOW,
  NL80211_MESHCONF_PLINK_TIMEOUT,
  NL80211_MESHCONF_CONNECTED_TO_GATE,
  NL80211_MESHCONF_NOLEARN,
  NL80211_MESHCONF_CONNECTED_TO_AS,
  __NL80211_MESHCONF_ATTR_AFTER_LAST,
  NL80211_MESHCONF_ATTR_MAX = __NL80211_MESHCONF_ATTR_AFTER_LAST - 1
};
enum nl80211_mesh_setup_params {
  __NL80211_MESH_SETUP_INVALID,
  NL80211_MESH_SETUP_ENABLE_VENDOR_PATH_SEL,
  NL80211_MESH_SETUP_ENABLE_VENDOR_METRIC,
  NL80211_MESH_SETUP_IE,
  NL80211_MESH_SETUP_USERSPACE_AUTH,
  NL80211_MESH_SETUP_USERSPACE_AMPE,
  NL80211_MESH_SETUP_ENABLE_VENDOR_SYNC,
  NL80211_MESH_SETUP_USERSPACE_MPM,
  NL80211_MESH_SETUP_AUTH_PROTOCOL,
  __NL80211_MESH_SETUP_ATTR_AFTER_LAST,
  NL80211_MESH_SETUP_ATTR_MAX = __NL80211_MESH_SETUP_ATTR_AFTER_LAST - 1
};
enum nl80211_txq_attr {
  __NL80211_TXQ_ATTR_INVALID,
  NL80211_TXQ_ATTR_AC,
  NL80211_TXQ_ATTR_TXOP,
  NL80211_TXQ_ATTR_CWMIN,
  NL80211_TXQ_ATTR_CWMAX,
  NL80211_TXQ_ATTR_AIFS,
  __NL80211_TXQ_ATTR_AFTER_LAST,
  NL80211_TXQ_ATTR_MAX = __NL80211_TXQ_ATTR_AFTER_LAST - 1
};
enum nl80211_ac {
  NL80211_AC_VO,
  NL80211_AC_VI,
  NL80211_AC_BE,
  NL80211_AC_BK,
  NL80211_NUM_ACS
};
#define NL80211_TXQ_ATTR_QUEUE NL80211_TXQ_ATTR_AC
#define NL80211_TXQ_Q_VO NL80211_AC_VO
#define NL80211_TXQ_Q_VI NL80211_AC_VI
#define NL80211_TXQ_Q_BE NL80211_AC_BE
#define NL80211_TXQ_Q_BK NL80211_AC_BK
enum nl80211_channel_type {
  NL80211_CHAN_NO_HT,
  NL80211_CHAN_HT20,
  NL80211_CHAN_HT40MINUS,
  NL80211_CHAN_HT40PLUS
};
enum nl80211_key_mode {
  NL80211_KEY_RX_TX,
  NL80211_KEY_NO_TX,
  NL80211_KEY_SET_TX
};
enum nl80211_chan_width {
  NL80211_CHAN_WIDTH_20_NOHT,
  NL80211_CHAN_WIDTH_20,
  NL80211_CHAN_WIDTH_40,
  NL80211_CHAN_WIDTH_80,
  NL80211_CHAN_WIDTH_80P80,
  NL80211_CHAN_WIDTH_160,
  NL80211_CHAN_WIDTH_5,
  NL80211_CHAN_WIDTH_10,
  NL80211_CHAN_WIDTH_1,
  NL80211_CHAN_WIDTH_2,
  NL80211_CHAN_WIDTH_4,
  NL80211_CHAN_WIDTH_8,
  NL80211_CHAN_WIDTH_16,
  NL80211_CHAN_WIDTH_320,
};
enum nl80211_bss_scan_width {
  NL80211_BSS_CHAN_WIDTH_20,
  NL80211_BSS_CHAN_WIDTH_10,
  NL80211_BSS_CHAN_WIDTH_5,
  NL80211_BSS_CHAN_WIDTH_1,
  NL80211_BSS_CHAN_WIDTH_2,
};
enum nl80211_bss {
  __NL80211_BSS_INVALID,
  NL80211_BSS_BSSID,
  NL80211_BSS_FREQUENCY,
  NL80211_BSS_TSF,
  NL80211_BSS_BEACON_INTERVAL,
  NL80211_BSS_CAPABILITY,
  NL80211_BSS_INFORMATION_ELEMENTS,
  NL80211_BSS_SIGNAL_MBM,
  NL80211_BSS_SIGNAL_UNSPEC,
  NL80211_BSS_STATUS,
  NL80211_BSS_SEEN_MS_AGO,
  NL80211_BSS_BEACON_IES,
  NL80211_BSS_CHAN_WIDTH,
  NL80211_BSS_BEACON_TSF,
  NL80211_BSS_PRESP_DATA,
  NL80211_BSS_LAST_SEEN_BOOTTIME,
  NL80211_BSS_PAD,
  NL80211_BSS_PARENT_TSF,
  NL80211_BSS_PARENT_BSSID,
  NL80211_BSS_CHAIN_SIGNAL,
  NL80211_BSS_FREQUENCY_OFFSET,
  NL80211_BSS_MLO_LINK_ID,
  NL80211_BSS_MLD_ADDR,
  __NL80211_BSS_AFTER_LAST,
  NL80211_BSS_MAX = __NL80211_BSS_AFTER_LAST - 1
};
enum nl80211_bss_status {
  NL80211_BSS_STATUS_AUTHENTICATED,
  NL80211_BSS_STATUS_ASSOCIATED,
  NL80211_BSS_STATUS_IBSS_JOINED,
};
enum nl80211_auth_type {
  NL80211_AUTHTYPE_OPEN_SYSTEM,
  NL80211_AUTHTYPE_SHARED_KEY,
  NL80211_AUTHTYPE_FT,
  NL80211_AUTHTYPE_NETWORK_EAP,
  NL80211_AUTHTYPE_SAE,
  NL80211_AUTHTYPE_FILS_SK,
  NL80211_AUTHTYPE_FILS_SK_PFS,
  NL80211_AUTHTYPE_FILS_PK,
  __NL80211_AUTHTYPE_NUM,
  NL80211_AUTHTYPE_MAX = __NL80211_AUTHTYPE_NUM - 1,
  NL80211_AUTHTYPE_AUTOMATIC
};
enum nl80211_key_type {
  NL80211_KEYTYPE_GROUP,
  NL80211_KEYTYPE_PAIRWISE,
  NL80211_KEYTYPE_PEERKEY,
  NUM_NL80211_KEYTYPES
};
enum nl80211_mfp {
  NL80211_MFP_NO,
  NL80211_MFP_REQUIRED,
  NL80211_MFP_OPTIONAL,
};
enum nl80211_wpa_versions {
  NL80211_WPA_VERSION_1 = 1 << 0,
  NL80211_WPA_VERSION_2 = 1 << 1,
  NL80211_WPA_VERSION_3 = 1 << 2,
};
enum nl80211_key_default_types {
  __NL80211_KEY_DEFAULT_TYPE_INVALID,
  NL80211_KEY_DEFAULT_TYPE_UNICAST,
  NL80211_KEY_DEFAULT_TYPE_MULTICAST,
  NUM_NL80211_KEY_DEFAULT_TYPES
};
enum nl80211_key_attributes {
  __NL80211_KEY_INVALID,
  NL80211_KEY_DATA,
  NL80211_KEY_IDX,
  NL80211_KEY_CIPHER,
  NL80211_KEY_SEQ,
  NL80211_KEY_DEFAULT,
  NL80211_KEY_DEFAULT_MGMT,
  NL80211_KEY_TYPE,
  NL80211_KEY_DEFAULT_TYPES,
  NL80211_KEY_MODE,
  NL80211_KEY_DEFAULT_BEACON,
  __NL80211_KEY_AFTER_LAST,
  NL80211_KEY_MAX = __NL80211_KEY_AFTER_LAST - 1
};
enum nl80211_tx_rate_attributes {
  __NL80211_TXRATE_INVALID,
  NL80211_TXRATE_LEGACY,
  NL80211_TXRATE_HT,
  NL80211_TXRATE_VHT,
  NL80211_TXRATE_GI,
  NL80211_TXRATE_HE,
  NL80211_TXRATE_HE_GI,
  NL80211_TXRATE_HE_LTF,
  __NL80211_TXRATE_AFTER_LAST,
  NL80211_TXRATE_MAX = __NL80211_TXRATE_AFTER_LAST - 1
};
#define NL80211_TXRATE_MCS NL80211_TXRATE_HT
#define NL80211_VHT_NSS_MAX 8
struct nl80211_txrate_vht {
  __u16 mcs[NL80211_VHT_NSS_MAX];
};
#define NL80211_HE_NSS_MAX 8
struct nl80211_txrate_he {
  __u16 mcs[NL80211_HE_NSS_MAX];
};
enum nl80211_txrate_gi {
  NL80211_TXRATE_DEFAULT_GI,
  NL80211_TXRATE_FORCE_SGI,
  NL80211_TXRATE_FORCE_LGI,
};
enum nl80211_band {
  NL80211_BAND_2GHZ,
  NL80211_BAND_5GHZ,
  NL80211_BAND_60GHZ,
  NL80211_BAND_6GHZ,
  NL80211_BAND_S1GHZ,
  NL80211_BAND_LC,
  NUM_NL80211_BANDS,
};
enum nl80211_ps_state {
  NL80211_PS_DISABLED,
  NL80211_PS_ENABLED,
};
enum nl80211_attr_cqm {
  __NL80211_ATTR_CQM_INVALID,
  NL80211_ATTR_CQM_RSSI_THOLD,
  NL80211_ATTR_CQM_RSSI_HYST,
  NL80211_ATTR_CQM_RSSI_THRESHOLD_EVENT,
  NL80211_ATTR_CQM_PKT_LOSS_EVENT,
  NL80211_ATTR_CQM_TXE_RATE,
  NL80211_ATTR_CQM_TXE_PKTS,
  NL80211_ATTR_CQM_TXE_INTVL,
  NL80211_ATTR_CQM_BEACON_LOSS_EVENT,
  NL80211_ATTR_CQM_RSSI_LEVEL,
  __NL80211_ATTR_CQM_AFTER_LAST,
  NL80211_ATTR_CQM_MAX = __NL80211_ATTR_CQM_AFTER_LAST - 1
};
enum nl80211_cqm_rssi_threshold_event {
  NL80211_CQM_RSSI_THRESHOLD_EVENT_LOW,
  NL80211_CQM_RSSI_THRESHOLD_EVENT_HIGH,
  NL80211_CQM_RSSI_BEACON_LOSS_EVENT,
};
enum nl80211_tx_power_setting {
  NL80211_TX_POWER_AUTOMATIC,
  NL80211_TX_POWER_LIMITED,
  NL80211_TX_POWER_FIXED,
};
enum nl80211_tid_config {
  NL80211_TID_CONFIG_ENABLE,
  NL80211_TID_CONFIG_DISABLE,
};
enum nl80211_tx_rate_setting {
  NL80211_TX_RATE_AUTOMATIC,
  NL80211_TX_RATE_LIMITED,
  NL80211_TX_RATE_FIXED,
};
enum nl80211_tid_config_attr {
  __NL80211_TID_CONFIG_ATTR_INVALID,
  NL80211_TID_CONFIG_ATTR_PAD,
  NL80211_TID_CONFIG_ATTR_VIF_SUPP,
  NL80211_TID_CONFIG_ATTR_PEER_SUPP,
  NL80211_TID_CONFIG_ATTR_OVERRIDE,
  NL80211_TID_CONFIG_ATTR_TIDS,
  NL80211_TID_CONFIG_ATTR_NOACK,
  NL80211_TID_CONFIG_ATTR_RETRY_SHORT,
  NL80211_TID_CONFIG_ATTR_RETRY_LONG,
  NL80211_TID_CONFIG_ATTR_AMPDU_CTRL,
  NL80211_TID_CONFIG_ATTR_RTSCTS_CTRL,
  NL80211_TID_CONFIG_ATTR_AMSDU_CTRL,
  NL80211_TID_CONFIG_ATTR_TX_RATE_TYPE,
  NL80211_TID_CONFIG_ATTR_TX_RATE,
  __NL80211_TID_CONFIG_ATTR_AFTER_LAST,
  NL80211_TID_CONFIG_ATTR_MAX = __NL80211_TID_CONFIG_ATTR_AFTER_LAST - 1
};
enum nl80211_packet_pattern_attr {
  __NL80211_PKTPAT_INVALID,
  NL80211_PKTPAT_MASK,
  NL80211_PKTPAT_PATTERN,
  NL80211_PKTPAT_OFFSET,
  NUM_NL80211_PKTPAT,
  MAX_NL80211_PKTPAT = NUM_NL80211_PKTPAT - 1,
};
struct nl80211_pattern_support {
  __u32 max_patterns;
  __u32 min_pattern_len;
  __u32 max_pattern_len;
  __u32 max_pkt_offset;
} __attribute__((packed));
#define __NL80211_WOWLAN_PKTPAT_INVALID __NL80211_PKTPAT_INVALID
#define NL80211_WOWLAN_PKTPAT_MASK NL80211_PKTPAT_MASK
#define NL80211_WOWLAN_PKTPAT_PATTERN NL80211_PKTPAT_PATTERN
#define NL80211_WOWLAN_PKTPAT_OFFSET NL80211_PKTPAT_OFFSET
#define NUM_NL80211_WOWLAN_PKTPAT NUM_NL80211_PKTPAT
#define MAX_NL80211_WOWLAN_PKTPAT MAX_NL80211_PKTPAT
#define nl80211_wowlan_pattern_support nl80211_pattern_support
enum nl80211_wowlan_triggers {
  __NL80211_WOWLAN_TRIG_INVALID,
  NL80211_WOWLAN_TRIG_ANY,
  NL80211_WOWLAN_TRIG_DISCONNECT,
  NL80211_WOWLAN_TRIG_MAGIC_PKT,
  NL80211_WOWLAN_TRIG_PKT_PATTERN,
  NL80211_WOWLAN_TRIG_GTK_REKEY_SUPPORTED,
  NL80211_WOWLAN_TRIG_GTK_REKEY_FAILURE,
  NL80211_WOWLAN_TRIG_EAP_IDENT_REQUEST,
  NL80211_WOWLAN_TRIG_4WAY_HANDSHAKE,
  NL80211_WOWLAN_TRIG_RFKILL_RELEASE,
  NL80211_WOWLAN_TRIG_WAKEUP_PKT_80211,
  NL80211_WOWLAN_TRIG_WAKEUP_PKT_80211_LEN,
  NL80211_WOWLAN_TRIG_WAKEUP_PKT_8023,
  NL80211_WOWLAN_TRIG_WAKEUP_PKT_8023_LEN,
  NL80211_WOWLAN_TRIG_TCP_CONNECTION,
  NL80211_WOWLAN_TRIG_WAKEUP_TCP_MATCH,
  NL80211_WOWLAN_TRIG_WAKEUP_TCP_CONNLOST,
  NL80211_WOWLAN_TRIG_WAKEUP_TCP_NOMORETOKENS,
  NL80211_WOWLAN_TRIG_NET_DETECT,
  NL80211_WOWLAN_TRIG_NET_DETECT_RESULTS,
  NUM_NL80211_WOWLAN_TRIG,
  MAX_NL80211_WOWLAN_TRIG = NUM_NL80211_WOWLAN_TRIG - 1
};
struct nl80211_wowlan_tcp_data_seq {
  __u32 start, offset, len;
};
struct nl80211_wowlan_tcp_data_token {
  __u32 offset, len;
  __u8 token_stream[];
};
struct nl80211_wowlan_tcp_data_token_feature {
  __u32 min_len, max_len, bufsize;
};
enum nl80211_wowlan_tcp_attrs {
  __NL80211_WOWLAN_TCP_INVALID,
  NL80211_WOWLAN_TCP_SRC_IPV4,
  NL80211_WOWLAN_TCP_DST_IPV4,
  NL80211_WOWLAN_TCP_DST_MAC,
  NL80211_WOWLAN_TCP_SRC_PORT,
  NL80211_WOWLAN_TCP_DST_PORT,
  NL80211_WOWLAN_TCP_DATA_PAYLOAD,
  NL80211_WOWLAN_TCP_DATA_PAYLOAD_SEQ,
  NL80211_WOWLAN_TCP_DATA_PAYLOAD_TOKEN,
  NL80211_WOWLAN_TCP_DATA_INTERVAL,
  NL80211_WOWLAN_TCP_WAKE_PAYLOAD,
  NL80211_WOWLAN_TCP_WAKE_MASK,
  NUM_NL80211_WOWLAN_TCP,
  MAX_NL80211_WOWLAN_TCP = NUM_NL80211_WOWLAN_TCP - 1
};
struct nl80211_coalesce_rule_support {
  __u32 max_rules;
  struct nl80211_pattern_support pat;
  __u32 max_delay;
} __attribute__((packed));
enum nl80211_attr_coalesce_rule {
  __NL80211_COALESCE_RULE_INVALID,
  NL80211_ATTR_COALESCE_RULE_DELAY,
  NL80211_ATTR_COALESCE_RULE_CONDITION,
  NL80211_ATTR_COALESCE_RULE_PKT_PATTERN,
  NUM_NL80211_ATTR_COALESCE_RULE,
  NL80211_ATTR_COALESCE_RULE_MAX = NUM_NL80211_ATTR_COALESCE_RULE - 1
};
enum nl80211_coalesce_condition {
  NL80211_COALESCE_CONDITION_MATCH,
  NL80211_COALESCE_CONDITION_NO_MATCH
};
enum nl80211_iface_limit_attrs {
  NL80211_IFACE_LIMIT_UNSPEC,
  NL80211_IFACE_LIMIT_MAX,
  NL80211_IFACE_LIMIT_TYPES,
  NUM_NL80211_IFACE_LIMIT,
  MAX_NL80211_IFACE_LIMIT = NUM_NL80211_IFACE_LIMIT - 1
};
enum nl80211_if_combination_attrs {
  NL80211_IFACE_COMB_UNSPEC,
  NL80211_IFACE_COMB_LIMITS,
  NL80211_IFACE_COMB_MAXNUM,
  NL80211_IFACE_COMB_STA_AP_BI_MATCH,
  NL80211_IFACE_COMB_NUM_CHANNELS,
  NL80211_IFACE_COMB_RADAR_DETECT_WIDTHS,
  NL80211_IFACE_COMB_RADAR_DETECT_REGIONS,
  NL80211_IFACE_COMB_BI_MIN_GCD,
  NUM_NL80211_IFACE_COMB,
  MAX_NL80211_IFACE_COMB = NUM_NL80211_IFACE_COMB - 1
};
enum nl80211_plink_state {
  NL80211_PLINK_LISTEN,
  NL80211_PLINK_OPN_SNT,
  NL80211_PLINK_OPN_RCVD,
  NL80211_PLINK_CNF_RCVD,
  NL80211_PLINK_ESTAB,
  NL80211_PLINK_HOLDING,
  NL80211_PLINK_BLOCKED,
  NUM_NL80211_PLINK_STATES,
  MAX_NL80211_PLINK_STATES = NUM_NL80211_PLINK_STATES - 1
};
enum plink_actions {
  NL80211_PLINK_ACTION_NO_ACTION,
  NL80211_PLINK_ACTION_OPEN,
  NL80211_PLINK_ACTION_BLOCK,
  NUM_NL80211_PLINK_ACTIONS,
};
#define NL80211_KCK_LEN 16
#define NL80211_KEK_LEN 16
#define NL80211_KCK_EXT_LEN 24
#define NL80211_KEK_EXT_LEN 32
#define NL80211_KCK_EXT_LEN_32 32
#define NL80211_REPLAY_CTR_LEN 8
enum nl80211_rekey_data {
  __NL80211_REKEY_DATA_INVALID,
  NL80211_REKEY_DATA_KEK,
  NL80211_REKEY_DATA_KCK,
  NL80211_REKEY_DATA_REPLAY_CTR,
  NL80211_REKEY_DATA_AKM,
  NUM_NL80211_REKEY_DATA,
  MAX_NL80211_REKEY_DATA = NUM_NL80211_REKEY_DATA - 1
};
enum nl80211_hidden_ssid {
  NL80211_HIDDEN_SSID_NOT_IN_USE,
  NL80211_HIDDEN_SSID_ZERO_LEN,
  NL80211_HIDDEN_SSID_ZERO_CONTENTS
};
enum nl80211_sta_wme_attr {
  __NL80211_STA_WME_INVALID,
  NL80211_STA_WME_UAPSD_QUEUES,
  NL80211_STA_WME_MAX_SP,
  __NL80211_STA_WME_AFTER_LAST,
  NL80211_STA_WME_MAX = __NL80211_STA_WME_AFTER_LAST - 1
};
enum nl80211_pmksa_candidate_attr {
  __NL80211_PMKSA_CANDIDATE_INVALID,
  NL80211_PMKSA_CANDIDATE_INDEX,
  NL80211_PMKSA_CANDIDATE_BSSID,
  NL80211_PMKSA_CANDIDATE_PREAUTH,
  NUM_NL80211_PMKSA_CANDIDATE,
  MAX_NL80211_PMKSA_CANDIDATE = NUM_NL80211_PMKSA_CANDIDATE - 1
};
enum nl80211_tdls_operation {
  NL80211_TDLS_DISCOVERY_REQ,
  NL80211_TDLS_SETUP,
  NL80211_TDLS_TEARDOWN,
  NL80211_TDLS_ENABLE_LINK,
  NL80211_TDLS_DISABLE_LINK,
};
enum nl80211_ap_sme_features {
  NL80211_AP_SME_SA_QUERY_OFFLOAD = 1 << 0,
};
enum nl80211_feature_flags {
  NL80211_FEATURE_SK_TX_STATUS = 1 << 0,
  NL80211_FEATURE_HT_IBSS = 1 << 1,
  NL80211_FEATURE_INACTIVITY_TIMER = 1 << 2,
  NL80211_FEATURE_CELL_BASE_REG_HINTS = 1 << 3,
  NL80211_FEATURE_P2P_DEVICE_NEEDS_CHANNEL = 1 << 4,
  NL80211_FEATURE_SAE = 1 << 5,
  NL80211_FEATURE_LOW_PRIORITY_SCAN = 1 << 6,
  NL80211_FEATURE_SCAN_FLUSH = 1 << 7,
  NL80211_FEATURE_AP_SCAN = 1 << 8,
  NL80211_FEATURE_VIF_TXPOWER = 1 << 9,
  NL80211_FEATURE_NEED_OBSS_SCAN = 1 << 10,
  NL80211_FEATURE_P2P_GO_CTWIN = 1 << 11,
  NL80211_FEATURE_P2P_GO_OPPPS = 1 << 12,
  NL80211_FEATURE_ADVERTISE_CHAN_LIMITS = 1 << 14,
  NL80211_FEATURE_FULL_AP_CLIENT_STATE = 1 << 15,
  NL80211_FEATURE_USERSPACE_MPM = 1 << 16,
  NL80211_FEATURE_ACTIVE_MONITOR = 1 << 17,
  NL80211_FEATURE_AP_MODE_CHAN_WIDTH_CHANGE = 1 << 18,
  NL80211_FEATURE_DS_PARAM_SET_IE_IN_PROBES = 1 << 19,
  NL80211_FEATURE_WFA_TPC_IE_IN_PROBES = 1 << 20,
  NL80211_FEATURE_QUIET = 1 << 21,
  NL80211_FEATURE_TX_POWER_INSERTION = 1 << 22,
  NL80211_FEATURE_ACKTO_ESTIMATION = 1 << 23,
  NL80211_FEATURE_STATIC_SMPS = 1 << 24,
  NL80211_FEATURE_DYNAMIC_SMPS = 1 << 25,
  NL80211_FEATURE_SUPPORTS_WMM_ADMISSION = 1 << 26,
  NL80211_FEATURE_MAC_ON_CREATE = 1 << 27,
  NL80211_FEATURE_TDLS_CHANNEL_SWITCH = 1 << 28,
  NL80211_FEATURE_SCAN_RANDOM_MAC_ADDR = 1 << 29,
  NL80211_FEATURE_SCHED_SCAN_RANDOM_MAC_ADDR = 1 << 30,
  NL80211_FEATURE_ND_RANDOM_MAC_ADDR = 1U << 31,
};
enum nl80211_ext_feature_index {
  NL80211_EXT_FEATURE_VHT_IBSS,
  NL80211_EXT_FEATURE_RRM,
  NL80211_EXT_FEATURE_MU_MIMO_AIR_SNIFFER,
  NL80211_EXT_FEATURE_SCAN_START_TIME,
  NL80211_EXT_FEATURE_BSS_PARENT_TSF,
  NL80211_EXT_FEATURE_SET_SCAN_DWELL,
  NL80211_EXT_FEATURE_BEACON_RATE_LEGACY,
  NL80211_EXT_FEATURE_BEACON_RATE_HT,
  NL80211_EXT_FEATURE_BEACON_RATE_VHT,
  NL80211_EXT_FEATURE_FILS_STA,
  NL80211_EXT_FEATURE_MGMT_TX_RANDOM_TA,
  NL80211_EXT_FEATURE_MGMT_TX_RANDOM_TA_CONNECTED,
  NL80211_EXT_FEATURE_SCHED_SCAN_RELATIVE_RSSI,
  NL80211_EXT_FEATURE_CQM_RSSI_LIST,
  NL80211_EXT_FEATURE_FILS_SK_OFFLOAD,
  NL80211_EXT_FEATURE_4WAY_HANDSHAKE_STA_PSK,
  NL80211_EXT_FEATURE_4WAY_HANDSHAKE_STA_1X,
  NL80211_EXT_FEATURE_FILS_MAX_CHANNEL_TIME,
  NL80211_EXT_FEATURE_ACCEPT_BCAST_PROBE_RESP,
  NL80211_EXT_FEATURE_OCE_PROBE_REQ_HIGH_TX_RATE,
  NL80211_EXT_FEATURE_OCE_PROBE_REQ_DEFERRAL_SUPPRESSION,
  NL80211_EXT_FEATURE_MFP_OPTIONAL,
  NL80211_EXT_FEATURE_LOW_SPAN_SCAN,
  NL80211_EXT_FEATURE_LOW_POWER_SCAN,
  NL80211_EXT_FEATURE_HIGH_ACCURACY_SCAN,
  NL80211_EXT_FEATURE_DFS_OFFLOAD,
  NL80211_EXT_FEATURE_CONTROL_PORT_OVER_NL80211,
  NL80211_EXT_FEATURE_ACK_SIGNAL_SUPPORT,
  NL80211_EXT_FEATURE_DATA_ACK_SIGNAL_SUPPORT = NL80211_EXT_FEATURE_ACK_SIGNAL_SUPPORT,
  NL80211_EXT_FEATURE_TXQS,
  NL80211_EXT_FEATURE_SCAN_RANDOM_SN,
  NL80211_EXT_FEATURE_SCAN_MIN_PREQ_CONTENT,
  NL80211_EXT_FEATURE_CAN_REPLACE_PTK0,
  NL80211_EXT_FEATURE_ENABLE_FTM_RESPONDER,
  NL80211_EXT_FEATURE_AIRTIME_FAIRNESS,
  NL80211_EXT_FEATURE_AP_PMKSA_CACHING,
  NL80211_EXT_FEATURE_SCHED_SCAN_BAND_SPECIFIC_RSSI_THOLD,
  NL80211_EXT_FEATURE_EXT_KEY_ID,
  NL80211_EXT_FEATURE_STA_TX_PWR,
  NL80211_EXT_FEATURE_SAE_OFFLOAD,
  NL80211_EXT_FEATURE_VLAN_OFFLOAD,
  NL80211_EXT_FEATURE_AQL,
  NL80211_EXT_FEATURE_BEACON_PROTECTION,
  NL80211_EXT_FEATURE_CONTROL_PORT_NO_PREAUTH,
  NL80211_EXT_FEATURE_PROTECTED_TWT,
  NL80211_EXT_FEATURE_DEL_IBSS_STA,
  NL80211_EXT_FEATURE_MULTICAST_REGISTRATIONS,
  NL80211_EXT_FEATURE_BEACON_PROTECTION_CLIENT,
  NL80211_EXT_FEATURE_SCAN_FREQ_KHZ,
  NL80211_EXT_FEATURE_CONTROL_PORT_OVER_NL80211_TX_STATUS,
  NL80211_EXT_FEATURE_OPERATING_CHANNEL_VALIDATION,
  NL80211_EXT_FEATURE_4WAY_HANDSHAKE_AP_PSK,
  NL80211_EXT_FEATURE_SAE_OFFLOAD_AP,
  NL80211_EXT_FEATURE_FILS_DISCOVERY,
  NL80211_EXT_FEATURE_UNSOL_BCAST_PROBE_RESP,
  NL80211_EXT_FEATURE_BEACON_RATE_HE,
  NL80211_EXT_FEATURE_SECURE_LTF,
  NL80211_EXT_FEATURE_SECURE_RTT,
  NL80211_EXT_FEATURE_PROT_RANGE_NEGO_AND_MEASURE,
  NL80211_EXT_FEATURE_BSS_COLOR,
  NL80211_EXT_FEATURE_FILS_CRYPTO_OFFLOAD,
  NL80211_EXT_FEATURE_RADAR_BACKGROUND,
  NL80211_EXT_FEATURE_POWERED_ADDR_CHANGE,
  NL80211_EXT_FEATURE_PUNCT,
  NL80211_EXT_FEATURE_SECURE_NAN,
  NL80211_EXT_FEATURE_AUTH_AND_DEAUTH_RANDOM_TA,
  NUM_NL80211_EXT_FEATURES,
  MAX_NL80211_EXT_FEATURES = NUM_NL80211_EXT_FEATURES - 1
};
enum nl80211_probe_resp_offload_support_attr {
  NL80211_PROBE_RESP_OFFLOAD_SUPPORT_WPS = 1 << 0,
  NL80211_PROBE_RESP_OFFLOAD_SUPPORT_WPS2 = 1 << 1,
  NL80211_PROBE_RESP_OFFLOAD_SUPPORT_P2P = 1 << 2,
  NL80211_PROBE_RESP_OFFLOAD_SUPPORT_80211U = 1 << 3,
};
enum nl80211_connect_failed_reason {
  NL80211_CONN_FAIL_MAX_CLIENTS,
  NL80211_CONN_FAIL_BLOCKED_CLIENT,
};
enum nl80211_timeout_reason {
  NL80211_TIMEOUT_UNSPECIFIED,
  NL80211_TIMEOUT_SCAN,
  NL80211_TIMEOUT_AUTH,
  NL80211_TIMEOUT_ASSOC,
};
enum nl80211_scan_flags {
  NL80211_SCAN_FLAG_LOW_PRIORITY = 1 << 0,
  NL80211_SCAN_FLAG_FLUSH = 1 << 1,
  NL80211_SCAN_FLAG_AP = 1 << 2,
  NL80211_SCAN_FLAG_RANDOM_ADDR = 1 << 3,
  NL80211_SCAN_FLAG_FILS_MAX_CHANNEL_TIME = 1 << 4,
  NL80211_SCAN_FLAG_ACCEPT_BCAST_PROBE_RESP = 1 << 5,
  NL80211_SCAN_FLAG_OCE_PROBE_REQ_HIGH_TX_RATE = 1 << 6,
  NL80211_SCAN_FLAG_OCE_PROBE_REQ_DEFERRAL_SUPPRESSION = 1 << 7,
  NL80211_SCAN_FLAG_LOW_SPAN = 1 << 8,
  NL80211_SCAN_FLAG_LOW_POWER = 1 << 9,
  NL80211_SCAN_FLAG_HIGH_ACCURACY = 1 << 10,
  NL80211_SCAN_FLAG_RANDOM_SN = 1 << 11,
  NL80211_SCAN_FLAG_MIN_PREQ_CONTENT = 1 << 12,
  NL80211_SCAN_FLAG_FREQ_KHZ = 1 << 13,
  NL80211_SCAN_FLAG_COLOCATED_6GHZ = 1 << 14,
};
enum nl80211_acl_policy {
  NL80211_ACL_POLICY_ACCEPT_UNLESS_LISTED,
  NL80211_ACL_POLICY_DENY_UNLESS_LISTED,
};
enum nl80211_smps_mode {
  NL80211_SMPS_OFF,
  NL80211_SMPS_STATIC,
  NL80211_SMPS_DYNAMIC,
  __NL80211_SMPS_AFTER_LAST,
  NL80211_SMPS_MAX = __NL80211_SMPS_AFTER_LAST - 1
};
enum nl80211_radar_event {
  NL80211_RADAR_DETECTED,
  NL80211_RADAR_CAC_FINISHED,
  NL80211_RADAR_CAC_ABORTED,
  NL80211_RADAR_NOP_FINISHED,
  NL80211_RADAR_PRE_CAC_EXPIRED,
  NL80211_RADAR_CAC_STARTED,
};
enum nl80211_dfs_state {
  NL80211_DFS_USABLE,
  NL80211_DFS_UNAVAILABLE,
  NL80211_DFS_AVAILABLE,
};
enum nl80211_protocol_features {
  NL80211_PROTOCOL_FEATURE_SPLIT_WIPHY_DUMP = 1 << 0,
};
enum nl80211_crit_proto_id {
  NL80211_CRIT_PROTO_UNSPEC,
  NL80211_CRIT_PROTO_DHCP,
  NL80211_CRIT_PROTO_EAPOL,
  NL80211_CRIT_PROTO_APIPA,
  NUM_NL80211_CRIT_PROTO
};
#define NL80211_CRIT_PROTO_MAX_DURATION 5000
enum nl80211_rxmgmt_flags {
  NL80211_RXMGMT_FLAG_ANSWERED = 1 << 0,
  NL80211_RXMGMT_FLAG_EXTERNAL_AUTH = 1 << 1,
};
#define NL80211_VENDOR_ID_IS_LINUX 0x80000000
struct nl80211_vendor_cmd_info {
  __u32 vendor_id;
  __u32 subcmd;
};
enum nl80211_tdls_peer_capability {
  NL80211_TDLS_PEER_HT = 1 << 0,
  NL80211_TDLS_PEER_VHT = 1 << 1,
  NL80211_TDLS_PEER_WMM = 1 << 2,
  NL80211_TDLS_PEER_HE = 1 << 3,
};
enum nl80211_sched_scan_plan {
  __NL80211_SCHED_SCAN_PLAN_INVALID,
  NL80211_SCHED_SCAN_PLAN_INTERVAL,
  NL80211_SCHED_SCAN_PLAN_ITERATIONS,
  __NL80211_SCHED_SCAN_PLAN_AFTER_LAST,
  NL80211_SCHED_SCAN_PLAN_MAX = __NL80211_SCHED_SCAN_PLAN_AFTER_LAST - 1
};
struct nl80211_bss_select_rssi_adjust {
  __u8 band;
  __s8 delta;
} __attribute__((packed));
enum nl80211_bss_select_attr {
  __NL80211_BSS_SELECT_ATTR_INVALID,
  NL80211_BSS_SELECT_ATTR_RSSI,
  NL80211_BSS_SELECT_ATTR_BAND_PREF,
  NL80211_BSS_SELECT_ATTR_RSSI_ADJUST,
  __NL80211_BSS_SELECT_ATTR_AFTER_LAST,
  NL80211_BSS_SELECT_ATTR_MAX = __NL80211_BSS_SELECT_ATTR_AFTER_LAST - 1
};
enum nl80211_nan_function_type {
  NL80211_NAN_FUNC_PUBLISH,
  NL80211_NAN_FUNC_SUBSCRIBE,
  NL80211_NAN_FUNC_FOLLOW_UP,
  __NL80211_NAN_FUNC_TYPE_AFTER_LAST,
  NL80211_NAN_FUNC_MAX_TYPE = __NL80211_NAN_FUNC_TYPE_AFTER_LAST - 1,
};
enum nl80211_nan_publish_type {
  NL80211_NAN_SOLICITED_PUBLISH = 1 << 0,
  NL80211_NAN_UNSOLICITED_PUBLISH = 1 << 1,
};
enum nl80211_nan_func_term_reason {
  NL80211_NAN_FUNC_TERM_REASON_USER_REQUEST,
  NL80211_NAN_FUNC_TERM_REASON_TTL_EXPIRED,
  NL80211_NAN_FUNC_TERM_REASON_ERROR,
};
#define NL80211_NAN_FUNC_SERVICE_ID_LEN 6
#define NL80211_NAN_FUNC_SERVICE_SPEC_INFO_MAX_LEN 0xff
#define NL80211_NAN_FUNC_SRF_MAX_LEN 0xff
enum nl80211_nan_func_attributes {
  __NL80211_NAN_FUNC_INVALID,
  NL80211_NAN_FUNC_TYPE,
  NL80211_NAN_FUNC_SERVICE_ID,
  NL80211_NAN_FUNC_PUBLISH_TYPE,
  NL80211_NAN_FUNC_PUBLISH_BCAST,
  NL80211_NAN_FUNC_SUBSCRIBE_ACTIVE,
  NL80211_NAN_FUNC_FOLLOW_UP_ID,
  NL80211_NAN_FUNC_FOLLOW_UP_REQ_ID,
  NL80211_NAN_FUNC_FOLLOW_UP_DEST,
  NL80211_NAN_FUNC_CLOSE_RANGE,
  NL80211_NAN_FUNC_TTL,
  NL80211_NAN_FUNC_SERVICE_INFO,
  NL80211_NAN_FUNC_SRF,
  NL80211_NAN_FUNC_RX_MATCH_FILTER,
  NL80211_NAN_FUNC_TX_MATCH_FILTER,
  NL80211_NAN_FUNC_INSTANCE_ID,
  NL80211_NAN_FUNC_TERM_REASON,
  NUM_NL80211_NAN_FUNC_ATTR,
  NL80211_NAN_FUNC_ATTR_MAX = NUM_NL80211_NAN_FUNC_ATTR - 1
};
enum nl80211_nan_srf_attributes {
  __NL80211_NAN_SRF_INVALID,
  NL80211_NAN_SRF_INCLUDE,
  NL80211_NAN_SRF_BF,
  NL80211_NAN_SRF_BF_IDX,
  NL80211_NAN_SRF_MAC_ADDRS,
  NUM_NL80211_NAN_SRF_ATTR,
  NL80211_NAN_SRF_ATTR_MAX = NUM_NL80211_NAN_SRF_ATTR - 1,
};
enum nl80211_nan_match_attributes {
  __NL80211_NAN_MATCH_INVALID,
  NL80211_NAN_MATCH_FUNC_LOCAL,
  NL80211_NAN_MATCH_FUNC_PEER,
  NUM_NL80211_NAN_MATCH_ATTR,
  NL80211_NAN_MATCH_ATTR_MAX = NUM_NL80211_NAN_MATCH_ATTR - 1
};
enum nl80211_external_auth_action {
  NL80211_EXTERNAL_AUTH_START,
  NL80211_EXTERNAL_AUTH_ABORT,
};
enum nl80211_ftm_responder_attributes {
  __NL80211_FTM_RESP_ATTR_INVALID,
  NL80211_FTM_RESP_ATTR_ENABLED,
  NL80211_FTM_RESP_ATTR_LCI,
  NL80211_FTM_RESP_ATTR_CIVICLOC,
  __NL80211_FTM_RESP_ATTR_LAST,
  NL80211_FTM_RESP_ATTR_MAX = __NL80211_FTM_RESP_ATTR_LAST - 1,
};
enum nl80211_ftm_responder_stats {
  __NL80211_FTM_STATS_INVALID,
  NL80211_FTM_STATS_SUCCESS_NUM,
  NL80211_FTM_STATS_PARTIAL_NUM,
  NL80211_FTM_STATS_FAILED_NUM,
  NL80211_FTM_STATS_ASAP_NUM,
  NL80211_FTM_STATS_NON_ASAP_NUM,
  NL80211_FTM_STATS_TOTAL_DURATION_MSEC,
  NL80211_FTM_STATS_UNKNOWN_TRIGGERS_NUM,
  NL80211_FTM_STATS_RESCHEDULE_REQUESTS_NUM,
  NL80211_FTM_STATS_OUT_OF_WINDOW_TRIGGERS_NUM,
  NL80211_FTM_STATS_PAD,
  __NL80211_FTM_STATS_AFTER_LAST,
  NL80211_FTM_STATS_MAX = __NL80211_FTM_STATS_AFTER_LAST - 1
};
enum nl80211_preamble {
  NL80211_PREAMBLE_LEGACY,
  NL80211_PREAMBLE_HT,
  NL80211_PREAMBLE_VHT,
  NL80211_PREAMBLE_DMG,
  NL80211_PREAMBLE_HE,
};
enum nl80211_peer_measurement_type {
  NL80211_PMSR_TYPE_INVALID,
  NL80211_PMSR_TYPE_FTM,
  NUM_NL80211_PMSR_TYPES,
  NL80211_PMSR_TYPE_MAX = NUM_NL80211_PMSR_TYPES - 1
};
enum nl80211_peer_measurement_status {
  NL80211_PMSR_STATUS_SUCCESS,
  NL80211_PMSR_STATUS_REFUSED,
  NL80211_PMSR_STATUS_TIMEOUT,
  NL80211_PMSR_STATUS_FAILURE,
};
enum nl80211_peer_measurement_req {
  __NL80211_PMSR_REQ_ATTR_INVALID,
  NL80211_PMSR_REQ_ATTR_DATA,
  NL80211_PMSR_REQ_ATTR_GET_AP_TSF,
  NUM_NL80211_PMSR_REQ_ATTRS,
  NL80211_PMSR_REQ_ATTR_MAX = NUM_NL80211_PMSR_REQ_ATTRS - 1
};
enum nl80211_peer_measurement_resp {
  __NL80211_PMSR_RESP_ATTR_INVALID,
  NL80211_PMSR_RESP_ATTR_DATA,
  NL80211_PMSR_RESP_ATTR_STATUS,
  NL80211_PMSR_RESP_ATTR_HOST_TIME,
  NL80211_PMSR_RESP_ATTR_AP_TSF,
  NL80211_PMSR_RESP_ATTR_FINAL,
  NL80211_PMSR_RESP_ATTR_PAD,
  NUM_NL80211_PMSR_RESP_ATTRS,
  NL80211_PMSR_RESP_ATTR_MAX = NUM_NL80211_PMSR_RESP_ATTRS - 1
};
enum nl80211_peer_measurement_peer_attrs {
  __NL80211_PMSR_PEER_ATTR_INVALID,
  NL80211_PMSR_PEER_ATTR_ADDR,
  NL80211_PMSR_PEER_ATTR_CHAN,
  NL80211_PMSR_PEER_ATTR_REQ,
  NL80211_PMSR_PEER_ATTR_RESP,
  NUM_NL80211_PMSR_PEER_ATTRS,
  NL80211_PMSR_PEER_ATTR_MAX = NUM_NL80211_PMSR_PEER_ATTRS - 1,
};
enum nl80211_peer_measurement_attrs {
  __NL80211_PMSR_ATTR_INVALID,
  NL80211_PMSR_ATTR_MAX_PEERS,
  NL80211_PMSR_ATTR_REPORT_AP_TSF,
  NL80211_PMSR_ATTR_RANDOMIZE_MAC_ADDR,
  NL80211_PMSR_ATTR_TYPE_CAPA,
  NL80211_PMSR_ATTR_PEERS,
  NUM_NL80211_PMSR_ATTR,
  NL80211_PMSR_ATTR_MAX = NUM_NL80211_PMSR_ATTR - 1
};
enum nl80211_peer_measurement_ftm_capa {
  __NL80211_PMSR_FTM_CAPA_ATTR_INVALID,
  NL80211_PMSR_FTM_CAPA_ATTR_ASAP,
  NL80211_PMSR_FTM_CAPA_ATTR_NON_ASAP,
  NL80211_PMSR_FTM_CAPA_ATTR_REQ_LCI,
  NL80211_PMSR_FTM_CAPA_ATTR_REQ_CIVICLOC,
  NL80211_PMSR_FTM_CAPA_ATTR_PREAMBLES,
  NL80211_PMSR_FTM_CAPA_ATTR_BANDWIDTHS,
  NL80211_PMSR_FTM_CAPA_ATTR_MAX_BURSTS_EXPONENT,
  NL80211_PMSR_FTM_CAPA_ATTR_MAX_FTMS_PER_BURST,
  NL80211_PMSR_FTM_CAPA_ATTR_TRIGGER_BASED,
  NL80211_PMSR_FTM_CAPA_ATTR_NON_TRIGGER_BASED,
  NUM_NL80211_PMSR_FTM_CAPA_ATTR,
  NL80211_PMSR_FTM_CAPA_ATTR_MAX = NUM_NL80211_PMSR_FTM_CAPA_ATTR - 1
};
enum nl80211_peer_measurement_ftm_req {
  __NL80211_PMSR_FTM_REQ_ATTR_INVALID,
  NL80211_PMSR_FTM_REQ_ATTR_ASAP,
  NL80211_PMSR_FTM_REQ_ATTR_PREAMBLE,
  NL80211_PMSR_FTM_REQ_ATTR_NUM_BURSTS_EXP,
  NL80211_PMSR_FTM_REQ_ATTR_BURST_PERIOD,
  NL80211_PMSR_FTM_REQ_ATTR_BURST_DURATION,
  NL80211_PMSR_FTM_REQ_ATTR_FTMS_PER_BURST,
  NL80211_PMSR_FTM_REQ_ATTR_NUM_FTMR_RETRIES,
  NL80211_PMSR_FTM_REQ_ATTR_REQUEST_LCI,
  NL80211_PMSR_FTM_REQ_ATTR_REQUEST_CIVICLOC,
  NL80211_PMSR_FTM_REQ_ATTR_TRIGGER_BASED,
  NL80211_PMSR_FTM_REQ_ATTR_NON_TRIGGER_BASED,
  NL80211_PMSR_FTM_REQ_ATTR_LMR_FEEDBACK,
  NL80211_PMSR_FTM_REQ_ATTR_BSS_COLOR,
  NUM_NL80211_PMSR_FTM_REQ_ATTR,
  NL80211_PMSR_FTM_REQ_ATTR_MAX = NUM_NL80211_PMSR_FTM_REQ_ATTR - 1
};
enum nl80211_peer_measurement_ftm_failure_reasons {
  NL80211_PMSR_FTM_FAILURE_UNSPECIFIED,
  NL80211_PMSR_FTM_FAILURE_NO_RESPONSE,
  NL80211_PMSR_FTM_FAILURE_REJECTED,
  NL80211_PMSR_FTM_FAILURE_WRONG_CHANNEL,
  NL80211_PMSR_FTM_FAILURE_PEER_NOT_CAPABLE,
  NL80211_PMSR_FTM_FAILURE_INVALID_TIMESTAMP,
  NL80211_PMSR_FTM_FAILURE_PEER_BUSY,
  NL80211_PMSR_FTM_FAILURE_BAD_CHANGED_PARAMS,
};
enum nl80211_peer_measurement_ftm_resp {
  __NL80211_PMSR_FTM_RESP_ATTR_INVALID,
  NL80211_PMSR_FTM_RESP_ATTR_FAIL_REASON,
  NL80211_PMSR_FTM_RESP_ATTR_BURST_INDEX,
  NL80211_PMSR_FTM_RESP_ATTR_NUM_FTMR_ATTEMPTS,
  NL80211_PMSR_FTM_RESP_ATTR_NUM_FTMR_SUCCESSES,
  NL80211_PMSR_FTM_RESP_ATTR_BUSY_RETRY_TIME,
  NL80211_PMSR_FTM_RESP_ATTR_NUM_BURSTS_EXP,
  NL80211_PMSR_FTM_RESP_ATTR_BURST_DURATION,
  NL80211_PMSR_FTM_RESP_ATTR_FTMS_PER_BURST,
  NL80211_PMSR_FTM_RESP_ATTR_RSSI_AVG,
  NL80211_PMSR_FTM_RESP_ATTR_RSSI_SPREAD,
  NL80211_PMSR_FTM_RESP_ATTR_TX_RATE,
  NL80211_PMSR_FTM_RESP_ATTR_RX_RATE,
  NL80211_PMSR_FTM_RESP_ATTR_RTT_AVG,
  NL80211_PMSR_FTM_RESP_ATTR_RTT_VARIANCE,
  NL80211_PMSR_FTM_RESP_ATTR_RTT_SPREAD,
  NL80211_PMSR_FTM_RESP_ATTR_DIST_AVG,
  NL80211_PMSR_FTM_RESP_ATTR_DIST_VARIANCE,
  NL80211_PMSR_FTM_RESP_ATTR_DIST_SPREAD,
  NL80211_PMSR_FTM_RESP_ATTR_LCI,
  NL80211_PMSR_FTM_RESP_ATTR_CIVICLOC,
  NL80211_PMSR_FTM_RESP_ATTR_PAD,
  NUM_NL80211_PMSR_FTM_RESP_ATTR,
  NL80211_PMSR_FTM_RESP_ATTR_MAX = NUM_NL80211_PMSR_FTM_RESP_ATTR - 1
};
enum nl80211_obss_pd_attributes {
  __NL80211_HE_OBSS_PD_ATTR_INVALID,
  NL80211_HE_OBSS_PD_ATTR_MIN_OFFSET,
  NL80211_HE_OBSS_PD_ATTR_MAX_OFFSET,
  NL80211_HE_OBSS_PD_ATTR_NON_SRG_MAX_OFFSET,
  NL80211_HE_OBSS_PD_ATTR_BSS_COLOR_BITMAP,
  NL80211_HE_OBSS_PD_ATTR_PARTIAL_BSSID_BITMAP,
  NL80211_HE_OBSS_PD_ATTR_SR_CTRL,
  __NL80211_HE_OBSS_PD_ATTR_LAST,
  NL80211_HE_OBSS_PD_ATTR_MAX = __NL80211_HE_OBSS_PD_ATTR_LAST - 1,
};
enum nl80211_bss_color_attributes {
  __NL80211_HE_BSS_COLOR_ATTR_INVALID,
  NL80211_HE_BSS_COLOR_ATTR_COLOR,
  NL80211_HE_BSS_COLOR_ATTR_DISABLED,
  NL80211_HE_BSS_COLOR_ATTR_PARTIAL,
  __NL80211_HE_BSS_COLOR_ATTR_LAST,
  NL80211_HE_BSS_COLOR_ATTR_MAX = __NL80211_HE_BSS_COLOR_ATTR_LAST - 1,
};
enum nl80211_iftype_akm_attributes {
  __NL80211_IFTYPE_AKM_ATTR_INVALID,
  NL80211_IFTYPE_AKM_ATTR_IFTYPES,
  NL80211_IFTYPE_AKM_ATTR_SUITES,
  __NL80211_IFTYPE_AKM_ATTR_LAST,
  NL80211_IFTYPE_AKM_ATTR_MAX = __NL80211_IFTYPE_AKM_ATTR_LAST - 1,
};
enum nl80211_fils_discovery_attributes {
  __NL80211_FILS_DISCOVERY_ATTR_INVALID,
  NL80211_FILS_DISCOVERY_ATTR_INT_MIN,
  NL80211_FILS_DISCOVERY_ATTR_INT_MAX,
  NL80211_FILS_DISCOVERY_ATTR_TMPL,
  __NL80211_FILS_DISCOVERY_ATTR_LAST,
  NL80211_FILS_DISCOVERY_ATTR_MAX = __NL80211_FILS_DISCOVERY_ATTR_LAST - 1
};
#define NL80211_FILS_DISCOVERY_TMPL_MIN_LEN 42
enum nl80211_unsol_bcast_probe_resp_attributes {
  __NL80211_UNSOL_BCAST_PROBE_RESP_ATTR_INVALID,
  NL80211_UNSOL_BCAST_PROBE_RESP_ATTR_INT,
  NL80211_UNSOL_BCAST_PROBE_RESP_ATTR_TMPL,
  __NL80211_UNSOL_BCAST_PROBE_RESP_ATTR_LAST,
  NL80211_UNSOL_BCAST_PROBE_RESP_ATTR_MAX = __NL80211_UNSOL_BCAST_PROBE_RESP_ATTR_LAST - 1
};
enum nl80211_sae_pwe_mechanism {
  NL80211_SAE_PWE_UNSPECIFIED,
  NL80211_SAE_PWE_HUNT_AND_PECK,
  NL80211_SAE_PWE_HASH_TO_ELEMENT,
  NL80211_SAE_PWE_BOTH,
};
enum nl80211_sar_type {
  NL80211_SAR_TYPE_POWER,
  NUM_NL80211_SAR_TYPE,
};
enum nl80211_sar_attrs {
  __NL80211_SAR_ATTR_INVALID,
  NL80211_SAR_ATTR_TYPE,
  NL80211_SAR_ATTR_SPECS,
  __NL80211_SAR_ATTR_LAST,
  NL80211_SAR_ATTR_MAX = __NL80211_SAR_ATTR_LAST - 1,
};
enum nl80211_sar_specs_attrs {
  __NL80211_SAR_ATTR_SPECS_INVALID,
  NL80211_SAR_ATTR_SPECS_POWER,
  NL80211_SAR_ATTR_SPECS_RANGE_INDEX,
  NL80211_SAR_ATTR_SPECS_START_FREQ,
  NL80211_SAR_ATTR_SPECS_END_FREQ,
  __NL80211_SAR_ATTR_SPECS_LAST,
  NL80211_SAR_ATTR_SPECS_MAX = __NL80211_SAR_ATTR_SPECS_LAST - 1,
};
enum nl80211_mbssid_config_attributes {
  __NL80211_MBSSID_CONFIG_ATTR_INVALID,
  NL80211_MBSSID_CONFIG_ATTR_MAX_INTERFACES,
  NL80211_MBSSID_CONFIG_ATTR_MAX_EMA_PROFILE_PERIODICITY,
  NL80211_MBSSID_CONFIG_ATTR_INDEX,
  NL80211_MBSSID_CONFIG_ATTR_TX_IFINDEX,
  NL80211_MBSSID_CONFIG_ATTR_EMA,
  __NL80211_MBSSID_CONFIG_ATTR_LAST,
  NL80211_MBSSID_CONFIG_ATTR_MAX = __NL80211_MBSSID_CONFIG_ATTR_LAST - 1,
};
enum nl80211_ap_settings_flags {
  NL80211_AP_SETTINGS_EXTERNAL_AUTH_SUPPORT = 1 << 0,
  NL80211_AP_SETTINGS_SA_QUERY_OFFLOAD_SUPPORT = 1 << 1,
};
#endif
