/*
 * Copyright (C) 2019 The Android Open Source Project
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <benchmark/benchmark.h>

#include "linker_gnu_hash.h"

// 250 symbols from the relocations of system/lib/libhwbinder.so in aosp/master, aosp_walleye.
// ROT13-encoded so as not to pollute code search.
static const char* const kSampleSymbolList[] = {
    "_MA7naqebvq8uneqjner9OUjOvaqre8genafnpgRwEXAF0_6CnepryRCF2_wAFg3__18shapgvbaVSiEF2_RRR",
    "_MA7naqebvq8uneqjner9OUjOvaqre11yvaxGbQrnguREXAF_2fcVAF0_7VOvaqre14QrnguErpvcvragRRRCiw",
    "_MA7naqebvq8uneqjner9OUjOvaqre13hayvaxGbQrnguREXAF_2jcVAF0_7VOvaqre14QrnguErpvcvragRRRCiwCF5_",
    "_MAX7naqebvq8uneqjner7VOvaqre13purpxFhopynffRCXi",
    "_MA7naqebvq8uneqjner9OUjOvaqre12nggnpuBowrpgRCXiCiF4_CSiF3_F4_F4_R",
    "_MAX7naqebvq8uneqjner9OUjOvaqre10svaqBowrpgRCXi",
    "_MA7naqebvq8uneqjner9OUjOvaqre12qrgnpuBowrpgRCXi",
    "_MA7naqebvq8uneqjner9OUjOvaqre11ybpnyOvaqreRi",
    "_MA7naqebvq8uneqjner7VOvaqre12erzbgrOvaqreRi",
    "_MA7naqebvq8uneqjner9OUjOvaqreQ1Ri",
    "_MA7naqebvq8uneqjner9OUjOvaqreQ0Ri",
    "_MA7naqebvq8uneqjner9OUjOvaqre10baGenafnpgRwEXAF0_6CnepryRCF2_wAFg3__18shapgvbaVSiEF2_RRR",
    "_MGi0_a12_A7naqebvq8uneqjner9OUjOvaqreQ1Ri",
    "_MGi0_a12_A7naqebvq8uneqjner9OUjOvaqreQ0Ri",
    "_MA7naqebvq7ErsOnfr10baSvefgErsRi",
    "_MA7naqebvq7ErsOnfr15baYnfgFgebatErsRCXi",
    "_MA7naqebvq7ErsOnfr20baVapFgebatNggrzcgrqRwCXi",
    "_MA7naqebvq7ErsOnfr13baYnfgJrnxErsRCXi",
    "_MA7naqebvq8uneqjner11OcUjErsOnfrQ1Ri",
    "_MA7naqebvq8uneqjner11OcUjErsOnfrQ0Ri",
    "_MA7naqebvq8uneqjner11OcUjErsOnfr10baSvefgErsRi",
    "_MA7naqebvq8uneqjner11OcUjErsOnfr15baYnfgFgebatErsRCXi",
    "_MA7naqebvq8uneqjner11OcUjErsOnfr20baVapFgebatNggrzcgrqRwCXi",
    "_MGi0_a12_A7naqebvq8uneqjner11OcUjErsOnfrQ1Ri",
    "_MGi0_a12_A7naqebvq8uneqjner11OcUjErsOnfrQ0Ri",
    "_MGi0_a16_A7naqebvq8uneqjner11OcUjErsOnfr10baSvefgErsRi",
    "_MGi0_a20_A7naqebvq8uneqjner11OcUjErsOnfr15baYnfgFgebatErsRCXi",
    "_MGi0_a24_A7naqebvq8uneqjner11OcUjErsOnfr20baVapFgebatNggrzcgrqRwCXi",
    "_MA7naqebvq7ErsOnfr13baYnfgJrnxErsRCXi",
    "__pkn_cher_iveghny",
    "__pkn_cher_iveghny",
    "__pkn_cher_iveghny",
    "_MAX7naqebvq8uneqjner7VOvaqre13purpxFhopynffRCXi",
    "__pkn_cher_iveghny",
    "__pkn_cher_iveghny",
    "__pkn_cher_iveghny",
    "_MA7naqebvq8uneqjner7VOvaqre11ybpnyOvaqreRi",
    "_MA7naqebvq8uneqjner7VOvaqre12erzbgrOvaqreRi",
    "_MA7naqebvq8uneqjner7VOvaqreQ1Ri",
    "_MA7naqebvq8uneqjner7VOvaqreQ0Ri",
    "_MGi0_a12_A7naqebvq8uneqjner7VOvaqreQ1Ri",
    "_MGi0_a12_A7naqebvq8uneqjner7VOvaqreQ0Ri",
    "_MA7naqebvq7ErsOnfr10baSvefgErsRi",
    "_MA7naqebvq7ErsOnfr15baYnfgFgebatErsRCXi",
    "_MA7naqebvq7ErsOnfr20baVapFgebatNggrzcgrqRwCXi",
    "_MA7naqebvq7ErsOnfr13baYnfgJrnxErsRCXi",
    "__pkn_cher_iveghny",
    "__pkn_cher_iveghny",
    "__pkn_cher_iveghny",
    "_MAX7naqebvq8uneqjner7VOvaqre13purpxFhopynffRCXi",
    "__pkn_cher_iveghny",
    "__pkn_cher_iveghny",
    "__pkn_cher_iveghny",
    "_MA7naqebvq8uneqjner7VOvaqre11ybpnyOvaqreRi",
    "_MA7naqebvq8uneqjner7VOvaqre12erzbgrOvaqreRi",
    "_MA7naqebvq8uneqjner7VOvaqreQ1Ri",
    "_MA7naqebvq8uneqjner7VOvaqreQ0Ri",
    "_MGi0_a12_A7naqebvq8uneqjner7VOvaqreQ1Ri",
    "_MGi0_a12_A7naqebvq8uneqjner7VOvaqreQ0Ri",
    "_MA7naqebvq7ErsOnfr10baSvefgErsRi",
    "_MA7naqebvq7ErsOnfr15baYnfgFgebatErsRCXi",
    "_MA7naqebvq7ErsOnfr20baVapFgebatNggrzcgrqRwCXi",
    "_MA7naqebvq7ErsOnfr13baYnfgJrnxErsRCXi",
    "_MA7naqebvq8uneqjner10OcUjOvaqre8genafnpgRwEXAF0_6CnepryRCF2_wAFg3__18shapgvbaVSiEF2_RRR",
    "_MA7naqebvq8uneqjner10OcUjOvaqre11yvaxGbQrnguREXAF_2fcVAF0_7VOvaqre14QrnguErpvcvragRRRCiw",
    "_MA7naqebvq8uneqjner10OcUjOvaqre13hayvaxGbQrnguREXAF_2jcVAF0_7VOvaqre14QrnguErpvcvragRRRCiwCF5_",
    "_MAX7naqebvq8uneqjner7VOvaqre13purpxFhopynffRCXi",
    "_MA7naqebvq8uneqjner10OcUjOvaqre12nggnpuBowrpgRCXiCiF4_CSiF3_F4_F4_R",
    "_MAX7naqebvq8uneqjner10OcUjOvaqre10svaqBowrpgRCXi",
    "_MA7naqebvq8uneqjner10OcUjOvaqre12qrgnpuBowrpgRCXi",
    "_MA7naqebvq8uneqjner7VOvaqre11ybpnyOvaqreRi",
    "_MA7naqebvq8uneqjner10OcUjOvaqre12erzbgrOvaqreRi",
    "_MA7naqebvq8uneqjner10OcUjOvaqreQ1Ri",
    "_MA7naqebvq8uneqjner10OcUjOvaqreQ0Ri",
    "_MA7naqebvq8uneqjner10OcUjOvaqre10baSvefgErsRi",
    "_MA7naqebvq8uneqjner10OcUjOvaqre15baYnfgFgebatErsRCXi",
    "_MA7naqebvq8uneqjner10OcUjOvaqre20baVapFgebatNggrzcgrqRwCXi",
    "_MGi0_a12_A7naqebvq8uneqjner10OcUjOvaqreQ1Ri",
    "_MGi0_a12_A7naqebvq8uneqjner10OcUjOvaqreQ0Ri",
    "_MGi0_a16_A7naqebvq8uneqjner10OcUjOvaqre10baSvefgErsRi",
    "_MGi0_a20_A7naqebvq8uneqjner10OcUjOvaqre15baYnfgFgebatErsRCXi",
    "_MGi0_a24_A7naqebvq8uneqjner10OcUjOvaqre20baVapFgebatNggrzcgrqRwCXi",
    "_MA7naqebvq7ErsOnfr13baYnfgJrnxErsRCXi",
    "__pkn_cher_iveghny",
    "__pkn_cher_iveghny",
    "__pkn_cher_iveghny",
    "_MAX7naqebvq8uneqjner7VOvaqre13purpxFhopynffRCXi",
    "__pkn_cher_iveghny",
    "__pkn_cher_iveghny",
    "__pkn_cher_iveghny",
    "_MA7naqebvq8uneqjner7VOvaqre11ybpnyOvaqreRi",
    "_MA7naqebvq8uneqjner7VOvaqre12erzbgrOvaqreRi",
    "_MA7naqebvq8uneqjner7VOvaqreQ1Ri",
    "_MA7naqebvq8uneqjner7VOvaqreQ0Ri",
    "_MGi0_a12_A7naqebvq8uneqjner7VOvaqreQ1Ri",
    "_MGi0_a12_A7naqebvq8uneqjner7VOvaqreQ0Ri",
    "_MA7naqebvq7ErsOnfr10baSvefgErsRi",
    "_MA7naqebvq7ErsOnfr15baYnfgFgebatErsRCXi",
    "_MA7naqebvq7ErsOnfr20baVapFgebatNggrzcgrqRwCXi",
    "_MA7naqebvq7ErsOnfr13baYnfgJrnxErsRCXi",
    "_MA7naqebvq8uneqjner18OhssrerqGrkgBhgchgQ2Ri",
    "_MA7naqebvq8uneqjner18OhssrerqGrkgBhgchgQ0Ri",
    "_MA7naqebvq8uneqjner18OhssrerqGrkgBhgchg5cevagRCXpw",
    "_MA7naqebvq8uneqjner18OhssrerqGrkgBhgchg10zbirVaqragRv",
    "_MA7naqebvq8uneqjner18OhssrerqGrkgBhgchg10chfuOhaqyrRi",
    "_MA7naqebvq8uneqjner18OhssrerqGrkgBhgchg9cbcOhaqyrRi",
    "__pkn_cher_iveghny",
    "_MA7naqebvq7ErsOnfr10baSvefgErsRi",
    "_MA7naqebvq7ErsOnfr15baYnfgFgebatErsRCXi",
    "_MA7naqebvq7ErsOnfr20baVapFgebatNggrzcgrqRwCXi",
    "_MA7naqebvq7ErsOnfr13baYnfgJrnxErsRCXi",
    "_MA7naqebvq8uneqjner10VVagresnprQ1Ri",
    "_MA7naqebvq8uneqjner10VVagresnprQ0Ri",
    "__pkn_cher_iveghny",
    "_MGi0_a12_A7naqebvq8uneqjner10VVagresnprQ1Ri",
    "_MGi0_a12_A7naqebvq8uneqjner10VVagresnprQ0Ri",
    "_MA7naqebvq7ErsOnfr10baSvefgErsRi",
    "_MA7naqebvq7ErsOnfr15baYnfgFgebatErsRCXi",
    "_MA7naqebvq7ErsOnfr20baVapFgebatNggrzcgrqRwCXi",
    "_MA7naqebvq7ErsOnfr13baYnfgJrnxErsRCXi",
    "_MAFg3__114onfvp_vbfgernzVpAF_11pune_genvgfVpRRRQ1Ri",
    "_MAFg3__114onfvp_vbfgernzVpAF_11pune_genvgfVpRRRQ0Ri",
    "_MGua8_AFg3__114onfvp_vbfgernzVpAF_11pune_genvgfVpRRRQ1Ri",
    "_MGua8_AFg3__114onfvp_vbfgernzVpAF_11pune_genvgfVpRRRQ0Ri",
    "_MGi0_a12_AFg3__114onfvp_vbfgernzVpAF_11pune_genvgfVpRRRQ1Ri",
    "_MGi0_a12_AFg3__114onfvp_vbfgernzVpAF_11pune_genvgfVpRRRQ0Ri",
    "_MAFg3__113onfvp_vfgernzVpAF_11pune_genvgfVpRRRQ1Ri",
    "_MAFg3__113onfvp_vfgernzVpAF_11pune_genvgfVpRRRQ0Ri",
    "_MGi0_a12_AFg3__113onfvp_vfgernzVpAF_11pune_genvgfVpRRRQ1Ri",
    "_MGi0_a12_AFg3__113onfvp_vfgernzVpAF_11pune_genvgfVpRRRQ0Ri",
    "_MAFg3__113onfvp_bfgernzVpAF_11pune_genvgfVpRRRQ1Ri",
    "_MAFg3__113onfvp_bfgernzVpAF_11pune_genvgfVpRRRQ0Ri",
    "_MGi0_a12_AFg3__113onfvp_bfgernzVpAF_11pune_genvgfVpRRRQ1Ri",
    "_MGi0_a12_AFg3__113onfvp_bfgernzVpAF_11pune_genvgfVpRRRQ0Ri",
    "_MAFg3__115onfvp_fgernzohsVpAF_11pune_genvgfVpRRR5vzohrREXAF_6ybpnyrR",
    "_MAFg3__115onfvp_fgernzohsVpAF_11pune_genvgfVpRRR6frgohsRCpv",
    "_MAFg3__115onfvp_fgernzohsVpAF_11pune_genvgfVpRRR4flapRi",
    "_MAFg3__115onfvp_fgernzohsVpAF_11pune_genvgfVpRRR9fubjznalpRi",
    "_MAFg3__115onfvp_fgernzohsVpAF_11pune_genvgfVpRRR6kftrgaRCpv",
    "_MAFg3__115onfvp_fgernzohsVpAF_11pune_genvgfVpRRR5hsybjRi",
    "_MAFg3__115onfvp_fgernzohsVpAF_11pune_genvgfVpRRR6kfchgaRCXpv",
    "_MA7naqebvq8uneqjner12CebprffFgngrQ1Ri",
    "_MA7naqebvq8uneqjner12CebprffFgngrQ0Ri",
    "_MGi0_a12_A7naqebvq8uneqjner12CebprffFgngrQ1Ri",
    "_MGi0_a12_A7naqebvq8uneqjner12CebprffFgngrQ0Ri",
    "_MA7naqebvq7ErsOnfr10baSvefgErsRi",
    "_MA7naqebvq7ErsOnfr15baYnfgFgebatErsRCXi",
    "_MA7naqebvq7ErsOnfr20baVapFgebatNggrzcgrqRwCXi",
    "_MA7naqebvq7ErsOnfr13baYnfgJrnxErsRCXi",
    "_MA7naqebvq6Guernq3ehaRCXpvw",
    "_MA7naqebvq6Guernq11erdhrfgRkvgRi",
    "_MA7naqebvq6Guernq10ernqlGbEhaRi",
    "_MA7naqebvq7ErsOnfr10baSvefgErsRi",
    "_MA7naqebvq7ErsOnfr15baYnfgFgebatErsRCXi",
    "_MA7naqebvq7ErsOnfr20baVapFgebatNggrzcgrqRwCXi",
    "_MA7naqebvq7ErsOnfr13baYnfgJrnxErsRCXi",
    "_MA7naqebvq6GuernqQ1Ri",
    "_MA7naqebvq6GuernqQ0Ri",
    "_MA7naqebvq6Guernq3ehaRCXpvw",
    "_MA7naqebvq6Guernq11erdhrfgRkvgRi",
    "_MA7naqebvq6Guernq10ernqlGbEhaRi",
    "__pkn_cher_iveghny",
    "_MGi0_a12_A7naqebvq6GuernqQ1Ri",
    "_MGi0_a12_A7naqebvq6GuernqQ0Ri",
    "_MA7naqebvq7ErsOnfr10baSvefgErsRi",
    "_MA7naqebvq7ErsOnfr15baYnfgFgebatErsRCXi",
    "_MA7naqebvq7ErsOnfr20baVapFgebatNggrzcgrqRwCXi",
    "_MA7naqebvq7ErsOnfr13baYnfgJrnxErsRCXi",
    "_MA7naqebvq8uneqjner18OhssrerqGrkgBhgchgQ2Ri",
    "_MA7naqebvq8uneqjner18OhssrerqGrkgBhgchg5cevagRCXpw",
    "_MA7naqebvq8uneqjner18OhssrerqGrkgBhgchg10zbirVaqragRv",
    "_MA7naqebvq8uneqjner18OhssrerqGrkgBhgchg10chfuOhaqyrRi",
    "_MA7naqebvq8uneqjner18OhssrerqGrkgBhgchg9cbcOhaqyrRi",
    "_MA7naqebvq8uneqjner18OhssrerqGrkgBhgchgQ2Ri",
    "_MA7naqebvq8uneqjner18OhssrerqGrkgBhgchg5cevagRCXpw",
    "_MA7naqebvq8uneqjner18OhssrerqGrkgBhgchg10zbirVaqragRv",
    "_MA7naqebvq8uneqjner18OhssrerqGrkgBhgchg10chfuOhaqyrRi",
    "_MA7naqebvq8uneqjner18OhssrerqGrkgBhgchg9cbcOhaqyrRi",
    "_MA7naqebvq8uneqjner10GrkgBhgchgQ2Ri",
    "_MA7naqebvq8uneqjner10GrkgBhgchgQ0Ri",
    "__pkn_cher_iveghny",
    "__pkn_cher_iveghny",
    "__pkn_cher_iveghny",
    "__pkn_cher_iveghny",
    "_MGIA7naqebvq8uneqjner9OUjOvaqreR",
    "_MGPA7naqebvq8uneqjner9OUjOvaqreR0_AF0_7VOvaqreR",
    "_MGPA7naqebvq8uneqjner9OUjOvaqreR0_AF0_7VOvaqreR",
    "_MGIA7naqebvq8uneqjner9OUjOvaqreR",
    "_MGIA7naqebvq8uneqjner11OcUjErsOnfrR",
    "_MGIA7naqebvq8uneqjner11OcUjErsOnfrR",
    "_MGIA7naqebvq8uneqjner7VOvaqreR",
    "_MGIA7naqebvq8uneqjner7VOvaqreR",
    "_MGIA7naqebvq8uneqjner10OcUjOvaqreR",
    "_MGPA7naqebvq8uneqjner10OcUjOvaqreR0_AF0_7VOvaqreR",
    "_MGPA7naqebvq8uneqjner10OcUjOvaqreR0_AF0_7VOvaqreR",
    "_MGIA7naqebvq8uneqjner10OcUjOvaqreR",
    "_MGIA7naqebvq8uneqjner10VVagresnprR",
    "_MGIA7naqebvq8uneqjner10VVagresnprR",
    "_MGIAFg3__118onfvp_fgevatfgernzVpAF_11pune_genvgfVpRRAF_9nyybpngbeVpRRRR",
    "_MGPAFg3__118onfvp_fgevatfgernzVpAF_11pune_genvgfVpRRAF_9nyybpngbeVpRRRR0_AF_14onfvp_vbfgernzVpF2_RR",
    "_MGPAFg3__118onfvp_fgevatfgernzVpAF_11pune_genvgfVpRRAF_9nyybpngbeVpRRRR0_AF_13onfvp_vfgernzVpF2_RR",
    "_MGPAFg3__118onfvp_fgevatfgernzVpAF_11pune_genvgfVpRRAF_9nyybpngbeVpRRRR0_AF_13onfvp_vfgernzVpF2_RR",
    "_MGPAFg3__118onfvp_fgevatfgernzVpAF_11pune_genvgfVpRRAF_9nyybpngbeVpRRRR8_AF_13onfvp_bfgernzVpF2_RR",
    "_MGPAFg3__118onfvp_fgevatfgernzVpAF_11pune_genvgfVpRRAF_9nyybpngbeVpRRRR8_AF_13onfvp_bfgernzVpF2_RR",
    "_MGPAFg3__118onfvp_fgevatfgernzVpAF_11pune_genvgfVpRRAF_9nyybpngbeVpRRRR0_AF_14onfvp_vbfgernzVpF2_RR",
    "_MGPAFg3__118onfvp_fgevatfgernzVpAF_11pune_genvgfVpRRAF_9nyybpngbeVpRRRR0_AF_14onfvp_vbfgernzVpF2_RR",
    "_MGIAFg3__118onfvp_fgevatfgernzVpAF_11pune_genvgfVpRRAF_9nyybpngbeVpRRRR",
    "_MGIAFg3__118onfvp_fgevatfgernzVpAF_11pune_genvgfVpRRAF_9nyybpngbeVpRRRR",
    "_MGIA7naqebvq8uneqjner12CebprffFgngrR",
    "_MGIA7naqebvq8uneqjner12CebprffFgngrR",
    "_MGIA7naqebvq8uneqjner10CbbyGuernqR",
    "_MGPA7naqebvq8uneqjner10CbbyGuernqR0_AF_6GuernqR",
    "_MGPA7naqebvq8uneqjner10CbbyGuernqR0_AF_6GuernqR",
    "_MGIA7naqebvq8uneqjner10CbbyGuernqR",
    "_MGIA7naqebvq8uneqjner9OUjOvaqreR",
    "__fgnpx_pux_thneq",
    "_MGIA7naqebvq8uneqjner11OcUjErsOnfrR",
    "_MGIA7naqebvq12FbegrqIrpgbeVAF_16xrl_inyhr_cnve_gVCXiAF_8uneqjner10OcUjOvaqre13BowrpgZnantre7ragel_gRRRRR",
    "_MGPA7naqebvq8uneqjner10OcUjOvaqreR0_AF0_7VOvaqreR",
    "_MGIA7naqebvq8uneqjner10OcUjOvaqreR",
    "_MGIA7naqebvq6IrpgbeVAF_8uneqjner10OcUjOvaqre8BovghnelRRR",
    "_MGGA7naqebvq8uneqjner10OcUjOvaqreR",
    "_MGIA7naqebvq6IrpgbeVAF_2fcVAF_8uneqjner18OhssrerqGrkgBhgchg11OhssreFgngrRRRRR",
    "_MA7naqebvq8uneqjner18OhssrerqGrkgBhgchg16guernqQrfgehpgbeRCi",
    "_MGIA7naqebvq8uneqjner18OhssrerqGrkgBhgchgR",
    "_MA7naqebvq8uneqjner12tGrkgOhssrefR",
    "_MGIA7naqebvq8uneqjner18OhssrerqGrkgBhgchg11OhssreFgngrR",
    "_MA7naqebvq8uneqjner14VCPGuernqFgngr16guernqQrfgehpgbeRCi",
    "_MA7naqebvq8uneqjner14VCPGuernqFgngr10serrOhssreRCAF0_6CnepryRCXuwCXlwCi",
    "_MA7naqebvq8uneqjner18gur_pbagrkg_bowrpgR",
    "_MA7naqebvq9PnyyFgnpx18trgPheeragVagreanyRv",
    "_MA7naqebvq9PnyyFgnpx16ybtFgnpxVagreanyRCXpCXF0_19naqebvq_YbtCevbevgl",
    "_MGIA7naqebvq6IrpgbeVCAF_8uneqjner9OUjOvaqreRRR",
    "_MGIA7naqebvq6IrpgbeVCAF_7ErsOnfr12jrnxers_glcrRRR",
    "_MGIA7naqebvq6IrpgbeVCAF_7ErsOnfrRRR",
    "_MFg7abguebj",
    "_MGPAFg3__118onfvp_fgevatfgernzVpAF_11pune_genvgfVpRRAF_9nyybpngbeVpRRRR0_AF_13onfvp_vfgernzVpF2_RR",
    "_MGIAFg3__118onfvp_fgevatfgernzVpAF_11pune_genvgfVpRRAF_9nyybpngbeVpRRRR",
    "_MGIAFg3__115onfvp_fgevatohsVpAF_11pune_genvgfVpRRAF_9nyybpngbeVpRRRR",
    "_MAFg3__15pglcrVpR2vqR",
    "_MA7naqebvq8uneqjner13tCebprffZhgrkR",
    "_MA7naqebvq8uneqjner8tCebprffR",
    "_MGIA7naqebvq8uneqjner12CebprffFgngrR",
    "_MGIA7naqebvq6IrpgbeVAF_8uneqjner12CebprffFgngr12unaqyr_ragelRRR",
    "_MGIA7naqebvq12FbegrqIrpgbeVAF_16xrl_inyhr_cnve_gVAF_8Fgevat16RAF_2fcVAF_8uneqjner7VOvaqreRRRRRRR",
    "_MGIA7naqebvq8uneqjner10CbbyGuernqR",
    "_MGGA7naqebvq8uneqjner12CebprffFgngrR",
    "_MGIA7naqebvq6IrpgbeVvRR",
    "_MGIA7naqebvq8uneqjner13YbtGrkgBhgchgR",
};

static void BM_gnu_hash_simple(benchmark::State& state) {
  for (auto _ : state) {
    for (const char* sym_name : kSampleSymbolList) {
      benchmark::DoNotOptimize(calculate_gnu_hash_simple(sym_name));
    }
  }
}

BENCHMARK(BM_gnu_hash_simple);

#if USE_GNU_HASH_NEON

static void BM_gnu_hash_neon(benchmark::State& state) {
  for (auto _ : state) {
    for (const char* sym_name : kSampleSymbolList) {
      benchmark::DoNotOptimize(calculate_gnu_hash_neon(sym_name));
    }
  }
}

BENCHMARK(BM_gnu_hash_neon);

#endif  // USE_GNU_HASH_NEON

BENCHMARK_MAIN();
