/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <math.h>

#include <fenv.h>

#include <gtest/gtest.h>

#if defined(__BIONIC__)
typedef struct {
  float expected;
  float call_data;
} tanf_intel_data_t;

static tanf_intel_data_t g_tanf_intel_data[] = {
  { // Entry 0
    -0x1.00000000001555555555577777777777p-21,
    -0x1.p-21
  },
  { // Entry 1
    0x1.00000000001555555555577777777777p-21,
    0x1.p-21
  },
  { // Entry 2
    -0x1.p-149,
    -0x1.p-149
  },
  { // Entry 3
    0x1.p-149,
    0x1.p-149
  },
  { // Entry 4
    -0x1.00000200000000000000155555d55556p-41,
    -0x1.000002p-41
  },
  { // Entry 5
    0x1.00000200000000000000155555d55556p-41,
    0x1.000002p-41
  },
  { // Entry 6
    -0x1.ffb7eb004b7e12b369388faaa0342f6cp-3,
    -0x1.27cca6p7
  },
  { // Entry 7
    0x1.ffb7eb004b7e12b369388faaa0342f6cp-3,
    0x1.27cca6p7
  },
  { // Entry 8
    -0x1.3b7ddaffdc9a2fad39f329743fbf49e5p4,
    -0x1.2a5996p2
  },
  { // Entry 9
    0x1.3b7ddaffdc9a2fad39f329743fbf49e5p4,
    0x1.2a5996p2
  },
  { // Entry 10
    0x1.819f32ffd97b1ed667bc143387037ddep-1,
    -0x1.3f7f22p1
  },
  { // Entry 11
    -0x1.819f32ffd97b1ed667bc143387037ddep-1,
    0x1.3f7f22p1
  },
  { // Entry 12
    -0x1.405f900000000000000a7402846583d0p-38,
    -0x1.405f90p-38
  },
  { // Entry 13
    0x1.405f900000000000000a7402846583d0p-38,
    0x1.405f90p-38
  },
  { // Entry 14
    -0x1.8cd79995344c7943c7b3e021607da3cbp-2,
    -0x1.496e80p96
  },
  { // Entry 15
    0x1.8cd79995344c7943c7b3e021607da3cbp-2,
    0x1.496e80p96
  },
  { // Entry 16
    0x1.e144471ea2b49b6c1fdceff8ccceea7bp10,
    -0x1.5fe0p3
  },
  { // Entry 17
    -0x1.e144471ea2b49b6c1fdceff8ccceea7bp10,
    0x1.5fe0p3
  },
  { // Entry 18
    -0x1.ca0f4c2315ab5a9729e6afa857677b3fp-1,
    -0x1.75aef0p-1
  },
  { // Entry 19
    0x1.ca0f4c2315ab5a9729e6afa857677b3fp-1,
    0x1.75aef0p-1
  },
  { // Entry 20
    -0x1.c33ed50b887775a5d613c08c488fbb9cp3,
    -0x1.80p0
  },
  { // Entry 21
    0x1.c33ed50b887775a5d613c08c488fbb9cp3,
    0x1.80p0
  },
  { // Entry 22
    -0x1.c34513ee7140fdb8217e83dc2d6d6f53p3,
    -0x1.800040p0
  },
  { // Entry 23
    0x1.c34513ee7140fdb8217e83dc2d6d6f53p3,
    0x1.800040p0
  },
  { // Entry 24
    0x1.4e6b8a48164b9e1d8175e4512ab22ff1p0,
    -0x1.8e3560p98
  },
  { // Entry 25
    -0x1.4e6b8a48164b9e1d8175e4512ab22ff1p0,
    0x1.8e3560p98
  },
  { // Entry 26
    -0x1.d017e0214a953265d8dd5c0a11ea61d1p-1,
    -0x1.9de7d4p4
  },
  { // Entry 27
    0x1.d017e0214a953265d8dd5c0a11ea61d1p-1,
    0x1.9de7d4p4
  },
  { // Entry 28
    -0x1.d0473f02270c0eec883e753e50800670p-1,
    -0x1.9de8a4p4
  },
  { // Entry 29
    0x1.d0473f02270c0eec883e753e50800670p-1,
    0x1.9de8a4p4
  },
  { // Entry 30
    0x1.d0aada22aa5e3dc35b5063c639047df5p-1,
    -0x1.be7e5ap5
  },
  { // Entry 31
    -0x1.d0aada22aa5e3dc35b5063c639047df5p-1,
    0x1.be7e5ap5
  },
  { // Entry 32
    -0x1.ee9495000a190cdb6db3e83d2c05ef38p-2,
    -0x1.ccbeb0p-2
  },
  { // Entry 33
    0x1.ee9495000a190cdb6db3e83d2c05ef38p-2,
    0x1.ccbeb0p-2
  },
  { // Entry 34
    0x1.dc32eba638d13458c7b29d96abffe1cap-7,
    -0x1.fffep127
  },
  { // Entry 35
    -0x1.dc32eba638d13458c7b29d96abffe1cap-7,
    0x1.fffep127
  },
  { // Entry 36
    0x1.00000000001555555555577777777777p-21,
    0x1.p-21
  },
  { // Entry 37
    -0x1.00000000001555555555577777777777p-21,
    -0x1.p-21
  },
  { // Entry 38
    0x1.p-131,
    0x1.p-131
  },
  { // Entry 39
    -0x1.p-131,
    -0x1.p-131
  },
  { // Entry 40
    0x1.p-149,
    0x1.p-149
  },
  { // Entry 41
    -0x1.p-149,
    -0x1.p-149
  },
  { // Entry 42
    0x1.52f50e757941cbff5b7c2e06a1ab7e9dp6,
    0x1.p63
  },
  { // Entry 43
    -0x1.52f50e757941cbff5b7c2e06a1ab7e9dp6,
    -0x1.p63
  },
  { // Entry 44
    0x1.00000200000000000000155555d55556p-41,
    0x1.000002p-41
  },
  { // Entry 45
    -0x1.00000200000000000000155555d55556p-41,
    -0x1.000002p-41
  },
  { // Entry 46
    -0x1.adb7eb6d8cebbe362f197dbeda5c113cp-1,
    0x1.000002p51
  },
  { // Entry 47
    0x1.adb7eb6d8cebbe362f197dbeda5c113cp-1,
    -0x1.000002p51
  },
  { // Entry 48
    0x1.f7762b752b006715d90c389a11826d6bp1,
    0x1.000004p127
  },
  { // Entry 49
    -0x1.f7762b752b006715d90c389a11826d6bp1,
    -0x1.000004p127
  },
  { // Entry 50
    -0x1.09cff10000671912c84762f18c285470p0,
    0x1.000090p7
  },
  { // Entry 51
    0x1.09cff10000671912c84762f18c285470p0,
    -0x1.000090p7
  },
  { // Entry 52
    0x1.015901017edb67aa7e52ae694e990a19p-3,
    0x1.000180p-3
  },
  { // Entry 53
    -0x1.015901017edb67aa7e52ae694e990a19p-3,
    -0x1.000180p-3
  },
  { // Entry 54
    0x1.0002200000000000000055577559d958p-40,
    0x1.000220p-40
  },
  { // Entry 55
    -0x1.0002200000000000000055577559d958p-40,
    -0x1.000220p-40
  },
  { // Entry 56
    0x1.6d53796cdd401e3ddc09e835b8ea660ap3,
    0x1.000380p127
  },
  { // Entry 57
    -0x1.6d53796cdd401e3ddc09e835b8ea660ap3,
    -0x1.000380p127
  },
  { // Entry 58
    -0x1.b070e3a6968463af6e9db922e7845524p-7,
    0x1.000880p9
  },
  { // Entry 59
    0x1.b070e3a6968463af6e9db922e7845524p-7,
    -0x1.000880p9
  },
  { // Entry 60
    -0x1.fa61dcffa3efe325b32704fc412462cfp1,
    0x1.0020p62
  },
  { // Entry 61
    0x1.fa61dcffa3efe325b32704fc412462cfp1,
    -0x1.0020p62
  },
  { // Entry 62
    0x1.fffd825a3f377f012209982a00c346f0p-2,
    0x1.0060p90
  },
  { // Entry 63
    -0x1.fffd825a3f377f012209982a00c346f0p-2,
    -0x1.0060p90
  },
  { // Entry 64
    0x1.013c68fff04b698165dfdf9d48444a95p-6,
    0x1.0137p-6
  },
  { // Entry 65
    -0x1.013c68fff04b698165dfdf9d48444a95p-6,
    -0x1.0137p-6
  },
  { // Entry 66
    0x1.932c994f61d804a084f20d975a617c50p0,
    0x1.014cp0
  },
  { // Entry 67
    -0x1.932c994f61d804a084f20d975a617c50p0,
    -0x1.014cp0
  },
  { // Entry 68
    -0x1.c34ec20533e760565cb762b15c18d6fcp1,
    0x1.020446p58
  },
  { // Entry 69
    0x1.c34ec20533e760565cb762b15c18d6fcp1,
    -0x1.020446p58
  },
  { // Entry 70
    0x1.9ff71767ea051e4e9cc0008922b11129p0,
    0x1.04e4p0
  },
  { // Entry 71
    -0x1.9ff71767ea051e4e9cc0008922b11129p0,
    -0x1.04e4p0
  },
  { // Entry 72
    0x1.07c9c5001659079722f8e9190ffe6ec6p-3,
    0x1.0658p-3
  },
  { // Entry 73
    -0x1.07c9c5001659079722f8e9190ffe6ec6p-3,
    -0x1.0658p-3
  },
  { // Entry 74
    0x1.fd611072a50357e6266768b2cdf0194cp-3,
    0x1.0ac710p100
  },
  { // Entry 75
    -0x1.fd611072a50357e6266768b2cdf0194cp-3,
    -0x1.0ac710p100
  },
  { // Entry 76
    0x1.0ddbb5000244c4fb972eb72de00896c0p-3,
    0x1.0c50p-3
  },
  { // Entry 77
    -0x1.0ddbb5000244c4fb972eb72de00896c0p-3,
    -0x1.0c50p-3
  },
  { // Entry 78
    -0x1.c0aeb5f84be95da5ab0716dfba205e28p2,
    0x1.0ddcp96
  },
  { // Entry 79
    0x1.c0aeb5f84be95da5ab0716dfba205e28p2,
    -0x1.0ddcp96
  },
  { // Entry 80
    0x1.340754fffffeb780761e86337f0c55efp1,
    0x1.0e28a6p4
  },
  { // Entry 81
    -0x1.340754fffffeb780761e86337f0c55efp1,
    -0x1.0e28a6p4
  },
  { // Entry 82
    0x1.349d95ffee472ec7c10934570d3ba486p-1,
    0x1.15bcp-1
  },
  { // Entry 83
    -0x1.349d95ffee472ec7c10934570d3ba486p-1,
    -0x1.15bcp-1
  },
  { // Entry 84
    0x1.eec72403a4fd24d0c9e2af088a05fb85p0,
    0x1.17e4p0
  },
  { // Entry 85
    -0x1.eec72403a4fd24d0c9e2af088a05fb85p0,
    -0x1.17e4p0
  },
  { // Entry 86
    0x1.ef4bd7a215237b3065d569fd4c5f5a47p0,
    0x1.18p0
  },
  { // Entry 87
    -0x1.ef4bd7a215237b3065d569fd4c5f5a47p0,
    -0x1.18p0
  },
  { // Entry 88
    -0x1.fe793900138c9941836b4fcbc9b2260dp-4,
    0x1.18p64
  },
  { // Entry 89
    0x1.fe793900138c9941836b4fcbc9b2260dp-4,
    -0x1.18p64
  },
  { // Entry 90
    0x1.f08f0873c5819a9f7cc6bbf3c5291cc0p0,
    0x1.1844p0
  },
  { // Entry 91
    -0x1.f08f0873c5819a9f7cc6bbf3c5291cc0p0,
    -0x1.1844p0
  },
  { // Entry 92
    0x1.5c51cc18f091bc4b54ee83623438c9a7p11,
    0x1.18fffep19
  },
  { // Entry 93
    -0x1.5c51cc18f091bc4b54ee83623438c9a7p11,
    -0x1.18fffep19
  },
  { // Entry 94
    0x1.2633567898e691eeb87ad026bd16a7e4p-2,
    0x1.1e7cp-2
  },
  { // Entry 95
    -0x1.2633567898e691eeb87ad026bd16a7e4p-2,
    -0x1.1e7cp-2
  },
  { // Entry 96
    0x1.ffffedf558bfb3100f61125f296b8badp1,
    0x1.1ebep18
  },
  { // Entry 97
    -0x1.ffffedf558bfb3100f61125f296b8badp1,
    -0x1.1ebep18
  },
  { // Entry 98
    0x1.0e551b00007fae17236421a76e861c75p1,
    0x1.20ea9cp0
  },
  { // Entry 99
    -0x1.0e551b00007fae17236421a76e861c75p1,
    -0x1.20ea9cp0
  },
  { // Entry 100
    0x1.c07dfb0552ba60b71c7df6bd7ca409d6p20,
    0x1.2106cap5
  },
  { // Entry 101
    -0x1.c07dfb0552ba60b71c7df6bd7ca409d6p20,
    -0x1.2106cap5
  },
  { // Entry 102
    -0x1.fd23fd64a4bfcfb597c46933649f5ae2p-2,
    0x1.219dc6p119
  },
  { // Entry 103
    0x1.fd23fd64a4bfcfb597c46933649f5ae2p-2,
    -0x1.219dc6p119
  },
  { // Entry 104
    -0x1.b93c13000d016d14e756c25e42302d9fp-3,
    0x1.26cd6ap3
  },
  { // Entry 105
    0x1.b93c13000d016d14e756c25e42302d9fp-3,
    -0x1.26cd6ap3
  },
  { // Entry 106
    -0x1.ebcbcb138b274cbcbe61af5113da83ecp-4,
    0x1.29c4e0p3
  },
  { // Entry 107
    0x1.ebcbcb138b274cbcbe61af5113da83ecp-4,
    -0x1.29c4e0p3
  },
  { // Entry 108
    0x1.99bc5b961b1b24fdb77fcee08ba2f720p-25,
    0x1.2d97c8p4
  },
  { // Entry 109
    -0x1.99bc5b961b1b24fdb77fcee08ba2f720p-25,
    -0x1.2d97c8p4
  },
  { // Entry 110
    -0x1.ed18af0b0ba80dfa6e8ee1b3b31dfc60p-1,
    0x1.30p1
  },
  { // Entry 111
    0x1.ed18af0b0ba80dfa6e8ee1b3b31dfc60p-1,
    -0x1.30p1
  },
  { // Entry 112
    0x1.9ab24111cfc62df4dbca320216b94651p-4,
    0x1.30ca70p3
  },
  { // Entry 113
    -0x1.9ab24111cfc62df4dbca320216b94651p-4,
    -0x1.30ca70p3
  },
  { // Entry 114
    0x1.337d8ffffffede62f050e98b3b9596e1p-3,
    0x1.3135f0p-3
  },
  { // Entry 115
    -0x1.337d8ffffffede62f050e98b3b9596e1p-3,
    -0x1.3135f0p-3
  },
  { // Entry 116
    0x1.348e650000002ef3a765b9416d12cf7ep-3,
    0x1.3240bcp-3
  },
  { // Entry 117
    -0x1.348e650000002ef3a765b9416d12cf7ep-3,
    -0x1.3240bcp-3
  },
  { // Entry 118
    -0x1.b9e58aec61a44ab533c2b83726367e17p-8,
    0x1.32d53cp16
  },
  { // Entry 119
    0x1.b9e58aec61a44ab533c2b83726367e17p-8,
    -0x1.32d53cp16
  },
  { // Entry 120
    -0x1.e1fd68edea44fb78780ed62e73c6e017p-6,
    0x1.3a0aa8p6
  },
  { // Entry 121
    0x1.e1fd68edea44fb78780ed62e73c6e017p-6,
    -0x1.3a0aa8p6
  },
  { // Entry 122
    -0x1.62a28100001393080f6733dfaf9c76fcp-1,
    0x1.4495bap1
  },
  { // Entry 123
    0x1.62a28100001393080f6733dfaf9c76fcp-1,
    -0x1.4495bap1
  },
  { // Entry 124
    0x1.b923c3ba0bc0c500ba4c245301bad207p1,
    0x1.49d42ap0
  },
  { // Entry 125
    -0x1.b923c3ba0bc0c500ba4c245301bad207p1,
    -0x1.49d42ap0
  },
  { // Entry 126
    0x1.541f3f00022ac25cc8a90855ab6bb808p-3,
    0x1.510bbcp-3
  },
  { // Entry 127
    -0x1.541f3f00022ac25cc8a90855ab6bb808p-3,
    -0x1.510bbcp-3
  },
  { // Entry 128
    0x1.76f3efffff3057122e6e7ce50d12cbcep-3,
    0x1.549520p100
  },
  { // Entry 129
    -0x1.76f3efffff3057122e6e7ce50d12cbcep-3,
    -0x1.549520p100
  },
  { // Entry 130
    0x1.4cac0300643e12c46203b47d3eeed4ffp-9,
    0x1.54c4bap24
  },
  { // Entry 131
    -0x1.4cac0300643e12c46203b47d3eeed4ffp-9,
    -0x1.54c4bap24
  },
  { // Entry 132
    -0x1.70d5450000058974c20b97ba96fdae03p-3,
    0x1.5a757ep24
  },
  { // Entry 133
    0x1.70d5450000058974c20b97ba96fdae03p-3,
    -0x1.5a757ep24
  },
  { // Entry 134
    -0x1.ffffe9bba7f1321fae192943a3e848c0p-1,
    0x1.5fdbc0p2
  },
  { // Entry 135
    0x1.ffffe9bba7f1321fae192943a3e848c0p-1,
    -0x1.5fdbc0p2
  },
  { // Entry 136
    -0x1.ffb68f0050dabe5ce719202610fcac2ep-1,
    0x1.5fe056p2
  },
  { // Entry 137
    0x1.ffb68f0050dabe5ce719202610fcac2ep-1,
    -0x1.5fe056p2
  },
  { // Entry 138
    -0x1.dabb46e3937e6c505ab2062232339a16p-7,
    0x1.6493d4p95
  },
  { // Entry 139
    0x1.dabb46e3937e6c505ab2062232339a16p-7,
    -0x1.6493d4p95
  },
  { // Entry 140
    0x1.c832162481e1ce4f01736bb97a3019b9p-1,
    0x1.74a566p-1
  },
  { // Entry 141
    -0x1.c832162481e1ce4f01736bb97a3019b9p-1,
    -0x1.74a566p-1
  },
  { // Entry 142
    0x1.7b2fa40000038d569226512c77976ff5p-3,
    0x1.76f0b2p-3
  },
  { // Entry 143
    -0x1.7b2fa40000038d569226512c77976ff5p-3,
    -0x1.76f0b2p-3
  },
  { // Entry 144
    -0x1.4f375ad9dee5fd604fb29435f32efe57p1,
    0x1.78b3fap100
  },
  { // Entry 145
    0x1.4f375ad9dee5fd604fb29435f32efe57p1,
    -0x1.78b3fap100
  },
  { // Entry 146
    -0x1.00005efffbe73e7bafeab7f76c8a93efp0,
    0x1.78fdb4p3
  },
  { // Entry 147
    0x1.00005efffbe73e7bafeab7f76c8a93efp0,
    -0x1.78fdb4p3
  },
  { // Entry 148
    -0x1.fc3ace000029c331692aa9fe4e42f004p-1,
    0x1.791cp3
  },
  { // Entry 149
    0x1.fc3ace000029c331692aa9fe4e42f004p-1,
    -0x1.791cp3
  },
  { // Entry 150
    0x1.dcfa3254b53b6a70cec4473abe850102p-1,
    0x1.7ffffep-1
  },
  { // Entry 151
    -0x1.dcfa3254b53b6a70cec4473abe850102p-1,
    -0x1.7ffffep-1
  },
  { // Entry 152
    0x1.c33ed50b887775a5d613c08c488fbb9cp3,
    0x1.80p0
  },
  { // Entry 153
    -0x1.c33ed50b887775a5d613c08c488fbb9cp3,
    -0x1.80p0
  },
  { // Entry 154
    0x1.8008p-130,
    0x1.8008p-130
  },
  { // Entry 155
    -0x1.8008p-130,
    -0x1.8008p-130
  },
  { // Entry 156
    -0x1.f96370ec482d2bb0eb8ea7a530139fcfp-5,
    0x1.8180p83
  },
  { // Entry 157
    0x1.f96370ec482d2bb0eb8ea7a530139fcfp-5,
    -0x1.8180p83
  },
  { // Entry 158
    -0x1.fff664faa6f86fa8b4e5e2719d2195cfp-1,
    0x1.89e090p9
  },
  { // Entry 159
    0x1.fff664faa6f86fa8b4e5e2719d2195cfp-1,
    -0x1.89e090p9
  },
  { // Entry 160
    0x1.1c051101643be740782fe0dfc9dcd1ccp0,
    0x1.8c631ep15
  },
  { // Entry 161
    -0x1.1c051101643be740782fe0dfc9dcd1ccp0,
    -0x1.8c631ep15
  },
  { // Entry 162
    0x1.bb2e88f26b9363f9a852665f3413d994p13,
    0x1.8c67fep127
  },
  { // Entry 163
    -0x1.bb2e88f26b9363f9a852665f3413d994p13,
    -0x1.8c67fep127
  },
  { // Entry 164
    -0x1.f0e4ec133585cb30e67cfcbb36faad8ep1,
    0x1.91d858p12
  },
  { // Entry 165
    0x1.f0e4ec133585cb30e67cfcbb36faad8ep1,
    -0x1.91d858p12
  },
  { // Entry 166
    -0x1.5d14946dc98975d6421a55284fe020a1p24,
    0x1.921fb6p0
  },
  { // Entry 167
    0x1.5d14946dc98975d6421a55284fe020a1p24,
    -0x1.921fb6p0
  },
  { // Entry 168
    0x1.980ee0cfbf0f1ebc9d4fd24cce3cdfe7p15,
    0x1.922922p15
  },
  { // Entry 169
    -0x1.980ee0cfbf0f1ebc9d4fd24cce3cdfe7p15,
    -0x1.922922p15
  },
  { // Entry 170
    -0x1.fd43f8e891e227ddad2fb2e5520d4ff2p-1,
    0x1.9230fep15
  },
  { // Entry 171
    0x1.fd43f8e891e227ddad2fb2e5520d4ff2p-1,
    -0x1.9230fep15
  },
  { // Entry 172
    0x1.cf38f6212e7e6276f4add54878f1a7dbp-1,
    0x1.9510c8p6
  },
  { // Entry 173
    -0x1.cf38f6212e7e6276f4add54878f1a7dbp-1,
    -0x1.9510c8p6
  },
  { // Entry 174
    0x1.d03d45024c3ca4a2c4e1a91856135046p-1,
    0x1.9511e6p6
  },
  { // Entry 175
    -0x1.d03d45024c3ca4a2c4e1a91856135046p-1,
    -0x1.9511e6p6
  },
  { // Entry 176
    0x1.0554eb5cbd393e4f0770c86528f39ee1p17,
    0x1.979f24p9
  },
  { // Entry 177
    -0x1.0554eb5cbd393e4f0770c86528f39ee1p17,
    -0x1.979f24p9
  },
  { // Entry 178
    0x1.fad5df93de3051cf018ab32c0b323571p-1,
    0x1.a1e862p119
  },
  { // Entry 179
    -0x1.fad5df93de3051cf018ab32c0b323571p-1,
    -0x1.a1e862p119
  },
  { // Entry 180
    0x1.ff981b1534f78016bea4d9588254e996p3,
    0x1.ad1fp63
  },
  { // Entry 181
    -0x1.ff981b1534f78016bea4d9588254e996p3,
    -0x1.ad1fp63
  },
  { // Entry 182
    -0x1.fff4a1db1e1e38c438ddd38bb94f6d31p1,
    0x1.ada3dap39
  },
  { // Entry 183
    0x1.fff4a1db1e1e38c438ddd38bb94f6d31p1,
    -0x1.ada3dap39
  },
  { // Entry 184
    0x1.d01529023d951390200a4252f038b4afp-1,
    0x1.b125bap5
  },
  { // Entry 185
    -0x1.d01529023d951390200a4252f038b4afp-1,
    -0x1.b125bap5
  },
  { // Entry 186
    0x1.d67fa105f76868612c84f74a1f38f0acp-2,
    0x1.b90a02p-2
  },
  { // Entry 187
    -0x1.d67fa105f76868612c84f74a1f38f0acp-2,
    -0x1.b90a02p-2
  },
  { // Entry 188
    0x1.99663da94dbd57199cb8e3dae7018358p-23,
    0x1.beeeeep80
  },
  { // Entry 189
    -0x1.99663da94dbd57199cb8e3dae7018358p-23,
    -0x1.beeeeep80
  },
  { // Entry 190
    0x1.eb96571eb9da1337e703cc20e41e9719p-13,
    0x1.c3abf0p24
  },
  { // Entry 191
    -0x1.eb96571eb9da1337e703cc20e41e9719p-13,
    -0x1.c3abf0p24
  },
  { // Entry 192
    0x1.e198c48bef954151ee075815d85c5363p0,
    0x1.c71c74p116
  },
  { // Entry 193
    -0x1.e198c48bef954151ee075815d85c5363p0,
    -0x1.c71c74p116
  },
  { // Entry 194
    -0x1.e50e524610728cfb239cc6305b212fd6p-1,
    0x1.cc3252p18
  },
  { // Entry 195
    0x1.e50e524610728cfb239cc6305b212fd6p-1,
    -0x1.cc3252p18
  },
  { // Entry 196
    -0x1.6a69e7bb21b52030964bc21ced077c71p19,
    0x1.d38a2ap19
  },
  { // Entry 197
    0x1.6a69e7bb21b52030964bc21ced077c71p19,
    -0x1.d38a2ap19
  },
  { // Entry 198
    0x1.6529bf81b958ca781cdaac7cec6e636ep0,
    0x1.df0648p24
  },
  { // Entry 199
    -0x1.6529bf81b958ca781cdaac7cec6e636ep0,
    -0x1.df0648p24
  },
  { // Entry 200
    0x1.659e43b4315f21ba5e7048b1d8d7815cp0,
    0x1.df2204p24
  },
  { // Entry 201
    -0x1.659e43b4315f21ba5e7048b1d8d7815cp0,
    -0x1.df2204p24
  },
  { // Entry 202
    -0x1.71a580ffc4e167ae0ef8b02d5d27c99dp-1,
    0x1.df34p24
  },
  { // Entry 203
    0x1.71a580ffc4e167ae0ef8b02d5d27c99dp-1,
    -0x1.df34p24
  },
  { // Entry 204
    0x1.ecf119000017a2caef4290b4d6c63785p-4,
    0x1.ea951ap-4
  },
  { // Entry 205
    -0x1.ecf119000017a2caef4290b4d6c63785p-4,
    -0x1.ea951ap-4
  },
  { // Entry 206
    0x1.ccd55821fad69755c2d824be2bfd4c64p-1,
    0x1.efedc6p1
  },
  { // Entry 207
    -0x1.ccd55821fad69755c2d824be2bfd4c64p-1,
    -0x1.efedc6p1
  },
  { // Entry 208
    0x1.d6981efffff2549634686a24dfda77cep-1,
    0x1.f143a2p1
  },
  { // Entry 209
    -0x1.d6981efffff2549634686a24dfda77cep-1,
    -0x1.f143a2p1
  },
  { // Entry 210
    0x1.dba4d1124a78a6803a0965af0ab79f88p3,
    0x1.f25b06p2
  },
  { // Entry 211
    -0x1.dba4d1124a78a6803a0965af0ab79f88p3,
    -0x1.f25b06p2
  },
  { // Entry 212
    -0x1.6dfcbaffd78023ecfabbf7ccf0a0e4b4p-1,
    0x1.f32218p24
  },
  { // Entry 213
    0x1.6dfcbaffd78023ecfabbf7ccf0a0e4b4p-1,
    -0x1.f32218p24
  },
  { // Entry 214
    -0x1.ec35cf000061079295ead714892db1cap1,
    0x1.f44dbcp58
  },
  { // Entry 215
    0x1.ec35cf000061079295ead714892db1cap1,
    -0x1.f44dbcp58
  },
  { // Entry 216
    0x1.db06c10d2a959715bc0a2e75e6da093bp4,
    0x1.f47ffep2
  },
  { // Entry 217
    -0x1.db06c10d2a959715bc0a2e75e6da093bp4,
    -0x1.f47ffep2
  },
  { // Entry 218
    0x1.ffffeb55643b9a648c2720bde1d22764p-1,
    0x1.f6a7a0p1
  },
  { // Entry 219
    -0x1.ffffeb55643b9a648c2720bde1d22764p-1,
    -0x1.f6a7a0p1
  },
  { // Entry 220
    0x1.c0a570ffffd379d0972ea78cd040c304p-3,
    0x1.f6ded8p8
  },
  { // Entry 221
    -0x1.c0a570ffffd379d0972ea78cd040c304p-3,
    -0x1.f6ded8p8
  },
  { // Entry 222
    -0x1.cdf18d01234809a6895315e9de59d864p-1,
    0x1.f7ffbep15
  },
  { // Entry 223
    0x1.cdf18d01234809a6895315e9de59d864p-1,
    -0x1.f7ffbep15
  },
  { // Entry 224
    -0x1.82f196fb60a81dc3b4dcbbc831ab8f85p-1,
    0x1.f7fffep47
  },
  { // Entry 225
    0x1.82f196fb60a81dc3b4dcbbc831ab8f85p-1,
    -0x1.f7fffep47
  },
  { // Entry 226
    0x1.6c03590f3fe3b7d29e89ee0e65fc9b1ep0,
    0x1.f87d58p24
  },
  { // Entry 227
    -0x1.6c03590f3fe3b7d29e89ee0e65fc9b1ep0,
    -0x1.f87d58p24
  },
  { // Entry 228
    -0x1.c7ae6e9c145b8d54f7719893fa03849fp27,
    0x1.f9cbe2p7
  },
  { // Entry 229
    0x1.c7ae6e9c145b8d54f7719893fa03849fp27,
    -0x1.f9cbe2p7
  },
  { // Entry 230
    0x1.6d2910005161b2bfa61134d0fbc9e9c0p0,
    0x1.fd86bcp24
  },
  { // Entry 231
    -0x1.6d2910005161b2bfa61134d0fbc9e9c0p0,
    -0x1.fd86bcp24
  },
  { // Entry 232
    0x1.6c8f8d0c3ad4bbb639a3f3a94237f69fp0,
    0x1.fefa4ap24
  },
  { // Entry 233
    -0x1.6c8f8d0c3ad4bbb639a3f3a94237f69fp0,
    -0x1.fefa4ap24
  },
  { // Entry 234
    0x1.00e5b5fffa13f7d9c4b0b52fe11a339bp-3,
    0x1.ff1ffep-4
  },
  { // Entry 235
    -0x1.00e5b5fffa13f7d9c4b0b52fe11a339bp-3,
    -0x1.ff1ffep-4
  },
  { // Entry 236
    0x1.ff3f41f01c5b360cce75b67877ffd677p0,
    0x1.ff7ffep41
  },
  { // Entry 237
    -0x1.ff3f41f01c5b360cce75b67877ffd677p0,
    -0x1.ff7ffep41
  },
  { // Entry 238
    -0x1.86dd5e00d7edc7266969bf5198438babp0,
    0x1.ff9ffep12
  },
  { // Entry 239
    0x1.86dd5e00d7edc7266969bf5198438babp0,
    -0x1.ff9ffep12
  },
  { // Entry 240
    -0x1.f8fe4579fdee2491c7d8572ea512fe93p5,
    0x1.fffbfep45
  },
  { // Entry 241
    0x1.f8fe4579fdee2491c7d8572ea512fe93p5,
    -0x1.fffbfep45
  },
  { // Entry 242
    -0x1.85ff462f0f86ff44641305da18ea8fc8p-13,
    0x1.fffdf2p23
  },
  { // Entry 243
    0x1.85ff462f0f86ff44641305da18ea8fc8p-13,
    -0x1.fffdf2p23
  },
  { // Entry 244
    0x1.3392e2ffbcb25fc1b016b9136e69c00bp-2,
    0x1.fffdfep3
  },
  { // Entry 245
    -0x1.3392e2ffbcb25fc1b016b9136e69c00bp-2,
    -0x1.fffdfep3
  },
  { // Entry 246
    -0x1.2f6c4bd2605f037f8609819f865a8dcbp8,
    0x1.fffe3ep41
  },
  { // Entry 247
    0x1.2f6c4bd2605f037f8609819f865a8dcbp8,
    -0x1.fffe3ep41
  },
  { // Entry 248
    -0x1.53a2e90e817727255e6ddf64e28c019cp-9,
    0x1.fffe7ep103
  },
  { // Entry 249
    0x1.53a2e90e817727255e6ddf64e28c019cp-9,
    -0x1.fffe7ep103
  },
  { // Entry 250
    -0x1.b34676f095b5b1a325426cdf42c04799p2,
    0x1.ffff7ep2
  },
  { // Entry 251
    0x1.b34676f095b5b1a325426cdf42c04799p2,
    -0x1.ffff7ep2
  },
  { // Entry 252
    0x1.f640d94e6241db4349e33bed67cbd3dbp-1,
    0x1.ffff7ep119
  },
  { // Entry 253
    -0x1.f640d94e6241db4349e33bed67cbd3dbp-1,
    -0x1.ffff7ep119
  },
  { // Entry 254
    0x1.526c269bdda8a89d90706870f3801eafp-1,
    0x1.ffffeep4
  },
  { // Entry 255
    -0x1.526c269bdda8a89d90706870f3801eafp-1,
    -0x1.ffffeep4
  },
  { // Entry 256
    -0x1.a37593c105e1462c2a37260603483da6p1,
    0x1.fffffcp12
  },
  { // Entry 257
    0x1.a37593c105e1462c2a37260603483da6p1,
    -0x1.fffffcp12
  },
  { // Entry 258
    -0x1.p-149,
    -0x1.p-149
  },
  { // Entry 259
    0x1.p-149,
    0x1.p-149
  },
  { // Entry 260
    0.0,
    0.0
  },
  { // Entry 261
    0x1.p-149,
    0x1.p-149
  },
  { // Entry 262
    -0x1.p-149,
    -0x1.p-149
  },
  { // Entry 263
    -0x1.000002p-126,
    -0x1.000002p-126
  },
  { // Entry 264
    0x1.000002p-126,
    0x1.000002p-126
  },
  { // Entry 265
    -0x1.p-126,
    -0x1.p-126
  },
  { // Entry 266
    0x1.p-126,
    0x1.p-126
  },
  { // Entry 267
    -0x1.fffffcp-127,
    -0x1.fffffcp-127
  },
  { // Entry 268
    0x1.fffffcp-127,
    0x1.fffffcp-127
  },
  { // Entry 269
    0x1.fffffcp-127,
    0x1.fffffcp-127
  },
  { // Entry 270
    -0x1.fffffcp-127,
    -0x1.fffffcp-127
  },
  { // Entry 271
    0x1.p-126,
    0x1.p-126
  },
  { // Entry 272
    -0x1.p-126,
    -0x1.p-126
  },
  { // Entry 273
    0x1.000002p-126,
    0x1.000002p-126
  },
  { // Entry 274
    -0x1.000002p-126,
    -0x1.000002p-126
  },
  { // Entry 275
    0x1.99999a57619f679b6193af8a0a7a8778p-13,
    0x1.99999ap-13
  },
  { // Entry 276
    -0x1.99999a57619f679b6193af8a0a7a8778p-13,
    -0x1.99999ap-13
  },
  { // Entry 277
    0x1.99999b5d867eaadd0305587399905311p-12,
    0x1.99999ap-12
  },
  { // Entry 278
    -0x1.99999b5d867eaadd0305587399905311p-12,
    -0x1.99999ap-12
  },
  { // Entry 279
    0x1.3333364dd2fb949645bea998cbc1ee72p-11,
    0x1.333334p-11
  },
  { // Entry 280
    -0x1.3333364dd2fb949645bea998cbc1ee72p-11,
    -0x1.333334p-11
  },
  { // Entry 281
    0x1.99999f761a0b726c18b00c6496cbe10dp-11,
    0x1.99999ap-11
  },
  { // Entry 282
    -0x1.99999f761a0b726c18b00c6496cbe10dp-11,
    -0x1.99999ap-11
  },
  { // Entry 283
    0x1.000005555577777854854dedc28ead51p-10,
    0x1.p-10
  },
  { // Entry 284
    -0x1.000005555577777854854dedc28ead51p-10,
    -0x1.p-10
  },
  { // Entry 285
    0x1.33333d374c2e05d108161378389fc84fp-10,
    0x1.333334p-10
  },
  { // Entry 286
    -0x1.33333d374c2e05d108161378389fc84fp-10,
    -0x1.333334p-10
  },
  { // Entry 287
    0x1.666676a27a6d8214d198b2321ef9a9dcp-10,
    0x1.666668p-10
  },
  { // Entry 288
    -0x1.666676a27a6d8214d198b2321ef9a9dcp-10,
    -0x1.666668p-10
  },
  { // Entry 289
    0x1.9999b1d8698c24cfe3b90ffd006ffdcap-10,
    0x1.99999cp-10
  },
  { // Entry 290
    -0x1.9999b1d8698c24cfe3b90ffd006ffdcap-10,
    -0x1.99999cp-10
  },
  { // Entry 291
    0x1.cccceb1aa219f71bb19208d74a739bb1p-10,
    0x1.ccccccp-10
  },
  { // Entry 292
    -0x1.cccceb1aa219f71bb19208d74a739bb1p-10,
    -0x1.ccccccp-10
  },
  { // Entry 293
    0x1.0667d5968bbbbe4037024b9c93f7b049p-7,
    0x1.066666p-7
  },
  { // Entry 294
    -0x1.0667d5968bbbbe4037024b9c93f7b049p-7,
    -0x1.066666p-7
  },
  { // Entry 295
    0x1.ccd492d035a227758b8c30d79b168826p-7,
    0x1.ccccccp-7
  },
  { // Entry 296
    -0x1.ccd492d035a227758b8c30d79b168826p-7,
    -0x1.ccccccp-7
  },
  { // Entry 297
    0x1.49a4fa68e90d228f445026eb29adcefdp-6,
    0x1.499998p-6
  },
  { // Entry 298
    -0x1.49a4fa68e90d228f445026eb29adcefdp-6,
    -0x1.499998p-6
  },
  { // Entry 299
    0x1.ace5de090603fda8f519afece05c17eap-6,
    0x1.acccccp-6
  },
  { // Entry 300
    -0x1.ace5de090603fda8f519afece05c17eap-6,
    -0x1.acccccp-6
  },
  { // Entry 301
    0x1.081767fd3cb685f7b069146ce3333851p-5,
    0x1.08p-5
  },
  { // Entry 302
    -0x1.081767fd3cb685f7b069146ce3333851p-5,
    -0x1.08p-5
  },
  { // Entry 303
    0x1.39c0d745334a3387d672e4a05624bca5p-5,
    0x1.39999ap-5
  },
  { // Entry 304
    -0x1.39c0d745334a3387d672e4a05624bca5p-5,
    -0x1.39999ap-5
  },
  { // Entry 305
    0x1.6b702c627fc00b777ea8661cce36061cp-5,
    0x1.6b3334p-5
  },
  { // Entry 306
    -0x1.6b702c627fc00b777ea8661cce36061cp-5,
    -0x1.6b3334p-5
  },
  { // Entry 307
    0x1.9d26574cd84759bfff51d8bb18538a0dp-5,
    0x1.9ccccep-5
  },
  { // Entry 308
    -0x1.9d26574cd84759bfff51d8bb18538a0dp-5,
    -0x1.9ccccep-5
  },
  { // Entry 309
    0x1.cee4467e15bb7ef59658a8eddc195167p-5,
    0x1.ce6666p-5
  },
  { // Entry 310
    -0x1.cee4467e15bb7ef59658a8eddc195167p-5,
    -0x1.ce6666p-5
  },
  { // Entry 311
    0x1.a1eaed7aa62a740c0b2e09bcd0f735b5p-1,
    0x1.5e7fc4p-1
  },
  { // Entry 312
    -0x1.a1eaed7aa62a740c0b2e09bcd0f735b5p-1,
    -0x1.5e7fc4p-1
  },
  { // Entry 313
    0x1.d93b891cbcb15aac8b5796a0a16bf29ep1,
    0x1.4e7fc4p0
  },
  { // Entry 314
    -0x1.d93b891cbcb15aac8b5796a0a16bf29ep1,
    -0x1.4e7fc4p0
  },
  { // Entry 315
    -0x1.563ad063486c797653a68955c0bb1c0bp1,
    0x1.edbfa6p0
  },
  { // Entry 316
    0x1.563ad063486c797653a68955c0bb1c0bp1,
    -0x1.edbfa6p0
  },
  { // Entry 317
    -0x1.576b789d544b6d037c3b7119fd6dd6p-1,
    0x1.467fc4p1
  },
  { // Entry 318
    0x1.576b789d544b6d037c3b7119fd6dd6p-1,
    -0x1.467fc4p1
  },
  { // Entry 319
    0x1.00150652b2d7931e0c878875b9f4ba82p-5,
    0x1.961fb4p1
  },
  { // Entry 320
    -0x1.00150652b2d7931e0c878875b9f4ba82p-5,
    -0x1.961fb4p1
  },
  { // Entry 321
    0x1.87e987b6e5071dbd3f755a76a27d8fc8p-1,
    0x1.e5bfa4p1
  },
  { // Entry 322
    -0x1.87e987b6e5071dbd3f755a76a27d8fc8p-1,
    -0x1.e5bfa4p1
  },
  { // Entry 323
    0x1.a49e55bce1c8991232387ecd1124698ap1,
    0x1.1aafcap2
  },
  { // Entry 324
    -0x1.a49e55bce1c8991232387ecd1124698ap1,
    -0x1.1aafcap2
  },
  { // Entry 325
    -0x1.79cf03135a93679d5aa2e1dcc5adedafp1,
    0x1.427fc2p2
  },
  { // Entry 326
    0x1.79cf03135a93679d5aa2e1dcc5adedafp1,
    -0x1.427fc2p2
  },
  { // Entry 327
    -0x1.6f1f86fdb20bc9923627b94d771f5388p-1,
    0x1.6a4fbap2
  },
  { // Entry 328
    0x1.6f1f86fdb20bc9923627b94d771f5388p-1,
    -0x1.6a4fbap2
  },
  { // Entry 329
    -0x1.67747ca802821c66c87a086638f28d36p-1,
    0x1.6af2f0p2
  },
  { // Entry 330
    0x1.67747ca802821c66c87a086638f28d36p-1,
    -0x1.6af2f0p2
  },
  { // Entry 331
    -0x1.626a30298df0c42c2cf7a8f9c166d55dp1,
    0x1.43c62ap2
  },
  { // Entry 332
    0x1.626a30298df0c42c2cf7a8f9c166d55dp1,
    -0x1.43c62ap2
  },
  { // Entry 333
    0x1.d6ad8a22a4407cc68df20cda1ea1c6aap1,
    0x1.1c9964p2
  },
  { // Entry 334
    -0x1.d6ad8a22a4407cc68df20cda1ea1c6aap1,
    -0x1.1c9964p2
  },
  { // Entry 335
    0x1.a94d00a1710d9bcc7b80481f42857d05p-1,
    0x1.ead93cp1
  },
  { // Entry 336
    -0x1.a94d00a1710d9bcc7b80481f42857d05p-1,
    -0x1.ead93cp1
  },
  { // Entry 337
    0x1.4cb9f4d315a995b28bfbd6e6a0905738p-4,
    0x1.9c7fb0p1
  },
  { // Entry 338
    -0x1.4cb9f4d315a995b28bfbd6e6a0905738p-4,
    -0x1.9c7fb0p1
  },
  { // Entry 339
    -0x1.2cb6f3ba51cd4ca385d7f4a7567c3a0bp-1,
    0x1.4e2624p1
  },
  { // Entry 340
    0x1.2cb6f3ba51cd4ca385d7f4a7567c3a0bp-1,
    -0x1.4e2624p1
  },
  { // Entry 341
    -0x1.18d9399a8290b3f8b42a4afc1f4b21dep1,
    0x1.ff9932p0
  },
  { // Entry 342
    0x1.18d9399a8290b3f8b42a4afc1f4b21dep1,
    -0x1.ff9932p0
  },
  { // Entry 343
    0x1.56fd94b0c0681613d3831608457f5bf6p2,
    0x1.62e61cp0
  },
  { // Entry 344
    -0x1.56fd94b0c0681613d3831608457f5bf6p2,
    -0x1.62e61cp0
  },
  { // Entry 345
    0x1.f4ad37f13e818641fc1555bf78e0e942p-1,
    0x1.8c662cp-1
  },
  { // Entry 346
    -0x1.f4ad37f13e818641fc1555bf78e0e942p-1,
    -0x1.8c662cp-1
  },
  { // Entry 347
    0x1.6a7e30ad8460f1a710479e2db9495c9cp3,
    -0x1.a8aa1cp0
  },
  { // Entry 348
    -0x1.6a7e30ad8460f1a710479e2db9495c9cp3,
    0x1.a8aa1cp0
  },
  { // Entry 349
    0x1.0d71ffac1d5e6aa753cf804a2a8c1f5bp6,
    -0x1.95ec8ap0
  },
  { // Entry 350
    -0x1.0d71ffac1d5e6aa753cf804a2a8c1f5bp6,
    0x1.95ec8ap0
  },
  { // Entry 351
    -0x1.11d8498073e1f4b776fe5672abb1f54ap4,
    -0x1.832ef8p0
  },
  { // Entry 352
    0x1.11d8498073e1f4b776fe5672abb1f54ap4,
    0x1.832ef8p0
  },
  { // Entry 353
    -0x1.e3a34b32708883a8578805f84ea03c6ap2,
    -0x1.707166p0
  },
  { // Entry 354
    0x1.e3a34b32708883a8578805f84ea03c6ap2,
    0x1.707166p0
  },
  { // Entry 355
    -0x1.3429d2634054eaae3bdbee94a6cec17fp2,
    -0x1.5db3d4p0
  },
  { // Entry 356
    0x1.3429d2634054eaae3bdbee94a6cec17fp2,
    0x1.5db3d4p0
  },
  { // Entry 357
    -0x1.c08c957bbb45acafa856bfd792cbf663p1,
    -0x1.4af642p0
  },
  { // Entry 358
    0x1.c08c957bbb45acafa856bfd792cbf663p1,
    0x1.4af642p0
  },
  { // Entry 359
    -0x1.5d602b0d0bdda825221a53369c5338d7p1,
    -0x1.3838b0p0
  },
  { // Entry 360
    0x1.5d602b0d0bdda825221a53369c5338d7p1,
    0x1.3838b0p0
  },
  { // Entry 361
    -0x1.1b4894e498720ec01735a02e55eefad8p1,
    -0x1.257b1ep0
  },
  { // Entry 362
    0x1.1b4894e498720ec01735a02e55eefad8p1,
    0x1.257b1ep0
  },
  { // Entry 363
    -0x1.d74cb200ab59040290627a9b2ffe29cfp0,
    -0x1.12bd92p0
  },
  { // Entry 364
    0x1.d74cb200ab59040290627a9b2ffe29cfp0,
    0x1.12bd92p0
  },
  { // Entry 365
    -0x1.6be7019f34d34f25cb0c14d0c7bc7b32p0,
    -0x1.ea5c3ep-1
  },
  { // Entry 366
    0x1.6be7019f34d34f25cb0c14d0c7bc7b32p0,
    0x1.ea5c3ep-1
  },
  { // Entry 367
    -0x1.4d0defbcb48aa75ce13e1b82f1fcb049p0,
    -0x1.d4b87cp-1
  },
  { // Entry 368
    0x1.4d0defbcb48aa75ce13e1b82f1fcb049p0,
    0x1.d4b87cp-1
  },
  { // Entry 369
    -0x1.316c87fdb7599cb57354e4b99f38d7ffp0,
    -0x1.bf14bap-1
  },
  { // Entry 370
    0x1.316c87fdb7599cb57354e4b99f38d7ffp0,
    0x1.bf14bap-1
  },
  { // Entry 371
    -0x1.18729dfe51dfcf767f79f39b689ae95ep0,
    -0x1.a970f8p-1
  },
  { // Entry 372
    0x1.18729dfe51dfcf767f79f39b689ae95ep0,
    0x1.a970f8p-1
  },
  { // Entry 373
    -0x1.01aeea9cbe9a8fb4ccef99ad961b6ad8p0,
    -0x1.93cd36p-1
  },
  { // Entry 374
    0x1.01aeea9cbe9a8fb4ccef99ad961b6ad8p0,
    0x1.93cd36p-1
  },
  { // Entry 375
    -0x1.d98e373faad7da3d6c8865a7ff9ba7f3p-1,
    -0x1.7e2974p-1
  },
  { // Entry 376
    0x1.d98e373faad7da3d6c8865a7ff9ba7f3p-1,
    0x1.7e2974p-1
  },
  { // Entry 377
    -0x1.b2e46af704eb75d1fab0766afc74703fp-1,
    -0x1.6885b2p-1
  },
  { // Entry 378
    0x1.b2e46af704eb75d1fab0766afc74703fp-1,
    0x1.6885b2p-1
  },
  { // Entry 379
    -0x1.8ee90b7dc89b1f999ae6dbb41baceb0dp-1,
    -0x1.52e1f0p-1
  },
  { // Entry 380
    0x1.8ee90b7dc89b1f999ae6dbb41baceb0dp-1,
    0x1.52e1f0p-1
  },
  { // Entry 381
    -0x1.6d395f05820b42f51223dab884367e71p-1,
    -0x1.3d3e36p-1
  },
  { // Entry 382
    0x1.6d395f05820b42f51223dab884367e71p-1,
    0x1.3d3e36p-1
  },
  { // Entry 383
    -0x1.24e3dfad4ce1493caa123864cb4f45d3p-1,
    -0x1.0a0b02p-1
  },
  { // Entry 384
    0x1.24e3dfad4ce1493caa123864cb4f45d3p-1,
    0x1.0a0b02p-1
  },
  { // Entry 385
    -0x1.fdbd5e53e0a6fc9c8b803289f1c3dbb7p-2,
    -0x1.d8f720p-2
  },
  { // Entry 386
    0x1.fdbd5e53e0a6fc9c8b803289f1c3dbb7p-2,
    0x1.d8f720p-2
  },
  { // Entry 387
    -0x1.b5f3d61c54ee4f6585e9bff489c00182p-2,
    -0x1.9dd83cp-2
  },
  { // Entry 388
    0x1.b5f3d61c54ee4f6585e9bff489c00182p-2,
    0x1.9dd83cp-2
  },
  { // Entry 389
    -0x1.71a0f907c661daf4903b7bbc015c5c14p-2,
    -0x1.62b958p-2
  },
  { // Entry 390
    0x1.71a0f907c661daf4903b7bbc015c5c14p-2,
    0x1.62b958p-2
  },
  { // Entry 391
    -0x1.30190941e699fdb2115a9ef6bf82d455p-2,
    -0x1.279a74p-2
  },
  { // Entry 392
    0x1.30190941e699fdb2115a9ef6bf82d455p-2,
    0x1.279a74p-2
  },
  { // Entry 393
    -0x1.e18e93867caf67efcaa19821898d50cap-3,
    -0x1.d8f720p-3
  },
  { // Entry 394
    0x1.e18e93867caf67efcaa19821898d50cap-3,
    0x1.d8f720p-3
  },
  { // Entry 395
    -0x1.665077dda822b189a56a02e15c04d5d4p-3,
    -0x1.62b958p-3
  },
  { // Entry 396
    0x1.665077dda822b189a56a02e15c04d5d4p-3,
    0x1.62b958p-3
  },
  { // Entry 397
    -0x1.db1423d877b250af6ea5546960743d72p-4,
    -0x1.d8f720p-4
  },
  { // Entry 398
    0x1.db1423d877b250af6ea5546960743d72p-4,
    0x1.d8f720p-4
  },
  { // Entry 399
    -0x1.d97dd643ffeef57d0a225051978ec8adp-5,
    -0x1.d8f720p-5
  },
  { // Entry 400
    0x1.d97dd643ffeef57d0a225051978ec8adp-5,
    0x1.d8f720p-5
  },
  { // Entry 401
    0x1.d97dd643ffeef57d0a225051978ec8adp-5,
    0x1.d8f720p-5
  },
  { // Entry 402
    -0x1.d97dd643ffeef57d0a225051978ec8adp-5,
    -0x1.d8f720p-5
  },
  { // Entry 403
    0x1.db1423d877b250af6ea5546960743d72p-4,
    0x1.d8f720p-4
  },
  { // Entry 404
    -0x1.db1423d877b250af6ea5546960743d72p-4,
    -0x1.d8f720p-4
  },
  { // Entry 405
    0x1.665077dda822b189a56a02e15c04d5d4p-3,
    0x1.62b958p-3
  },
  { // Entry 406
    -0x1.665077dda822b189a56a02e15c04d5d4p-3,
    -0x1.62b958p-3
  },
  { // Entry 407
    0x1.e18e93867caf67efcaa19821898d50cap-3,
    0x1.d8f720p-3
  },
  { // Entry 408
    -0x1.e18e93867caf67efcaa19821898d50cap-3,
    -0x1.d8f720p-3
  },
  { // Entry 409
    0x1.30190941e699fdb2115a9ef6bf82d455p-2,
    0x1.279a74p-2
  },
  { // Entry 410
    -0x1.30190941e699fdb2115a9ef6bf82d455p-2,
    -0x1.279a74p-2
  },
  { // Entry 411
    0x1.71a0f907c661daf4903b7bbc015c5c14p-2,
    0x1.62b958p-2
  },
  { // Entry 412
    -0x1.71a0f907c661daf4903b7bbc015c5c14p-2,
    -0x1.62b958p-2
  },
  { // Entry 413
    0x1.b5f3d61c54ee4f6585e9bff489c00182p-2,
    0x1.9dd83cp-2
  },
  { // Entry 414
    -0x1.b5f3d61c54ee4f6585e9bff489c00182p-2,
    -0x1.9dd83cp-2
  },
  { // Entry 415
    0x1.fdbd5e53e0a6fc9c8b803289f1c3dbb7p-2,
    0x1.d8f720p-2
  },
  { // Entry 416
    -0x1.fdbd5e53e0a6fc9c8b803289f1c3dbb7p-2,
    -0x1.d8f720p-2
  },
  { // Entry 417
    0x1.24e3dfad4ce1493caa123864cb4f45d3p-1,
    0x1.0a0b02p-1
  },
  { // Entry 418
    -0x1.24e3dfad4ce1493caa123864cb4f45d3p-1,
    -0x1.0a0b02p-1
  },
  { // Entry 419
    0x1.6d395f05820b42f51223dab884367e71p-1,
    0x1.3d3e36p-1
  },
  { // Entry 420
    -0x1.6d395f05820b42f51223dab884367e71p-1,
    -0x1.3d3e36p-1
  },
  { // Entry 421
    0x1.8ee91858fbaaf2a34a32dd947fd7e076p-1,
    0x1.52e1f8p-1
  },
  { // Entry 422
    -0x1.8ee91858fbaaf2a34a32dd947fd7e076p-1,
    -0x1.52e1f8p-1
  },
  { // Entry 423
    0x1.b2e478bc9ba738db90b2a4bc294ecf4fp-1,
    0x1.6885bap-1
  },
  { // Entry 424
    -0x1.b2e478bc9ba738db90b2a4bc294ecf4fp-1,
    -0x1.6885bap-1
  },
  { // Entry 425
    0x1.d98e4617a8bd1a1bb9e2e989d8ad35ccp-1,
    0x1.7e297cp-1
  },
  { // Entry 426
    -0x1.d98e4617a8bd1a1bb9e2e989d8ad35ccp-1,
    -0x1.7e297cp-1
  },
  { // Entry 427
    0x1.01aef2aa416545e3900864f2b35d86a6p0,
    0x1.93cd3ep-1
  },
  { // Entry 428
    -0x1.01aef2aa416545e3900864f2b35d86a6p0,
    -0x1.93cd3ep-1
  },
  { // Entry 429
    0x1.1872a6cb3dba156db8dc784e95d96a46p0,
    0x1.a971p-1
  },
  { // Entry 430
    -0x1.1872a6cb3dba156db8dc784e95d96a46p0,
    -0x1.a971p-1
  },
  { // Entry 431
    0x1.316c91af46b015a9c931a816fed89092p0,
    0x1.bf14c2p-1
  },
  { // Entry 432
    -0x1.316c91af46b015a9c931a816fed89092p0,
    -0x1.bf14c2p-1
  },
  { // Entry 433
    0x1.4d0dfa81e9cc806c10194fba6b767761p0,
    0x1.d4b884p-1
  },
  { // Entry 434
    -0x1.4d0dfa81e9cc806c10194fba6b767761p0,
    -0x1.d4b884p-1
  },
  { // Entry 435
    0x1.6be7019f34d34f25cb0c14d0c7bc7b32p0,
    0x1.ea5c3ep-1
  },
  { // Entry 436
    -0x1.6be7019f34d34f25cb0c14d0c7bc7b32p0,
    -0x1.ea5c3ep-1
  },
  { // Entry 437
    0x1.d74cb200ab59040290627a9b2ffe29cfp0,
    0x1.12bd92p0
  },
  { // Entry 438
    -0x1.d74cb200ab59040290627a9b2ffe29cfp0,
    -0x1.12bd92p0
  },
  { // Entry 439
    0x1.1b48a6964c024648f186bb6b1ebdeec2p1,
    0x1.257b24p0
  },
  { // Entry 440
    -0x1.1b48a6964c024648f186bb6b1ebdeec2p1,
    -0x1.257b24p0
  },
  { // Entry 441
    0x1.5d604466c5aee8f1a1d8470f7ff579cfp1,
    0x1.3838b6p0
  },
  { // Entry 442
    -0x1.5d604466c5aee8f1a1d8470f7ff579cfp1,
    -0x1.3838b6p0
  },
  { // Entry 443
    0x1.c08cbd52d2b012f0cb47bcb3ff513c6dp1,
    0x1.4af648p0
  },
  { // Entry 444
    -0x1.c08cbd52d2b012f0cb47bcb3ff513c6dp1,
    -0x1.4af648p0
  },
  { // Entry 445
    0x1.3429f6aa3446d703e6ef96e0b564fc0cp2,
    0x1.5db3dap0
  },
  { // Entry 446
    -0x1.3429f6aa3446d703e6ef96e0b564fc0cp2,
    -0x1.5db3dap0
  },
  { // Entry 447
    0x1.e3a3a25b2606418a13970971beef41d6p2,
    0x1.70716cp0
  },
  { // Entry 448
    -0x1.e3a3a25b2606418a13970971beef41d6p2,
    -0x1.70716cp0
  },
  { // Entry 449
    0x1.11d8b7ba41694658111af48925bbad68p4,
    0x1.832efep0
  },
  { // Entry 450
    -0x1.11d8b7ba41694658111af48925bbad68p4,
    -0x1.832efep0
  },
  { // Entry 451
    -0x1.0d70563193fe219f3fd31a285f4d6638p6,
    0x1.95ec90p0
  },
  { // Entry 452
    0x1.0d70563193fe219f3fd31a285f4d6638p6,
    -0x1.95ec90p0
  },
  { // Entry 453
    -0x1.6a7e30ad8460f1a710479e2db9495c9cp3,
    0x1.a8aa1cp0
  },
  { // Entry 454
    0x1.6a7e30ad8460f1a710479e2db9495c9cp3,
    -0x1.a8aa1cp0
  },
  { // Entry 455
    0x1.9f39ee9fedb2375ec05d6da7a288c6bdp0,
    0x1.04aff8p0
  },
  { // Entry 456
    -0x1.9f39ee9fedb2375ec05d6da7a288c6bdp0,
    -0x1.04aff8p0
  },
  { // Entry 457
    0x1.9f3c509c6a7d75e451088359c88def88p0,
    0x1.04b0a0p0
  },
  { // Entry 458
    -0x1.9f3c509c6a7d75e451088359c88def88p0,
    -0x1.04b0a0p0
  },
  { // Entry 459
    0x1.9f3eb29df9e6a20467474e24d8bf35bap0,
    0x1.04b148p0
  },
  { // Entry 460
    -0x1.9f3eb29df9e6a20467474e24d8bf35bap0,
    -0x1.04b148p0
  },
  { // Entry 461
    0x1.9f4114a49bfffc3f5a183d36000aa785p0,
    0x1.04b1f0p0
  },
  { // Entry 462
    -0x1.9f4114a49bfffc3f5a183d36000aa785p0,
    -0x1.04b1f0p0
  },
  { // Entry 463
    0x1.9f4376b050dbc56bf5596083192077b5p0,
    0x1.04b298p0
  },
  { // Entry 464
    -0x1.9f4376b050dbc56bf5596083192077b5p0,
    -0x1.04b298p0
  },
  { // Entry 465
    0x1.9f45d8c1188c3eb77bca2c4a84c7eaddp0,
    0x1.04b340p0
  },
  { // Entry 466
    -0x1.9f45d8c1188c3eb77bca2c4a84c7eaddp0,
    -0x1.04b340p0
  },
  { // Entry 467
    0x1.9f483ad6f323a9a5a90d4ae07a23d266p0,
    0x1.04b3e8p0
  },
  { // Entry 468
    -0x1.9f483ad6f323a9a5a90d4ae07a23d266p0,
    -0x1.04b3e8p0
  },
  { // Entry 469
    0x1.9f4a9cf1e0b44810b3aa7cca45d71cc9p0,
    0x1.04b490p0
  },
  { // Entry 470
    -0x1.9f4a9cf1e0b44810b3aa7cca45d71cc9p0,
    -0x1.04b490p0
  },
  { // Entry 471
    0x1.9f4cf08af6c60ed6e2badd5a7b5c1e87p0,
    0x1.04b534p0
  },
  { // Entry 472
    -0x1.9f4cf08af6c60ed6e2badd5a7b5c1e87p0,
    -0x1.04b534p0
  },
  { // Entry 473
    -0x1.p-149,
    -0x1.p-149
  },
  { // Entry 474
    0x1.p-149,
    0x1.p-149
  },
  { // Entry 475
    0.0,
    0.0
  },
  { // Entry 476
    0x1.p-149,
    0x1.p-149
  },
  { // Entry 477
    -0x1.p-149,
    -0x1.p-149
  },
  { // Entry 478
    0x1.4d82b334a582a56a802f96b3b96feb81p-1,
    0x1.279a72p-1
  },
  { // Entry 479
    -0x1.4d82b334a582a56a802f96b3b96feb81p-1,
    -0x1.279a72p-1
  },
  { // Entry 480
    0x1.4d82b60de428f92aa8c96a4a7fe88945p-1,
    0x1.279a74p-1
  },
  { // Entry 481
    -0x1.4d82b60de428f92aa8c96a4a7fe88945p-1,
    -0x1.279a74p-1
  },
  { // Entry 482
    0x1.4d82b8e722d302f5aa939a563b12b1a1p-1,
    0x1.279a76p-1
  },
  { // Entry 483
    -0x1.4d82b8e722d302f5aa939a563b12b1a1p-1,
    -0x1.279a76p-1
  },
  { // Entry 484
    -0x1.89714760e8fed9af03a91cf1527ceaadp2,
    0x1.bb67acp0
  },
  { // Entry 485
    0x1.89714760e8fed9af03a91cf1527ceaadp2,
    -0x1.bb67acp0
  },
  { // Entry 486
    -0x1.897133fb81f3169b3161d50b50ccc1a7p2,
    0x1.bb67aep0
  },
  { // Entry 487
    0x1.897133fb81f3169b3161d50b50ccc1a7p2,
    -0x1.bb67aep0
  },
  { // Entry 488
    -0x1.897120961cc4475eb3b8061df0409430p2,
    0x1.bb67b0p0
  },
  { // Entry 489
    0x1.897120961cc4475eb3b8061df0409430p2,
    -0x1.bb67b0p0
  },
  { // Entry 490
    0x1.def49c3ab0ad5dde93ba34c54db714c7p-2,
    0x1.bffffep-2
  },
  { // Entry 491
    -0x1.def49c3ab0ad5dde93ba34c54db714c7p-2,
    -0x1.bffffep-2
  },
  { // Entry 492
    0x1.def49eaab37a1479231e899509ecf26cp-2,
    0x1.c0p-2
  },
  { // Entry 493
    -0x1.def49eaab37a1479231e899509ecf26cp-2,
    -0x1.c0p-2
  },
  { // Entry 494
    0x1.def4a11ab647eef212b1997d3b51405ap-2,
    0x1.c00002p-2
  },
  { // Entry 495
    -0x1.def4a11ab647eef212b1997d3b51405ap-2,
    -0x1.c00002p-2
  },
  { // Entry 496
    0x1.a46caf652fa18987e4d0a79f8145dd5bp-1,
    0x1.5ffffep-1
  },
  { // Entry 497
    -0x1.a46caf652fa18987e4d0a79f8145dd5bp-1,
    -0x1.5ffffep-1
  },
  { // Entry 498
    0x1.a46cb2be6a0b1dacb36269c41a4a9147p-1,
    0x1.60p-1
  },
  { // Entry 499
    -0x1.a46cb2be6a0b1dacb36269c41a4a9147p-1,
    -0x1.60p-1
  },
  { // Entry 500
    0x1.a46cb617a47a31a156dc0005b4e6ebp-1,
    0x1.600002p-1
  },
  { // Entry 501
    -0x1.a46cb617a47a31a156dc0005b4e6ebp-1,
    -0x1.600002p-1
  },
  { // Entry 502
    0x1.3d6dc230869c70d5937fedc92d424df2p1,
    0x1.2ffffep0
  },
  { // Entry 503
    -0x1.3d6dc230869c70d5937fedc92d424df2p1,
    -0x1.2ffffep0
  },
  { // Entry 504
    0x1.3d6dc956eac7d3b8d6eb2174110d1ddcp1,
    0x1.30p0
  },
  { // Entry 505
    -0x1.3d6dc956eac7d3b8d6eb2174110d1ddcp1,
    -0x1.30p0
  },
  { // Entry 506
    0x1.3d6dd07d4f3a237589ad5c41c3801cb4p1,
    0x1.300002p0
  },
  { // Entry 507
    -0x1.3d6dd07d4f3a237589ad5c41c3801cb4p1,
    -0x1.300002p0
  },
  { // Entry 508
    -0x1.b2d8a858c90a538d1daad78040e69b98p-1,
    0x1.37fffep1
  },
  { // Entry 509
    0x1.b2d8a858c90a538d1daad78040e69b98p-1,
    -0x1.37fffep1
  },
  { // Entry 510
    -0x1.b2d89a938294c8a2604db9f7aa56a0f8p-1,
    0x1.38p1
  },
  { // Entry 511
    0x1.b2d89a938294c8a2604db9f7aa56a0f8p-1,
    -0x1.38p1
  },
  { // Entry 512
    -0x1.b2d88cce3c7cce174266439da309cf60p-1,
    0x1.380002p1
  },
  { // Entry 513
    0x1.b2d88cce3c7cce174266439da309cf60p-1,
    -0x1.380002p1
  },
  { // Entry 514
    0x1.06f8d0cecf169b06467e4aa036cf8279p-4,
    0x1.069c8cp-4
  },
  { // Entry 515
    -0x1.06f8d0cecf169b06467e4aa036cf8279p-4,
    -0x1.069c8cp-4
  },
  { // Entry 516
    0x1.080f746cd17397b60f908e2be01f7ba7p-3,
    0x1.069c8cp-3
  },
  { // Entry 517
    -0x1.080f746cd17397b60f908e2be01f7ba7p-3,
    -0x1.069c8cp-3
  },
  { // Entry 518
    0x1.8ed91550469d0eb08aae20658958043bp-3,
    0x1.89ead2p-3
  },
  { // Entry 519
    -0x1.8ed91550469d0eb08aae20658958043bp-3,
    -0x1.89ead2p-3
  },
  { // Entry 520
    0x1.0c864149dc68276df299282d04f69af6p-2,
    0x1.069c8cp-2
  },
  { // Entry 521
    -0x1.0c864149dc68276df299282d04f69af6p-2,
    -0x1.069c8cp-2
  },
  { // Entry 522
    0x1.53fdd01a98f07f208555cc644276ef2cp-2,
    0x1.4843b0p-2
  },
  { // Entry 523
    -0x1.53fdd01a98f07f208555cc644276ef2cp-2,
    -0x1.4843b0p-2
  },
  { // Entry 524
    0x1.9e925b7e237b88ac6098b513c371757cp-2,
    0x1.89ead4p-2
  },
  { // Entry 525
    -0x1.9e925b7e237b88ac6098b513c371757cp-2,
    -0x1.89ead4p-2
  },
  { // Entry 526
    0x1.ed21eadb08e47db8b2f11880fbb52879p-2,
    0x1.cb91f8p-2
  },
  { // Entry 527
    -0x1.ed21eadb08e47db8b2f11880fbb52879p-2,
    -0x1.cb91f8p-2
  },
  { // Entry 528
    0x1.205a63a04e31e1852af3da22e9f69a19p-1,
    0x1.069c8ep-1
  },
  { // Entry 529
    -0x1.205a63a04e31e1852af3da22e9f69a19p-1,
    -0x1.069c8ep-1
  },
  { // Entry 530
    0x1.4d466f84a3288515ab699dd1cec345d3p-1,
    0x1.277020p-1
  },
  { // Entry 531
    -0x1.4d466f84a3288515ab699dd1cec345d3p-1,
    -0x1.277020p-1
  },
  { // Entry 532
    0x1.7e1d9983b58754a29012e17a26f277d7p-1,
    0x1.4843b2p-1
  },
  { // Entry 533
    -0x1.7e1d9983b58754a29012e17a26f277d7p-1,
    -0x1.4843b2p-1
  },
  { // Entry 534
    0x1.b3df402fe49842a4164cf380ffa5dcp-1,
    0x1.691744p-1
  },
  { // Entry 535
    -0x1.b3df402fe49842a4164cf380ffa5dcp-1,
    -0x1.691744p-1
  },
  { // Entry 536
    0x1.efd8311ddf2cc393f20ea767c7b2264ap-1,
    0x1.89ead6p-1
  },
  { // Entry 537
    -0x1.efd8311ddf2cc393f20ea767c7b2264ap-1,
    -0x1.89ead6p-1
  },
  { // Entry 538
    0x1.19e271a6444ff34aa2f73c85014971c9p0,
    0x1.aabe68p-1
  },
  { // Entry 539
    -0x1.19e271a6444ff34aa2f73c85014971c9p0,
    -0x1.aabe68p-1
  },
  { // Entry 540
    0x1.410393802c1a22382914abf096afbee9p0,
    0x1.cb91fap-1
  },
  { // Entry 541
    -0x1.410393802c1a22382914abf096afbee9p0,
    -0x1.cb91fap-1
  },
  { // Entry 542
    0x1.6efed33b714045fe99cfa59471e1e9fdp0,
    0x1.ec658cp-1
  },
  { // Entry 543
    -0x1.6efed33b714045fe99cfa59471e1e9fdp0,
    -0x1.ec658cp-1
  },
  { // Entry 544
    0x1.a64c86c02e7a7d96e91f96a5584129f4p0,
    0x1.069c8ep0
  },
  { // Entry 545
    -0x1.a64c86c02e7a7d96e91f96a5584129f4p0,
    -0x1.069c8ep0
  },
  { // Entry 546
    0x1.eab4477e5b226dc5270bae9720ea13e3p0,
    0x1.170656p0
  },
  { // Entry 547
    -0x1.eab4477e5b226dc5270bae9720ea13e3p0,
    -0x1.170656p0
  },
  { // Entry 548
    0x1.21277f9a7d2f66bb131cff32f26629cdp1,
    0x1.27701ep0
  },
  { // Entry 549
    -0x1.21277f9a7d2f66bb131cff32f26629cdp1,
    -0x1.27701ep0
  },
  { // Entry 550
    0x1.5bd1406825b3ffeba48221ad6a8f5414p1,
    0x1.37d9e6p0
  },
  { // Entry 551
    -0x1.5bd1406825b3ffeba48221ad6a8f5414p1,
    -0x1.37d9e6p0
  },
  { // Entry 552
    0x1.af464352a989f802824152cad0afe8b7p1,
    0x1.4843aep0
  },
  { // Entry 553
    -0x1.af464352a989f802824152cad0afe8b7p1,
    -0x1.4843aep0
  },
  { // Entry 554
    0x1.1866fa7a601b87bb6f378b3438e3fc26p2,
    0x1.58ad76p0
  },
  { // Entry 555
    -0x1.1866fa7a601b87bb6f378b3438e3fc26p2,
    -0x1.58ad76p0
  },
  { // Entry 556
    0x1.8bdcc68718a70118860a1b945437fd90p2,
    0x1.69173ep0
  },
  { // Entry 557
    -0x1.8bdcc68718a70118860a1b945437fd90p2,
    -0x1.69173ep0
  },
  { // Entry 558
    0x1.4bb68859d3eafb2a130b73ba07e48e8ap3,
    0x1.798106p0
  },
  { // Entry 559
    -0x1.4bb68859d3eafb2a130b73ba07e48e8ap3,
    -0x1.798106p0
  },
  { // Entry 560
    0x1.f2efabaeb322ec5ca9d33869295c6063p4,
    0x1.89eacep0
  },
  { // Entry 561
    -0x1.f2efabaeb322ec5ca9d33869295c6063p4,
    -0x1.89eacep0
  },
  { // Entry 562
    -0x1.f2f13929323ef8f58db152143e65bcb7p4,
    0x1.9a5496p0
  },
  { // Entry 563
    0x1.f2f13929323ef8f58db152143e65bcb7p4,
    -0x1.9a5496p0
  },
  { // Entry 564
    -0x1.4bb6e0ec02cad5c110a4d70039db4d1cp3,
    0x1.aabe5ep0
  },
  { // Entry 565
    0x1.4bb6e0ec02cad5c110a4d70039db4d1cp3,
    -0x1.aabe5ep0
  },
  { // Entry 566
    -0x1.8bdd06a655dfa2f3195aca48798e5c86p2,
    0x1.bb2826p0
  },
  { // Entry 567
    0x1.8bdd06a655dfa2f3195aca48798e5c86p2,
    -0x1.bb2826p0
  },
  { // Entry 568
    -0x1.18671b76cfccf98a6edbc1fd5b8647b7p2,
    0x1.cb91eep0
  },
  { // Entry 569
    0x1.18671b76cfccf98a6edbc1fd5b8647b7p2,
    -0x1.cb91eep0
  },
  { // Entry 570
    -0x1.af466bac80dc9df668d1e0e9b442bf0ep1,
    0x1.dbfbb6p0
  },
  { // Entry 571
    0x1.af466bac80dc9df668d1e0e9b442bf0ep1,
    -0x1.dbfbb6p0
  },
  { // Entry 572
    -0x1.5bd15bcb3d06906cef5f3b2ec3ab4ab9p1,
    0x1.ec657ep0
  },
  { // Entry 573
    0x1.5bd15bcb3d06906cef5f3b2ec3ab4ab9p1,
    -0x1.ec657ep0
  },
  { // Entry 574
    -0x1.2127938a546d3c428292ba53ee6f67ccp1,
    0x1.fccf46p0
  },
  { // Entry 575
    0x1.2127938a546d3c428292ba53ee6f67ccp1,
    -0x1.fccf46p0
  },
  { // Entry 576
    -0x1.eab45caed706c4db622c90fe3e8d16c2p0,
    0x1.069c88p1
  },
  { // Entry 577
    0x1.eab45caed706c4db622c90fe3e8d16c2p0,
    -0x1.069c88p1
  },
  { // Entry 578
    -0x1.a64c979eb703d82cb4808044e8abf93fp0,
    0x1.0ed16cp1
  },
  { // Entry 579
    0x1.a64c979eb703d82cb4808044e8abf93fp0,
    -0x1.0ed16cp1
  },
  { // Entry 580
    -0x1.6efee11500263c10c1d1bb5904244de6p0,
    0x1.170650p1
  },
  { // Entry 581
    0x1.6efee11500263c10c1d1bb5904244de6p0,
    -0x1.170650p1
  },
  { // Entry 582
    -0x1.4103a1bc0f6576a760d49da3bfe55874p0,
    0x1.1f3b34p1
  },
  { // Entry 583
    0x1.4103a1bc0f6576a760d49da3bfe55874p0,
    -0x1.1f3b34p1
  },
  { // Entry 584
    -0x1.19e2801aa24ee0adcd9491e4d7af256fp0,
    0x1.277018p1
  },
  { // Entry 585
    0x1.19e2801aa24ee0adcd9491e4d7af256fp0,
    -0x1.277018p1
  },
  { // Entry 586
    -0x1.efd84e50652c1b7c71972ad8ee7c018ap-1,
    0x1.2fa4fcp1
  },
  { // Entry 587
    0x1.efd84e50652c1b7c71972ad8ee7c018ap-1,
    -0x1.2fa4fcp1
  },
  { // Entry 588
    -0x1.b3df5d9f54e2c748cf0227ee0974ea2ep-1,
    0x1.37d9e0p1
  },
  { // Entry 589
    0x1.b3df5d9f54e2c748cf0227ee0974ea2ep-1,
    -0x1.37d9e0p1
  },
  { // Entry 590
    -0x1.7e1db733769a1126a2b0ac7fa14a402cp-1,
    0x1.400ec4p1
  },
  { // Entry 591
    0x1.7e1db733769a1126a2b0ac7fa14a402cp-1,
    -0x1.400ec4p1
  },
  { // Entry 592
    -0x1.4d468d82c1a84fef7279fc5fb24419b2p-1,
    0x1.4843a8p1
  },
  { // Entry 593
    0x1.4d468d82c1a84fef7279fc5fb24419b2p-1,
    -0x1.4843a8p1
  },
  { // Entry 594
    -0x1.205a8202545202d891ce89bfa6cd1476p-1,
    0x1.50788cp1
  },
  { // Entry 595
    0x1.205a8202545202d891ce89bfa6cd1476p-1,
    -0x1.50788cp1
  },
  { // Entry 596
    -0x1.ed22289d891ed78cdc818a4cde6de918p-2,
    0x1.58ad70p1
  },
  { // Entry 597
    0x1.ed22289d891ed78cdc818a4cde6de918p-2,
    -0x1.58ad70p1
  },
  { // Entry 598
    -0x1.9e929a7fadf83b6f9e8fb851f512b44bp-2,
    0x1.60e254p1
  },
  { // Entry 599
    0x1.9e929a7fadf83b6f9e8fb851f512b44bp-2,
    -0x1.60e254p1
  },
  { // Entry 600
    -0x1.53fe10a547a6ecce5caddc2005db822bp-2,
    0x1.691738p1
  },
  { // Entry 601
    0x1.53fe10a547a6ecce5caddc2005db822bp-2,
    -0x1.691738p1
  },
  { // Entry 602
    -0x1.0c8683b1bc682759e28441ef97c8854bp-2,
    0x1.714c1cp1
  },
  { // Entry 603
    0x1.0c8683b1bc682759e28441ef97c8854bp-2,
    -0x1.714c1cp1
  },
  { // Entry 604
    -0x1.8ed99c8546008be46614ea66c7ddd7e6p-3,
    0x1.7981p1
  },
  { // Entry 605
    0x1.8ed99c8546008be46614ea66c7ddd7e6p-3,
    -0x1.7981p1
  },
  { // Entry 606
    -0x1.080ffef4eda0271d81658d58ae280792p-3,
    0x1.81b5e4p1
  },
  { // Entry 607
    0x1.080ffef4eda0271d81658d58ae280792p-3,
    -0x1.81b5e4p1
  },
  { // Entry 608
    -0x1.06f9ee83686aa6194c03de71a6b52f75p-4,
    0x1.89eac8p1
  },
  { // Entry 609
    0x1.06f9ee83686aa6194c03de71a6b52f75p-4,
    -0x1.89eac8p1
  },
  { // Entry 610
    0x1.0c8627ec3bc2e8f0e6df44f809f370fdp-2,
    -0x1.81b5eep2
  },
  { // Entry 611
    -0x1.0c8627ec3bc2e8f0e6df44f809f370fdp-2,
    0x1.81b5eep2
  },
  { // Entry 612
    0x1.205a49753bb89e8c971c6cd2842edaf0p-1,
    -0x1.714c26p2
  },
  { // Entry 613
    -0x1.205a49753bb89e8c971c6cd2842edaf0p-1,
    0x1.714c26p2
  },
  { // Entry 614
    0x1.efd7fb1d28b8a0602b25fadfe9e0277ap-1,
    -0x1.60e25ep2
  },
  { // Entry 615
    -0x1.efd7fb1d28b8a0602b25fadfe9e0277ap-1,
    0x1.60e25ep2
  },
  { // Entry 616
    0x1.a64c47bcfb5f9cbdb49360a65548fd6dp0,
    -0x1.507896p2
  },
  { // Entry 617
    -0x1.a64c47bcfb5f9cbdb49360a65548fd6dp0,
    0x1.507896p2
  },
  { // Entry 618
    0x1.af45dabd34b75597ff70079b3de986fdp1,
    -0x1.400ecep2
  },
  { // Entry 619
    -0x1.af45dabd34b75597ff70079b3de986fdp1,
    0x1.400ecep2
  },
  { // Entry 620
    0x1.f2eba583fff9f8df3693ffd969395de7p4,
    -0x1.2fa506p2
  },
  { // Entry 621
    -0x1.f2eba583fff9f8df3693ffd969395de7p4,
    0x1.2fa506p2
  },
  { // Entry 622
    -0x1.186770f5cef152a4ec75fe9a7031a56ap2,
    -0x1.1f3b3ep2
  },
  { // Entry 623
    0x1.186770f5cef152a4ec75fe9a7031a56ap2,
    0x1.1f3b3ep2
  },
  { // Entry 624
    -0x1.eab4b52e6cce160a5b9a23a4b929d01dp0,
    -0x1.0ed176p2
  },
  { // Entry 625
    0x1.eab4b52e6cce160a5b9a23a4b929d01dp0,
    0x1.0ed176p2
  },
  { // Entry 626
    -0x1.19e2a124bc3deef648338274627cc371p0,
    -0x1.fccf5ap1
  },
  { // Entry 627
    0x1.19e2a124bc3deef648338274627cc371p0,
    0x1.fccf5ap1
  },
  { // Entry 628
    -0x1.4d46aca48de47f5fd90c9000c15425d8p-1,
    -0x1.dbfbc8p1
  },
  { // Entry 629
    0x1.4d46aca48de47f5fd90c9000c15425d8p-1,
    0x1.dbfbc8p1
  },
  { // Entry 630
    -0x1.53fe2f6fc9d023774a2105c8213e4d5ep-2,
    -0x1.bb2836p1
  },
  { // Entry 631
    0x1.53fe2f6fc9d023774a2105c8213e4d5ep-2,
    0x1.bb2836p1
  },
  { // Entry 632
    -0x1.06fa1da43b26cd580ce5a5b89cf2eff3p-4,
    -0x1.9a54a4p1
  },
  { // Entry 633
    0x1.06fa1da43b26cd580ce5a5b89cf2eff3p-4,
    0x1.9a54a4p1
  },
  { // Entry 634
    0x1.8ed87198f413d3a122658287aa7fc33ep-3,
    -0x1.798112p1
  },
  { // Entry 635
    -0x1.8ed87198f413d3a122658287aa7fc33ep-3,
    0x1.798112p1
  },
  { // Entry 636
    0x1.ed218aee2df4e80e39340b0c4ec3b1d5p-2,
    -0x1.58ad80p1
  },
  { // Entry 637
    -0x1.ed218aee2df4e80e39340b0c4ec3b1d5p-2,
    0x1.58ad80p1
  },
  { // Entry 638
    0x1.b3defd0991e6315369dbd5e2de2d14fep-1,
    -0x1.37d9eep1
  },
  { // Entry 639
    -0x1.b3defd0991e6315369dbd5e2de2d14fep-1,
    0x1.37d9eep1
  },
  { // Entry 640
    0x1.6efe97c23f206826b4f0019f275d3a44p0,
    -0x1.17065cp1
  },
  { // Entry 641
    -0x1.6efe97c23f206826b4f0019f275d3a44p0,
    0x1.17065cp1
  },
  { // Entry 642
    0x1.5bd0ff925c94f7d608b88484f9081f2cp1,
    -0x1.ec6594p0
  },
  { // Entry 643
    -0x1.5bd0ff925c94f7d608b88484f9081f2cp1,
    0x1.ec6594p0
  },
  { // Entry 644
    0x1.4bb5ece657bee292a82a3fda6b812aadp3,
    -0x1.aabe70p0
  },
  { // Entry 645
    -0x1.4bb5ece657bee292a82a3fda6b812aadp3,
    0x1.aabe70p0
  },
  { // Entry 646
    -0x1.8bdd4feef18bfa8a6c23de6a721f2436p2,
    -0x1.69174cp0
  },
  { // Entry 647
    0x1.8bdd4feef18bfa8a6c23de6a721f2436p2,
    0x1.69174cp0
  },
  { // Entry 648
    -0x1.21279e1e8bf4bd3983a3677267e55809p1,
    -0x1.277028p0
  },
  { // Entry 649
    0x1.21279e1e8bf4bd3983a3677267e55809p1,
    0x1.277028p0
  },
  { // Entry 650
    -0x1.4103a8147ca836136cc98db9bc6ddf30p0,
    -0x1.cb920ap-1
  },
  { // Entry 651
    0x1.4103a8147ca836136cc98db9bc6ddf30p0,
    0x1.cb920ap-1
  },
  { // Entry 652
    -0x1.7e1db58a55d6a12a6457e3c5929ac2c7p-1,
    -0x1.4843c4p-1
  },
  { // Entry 653
    0x1.7e1db58a55d6a12a6457e3c5929ac2c7p-1,
    0x1.4843c4p-1
  },
  { // Entry 654
    -0x1.9e928a0c8e79023200164ed240caad05p-2,
    -0x1.89eafcp-2
  },
  { // Entry 655
    0x1.9e928a0c8e79023200164ed240caad05p-2,
    0x1.89eafcp-2
  },
  { // Entry 656
    -0x1.080fc9d24fbe9876b31b0aa29dd238eap-3,
    -0x1.069ce0p-3
  },
  { // Entry 657
    0x1.080fc9d24fbe9876b31b0aa29dd238eap-3,
    0x1.069ce0p-3
  },
  { // Entry 658
    0x1.080f1f07540fd03b82d4b370d237fa3dp-3,
    0x1.069c38p-3
  },
  { // Entry 659
    -0x1.080f1f07540fd03b82d4b370d237fa3dp-3,
    -0x1.069c38p-3
  },
  { // Entry 660
    0x1.9e922847e2b1b6a72d486700e18c05f2p-2,
    0x1.89eaa8p-2
  },
  { // Entry 661
    -0x1.9e922847e2b1b6a72d486700e18c05f2p-2,
    -0x1.89eaa8p-2
  },
  { // Entry 662
    0x1.7e1d74258cbc964b561d99c9a66f8c7ep-1,
    0x1.48439ap-1
  },
  { // Entry 663
    -0x1.7e1d74258cbc964b561d99c9a66f8c7ep-1,
    -0x1.48439ap-1
  },
  { // Entry 664
    0x1.4103720f2ca3e0580fba15849398a4e9p0,
    0x1.cb91e0p-1
  },
  { // Entry 665
    -0x1.4103720f2ca3e0580fba15849398a4e9p0,
    -0x1.cb91e0p-1
  },
  { // Entry 666
    0x1.2127611673ccc7531f5af5aeda3412c5p1,
    0x1.277014p0
  },
  { // Entry 667
    -0x1.2127611673ccc7531f5af5aeda3412c5p1,
    -0x1.277014p0
  },
  { // Entry 668
    0x1.8bdc8ba3d8277213c5b74ef806ef466bp2,
    0x1.691738p0
  },
  { // Entry 669
    -0x1.8bdc8ba3d8277213c5b74ef806ef466bp2,
    -0x1.691738p0
  },
  { // Entry 670
    -0x1.4bb6fc092bc16530216209a912aada37p3,
    0x1.aabe5cp0
  },
  { // Entry 671
    0x1.4bb6fc092bc16530216209a912aada37p3,
    -0x1.aabe5cp0
  },
  { // Entry 672
    -0x1.5bd15368f84be0bda8f135a5f79aeacbp1,
    0x1.ec6580p0
  },
  { // Entry 673
    0x1.5bd15368f84be0bda8f135a5f79aeacbp1,
    -0x1.ec6580p0
  },
  { // Entry 674
    -0x1.6efed4dc8946e1c3620d79bb0d654338p0,
    0x1.170652p1
  },
  { // Entry 675
    0x1.6efed4dc8946e1c3620d79bb0d654338p0,
    -0x1.170652p1
  },
  { // Entry 676
    -0x1.b3df4206d232794d5761992d88c5a394p-1,
    0x1.37d9e4p1
  },
  { // Entry 677
    0x1.b3df4206d232794d5761992d88c5a394p-1,
    -0x1.37d9e4p1
  },
  { // Entry 678
    -0x1.ed21ed7bc4b5968bdb0cd6da269cd55fp-2,
    0x1.58ad76p1
  },
  { // Entry 679
    0x1.ed21ed7bc4b5968bdb0cd6da269cd55fp-2,
    -0x1.58ad76p1
  },
  { // Entry 680
    -0x1.8ed917aa74e733b9194d537c8df33c64p-3,
    0x1.798108p1
  },
  { // Entry 681
    0x1.8ed917aa74e733b9194d537c8df33c64p-3,
    -0x1.798108p1
  },
  { // Entry 682
    0x1.06f8dc528ea01882064ee242f58a2b88p-4,
    0x1.9a549ap1
  },
  { // Entry 683
    -0x1.06f8dc528ea01882064ee242f58a2b88p-4,
    -0x1.9a549ap1
  },
  { // Entry 684
    0x1.53fdd69e1437db957c62e8cc55742beep-2,
    0x1.bb282cp1
  },
  { // Entry 685
    -0x1.53fdd69e1437db957c62e8cc55742beep-2,
    -0x1.bb282cp1
  },
  { // Entry 686
    0x1.4d4673b1c7635cc893e1c8d2ca57b3e9p-1,
    0x1.dbfbbep1
  },
  { // Entry 687
    -0x1.4d4673b1c7635cc893e1c8d2ca57b3e9p-1,
    -0x1.dbfbbep1
  },
  { // Entry 688
    0x1.19e274e4fdec9e78ef6872081b5572cfp0,
    0x1.fccf50p1
  },
  { // Entry 689
    -0x1.19e274e4fdec9e78ef6872081b5572cfp0,
    -0x1.fccf50p1
  },
  { // Entry 690
    0x1.eab445003a7b542a2d4d87a88793bb67p0,
    0x1.0ed170p2
  },
  { // Entry 691
    -0x1.eab445003a7b542a2d4d87a88793bb67p0,
    -0x1.0ed170p2
  },
  { // Entry 692
    0x1.1866f7c91660d9c9f4b2d14e91375732p2,
    0x1.1f3b38p2
  },
  { // Entry 693
    -0x1.1866f7c91660d9c9f4b2d14e91375732p2,
    -0x1.1f3b38p2
  },
  { // Entry 694
    -0x1.f2f1599b29a7de952b8ba1877d9f5e61p4,
    0x1.2fa5p2
  },
  { // Entry 695
    0x1.f2f1599b29a7de952b8ba1877d9f5e61p4,
    -0x1.2fa5p2
  },
  { // Entry 696
    -0x1.af466ef7b15645455e15fbbae6bb4bc6p1,
    0x1.400ec8p2
  },
  { // Entry 697
    0x1.af466ef7b15645455e15fbbae6bb4bc6p1,
    -0x1.400ec8p2
  },
  { // Entry 698
    -0x1.a64ca10bfefd2b04bb6a1bb708c28967p0,
    0x1.507890p2
  },
  { // Entry 699
    0x1.a64ca10bfefd2b04bb6a1bb708c28967p0,
    -0x1.507890p2
  },
  { // Entry 700
    -0x1.efd85821ec927f2a89ec41acee587230p-1,
    0x1.60e258p2
  },
  { // Entry 701
    0x1.efd85821ec927f2a89ec41acee587230p-1,
    -0x1.60e258p2
  },
  { // Entry 702
    -0x1.205a88aec64cad35d7752c73620c2139p-1,
    0x1.714c20p2
  },
  { // Entry 703
    0x1.205a88aec64cad35d7752c73620c2139p-1,
    -0x1.714c20p2
  },
  { // Entry 704
    -0x1.0c868e863543fd989476c8cdeffa93eap-2,
    0x1.81b5e8p2
  },
  { // Entry 705
    0x1.0c868e863543fd989476c8cdeffa93eap-2,
    -0x1.81b5e8p2
  },
  { // Entry 706
    0x1.f09b61a8a04f0898851f1d7604fa13c8p-5,
    0x1.effffep-5
  },
  { // Entry 707
    -0x1.f09b61a8a04f0898851f1d7604fa13c8p-5,
    -0x1.effffep-5
  },
  { // Entry 708
    0x1.f09b63aa81fc46e95e06405b41e8b4ccp-5,
    0x1.f0p-5
  },
  { // Entry 709
    -0x1.f09b63aa81fc46e95e06405b41e8b4ccp-5,
    -0x1.f0p-5
  },
  { // Entry 710
    0x1.f09b65ac63a9891f1418c4338c1e419ep-5,
    0x1.f00002p-5
  },
  { // Entry 711
    -0x1.f09b65ac63a9891f1418c4338c1e419ep-5,
    -0x1.f00002p-5
  },
  { // Entry 712
    0x1.fa8f1fc0ce86c214bf765fd59e8798a5p-4,
    0x1.f7fffep-4
  },
  { // Entry 713
    -0x1.fa8f1fc0ce86c214bf765fd59e8798a5p-4,
    -0x1.f7fffep-4
  },
  { // Entry 714
    0x1.fa8f21c8a33afd3355198e8d7716a811p-4,
    0x1.f8p-4
  },
  { // Entry 715
    -0x1.fa8f21c8a33afd3355198e8d7716a811p-4,
    -0x1.f8p-4
  },
  { // Entry 716
    0x1.fa8f23d077ef48645eff9a519628b3a9p-4,
    0x1.f80002p-4
  },
  { // Entry 717
    -0x1.fa8f23d077ef48645eff9a519628b3a9p-4,
    -0x1.f80002p-4
  },
  { // Entry 718
    0x1.4ef06aa73ee6a439c0c9f45046b25978p-3,
    0x1.4bfffep-3
  },
  { // Entry 719
    -0x1.4ef06aa73ee6a439c0c9f45046b25978p-3,
    -0x1.4bfffep-3
  },
  { // Entry 720
    0x1.4ef06cb4f0a87a5c8eeeebceb12a22b4p-3,
    0x1.4cp-3
  },
  { // Entry 721
    -0x1.4ef06cb4f0a87a5c8eeeebceb12a22b4p-3,
    -0x1.4cp-3
  },
  { // Entry 722
    0x1.4ef06ec2a26a7b7c1721ffafb93c0281p-3,
    0x1.4c0002p-3
  },
  { // Entry 723
    -0x1.4ef06ec2a26a7b7c1721ffafb93c0281p-3,
    -0x1.4c0002p-3
  },
  { // Entry 724
    0x1.3cc2a2fd911e1557d57b44abf28c4ccap-2,
    0x1.333332p-2
  },
  { // Entry 725
    -0x1.3cc2a2fd911e1557d57b44abf28c4ccap-2,
    -0x1.333332p-2
  },
  { // Entry 726
    0x1.3cc2a52e8f4137ca27d1dc0567195443p-2,
    0x1.333334p-2
  },
  { // Entry 727
    -0x1.3cc2a52e8f4137ca27d1dc0567195443p-2,
    -0x1.333334p-2
  },
  { // Entry 728
    0x1.3cc2a75f8d6507c589bf08e0371394bcp-2,
    0x1.333336p-2
  },
  { // Entry 729
    -0x1.3cc2a75f8d6507c589bf08e0371394bcp-2,
    -0x1.333336p-2
  },
  { // Entry 730
    0x1.99436e5f07b73dda1ef61a800aadfdd3p-1,
    0x1.594316p-1
  },
  { // Entry 731
    -0x1.99436e5f07b73dda1ef61a800aadfdd3p-1,
    -0x1.594316p-1
  },
  { // Entry 732
    0x1.994371a62bfe13eb1c755cb5be46f853p-1,
    0x1.594318p-1
  },
  { // Entry 733
    -0x1.994371a62bfe13eb1c755cb5be46f853p-1,
    -0x1.594318p-1
  },
  { // Entry 734
    0x1.994374ed504a278226573562b60eca9ap-1,
    0x1.59431ap-1
  },
  { // Entry 735
    -0x1.994374ed504a278226573562b60eca9ap-1,
    -0x1.59431ap-1
  },
  { // Entry 736
    0x1.fbc50de7c605a4d1d0f1119b1294b6f0p-1,
    0x1.8ffffep-1
  },
  { // Entry 737
    -0x1.fbc50de7c605a4d1d0f1119b1294b6f0p-1,
    -0x1.8ffffep-1
  },
  { // Entry 738
    0x1.fbc511df5917f539bbcf778bc1a22249p-1,
    0x1.90p-1
  },
  { // Entry 739
    -0x1.fbc511df5917f539bbcf778bc1a22249p-1,
    -0x1.90p-1
  },
  { // Entry 740
    0x1.fbc515d6ec3223ffbed4bb75154fda0fp-1,
    0x1.900002p-1
  },
  { // Entry 741
    -0x1.fbc515d6ec3223ffbed4bb75154fda0fp-1,
    -0x1.900002p-1
  },
  { // Entry 742
    -0x1.p-149,
    -0x1.p-149
  },
  { // Entry 743
    0x1.p-149,
    0x1.p-149
  },
  { // Entry 744
    0.0,
    0.0
  },
  { // Entry 745
    0x1.p-149,
    0x1.p-149
  },
  { // Entry 746
    -0x1.p-149,
    -0x1.p-149
  },
  { // Entry 747
    0x1.9272775ea5ecff4e43ecdef3d85ec226p-5,
    0x1.921fb4p-5
  },
  { // Entry 748
    -0x1.9272775ea5ecff4e43ecdef3d85ec226p-5,
    -0x1.921fb4p-5
  },
  { // Entry 749
    0x1.9272795fe242d9eb9393a7446620c394p-5,
    0x1.921fb6p-5
  },
  { // Entry 750
    -0x1.9272795fe242d9eb9393a7446620c394p-5,
    -0x1.921fb6p-5
  },
  { // Entry 751
    0x1.92727b611e98b7afb97977551d1c5f38p-5,
    0x1.921fb8p-5
  },
  { // Entry 752
    -0x1.92727b611e98b7afb97977551d1c5f38p-5,
    -0x1.921fb8p-5
  },
  { // Entry 753
    0x1.936bb77e4ac859bc69bc4abc9e91f025p-4,
    0x1.921fb4p-4
  },
  { // Entry 754
    -0x1.936bb77e4ac859bc69bc4abc9e91f025p-4,
    -0x1.921fb4p-4
  },
  { // Entry 755
    0x1.936bb9834241022ecd070b9064632721p-4,
    0x1.921fb6p-4
  },
  { // Entry 756
    -0x1.936bb9834241022ecd070b9064632721p-4,
    -0x1.921fb6p-4
  },
  { // Entry 757
    0x1.936bbb8839b9b75bdcc5f6870267a609p-4,
    0x1.921fb8p-4
  },
  { // Entry 758
    -0x1.936bbb8839b9b75bdcc5f6870267a609p-4,
    -0x1.921fb8p-4
  },
  { // Entry 759
    0x1.975f5cb43bd951aa2e89a05cbf5e70ffp-3,
    0x1.921fb4p-3
  },
  { // Entry 760
    -0x1.975f5cb43bd951aa2e89a05cbf5e70ffp-3,
    -0x1.921fb4p-3
  },
  { // Entry 761
    0x1.975f5ec87ddc4e7a357059f71a9f05b2p-3,
    0x1.921fb6p-3
  },
  { // Entry 762
    -0x1.975f5ec87ddc4e7a357059f71a9f05b2p-3,
    -0x1.921fb6p-3
  },
  { // Entry 763
    0x1.975f60dcbfdf8039f01eb7864bc09e13p-3,
    0x1.921fb8p-3
  },
  { // Entry 764
    -0x1.975f60dcbfdf8039f01eb7864bc09e13p-3,
    -0x1.921fb8p-3
  },
  { // Entry 765
    0x1.a8279823e9ba30ee623a5402a48590fcp-2,
    0x1.921fb4p-2
  },
  { // Entry 766
    -0x1.a8279823e9ba30ee623a5402a48590fcp-2,
    -0x1.921fb4p-2
  },
  { // Entry 767
    0x1.a8279a7bc2206fff3afa52f168c5f8f2p-2,
    0x1.921fb6p-2
  },
  { // Entry 768
    -0x1.a8279a7bc2206fff3afa52f168c5f8f2p-2,
    -0x1.921fb6p-2
  },
  { // Entry 769
    0x1.a8279cd39a87a786e140537db72ff334p-2,
    0x1.921fb8p-2
  },
  { // Entry 770
    -0x1.a8279cd39a87a786e140537db72ff334p-2,
    -0x1.921fb8p-2
  },
  { // Entry 771
    0x1.fffffd777a5e91e61f5380fb808d3272p-1,
    0x1.921fb4p-1
  },
  { // Entry 772
    -0x1.fffffd777a5e91e61f5380fb808d3272p-1,
    -0x1.921fb4p-1
  },
  { // Entry 773
    0x1.000000bbbd2ec06d6d6fff3655a346acp0,
    0x1.921fb6p-1
  },
  { // Entry 774
    -0x1.000000bbbd2ec06d6d6fff3655a346acp0,
    -0x1.921fb6p-1
  },
  { // Entry 775
    0x1.000002bbbd3237e7d114276ed329af5bp0,
    0x1.921fb8p-1
  },
  { // Entry 776
    -0x1.000002bbbd3237e7d114276ed329af5bp0,
    -0x1.921fb8p-1
  },
  { // Entry 777
    0x1.9437b336b6b0c479b2280999b19575c7p23,
    0x1.921fb4p0
  },
  { // Entry 778
    -0x1.9437b336b6b0c479b2280999b19575c7p23,
    -0x1.921fb4p0
  },
  { // Entry 779
    -0x1.5d14946dc98975d6421a55284fe020a1p24,
    0x1.921fb6p0
  },
  { // Entry 780
    0x1.5d14946dc98975d6421a55284fe020a1p24,
    -0x1.921fb6p0
  },
  { // Entry 781
    -0x1.76a190eb2b0718d8db55f7d2abeb07d2p22,
    0x1.921fb8p0
  },
  { // Entry 782
    0x1.76a190eb2b0718d8db55f7d2abeb07d2p22,
    -0x1.921fb8p0
  },
  { // Entry 783
    -0x1.4442d184698c426c8e3efd356cbebe0ap-23,
    0x1.921fb4p1
  },
  { // Entry 784
    0x1.4442d184698c426c8e3efd356cbebe0ap-23,
    -0x1.921fb4p1
  },
  { // Entry 785
    0x1.777a5cf72cedf3b544c81808b515f1f9p-24,
    0x1.921fb6p1
  },
  { // Entry 786
    -0x1.777a5cf72cedf3b544c81808b515f1f9p-24,
    -0x1.921fb6p1
  },
  { // Entry 787
    0x1.5dde973dcb48d6e3d13cf2a51550e911p-22,
    0x1.921fb8p1
  },
  { // Entry 788
    -0x1.5dde973dcb48d6e3d13cf2a51550e911p-22,
    -0x1.921fb8p1
  },
  { // Entry 789
    -0x1.4442d18469946362f3f6cc7c43857661p-22,
    0x1.921fb4p2
  },
  { // Entry 790
    0x1.4442d18469946362f3f6cc7c43857661p-22,
    -0x1.921fb4p2
  },
  { // Entry 791
    0x1.777a5cf72cf11b739d2ab1877e81a9c7p-23,
    0x1.921fb6p2
  },
  { // Entry 792
    -0x1.777a5cf72cf11b739d2ab1877e81a9c7p-23,
    -0x1.921fb6p2
  },
  { // Entry 793
    0x1.5dde973dcb71aeb6e776668bbb3de253p-21,
    0x1.921fb8p2
  },
  { // Entry 794
    -0x1.5dde973dcb71aeb6e776668bbb3de253p-21,
    -0x1.921fb8p2
  },
  { // Entry 795
    -0x1.4442d18469b4e73c8ad60e7b9f288c5cp-21,
    0x1.921fb4p3
  },
  { // Entry 796
    0x1.4442d18469b4e73c8ad60e7b9f288c5cp-21,
    -0x1.921fb4p3
  },
  { // Entry 797
    0x1.777a5cf72cfdba6cfeb518258bcf263cp-22,
    0x1.921fb6p3
  },
  { // Entry 798
    -0x1.777a5cf72cfdba6cfeb518258bcf263cp-22,
    -0x1.921fb6p3
  },
  { // Entry 799
    0x1.5dde973dcc150e03405ca894886602c2p-20,
    0x1.921fb8p3
  },
  { // Entry 800
    -0x1.5dde973dcc150e03405ca894886602c2p-20,
    -0x1.921fb8p3
  },
  { // Entry 801
    -0x1.4442d1846a36f6a2e65364b916382e9bp-20,
    0x1.921fb4p4
  },
  { // Entry 802
    0x1.4442d1846a36f6a2e65364b916382e9bp-20,
    -0x1.921fb4p4
  },
  { // Entry 803
    0x1.777a5cf72d30365284debccc3aeeec17p-21,
    0x1.921fb6p4
  },
  { // Entry 804
    -0x1.777a5cf72d30365284debccc3aeeec17p-21,
    -0x1.921fb6p4
  },
  { // Entry 805
    0x1.5dde973dcea28b34a3fcd79b144a5050p-19,
    0x1.921fb8p4
  },
  { // Entry 806
    -0x1.5dde973dcea28b34a3fcd79b144a5050p-19,
    -0x1.921fb8p4
  },
  { // Entry 807
    -0x1.4442d1846c3f343c544da1af7aab690cp-19,
    0x1.921fb4p5
  },
  { // Entry 808
    0x1.4442d1846c3f343c544da1af7aab690cp-19,
    -0x1.921fb4p5
  },
  { // Entry 809
    0x1.777a5cf72dfa25e89d85f24e960b4455p-20,
    0x1.921fb6p5
  },
  { // Entry 810
    -0x1.777a5cf72dfa25e89d85f24e960b4455p-20,
    -0x1.921fb6p5
  },
  { // Entry 811
    0x1.5dde973dd8d87ffa32f001eab81d960cp-18,
    0x1.921fb8p5
  },
  { // Entry 812
    -0x1.5dde973dd8d87ffa32f001eab81d960cp-18,
    -0x1.921fb8p5
  },
  { // Entry 813
    -0x1.4442d18474602aa20c84d5918fc68a8ep-18,
    0x1.921fb4p6
  },
  { // Entry 814
    0x1.4442d18474602aa20c84d5918fc68a8ep-18,
    -0x1.921fb4p6
  },
  { // Entry 815
    0x1.777a5cf73121e441002cf6d1ec50d56dp-19,
    0x1.921fb6p6
  },
  { // Entry 816
    -0x1.777a5cf73121e441002cf6d1ec50d56dp-19,
    -0x1.921fb6p6
  },
  { // Entry 817
    0x1.5dde973e01b0531075e38e808ce048f2p-17,
    0x1.921fb8p6
  },
  { // Entry 818
    -0x1.5dde973e01b0531075e38e808ce048f2p-17,
    -0x1.921fb8p6
  },
  { // Entry 819
    -0x1.4442d18494e40438f245a5a219dea235p-17,
    0x1.921fb4p7
  },
  { // Entry 820
    0x1.4442d18494e40438f245a5a219dea235p-17,
    -0x1.921fb4p7
  },
  { // Entry 821
    0x1.777a5cf73dc0dda28b6bf07de2b2d5e6p-18,
    0x1.921fb6p7
  },
  { // Entry 822
    -0x1.777a5cf73dc0dda28b6bf07de2b2d5e6p-18,
    -0x1.921fb6p7
  },
  { // Entry 823
    0x1.5dde973ea50f9f69f41ff64c8c6db761p-16,
    0x1.921fb8p7
  },
  { // Entry 824
    -0x1.5dde973ea50f9f69f41ff64c8c6db761p-16,
    -0x1.921fb8p7
  },
  { // Entry 825
    -0x1.00000fccc8f15ee89f09d222e14c7292p0,
    0x1.2d97c4p1
  },
  { // Entry 826
    0x1.00000fccc8f15ee89f09d222e14c7292p0,
    -0x1.2d97c4p1
  },
  { // Entry 827
    -0x1.000007ccc892f8a0760cc20827ace476p0,
    0x1.2d97c6p1
  },
  { // Entry 828
    0x1.000007ccc892f8a0760cc20827ace476p0,
    -0x1.2d97c6p1
  },
  { // Entry 829
    -0x1.ffffff9990e924b866e831c9e9e639c7p-1,
    0x1.2d97c8p1
  },
  { // Entry 830
    0x1.ffffff9990e924b866e831c9e9e639c7p-1,
    -0x1.2d97c8p1
  },
  { // Entry 831
    0x1.ffffeb55643b9a648c2720bde1d22764p-1,
    0x1.f6a7a0p1
  },
  { // Entry 832
    -0x1.ffffeb55643b9a648c2720bde1d22764p-1,
    -0x1.f6a7a0p1
  },
  { // Entry 833
    0x1.fffffb5563d64585e9dcc97d74321461p-1,
    0x1.f6a7a2p1
  },
  { // Entry 834
    -0x1.fffffb5563d64585e9dcc97d74321461p-1,
    -0x1.f6a7a2p1
  },
  { // Entry 835
    0x1.000005aab1f87852792237652d34b1cep0,
    0x1.f6a7a4p1
  },
  { // Entry 836
    -0x1.000005aab1f87852792237652d34b1cep0,
    -0x1.f6a7a4p1
  },
  { // Entry 837
    0x1.033dd91c1035861ae455e0f8dc274b0dp20,
    0x1.2d97c4p2
  },
  { // Entry 838
    -0x1.033dd91c1035861ae455e0f8dc274b0dp20,
    -0x1.2d97c4p2
  },
  { // Entry 839
    0x1.0690fb4774ab80ccddc9ef5ad0fcc237p21,
    0x1.2d97c6p2
  },
  { // Entry 840
    -0x1.0690fb4774ab80ccddc9ef5ad0fcc237p21,
    -0x1.2d97c6p2
  },
  { // Entry 841
    -0x1.3fe4dac06d830837f6c584af6f8d9399p26,
    0x1.2d97c8p2
  },
  { // Entry 842
    0x1.3fe4dac06d830837f6c584af6f8d9399p26,
    -0x1.2d97c8p2
  },
  { // Entry 843
    -0x1.000014ddd4945394cb6ec7f87debc7a5p0,
    0x1.5fdbbcp2
  },
  { // Entry 844
    0x1.000014ddd4945394cb6ec7f87debc7a5p0,
    -0x1.5fdbbcp2
  },
  { // Entry 845
    -0x1.000004ddd3c6764d7369a0be61a630e7p0,
    0x1.5fdbbep2
  },
  { // Entry 846
    0x1.000004ddd3c6764d7369a0be61a630e7p0,
    -0x1.5fdbbep2
  },
  { // Entry 847
    -0x1.ffffe9bba7f1321fae192943a3e848c0p-1,
    0x1.5fdbc0p2
  },
  { // Entry 848
    0x1.ffffe9bba7f1321fae192943a3e848c0p-1,
    -0x1.5fdbc0p2
  },
  { // Entry 849
    0x1.ffffc133511ea2d3b988bf85316d4e05p-1,
    0x1.c463a8p2
  },
  { // Entry 850
    -0x1.ffffc133511ea2d3b988bf85316d4e05p-1,
    -0x1.c463a8p2
  },
  { // Entry 851
    0x1.ffffe1334e31d7ef20d6220c65dd2f9bp-1,
    0x1.c463aap2
  },
  { // Entry 852
    -0x1.ffffe1334e31d7ef20d6220c65dd2f9bp-1,
    -0x1.c463aap2
  },
  { // Entry 853
    0x1.00000099a6a286667761c2874c5890aep0,
    0x1.c463acp2
  },
  { // Entry 854
    -0x1.00000099a6a286667761c2874c5890aep0,
    -0x1.c463acp2
  },
  { // Entry 855
    0x1.8c642e8cc56a9b233450d6b635a6266dp20,
    0x1.f6a7a0p2
  },
  { // Entry 856
    -0x1.8c642e8cc56a9b233450d6b635a6266dp20,
    -0x1.f6a7a0p2
  },
  { // Entry 857
    0x1.b6e0bfb728e42363cd5fb26b31c366c2p22,
    0x1.f6a7a2p2
  },
  { // Entry 858
    -0x1.b6e0bfb728e42363cd5fb26b31c366c2p22,
    -0x1.f6a7a2p2
  },
  { // Entry 859
    -0x1.69679b966acc43dfdb28383aa976f5c1p21,
    0x1.f6a7a4p2
  },
  { // Entry 860
    0x1.69679b966acc43dfdb28383aa976f5c1p21,
    -0x1.f6a7a4p2
  },
  { // Entry 861
    -0x1.000029eee26fe211bb4a2f8e23a0a9e9p0,
    0x1.1475cap3
  },
  { // Entry 862
    0x1.000029eee26fe211bb4a2f8e23a0a9e9p0,
    -0x1.1475cap3
  },
  { // Entry 863
    -0x1.000009eedf3205d2e9b66a3783e02f05p0,
    0x1.1475ccp3
  },
  { // Entry 864
    0x1.000009eedf3205d2e9b66a3783e02f05p0,
    -0x1.1475ccp3
  },
  { // Entry 865
    -0x1.ffffd3ddbfe853c71e4a5f7502b09c4ep-1,
    0x1.1475cep3
  },
  { // Entry 866
    0x1.ffffd3ddbfe853c71e4a5f7502b09c4ep-1,
    -0x1.1475cep3
  },
  { // Entry 867
    -0x1.f9990e91aa24f550cef57fa4106c56ebp-20,
    0x1.2d97c4p3
  },
  { // Entry 868
    0x1.f9990e91aa24f550cef57fa4106c56ebp-20,
    -0x1.2d97c4p3
  },
  { // Entry 869
    -0x1.f3321d234fc557a61c638ef7752de43fp-21,
    0x1.2d97c6p3
  },
  { // Entry 870
    0x1.f3321d234fc557a61c638ef7752de43fp-21,
    -0x1.2d97c6p3
  },
  { // Entry 871
    0x1.99bc5b961b1ae363cfc0ffaab4f0e505p-26,
    0x1.2d97c8p3
  },
  { // Entry 872
    -0x1.99bc5b961b1ae363cfc0ffaab4f0e505p-26,
    -0x1.2d97c8p3
  },
  { // Entry 873
    0x1.ffff971141794461276f342bd29c5a1fp-1,
    0x1.46b9c0p3
  },
  { // Entry 874
    -0x1.ffff971141794461276f342bd29c5a1fp-1,
    -0x1.46b9c0p3
  },
  { // Entry 875
    0x1.ffffd711385b6c9a013dabe9b7254665p-1,
    0x1.46b9c2p3
  },
  { // Entry 876
    -0x1.ffffd711385b6c9a013dabe9b7254665p-1,
    -0x1.46b9c2p3
  },
  { // Entry 877
    0x1.00000b889b9ec9c5b277fb6a91cf5f49p0,
    0x1.46b9c4p3
  },
  { // Entry 878
    -0x1.00000b889b9ec9c5b277fb6a91cf5f49p0,
    -0x1.46b9c4p3
  },
  { // Entry 879
    0x1.88973cb02a0eea2cfe1a281ca7f04663p19,
    0x1.5fdbbcp3
  },
  { // Entry 880
    -0x1.88973cb02a0eea2cfe1a281ca7f04663p19,
    -0x1.5fdbbcp3
  },
  { // Entry 881
    0x1.a4d5d5d753841c89cfe71c25abc8d645p21,
    0x1.5fdbbep3
  },
  { // Entry 882
    -0x1.a4d5d5d753841c89cfe71c25abc8d645p21,
    -0x1.5fdbbep3
  },
  { // Entry 883
    -0x1.6fe62a1a9a12b70b1fbb952801f99801p20,
    0x1.5fdbc0p3
  },
  { // Entry 884
    0x1.6fe62a1a9a12b70b1fbb952801f99801p20,
    -0x1.5fdbc0p3
  },
  { // Entry 885
    -0x1.00003efff2073e1c0dd65d3b83e5e589p0,
    0x1.78fdb6p3
  },
  { // Entry 886
    0x1.00003efff2073e1c0dd65d3b83e5e589p0,
    -0x1.78fdb6p3
  },
  { // Entry 887
    -0x1.00001effec273fb46bb5ecfec53c3105p0,
    0x1.78fdb8p3
  },
  { // Entry 888
    0x1.00001effec273fb46bb5ecfec53c3105p0,
    -0x1.78fdb8p3
  },
  { // Entry 889
    -0x1.fffffdffd48e84899227cea1f77a1cf7p-1,
    0x1.78fdbap3
  },
  { // Entry 890
    0x1.fffffdffd48e84899227cea1f77a1cf7p-1,
    -0x1.78fdbap3
  },
  { // Entry 891
    0x1.ffffacef26e965d1253424fbbc9ff354p-1,
    0x1.ab41aep3
  },
  { // Entry 892
    -0x1.ffffacef26e965d1253424fbbc9ff354p-1,
    -0x1.ab41aep3
  },
  { // Entry 893
    0x1.ffffecef20874a8f035ac4dc1a6029f8p-1,
    0x1.ab41b0p3
  },
  { // Entry 894
    -0x1.ffffecef20874a8f035ac4dc1a6029f8p-1,
    -0x1.ab41b0p3
  },
  { // Entry 895
    0x1.000016779112975a2d4b9b75bd90b3c1p0,
    0x1.ab41b2p3
  },
  { // Entry 896
    -0x1.000016779112975a2d4b9b75bd90b3c1p0,
    -0x1.ab41b2p3
  },
  { // Entry 897
    0x1.04e4b40acdf9439feccd49bbeb37da0fp19,
    0x1.c463a8p3
  },
  { // Entry 898
    -0x1.04e4b40acdf9439feccd49bbeb37da0fp19,
    -0x1.c463a8p3
  },
  { // Entry 899
    0x1.09fa3ae1f4913d1b3764ff9a9678ef68p20,
    0x1.c463aap3
  },
  { // Entry 900
    -0x1.09fa3ae1f4913d1b3764ff9a9678ef68p20,
    -0x1.c463aap3
  },
  { // Entry 901
    -0x1.aa8679009203dd6e942f9175275a7461p24,
    0x1.c463acp3
  },
  { // Entry 902
    0x1.aa8679009203dd6e942f9175275a7461p24,
    -0x1.c463acp3
  },
  { // Entry 903
    -0x1.00003410fad846fd67d35e0c0d983628p0,
    0x1.dd85a4p3
  },
  { // Entry 904
    0x1.00003410fad846fd67d35e0c0d983628p0,
    -0x1.dd85a4p3
  },
  { // Entry 905
    -0x1.00001410f656279e89d14cf4054f6c56p0,
    0x1.dd85a6p3
  },
  { // Entry 906
    0x1.00001410f656279e89d14cf4054f6c56p0,
    -0x1.dd85a6p3
  },
  { // Entry 907
    -0x1.ffffe821eba811c067240f666c904371p-1,
    0x1.dd85a8p3
  },
  { // Entry 908
    0x1.ffffe821eba811c067240f666c904371p-1,
    -0x1.dd85a8p3
  },
  { // Entry 909
    -0x1.4aa9c2f2c2addb9b59e39401239761e2p-20,
    0x1.f6a7a0p3
  },
  { // Entry 910
    0x1.4aa9c2f2c2addb9b59e39401239761e2p-20,
    -0x1.f6a7a0p3
  },
  { // Entry 911
    -0x1.2aa70bcb07e057b729eacbc0cf17cbbfp-22,
    0x1.f6a7a2p3
  },
  { // Entry 912
    0x1.2aa70bcb07e057b729eacbc0cf17cbbfp-22,
    -0x1.f6a7a2p3
  },
  { // Entry 913
    0x1.6aac7a1a7c50b873bed39b6859bf2934p-21,
    0x1.f6a7a4p3
  },
  { // Entry 914
    -0x1.6aac7a1a7c50b873bed39b6859bf2934p-21,
    -0x1.f6a7a4p3
  },
  { // Entry 915
    0x1.ffff42cd2c95508e700ab76956dd04cfp-1,
    0x1.07e4ccp4
  },
  { // Entry 916
    -0x1.ffff42cd2c95508e700ab76956dd04cfp-1,
    -0x1.07e4ccp4
  },
  { // Entry 917
    0x1.ffffc2cd0d489b48844179c594356e0dp-1,
    0x1.07e4cep4
  },
  { // Entry 918
    -0x1.ffffc2cd0d489b48844179c594356e0dp-1,
    -0x1.07e4cep4
  },
  { // Entry 919
    0x1.0000216686fdef2e1dd31a2eaa6a1cd4p0,
    0x1.07e4d0p4
  },
  { // Entry 920
    -0x1.0000216686fdef2e1dd31a2eaa6a1cd4p0,
    -0x1.07e4d0p4
  },
  { // Entry 921
    0x1.86b7ba4923bcf157dcc33291871e88d4p18,
    0x1.1475cap4
  },
  { // Entry 922
    -0x1.86b7ba4923bcf157dcc33291871e88d4p18,
    -0x1.1475cap4
  },
  { // Entry 923
    0x1.9c5becf2873eed369afdc3159a7f797cp20,
    0x1.1475ccp4
  },
  { // Entry 924
    -0x1.9c5becf2873eed369afdc3159a7f797cp20,
    -0x1.1475ccp4
  },
  { // Entry 925
    -0x1.733c0d84332fa606d1bd207a491e4371p19,
    0x1.1475cep4
  },
  { // Entry 926
    0x1.733c0d84332fa606d1bd207a491e4371p19,
    -0x1.1475cep4
  },
  { // Entry 927
    -0x1.000049220b451bf6e8e605550c88602fp0,
    0x1.2106c8p4
  },
  { // Entry 928
    0x1.000049220b451bf6e8e605550c88602fp0,
    -0x1.2106c8p4
  },
  { // Entry 929
    -0x1.0000092200fc99c5dfa4fe18085cf7cdp0,
    0x1.2106cap4
  },
  { // Entry 930
    0x1.0000092200fc99c5dfa4fe18085cf7cdp0,
    -0x1.2106cap4
  },
  { // Entry 931
    -0x1.ffff92440d6831722dec0d31810d8fc7p-1,
    0x1.2106ccp4
  },
  { // Entry 932
    0x1.ffff92440d6831722dec0d31810d8fc7p-1,
    -0x1.2106ccp4
  },
  { // Entry 933
    -0x1.f9990e91b1d916e582242347112ba1d6p-19,
    0x1.2d97c4p4
  },
  { // Entry 934
    0x1.f9990e91b1d916e582242347112ba1d6p-19,
    -0x1.2d97c4p4
  },
  { // Entry 935
    -0x1.f3321d23519fe1dcfdcd2f1f762008a4p-20,
    0x1.2d97c6p4
  },
  { // Entry 936
    0x1.f3321d23519fe1dcfdcd2f1f762008a4p-20,
    -0x1.2d97c6p4
  },
  { // Entry 937
    0x1.99bc5b961b1b24fdb77fcee08ba2f720p-25,
    0x1.2d97c8p4
  },
  { // Entry 938
    -0x1.99bc5b961b1b24fdb77fcee08ba2f720p-25,
    -0x1.2d97c8p4
  },
  { // Entry 939
    0x1.ffff18ab2756ba0a20aaf4392b0a8019p-1,
    0x1.3a28c2p4
  },
  { // Entry 940
    -0x1.ffff18ab2756ba0a20aaf4392b0a8019p-1,
    -0x1.3a28c2p4
  },
  { // Entry 941
    0x1.ffff98aafd818525d24d664ef962ef14p-1,
    0x1.3a28c4p4
  },
  { // Entry 942
    -0x1.ffff98aafd818525d24d664ef962ef14p-1,
    -0x1.3a28c4p4
  },
  { // Entry 943
    0x1.00000c5579d621ab7334eff31d23cf2cp0,
    0x1.3a28c6p4
  },
  { // Entry 944
    -0x1.00000c5579d621ab7334eff31d23cf2cp0,
    -0x1.3a28c6p4
  },
  { // Entry 945
    0x1.3846b310de7c796adb3ea2ea22b108e2p18,
    0x1.46b9c0p4
  },
  { // Entry 946
    -0x1.3846b310de7c796adb3ea2ea22b108e2p18,
    -0x1.46b9c0p4
  },
  { // Entry 947
    0x1.904425fc92eab0abfe96aeeb6ffb2dc8p19,
    0x1.46b9c2p4
  },
  { // Entry 948
    -0x1.904425fc92eab0abfe96aeeb6ffb2dc8p19,
    -0x1.46b9c2p4
  },
  { // Entry 949
    -0x1.6322bacb22de6af00228d2ea4d6d2799p20,
    0x1.46b9c4p4
  },
  { // Entry 950
    0x1.6322bacb22de6af00228d2ea4d6d2799p20,
    -0x1.46b9c4p4
  },
  { // Entry 951
    -0x1.00005e331d6dbee9f9d431b49ea7b723p0,
    0x1.534abep4
  },
  { // Entry 952
    0x1.00005e331d6dbee9f9d431b49ea7b723p0,
    -0x1.534abep4
  },
  { // Entry 953
    -0x1.00001e330de0f7c734bc57a4c6650327p0,
    0x1.534ac0p4
  },
  { // Entry 954
    0x1.00001e330de0f7c734bc57a4c6650327p0,
    -0x1.534ac0p4
  },
  { // Entry 955
    -0x1.ffffbc661ca868d5a4418f0d1cd7c22fp-1,
    0x1.534ac2p4
  },
  { // Entry 956
    0x1.ffffbc661ca868d5a4418f0d1cd7c22fp-1,
    -0x1.534ac2p4
  },
  { // Entry 957
    -0x1.4ddd3ba9f1214deb40672397d6f191bcp-19,
    0x1.5fdbbcp4
  },
  { // Entry 958
    0x1.4ddd3ba9f1214deb40672397d6f191bcp-19,
    -0x1.5fdbbcp4
  },
  { // Entry 959
    -0x1.3774eea7b8d7214bc89b11532f82d323p-21,
    0x1.5fdbbep4
  },
  { // Entry 960
    0x1.3774eea7b8d7214bc89b11532f82d323p-21,
    -0x1.5fdbbep4
  },
  { // Entry 961
    0x1.644588ac248da6d01941121f50673b3fp-20,
    0x1.5fdbc0p4
  },
  { // Entry 962
    -0x1.644588ac248da6d01941121f50673b3fp-20,
    -0x1.5fdbc0p4
  },
  { // Entry 963
    0x1.ffff6e88f1320794d845e8e0fe1fd8bdp-1,
    0x1.6c6cbap4
  },
  { // Entry 964
    -0x1.ffff6e88f1320794d845e8e0fe1fd8bdp-1,
    -0x1.6c6cbap4
  },
  { // Entry 965
    0x1.ffffee88dcd4429f15c0e4a95b9ba0e6p-1,
    0x1.6c6cbcp4
  },
  { // Entry 966
    -0x1.ffffee88dcd4429f15c0e4a95b9ba0e6p-1,
    -0x1.6c6cbcp4
  },
  { // Entry 967
    0x1.00003744743b3dbd37dd053e702bd754p0,
    0x1.6c6cbep4
  },
  { // Entry 968
    -0x1.00003744743b3dbd37dd053e702bd754p0,
    -0x1.6c6cbep4
  },
  { // Entry 969
    0x1.04109ab0ec78f827ee95cea746b38c20p18,
    0x1.78fdb6p4
  },
  { // Entry 970
    -0x1.04109ab0ec78f827ee95cea746b38c20p18,
    -0x1.78fdb6p4
  },
  { // Entry 971
    0x1.0842c9b32d2125dbf5c20d70c46b17a5p19,
    0x1.78fdb8p4
  },
  { // Entry 972
    -0x1.0842c9b32d2125dbf5c20d70c46b17a5p19,
    -0x1.78fdb8p4
  },
  { // Entry 973
    -0x1.ffd49133e26a9c749966630dee813ddep23,
    0x1.78fdbap4
  },
  { // Entry 974
    0x1.ffd49133e26a9c749966630dee813ddep23,
    -0x1.78fdbap4
  },
  { // Entry 975
    -0x1.000073443152301fa59338eec29c3778p0,
    0x1.858eb4p4
  },
  { // Entry 976
    0x1.000073443152301fa59338eec29c3778p0,
    -0x1.858eb4p4
  },
  { // Entry 977
    -0x1.000033441c81232d3d9fc34bea81fb7cp0,
    0x1.858eb6p4
  },
  { // Entry 978
    0x1.000033441c81232d3d9fc34bea81fb7cp0,
    -0x1.858eb6p4
  },
  { // Entry 979
    -0x1.ffffe6882f603946b53b042361aec82cp-1,
    0x1.858eb8p4
  },
  { // Entry 980
    0x1.ffffe6882f603946b53b042361aec82cp-1,
    -0x1.858eb8p4
  },
  { // Entry 981
    -0x1.cb6cd4cb82a91dfc4af9a499a575e4a4p-3,
    0x1.fffffep62
  },
  { // Entry 982
    0x1.cb6cd4cb82a91dfc4af9a499a575e4a4p-3,
    -0x1.fffffep62
  },
  { // Entry 983
    0x1.52f50e757941cbff5b7c2e06a1ab7e9dp6,
    0x1.p63
  },
  { // Entry 984
    -0x1.52f50e757941cbff5b7c2e06a1ab7e9dp6,
    -0x1.p63
  },
  { // Entry 985
    -0x1.29cbd12821b399c9ee4f265da51881a8p1,
    0x1.000002p63
  },
  { // Entry 986
    0x1.29cbd12821b399c9ee4f265da51881a8p1,
    -0x1.000002p63
  },
  { // Entry 987
    0x1.3e4d9148d7086727da944e1c052b68afp-1,
    0x1.fffffep26
  },
  { // Entry 988
    -0x1.3e4d9148d7086727da944e1c052b68afp-1,
    -0x1.fffffep26
  },
  { // Entry 989
    -0x1.2e8fc1af81d8baa8899a3325200c0dcbp0,
    0x1.p27
  },
  { // Entry 990
    0x1.2e8fc1af81d8baa8899a3325200c0dcbp0,
    -0x1.p27
  },
  { // Entry 991
    -0x1.4ce9748e524f77ad85735c7f7d668cf1p-1,
    0x1.000002p27
  },
  { // Entry 992
    0x1.4ce9748e524f77ad85735c7f7d668cf1p-1,
    -0x1.000002p27
  },
  { // Entry 993
    0x1.7e3005d57ed93ae45b1bea3e3615bb67p1,
    0x1.fffffep23
  },
  { // Entry 994
    -0x1.7e3005d57ed93ae45b1bea3e3615bb67p1,
    -0x1.fffffep23
  },
  { // Entry 995
    -0x1.3ea28271a9bea36e744f9ce537ba4b59p0,
    0x1.p24
  },
  { // Entry 996
    0x1.3ea28271a9bea36e744f9ce537ba4b59p0,
    -0x1.p24
  },
  { // Entry 997
    0x1.fe929b4282105a160a9be2731df20a6cp0,
    0x1.000002p24
  },
  { // Entry 998
    -0x1.fe929b4282105a160a9be2731df20a6cp0,
    -0x1.000002p24
  },
  { // Entry 999
    0x1.2866f06194e0c2c7ee22ee9f8f9dcaeep0,
    0x1.fffffep1
  },
  { // Entry 1000
    -0x1.2866f06194e0c2c7ee22ee9f8f9dcaeep0,
    -0x1.fffffep1
  },
  { // Entry 1001
    0x1.2866f9be4de1370db9078607012cb07bp0,
    0x1.p2
  },
  { // Entry 1002
    -0x1.2866f9be4de1370db9078607012cb07bp0,
    -0x1.p2
  },
  { // Entry 1003
    0x1.28670c77c0e647138d4fc7181ef9b61fp0,
    0x1.000002p2
  },
  { // Entry 1004
    -0x1.28670c77c0e647138d4fc7181ef9b61fp0,
    -0x1.000002p2
  },
  { // Entry 1005
    -0x1.17af68a6d42f772bd249f5d692afa4e7p1,
    0x1.fffffep0
  },
  { // Entry 1006
    0x1.17af68a6d42f772bd249f5d692afa4e7p1,
    -0x1.fffffep0
  },
  { // Entry 1007
    -0x1.17af62e0950f83b5099087aaf67af9c1p1,
    0x1.p1
  },
  { // Entry 1008
    0x1.17af62e0950f83b5099087aaf67af9c1p1,
    -0x1.p1
  },
  { // Entry 1009
    -0x1.17af5754176705173cec89d01381f553p1,
    0x1.000002p1
  },
  { // Entry 1010
    0x1.17af5754176705173cec89d01381f553p1,
    -0x1.000002p1
  },
  { // Entry 1011
    0x1.8eb2425eff72860d56d61056db54ef67p0,
    0x1.fffffep-1
  },
  { // Entry 1012
    -0x1.8eb2425eff72860d56d61056db54ef67p0,
    -0x1.fffffep-1
  },
  { // Entry 1013
    0x1.8eb245cbee3a5b8acc7d41323140b3b5p0,
    0x1.p0
  },
  { // Entry 1014
    -0x1.8eb245cbee3a5b8acc7d41323140b3b5p0,
    -0x1.p0
  },
  { // Entry 1015
    0x1.8eb24ca5cbea08f991206a3eaf93ab98p0,
    0x1.000002p0
  },
  { // Entry 1016
    -0x1.8eb24ca5cbea08f991206a3eaf93ab98p0,
    -0x1.000002p0
  },
  { // Entry 1017
    0x1.17b4f472cd791aabfe4ea91afb5e79e7p-1,
    0x1.fffffep-2
  },
  { // Entry 1018
    -0x1.17b4f472cd791aabfe4ea91afb5e79e7p-1,
    -0x1.fffffep-2
  },
  { // Entry 1019
    0x1.17b4f5bf3474a4317964807882444cc8p-1,
    0x1.p-1
  },
  { // Entry 1020
    -0x1.17b4f5bf3474a4317964807882444cc8p-1,
    -0x1.p-1
  },
  { // Entry 1021
    0x1.17b4f858026dd8033ed3d8d6d5350ca9p-1,
    0x1.000002p-1
  },
  { // Entry 1022
    -0x1.17b4f858026dd8033ed3d8d6d5350ca9p-1,
    -0x1.000002p-1
  },
  { // Entry 1023
    0x1.0578593313db659cf3ab88a235218456p-2,
    0x1.fffffep-3
  },
  { // Entry 1024
    -0x1.0578593313db659cf3ab88a235218456p-2,
    -0x1.fffffep-3
  },
  { // Entry 1025
    0x1.05785a43c4c55e63940188965c28bd0fp-2,
    0x1.p-2
  },
  { // Entry 1026
    -0x1.05785a43c4c55e63940188965c28bd0fp-2,
    -0x1.p-2
  },
  { // Entry 1027
    0x1.05785c652699b8628b7876b7bd83c0ccp-2,
    0x1.000002p-2
  },
  { // Entry 1028
    -0x1.05785c652699b8628b7876b7bd83c0ccp-2,
    -0x1.000002p-2
  },
  { // Entry 1029
    0x1.015779ed46574724b9025a4472a1ae0ap-3,
    0x1.fffffep-4
  },
  { // Entry 1030
    -0x1.015779ed46574724b9025a4472a1ae0ap-3,
    -0x1.fffffep-4
  },
  { // Entry 1031
    0x1.01577af1511a4e0459f5b872d4ff34fdp-3,
    0x1.p-3
  },
  { // Entry 1032
    -0x1.01577af1511a4e0459f5b872d4ff34fdp-3,
    -0x1.p-3
  },
  { // Entry 1033
    0x1.01577cf966a0744553dd44a994f0bbd1p-3,
    0x1.000002p-3
  },
  { // Entry 1034
    -0x1.01577cf966a0744553dd44a994f0bbd1p-3,
    -0x1.000002p-3
  },
  { // Entry 1035
    0x1.005576844d44fda0b80348bb17498aa1p-4,
    0x1.fffffep-5
  },
  { // Entry 1036
    -0x1.005576844d44fda0b80348bb17498aa1p-4,
    -0x1.fffffep-5
  },
  { // Entry 1037
    0x1.005577854df0083293be639057b0c681p-4,
    0x1.p-4
  },
  { // Entry 1038
    -0x1.005577854df0083293be639057b0c681p-4,
    -0x1.p-4
  },
  { // Entry 1039
    0x1.005579874f46235e52082a4d0ddfc6e1p-4,
    0x1.000002p-4
  },
  { // Entry 1040
    -0x1.005579874f46235e52082a4d0ddfc6e1p-4,
    -0x1.000002p-4
  },
  { // Entry 1041
    0x1.001556776eb5d98f82e1b5eab28c6b5fp-5,
    0x1.fffffep-6
  },
  { // Entry 1042
    -0x1.001556776eb5d98f82e1b5eab28c6b5fp-5,
    -0x1.fffffep-6
  },
  { // Entry 1043
    0x1.00155777aec0857d22c97e809860288dp-5,
    0x1.p-5
  },
  { // Entry 1044
    -0x1.00155777aec0857d22c97e809860288dp-5,
    -0x1.p-5
  },
  { // Entry 1045
    0x1.001559782ed5ded8e2b4c819cb7c9f11p-5,
    0x1.000002p-5
  },
  { // Entry 1046
    -0x1.001559782ed5ded8e2b4c819cb7c9f11p-5,
    -0x1.000002p-5
  },
  { // Entry 1047
    0x1.000554776853e041010da22a656f8267p-6,
    0x1.fffffep-7
  },
  { // Entry 1048
    -0x1.000554776853e041010da22a656f8267p-6,
    -0x1.fffffep-7
  },
  { // Entry 1049
    0x1.0005557778548ae1b5f60574706e8238p-6,
    0x1.p-6
  },
  { // Entry 1050
    -0x1.0005557778548ae1b5f60574706e8238p-6,
    -0x1.p-6
  },
  { // Entry 1051
    0x1.000557779855e08327c758e20d691dadp-6,
    0x1.000002p-6
  },
  { // Entry 1052
    -0x1.000557779855e08327c758e20d691dadp-6,
    -0x1.000002p-6
  },
  { // Entry 1053
    0x1.fffffe0aaaaa8aeeef0d9b53ad2f4823p-15,
    0x1.fffffep-15
  },
  { // Entry 1054
    -0x1.fffffe0aaaaa8aeeef0d9b53ad2f4823p-15,
    -0x1.fffffep-15
  },
  { // Entry 1055
    0x1.00000005555555777777785485485a1ep-14,
    0x1.p-14
  },
  { // Entry 1056
    -0x1.00000005555555777777785485485a1ep-14,
    -0x1.p-14
  },
  { // Entry 1057
    0x1.000002055555757777b8cdaa0aa9c640p-14,
    0x1.000002p-14
  },
  { // Entry 1058
    -0x1.000002055555757777b8cdaa0aa9c640p-14,
    -0x1.000002p-14
  },
  { // Entry 1059
    0x1.fffffe00000002aaaaa2aaaab2aeeeecp-28,
    0x1.fffffep-28
  },
  { // Entry 1060
    -0x1.fffffe00000002aaaaa2aaaab2aeeeecp-28,
    -0x1.fffffep-28
  },
  { // Entry 1061
    0x1.00000000000001555555555555577777p-27,
    0x1.p-27
  },
  { // Entry 1062
    -0x1.00000000000001555555555555577777p-27,
    -0x1.p-27
  },
  { // Entry 1063
    0x1.0000020000000155555d555565577782p-27,
    0x1.000002p-27
  },
  { // Entry 1064
    -0x1.0000020000000155555d555565577782p-27,
    -0x1.000002p-27
  },
  { // Entry 1065
    0x1.fffffe000000000aaaaa8aaaaacaaaeep-31,
    0x1.fffffep-31
  },
  { // Entry 1066
    -0x1.fffffe000000000aaaaa8aaaaacaaaeep-31,
    -0x1.fffffep-31
  },
  { // Entry 1067
    0x1.00000000000000055555555555555577p-30,
    0x1.p-30
  },
  { // Entry 1068
    -0x1.00000000000000055555555555555577p-30,
    -0x1.p-30
  },
  { // Entry 1069
    0x1.00000200000000055555755555955577p-30,
    0x1.000002p-30
  },
  { // Entry 1070
    -0x1.00000200000000055555755555955577p-30,
    -0x1.000002p-30
  },
  { // Entry 1071
    0x1.393d94b4988c1f254345c9f7d9ea0c03p-1,
    -0x1.fffffep127
  },
  { // Entry 1072
    -0x1.393d94b4988c1f254345c9f7d9ea0c03p-1,
    0x1.fffffep127
  },
  { // Entry 1073
    -0x1.393d94b4988c1f254345c9f7d9ea0c03p-1,
    0x1.fffffep127
  },
  { // Entry 1074
    0x1.393d94b4988c1f254345c9f7d9ea0c03p-1,
    -0x1.fffffep127
  },
  { // Entry 1075
    -0x1.393d94b4988c1f254345c9f7d9ea0c03p-1,
    0x1.fffffep127
  },
  { // Entry 1076
    0x1.393d94b4988c1f254345c9f7d9ea0c03p-1,
    -0x1.fffffep127
  },
  { // Entry 1077
    0x1.acf315a87aa5da8654c844b917d14745p-1,
    0x1.fffffcp127
  },
  { // Entry 1078
    -0x1.acf315a87aa5da8654c844b917d14745p-1,
    -0x1.fffffcp127
  },
  { // Entry 1079
    0x1.777a5cf72cedf3b544c81808b515f1f9p-24,
    0x1.921fb6p1
  },
  { // Entry 1080
    -0x1.777a5cf72cedf3b544c81808b515f1f9p-24,
    -0x1.921fb6p1
  },
  { // Entry 1081
    -0x1.5d14946dc98975d6421a55284fe020a1p24,
    0x1.921fb6p0
  },
  { // Entry 1082
    0x1.5d14946dc98975d6421a55284fe020a1p24,
    -0x1.921fb6p0
  },
  { // Entry 1083
    0x1.8eb24ca5cbea08f991206a3eaf93ab98p0,
    0x1.000002p0
  },
  { // Entry 1084
    -0x1.8eb24ca5cbea08f991206a3eaf93ab98p0,
    -0x1.000002p0
  },
  { // Entry 1085
    0x1.8eb245cbee3a5b8acc7d41323140b3b5p0,
    0x1.p0
  },
  { // Entry 1086
    -0x1.8eb245cbee3a5b8acc7d41323140b3b5p0,
    -0x1.p0
  },
  { // Entry 1087
    0x1.8eb2425eff72860d56d61056db54ef67p0,
    0x1.fffffep-1
  },
  { // Entry 1088
    -0x1.8eb2425eff72860d56d61056db54ef67p0,
    -0x1.fffffep-1
  },
  { // Entry 1089
    0x1.000000bbbd2ec06d6d6fff3655a346acp0,
    0x1.921fb6p-1
  },
  { // Entry 1090
    -0x1.000000bbbd2ec06d6d6fff3655a346acp0,
    -0x1.921fb6p-1
  },
  { // Entry 1091
    0x1.000002p-126,
    0x1.000002p-126
  },
  { // Entry 1092
    -0x1.000002p-126,
    -0x1.000002p-126
  },
  { // Entry 1093
    0x1.p-126,
    0x1.p-126
  },
  { // Entry 1094
    -0x1.p-126,
    -0x1.p-126
  },
  { // Entry 1095
    0x1.fffffcp-127,
    0x1.fffffcp-127
  },
  { // Entry 1096
    -0x1.fffffcp-127,
    -0x1.fffffcp-127
  },
  { // Entry 1097
    0x1.fffff8p-127,
    0x1.fffff8p-127
  },
  { // Entry 1098
    -0x1.fffff8p-127,
    -0x1.fffff8p-127
  },
  { // Entry 1099
    0x1.p-148,
    0x1.p-148
  },
  { // Entry 1100
    -0x1.p-148,
    -0x1.p-148
  },
  { // Entry 1101
    0x1.p-149,
    0x1.p-149
  },
  { // Entry 1102
    -0x1.p-149,
    -0x1.p-149
  },
  { // Entry 1103
    0.0,
    0.0f
  },
  { // Entry 1104
    -0.0,
    -0.0f
  },
};
#endif // __BIONIC__

TEST(math_tanf, tanf_intel) {
#if defined(__BIONIC__)
  fesetenv(FE_DFL_ENV);
  for (size_t i = 0; i < sizeof(g_tanf_intel_data)/sizeof(tanf_intel_data_t); i++) {
    EXPECT_FLOAT_EQ(g_tanf_intel_data[i].expected, tanf(g_tanf_intel_data[i].call_data)) << "Failed on element " << i;
  }
#else // __BIONIC__
  GTEST_LOG_(INFO) << "This test does nothing.";
#endif // __BIONIC__
}
