/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <math.h>

#include <fenv.h>

#include <gtest/gtest.h>

#if defined(__BIONIC__)
typedef struct {
  double expected;
  double call_data;
} tan_intel_data_t;

static tan_intel_data_t g_tan_intel_data[] = {
  { // Entry 0
    0x1.5078cebff9c728000000000000024df8p-5,
    0x1.50486b2f87014p-5
  },
  { // Entry 1
    -0x1.5078cebff9c728000000000000024df8p-5,
    -0x1.50486b2f87014p-5
  },
  { // Entry 2
    0x1.5389e6df41978fffffffffffffc61f54p-4,
    0x1.52c39ef070cadp-4
  },
  { // Entry 3
    -0x1.5389e6df41978fffffffffffffc61f54p-4,
    -0x1.52c39ef070cadp-4
  },
  { // Entry 4
    0x1.a933fe176b37500000000000000a4065p-3,
    0x1.a33f32ac5ceb5p-3
  },
  { // Entry 5
    -0x1.a933fe176b37500000000000000a4065p-3,
    -0x1.a33f32ac5ceb5p-3
  },
  { // Entry 6
    0x1.fac71cd34eea680000000000009a0c10p-2,
    0x1.d696bfa988db9p-2
  },
  { // Entry 7
    -0x1.fac71cd34eea680000000000009a0c10p-2,
    -0x1.d696bfa988db9p-2
  },
  { // Entry 8
    0x1.7ba49f739829efffffffffffffe7e9bep-1,
    0x1.46ac372243536p-1
  },
  { // Entry 9
    -0x1.7ba49f739829efffffffffffffe7e9bep-1,
    -0x1.46ac372243536p-1
  },
  { // Entry 10
    -0x1.p-1074,
    -0x1.0p-1074
  },
  { // Entry 11
    0x1.p-1074,
    0x1.0p-1074
  },
  { // Entry 12
    -0x1.8f048832144b70021ccd7a5246cb0b20p0,
    -0x1.00180p0
  },
  { // Entry 13
    0x1.8f048832144b70021ccd7a5246cb0b20p0,
    0x1.00180p0
  },
  { // Entry 14
    -0x1.8e884b24313ae802db47899fad15a6c6p0,
    -0x1.090cca18a5565p2
  },
  { // Entry 15
    0x1.8e884b24313ae802db47899fad15a6c6p0,
    0x1.090cca18a5565p2
  },
  { // Entry 16
    -0x1.ca18654b356972967a4f1e8404b9f972p0,
    -0x1.0faa7650df144p0
  },
  { // Entry 17
    0x1.ca18654b356972967a4f1e8404b9f972p0,
    0x1.0faa7650df144p0
  },
  { // Entry 18
    -0x1.e52fafa22ef1481d437e7ed32cba03b1p-2,
    -0x1.1800000000040p5
  },
  { // Entry 19
    0x1.e52fafa22ef1481d437e7ed32cba03b1p-2,
    0x1.1800000000040p5
  },
  { // Entry 20
    -0x1.a3ca421dc30f1c5760a1ae07396fec33p-3,
    -0x1.4000527aca388p99
  },
  { // Entry 21
    0x1.a3ca421dc30f1c5760a1ae07396fec33p-3,
    0x1.4000527aca388p99
  },
  { // Entry 22
    0x1.1f3b7d1978609800a1628e1df9558df6p1,
    -0x1.486c3634751ecp2
  },
  { // Entry 23
    -0x1.1f3b7d1978609800a1628e1df9558df6p1,
    0x1.486c3634751ecp2
  },
  { // Entry 24
    -0x1.7eb873343fa7ab5d9ef9a78afd33d501p-1,
    -0x1.48a71800b5713p-1
  },
  { // Entry 25
    0x1.7eb873343fa7ab5d9ef9a78afd33d501p-1,
    0x1.48a71800b5713p-1
  },
  { // Entry 26
    0x1.be071572f64e88047c3939ba46626a25p-1,
    -0x1.49af0314eea3cp299
  },
  { // Entry 27
    -0x1.be071572f64e88047c3939ba46626a25p-1,
    0x1.49af0314eea3cp299
  },
  { // Entry 28
    0x1.ffbb2647f57a181bd1296faf33c04e3ep-1,
    -0x1.5fe00c814ffd6p2
  },
  { // Entry 29
    -0x1.ffbb2647f57a181bd1296faf33c04e3ep-1,
    0x1.5fe00c814ffd6p2
  },
  { // Entry 30
    -0x1.a8eb142b2f42756e6dedff09267a62c6p-1,
    -0x1.62ac241f79439p-1
  },
  { // Entry 31
    0x1.a8eb142b2f42756e6dedff09267a62c6p-1,
    0x1.62ac241f79439p-1
  },
  { // Entry 32
    -0x1.7d1d3559ddac885ee30632c760998c8ep-4,
    -0x1.7c051b476ca8dp-4
  },
  { // Entry 33
    0x1.7d1d3559ddac885ee30632c760998c8ep-4,
    0x1.7c051b476ca8dp-4
  },
  { // Entry 34
    -0x1.0e1d0305b7b727ff193d9d0b8eaff181p2,
    -0x1.7e43c880074c6p996
  },
  { // Entry 35
    0x1.0e1d0305b7b727ff193d9d0b8eaff181p2,
    0x1.7e43c880074c6p996
  },
  { // Entry 36
    -0x1.812bdfe0246bbf2a7ab6477a5cbb352bp-4,
    -0x1.800ac363398c4p-4
  },
  { // Entry 37
    0x1.812bdfe0246bbf2a7ab6477a5cbb352bp-4,
    0x1.800ac363398c4p-4
  },
  { // Entry 38
    -0x1.850e5544b0c797b36034c98e16f3fafbp-4,
    -0x1.83e46aedbff36p-4
  },
  { // Entry 39
    0x1.850e5544b0c797b36034c98e16f3fafbp-4,
    0x1.83e46aedbff36p-4
  },
  { // Entry 40
    0x1.e6b5d91bba9337fc0ceb686c60cd29bdp-2,
    -0x1.83ecf42e9265ap3
  },
  { // Entry 41
    -0x1.e6b5d91bba9337fc0ceb686c60cd29bdp-2,
    0x1.83ecf42e9265ap3
  },
  { // Entry 42
    -0x1.f3688bc2594e20102573cff48190ac28p-1,
    -0x1.8bcp-1
  },
  { // Entry 43
    0x1.f3688bc2594e20102573cff48190ac28p-1,
    0x1.8bcp-1
  },
  { // Entry 44
    0x1.ec0d0facdd08b773a1d93484e2d66c45p-2,
    -0x1.8d2ffffffffd1p9
  },
  { // Entry 45
    -0x1.ec0d0facdd08b773a1d93484e2d66c45p-2,
    0x1.8d2ffffffffd1p9
  },
  { // Entry 46
    0x1.ec0336d5392597689b640bf049227338p-2,
    -0x1.8d3000fffffd1p9
  },
  { // Entry 47
    -0x1.ec0336d5392597689b640bf049227338p-2,
    0x1.8d3000fffffd1p9
  },
  { // Entry 48
    -0x1.f8093a017021f81c01c131475e50e49bp-1,
    -0x1.baeee6f6fa538p6
  },
  { // Entry 49
    0x1.f8093a017021f81c01c131475e50e49bp-1,
    0x1.baeee6f6fa538p6
  },
  { // Entry 50
    0x1.deaf34994b7e77fd52a408f0c677eae1p3,
    -0x1.c6867e07455eap3
  },
  { // Entry 51
    -0x1.deaf34994b7e77fd52a408f0c677eae1p3,
    0x1.c6867e07455eap3
  },
  { // Entry 52
    -0x1.f29aa87d4e1dd81b7b69abe9790ee0abp-1,
    -0x1.d27ffffffe0p7
  },
  { // Entry 53
    0x1.f29aa87d4e1dd81b7b69abe9790ee0abp-1,
    0x1.d27ffffffe0p7
  },
  { // Entry 54
    0x1.762fb47a192597ffffffeeedb26fb978p-3,
    -0x1.f0df38029c9efp3
  },
  { // Entry 55
    -0x1.762fb47a192597ffffffeeedb26fb978p-3,
    0x1.f0df38029c9efp3
  },
  { // Entry 56
    -0x1.8eb23ef2126bb7fffd153c7ff90e9f6cp0,
    -0x1.fffffc0000fffp-1
  },
  { // Entry 57
    0x1.8eb23ef2126bb7fffd153c7ff90e9f6cp0,
    0x1.fffffc0000fffp-1
  },
  { // Entry 58
    -0x1.d299d285bf018423fbc14efc00ed5799p-2,
    -0x1.ffffffffffffcp1023
  },
  { // Entry 59
    0x1.d299d285bf018423fbc14efc00ed5799p-2,
    0x1.ffffffffffffcp1023
  },
  { // Entry 60
    0x1.p-1074,
    0x1.0p-1074
  },
  { // Entry 61
    -0x1.p-1074,
    -0x1.0p-1074
  },
  { // Entry 62
    -0x1.82bee572e2ac8c76d6909c66b282e962p-6,
    0x1.0p64
  },
  { // Entry 63
    0x1.82bee572e2ac8c76d6909c66b282e962p-6,
    -0x1.0p64
  },
  { // Entry 64
    0x1.f53a8d05afcf6c4bf2e1e5208b34d5c6p4,
    0x1.0000000000001p51
  },
  { // Entry 65
    -0x1.f53a8d05afcf6c4bf2e1e5208b34d5c6p4,
    -0x1.0000000000001p51
  },
  { // Entry 66
    -0x1.6b371df5980cd3db36768e36046a4a81p-1,
    0x1.0000000000001p1017
  },
  { // Entry 67
    0x1.6b371df5980cd3db36768e36046a4a81p-1,
    -0x1.0000000000001p1017
  },
  { // Entry 68
    -0x1.b32e78f49a0c83c7f60a3dc3ef8ecf1fp2,
    0x1.0000000000003p3
  },
  { // Entry 69
    0x1.b32e78f49a0c83c7f60a3dc3ef8ecf1fp2,
    -0x1.0000000000003p3
  },
  { // Entry 70
    0x1.98afbd24264bc3a9d1838074a3daa5e5p-1,
    0x1.0000000000003p21
  },
  { // Entry 71
    -0x1.98afbd24264bc3a9d1838074a3daa5e5p-1,
    -0x1.0000000000003p21
  },
  { // Entry 72
    0x1.b667a2abe36c280315c62a1f974e7611p0,
    0x1.0000000000003p511
  },
  { // Entry 73
    -0x1.b667a2abe36c280315c62a1f974e7611p0,
    -0x1.0000000000003p511
  },
  { // Entry 74
    0x1.204c26a427861ffefb73796bcf1fd724p-2,
    0x1.0000000000003p716
  },
  { // Entry 75
    -0x1.204c26a427861ffefb73796bcf1fd724p-2,
    -0x1.0000000000003p716
  },
  { // Entry 76
    0x1.91c8f2938262ce2e9ad99ab17e46abd6p4,
    0x1.0000000000007p8
  },
  { // Entry 77
    -0x1.91c8f2938262ce2e9ad99ab17e46abd6p4,
    -0x1.0000000000007p8
  },
  { // Entry 78
    -0x1.27f7f0880031fe42ed1d5fedc496d14ep-2,
    0x1.0000000000038p380
  },
  { // Entry 79
    0x1.27f7f0880031fe42ed1d5fedc496d14ep-2,
    -0x1.0000000000038p380
  },
  { // Entry 80
    -0x1.d6890cc32711d4b046903ad8851a41bbp-3,
    0x1.0000000000118p380
  },
  { // Entry 81
    0x1.d6890cc32711d4b046903ad8851a41bbp-3,
    -0x1.0000000000118p380
  },
  { // Entry 82
    0x1.9af0e6f72f9127ffffc0200ea7f406f4p-3,
    0x1.0000000000908p500
  },
  { // Entry 83
    -0x1.9af0e6f72f9127ffffc0200ea7f406f4p-3,
    -0x1.0000000000908p500
  },
  { // Entry 84
    0x1.17b4f5bf440978002d66f1bd37032532p-1,
    0x1.000000000c0p-1
  },
  { // Entry 85
    -0x1.17b4f5bf440978002d66f1bd37032532p-1,
    -0x1.000000000c0p-1
  },
  { // Entry 86
    -0x1.17eb22e4dba72800d2a000698263d582p0,
    0x1.00000001cp40
  },
  { // Entry 87
    0x1.17eb22e4dba72800d2a000698263d582p0,
    -0x1.00000001cp40
  },
  { // Entry 88
    0x1.f6f03ce5690a6e3880b95fd8b2c8363ep-1,
    0x1.0000001p250
  },
  { // Entry 89
    -0x1.f6f03ce5690a6e3880b95fd8b2c8363ep-1,
    -0x1.0000001p250
  },
  { // Entry 90
    0x1.e23b78282a75d0dd6da35692d142bc63p-1,
    0x1.000000988p27
  },
  { // Entry 91
    -0x1.e23b78282a75d0dd6da35692d142bc63p-1,
    -0x1.000000988p27
  },
  { // Entry 92
    -0x1.981b657e1ca27009d82d8e18314240b5p-3,
    0x1.00000c0p429
  },
  { // Entry 93
    0x1.981b657e1ca27009d82d8e18314240b5p-3,
    -0x1.00000c0p429
  },
  { // Entry 94
    -0x1.455a2184f4c3dffb0986919cece683a4p-1,
    0x1.00000fcp1000
  },
  { // Entry 95
    0x1.455a2184f4c3dffb0986919cece683a4p-1,
    -0x1.00000fcp1000
  },
  { // Entry 96
    0x1.8ee66962f210c800000568c7daad3a28p0,
    0x1.000f371b7a006p0
  },
  { // Entry 97
    -0x1.8ee66962f210c800000568c7daad3a28p0,
    -0x1.000f371b7a006p0
  },
  { // Entry 98
    -0x1.ecd75cf6d4663bee1c96f03184fae086p-3,
    0x1.001p15
  },
  { // Entry 99
    0x1.ecd75cf6d4663bee1c96f03184fae086p-3,
    -0x1.001p15
  },
  { // Entry 100
    0x1.17d42033277cc8244ccb6e5154482105p-1,
    0x1.0017ffffffffdp-1
  },
  { // Entry 101
    -0x1.17d42033277cc8244ccb6e5154482105p-1,
    -0x1.0017ffffffffdp-1
  },
  { // Entry 102
    0x1.8f048832144b70021ccd7a5246cb0b20p0,
    0x1.00180p0
  },
  { // Entry 103
    -0x1.8f048832144b70021ccd7a5246cb0b20p0,
    -0x1.00180p0
  },
  { // Entry 104
    -0x1.18273cc3e763900743704028cfb114a5p-2,
    0x1.001fffep500
  },
  { // Entry 105
    0x1.18273cc3e763900743704028cfb114a5p-2,
    -0x1.001fffep500
  },
  { // Entry 106
    -0x1.d8f90cad30546ce5b8268b330ce50a6fp-2,
    0x1.018p40
  },
  { // Entry 107
    0x1.d8f90cad30546ce5b8268b330ce50a6fp-2,
    -0x1.018p40
  },
  { // Entry 108
    0x1.b079ea0d14a4a7ffc04bd6fbf451bb34p-2,
    0x1.01b8a484ac0b6p4
  },
  { // Entry 109
    -0x1.b079ea0d14a4a7ffc04bd6fbf451bb34p-2,
    -0x1.01b8a484ac0b6p4
  },
  { // Entry 110
    -0x1.a40c262f6ab997fef43bf54af3c5a765p-1,
    0x1.026ac0ef32d40p28
  },
  { // Entry 111
    0x1.a40c262f6ab997fef43bf54af3c5a765p-1,
    -0x1.026ac0ef32d40p28
  },
  { // Entry 112
    0x1.03b8c1f3296657c651a13eb5b100fc78p-4,
    0x1.035fdcd08a596p-4
  },
  { // Entry 113
    -0x1.03b8c1f3296657c651a13eb5b100fc78p-4,
    -0x1.035fdcd08a596p-4
  },
  { // Entry 114
    0x1.044979d134ed97c78bfe58a9003bfac5p-4,
    0x1.03fp-4
  },
  { // Entry 115
    -0x1.044979d134ed97c78bfe58a9003bfac5p-4,
    -0x1.03fp-4
  },
  { // Entry 116
    -0x1.e717de7da2ce831066bad1df5e88a030p0,
    0x1.070p1
  },
  { // Entry 117
    0x1.e717de7da2ce831066bad1df5e88a030p0,
    -0x1.070p1
  },
  { // Entry 118
    -0x1.8c896f607ff52bbae86f63e19a988d2bp-1,
    0x1.070p30
  },
  { // Entry 119
    0x1.8c896f607ff52bbae86f63e19a988d2bp-1,
    -0x1.070p30
  },
  { // Entry 120
    0x1.fffffffff5d846af6f017262c9c81de4p-1,
    0x1.07e4cef4cbb0ep4
  },
  { // Entry 121
    -0x1.fffffffff5d846af6f017262c9c81de4p-1,
    -0x1.07e4cef4cbb0ep4
  },
  { // Entry 122
    0x1.b476d32c1b7457ffff66edb3f78a7003p0,
    0x1.0a53a78b13ab2p0
  },
  { // Entry 123
    -0x1.b476d32c1b7457ffff66edb3f78a7003p0,
    -0x1.0a53a78b13ab2p0
  },
  { // Entry 124
    0x1.f2df7c02d20cd81b33117c00545f7a6bp-1,
    0x1.0afbc268b9848p6
  },
  { // Entry 125
    -0x1.f2df7c02d20cd81b33117c00545f7a6bp-1,
    -0x1.0afbc268b9848p6
  },
  { // Entry 126
    -0x1.b571af562f08a5a03dd8493990b29db1p0,
    0x1.0cd5d435bea6dp1
  },
  { // Entry 127
    0x1.b571af562f08a5a03dd8493990b29db1p0,
    -0x1.0cd5d435bea6dp1
  },
  { // Entry 128
    -0x1.ac73d2920a7955336ab2a3436c77c276p0,
    0x1.0e0p1
  },
  { // Entry 129
    0x1.ac73d2920a7955336ab2a3436c77c276p0,
    -0x1.0e0p1
  },
  { // Entry 130
    -0x1.126dce8ac7c818000cfcf3df066a4a2dp-1,
    0x1.1086210842108p5
  },
  { // Entry 131
    0x1.126dce8ac7c818000cfcf3df066a4a2dp-1,
    -0x1.1086210842108p5
  },
  { // Entry 132
    -0x1.9680c02601046ca506c0e3f744db1d0ap0,
    0x1.110p1
  },
  { // Entry 133
    0x1.9680c02601046ca506c0e3f744db1d0ap0,
    -0x1.110p1
  },
  { // Entry 134
    0x1.d1e716934469b2bc02fa835ae0149f58p0,
    0x1.118p0
  },
  { // Entry 135
    -0x1.d1e716934469b2bc02fa835ae0149f58p0,
    -0x1.118p0
  },
  { // Entry 136
    -0x1.6aa73101430837fffffebaafd45f7efap-1,
    0x1.19df389f39e0ap3
  },
  { // Entry 137
    0x1.6aa73101430837fffffebaafd45f7efap-1,
    -0x1.19df389f39e0ap3
  },
  { // Entry 138
    0x1.cb9a99227bdc972cd4145969c3dc38c1p1,
    0x1.1c3598211013ap2
  },
  { // Entry 139
    -0x1.cb9a99227bdc972cd4145969c3dc38c1p1,
    -0x1.1c3598211013ap2
  },
  { // Entry 140
    -0x1.bc109c3e6172450a5308b4c6eb2898cap7,
    0x1.1d65aa4224c30p118
  },
  { // Entry 141
    0x1.bc109c3e6172450a5308b4c6eb2898cap7,
    -0x1.1d65aa4224c30p118
  },
  { // Entry 142
    -0x1.09b393f48b2c67ffff3bd559c6326e60p-1,
    0x1.1e4658272dc6fp3
  },
  { // Entry 143
    0x1.09b393f48b2c67ffff3bd559c6326e60p-1,
    -0x1.1e4658272dc6fp3
  },
  { // Entry 144
    0x1.20000000000798000000003d82666666p-22,
    0x1.2p-22
  },
  { // Entry 145
    -0x1.20000000000798000000003d82666666p-22,
    -0x1.2p-22
  },
  { // Entry 146
    -0x1.02a335b00707a7ffffbe455adab7e814p0,
    0x1.2127409620cacp95
  },
  { // Entry 147
    0x1.02a335b00707a7ffffbe455adab7e814p0,
    -0x1.2127409620cacp95
  },
  { // Entry 148
    0x1.2508b9c1273ac034c3c79c4088e2acfdp-4,
    0x1.2489224892248p-4
  },
  { // Entry 149
    -0x1.2508b9c1273ac034c3c79c4088e2acfdp-4,
    -0x1.2489224892248p-4
  },
  { // Entry 150
    0x1.fded5f53d132d26a8244a63f9bcdf153p2,
    0x1.2a52d119da061p237
  },
  { // Entry 151
    -0x1.fded5f53d132d26a8244a63f9bcdf153p2,
    -0x1.2a52d119da061p237
  },
  { // Entry 152
    0x1.2de56a6ef9c5d7e9c71030407530f1d7p-4,
    0x1.2d59ebab8dae4p-4
  },
  { // Entry 153
    -0x1.2de56a6ef9c5d7e9c71030407530f1d7p-4,
    -0x1.2d59ebab8dae4p-4
  },
  { // Entry 154
    0x1.31665eb191fba800b7e715fd11716c8cp-4,
    0x1.30d5f8e54b6d8p-4
  },
  { // Entry 155
    -0x1.31665eb191fba800b7e715fd11716c8cp-4,
    -0x1.30d5f8e54b6d8p-4
  },
  { // Entry 156
    0x1.3cc1d4d28bfd17fded9ae50407590f3fp-2,
    0x1.333275d63ec50p-2
  },
  { // Entry 157
    -0x1.3cc1d4d28bfd17fded9ae50407590f3fp-2,
    -0x1.333275d63ec50p-2
  },
  { // Entry 158
    0x1.3cc237c0c7dcbfff1046ad9a068af510p-2,
    0x1.3332d020b6da9p-2
  },
  { // Entry 159
    -0x1.3cc237c0c7dcbfff1046ad9a068af510p-2,
    -0x1.3332d020b6da9p-2
  },
  { // Entry 160
    0x1.5e472e16999df00000fc06ee474fbfc9p-1,
    0x1.333333401e66bp-1
  },
  { // Entry 161
    -0x1.5e472e16999df00000fc06ee474fbfc9p-1,
    -0x1.333333401e66bp-1
  },
  { // Entry 162
    0x1.b5ed1c2080a987fc84f26ec958b2ac47p-1,
    0x1.38f137cb9dbfcp9
  },
  { // Entry 163
    -0x1.b5ed1c2080a987fc84f26ec958b2ac47p-1,
    -0x1.38f137cb9dbfcp9
  },
  { // Entry 164
    0x1.01aa22e2133d37fffff2a0c08093358ep1,
    0x1.39a383f3fa003p85
  },
  { // Entry 165
    -0x1.01aa22e2133d37fffff2a0c08093358ep1,
    -0x1.39a383f3fa003p85
  },
  { // Entry 166
    0x1.ffffffffff58236322819d060eb67c3cp-1,
    0x1.3a28c59d54311p4
  },
  { // Entry 167
    -0x1.ffffffffff58236322819d060eb67c3cp-1,
    -0x1.3a28c59d54311p4
  },
  { // Entry 168
    0x1.7166689d4803e83d2b6b1d15f5aca26ep-1,
    0x1.4000000003fffp-1
  },
  { // Entry 169
    -0x1.7166689d4803e83d2b6b1d15f5aca26ep-1,
    -0x1.4000000003fffp-1
  },
  { // Entry 170
    -0x1.ff7d27b37eba0819199e533cc5016f0dp-1,
    0x1.40724a44714cfp5
  },
  { // Entry 171
    0x1.ff7d27b37eba0819199e533cc5016f0dp-1,
    -0x1.40724a44714cfp5
  },
  { // Entry 172
    0x1.453a7d29dadad7c0dda78a7398be0873p-4,
    0x1.448c2d6e1e1afp-4
  },
  { // Entry 173
    -0x1.453a7d29dadad7c0dda78a7398be0873p-4,
    -0x1.448c2d6e1e1afp-4
  },
  { // Entry 174
    -0x1.a50f7601413e53ab1c5a2f0d676c397cp0,
    0x1.478fc08p43
  },
  { // Entry 175
    0x1.a50f7601413e53ab1c5a2f0d676c397cp0,
    -0x1.478fc08p43
  },
  { // Entry 176
    -0x1.a9991acb7636beee5b1a5d35a8a89917p-4,
    0x1.4e93bee72b565p62
  },
  { // Entry 177
    0x1.a9991acb7636beee5b1a5d35a8a89917p-4,
    -0x1.4e93bee72b565p62
  },
  { // Entry 178
    0x1.2952396945947b726ebf025a8ba07093p1,
    0x1.4f0f308p488
  },
  { // Entry 179
    -0x1.2952396945947b726ebf025a8ba07093p1,
    -0x1.4f0f308p488
  },
  { // Entry 180
    0x1.5078cebff9c728000000000000024df8p-5,
    0x1.50486b2f87014p-5
  },
  { // Entry 181
    -0x1.5078cebff9c728000000000000024df8p-5,
    -0x1.50486b2f87014p-5
  },
  { // Entry 182
    -0x1.1c929b6ede9ee8000040a3d1ca90a9f4p-1,
    0x1.5130d552f1036p1
  },
  { // Entry 183
    0x1.1c929b6ede9ee8000040a3d1ca90a9f4p-1,
    -0x1.5130d552f1036p1
  },
  { // Entry 184
    0x1.2ab3189e2d4ae41c1aff3cc30cfedd30p1,
    0x1.52f00e0p793
  },
  { // Entry 185
    -0x1.2ab3189e2d4ae41c1aff3cc30cfedd30p1,
    -0x1.52f00e0p793
  },
  { // Entry 186
    -0x1.7d2e63fb988907a109091d130f9f20d1p0,
    0x1.5371684e5fb34p2
  },
  { // Entry 187
    0x1.7d2e63fb988907a109091d130f9f20d1p0,
    -0x1.5371684e5fb34p2
  },
  { // Entry 188
    -0x1.f9f4f0da4de54499283a8ac2f55f7258p-1,
    0x1.54ef2208956p239
  },
  { // Entry 189
    0x1.f9f4f0da4de54499283a8ac2f55f7258p-1,
    -0x1.54ef2208956p239
  },
  { // Entry 190
    0x1.1483073142e608008f8849daf5f8c58dp2,
    0x1.57e590af09014p0
  },
  { // Entry 191
    -0x1.1483073142e608008f8849daf5f8c58dp2,
    -0x1.57e590af09014p0
  },
  { // Entry 192
    0x1.9972d4021c971563936055d8c1eaae0ap-1,
    0x1.596p-1
  },
  { // Entry 193
    -0x1.9972d4021c971563936055d8c1eaae0ap-1,
    -0x1.596p-1
  },
  { // Entry 194
    -0x1.e501ffd3a68c38336d977f634326a342p-2,
    0x1.5981293783e1fp1
  },
  { // Entry 195
    0x1.e501ffd3a68c38336d977f634326a342p-2,
    -0x1.5981293783e1fp1
  },
  { // Entry 196
    0x1.1604cc3dfc4181c3e9481558467a85fep-1,
    0x1.5bea010p468
  },
  { // Entry 197
    -0x1.1604cc3dfc4181c3e9481558467a85fep-1,
    -0x1.5bea010p468
  },
  { // Entry 198
    -0x1.f76ca50bbbaeb012beade2a328e5fc03p-1,
    0x1.60661c1969666p2
  },
  { // Entry 199
    0x1.f76ca50bbbaeb012beade2a328e5fc03p-1,
    -0x1.60661c1969666p2
  },
  { // Entry 200
    0x1.cd8b73c9430fef75dc710ffdfe091b42p0,
    0x1.62c5a850a142ap59
  },
  { // Entry 201
    -0x1.cd8b73c9430fef75dc710ffdfe091b42p0,
    -0x1.62c5a850a142ap59
  },
  { // Entry 202
    0x1.3accfd453ee67296088378f582eacb02p0,
    0x1.64ef438p142
  },
  { // Entry 203
    -0x1.3accfd453ee67296088378f582eacb02p0,
    -0x1.64ef438p142
  },
  { // Entry 204
    -0x1.acd9302d72de4bd8dda8f5650b77e732p-1,
    0x1.658p2
  },
  { // Entry 205
    0x1.acd9302d72de4bd8dda8f5650b77e732p-1,
    -0x1.658p2
  },
  { // Entry 206
    0x1.f004f875c2e738159c7d75a3980cafd7p-1,
    0x1.6603c65d348d2p5
  },
  { // Entry 207
    -0x1.f004f875c2e738159c7d75a3980cafd7p-1,
    -0x1.6603c65d348d2p5
  },
  { // Entry 208
    0x1.f53496e6d7f7181a62fec4c8a710900ep-1,
    0x1.660e6bf2e092ap5
  },
  { // Entry 209
    -0x1.f53496e6d7f7181a62fec4c8a710900ep-1,
    -0x1.660e6bf2e092ap5
  },
  { // Entry 210
    0x1.b64ee24f0119c800d5d0bb10a39aca4ep-1,
    0x1.6a8p-1
  },
  { // Entry 211
    -0x1.b64ee24f0119c800d5d0bb10a39aca4ep-1,
    -0x1.6a8p-1
  },
  { // Entry 212
    -0x1.d9ba9a7975635a3acc324e6aeda45133p60,
    0x1.6ac5b262ca1ffp849
  },
  { // Entry 213
    0x1.d9ba9a7975635a3acc324e6aeda45133p60,
    -0x1.6ac5b262ca1ffp849
  },
  { // Entry 214
    0x1.b6f557b999e22e0db10a92b908e877f6p-1,
    0x1.6aep-1
  },
  { // Entry 215
    -0x1.b6f557b999e22e0db10a92b908e877f6p-1,
    -0x1.6aep-1
  },
  { // Entry 216
    0x1.c1e1d5c4c0f077fc871d4bd0a03c6431p-1,
    0x1.6cdb36cdb36c9p239
  },
  { // Entry 217
    -0x1.c1e1d5c4c0f077fc871d4bd0a03c6431p-1,
    -0x1.6cdb36cdb36c9p239
  },
  { // Entry 218
    0x1.95bce4f5786978078c310210dced6f3fp-1,
    0x1.6f1af1612270ap6
  },
  { // Entry 219
    -0x1.95bce4f5786978078c310210dced6f3fp-1,
    -0x1.6f1af1612270ap6
  },
  { // Entry 220
    0x1.711e8f5fffba1f599595fbaac5b70e0bp-4,
    0x1.702p-4
  },
  { // Entry 221
    -0x1.711e8f5fffba1f599595fbaac5b70e0bp-4,
    -0x1.702p-4
  },
  { // Entry 222
    0x1.fb5898f29bb257fda6f2bedfc491abaep2,
    0x1.720p0
  },
  { // Entry 223
    -0x1.fb5898f29bb257fda6f2bedfc491abaep2,
    -0x1.720p0
  },
  { // Entry 224
    -0x1.ff9b771284d23290cdd83717cc905773p1,
    0x1.7348c347ddc20p239
  },
  { // Entry 225
    0x1.ff9b771284d23290cdd83717cc905773p1,
    -0x1.7348c347ddc20p239
  },
  { // Entry 226
    0x1.f72d47a0080e2d3d040863d56dbb567ep-2,
    0x1.739ce739ce738p100
  },
  { // Entry 227
    -0x1.f72d47a0080e2d3d040863d56dbb567ep-2,
    -0x1.739ce739ce738p100
  },
  { // Entry 228
    0x1.76441e7f8ea5f8000001d1c5c84f104ep-4,
    0x1.753acc3d3ff35p-4
  },
  { // Entry 229
    -0x1.76441e7f8ea5f8000001d1c5c84f104ep-4,
    -0x1.753acc3d3ff35p-4
  },
  { // Entry 230
    0x1.ce3f642e15af3c921dd7129db5e39342p-1,
    0x1.77fffffffffffp-1
  },
  { // Entry 231
    -0x1.ce3f642e15af3c921dd7129db5e39342p-1,
    -0x1.77fffffffffffp-1
  },
  { // Entry 232
    0x1.f425002a548eb405450970a353d307f7p42,
    0x1.78fdb9effea26p4
  },
  { // Entry 233
    -0x1.f425002a548eb405450970a353d307f7p42,
    -0x1.78fdb9effea26p4
  },
  { // Entry 234
    -0x1.dbc80de7dd042a9371e1b45718e51babp-1,
    0x1.7a5f74607e851p19
  },
  { // Entry 235
    0x1.dbc80de7dd042a9371e1b45718e51babp-1,
    -0x1.7a5f74607e851p19
  },
  { // Entry 236
    0x1.7b3bb3d0b3ca42f13207842899e0ba71p42,
    0x1.7f7ef77e83f1ap19
  },
  { // Entry 237
    -0x1.7b3bb3d0b3ca42f13207842899e0ba71p42,
    -0x1.7f7ef77e83f1ap19
  },
  { // Entry 238
    0x1.e7f05b71cd2d0fb4df6a43375cd8f670p33,
    0x1.7f7f10a07f45ep20
  },
  { // Entry 239
    -0x1.e7f05b71cd2d0fb4df6a43375cd8f670p33,
    -0x1.7f7f10a07f45ep20
  },
  { // Entry 240
    0x1.80000000000038000000000007333333p-25,
    0x1.7ffffffffffffp-25
  },
  { // Entry 241
    -0x1.80000000000038000000000007333333p-25,
    -0x1.7ffffffffffffp-25
  },
  { // Entry 242
    0x1.80000000000068000000000022333333p-25,
    0x1.8000000000002p-25
  },
  { // Entry 243
    -0x1.80000000000068000000000022333333p-25,
    -0x1.8000000000002p-25
  },
  { // Entry 244
    0x1.24245af4cd994e9b3bba992d1016365bp-52,
    0x1.81ae0dffa3b33p959
  },
  { // Entry 245
    -0x1.24245af4cd994e9b3bba992d1016365bp-52,
    -0x1.81ae0dffa3b33p959
  },
  { // Entry 246
    0x1.d72261d98e26b7ffa300d89fd46fb775p-1,
    0x1.846bd7a4dce55p698
  },
  { // Entry 247
    -0x1.d72261d98e26b7ffa300d89fd46fb775p-1,
    -0x1.846bd7a4dce55p698
  },
  { // Entry 248
    0x1.42d8a1ba441ad4028ac7f1a6a5ee0c54p1,
    0x1.8720588p392
  },
  { // Entry 249
    -0x1.42d8a1ba441ad4028ac7f1a6a5ee0c54p1,
    -0x1.8720588p392
  },
  { // Entry 250
    0x1.ea7b444cd798d7faeeff093f1d9971adp-1,
    0x1.8722a67ea14acp-1
  },
  { // Entry 251
    -0x1.ea7b444cd798d7faeeff093f1d9971adp-1,
    -0x1.8722a67ea14acp-1
  },
  { // Entry 252
    -0x1.c7dc7f08dbba089f2d7e890021bedcb7p-1,
    0x1.89936c8828d38p299
  },
  { // Entry 253
    0x1.c7dc7f08dbba089f2d7e890021bedcb7p-1,
    -0x1.89936c8828d38p299
  },
  { // Entry 254
    0x1.569653e319bba800000c83632e43abdep1,
    0x1.8a69106fb9798p6
  },
  { // Entry 255
    -0x1.569653e319bba800000c83632e43abdep1,
    -0x1.8a69106fb9798p6
  },
  { // Entry 256
    0x1.f2db21469f3d5819fa9ba8dccbff914ap-1,
    0x1.8b777e1d2308cp-1
  },
  { // Entry 257
    -0x1.f2db21469f3d5819fa9ba8dccbff914ap-1,
    -0x1.8b777e1d2308cp-1
  },
  { // Entry 258
    0x1.f3688bc2594e20102573cff48190ac28p-1,
    0x1.8bcp-1
  },
  { // Entry 259
    -0x1.f3688bc2594e20102573cff48190ac28p-1,
    -0x1.8bcp-1
  },
  { // Entry 260
    0x1.8d3a2544566df7b559b4ac48e12eac71p-4,
    0x1.8bfd2274d851ap-4
  },
  { // Entry 261
    -0x1.8d3a2544566df7b559b4ac48e12eac71p-4,
    -0x1.8bfd2274d851ap-4
  },
  { // Entry 262
    0x1.f4575cc4e477f019dab5d0103aaf91cfp-1,
    0x1.8c3a450071dd9p-1
  },
  { // Entry 263
    -0x1.f4575cc4e477f019dab5d0103aaf91cfp-1,
    -0x1.8c3a450071dd9p-1
  },
  { // Entry 264
    -0x1.1e09f66c4250b94e9030cadd00851158p11,
    0x1.8cc0dd2b0f4b8p200
  },
  { // Entry 265
    0x1.1e09f66c4250b94e9030cadd00851158p11,
    -0x1.8cc0dd2b0f4b8p200
  },
  { // Entry 266
    0x1.f71496cb921e5a4d2f39046a628b6509p-1,
    0x1.8dap-1
  },
  { // Entry 267
    -0x1.f71496cb921e5a4d2f39046a628b6509p-1,
    -0x1.8dap-1
  },
  { // Entry 268
    0x1.f71b4a6591169819476e6b759c7aae52p-1,
    0x1.8da368da368d8p-1
  },
  { // Entry 269
    -0x1.f71b4a6591169819476e6b759c7aae52p-1,
    -0x1.8da368da368d8p-1
  },
  { // Entry 270
    0x1.ff9b68ccadb2ff62c26864288ed6a4dfp-1,
    0x1.91ed64b977a9ap-1
  },
  { // Entry 271
    -0x1.ff9b68ccadb2ff62c26864288ed6a4dfp-1,
    -0x1.91ed64b977a9ap-1
  },
  { // Entry 272
    0x1.00000000290484779fa491c728aef945p18,
    0x1.921f754442d19p0
  },
  { // Entry 273
    -0x1.00000000290484779fa491c728aef945p18,
    -0x1.921f754442d19p0
  },
  { // Entry 274
    0x1.eef067afd328f311ce2c7a1f420a5983p48,
    0x1.921fb54442d10p0
  },
  { // Entry 275
    -0x1.eef067afd328f311ce2c7a1f420a5983p48,
    -0x1.921fb54442d10p0
  },
  { // Entry 276
    0x1.0000000003af2f223eb1e709cba00ec3p-17,
    0x1.921ff54442d18p1
  },
  { // Entry 277
    -0x1.0000000003af2f223eb1e709cba00ec3p-17,
    -0x1.921ff54442d18p1
  },
  { // Entry 278
    -0x1.b6772cb667dc187b7d019d1d7232c9e7p17,
    0x1.922p0
  },
  { // Entry 279
    0x1.b6772cb667dc187b7d019d1d7232c9e7p17,
    -0x1.922p0
  },
  { // Entry 280
    -0x1.fffffffceeefe791be2074779fd1dd9ep-1,
    0x1.922071c31fc99p20
  },
  { // Entry 281
    0x1.fffffffceeefe791be2074779fd1dd9ep-1,
    -0x1.922071c31fc99p20
  },
  { // Entry 282
    0x1.9d7c1354ba6f781c8b04408094f45284p-3,
    0x1.97fffffffffffp-3
  },
  { // Entry 283
    -0x1.9d7c1354ba6f781c8b04408094f45284p-3,
    -0x1.97fffffffffffp-3
  },
  { // Entry 284
    0x1.9af8877bb45e47ffffe961084b2c0beap-4,
    0x1.999999a10a13cp-4
  },
  { // Entry 285
    -0x1.9af8877bb45e47ffffe961084b2c0beap-4,
    -0x1.999999a10a13cp-4
  },
  { // Entry 286
    -0x1.b6ce128587cd07ffff757abda294c151p4,
    0x1.9b74446ed05dcp0
  },
  { // Entry 287
    0x1.b6ce128587cd07ffff757abda294c151p4,
    -0x1.9b74446ed05dcp0
  },
  { // Entry 288
    0x1.ff65aef54c8fc8042841071b45b6d7d9p-1,
    0x1.9eae494d2b275p4
  },
  { // Entry 289
    -0x1.ff65aef54c8fc8042841071b45b6d7d9p-1,
    -0x1.9eae494d2b275p4
  },
  { // Entry 290
    0x1.61776aa407a437f617fcadb15c7f61c2p-3,
    0x1.a80p1
  },
  { // Entry 291
    -0x1.61776aa407a437f617fcadb15c7f61c2p-3,
    -0x1.a80p1
  },
  { // Entry 292
    0x1.b6001de13ad9580073acba4aa423e2d9p-3,
    0x1.af8p-3
  },
  { // Entry 293
    -0x1.b6001de13ad9580073acba4aa423e2d9p-3,
    -0x1.af8p-3
  },
  { // Entry 294
    0x1.b5a0503ae354b7a16f7c50f8b3bef2cap-4,
    0x1.b3f8ea7b1f91bp-4
  },
  { // Entry 295
    -0x1.b5a0503ae354b7a16f7c50f8b3bef2cap-4,
    -0x1.b3f8ea7b1f91bp-4
  },
  { // Entry 296
    0x1.b5a0503ae4c7b792537327f4245ac6fbp-4,
    0x1.b3f8ea7b21008p-4
  },
  { // Entry 297
    -0x1.b5a0503ae4c7b792537327f4245ac6fbp-4,
    -0x1.b3f8ea7b21008p-4
  },
  { // Entry 298
    0x1.057584c429b3a6ea0a65caff98634490p59,
    0x1.b951f1572eba5p23
  },
  { // Entry 299
    -0x1.057584c429b3a6ea0a65caff98634490p59,
    -0x1.b951f1572eba5p23
  },
  { // Entry 300
    -0x1.9a282fa1ff7d98039be3bf5b39cc6d89p2,
    0x1.b9cp0
  },
  { // Entry 301
    0x1.9a282fa1ff7d98039be3bf5b39cc6d89p2,
    -0x1.b9cp0
  },
  { // Entry 302
    -0x1.027d184afb1984ca1d21b1ac93111887p-52,
    0x1.bab62ed655019p970
  },
  { // Entry 303
    0x1.027d184afb1984ca1d21b1ac93111887p-52,
    -0x1.bab62ed655019p970
  },
  { // Entry 304
    0x1.ca6efdf845d6c7fffebaea1afbf7e961p2,
    0x1.bea1b35f3cb6dp84
  },
  { // Entry 305
    -0x1.ca6efdf845d6c7fffebaea1afbf7e961p2,
    -0x1.bea1b35f3cb6dp84
  },
  { // Entry 306
    0x1.fd87b34747b746b8b657cac797c0870dp42,
    0x1.c463abeccb27bp3
  },
  { // Entry 307
    -0x1.fd87b34747b746b8b657cac797c0870dp42,
    -0x1.c463abeccb27bp3
  },
  { // Entry 308
    0x1.ffffffffffffb094541a2461e734daeep-1,
    0x1.c463abeccb2bbp2
  },
  { // Entry 309
    -0x1.ffffffffffffb094541a2461e734daeep-1,
    -0x1.c463abeccb2bbp2
  },
  { // Entry 310
    0x1.fb057029acfd17fffffa5ac8204f0803p-1,
    0x1.c6cbe26b7b45fp86
  },
  { // Entry 311
    -0x1.fb057029acfd17fffffa5ac8204f0803p-1,
    -0x1.c6cbe26b7b45fp86
  },
  { // Entry 312
    0x1.c8d5a08be40c20p-117,
    0x1.c8d5a08be40c2p-117
  },
  { // Entry 313
    -0x1.c8d5a08be40c20p-117,
    -0x1.c8d5a08be40c2p-117
  },
  { // Entry 314
    0x1.e5dffd7f06cb3754933cea578deaad36p-2,
    0x1.cad4e9827a2bep1
  },
  { // Entry 315
    -0x1.e5dffd7f06cb3754933cea578deaad36p-2,
    -0x1.cad4e9827a2bep1
  },
  { // Entry 316
    0x1.e6be378b1b4eb7658e85ad0af33836a9p-2,
    0x1.caeb940e4b997p1
  },
  { // Entry 317
    -0x1.e6be378b1b4eb7658e85ad0af33836a9p-2,
    -0x1.caeb940e4b997p1
  },
  { // Entry 318
    0x1.e72bd025a1fd5765f853469a85ae7b7dp-2,
    0x1.caf6c04ecd034p1
  },
  { // Entry 319
    -0x1.e72bd025a1fd5765f853469a85ae7b7dp-2,
    -0x1.caf6c04ecd034p1
  },
  { // Entry 320
    0x1.e844b3d7cbe4375c28e322da6ba5d7d8p-2,
    0x1.cb135ec1c956ep1
  },
  { // Entry 321
    -0x1.e844b3d7cbe4375c28e322da6ba5d7d8p-2,
    -0x1.cb135ec1c956ep1
  },
  { // Entry 322
    0x1.dd38a1f1d289b6173115721bc5c1fc72p-54,
    0x1.cb44e86bc192bp648
  },
  { // Entry 323
    -0x1.dd38a1f1d289b6173115721bc5c1fc72p-54,
    -0x1.cb44e86bc192bp648
  },
  { // Entry 324
    0x1.dd38a1f1d289b6173115721bc629a23dp-53,
    0x1.cb44e86bc192bp649
  },
  { // Entry 325
    -0x1.dd38a1f1d289b6173115721bc629a23dp-53,
    -0x1.cb44e86bc192bp649
  },
  { // Entry 326
    -0x1.fff6e755320ed78db4d6eff4bf6a6b10p1,
    0x1.cb61afedb2b3cp119
  },
  { // Entry 327
    0x1.fff6e755320ed78db4d6eff4bf6a6b10p1,
    -0x1.cb61afedb2b3cp119
  },
  { // Entry 328
    0x1.ccdf4aa6c228f8041be91a142e0e271bp-7,
    0x1.ccd7834ba3804p-7
  },
  { // Entry 329
    -0x1.ccdf4aa6c228f8041be91a142e0e271bp-7,
    -0x1.ccd7834ba3804p-7
  },
  { // Entry 330
    0x1.cee50016fc2d8837286bf6fd431a7b3bp-4,
    0x1.ccf0599da478ep-4
  },
  { // Entry 331
    -0x1.cee50016fc2d8837286bf6fd431a7b3bp-4,
    -0x1.ccf0599da478ep-4
  },
  { // Entry 332
    0x1.44cf3ee8a75a87cc6657e62f94a93e6fp0,
    0x1.ce8p-1
  },
  { // Entry 333
    -0x1.44cf3ee8a75a87cc6657e62f94a93e6fp0,
    -0x1.ce8p-1
  },
  { // Entry 334
    0x1.45aa12ff98152800001fbd8799a96a2cp0,
    0x1.cf276c9cb9af0p-1
  },
  { // Entry 335
    -0x1.45aa12ff98152800001fbd8799a96a2cp0,
    -0x1.cf276c9cb9af0p-1
  },
  { // Entry 336
    0x1.f9bc744f61e0ed853829e2f765b8a12cp-4,
    0x1.d2e979148a458p61
  },
  { // Entry 337
    -0x1.f9bc744f61e0ed853829e2f765b8a12cp-4,
    -0x1.d2e979148a458p61
  },
  { // Entry 338
    0x1.6e70f9edbd1a082ae6f90c62ef4f31ddp-2,
    0x1.d6b5ad6b5ab68p100
  },
  { // Entry 339
    -0x1.6e70f9edbd1a082ae6f90c62ef4f31ddp-2,
    -0x1.d6b5ad6b5ab68p100
  },
  { // Entry 340
    0x1.13e9c6a348e4a7bede82724505269f68p2,
    0x1.d96e058p488
  },
  { // Entry 341
    -0x1.13e9c6a348e4a7bede82724505269f68p2,
    -0x1.d96e058p488
  },
  { // Entry 342
    -0x1.d355463c2303582fa31a3238dcbe560ep-5,
    0x1.dd10f25171bc9p5
  },
  { // Entry 343
    0x1.d355463c2303582fa31a3238dcbe560ep-5,
    -0x1.dd10f25171bc9p5
  },
  { // Entry 344
    0x1.ddf21ebf6fc927fffffbb3ecc0cff66ep-6,
    0x1.ddcf6e56696a4p-6
  },
  { // Entry 345
    -0x1.ddf21ebf6fc927fffffbb3ecc0cff66ep-6,
    -0x1.ddcf6e56696a4p-6
  },
  { // Entry 346
    0x1.5cb0bfc1558007e0c5d095f729e3427bp0,
    0x1.ep-1
  },
  { // Entry 347
    -0x1.5cb0bfc1558007e0c5d095f729e3427bp0,
    -0x1.ep-1
  },
  { // Entry 348
    -0x1.97b5e8ae9a21c7f4821922bc5b3782ccp1,
    0x1.ep0
  },
  { // Entry 349
    0x1.97b5e8ae9a21c7f4821922bc5b3782ccp1,
    -0x1.ep0
  },
  { // Entry 350
    -0x1.f8bf68d0c23f3741efb8bd99853bae8ap0,
    0x1.e779de779de71p118
  },
  { // Entry 351
    0x1.f8bf68d0c23f3741efb8bd99853bae8ap0,
    -0x1.e779de779de71p118
  },
  { // Entry 352
    -0x1.fffffffffd71cf934ef3e5df4008665fp-1,
    0x1.eb0567bed1f71p12
  },
  { // Entry 353
    0x1.fffffffffd71cf934ef3e5df4008665fp-1,
    -0x1.eb0567bed1f71p12
  },
  { // Entry 354
    0x1.ee788d1cc7954841878473aa5d2615a5p-4,
    0x1.ec16f30a34fbcp-4
  },
  { // Entry 355
    -0x1.ee788d1cc7954841878473aa5d2615a5p-4,
    -0x1.ec16f30a34fbcp-4
  },
  { // Entry 356
    0x1.efdad938b4b0e834014bf56a7084675dp-4,
    0x1.ed7424ba2aa4ep-4
  },
  { // Entry 357
    -0x1.efdad938b4b0e834014bf56a7084675dp-4,
    -0x1.ed7424ba2aa4ep-4
  },
  { // Entry 358
    0x1.da347607948f47ffef21697161fd3cddp-1,
    0x1.ee9eda5890390p499
  },
  { // Entry 359
    -0x1.da347607948f47ffef21697161fd3cddp-1,
    -0x1.ee9eda5890390p499
  },
  { // Entry 360
    0x1.f682d27a8be87f783d494857b6f30e05p0,
    0x1.f4ff0d7b3ac10p100
  },
  { // Entry 361
    -0x1.f682d27a8be87f783d494857b6f30e05p0,
    -0x1.f4ff0d7b3ac10p100
  },
  { // Entry 362
    -0x1.ffd36a753ced9027c93845adde046246p-1,
    0x1.f5a814afd69f5p119
  },
  { // Entry 363
    0x1.ffd36a753ced9027c93845adde046246p-1,
    -0x1.f5a814afd69f5p119
  },
  { // Entry 364
    -0x1.0fa7701d059b51de05df58ade26bec5cp-9,
    0x1.f8fc824d2693bp61
  },
  { // Entry 365
    0x1.0fa7701d059b51de05df58ade26bec5cp-9,
    -0x1.f8fc824d2693bp61
  },
  { // Entry 366
    -0x1.afe3875bd3afe801f149d0a9ad36f453p-4,
    0x1.f9be6f9be6f98p9
  },
  { // Entry 367
    0x1.afe3875bd3afe801f149d0a9ad36f453p-4,
    -0x1.f9be6f9be6f98p9
  },
  { // Entry 368
    0x1.fd1032e82deab7baba99c913dee10b9ap-4,
    0x1.fa775cd264f43p-4
  },
  { // Entry 369
    -0x1.fd1032e82deab7baba99c913dee10b9ap-4,
    -0x1.fa775cd264f43p-4
  },
  { // Entry 370
    0x1.fea8c67dd46ca83ca49ab9ecd0360739p-4,
    0x1.fc09b47402d82p-4
  },
  { // Entry 371
    -0x1.fea8c67dd46ca83ca49ab9ecd0360739p-4,
    -0x1.fc09b47402d82p-4
  },
  { // Entry 372
    -0x1.9020caf18a87438127a85d1f0a3d4205p-1,
    0x1.feeffffffffc6p995
  },
  { // Entry 373
    0x1.9020caf18a87438127a85d1f0a3d4205p-1,
    -0x1.feeffffffffc6p995
  },
  { // Entry 374
    0x1.af135beb0f2817fba77204a5b1b6766bp0,
    0x1.ff01fffffffffp7
  },
  { // Entry 375
    -0x1.af135beb0f2817fba77204a5b1b6766bp0,
    -0x1.ff01fffffffffp7
  },
  { // Entry 376
    -0x1.fd97532efd89b26bc294b27e0a1956b9p3,
    0x1.ff8ffffffffffp540
  },
  { // Entry 377
    0x1.fd97532efd89b26bc294b27e0a1956b9p3,
    -0x1.ff8ffffffffffp540
  },
  { // Entry 378
    -0x1.cc32cb933818111e6ddf00c5c79cbc88p-1,
    0x1.ff8ffffffffffp870
  },
  { // Entry 379
    0x1.cc32cb933818111e6ddf00c5c79cbc88p-1,
    -0x1.ff8ffffffffffp870
  },
  { // Entry 380
    -0x1.8659d3e2b52b880668ac8b4b9fae9538p-1,
    0x1.ffc10p9
  },
  { // Entry 381
    0x1.8659d3e2b52b880668ac8b4b9fae9538p-1,
    -0x1.ffc10p9
  },
  { // Entry 382
    -0x1.b66066fb812ee27dbb623a1a1353e062p-2,
    0x1.ffcfff8p19
  },
  { // Entry 383
    0x1.b66066fb812ee27dbb623a1a1353e062p-2,
    -0x1.ffcfff8p19
  },
  { // Entry 384
    -0x1.520ebd32e1d8ecd38bfcd6a57e1a377fp1,
    0x1.ffcfff8p365
  },
  { // Entry 385
    0x1.520ebd32e1d8ecd38bfcd6a57e1a377fp1,
    -0x1.ffcfff8p365
  },
  { // Entry 386
    0x1.489813c24d13b00ab69627d858bb63b5p0,
    0x1.ffcffffffff6cp720
  },
  { // Entry 387
    -0x1.489813c24d13b00ab69627d858bb63b5p0,
    -0x1.ffcffffffff6cp720
  },
  { // Entry 388
    0x1.413e63f7dd607ef3c8422a490af2dc30p0,
    0x1.ffcfffffffff9p320
  },
  { // Entry 389
    -0x1.413e63f7dd607ef3c8422a490af2dc30p0,
    -0x1.ffcfffffffff9p320
  },
  { // Entry 390
    -0x1.fc3928a39b65284d4c7ef3b6a2edc8f1p-2,
    0x1.ffcffffffffffp990
  },
  { // Entry 391
    0x1.fc3928a39b65284d4c7ef3b6a2edc8f1p-2,
    -0x1.ffcffffffffffp990
  },
  { // Entry 392
    -0x1.9ad70d284f16d59dcaa0ab9fb77d7490p-1,
    0x1.ffeffffffffccp995
  },
  { // Entry 393
    0x1.9ad70d284f16d59dcaa0ab9fb77d7490p-1,
    -0x1.ffeffffffffccp995
  },
  { // Entry 394
    0x1.aad6effcb6783826de7b24dba501c11cp-3,
    0x1.ffefffffffffdp366
  },
  { // Entry 395
    -0x1.aad6effcb6783826de7b24dba501c11cp-3,
    -0x1.ffefffffffffdp366
  },
  { // Entry 396
    0x1.c88645f9d119ec2030724a4ce4e6ebbap2,
    0x1.ffeffffffffffp180
  },
  { // Entry 397
    -0x1.c88645f9d119ec2030724a4ce4e6ebbap2,
    -0x1.ffeffffffffffp180
  },
  { // Entry 398
    0x1.131aa7b9d4aa07ff5840ac1e8fb42360p2,
    0x1.ffeffffffffffp231
  },
  { // Entry 399
    -0x1.131aa7b9d4aa07ff5840ac1e8fb42360p2,
    -0x1.ffeffffffffffp231
  },
  { // Entry 400
    0x1.f671719be50d1d4debe85c922e1e2913p-3,
    0x1.ffeffffffffffp1019
  },
  { // Entry 401
    -0x1.f671719be50d1d4debe85c922e1e2913p-3,
    -0x1.ffeffffffffffp1019
  },
  { // Entry 402
    0x1.ff078a2d2d871ac1f32765e9db644eb1p-1,
    0x1.fff1fffffffffp40
  },
  { // Entry 403
    -0x1.ff078a2d2d871ac1f32765e9db644eb1p-1,
    -0x1.fff1fffffffffp40
  },
  { // Entry 404
    0x1.0784b04fc42a59e77f85d9967da6775dp9,
    0x1.fff1fffffffffp41
  },
  { // Entry 405
    -0x1.0784b04fc42a59e77f85d9967da6775dp9,
    -0x1.fff1fffffffffp41
  },
  { // Entry 406
    0x1.8eb22dd167a37ad21ddf1e69734e9ce2p0,
    0x1.fffff1fffffffp-1
  },
  { // Entry 407
    -0x1.8eb22dd167a37ad21ddf1e69734e9ce2p0,
    -0x1.fffff1fffffffp-1
  },
  { // Entry 408
    -0x1.22e7346fd3dda553b146c37f61127a4cp1,
    0x1.ffffff8p119
  },
  { // Entry 409
    0x1.22e7346fd3dda553b146c37f61127a4cp1,
    -0x1.ffffff8p119
  },
  { // Entry 410
    -0x1.db0b3b019f175bed5bcf1a5602db00afp-3,
    0x1.ffffff8p192
  },
  { // Entry 411
    0x1.db0b3b019f175bed5bcf1a5602db00afp-3,
    -0x1.ffffff8p192
  },
  { // Entry 412
    0x1.06b6bede910257f315a5083a9ab2b650p-1,
    0x1.ffffff8p543
  },
  { // Entry 413
    -0x1.06b6bede910257f315a5083a9ab2b650p-1,
    -0x1.ffffff8p543
  },
  { // Entry 414
    -0x1.40f02a15dfa3d7ff3e2a4553f19cb2d0p1,
    0x1.ffffffffbbfffp40
  },
  { // Entry 415
    0x1.40f02a15dfa3d7ff3e2a4553f19cb2d0p1,
    -0x1.ffffffffbbfffp40
  },
  { // Entry 416
    0x1.ab60112ef4fddff3f5a2690c7d3ea6efp-2,
    0x1.fffffffff7fffp231
  },
  { // Entry 417
    -0x1.ab60112ef4fddff3f5a2690c7d3ea6efp-2,
    -0x1.fffffffff7fffp231
  },
  { // Entry 418
    0x1.35a9929eeafd70f0712abe2a511854a1p0,
    0x1.fffffffffff78p920
  },
  { // Entry 419
    -0x1.35a9929eeafd70f0712abe2a511854a1p0,
    -0x1.fffffffffff78p920
  },
  { // Entry 420
    0x1.4630298f3b993287205dc0b89b0601e0p0,
    0x1.fffffffffffd5p995
  },
  { // Entry 421
    -0x1.4630298f3b993287205dc0b89b0601e0p0,
    -0x1.fffffffffffd5p995
  },
  { // Entry 422
    -0x1.9472e045129fdba63791712416ec9613p-1,
    0x1.fffffffffffe8p720
  },
  { // Entry 423
    0x1.9472e045129fdba63791712416ec9613p-1,
    -0x1.fffffffffffe8p720
  },
  { // Entry 424
    0x1.42e586daa1b428fc0580888f2fc46893p0,
    0x1.fffffffffffebp920
  },
  { // Entry 425
    -0x1.42e586daa1b428fc0580888f2fc46893p0,
    -0x1.fffffffffffebp920
  },
  { // Entry 426
    -0x1.bfc436b94374b5f16b60ea69cd883992p-1,
    0x1.ffffffffffff1p245
  },
  { // Entry 427
    0x1.bfc436b94374b5f16b60ea69cd883992p-1,
    -0x1.ffffffffffff1p245
  },
  { // Entry 428
    0x1.35117d4a4f1e4bb22fdd03164a364ccfp0,
    0x1.ffffffffffff4p845
  },
  { // Entry 429
    -0x1.35117d4a4f1e4bb22fdd03164a364ccfp0,
    -0x1.ffffffffffff4p845
  },
  { // Entry 430
    -0x1.bfdd9292798aaa789c3df0df7729835ap-1,
    0x1.ffffffffffff4p1020
  },
  { // Entry 431
    0x1.bfdd9292798aaa789c3df0df7729835ap-1,
    -0x1.ffffffffffff4p1020
  },
  { // Entry 432
    -0x1.9b768ccdae6ebb70b45ac14e92b3d5c8p9,
    0x1.ffffffffffffcp45
  },
  { // Entry 433
    0x1.9b768ccdae6ebb70b45ac14e92b3d5c8p9,
    -0x1.ffffffffffffcp45
  },
  { // Entry 434
    0x1.feca047f2730f7395d95f469ccb5a5d3p-1,
    0x1.ffffffffffffcp474
  },
  { // Entry 435
    -0x1.feca047f2730f7395d95f469ccb5a5d3p-1,
    -0x1.ffffffffffffcp474
  },
  { // Entry 436
    -0x1.449f15cc945597ff58f2426acbff9c62p-2,
    0x1.ffffffffffffcp976
  },
  { // Entry 437
    0x1.449f15cc945597ff58f2426acbff9c62p-2,
    -0x1.ffffffffffffcp976
  },
  { // Entry 438
    0x1.fffc58da07951cbe22c96d73b1289e1ep-2,
    0x1.ffffffffffffep881
  },
  { // Entry 439
    -0x1.fffc58da07951cbe22c96d73b1289e1ep-2,
    -0x1.ffffffffffffep881
  },
  { // Entry 440
    -0x1.c1c9195ec23aa64df145dd269cd895e8p-1,
    0x1.ffffffffffffep970
  },
  { // Entry 441
    0x1.c1c9195ec23aa64df145dd269cd895e8p-1,
    -0x1.ffffffffffffep970
  },
  { // Entry 442
    0x1.3cc1ed3906d2f7fdd633cf4eb06f3f19p-2,
    0x1.33328c1b37321p-2
  },
  { // Entry 443
    -0x1.3cc1ed3906d2f7fdd633cf4eb06f3f19p-2,
    -0x1.33328c1b37321p-2
  },
  { // Entry 444
    -0x1.p-1074,
    -0x1.0p-1074
  },
  { // Entry 445
    0x1.p-1074,
    0x1.0p-1074
  },
  { // Entry 446
    -0.0,
    -0.0
  },
  { // Entry 447
    0x1.p-1074,
    0x1.0p-1074
  },
  { // Entry 448
    -0x1.p-1074,
    -0x1.0p-1074
  },
  { // Entry 449
    -0x1.00000000000010p-1022,
    -0x1.0000000000001p-1022
  },
  { // Entry 450
    0x1.00000000000010p-1022,
    0x1.0000000000001p-1022
  },
  { // Entry 451
    -0x1.p-1022,
    -0x1.0p-1022
  },
  { // Entry 452
    0x1.p-1022,
    0x1.0p-1022
  },
  { // Entry 453
    -0x1.ffffffffffffe0p-1023,
    -0x1.ffffffffffffep-1023
  },
  { // Entry 454
    0x1.ffffffffffffe0p-1023,
    0x1.ffffffffffffep-1023
  },
  { // Entry 455
    0x1.ffffffffffffe0p-1023,
    0x1.ffffffffffffep-1023
  },
  { // Entry 456
    -0x1.ffffffffffffe0p-1023,
    -0x1.ffffffffffffep-1023
  },
  { // Entry 457
    0x1.p-1022,
    0x1.0p-1022
  },
  { // Entry 458
    -0x1.p-1022,
    -0x1.0p-1022
  },
  { // Entry 459
    0x1.00000000000010p-1022,
    0x1.0000000000001p-1022
  },
  { // Entry 460
    -0x1.00000000000010p-1022,
    -0x1.0000000000001p-1022
  },
  { // Entry 461
    0x1.999999f0fb38c6122a1fa8e043bb07c2p-13,
    0x1.999999999999ap-13
  },
  { // Entry 462
    -0x1.999999f0fb38c6122a1fa8e043bb07c2p-13,
    -0x1.999999999999ap-13
  },
  { // Entry 463
    0x1.99999af7201744b823e5b270fd1aa39dp-12,
    0x1.999999999999ap-12
  },
  { // Entry 464
    -0x1.99999af7201744b823e5b270fd1aa39dp-12,
    -0x1.999999999999ap-12
  },
  { // Entry 465
    0x1.33333581062a38f04df024142ddaa05dp-11,
    0x1.3333333333334p-11
  },
  { // Entry 466
    -0x1.33333581062a38f04df024142ddaa05dp-11,
    -0x1.3333333333334p-11
  },
  { // Entry 467
    0x1.99999f0fb3a0f9d88738be2ff7af9aaap-11,
    0x1.999999999999ap-11
  },
  { // Entry 468
    -0x1.99999f0fb3a0f9d88738be2ff7af9aaap-11,
    -0x1.999999999999ap-11
  },
  { // Entry 469
    0x1.000005555577777854854dedc28ead51p-10,
    0x1.0p-10
  },
  { // Entry 470
    -0x1.000005555577777854854dedc28ead51p-10,
    -0x1.0p-10
  },
  { // Entry 471
    0x1.33333c6a7f4ec73853151cd76b79e135p-10,
    0x1.3333333333333p-10
  },
  { // Entry 472
    -0x1.33333c6a7f4ec73853151cd76b79e135p-10,
    -0x1.3333333333333p-10
  },
  { // Entry 473
    0x1.66667508e0a1b502287034d36bf4e3d5p-10,
    0x1.6666666666666p-10
  },
  { // Entry 474
    -0x1.66667508e0a1b502287034d36bf4e3d5p-10,
    -0x1.6666666666666p-10
  },
  { // Entry 475
    0x1.9999af7202c366f1e0b548a31c41d210p-10,
    0x1.9999999999999p-10
  },
  { // Entry 476
    -0x1.9999af7202c366f1e0b548a31c41d210p-10,
    -0x1.9999999999999p-10
  },
  { // Entry 477
    0x1.ccccebe76f102ff633c5f02a34076687p-10,
    0x1.cccccccccccccp-10
  },
  { // Entry 478
    -0x1.ccccebe76f102ff633c5f02a34076687p-10,
    -0x1.cccccccccccccp-10
  },
  { // Entry 479
    0x1.0667d5fcf3d078f940687eb974310fb9p-7,
    0x1.0666666666666p-7
  },
  { // Entry 480
    -0x1.0667d5fcf3d078f940687eb974310fb9p-7,
    -0x1.0666666666666p-7
  },
  { // Entry 481
    0x1.ccd4939d0ccd7646b3f81b7553675c23p-7,
    0x1.cccccccccccccp-7
  },
  { // Entry 482
    -0x1.ccd4939d0ccd7646b3f81b7553675c23p-7,
    -0x1.cccccccccccccp-7
  },
  { // Entry 483
    0x1.49a4fc02ad193e8e94c4b2429190b5b2p-6,
    0x1.4999999999999p-6
  },
  { // Entry 484
    -0x1.49a4fc02ad193e8e94c4b2429190b5b2p-6,
    -0x1.4999999999999p-6
  },
  { // Entry 485
    0x1.ace5ded5f6be698f56697ac761f3dc69p-6,
    0x1.accccccccccccp-6
  },
  { // Entry 486
    -0x1.ace5ded5f6be698f56697ac761f3dc69p-6,
    -0x1.accccccccccccp-6
  },
  { // Entry 487
    0x1.081767fd3cb685f7b069146ce3333851p-5,
    0x1.080p-5
  },
  { // Entry 488
    -0x1.081767fd3cb685f7b069146ce3333851p-5,
    -0x1.080p-5
  },
  { // Entry 489
    0x1.39c0d6dea66fb6d286d403c292527356p-5,
    0x1.399999999999ap-5
  },
  { // Entry 490
    -0x1.39c0d6dea66fb6d286d403c292527356p-5,
    -0x1.399999999999ap-5
  },
  { // Entry 491
    0x1.6b702b954bc1d583c4a46773c2c2a15dp-5,
    0x1.6b33333333334p-5
  },
  { // Entry 492
    -0x1.6b702b954bc1d583c4a46773c2c2a15dp-5,
    -0x1.6b33333333334p-5
  },
  { // Entry 493
    0x1.9d265618dd0c688e049c61090d3e3fe2p-5,
    0x1.9cccccccccccep-5
  },
  { // Entry 494
    -0x1.9d265618dd0c688e049c61090d3e3fe2p-5,
    -0x1.9cccccccccccep-5
  },
  { // Entry 495
    0x1.cee446e4cfd4be6900f4b906ca9725b1p-5,
    0x1.ce66666666666p-5
  },
  { // Entry 496
    -0x1.cee446e4cfd4be6900f4b906ca9725b1p-5,
    -0x1.ce66666666666p-5
  },
  { // Entry 497
    0x1.a1eaedd5a4313e9d08bc7bb17a22531fp-1,
    0x1.5e7fc4369bdadp-1
  },
  { // Entry 498
    -0x1.a1eaedd5a4313e9d08bc7bb17a22531fp-1,
    -0x1.5e7fc4369bdadp-1
  },
  { // Entry 499
    0x1.d93b8aad424de0e43fb04d6781be81a3p1,
    0x1.4e7fc4369bdadp0
  },
  { // Entry 500
    -0x1.d93b8aad424de0e43fb04d6781be81a3p1,
    -0x1.4e7fc4369bdadp0
  },
  { // Entry 501
    -0x1.563acf158c2eb678d71be31e0f34754dp1,
    0x1.edbfa651e9c84p0
  },
  { // Entry 502
    0x1.563acf158c2eb678d71be31e0f34754dp1,
    -0x1.edbfa651e9c84p0
  },
  { // Entry 503
    -0x1.576b77609f0890313c371a0a2c582145p-1,
    0x1.467fc4369bdadp1
  },
  { // Entry 504
    0x1.576b77609f0890313c371a0a2c582145p-1,
    -0x1.467fc4369bdadp1
  },
  { // Entry 505
    0x1.00155777aebf6ad41b39a808ed5c3384p-5,
    0x1.961fb54442d18p1
  },
  { // Entry 506
    -0x1.00155777aebf6ad41b39a808ed5c3384p-5,
    -0x1.961fb54442d18p1
  },
  { // Entry 507
    0x1.87e9966e7d22d348fec6c95f851775f4p-1,
    0x1.e5bfa651e9c83p1
  },
  { // Entry 508
    -0x1.87e9966e7d22d348fec6c95f851775f4p-1,
    -0x1.e5bfa651e9c83p1
  },
  { // Entry 509
    0x1.a49e7d8987850f9ca5b9332e39dcd88fp1,
    0x1.1aafcbafc85f7p2
  },
  { // Entry 510
    -0x1.a49e7d8987850f9ca5b9332e39dcd88fp1,
    -0x1.1aafcbafc85f7p2
  },
  { // Entry 511
    -0x1.79ced8156d040edde5a6ab62255e2261p1,
    0x1.427fc4369bdadp2
  },
  { // Entry 512
    0x1.79ced8156d040edde5a6ab62255e2261p1,
    -0x1.427fc4369bdadp2
  },
  { // Entry 513
    -0x1.6f1f65cd1e91b5e5ec1e120e9e0ddc0ap-1,
    0x1.6a4fbcbd6f562p2
  },
  { // Entry 514
    0x1.6f1f65cd1e91b5e5ec1e120e9e0ddc0ap-1,
    -0x1.6a4fbcbd6f562p2
  },
  { // Entry 515
    -0x1.67747d5f844e1b0c503d51e7ba032ffcp-1,
    0x1.6af2eff0a2896p2
  },
  { // Entry 516
    0x1.67747d5f844e1b0c503d51e7ba032ffcp-1,
    -0x1.6af2eff0a2896p2
  },
  { // Entry 517
    -0x1.626a258815d1823506d17069130eb9fbp1,
    0x1.43c62a9d02414p2
  },
  { // Entry 518
    0x1.626a258815d1823506d17069130eb9fbp1,
    -0x1.43c62a9d02414p2
  },
  { // Entry 519
    0x1.d6adaf80f8b051fbc7ab9f2e09e8e608p1,
    0x1.1c99654961f92p2
  },
  { // Entry 520
    -0x1.d6adaf80f8b051fbc7ab9f2e09e8e608p1,
    -0x1.1c99654961f92p2
  },
  { // Entry 521
    0x1.a94d1b21370d52bfcd9ec417e41d6e5bp-1,
    0x1.ead93feb8361fp1
  },
  { // Entry 522
    -0x1.a94d1b21370d52bfcd9ec417e41d6e5bp-1,
    -0x1.ead93feb8361fp1
  },
  { // Entry 523
    0x1.4cba9e78222340ca493f803bbc947659p-4,
    0x1.9c7fb54442d1ap1
  },
  { // Entry 524
    -0x1.4cba9e78222340ca493f803bbc947659p-4,
    -0x1.9c7fb54442d1ap1
  },
  { // Entry 525
    -0x1.2cb6d02634531a6839bf898cc1f918dep-1,
    0x1.4e262a9d02415p1
  },
  { // Entry 526
    0x1.2cb6d02634531a6839bf898cc1f918dep-1,
    -0x1.4e262a9d02415p1
  },
  { // Entry 527
    -0x1.18d9112308d5b897ba44cfc5c4437317p1,
    0x1.ff993feb83620p0
  },
  { // Entry 528
    0x1.18d9112308d5b897ba44cfc5c4437317p1,
    -0x1.ff993feb83620p0
  },
  { // Entry 529
    0x1.56fe0145cf2901975829ddc3fc786df0p2,
    0x1.62e62a9d02416p0
  },
  { // Entry 530
    -0x1.56fe0145cf2901975829ddc3fc786df0p2,
    -0x1.62e62a9d02416p0
  },
  { // Entry 531
    0x1.f4ad353aca453f62beae01cd5b13d50dp-1,
    0x1.8c662a9d02419p-1
  },
  { // Entry 532
    -0x1.f4ad353aca453f62beae01cd5b13d50dp-1,
    -0x1.8c662a9d02419p-1
  },
  { // Entry 533
    0x1.6a7e1f6407ee61397d016d691bb61d17p3,
    -0x1.a8aa1d11c44ffp0
  },
  { // Entry 534
    -0x1.6a7e1f6407ee61397d016d691bb61d17p3,
    0x1.a8aa1d11c44ffp0
  },
  { // Entry 535
    0x1.0d718cfc82464536bfd621be419f007cp6,
    -0x1.95ec8b9e03d54p0
  },
  { // Entry 536
    -0x1.0d718cfc82464536bfd621be419f007cp6,
    0x1.95ec8b9e03d54p0
  },
  { // Entry 537
    -0x1.11d87146c2d5a1832c24f3d87052d7ebp4,
    -0x1.832efa2a435a9p0
  },
  { // Entry 538
    0x1.11d87146c2d5a1832c24f3d87052d7ebp4,
    0x1.832efa2a435a9p0
  },
  { // Entry 539
    -0x1.e3a3729b3e86e2221fa5f04abf699e6ep2,
    -0x1.707168b682dfep0
  },
  { // Entry 540
    0x1.e3a3729b3e86e2221fa5f04abf699e6ep2,
    0x1.707168b682dfep0
  },
  { // Entry 541
    -0x1.3429e61a5d1f2e80fbd1370d4a7c2b10p2,
    -0x1.5db3d742c2653p0
  },
  { // Entry 542
    0x1.3429e61a5d1f2e80fbd1370d4a7c2b10p2,
    0x1.5db3d742c2653p0
  },
  { // Entry 543
    -0x1.c08caec5cf99725e57c32766fb084c5fp1,
    -0x1.4af645cf01ea8p0
  },
  { // Entry 544
    0x1.c08caec5cf99725e57c32766fb084c5fp1,
    0x1.4af645cf01ea8p0
  },
  { // Entry 545
    -0x1.5d603d751767ee70e9a2ff54959fa4a7p1,
    -0x1.3838b45b416fdp0
  },
  { // Entry 546
    0x1.5d603d751767ee70e9a2ff54959fa4a7p1,
    0x1.3838b45b416fdp0
  },
  { // Entry 547
    -0x1.1b48a35b1b277effabd7278b525708edp1,
    -0x1.257b22e780f52p0
  },
  { // Entry 548
    0x1.1b48a35b1b277effabd7278b525708edp1,
    0x1.257b22e780f52p0
  },
  { // Entry 549
    -0x1.d74caf9912dc7d9669b00926aa1ade11p0,
    -0x1.12bd9173c07abp0
  },
  { // Entry 550
    0x1.d74caf9912dc7d9669b00926aa1ade11p0,
    0x1.12bd9173c07abp0
  },
  { // Entry 551
    -0x1.6be702e1f6cd60bfd86ad86180d18490p0,
    -0x1.ea5c3ed5b3850p-1
  },
  { // Entry 552
    0x1.6be702e1f6cd60bfd86ad86180d18490p0,
    0x1.ea5c3ed5b3850p-1
  },
  { // Entry 553
    -0x1.4d0df1fc1d3484b027537d8117a395f4p0,
    -0x1.d4b87dab670a0p-1
  },
  { // Entry 554
    0x1.4d0df1fc1d3484b027537d8117a395f4p0,
    0x1.d4b87dab670a0p-1
  },
  { // Entry 555
    -0x1.316c8b068a7af257f1e5a51943834f3ep0,
    -0x1.bf14bc811a8f0p-1
  },
  { // Entry 556
    0x1.316c8b068a7af257f1e5a51943834f3ep0,
    0x1.bf14bc811a8f0p-1
  },
  { // Entry 557
    -0x1.1872a1aaa7e26cf417e6331617ea7dd0p0,
    -0x1.a970fb56ce140p-1
  },
  { // Entry 558
    0x1.1872a1aaa7e26cf417e6331617ea7dd0p0,
    0x1.a970fb56ce140p-1
  },
  { // Entry 559
    -0x1.01aeeed04cbb0dfacd1d00c657d08b19p0,
    -0x1.93cd3a2c81990p-1
  },
  { // Entry 560
    0x1.01aeeed04cbb0dfacd1d00c657d08b19p0,
    0x1.93cd3a2c81990p-1
  },
  { // Entry 561
    -0x1.d98e408ac2085c4e0588df10ba7fb023p-1,
    -0x1.7e297902351e0p-1
  },
  { // Entry 562
    0x1.d98e408ac2085c4e0588df10ba7fb023p-1,
    0x1.7e297902351e0p-1
  },
  { // Entry 563
    -0x1.b2e4750631c53c54f5830fd41753d427p-1,
    -0x1.6885b7d7e8a30p-1
  },
  { // Entry 564
    0x1.b2e4750631c53c54f5830fd41753d427p-1,
    0x1.6885b7d7e8a30p-1
  },
  { // Entry 565
    -0x1.8ee916392e04590ce988d82cc3959021p-1,
    -0x1.52e1f6ad9c280p-1
  },
  { // Entry 566
    0x1.8ee916392e04590ce988d82cc3959021p-1,
    0x1.52e1f6ad9c280p-1
  },
  { // Entry 567
    -0x1.6d395e495f77e709842592e226607b53p-1,
    -0x1.3d3e35834fad0p-1
  },
  { // Entry 568
    0x1.6d395e495f77e709842592e226607b53p-1,
    0x1.3d3e35834fad0p-1
  },
  { // Entry 569
    -0x1.24e3e017a098ecf4de48bceeb026743ap-1,
    -0x1.0a0b02501c799p-1
  },
  { // Entry 570
    0x1.24e3e017a098ecf4de48bceeb026743ap-1,
    0x1.0a0b02501c799p-1
  },
  { // Entry 571
    -0x1.fdbd5f0596bdc6ef8da53ee652b57cf7p-2,
    -0x1.d8f7208e6b82cp-2
  },
  { // Entry 572
    0x1.fdbd5f0596bdc6ef8da53ee652b57cf7p-2,
    0x1.d8f7208e6b82cp-2
  },
  { // Entry 573
    -0x1.b5f3d6afbe6f259af37c4e633ab5fdfap-2,
    -0x1.9dd83c7c9e126p-2
  },
  { // Entry 574
    0x1.b5f3d6afbe6f259af37c4e633ab5fdfap-2,
    0x1.9dd83c7c9e126p-2
  },
  { // Entry 575
    -0x1.71a0f98081ea98b5f30a1593e3fc6373p-2,
    -0x1.62b9586ad0a20p-2
  },
  { // Entry 576
    0x1.71a0f98081ea98b5f30a1593e3fc6373p-2,
    0x1.62b9586ad0a20p-2
  },
  { // Entry 577
    -0x1.301909a2c36e89a67528a38c77ac9e43p-2,
    -0x1.279a74590331ap-2
  },
  { // Entry 578
    0x1.301909a2c36e89a67528a38c77ac9e43p-2,
    0x1.279a74590331ap-2
  },
  { // Entry 579
    -0x1.e18e941cc7fd519ecc40548a86d2a3edp-3,
    -0x1.d8f7208e6b829p-3
  },
  { // Entry 580
    0x1.e18e941cc7fd519ecc40548a86d2a3edp-3,
    0x1.d8f7208e6b829p-3
  },
  { // Entry 581
    -0x1.6650784bbdcc02f3390262cf68bad3c6p-3,
    -0x1.62b9586ad0a1ep-3
  },
  { // Entry 582
    0x1.6650784bbdcc02f3390262cf68bad3c6p-3,
    0x1.62b9586ad0a1ep-3
  },
  { // Entry 583
    -0x1.db142468cdafc56ecfdf8b1052b09e63p-4,
    -0x1.d8f7208e6b826p-4
  },
  { // Entry 584
    0x1.db142468cdafc56ecfdf8b1052b09e63p-4,
    0x1.d8f7208e6b826p-4
  },
  { // Entry 585
    -0x1.d97dd6d2e53f27e0fe1f3bd2b035662ap-5,
    -0x1.d8f7208e6b82dp-5
  },
  { // Entry 586
    0x1.d97dd6d2e53f27e0fe1f3bd2b035662ap-5,
    0x1.d8f7208e6b82dp-5
  },
  { // Entry 587
    0x1.d97dd6d2e53f27e0fe1f3bd2b035662ap-5,
    0x1.d8f7208e6b82dp-5
  },
  { // Entry 588
    -0x1.d97dd6d2e53f27e0fe1f3bd2b035662ap-5,
    -0x1.d8f7208e6b82dp-5
  },
  { // Entry 589
    0x1.db142468cdb036f08783d936b19348f6p-4,
    0x1.d8f7208e6b82dp-4
  },
  { // Entry 590
    -0x1.db142468cdb036f08783d936b19348f6p-4,
    -0x1.d8f7208e6b82dp-4
  },
  { // Entry 591
    0x1.6650784bbdcc44e8be2c220e1d673ffbp-3,
    0x1.62b9586ad0a22p-3
  },
  { // Entry 592
    -0x1.6650784bbdcc44e8be2c220e1d673ffbp-3,
    -0x1.62b9586ad0a22p-3
  },
  { // Entry 593
    0x1.e18e941cc7fd9528a5585157ac65e615p-3,
    0x1.d8f7208e6b82dp-3
  },
  { // Entry 594
    -0x1.e18e941cc7fd9528a5585157ac65e615p-3,
    -0x1.d8f7208e6b82dp-3
  },
  { // Entry 595
    0x1.301909a2c36eac78ec1b4e711316d0c4p-2,
    0x1.279a74590331cp-2
  },
  { // Entry 596
    -0x1.301909a2c36eac78ec1b4e711316d0c4p-2,
    -0x1.279a74590331cp-2
  },
  { // Entry 597
    0x1.71a0f98081eabce155f310288c4245eap-2,
    0x1.62b9586ad0a22p-2
  },
  { // Entry 598
    -0x1.71a0f98081eabce155f310288c4245eap-2,
    -0x1.62b9586ad0a22p-2
  },
  { // Entry 599
    0x1.b5f3d6afbe6f4b756842b8eee5c85a31p-2,
    0x1.9dd83c7c9e128p-2
  },
  { // Entry 600
    -0x1.b5f3d6afbe6f4b756842b8eee5c85a31p-2,
    -0x1.9dd83c7c9e128p-2
  },
  { // Entry 601
    0x1.fdbd5f0596bdeedd82d5223c3c1b1925p-2,
    0x1.d8f7208e6b82ep-2
  },
  { // Entry 602
    -0x1.fdbd5f0596bdeedd82d5223c3c1b1925p-2,
    -0x1.d8f7208e6b82ep-2
  },
  { // Entry 603
    0x1.24e3e017a098ecf4de48bceeb026743ap-1,
    0x1.0a0b02501c799p-1
  },
  { // Entry 604
    -0x1.24e3e017a098ecf4de48bceeb026743ap-1,
    -0x1.0a0b02501c799p-1
  },
  { // Entry 605
    0x1.6d395e495f778678b9ea0d4808c7220ap-1,
    0x1.3d3e35834faccp-1
  },
  { // Entry 606
    -0x1.6d395e495f778678b9ea0d4808c7220ap-1,
    -0x1.3d3e35834faccp-1
  },
  { // Entry 607
    0x1.8ee916392e03f2335033a41b3b0206e4p-1,
    0x1.52e1f6ad9c27cp-1
  },
  { // Entry 608
    -0x1.8ee916392e03f2335033a41b3b0206e4p-1,
    -0x1.52e1f6ad9c27cp-1
  },
  { // Entry 609
    0x1.b2e4750631c4ce283ef8753fa1edf324p-1,
    0x1.6885b7d7e8a2cp-1
  },
  { // Entry 610
    -0x1.b2e4750631c4ce283ef8753fa1edf324p-1,
    -0x1.6885b7d7e8a2cp-1
  },
  { // Entry 611
    0x1.d98e408ac207e58e15f0185d4b10cf71p-1,
    0x1.7e297902351dcp-1
  },
  { // Entry 612
    -0x1.d98e408ac207e58e15f0185d4b10cf71p-1,
    -0x1.7e297902351dcp-1
  },
  { // Entry 613
    0x1.01aeeed04cbacd8eb6bc094664db7763p0,
    0x1.93cd3a2c8198cp-1
  },
  { // Entry 614
    -0x1.01aeeed04cbacd8eb6bc094664db7763p0,
    -0x1.93cd3a2c8198cp-1
  },
  { // Entry 615
    0x1.1872a1aaa7e2268cb946fceb83f0ea5ep0,
    0x1.a970fb56ce13cp-1
  },
  { // Entry 616
    -0x1.1872a1aaa7e2268cb946fceb83f0ea5ep0,
    -0x1.a970fb56ce13cp-1
  },
  { // Entry 617
    0x1.316c8b068a7aa4cb77bc3f39921c2c8dp0,
    0x1.bf14bc811a8ecp-1
  },
  { // Entry 618
    -0x1.316c8b068a7aa4cb77bc3f39921c2c8dp0,
    -0x1.bf14bc811a8ecp-1
  },
  { // Entry 619
    0x1.4d0df1fc1d342e867e49f1f6ddacedaap0,
    0x1.d4b87dab6709cp-1
  },
  { // Entry 620
    -0x1.4d0df1fc1d342e867e49f1f6ddacedaap0,
    -0x1.d4b87dab6709cp-1
  },
  { // Entry 621
    0x1.6be702e1f6cd0016ba1677a9cd33f139p0,
    0x1.ea5c3ed5b384cp-1
  },
  { // Entry 622
    -0x1.6be702e1f6cd0016ba1677a9cd33f139p0,
    -0x1.ea5c3ed5b384cp-1
  },
  { // Entry 623
    0x1.d74caf9912dc7d9669b00926aa1ade11p0,
    0x1.12bd9173c07abp0
  },
  { // Entry 624
    -0x1.d74caf9912dc7d9669b00926aa1ade11p0,
    -0x1.12bd9173c07abp0
  },
  { // Entry 625
    0x1.1b48a35b1b283bbc82bb044e99c4d9b1p1,
    0x1.257b22e780f56p0
  },
  { // Entry 626
    -0x1.1b48a35b1b283bbc82bb044e99c4d9b1p1,
    -0x1.257b22e780f56p0
  },
  { // Entry 627
    0x1.5d603d751768fcd8af82b38746888530p1,
    0x1.3838b45b41701p0
  },
  { // Entry 628
    -0x1.5d603d751768fcd8af82b38746888530p1,
    -0x1.3838b45b41701p0
  },
  { // Entry 629
    0x1.c08caec5cf9b1b54b045228b3eeb2469p1,
    0x1.4af645cf01eacp0
  },
  { // Entry 630
    -0x1.c08caec5cf9b1b54b045228b3eeb2469p1,
    -0x1.4af645cf01eacp0
  },
  { // Entry 631
    0x1.3429e61a5d20b175d45c2a675a386ba3p2,
    0x1.5db3d742c2657p0
  },
  { // Entry 632
    -0x1.3429e61a5d20b175d45c2a675a386ba3p2,
    -0x1.5db3d742c2657p0
  },
  { // Entry 633
    0x1.e3a3729b3e8a83d44a76e342d6b3fcbfp2,
    0x1.707168b682e02p0
  },
  { // Entry 634
    -0x1.e3a3729b3e8a83d44a76e342d6b3fcbfp2,
    -0x1.707168b682e02p0
  },
  { // Entry 635
    0x1.11d87146c2da39408e86083bf1471c8bp4,
    0x1.832efa2a435adp0
  },
  { // Entry 636
    -0x1.11d87146c2da39408e86083bf1471c8bp4,
    -0x1.832efa2a435adp0
  },
  { // Entry 637
    -0x1.0d718cfc82348ab9754f3d6b5e0ea499p6,
    0x1.95ec8b9e03d58p0
  },
  { // Entry 638
    0x1.0d718cfc82348ab9754f3d6b5e0ea499p6,
    -0x1.95ec8b9e03d58p0
  },
  { // Entry 639
    -0x1.6a7e1f6407ee61397d016d691bb61d17p3,
    0x1.a8aa1d11c44ffp0
  },
  { // Entry 640
    0x1.6a7e1f6407ee61397d016d691bb61d17p3,
    -0x1.a8aa1d11c44ffp0
  },
  { // Entry 641
    0x1.9f39ea5bbe4749e962a807c2dc11c825p0,
    0x1.04aff6d330942p0
  },
  { // Entry 642
    -0x1.9f39ea5bbe4749e962a807c2dc11c825p0,
    -0x1.04aff6d330942p0
  },
  { // Entry 643
    0x1.9f3c4b8469f853b8507455717327c311p0,
    0x1.04b09e98dcdb4p0
  },
  { // Entry 644
    -0x1.9f3c4b8469f853b8507455717327c311p0,
    -0x1.04b09e98dcdb4p0
  },
  { // Entry 645
    0x1.9f3eacb224c2086ef391b0dfad2f1010p0,
    0x1.04b1465e89226p0
  },
  { // Entry 646
    -0x1.9f3eacb224c2086ef391b0dfad2f1010p0,
    -0x1.04b1465e89226p0
  },
  { // Entry 647
    0x1.9f410de4eeb69590caee85e886f478a8p0,
    0x1.04b1ee2435698p0
  },
  { // Entry 648
    -0x1.9f410de4eeb69590caee85e886f478a8p0,
    -0x1.04b1ee2435698p0
  },
  { // Entry 649
    0x1.9f436f1cc7e828f752819af1e2f4b6a2p0,
    0x1.04b295e9e1b0ap0
  },
  { // Entry 650
    -0x1.9f436f1cc7e828f752819af1e2f4b6a2p0,
    -0x1.04b295e9e1b0ap0
  },
  { // Entry 651
    0x1.9f45d059b068f0d205485ad648223e6dp0,
    0x1.04b33daf8df7cp0
  },
  { // Entry 652
    -0x1.9f45d059b068f0d205485ad648223e6dp0,
    -0x1.04b33daf8df7cp0
  },
  { // Entry 653
    0x1.9f48319ba84b1ba65f452cfe65e02d0ep0,
    0x1.04b3e5753a3eep0
  },
  { // Entry 654
    -0x1.9f48319ba84b1ba65f452cfe65e02d0ep0,
    -0x1.04b3e5753a3eep0
  },
  { // Entry 655
    0x1.9f4a92e2afa0d84fdf7ddbaad302f150p0,
    0x1.04b48d3ae6860p0
  },
  { // Entry 656
    -0x1.9f4a92e2afa0d84fdf7ddbaad302f150p0,
    -0x1.04b48d3ae6860p0
  },
  { // Entry 657
    0x1.9f4cf42ec67ba7ad0db2be248a870bfep0,
    0x1.04b5350092ccfp0
  },
  { // Entry 658
    -0x1.9f4cf42ec67ba7ad0db2be248a870bfep0,
    -0x1.04b5350092ccfp0
  },
  { // Entry 659
    -0x1.p-1074,
    -0x1.0p-1074
  },
  { // Entry 660
    0x1.p-1074,
    0x1.0p-1074
  },
  { // Entry 661
    -0.0,
    -0.0
  },
  { // Entry 662
    0x1.p-1074,
    0x1.0p-1074
  },
  { // Entry 663
    -0x1.p-1074,
    -0x1.0p-1074
  },
  { // Entry 664
    0x1.4d82b68cac19e6d065c5f1aa7621c08cp-1,
    0x1.279a74590331bp-1
  },
  { // Entry 665
    -0x1.4d82b68cac19e6d065c5f1aa7621c08cp-1,
    -0x1.279a74590331bp-1
  },
  { // Entry 666
    0x1.4d82b68cac19fd9a5b0c912d9093aa4ap-1,
    0x1.279a74590331cp-1
  },
  { // Entry 667
    -0x1.4d82b68cac19fd9a5b0c912d9093aa4ap-1,
    -0x1.279a74590331cp-1
  },
  { // Entry 668
    0x1.4d82b68cac1a1464505330b0abf316bfp-1,
    0x1.279a74590331dp-1
  },
  { // Entry 669
    -0x1.4d82b68cac1a1464505330b0abf316bfp-1,
    -0x1.279a74590331dp-1
  },
  { // Entry 670
    -0x1.89712eeca32be97dba2ca3f9b8379154p2,
    0x1.bb67ae8584ca9p0
  },
  { // Entry 671
    0x1.89712eeca32be97dba2ca3f9b8379154p2,
    -0x1.bb67ae8584ca9p0
  },
  { // Entry 672
    -0x1.89712eeca32b4e528d25635a4293be1dp2,
    0x1.bb67ae8584caap0
  },
  { // Entry 673
    0x1.89712eeca32b4e528d25635a4293be1dp2,
    -0x1.bb67ae8584caap0
  },
  { // Entry 674
    -0x1.89712eeca32ab327601e22bb442cdc37p2,
    0x1.bb67ae8584cabp0
  },
  { // Entry 675
    0x1.89712eeca32ab327601e22bb442cdc37p2,
    -0x1.bb67ae8584cabp0
  },
  { // Entry 676
    0x1.def49eaab37a00f90cb4454710e4e545p-2,
    0x1.bffffffffffffp-2
  },
  { // Entry 677
    -0x1.def49eaab37a00f90cb4454710e4e545p-2,
    -0x1.bffffffffffffp-2
  },
  { // Entry 678
    0x1.def49eaab37a1479231e899509ecf26cp-2,
    0x1.cp-2
  },
  { // Entry 679
    -0x1.def49eaab37a1479231e899509ecf26cp-2,
    -0x1.cp-2
  },
  { // Entry 680
    0x1.def49eaab37a27f93988cde3033df72cp-2,
    0x1.c000000000001p-2
  },
  { // Entry 681
    -0x1.def49eaab37a27f93988cde3033df72cp-2,
    -0x1.c000000000001p-2
  },
  { // Entry 682
    0x1.a46cb2be6a0b02e2dfffc95e6dcb2842p-1,
    0x1.5ffffffffffffp-1
  },
  { // Entry 683
    -0x1.a46cb2be6a0b02e2dfffc95e6dcb2842p-1,
    -0x1.5ffffffffffffp-1
  },
  { // Entry 684
    0x1.a46cb2be6a0b1dacb36269c41a4a9147p-1,
    0x1.6p-1
  },
  { // Entry 685
    -0x1.a46cb2be6a0b1dacb36269c41a4a9147p-1,
    -0x1.6p-1
  },
  { // Entry 686
    0x1.a46cb2be6a0b387686c50a29c829ee42p-1,
    0x1.6000000000001p-1
  },
  { // Entry 687
    -0x1.a46cb2be6a0b387686c50a29c829ee42p-1,
    -0x1.6000000000001p-1
  },
  { // Entry 688
    0x1.3d6dc956eac79a85b47456fa0c946b13p1,
    0x1.2ffffffffffffp0
  },
  { // Entry 689
    -0x1.3d6dc956eac79a85b47456fa0c946b13p1,
    -0x1.2ffffffffffffp0
  },
  { // Entry 690
    0x1.3d6dc956eac7d3b8d6eb2174110d1ddcp1,
    0x1.3p0
  },
  { // Entry 691
    -0x1.3d6dc956eac7d3b8d6eb2174110d1ddcp1,
    -0x1.3p0
  },
  { // Entry 692
    0x1.3d6dc956eac80cebf961ebee274107p1,
    0x1.3000000000001p0
  },
  { // Entry 693
    -0x1.3d6dc956eac80cebf961ebee274107p1,
    -0x1.3000000000001p0
  },
  { // Entry 694
    -0x1.b2d89a93829536cc9283cfc7e01fe2a3p-1,
    0x1.37fffffffffffp1
  },
  { // Entry 695
    0x1.b2d89a93829536cc9283cfc7e01fe2a3p-1,
    -0x1.37fffffffffffp1
  },
  { // Entry 696
    -0x1.b2d89a938294c8a2604db9f7aa56a0f8p-1,
    0x1.380p1
  },
  { // Entry 697
    0x1.b2d89a938294c8a2604db9f7aa56a0f8p-1,
    -0x1.380p1
  },
  { // Entry 698
    -0x1.b2d89a9382945a782e17a4278bf17736p-1,
    0x1.3800000000001p1
  },
  { // Entry 699
    0x1.b2d89a9382945a782e17a4278bf17736p-1,
    -0x1.3800000000001p1
  },
  { // Entry 700
    0x1.06f8d014bf083cd36650e9466dc086dcp-4,
    0x1.069c8b46b3792p-4
  },
  { // Entry 701
    -0x1.06f8d014bf083cd36650e9466dc086dcp-4,
    -0x1.069c8b46b3792p-4
  },
  { // Entry 702
    0x1.080f73b07051e37b23da3337c0aed353p-3,
    0x1.069c8b46b3792p-3
  },
  { // Entry 703
    -0x1.080f73b07051e37b23da3337c0aed353p-3,
    -0x1.069c8b46b3792p-3
  },
  { // Entry 704
    0x1.8ed9142fc918888e294d3ff5d0149415p-3,
    0x1.89ead0ea0d35bp-3
  },
  { // Entry 705
    -0x1.8ed9142fc918888e294d3ff5d0149415p-3,
    -0x1.89ead0ea0d35bp-3
  },
  { // Entry 706
    0x1.0c864083d1e7ca5551bce24972878127p-2,
    0x1.069c8b46b3792p-2
  },
  { // Entry 707
    -0x1.0c864083d1e7ca5551bce24972878127p-2,
    -0x1.069c8b46b3792p-2
  },
  { // Entry 708
    0x1.53fdcdfd37f04375d9ffb6aebafe7df8p-2,
    0x1.4843ae1860576p-2
  },
  { // Entry 709
    -0x1.53fdcdfd37f04375d9ffb6aebafe7df8p-2,
    -0x1.4843ae1860576p-2
  },
  { // Entry 710
    0x1.9e9257e6b62a0a8de5650c837f7f6227p-2,
    0x1.89ead0ea0d35ap-2
  },
  { // Entry 711
    -0x1.9e9257e6b62a0a8de5650c837f7f6227p-2,
    -0x1.89ead0ea0d35ap-2
  },
  { // Entry 712
    0x1.ed21e59972b07c7053f4f35dd5502493p-2,
    0x1.cb91f3bbba13ep-2
  },
  { // Entry 713
    -0x1.ed21e59972b07c7053f4f35dd5502493p-2,
    -0x1.cb91f3bbba13ep-2
  },
  { // Entry 714
    0x1.205a6009d5e3dde25d6deb7d521ff140p-1,
    0x1.069c8b46b3791p-1
  },
  { // Entry 715
    -0x1.205a6009d5e3dde25d6deb7d521ff140p-1,
    -0x1.069c8b46b3791p-1
  },
  { // Entry 716
    0x1.4d466accad48dd958ab168f5cfc6c99cp-1,
    0x1.27701caf89e83p-1
  },
  { // Entry 717
    -0x1.4d466accad48dd958ab168f5cfc6c99cp-1,
    -0x1.27701caf89e83p-1
  },
  { // Entry 718
    0x1.7e1d936f4d6152fb74809595717fa06dp-1,
    0x1.4843ae1860575p-1
  },
  { // Entry 719
    -0x1.7e1d936f4d6152fb74809595717fa06dp-1,
    -0x1.4843ae1860575p-1
  },
  { // Entry 720
    0x1.b3df386f18227ebcee905fdc51cdcbe2p-1,
    0x1.69173f8136c67p-1
  },
  { // Entry 721
    -0x1.b3df386f18227ebcee905fdc51cdcbe2p-1,
    -0x1.69173f8136c67p-1
  },
  { // Entry 722
    0x1.efd82742d778c18a8c969be0cf0902b3p-1,
    0x1.89ead0ea0d359p-1
  },
  { // Entry 723
    -0x1.efd82742d778c18a8c969be0cf0902b3p-1,
    -0x1.89ead0ea0d359p-1
  },
  { // Entry 724
    0x1.19e26b5ecd5c040a1d80c1583f78f7d7p0,
    0x1.aabe6252e3a4bp-1
  },
  { // Entry 725
    -0x1.19e26b5ecd5c040a1d80c1583f78f7d7p0,
    -0x1.aabe6252e3a4bp-1
  },
  { // Entry 726
    0x1.41038b70be0fa1478f98a2e9f266550ap0,
    0x1.cb91f3bbba13dp-1
  },
  { // Entry 727
    -0x1.41038b70be0fa1478f98a2e9f266550ap0,
    -0x1.cb91f3bbba13dp-1
  },
  { // Entry 728
    0x1.6efec8c1e493b517efe5eb92464fdf42p0,
    0x1.ec6585249082fp-1
  },
  { // Entry 729
    -0x1.6efec8c1e493b517efe5eb92464fdf42p0,
    -0x1.ec6585249082fp-1
  },
  { // Entry 730
    0x1.a64c7c9d653462d8ded3e658fe4efbcbp0,
    0x1.069c8b46b3791p0
  },
  { // Entry 731
    -0x1.a64c7c9d653462d8ded3e658fe4efbcbp0,
    -0x1.069c8b46b3791p0
  },
  { // Entry 732
    0x1.eab43e0e5e87c26fd432e06301e19e15p0,
    0x1.170653fb1eb0ap0
  },
  { // Entry 733
    -0x1.eab43e0e5e87c26fd432e06301e19e15p0,
    -0x1.170653fb1eb0ap0
  },
  { // Entry 734
    0x1.21277b97c01376e361988250b56364cfp1,
    0x1.27701caf89e83p0
  },
  { // Entry 735
    -0x1.21277b97c01376e361988250b56364cfp1,
    -0x1.27701caf89e83p0
  },
  { // Entry 736
    0x1.5bd13dda077cce249db2794d69407504p1,
    0x1.37d9e563f51fcp0
  },
  { // Entry 737
    -0x1.5bd13dda077cce249db2794d69407504p1,
    -0x1.37d9e563f51fcp0
  },
  { // Entry 738
    0x1.af4643e9371f88e78c24d83bd6b8e23ep1,
    0x1.4843ae1860575p0
  },
  { // Entry 739
    -0x1.af4643e9371f88e78c24d83bd6b8e23ep1,
    -0x1.4843ae1860575p0
  },
  { // Entry 740
    0x1.1866fe845e759d14da478c6cf6f2be65p2,
    0x1.58ad76cccb8eep0
  },
  { // Entry 741
    -0x1.1866fe845e759d14da478c6cf6f2be65p2,
    -0x1.58ad76cccb8eep0
  },
  { // Entry 742
    0x1.8bdcd54bd5980b3a80cefc914c481475p2,
    0x1.69173f8136c67p0
  },
  { // Entry 743
    -0x1.8bdcd54bd5980b3a80cefc914c481475p2,
    -0x1.69173f8136c67p0
  },
  { // Entry 744
    0x1.4bb6a64e0625b974cded615056ffd61cp3,
    0x1.79810835a1fe0p0
  },
  { // Entry 745
    -0x1.4bb6a64e0625b974cded615056ffd61cp3,
    -0x1.79810835a1fe0p0
  },
  { // Entry 746
    0x1.f2f05cfb656a39f6f2a90f7911b24051p4,
    0x1.89ead0ea0d359p0
  },
  { // Entry 747
    -0x1.f2f05cfb656a39f6f2a90f7911b24051p4,
    -0x1.89ead0ea0d359p0
  },
  { // Entry 748
    -0x1.f2f05cfb657f55f2bc6d204377a68543p4,
    0x1.9a54999e786d2p0
  },
  { // Entry 749
    0x1.f2f05cfb657f55f2bc6d204377a68543p4,
    -0x1.9a54999e786d2p0
  },
  { // Entry 750
    -0x1.4bb6a64e062a6da35870cfb33595fbe6p3,
    0x1.aabe6252e3a4bp0
  },
  { // Entry 751
    0x1.4bb6a64e062a6da35870cfb33595fbe6p3,
    -0x1.aabe6252e3a4bp0
  },
  { // Entry 752
    -0x1.8bdcd54bd59b73028e5f27649ca67cbap2,
    0x1.bb282b074edc4p0
  },
  { // Entry 753
    0x1.8bdcd54bd59b73028e5f27649ca67cbap2,
    -0x1.bb282b074edc4p0
  },
  { // Entry 754
    -0x1.1866fe845e775d8c8f8bf9165647f6cbp2,
    0x1.cb91f3bbba13dp0
  },
  { // Entry 755
    0x1.1866fe845e775d8c8f8bf9165647f6cbp2,
    -0x1.cb91f3bbba13dp0
  },
  { // Entry 756
    -0x1.af4643e93721ad8095dd27f0827e13e0p1,
    0x1.dbfbbc70254b6p0
  },
  { // Entry 757
    0x1.af4643e93721ad8095dd27f0827e13e0p1,
    -0x1.dbfbbc70254b6p0
  },
  { // Entry 758
    -0x1.5bd13dda077e427d0c9dc6c0e5d3b1b5p1,
    0x1.ec6585249082fp0
  },
  { // Entry 759
    0x1.5bd13dda077e427d0c9dc6c0e5d3b1b5p1,
    -0x1.ec6585249082fp0
  },
  { // Entry 760
    -0x1.21277b97c01485f17bacdb804375ebcdp1,
    0x1.fccf4dd8fbba8p0
  },
  { // Entry 761
    0x1.21277b97c01485f17bacdb804375ebcdp1,
    -0x1.fccf4dd8fbba8p0
  },
  { // Entry 762
    -0x1.eab43e0e5e8916d4c08349abe9e2abd3p0,
    0x1.069c8b46b3791p1
  },
  { // Entry 763
    0x1.eab43e0e5e8916d4c08349abe9e2abd3p0,
    -0x1.069c8b46b3791p1
  },
  { // Entry 764
    -0x1.a64c7c9d6535364d605bb9e5315072ffp0,
    0x1.0ed16fa0e914ep1
  },
  { // Entry 765
    0x1.a64c7c9d6535364d605bb9e5315072ffp0,
    -0x1.0ed16fa0e914ep1
  },
  { // Entry 766
    -0x1.6efec8c1e4944a425541219364a15078p0,
    0x1.170653fb1eb0bp1
  },
  { // Entry 767
    0x1.6efec8c1e4944a425541219364a15078p0,
    -0x1.170653fb1eb0bp1
  },
  { // Entry 768
    -0x1.41038b70be0ff5b7c4d8f06b0d4cf525p0,
    0x1.1f3b3855544c8p1
  },
  { // Entry 769
    0x1.41038b70be0ff5b7c4d8f06b0d4cf525p0,
    -0x1.1f3b3855544c8p1
  },
  { // Entry 770
    -0x1.19e26b5ecd5c294348ba17fec5454792p0,
    0x1.27701caf89e85p1
  },
  { // Entry 771
    0x1.19e26b5ecd5c294348ba17fec5454792p0,
    -0x1.27701caf89e85p1
  },
  { // Entry 772
    -0x1.efd82742d778c4bca07e1e86cbc604b0p-1,
    0x1.2fa50109bf842p1
  },
  { // Entry 773
    0x1.efd82742d778c4bca07e1e86cbc604b0p-1,
    -0x1.2fa50109bf842p1
  },
  { // Entry 774
    -0x1.b3df386f18224a6403e55c16b36ef17fp-1,
    0x1.37d9e563f51ffp1
  },
  { // Entry 775
    0x1.b3df386f18224a6403e55c16b36ef17fp-1,
    -0x1.37d9e563f51ffp1
  },
  { // Entry 776
    -0x1.7e1d936f4d60f1e6f88b4a24df9c65f4p-1,
    0x1.400ec9be2abbcp1
  },
  { // Entry 777
    0x1.7e1d936f4d60f1e6f88b4a24df9c65f4p-1,
    -0x1.400ec9be2abbcp1
  },
  { // Entry 778
    -0x1.4d466accad48574188835130e68e9badp-1,
    0x1.4843ae1860579p1
  },
  { // Entry 779
    0x1.4d466accad48574188835130e68e9badp-1,
    -0x1.4843ae1860579p1
  },
  { // Entry 780
    -0x1.205a6009d5e33774fa98f9f616acc80fp-1,
    0x1.5078927295f36p1
  },
  { // Entry 781
    0x1.205a6009d5e33774fa98f9f616acc80fp-1,
    -0x1.5078927295f36p1
  },
  { // Entry 782
    -0x1.ed21e59972aef64a06e553f18d646093p-2,
    0x1.58ad76cccb8f3p1
  },
  { // Entry 783
    0x1.ed21e59972aef64a06e553f18d646093p-2,
    -0x1.58ad76cccb8f3p1
  },
  { // Entry 784
    -0x1.9e9257e6b6284f73cd1e2eae3220f313p-2,
    0x1.60e25b27012b0p1
  },
  { // Entry 785
    0x1.9e9257e6b6284f73cd1e2eae3220f313p-2,
    -0x1.60e25b27012b0p1
  },
  { // Entry 786
    -0x1.53fdcdfd37ee55bc1cd1604b6ab13b5fp-2,
    0x1.69173f8136c6dp1
  },
  { // Entry 787
    0x1.53fdcdfd37ee55bc1cd1604b6ab13b5fp-2,
    -0x1.69173f8136c6dp1
  },
  { // Entry 788
    -0x1.0c864083d1e5aaa6815a85e25c662e97p-2,
    0x1.714c23db6c62ap1
  },
  { // Entry 789
    0x1.0c864083d1e5aaa6815a85e25c662e97p-2,
    -0x1.714c23db6c62ap1
  },
  { // Entry 790
    -0x1.8ed9142fc913f450dccdbdd27ed11a40p-3,
    0x1.79810835a1fe7p1
  },
  { // Entry 791
    0x1.8ed9142fc913f450dccdbdd27ed11a40p-3,
    -0x1.79810835a1fe7p1
  },
  { // Entry 792
    -0x1.080f73b0704cf570818a65d1a12d5be1p-3,
    0x1.81b5ec8fd79a4p1
  },
  { // Entry 793
    0x1.080f73b0704cf570818a65d1a12d5be1p-3,
    -0x1.81b5ec8fd79a4p1
  },
  { // Entry 794
    -0x1.06f8d014bf09ab85f2a19d80da5a2c0bp-4,
    0x1.89ead0ea0d35bp1
  },
  { // Entry 795
    0x1.06f8d014bf09ab85f2a19d80da5a2c0bp-4,
    -0x1.89ead0ea0d35bp1
  },
  { // Entry 796
    0x1.0c864083d1e7f3955b12071e0644418bp-2,
    -0x1.81b5ec8fd799fp2
  },
  { // Entry 797
    -0x1.0c864083d1e7f3955b12071e0644418bp-2,
    0x1.81b5ec8fd799fp2
  },
  { // Entry 798
    0x1.205a6009d5e3f74da3a372ac15721ef6p-1,
    -0x1.714c23db6c626p2
  },
  { // Entry 799
    -0x1.205a6009d5e3f74da3a372ac15721ef6p-1,
    0x1.714c23db6c626p2
  },
  { // Entry 800
    0x1.efd82742d778e6f04adefc3d21f8be96p-1,
    -0x1.60e25b27012adp2
  },
  { // Entry 801
    -0x1.efd82742d778e6f04adefc3d21f8be96p-1,
    0x1.60e25b27012adp2
  },
  { // Entry 802
    0x1.a64c7c9d653468fbc5260dca501ddb81p0,
    -0x1.5078927295f34p2
  },
  { // Entry 803
    -0x1.a64c7c9d653468fbc5260dca501ddb81p0,
    0x1.5078927295f34p2
  },
  { // Entry 804
    0x1.af4643e9371f9316d3254b8619eda484p1,
    -0x1.400ec9be2abbbp2
  },
  { // Entry 805
    -0x1.af4643e9371f9316d3254b8619eda484p1,
    0x1.400ec9be2abbbp2
  },
  { // Entry 806
    0x1.f2f05cfb656a9e4a085b027d18603230p4,
    -0x1.2fa50109bf842p2
  },
  { // Entry 807
    -0x1.f2f05cfb656a9e4a085b027d18603230p4,
    0x1.2fa50109bf842p2
  },
  { // Entry 808
    -0x1.1866fe845e7755392a0adff56a688eaap2,
    -0x1.1f3b3855544c9p2
  },
  { // Entry 809
    0x1.1866fe845e7755392a0adff56a688eaap2,
    0x1.1f3b3855544c9p2
  },
  { // Entry 810
    -0x1.eab43e0e5e8959e8f5ac6c4f9d9a833bp0,
    -0x1.0ed16fa0e9150p2
  },
  { // Entry 811
    0x1.eab43e0e5e8959e8f5ac6c4f9d9a833bp0,
    0x1.0ed16fa0e9150p2
  },
  { // Entry 812
    -0x1.19e26b5ecd5cd69c30c3dc5d9ffde986p0,
    -0x1.fccf4dd8fbbaep1
  },
  { // Entry 813
    0x1.19e26b5ecd5cd69c30c3dc5d9ffde986p0,
    0x1.fccf4dd8fbbaep1
  },
  { // Entry 814
    -0x1.4d466accad49ec96935caa2a35e439f0p-1,
    -0x1.dbfbbc70254bcp1
  },
  { // Entry 815
    0x1.4d466accad49ec96935caa2a35e439f0p-1,
    0x1.dbfbbc70254bcp1
  },
  { // Entry 816
    -0x1.53fdcdfd37f1ea216e815758ed02a557p-2,
    -0x1.bb282b074edcap1
  },
  { // Entry 817
    0x1.53fdcdfd37f1ea216e815758ed02a557p-2,
    0x1.bb282b074edcap1
  },
  { // Entry 818
    -0x1.06f8d014bf0e964e634f37bcdbf64491p-4,
    -0x1.9a54999e786d8p1
  },
  { // Entry 819
    0x1.06f8d014bf0e964e634f37bcdbf64491p-4,
    0x1.9a54999e786d8p1
  },
  { // Entry 820
    0x1.8ed9142fc914fe067b991d11d70859b8p-3,
    -0x1.79810835a1fe6p1
  },
  { // Entry 821
    -0x1.8ed9142fc914fe067b991d11d70859b8p-3,
    0x1.79810835a1fe6p1
  },
  { // Entry 822
    0x1.ed21e59972ae589aaa4ee3d80c3b7defp-2,
    -0x1.58ad76cccb8f4p1
  },
  { // Entry 823
    -0x1.ed21e59972ae589aaa4ee3d80c3b7defp-2,
    0x1.58ad76cccb8f4p1
  },
  { // Entry 824
    0x1.b3df386f1820ff3df290f036db46f13bp-1,
    -0x1.37d9e563f5202p1
  },
  { // Entry 825
    -0x1.b3df386f1820ff3df290f036db46f13bp-1,
    0x1.37d9e563f5202p1
  },
  { // Entry 826
    0x1.6efec8c1e492616fe2fec0b764fa6eb4p0,
    -0x1.170653fb1eb10p1
  },
  { // Entry 827
    -0x1.6efec8c1e492616fe2fec0b764fa6eb4p0,
    0x1.170653fb1eb10p1
  },
  { // Entry 828
    0x1.5bd13dda077ada91927ab73cedaa828dp1,
    -0x1.ec6585249083cp0
  },
  { // Entry 829
    -0x1.5bd13dda077ada91927ab73cedaa828dp1,
    0x1.ec6585249083cp0
  },
  { // Entry 830
    0x1.4bb6a64e061f69cf7409931383cc80a1p3,
    -0x1.aabe6252e3a58p0
  },
  { // Entry 831
    -0x1.4bb6a64e061f69cf7409931383cc80a1p3,
    0x1.aabe6252e3a58p0
  },
  { // Entry 832
    -0x1.8bdcd54bd5a004acf922c49a8d5e28a2p2,
    -0x1.69173f8136c74p0
  },
  { // Entry 833
    0x1.8bdcd54bd5a004acf922c49a8d5e28a2p2,
    0x1.69173f8136c74p0
  },
  { // Entry 834
    -0x1.21277b97c015f19de7b238252e56e63fp1,
    -0x1.27701caf89e90p0
  },
  { // Entry 835
    0x1.21277b97c015f19de7b238252e56e63fp1,
    0x1.27701caf89e90p0
  },
  { // Entry 836
    -0x1.41038b70be11b85798a271ac3d209ea7p0,
    -0x1.cb91f3bbba157p-1
  },
  { // Entry 837
    0x1.41038b70be11b85798a271ac3d209ea7p0,
    0x1.cb91f3bbba157p-1
  },
  { // Entry 838
    -0x1.7e1d936f4d63c1c7806657d8b838836ep-1,
    -0x1.4843ae186058ep-1
  },
  { // Entry 839
    0x1.7e1d936f4d63c1c7806657d8b838836ep-1,
    0x1.4843ae186058ep-1
  },
  { // Entry 840
    -0x1.9e9257e6b62d886f74e348bdc142599cp-2,
    -0x1.89ead0ea0d38ap-2
  },
  { // Entry 841
    0x1.9e9257e6b62d886f74e348bdc142599cp-2,
    0x1.89ead0ea0d38ap-2
  },
  { // Entry 842
    -0x1.080f73b07057dc7bf0df6de1d3ae1a3bp-3,
    -0x1.069c8b46b37f0p-3
  },
  { // Entry 843
    0x1.080f73b07057dc7bf0df6de1d3ae1a3bp-3,
    0x1.069c8b46b37f0p-3
  },
  { // Entry 844
    0x1.080f73b0704bea7a56d4f88ecf3d5cd3p-3,
    0x1.069c8b46b3734p-3
  },
  { // Entry 845
    -0x1.080f73b0704bea7a56d4f88ecf3d5cd3p-3,
    -0x1.069c8b46b3734p-3
  },
  { // Entry 846
    0x1.9e9257e6b626b1eb1136bd7853311543p-2,
    0x1.89ead0ea0d32cp-2
  },
  { // Entry 847
    -0x1.9e9257e6b626b1eb1136bd7853311543p-2,
    -0x1.89ead0ea0d32cp-2
  },
  { // Entry 848
    0x1.7e1d936f4d5f2eebbbf3d62963106afap-1,
    0x1.4843ae186055fp-1
  },
  { // Entry 849
    -0x1.7e1d936f4d5f2eebbbf3d62963106afap-1,
    -0x1.4843ae186055fp-1
  },
  { // Entry 850
    0x1.41038b70be0df11d1224683c6f865584p0,
    0x1.cb91f3bbba128p-1
  },
  { // Entry 851
    -0x1.41038b70be0df11d1224683c6f865584p0,
    -0x1.cb91f3bbba128p-1
  },
  { // Entry 852
    0x1.21277b97c0115dcf6647ad68f4cb4ad0p1,
    0x1.27701caf89e78p0
  },
  { // Entry 853
    -0x1.21277b97c0115dcf6647ad68f4cb4ad0p1,
    -0x1.27701caf89e78p0
  },
  { // Entry 854
    0x1.8bdcd54bd5914bd9a4d6dd659c2f6606p2,
    0x1.69173f8136c5cp0
  },
  { // Entry 855
    -0x1.8bdcd54bd5914bd9a4d6dd659c2f6606p2,
    -0x1.69173f8136c5cp0
  },
  { // Entry 856
    -0x1.4bb6a64e0633bfa56879660655c38767p3,
    0x1.aabe6252e3a40p0
  },
  { // Entry 857
    0x1.4bb6a64e0633bfa56879660655c38767p3,
    -0x1.aabe6252e3a40p0
  },
  { // Entry 858
    -0x1.5bd13dda078124444c940f013be7c402p1,
    0x1.ec65852490824p0
  },
  { // Entry 859
    0x1.5bd13dda078124444c940f013be7c402p1,
    -0x1.ec65852490824p0
  },
  { // Entry 860
    -0x1.6efec8c1e496f69c286adc66bd586eafp0,
    0x1.170653fb1eb04p1
  },
  { // Entry 861
    0x1.6efec8c1e496f69c286adc66bd586eafp0,
    -0x1.170653fb1eb04p1
  },
  { // Entry 862
    -0x1.b3df386f18262bd637e29fbb30806b2cp-1,
    0x1.37d9e563f51f6p1
  },
  { // Entry 863
    0x1.b3df386f18262bd637e29fbb30806b2cp-1,
    -0x1.37d9e563f51f6p1
  },
  { // Entry 864
    -0x1.ed21e59972b5bcd3015c250eff1c69b9p-2,
    0x1.58ad76cccb8e8p1
  },
  { // Entry 865
    0x1.ed21e59972b5bcd3015c250eff1c69b9p-2,
    -0x1.58ad76cccb8e8p1
  },
  { // Entry 866
    -0x1.8ed9142fc9217289ed21940deaafe878p-3,
    0x1.79810835a1fdap1
  },
  { // Entry 867
    0x1.8ed9142fc9217289ed21940deaafe878p-3,
    -0x1.79810835a1fdap1
  },
  { // Entry 868
    0x1.06f8d014bef67cfb2db560f5a414c88bp-4,
    0x1.9a54999e786ccp1
  },
  { // Entry 869
    -0x1.06f8d014bef67cfb2db560f5a414c88bp-4,
    -0x1.9a54999e786ccp1
  },
  { // Entry 870
    0x1.53fdcdfd37eb40cd9e504df431b502d0p-2,
    0x1.bb282b074edbep1
  },
  { // Entry 871
    -0x1.53fdcdfd37eb40cd9e504df431b502d0p-2,
    -0x1.bb282b074edbep1
  },
  { // Entry 872
    0x1.4d466accad45a72e5f735eb2f6adf9ffp-1,
    0x1.dbfbbc70254b0p1
  },
  { // Entry 873
    -0x1.4d466accad45a72e5f735eb2f6adf9ffp-1,
    -0x1.dbfbbc70254b0p1
  },
  { // Entry 874
    0x1.19e26b5ecd598507ecd00d81ec775683p0,
    0x1.fccf4dd8fbba2p1
  },
  { // Entry 875
    -0x1.19e26b5ecd598507ecd00d81ec775683p0,
    -0x1.fccf4dd8fbba2p1
  },
  { // Entry 876
    0x1.eab43e0e5e8257073afaecab386154a1p0,
    0x1.0ed16fa0e914ap2
  },
  { // Entry 877
    -0x1.eab43e0e5e8257073afaecab386154a1p0,
    -0x1.0ed16fa0e914ap2
  },
  { // Entry 878
    0x1.1866fe845e6fc27064e2b123a7724e75p2,
    0x1.1f3b3855544c3p2
  },
  { // Entry 879
    -0x1.1866fe845e6fc27064e2b123a7724e75p2,
    -0x1.1f3b3855544c3p2
  },
  { // Entry 880
    -0x1.f2f05cfb65c5e06b1ae88c48b4b755cep4,
    0x1.2fa50109bf83cp2
  },
  { // Entry 881
    0x1.f2f05cfb65c5e06b1ae88c48b4b755cep4,
    -0x1.2fa50109bf83cp2
  },
  { // Entry 882
    -0x1.af4643e93728d6bfd702c33405dcce7dp1,
    0x1.400ec9be2abb5p2
  },
  { // Entry 883
    0x1.af4643e93728d6bfd702c33405dcce7dp1,
    -0x1.400ec9be2abb5p2
  },
  { // Entry 884
    -0x1.a64c7c9d6539fdec27afc380b9f752c0p0,
    0x1.5078927295f2ep2
  },
  { // Entry 885
    0x1.a64c7c9d6539fdec27afc380b9f752c0p0,
    -0x1.5078927295f2ep2
  },
  { // Entry 886
    -0x1.efd82742d77eb73c81a00f568621f63cp-1,
    0x1.60e25b27012a7p2
  },
  { // Entry 887
    0x1.efd82742d77eb73c81a00f568621f63cp-1,
    -0x1.60e25b27012a7p2
  },
  { // Entry 888
    -0x1.205a6009d5e7eae63da1cbd57129eeffp-1,
    0x1.714c23db6c620p2
  },
  { // Entry 889
    0x1.205a6009d5e7eae63da1cbd57129eeffp-1,
    -0x1.714c23db6c620p2
  },
  { // Entry 890
    -0x1.0c864083d1ee5d34de2060c8629d4951p-2,
    0x1.81b5ec8fd7999p2
  },
  { // Entry 891
    0x1.0c864083d1ee5d34de2060c8629d4951p-2,
    -0x1.81b5ec8fd7999p2
  },
  { // Entry 892
    0x1.f09b63aa81fc36da509c3e410607ffe7p-5,
    0x1.effffffffffffp-5
  },
  { // Entry 893
    -0x1.f09b63aa81fc36da509c3e410607ffe7p-5,
    -0x1.effffffffffffp-5
  },
  { // Entry 894
    0x1.f09b63aa81fc46e95e06405b41e8b4ccp-5,
    0x1.fp-5
  },
  { // Entry 895
    -0x1.f09b63aa81fc46e95e06405b41e8b4ccp-5,
    -0x1.fp-5
  },
  { // Entry 896
    0x1.f09b63aa81fc56f86b7042757dca62e8p-5,
    0x1.f000000000001p-5
  },
  { // Entry 897
    -0x1.f09b63aa81fc56f86b7042757dca62e8p-5,
    -0x1.f000000000001p-5
  },
  { // Entry 898
    0x1.fa8f21c8a33aecf4af77754ef90a67b8p-4,
    0x1.f7fffffffffffp-4
  },
  { // Entry 899
    -0x1.fa8f21c8a33aecf4af77754ef90a67b8p-4,
    -0x1.f7fffffffffffp-4
  },
  { // Entry 900
    0x1.fa8f21c8a33afd3355198e8d7716a811p-4,
    0x1.f80p-4
  },
  { // Entry 901
    -0x1.fa8f21c8a33afd3355198e8d7716a811p-4,
    -0x1.f80p-4
  },
  { // Entry 902
    0x1.fa8f21c8a33b0d71fabba7cbf526ed07p-4,
    0x1.f800000000001p-4
  },
  { // Entry 903
    -0x1.fa8f21c8a33b0d71fabba7cbf526ed07p-4,
    -0x1.f800000000001p-4
  },
  { // Entry 904
    0x1.4ef06cb4f0a869ef00df8ec5582dfa31p-3,
    0x1.4bfffffffffffp-3
  },
  { // Entry 905
    -0x1.4ef06cb4f0a869ef00df8ec5582dfa31p-3,
    -0x1.4bfffffffffffp-3
  },
  { // Entry 906
    0x1.4ef06cb4f0a87a5c8eeeebceb12a22b4p-3,
    0x1.4c0p-3
  },
  { // Entry 907
    -0x1.4ef06cb4f0a87a5c8eeeebceb12a22b4p-3,
    -0x1.4c0p-3
  },
  { // Entry 908
    0x1.4ef06cb4f0a88aca1cfe48d80a310a65p-3,
    0x1.4c00000000001p-3
  },
  { // Entry 909
    -0x1.4ef06cb4f0a88aca1cfe48d80a310a65p-3,
    -0x1.4c00000000001p-3
  },
  { // Entry 910
    0x1.3cc2a44e2999668cb092a09b73b2de50p-2,
    0x1.3333333333332p-2
  },
  { // Entry 911
    -0x1.3cc2a44e2999668cb092a09b73b2de50p-2,
    -0x1.3333333333332p-2
  },
  { // Entry 912
    0x1.3cc2a44e29997814a1ac3f0211c7641fp-2,
    0x1.3333333333333p-2
  },
  { // Entry 913
    -0x1.3cc2a44e29997814a1ac3f0211c7641fp-2,
    -0x1.3333333333333p-2
  },
  { // Entry 914
    0x1.3cc2a44e2999899c92c5dd68b0074c31p-2,
    0x1.3333333333334p-2
  },
  { // Entry 915
    -0x1.3cc2a44e2999899c92c5dd68b0074c31p-2,
    -0x1.3333333333334p-2
  },
  { // Entry 916
    0x1.9943711dc2ce83d21cdb285aced817adp-1,
    0x1.594317acc4ef8p-1
  },
  { // Entry 917
    -0x1.9943711dc2ce83d21cdb285aced817adp-1,
    -0x1.594317acc4ef8p-1
  },
  { // Entry 918
    0x1.9943711dc2ce9e0b3f1ffe5aec0ac20dp-1,
    0x1.594317acc4ef9p-1
  },
  { // Entry 919
    -0x1.9943711dc2ce9e0b3f1ffe5aec0ac20dp-1,
    -0x1.594317acc4ef9p-1
  },
  { // Entry 920
    0x1.9943711dc2ceb8446164d45b0a8ccdeep-1,
    0x1.594317acc4efap-1
  },
  { // Entry 921
    -0x1.9943711dc2ceb8446164d45b0a8ccdeep-1,
    -0x1.594317acc4efap-1
  },
  { // Entry 922
    0x1.fbc511df5917d57d231d7ad434da5f94p-1,
    0x1.8ffffffffffffp-1
  },
  { // Entry 923
    -0x1.fbc511df5917d57d231d7ad434da5f94p-1,
    -0x1.8ffffffffffffp-1
  },
  { // Entry 924
    0x1.fbc511df5917f539bbcf778bc1a22249p-1,
    0x1.9p-1
  },
  { // Entry 925
    -0x1.fbc511df5917f539bbcf778bc1a22249p-1,
    -0x1.9p-1
  },
  { // Entry 926
    0x1.fbc511df591814f65481744350617c85p-1,
    0x1.9000000000001p-1
  },
  { // Entry 927
    -0x1.fbc511df591814f65481744350617c85p-1,
    -0x1.9000000000001p-1
  },
  { // Entry 928
    -0x1.p-1074,
    -0x1.0p-1074
  },
  { // Entry 929
    0x1.p-1074,
    0x1.0p-1074
  },
  { // Entry 930
    -0.0,
    -0.0
  },
  { // Entry 931
    0x1.p-1074,
    0x1.0p-1074
  },
  { // Entry 932
    -0x1.p-1074,
    -0x1.0p-1074
  },
  { // Entry 933
    0x1.927278a3b1160bbf8e0bb309da4247c5p-5,
    0x1.921fb54442d17p-5
  },
  { // Entry 934
    -0x1.927278a3b1160bbf8e0bb309da4247c5p-5,
    -0x1.921fb54442d17p-5
  },
  { // Entry 935
    0x1.927278a3b1161bc970ba8b50e575f97fp-5,
    0x1.921fb54442d18p-5
  },
  { // Entry 936
    -0x1.927278a3b1161bc970ba8b50e575f97fp-5,
    -0x1.921fb54442d18p-5
  },
  { // Entry 937
    0x1.927278a3b1162bd353696397f0aa74eep-5,
    0x1.921fb54442d19p-5
  },
  { // Entry 938
    -0x1.927278a3b1162bd353696397f0aa74eep-5,
    -0x1.921fb54442d19p-5
  },
  { // Entry 939
    0x1.936bb8c5b2da118306fa9b5d6d8ed2c1p-4,
    0x1.921fb54442d17p-4
  },
  { // Entry 940
    -0x1.936bb8c5b2da118306fa9b5d6d8ed2c1p-4,
    -0x1.921fb54442d17p-4
  },
  { // Entry 941
    0x1.936bb8c5b2da21aac2bfec84293e5d4dp-4,
    0x1.921fb54442d18p-4
  },
  { // Entry 942
    -0x1.936bb8c5b2da21aac2bfec84293e5d4dp-4,
    -0x1.921fb54442d18p-4
  },
  { // Entry 943
    0x1.936bb8c5b2da31d27e853daae4f11684p-4,
    0x1.921fb54442d19p-4
  },
  { // Entry 944
    -0x1.936bb8c5b2da31d27e853daae4f11684p-4,
    -0x1.921fb54442d19p-4
  },
  { // Entry 945
    0x1.975f5e0553156b438ca7d752d37d0873p-3,
    0x1.921fb54442d17p-3
  },
  { // Entry 946
    -0x1.975f5e0553156b438ca7d752d37d0873p-3,
    -0x1.921fb54442d17p-3
  },
  { // Entry 947
    0x1.975f5e0553157be59cbff648fdef2c08p-3,
    0x1.921fb54442d18p-3
  },
  { // Entry 948
    -0x1.975f5e0553157be59cbff648fdef2c08p-3,
    -0x1.921fb54442d18p-3
  },
  { // Entry 949
    0x1.975f5e0553158c87acd8153f286e8b8ap-3,
    0x1.921fb54442d19p-3
  },
  { // Entry 950
    -0x1.975f5e0553158c87acd8153f286e8b8ap-3,
    -0x1.921fb54442d19p-3
  },
  { // Entry 951
    0x1.a827999fcef30c38b2e5397ea7c10eadp-2,
    0x1.921fb54442d17p-2
  },
  { // Entry 952
    -0x1.a827999fcef30c38b2e5397ea7c10eadp-2,
    -0x1.921fb54442d17p-2
  },
  { // Entry 953
    0x1.a827999fcef31ef776183b070e6fc84ep-2,
    0x1.921fb54442d18p-2
  },
  { // Entry 954
    -0x1.a827999fcef31ef776183b070e6fc84ep-2,
    -0x1.921fb54442d18p-2
  },
  { // Entry 955
    0x1.a827999fcef331b6394b3c8f755c9fa3p-2,
    0x1.921fb54442d19p-2
  },
  { // Entry 956
    -0x1.a827999fcef331b6394b3c8f755c9fa3p-2,
    -0x1.921fb54442d19p-2
  },
  { // Entry 957
    0x1.ffffffffffffd72cece675d1fe3035bbp-1,
    0x1.921fb54442d17p-1
  },
  { // Entry 958
    -0x1.ffffffffffffd72cece675d1fe3035bbp-1,
    -0x1.921fb54442d17p-1
  },
  { // Entry 959
    0x1.fffffffffffff72cece675d1fca30489p-1,
    0x1.921fb54442d18p-1
  },
  { // Entry 960
    -0x1.fffffffffffff72cece675d1fca30489p-1,
    -0x1.921fb54442d18p-1
  },
  { // Entry 961
    0x1.0000000000000b9676733ae8fe8ae9acp0,
    0x1.921fb54442d19p-1
  },
  { // Entry 962
    -0x1.0000000000000b9676733ae8fe8ae9acp0,
    -0x1.921fb54442d19p-1
  },
  { // Entry 963
    0x1.9153d9443ed0b3b43ddab6ae573aa23dp51,
    0x1.921fb54442d17p0
  },
  { // Entry 964
    -0x1.9153d9443ed0b3b43ddab6ae573aa23dp51,
    -0x1.921fb54442d17p0
  },
  { // Entry 965
    0x1.d02967c31cdb4e0c38d01b655d5e0aafp53,
    0x1.921fb54442d18p0
  },
  { // Entry 966
    -0x1.d02967c31cdb4e0c38d01b655d5e0aafp53,
    -0x1.921fb54442d18p0
  },
  { // Entry 967
    -0x1.617a15494767a04882c320317f3e4cecp52,
    0x1.921fb54442d19p0
  },
  { // Entry 968
    0x1.617a15494767a04882c320317f3e4cecp52,
    -0x1.921fb54442d19p0
  },
  { // Entry 969
    -0x1.469898cc51701b839a252049c3d60c68p-51,
    0x1.921fb54442d17p1
  },
  { // Entry 970
    0x1.469898cc51701b839a252049c3d60c68p-51,
    -0x1.921fb54442d17p1
  },
  { // Entry 971
    -0x1.1a62633145c06e0e689481270461d5d7p-53,
    0x1.921fb54442d18p1
  },
  { // Entry 972
    0x1.1a62633145c06e0e689481270461d5d7p-53,
    -0x1.921fb54442d18p1
  },
  { // Entry 973
    0x1.72cece675d1fc8f8cbb5bf6c7ee0b96cp-52,
    0x1.921fb54442d19p1
  },
  { // Entry 974
    -0x1.72cece675d1fc8f8cbb5bf6c7ee0b96cp-52,
    -0x1.921fb54442d19p1
  },
  { // Entry 975
    -0x1.469898cc51701b839a252049cc244ab5p-50,
    0x1.921fb54442d17p2
  },
  { // Entry 976
    0x1.469898cc51701b839a252049cc244ab5p-50,
    -0x1.921fb54442d17p2
  },
  { // Entry 977
    -0x1.1a62633145c06e0e6894812704b7bbabp-52,
    0x1.921fb54442d18p2
  },
  { // Entry 978
    0x1.1a62633145c06e0e6894812704b7bbabp-52,
    -0x1.921fb54442d18p2
  },
  { // Entry 979
    0x1.72cece675d1fc8f8cbb5bf6c81eab38cp-51,
    0x1.921fb54442d19p2
  },
  { // Entry 980
    -0x1.72cece675d1fc8f8cbb5bf6c81eab38cp-51,
    -0x1.921fb54442d19p2
  },
  { // Entry 981
    -0x1.469898cc51701b839a252049ed5d43e8p-49,
    0x1.921fb54442d17p3
  },
  { // Entry 982
    0x1.469898cc51701b839a252049ed5d43e8p-49,
    -0x1.921fb54442d17p3
  },
  { // Entry 983
    -0x1.1a62633145c06e0e68948127060f52f9p-51,
    0x1.921fb54442d18p3
  },
  { // Entry 984
    0x1.1a62633145c06e0e68948127060f52f9p-51,
    -0x1.921fb54442d18p3
  },
  { // Entry 985
    0x1.72cece675d1fc8f8cbb5bf6c8e129c0ap-50,
    0x1.921fb54442d19p3
  },
  { // Entry 986
    -0x1.72cece675d1fc8f8cbb5bf6c8e129c0ap-50,
    -0x1.921fb54442d19p3
  },
  { // Entry 987
    -0x1.469898cc51701b839a25204a724128b4p-48,
    0x1.921fb54442d17p4
  },
  { // Entry 988
    0x1.469898cc51701b839a25204a724128b4p-48,
    -0x1.921fb54442d17p4
  },
  { // Entry 989
    -0x1.1a62633145c06e0e689481270b6db033p-50,
    0x1.921fb54442d18p4
  },
  { // Entry 990
    0x1.1a62633145c06e0e689481270b6db033p-50,
    -0x1.921fb54442d18p4
  },
  { // Entry 991
    0x1.72cece675d1fc8f8cbb5bf6cbeb23e03p-49,
    0x1.921fb54442d19p4
  },
  { // Entry 992
    -0x1.72cece675d1fc8f8cbb5bf6cbeb23e03p-49,
    -0x1.921fb54442d19p4
  },
  { // Entry 993
    -0x1.469898cc51701b839a25204c85d0bbe3p-47,
    0x1.921fb54442d17p5
  },
  { // Entry 994
    0x1.469898cc51701b839a25204c85d0bbe3p-47,
    -0x1.921fb54442d17p5
  },
  { // Entry 995
    -0x1.1a62633145c06e0e6894812720e7251ap-49,
    0x1.921fb54442d18p5
  },
  { // Entry 996
    0x1.1a62633145c06e0e6894812720e7251ap-49,
    -0x1.921fb54442d18p5
  },
  { // Entry 997
    0x1.72cece675d1fc8f8cbb5bf6d8130c5e7p-48,
    0x1.921fb54442d19p5
  },
  { // Entry 998
    -0x1.72cece675d1fc8f8cbb5bf6d8130c5e7p-48,
    -0x1.921fb54442d19p5
  },
  { // Entry 999
    -0x1.469898cc51701b839a252054d40f08a0p-46,
    0x1.921fb54442d17p6
  },
  { // Entry 1000
    0x1.469898cc51701b839a252054d40f08a0p-46,
    -0x1.921fb54442d17p6
  },
  { // Entry 1001
    -0x1.1a62633145c06e0e6894812776ccf8b7p-48,
    0x1.921fb54442d18p6
  },
  { // Entry 1002
    0x1.1a62633145c06e0e6894812776ccf8b7p-48,
    -0x1.921fb54442d18p6
  },
  { // Entry 1003
    0x1.72cece675d1fc8f8cbb5bf708b2ae576p-47,
    0x1.921fb54442d19p6
  },
  { // Entry 1004
    -0x1.72cece675d1fc8f8cbb5bf708b2ae576p-47,
    -0x1.921fb54442d19p6
  },
  { // Entry 1005
    -0x1.469898cc51701b839a2520760d083b97p-45,
    0x1.921fb54442d17p7
  },
  { // Entry 1006
    0x1.469898cc51701b839a2520760d083b97p-45,
    -0x1.921fb54442d17p7
  },
  { // Entry 1007
    -0x1.1a62633145c06e0e68948128ce64472bp-47,
    0x1.921fb54442d18p7
  },
  { // Entry 1008
    0x1.1a62633145c06e0e68948128ce64472bp-47,
    -0x1.921fb54442d18p7
  },
  { // Entry 1009
    0x1.72cece675d1fc8f8cbb5bf7cb31363b1p-46,
    0x1.921fb54442d19p7
  },
  { // Entry 1010
    -0x1.72cece675d1fc8f8cbb5bf7cb31363b1p-46,
    -0x1.921fb54442d19p7
  },
  { // Entry 1011
    -0x1.0000000000004d3c9ca64f4510cf6f31p0,
    0x1.2d97c7f3321d1p1
  },
  { // Entry 1012
    0x1.0000000000004d3c9ca64f4510cf6f31p0,
    -0x1.2d97c7f3321d1p1
  },
  { // Entry 1013
    -0x1.0000000000000d3c9ca64f4505804808p0,
    0x1.2d97c7f3321d2p1
  },
  { // Entry 1014
    0x1.0000000000000d3c9ca64f4505804808p0,
    -0x1.2d97c7f3321d2p1
  },
  { // Entry 1015
    -0x1.ffffffffffff9a79394c9e8a146241bdp-1,
    0x1.2d97c7f3321d3p1
  },
  { // Entry 1016
    0x1.ffffffffffff9a79394c9e8a146241bdp-1,
    -0x1.2d97c7f3321d3p1
  },
  { // Entry 1017
    0x1.ffffffffffff53e0a0804d1a0bbc4ab3p-1,
    0x1.f6a7a2955385dp1
  },
  { // Entry 1018
    -0x1.ffffffffffff53e0a0804d1a0bbc4ab3p-1,
    -0x1.f6a7a2955385dp1
  },
  { // Entry 1019
    0x1.ffffffffffffd3e0a0804d19f0b472d3p-1,
    0x1.f6a7a2955385ep1
  },
  { // Entry 1020
    -0x1.ffffffffffffd3e0a0804d19f0b472d3p-1,
    -0x1.f6a7a2955385ep1
  },
  { // Entry 1021
    0x1.00000000000029f05040268cfad64d79p0,
    0x1.f6a7a2955385fp1
  },
  { // Entry 1022
    -0x1.00000000000029f05040268cfad64d79p0,
    -0x1.f6a7a2955385fp1
  },
  { // Entry 1023
    0x1.a8410087262e3f41859fa73567f9244dp49,
    0x1.2d97c7f3321d1p2
  },
  { // Entry 1024
    -0x1.a8410087262e3f41859fa73567f9244dp49,
    -0x1.2d97c7f3321d1p2
  },
  { // Entry 1025
    0x1.3570efd76892340825e0124393554697p52,
    0x1.2d97c7f3321d2p2
  },
  { // Entry 1026
    -0x1.3570efd76892340825e0124393554697p52,
    -0x1.2d97c7f3321d2p2
  },
  { // Entry 1027
    -0x1.42c0d64d5de5178afe06452a1a1b8667p50,
    0x1.2d97c7f3321d3p2
  },
  { // Entry 1028
    0x1.42c0d64d5de5178afe06452a1a1b8667p50,
    -0x1.2d97c7f3321d3p2
  },
  { // Entry 1029
    -0x1.0000000000009ee2c2d963a13d57ec20p0,
    0x1.5fdbbe9bba774p2
  },
  { // Entry 1030
    0x1.0000000000009ee2c2d963a13d57ec20p0,
    -0x1.5fdbbe9bba774p2
  },
  { // Entry 1031
    -0x1.0000000000001ee2c2d963a10de68ab4p0,
    0x1.5fdbbe9bba775p2
  },
  { // Entry 1032
    0x1.0000000000001ee2c2d963a10de68ab4p0,
    -0x1.5fdbbe9bba775p2
  },
  { // Entry 1033
    -0x1.ffffffffffff3dc585b2c7423cea528ep-1,
    0x1.5fdbbe9bba776p2
  },
  { // Entry 1034
    0x1.ffffffffffff3dc585b2c7423cea528ep-1,
    -0x1.5fdbbe9bba776p2
  },
  { // Entry 1035
    0x1.fffffffffffeb094541a24624eeab0e1p-1,
    0x1.c463abeccb2bap2
  },
  { // Entry 1036
    -0x1.fffffffffffeb094541a24624eeab0e1p-1,
    -0x1.c463abeccb2bap2
  },
  { // Entry 1037
    0x1.ffffffffffffb094541a2461e734daeep-1,
    0x1.c463abeccb2bbp2
  },
  { // Entry 1038
    -0x1.ffffffffffffb094541a2461e734daeep-1,
    -0x1.c463abeccb2bbp2
  },
  { // Entry 1039
    0x1.000000000000584a2a0d1230ffbf827dp0,
    0x1.c463abeccb2bcp2
  },
  { // Entry 1040
    -0x1.000000000000584a2a0d1230ffbf827dp0,
    -0x1.c463abeccb2bcp2
  },
  { // Entry 1041
    0x1.7cc080f8958567f05c40ac5f6d310de8p49,
    0x1.f6a7a2955385dp2
  },
  { // Entry 1042
    -0x1.7cc080f8958567f05c40ac5f6d310de8p49,
    -0x1.f6a7a2955385dp2
  },
  { // Entry 1043
    0x1.735453027d7c3e702d73491de369536fp51,
    0x1.f6a7a2955385ep2
  },
  { // Entry 1044
    -0x1.735453027d7c3e702d73491de369536fp51,
    -0x1.f6a7a2955385ep2
  },
  { // Entry 1045
    -0x1.86aa4a3a127a3add9a8e76993733b4a7p50,
    0x1.f6a7a2955385fp2
  },
  { // Entry 1046
    0x1.86aa4a3a127a3add9a8e76993733b4a7p50,
    -0x1.f6a7a2955385fp2
  },
  { // Entry 1047
    -0x1.000000000001b088e90c77fe8051a7dap0,
    0x1.1475cc9eedeffp3
  },
  { // Entry 1048
    0x1.000000000001b088e90c77fe8051a7dap0,
    -0x1.1475cc9eedeffp3
  },
  { // Entry 1049
    -0x1.000000000000b088e90c77fd4fc8becep0,
    0x1.1475cc9eedfp3
  },
  { // Entry 1050
    0x1.000000000000b088e90c77fd4fc8becep0,
    -0x1.1475cc9eedfp3
  },
  { // Entry 1051
    -0x1.ffffffffffff6111d218effa3e7fab83p-1,
    0x1.1475cc9eedf01p3
  },
  { // Entry 1052
    0x1.ffffffffffff6111d218effa3e7fab83p-1,
    -0x1.1475cc9eedf01p3
  },
  { // Entry 1053
    -0x1.34f272993d1414a2b39bd837764c1608p-49,
    0x1.2d97c7f3321d1p3
  },
  { // Entry 1054
    0x1.34f272993d1414a2b39bd837764c1608p-49,
    -0x1.2d97c7f3321d1p3
  },
  { // Entry 1055
    -0x1.a79394c9e8a0a5159cdec1ba87ea5811p-52,
    0x1.2d97c7f3321d2p3
  },
  { // Entry 1056
    0x1.a79394c9e8a0a5159cdec1ba87ea5811p-52,
    -0x1.2d97c7f3321d2p3
  },
  { // Entry 1057
    0x1.961b1acd85d7d6ba98c84f9173b08d6fp-50,
    0x1.2d97c7f3321d3p3
  },
  { // Entry 1058
    -0x1.961b1acd85d7d6ba98c84f9173b08d6fp-50,
    -0x1.2d97c7f3321d3p3
  },
  { // Entry 1059
    0x1.fffffffffffc8d4807b3fbaccc38314bp-1,
    0x1.46b9c347764a2p3
  },
  { // Entry 1060
    -0x1.fffffffffffc8d4807b3fbaccc38314bp-1,
    -0x1.46b9c347764a2p3
  },
  { // Entry 1061
    0x1.fffffffffffe8d4807b3fbaa598038ffp-1,
    0x1.46b9c347764a3p3
  },
  { // Entry 1062
    -0x1.fffffffffffe8d4807b3fbaa598038ffp-1,
    -0x1.46b9c347764a3p3
  },
  { // Entry 1063
    0x1.00000000000046a403d9fdd4f3642059p0,
    0x1.46b9c347764a4p3
  },
  { // Entry 1064
    -0x1.00000000000046a403d9fdd4f3642059p0,
    -0x1.46b9c347764a4p3
  },
  { // Entry 1065
    0x1.9c78eea78baa6e13eccc94c421c4f5acp48,
    0x1.5fdbbe9bba774p3
  },
  { // Entry 1066
    -0x1.9c78eea78baa6e13eccc94c421c4f5acp48,
    -0x1.5fdbbe9bba774p3
  },
  { // Entry 1067
    0x1.093c3b4aebeb0806fbe4a1f0c660ba3bp51,
    0x1.5fdbbe9bba775p3
  },
  { // Entry 1068
    -0x1.093c3b4aebeb0806fbe4a1f0c660ba3bp51,
    -0x1.5fdbbe9bba775p3
  },
  { // Entry 1069
    -0x1.516ac961421855fb759fc2facb4e9f5bp49,
    0x1.5fdbbe9bba776p3
  },
  { // Entry 1070
    0x1.516ac961421855fb759fc2facb4e9f5bp49,
    -0x1.5fdbbe9bba776p3
  },
  { // Entry 1071
    -0x1.000000000001c22f0f3f8c5aa5a01da3p0,
    0x1.78fdb9effea45p3
  },
  { // Entry 1072
    0x1.000000000001c22f0f3f8c5aa5a01da3p0,
    -0x1.78fdb9effea45p3
  },
  { // Entry 1073
    -0x1.000000000000c22f0f3f8c5963710e64p0,
    0x1.78fdb9effea46p3
  },
  { // Entry 1074
    0x1.000000000000c22f0f3f8c5963710e64p0,
    -0x1.78fdb9effea46p3
  },
  { // Entry 1075
    -0x1.ffffffffffff845e1e7f18b24283fe49p-1,
    0x1.78fdb9effea47p3
  },
  { // Entry 1076
    0x1.ffffffffffff845e1e7f18b24283fe49p-1,
    -0x1.78fdb9effea47p3
  },
  { // Entry 1077
    0x1.fffffffffffc69fbbb4dd2f4fc88ffa1p-1,
    0x1.ab41b09886fe8p3
  },
  { // Entry 1078
    -0x1.fffffffffffc69fbbb4dd2f4fc88ffa1p-1,
    -0x1.ab41b09886fe8p3
  },
  { // Entry 1079
    0x1.fffffffffffe69fbbb4dd2f26684baeep-1,
    0x1.ab41b09886fe9p3
  },
  { // Entry 1080
    -0x1.fffffffffffe69fbbb4dd2f26684baeep-1,
    -0x1.ab41b09886fe9p3
  },
  { // Entry 1081
    0x1.00000000000034fddda6e978e8403b1ep0,
    0x1.ab41b09886feap3
  },
  { // Entry 1082
    -0x1.00000000000034fddda6e978e8403b1ep0,
    -0x1.ab41b09886feap3
  },
  { // Entry 1083
    0x1.86c4e333b3c9f6273896aba201767912p48,
    0x1.c463abeccb2bap3
  },
  { // Entry 1084
    -0x1.86c4e333b3c9f6273896aba201767912p48,
    -0x1.c463abeccb2bap3
  },
  { // Entry 1085
    0x1.9c96951f361845603280185a16d6026cp50,
    0x1.c463abeccb2bbp3
  },
  { // Entry 1086
    -0x1.9c96951f361845603280185a16d6026cp50,
    -0x1.c463abeccb2bbp3
  },
  { // Entry 1087
    -0x1.73244d369e0b6eb2f5d73cca7344e87ap49,
    0x1.c463abeccb2bcp3
  },
  { // Entry 1088
    0x1.73244d369e0b6eb2f5d73cca7344e87ap49,
    -0x1.c463abeccb2bcp3
  },
  { // Entry 1089
    -0x1.000000000001d3d53572a0b6cc261055p0,
    0x1.dd85a7410f58bp3
  },
  { // Entry 1090
    0x1.000000000001d3d53572a0b6cc261055p0,
    -0x1.dd85a7410f58bp3
  },
  { // Entry 1091
    -0x1.000000000000d3d53572a0b57850dae2p0,
    0x1.dd85a7410f58cp3
  },
  { // Entry 1092
    0x1.000000000000d3d53572a0b57850dae2p0,
    -0x1.dd85a7410f58cp3
  },
  { // Entry 1093
    -0x1.ffffffffffffa7aa6ae5416a48f74adfp-1,
    0x1.dd85a7410f58dp3
  },
  { // Entry 1094
    0x1.ffffffffffffa7aa6ae5416a48f74adfp-1,
    -0x1.dd85a7410f58dp3
  },
  { // Entry 1095
    -0x1.583ebeff65cc226480ae685c65352325p-49,
    0x1.f6a7a2955385dp3
  },
  { // Entry 1096
    0x1.583ebeff65cc226480ae685c65352325p-49,
    -0x1.f6a7a2955385dp3
  },
  { // Entry 1097
    -0x1.60fafbfd9730899202b9a170c8d54591p-51,
    0x1.f6a7a2955385ep3
  },
  { // Entry 1098
    0x1.60fafbfd9730899202b9a170c8d54591p-51,
    -0x1.f6a7a2955385ep3
  },
  { // Entry 1099
    0x1.4f8282013467bb36fea32f47a95641bap-50,
    0x1.f6a7a2955385fp3
  },
  { // Entry 1100
    -0x1.4f8282013467bb36fea32f47a95641bap-50,
    -0x1.f6a7a2955385fp3
  },
  { // Entry 1101
    0x1.fffffffffff846af6ee7aa48a1e9e9f7p-1,
    0x1.07e4cef4cbd96p4
  },
  { // Entry 1102
    -0x1.fffffffffff846af6ee7aa48a1e9e9f7p-1,
    -0x1.07e4cef4cbd96p4
  },
  { // Entry 1103
    0x1.fffffffffffc46af6ee7aa3d2f48c7c7p-1,
    0x1.07e4cef4cbd97p4
  },
  { // Entry 1104
    -0x1.fffffffffffc46af6ee7aa3d2f48c7c7p-1,
    -0x1.07e4cef4cbd97p4
  },
  { // Entry 1105
    0x1.0000000000002357b773d51cde53d2cbp0,
    0x1.07e4cef4cbd98p4
  },
  { // Entry 1106
    -0x1.0000000000002357b773d51cde53d2cbp0,
    -0x1.07e4cef4cbd98p4
  },
  { // Entry 1107
    0x1.2f0842389e5bc014d0fbe843cca6ddf3p47,
    0x1.1475cc9eedeffp4
  },
  { // Entry 1108
    -0x1.2f0842389e5bc014d0fbe843cca6ddf3p47,
    -0x1.1475cc9eedeffp4
  },
  { // Entry 1109
    0x1.733c4e8ef9c50cb5929f6bb674bec67fp48,
    0x1.1475cc9eedfp4
  },
  { // Entry 1110
    -0x1.733c4e8ef9c50cb5929f6bb674bec67fp48,
    -0x1.1475cc9eedfp4
  },
  { // Entry 1111
    -0x1.9c5b4c728989891dfb8710adf387843cp49,
    0x1.1475cc9eedf01p4
  },
  { // Entry 1112
    0x1.9c5b4c728989891dfb8710adf387843cp49,
    -0x1.1475cc9eedf01p4
  },
  { // Entry 1113
    -0x1.000000000002e57b5ba5b515595edb94p0,
    0x1.2106ca4910068p4
  },
  { // Entry 1114
    0x1.000000000002e57b5ba5b515595edb94p0,
    -0x1.2106ca4910068p4
  },
  { // Entry 1115
    -0x1.000000000000e57b5ba5b5118e682449p0,
    0x1.2106ca4910069p4
  },
  { // Entry 1116
    0x1.000000000000e57b5ba5b5118e682449p0,
    -0x1.2106ca4910069p4
  },
  { // Entry 1117
    -0x1.fffffffffffdcaf6b74b6a2386e2d9fbp-1,
    0x1.2106ca491006ap4
  },
  { // Entry 1118
    0x1.fffffffffffdcaf6b74b6a2386e2d9fbp-1,
    -0x1.2106ca491006ap4
  },
  { // Entry 1119
    -0x1.34f272993d1414a2b39bd837e6c96af0p-48,
    0x1.2d97c7f3321d1p4
  },
  { // Entry 1120
    0x1.34f272993d1414a2b39bd837e6c96af0p-48,
    -0x1.2d97c7f3321d1p4
  },
  { // Entry 1121
    -0x1.a79394c9e8a0a5159cdec1ba8c71f6bap-51,
    0x1.2d97c7f3321d2p4
  },
  { // Entry 1122
    0x1.a79394c9e8a0a5159cdec1ba8c71f6bap-51,
    -0x1.2d97c7f3321d2p4
  },
  { // Entry 1123
    0x1.961b1acd85d7d6ba98c84f91b390101fp-49,
    0x1.2d97c7f3321d3p4
  },
  { // Entry 1124
    -0x1.961b1acd85d7d6ba98c84f91b390101fp-49,
    -0x1.2d97c7f3321d3p4
  },
  { // Entry 1125
    0x1.fffffffffff82363228181911db144bap-1,
    0x1.3a28c59d54339p4
  },
  { // Entry 1126
    -0x1.fffffffffff82363228181911db144bap-1,
    -0x1.3a28c59d54339p4
  },
  { // Entry 1127
    0x1.fffffffffffc236322818185647789bdp-1,
    0x1.3a28c59d5433ap4
  },
  { // Entry 1128
    -0x1.fffffffffffc236322818185647789bdp-1,
    -0x1.3a28c59d5433ap4
  },
  { // Entry 1129
    0x1.00000000000011b19140c0c0d59ee760p0,
    0x1.3a28c59d5433bp4
  },
  { // Entry 1130
    -0x1.00000000000011b19140c0c0d59ee760p0,
    -0x1.3a28c59d5433bp4
  },
  { // Entry 1131
    0x1.28f934315e5eb9b45a603a5f788de131p47,
    0x1.46b9c347764a2p4
  },
  { // Entry 1132
    -0x1.28f934315e5eb9b45a603a5f788de131p47,
    -0x1.46b9c347764a2p4
  },
  { // Entry 1133
    0x1.618fdb7f21c13c236a4c4551ff139f5dp48,
    0x1.46b9c347764a3p4
  },
  { // Entry 1134
    -0x1.618fdb7f21c13c236a4c4551ff139f5dp48,
    -0x1.46b9c347764a3p4
  },
  { // Entry 1135
    -0x1.cfde61218ab9e79ffe8f046afdf00de3p49,
    0x1.46b9c347764a4p4
  },
  { // Entry 1136
    0x1.cfde61218ab9e79ffe8f046afdf00de3p49,
    -0x1.46b9c347764a4p4
  },
  { // Entry 1137
    -0x1.000000000002f72181d8c97193f9ee49p0,
    0x1.534ac0f19860bp4
  },
  { // Entry 1138
    0x1.000000000002f72181d8c97193f9ee49p0,
    -0x1.534ac0f19860bp4
  },
  { // Entry 1139
    -0x1.000000000000f72181d8c96da5b6ea98p0,
    0x1.534ac0f19860cp4
  },
  { // Entry 1140
    0x1.000000000000f72181d8c96da5b6ea98p0,
    -0x1.534ac0f19860cp4
  },
  { // Entry 1141
    -0x1.fffffffffffdee4303b192db6ee7cdcdp-1,
    0x1.534ac0f19860dp4
  },
  { // Entry 1142
    0x1.fffffffffffdee4303b192db6ee7cdcdp-1,
    -0x1.534ac0f19860dp4
  },
  { // Entry 1143
    -0x1.3dc585b2c742181326e07c412c24a052p-48,
    0x1.5fdbbe9bba774p4
  },
  { // Entry 1144
    0x1.3dc585b2c742181326e07c412c24a052p-48,
    -0x1.5fdbbe9bba774p4
  },
  { // Entry 1145
    -0x1.ee2c2d963a10c0993703e2045110595ep-51,
    0x1.5fdbbe9bba775p4
  },
  { // Entry 1146
    0x1.ee2c2d963a10c0993703e2045110595ep-51,
    -0x1.5fdbbe9bba775p4
  },
  { // Entry 1147
    0x1.8474f49a717bcfd9b23f077f38aafd2ap-49,
    0x1.5fdbbe9bba776p4
  },
  { // Entry 1148
    -0x1.8474f49a717bcfd9b23f077f38aafd2ap-49,
    -0x1.5fdbbe9bba776p4
  },
  { // Entry 1149
    0x1.fffffffffff80016d61b58d99be7994ep-1,
    0x1.6c6cbc45dc8dcp4
  },
  { // Entry 1150
    -0x1.fffffffffff80016d61b58d99be7994ep-1,
    -0x1.6c6cbc45dc8dcp4
  },
  { // Entry 1151
    0x1.fffffffffffc0016d61b58cd9c154585p-1,
    0x1.6c6cbc45dc8ddp4
  },
  { // Entry 1152
    -0x1.fffffffffffc0016d61b58cd9c154585p-1,
    -0x1.6c6cbc45dc8ddp4
  },
  { // Entry 1153
    0x1.000000000000000b6b0dac64ce2178ddp0,
    0x1.6c6cbc45dc8dep4
  },
  { // Entry 1154
    -0x1.000000000000000b6b0dac64ce2178ddp0,
    -0x1.6c6cbc45dc8dep4
  },
  { // Entry 1155
    0x1.2326f4e8f2bb180e5bf0417d75ea5d9ep47,
    0x1.78fdb9effea45p4
  },
  { // Entry 1156
    -0x1.2326f4e8f2bb180e5bf0417d75ea5d9ep47,
    -0x1.78fdb9effea45p4
  },
  { // Entry 1157
    0x1.517ea08708ba69da333a8c85f3bc6609p48,
    0x1.78fdb9effea46p4
  },
  { // Entry 1158
    -0x1.517ea08708ba69da333a8c85f3bc6609p48,
    -0x1.78fdb9effea46p4
  },
  { // Entry 1159
    -0x1.090b3d5161785ac2d31663f7e5d6bed4p50,
    0x1.78fdb9effea47p4
  },
  { // Entry 1160
    0x1.090b3d5161785ac2d31663f7e5d6bed4p50,
    -0x1.78fdb9effea47p4
  },
  { // Entry 1161
    -0x1.00000000000308c7a80bddcdcfcc7de7p0,
    0x1.858eb79a20baep4
  },
  { // Entry 1162
    0x1.00000000000308c7a80bddcdcfcc7de7p0,
    -0x1.858eb79a20baep4
  },
  { // Entry 1163
    -0x1.00000000000108c7a80bddc9be3d2dcfp0,
    0x1.858eb79a20bafp4
  },
  { // Entry 1164
    0x1.00000000000108c7a80bddc9be3d2dcfp0,
    -0x1.858eb79a20bafp4
  },
  { // Entry 1165
    -0x1.fffffffffffe118f5017bb93595bbb6fp-1,
    0x1.858eb79a20bb0p4
  },
  { // Entry 1166
    0x1.fffffffffffe118f5017bb93595bbb6fp-1,
    -0x1.858eb79a20bb0p4
  },
  { // Entry 1167
    -0x1.af0792001f856335a38010a6a6832e6bp2,
    0x1.fffffffffffffp62
  },
  { // Entry 1168
    0x1.af0792001f856335a38010a6a6832e6bp2,
    -0x1.fffffffffffffp62
  },
  { // Entry 1169
    0x1.52f50e757941cbff5b7c2e06a1ab7e9dp6,
    0x1.0p63
  },
  { // Entry 1170
    -0x1.52f50e757941cbff5b7c2e06a1ab7e9dp6,
    -0x1.0p63
  },
  { // Entry 1171
    0x1.7570667d032eca8ef780ad59d3e27e4bp1,
    0x1.0000000000001p63
  },
  { // Entry 1172
    -0x1.7570667d032eca8ef780ad59d3e27e4bp1,
    -0x1.0000000000001p63
  },
  { // Entry 1173
    -0x1.2e8fc248e7b854fe5c2dc9d287de0cd3p0,
    0x1.fffffffffffffp26
  },
  { // Entry 1174
    0x1.2e8fc248e7b854fe5c2dc9d287de0cd3p0,
    -0x1.fffffffffffffp26
  },
  { // Entry 1175
    -0x1.2e8fc1af81d8baa8899a3325200c0dcbp0,
    0x1.0p27
  },
  { // Entry 1176
    0x1.2e8fc1af81d8baa8899a3325200c0dcbp0,
    -0x1.0p27
  },
  { // Entry 1177
    -0x1.2e8fc07cb61a95ef5e5d8d6416652c7ap0,
    0x1.0000000000001p27
  },
  { // Entry 1178
    0x1.2e8fc07cb61a95ef5e5d8d6416652c7ap0,
    -0x1.0000000000001p27
  },
  { // Entry 1179
    -0x1.3ea282860e7fbe1765607c2fdb32481fp0,
    0x1.fffffffffffffp23
  },
  { // Entry 1180
    0x1.3ea282860e7fbe1765607c2fdb32481fp0,
    -0x1.fffffffffffffp23
  },
  { // Entry 1181
    -0x1.3ea28271a9bea36e744f9ce537ba4b59p0,
    0x1.0p24
  },
  { // Entry 1182
    0x1.3ea28271a9bea36e744f9ce537ba4b59p0,
    -0x1.0p24
  },
  { // Entry 1183
    -0x1.3ea28248e03c72def70e7efb4c43f03ep0,
    0x1.0000000000001p24
  },
  { // Entry 1184
    0x1.3ea28248e03c72def70e7efb4c43f03ep0,
    -0x1.0000000000001p24
  },
  { // Entry 1185
    0x1.2866f9be4de0ec27efa9049ab80bbd6cp0,
    0x1.fffffffffffffp1
  },
  { // Entry 1186
    -0x1.2866f9be4de0ec27efa9049ab80bbd6cp0,
    -0x1.fffffffffffffp1
  },
  { // Entry 1187
    0x1.2866f9be4de1370db9078607012cb07bp0,
    0x1.0p2
  },
  { // Entry 1188
    -0x1.2866f9be4de1370db9078607012cb07bp0,
    -0x1.0p2
  },
  { // Entry 1189
    0x1.2866f9be4de1ccd94bc488dfd47873afp0,
    0x1.0000000000001p2
  },
  { // Entry 1190
    -0x1.2866f9be4de1ccd94bc488dfd47873afp0,
    -0x1.0000000000001p2
  },
  { // Entry 1191
    -0x1.17af62e0950fb1e701c642ef8737f516p1,
    0x1.fffffffffffffp0
  },
  { // Entry 1192
    0x1.17af62e0950fb1e701c642ef8737f516p1,
    -0x1.fffffffffffffp0
  },
  { // Entry 1193
    -0x1.17af62e0950f83b5099087aaf67af9c1p1,
    0x1.0p1
  },
  { // Entry 1194
    0x1.17af62e0950f83b5099087aaf67af9c1p1,
    -0x1.0p1
  },
  { // Entry 1195
    -0x1.17af62e0950f275119251121fadb17bap1,
    0x1.0000000000001p1
  },
  { // Entry 1196
    0x1.17af62e0950f275119251121fadb17bap1,
    -0x1.0000000000001p1
  },
  { // Entry 1197
    0x1.8eb245cbee3a40235613e7575020d30dp0,
    0x1.fffffffffffffp-1
  },
  { // Entry 1198
    -0x1.8eb245cbee3a40235613e7575020d30dp0,
    -0x1.fffffffffffffp-1
  },
  { // Entry 1199
    0x1.8eb245cbee3a5b8acc7d41323140b3b5p0,
    0x1.0p0
  },
  { // Entry 1200
    -0x1.8eb245cbee3a5b8acc7d41323140b3b5p0,
    -0x1.0p0
  },
  { // Entry 1201
    0x1.8eb245cbee3a9259b94ff4e7fb8111ecp0,
    0x1.0000000000001p0
  },
  { // Entry 1202
    -0x1.8eb245cbee3a9259b94ff4e7fb8111ecp0,
    -0x1.0000000000001p0
  },
  { // Entry 1203
    0x1.17b4f5bf347499ce41855dee4344bd1dp-1,
    0x1.fffffffffffffp-2
  },
  { // Entry 1204
    -0x1.17b4f5bf347499ce41855dee4344bd1dp-1,
    -0x1.fffffffffffffp-2
  },
  { // Entry 1205
    0x1.17b4f5bf3474a4317964807882444cc8p-1,
    0x1.0p-1
  },
  { // Entry 1206
    -0x1.17b4f5bf3474a4317964807882444cc8p-1,
    -0x1.0p-1
  },
  { // Entry 1207
    0x1.17b4f5bf3474b8f7e922c58d00cb9dd2p-1,
    0x1.0000000000001p-1
  },
  { // Entry 1208
    -0x1.17b4f5bf3474b8f7e922c58d00cb9dd2p-1,
    -0x1.0000000000001p-1
  },
  { // Entry 1209
    0x1.05785a43c4c555de0cb1371f10db31afp-2,
    0x1.fffffffffffffp-3
  },
  { // Entry 1210
    -0x1.05785a43c4c555de0cb1371f10db31afp-2,
    -0x1.fffffffffffffp-3
  },
  { // Entry 1211
    0x1.05785a43c4c55e63940188965c28bd0fp-2,
    0x1.0p-2
  },
  { // Entry 1212
    -0x1.05785a43c4c55e63940188965c28bd0fp-2,
    -0x1.0p-2
  },
  { // Entry 1213
    0x1.05785a43c4c56f6ea2a22b84f2ddf03fp-2,
    0x1.0000000000001p-2
  },
  { // Entry 1214
    -0x1.05785a43c4c56f6ea2a22b84f2ddf03fp-2,
    -0x1.0000000000001p-2
  },
  { // Entry 1215
    0x1.01577af1511a45e403dd60c8d82590d0p-3,
    0x1.fffffffffffffp-4
  },
  { // Entry 1216
    -0x1.01577af1511a45e403dd60c8d82590d0p-3,
    -0x1.fffffffffffffp-4
  },
  { // Entry 1217
    0x1.01577af1511a4e0459f5b872d4ff34fdp-3,
    0x1.0p-3
  },
  { // Entry 1218
    -0x1.01577af1511a4e0459f5b872d4ff34fdp-3,
    -0x1.0p-3
  },
  { // Entry 1219
    0x1.01577af1511a5e45062667c6ceb89dc4p-3,
    0x1.0000000000001p-3
  },
  { // Entry 1220
    -0x1.01577af1511a5e45062667c6ceb89dc4p-3,
    -0x1.0000000000001p-3
  },
  { // Entry 1221
    0x1.005577854df0002a8e6606f6c618d988p-4,
    0x1.fffffffffffffp-5
  },
  { // Entry 1222
    -0x1.005577854df0002a8e6606f6c618d988p-4,
    -0x1.fffffffffffffp-5
  },
  { // Entry 1223
    0x1.005577854df0083293be639057b0c681p-4,
    0x1.0p-4
  },
  { // Entry 1224
    -0x1.005577854df0083293be639057b0c681p-4,
    -0x1.0p-4
  },
  { // Entry 1225
    0x1.005577854df018429e6f1cc37ae22274p-4,
    0x1.0000000000001p-4
  },
  { // Entry 1226
    -0x1.005577854df018429e6f1cc37ae22274p-4,
    -0x1.0000000000001p-4
  },
  { // Entry 1227
    0x1.00155777aec07d7b22741d12ee53a9fcp-5,
    0x1.fffffffffffffp-6
  },
  { // Entry 1228
    -0x1.00155777aec07d7b22741d12ee53a9fcp-5,
    -0x1.fffffffffffffp-6
  },
  { // Entry 1229
    0x1.00155777aec0857d22c97e809860288dp-5,
    0x1.0p-5
  },
  { // Entry 1230
    -0x1.00155777aec0857d22c97e809860288dp-5,
    -0x1.0p-5
  },
  { // Entry 1231
    0x1.00155777aec095812374415bec7985cep-5,
    0x1.0000000000001p-5
  },
  { // Entry 1232
    -0x1.00155777aec095812374415bec7985cep-5,
    -0x1.0000000000001p-5
  },
  { // Entry 1233
    0x1.00055577785482e135f0afeebe805adbp-6,
    0x1.fffffffffffffp-7
  },
  { // Entry 1234
    -0x1.00055577785482e135f0afeebe805adbp-6,
    -0x1.fffffffffffffp-7
  },
  { // Entry 1235
    0x1.0005557778548ae1b5f60574706e8238p-6,
    0x1.0p-6
  },
  { // Entry 1236
    -0x1.0005557778548ae1b5f60574706e8238p-6,
    -0x1.0p-6
  },
  { // Entry 1237
    0x1.0005557778549ae2b600b07fd44ae8f3p-6,
    0x1.0000000000001p-6
  },
  { // Entry 1238
    -0x1.0005557778549ae2b600b07fd44ae8f3p-6,
    -0x1.0000000000001p-6
  },
  { // Entry 1239
    0x1.0000000555554d777776f854854304c9p-14,
    0x1.fffffffffffffp-15
  },
  { // Entry 1240
    -0x1.0000000555554d777776f854854304c9p-14,
    -0x1.fffffffffffffp-15
  },
  { // Entry 1241
    0x1.00000005555555777777785485485a1ep-14,
    0x1.0p-14
  },
  { // Entry 1242
    -0x1.00000005555555777777785485485a1ep-14,
    -0x1.0p-14
  },
  { // Entry 1243
    0x1.000000055555657777787854855304c9p-14,
    0x1.0000000000001p-14
  },
  { // Entry 1244
    -0x1.000000055555657777787854855304c9p-14,
    -0x1.0000000000001p-14
  },
  { // Entry 1245
    0x1.fffffffffffff2aaaaaaaaaaaa6eeeeep-28,
    0x1.fffffffffffffp-28
  },
  { // Entry 1246
    -0x1.fffffffffffff2aaaaaaaaaaaa6eeeeep-28,
    -0x1.fffffffffffffp-28
  },
  { // Entry 1247
    0x1.00000000000001555555555555577777p-27,
    0x1.0p-27
  },
  { // Entry 1248
    -0x1.00000000000001555555555555577777p-27,
    -0x1.0p-27
  },
  { // Entry 1249
    0x1.00000000000011555555555555977777p-27,
    0x1.0000000000001p-27
  },
  { // Entry 1250
    -0x1.00000000000011555555555555977777p-27,
    -0x1.0000000000001p-27
  },
  { // Entry 1251
    0x1.fffffffffffff00aaaaaaaaaaaa9aaeep-31,
    0x1.fffffffffffffp-31
  },
  { // Entry 1252
    -0x1.fffffffffffff00aaaaaaaaaaaa9aaeep-31,
    -0x1.fffffffffffffp-31
  },
  { // Entry 1253
    0x1.00000000000000055555555555555577p-30,
    0x1.0p-30
  },
  { // Entry 1254
    -0x1.00000000000000055555555555555577p-30,
    -0x1.0p-30
  },
  { // Entry 1255
    0x1.00000000000010055555555555565577p-30,
    0x1.0000000000001p-30
  },
  { // Entry 1256
    -0x1.00000000000010055555555555565577p-30,
    -0x1.0000000000001p-30
  },
  { // Entry 1257
    0x1.4530cfe729483b8da1f7101e16cd74b7p-8,
    -0x1.fffffffffffffp1023
  },
  { // Entry 1258
    -0x1.4530cfe729483b8da1f7101e16cd74b7p-8,
    0x1.fffffffffffffp1023
  },
  { // Entry 1259
    -0x1.4530cfe729483b8da1f7101e16cd74b7p-8,
    0x1.fffffffffffffp1023
  },
  { // Entry 1260
    0x1.4530cfe729483b8da1f7101e16cd74b7p-8,
    -0x1.fffffffffffffp1023
  },
  { // Entry 1261
    -0x1.4530cfe729483b8da1f7101e16cd74b7p-8,
    0x1.fffffffffffffp1023
  },
  { // Entry 1262
    0x1.4530cfe729483b8da1f7101e16cd74b7p-8,
    -0x1.fffffffffffffp1023
  },
  { // Entry 1263
    0x1.3c6e9970f78b84fc8227517fd521017bp1,
    0x1.ffffffffffffep1023
  },
  { // Entry 1264
    -0x1.3c6e9970f78b84fc8227517fd521017bp1,
    -0x1.ffffffffffffep1023
  },
  { // Entry 1265
    -0x1.1a62633145c06e0e689481270461d5d7p-53,
    0x1.921fb54442d18p1
  },
  { // Entry 1266
    0x1.1a62633145c06e0e689481270461d5d7p-53,
    -0x1.921fb54442d18p1
  },
  { // Entry 1267
    0x1.d02967c31cdb4e0c38d01b655d5e0aafp53,
    0x1.921fb54442d18p0
  },
  { // Entry 1268
    -0x1.d02967c31cdb4e0c38d01b655d5e0aafp53,
    -0x1.921fb54442d18p0
  },
  { // Entry 1269
    0x1.8eb245cbee3a9259b94ff4e7fb8111ecp0,
    0x1.0000000000001p0
  },
  { // Entry 1270
    -0x1.8eb245cbee3a9259b94ff4e7fb8111ecp0,
    -0x1.0000000000001p0
  },
  { // Entry 1271
    0x1.8eb245cbee3a5b8acc7d41323140b3b5p0,
    0x1.0p0
  },
  { // Entry 1272
    -0x1.8eb245cbee3a5b8acc7d41323140b3b5p0,
    -0x1.0p0
  },
  { // Entry 1273
    0x1.8eb245cbee3a40235613e7575020d30dp0,
    0x1.fffffffffffffp-1
  },
  { // Entry 1274
    -0x1.8eb245cbee3a40235613e7575020d30dp0,
    -0x1.fffffffffffffp-1
  },
  { // Entry 1275
    0x1.fffffffffffff72cece675d1fca30489p-1,
    0x1.921fb54442d18p-1
  },
  { // Entry 1276
    -0x1.fffffffffffff72cece675d1fca30489p-1,
    -0x1.921fb54442d18p-1
  },
  { // Entry 1277
    0x1.00000000000010p-1022,
    0x1.0000000000001p-1022
  },
  { // Entry 1278
    -0x1.00000000000010p-1022,
    -0x1.0000000000001p-1022
  },
  { // Entry 1279
    0x1.p-1022,
    0x1.0p-1022
  },
  { // Entry 1280
    -0x1.p-1022,
    -0x1.0p-1022
  },
  { // Entry 1281
    0x1.ffffffffffffe0p-1023,
    0x1.ffffffffffffep-1023
  },
  { // Entry 1282
    -0x1.ffffffffffffe0p-1023,
    -0x1.ffffffffffffep-1023
  },
  { // Entry 1283
    0x1.ffffffffffffc0p-1023,
    0x1.ffffffffffffcp-1023
  },
  { // Entry 1284
    -0x1.ffffffffffffc0p-1023,
    -0x1.ffffffffffffcp-1023
  },
  { // Entry 1285
    0x1.p-1073,
    0x1.0p-1073
  },
  { // Entry 1286
    -0x1.p-1073,
    -0x1.0p-1073
  },
  { // Entry 1287
    0x1.p-1074,
    0x1.0p-1074
  },
  { // Entry 1288
    -0x1.p-1074,
    -0x1.0p-1074
  },
  { // Entry 1289
    0.0,
    0.0
  },
  { // Entry 1290
    -0.0,
    -0.0
  },
};
#endif // __BIONIC__

TEST(math_tan, tan_intel) {
#if defined(__BIONIC__)
  fesetenv(FE_DFL_ENV);
  for (size_t i = 0; i < sizeof(g_tan_intel_data)/sizeof(tan_intel_data_t); i++) {
    EXPECT_DOUBLE_EQ(g_tan_intel_data[i].expected, tan(g_tan_intel_data[i].call_data)) << "Failed on element " << i;
  }
#else // __BIONIC__
  GTEST_LOG_(INFO) << "This test does nothing.";
#endif // __BIONIC__
}
