/*
 * Copyright (C) 2018 The Android Open Source Project
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

// Reduced trace based on 2.3 billion samples extracted from specpu2017
// 521.wrf_r benchmark.
static const std::vector<std::pair<float, float>> powf_input = {
  {0x1.00daap+0, 0x1.249236p-2},
  {0x1.3e510ap-4, 0x1.19999ap+0},
  {0x1.66c872p-3, 0x1.666666p+0},
  {0x1.897858p+1, 0x1.19999ap+0},
  {0x1.a6efc4p-2, 0x1.666666p+0},
  {0x1.3fc088p+8, 0x1.51eb86p-2},
  {0x1.03e8bcp-1, 0x1.666666p+0},
  {0x1.3f0094p+10, 0x1.51eb86p-2},
  {0x1.f6c41ep-1, 0x1.249236p-2},
  {0x1.3880bap+12, 0x1.19999ap+0},
  {0x1.003a1p+0, 0x1.d1746p-1},
  {0x1.391bc6p-2, 0x1.19999ap+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.0005c4p+0, 0x1.51eb86p-2},
  {0x1.7800b4p+8, 0x1.51eb86p-2},
  {0x1.06db5p-3, 0x1.666666p+0},
  {0x1.6e98b2p+5, 0x1.51eb86p-2},
  {0x1.8c241cp-1, 0x1.249236p-2},
  {0x1.970124p+3, 0x1.51eb86p-2},
  {0x1.9dadfcp-3, 0x1.666666p+0},
  {0x1.8700f8p+4, 0x1.51eb86p-2},
  {0x1.a3269ep-2, 0x1.666666p+0},
  {0x1.00258ep+0, 0x1.d1746p-1},
  {0x1.e80102p+6, 0x1.d1746p-1},
  {0x1.000d5ep+0, 0x1.51eb86p-2},
  {0x1.3f4104p+9, 0x1.51eb86p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.e7e468p+6, 0x1.d1746p-1},
  {0x1.ef66e8p-1, 0x1.249236p-2},
  {0x1.778238p+9, 0x1.51eb86p-2},
  {0x1.9a0caep-1, 0x1.249236p-2},
  {0x1.00013ep+0, 0x1.99999ap-2},
  {0x1.5ae57ap-1, 0x1.666666p+0},
  {0x1.3e4dcap+11, 0x1.19999ap+0},
  {0x1.97e8acp-1, 0x1.666666p+0},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.0dd4ccp+5, 0x1.19999ap+0},
  {0x1.60dfdep-3, 0x1.19999ap+0},
  {0x1.c99286p-4, 0x1.19999ap+0},
  {0x1.0001d6p+0, 0x1.51eb86p-2},
  {0x1.917594p+5, 0x1.51eb86p-2},
  {0x1.3c751cp-1, 0x1.666666p+0},
  {0x1.318c4cp+0, 0x1.51eb86p-2},
  {0x1.d25376p-1, 0x1.249236p-2},
  {0x1.ad4ddep+15, 0x1.d1746p-1},
  {0x1.ce1da8p-2, 0x1.666666p+0},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.d4a4f4p-1, 0x1.666666p+0},
  {0x1.058d04p+5, 0x1.d1746p-1},
  {0x1.607416p+6, 0x1.99999ap-2},
  {0x1.000326p+0, 0x1.51eb86p-2},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.bca0c2p-2, 0x1.249236p-2},
  {0x1.3b4dcep-3, 0x1.19999ap+0},
  {0x1.3fd0dp-12, 0x1.4f5c28p+0},
  {0x1.3e6644p-1, 0x1.19999ap+0},
  {0x1.656bcap-3, 0x1.666666p+0},
  {0x1.018384p+0, 0x1.d1746p-1},
  {0x1.959ba2p-1, 0x1.666666p+0},
  {0x1.46c044p+5, 0x1.51eb86p-2},
  {0x1.321426p-1, 0x1.d51eb8p+2},
  {0x1.001606p+0, 0x1.d1746p-1},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.391dbep+7, 0x1.19999ap+0},
  {0x1.00001p+0, 0x1.99999ap-2},
  {0x1.9787aep-1, 0x1.666666p+0},
  {0x1.00112cp+0, 0x1.51eb86p-2},
  {0x1.6738a4p-3, 0x1.666666p+0},
  {0x1.42367cp+8, 0x1.51eb86p-2},
  {0x1.2eafeep-2, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.0a95p-2, 0x1.666666p+0},
  {0x1.5dedaep+0, 0x1.51eb86p-2},
  {0x1.98ebaap-1, 0x1.666666p+0},
  {0x1.5debb8p+0, 0x1.51eb86p-2},
  {0x1.1a21fap+0, 0x1.249236p-2},
  {0x1p+0, 0x1.d1746p-1},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.05c316p+0, 0x1.51eb86p-2},
  {0x1.bf03bap+4, 0x1.99999ap-2},
  {0x1.bea6ap-1, 0x1.249236p-2},
  {0x1.382992p+33, 0x1.99999ap-2},
  {0x1.8aa716p-2, 0x1.249236p-2},
  {0x1.0009b4p+0, 0x1.51eb86p-2},
  {0x1.fa4b76p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.66afccp-4, 0x1.249236p-2},
  {0x1.001908p+0, 0x1.51eb86p-2},
  {0x1.9aa4fcp-3, 0x1.666666p+0},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.381eeep-1, 0x1.666666p+0},
  {0x1.00169cp+0, 0x1.d1746p-1},
  {0x1.075e64p-3, 0x1.666666p+0},
  {0x1.3e17f4p+2, 0x1.19999ap+0},
  {0x1.60d52p-2, 0x1.b51eb8p+3},
  {0x1.1ba56ap+9, 0x1.d1746p-1},
  {0x1.011d04p+0, 0x1.51eb86p-2},
  {0x1.0d5beep+0, 0x1.51eb86p-2},
  {0x1.348b22p+0, 0x1.d1746p-1},
  {0x1.0067fp+0, 0x1.51eb86p-2},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.ceca68p-1, 0x1.249236p-2},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.2ce5b4p-2, 0x1.666666p+0},
  {0x1.0ea8a8p+2, 0x1.d1746p-1},
  {0x1.25eedcp-2, 0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.ab0c24p-1, 0x1.666666p+0},
  {0x1.aa822p-9, 0x1.19999ap+0},
  {0x1.f667d8p-1, 0x1.666666p+0},
  {0x1.77106p+12, 0x1.51eb86p-2},
  {0x1.2b18dap-2, 0x1.666666p+0},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.833312p-1, 0x1.af5c28p+2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.a53368p+15, 0x1.d1746p-1},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.e075fep+18, 0x1.99999ap-2},
  {0x1.036976p-3, 0x1.249236p-2},
  {0x1.5f2a72p+3, 0x1.19999ap+0},
  {0x1.06c764p-3, 0x1.666666p+0},
  {0x1.000064p+0, 0x1.99999ap-2},
  {0x1.528912p-2, 0x1.666666p+0},
  {0x1.3b34bp+12, 0x1.19999ap+0},
  {0x1.a3941p-1, 0x1.249236p-2},
  {0x1.6c61dp+21, 0x1.99999ap-2},
  {0x1.042ce4p-1, 0x1.666666p+0},
  {0x1.004d34p+0, 0x1.51eb86p-2},
  {0x1.d61ed6p-3, 0x1.666666p+0},
  {0x1.4c0832p-3, 0x1.19999ap+0},
  {0x1.9029aep-8, 0x1.19999ap+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.000032p+0, 0x1.99999ap-2},
  {0x1.d7c4dap+2, 0x1.19999ap+0},
  {0x1.102a24p+0, 0x1.51eb86p-2},
  {0x1.0149d8p+0, 0x1.51eb86p-2},
  {0x1.61be2cp-4, 0x1.249236p-2},
  {0x1.905a2ep+1, 0x1.d1746p-1},
  {0x1.d4d4ccp-2, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.baed36p-1, 0x1.249236p-2},
  {0x1.0001b4p+0, 0x1.51eb86p-2},
  {0x1.bad278p-1, 0x1.249236p-2},
  {0x1.03ccf2p+0, 0x1.51eb86p-2},
  {0x1.fe2974p-1, 0x1.666666p+0},
  {0x1.3ec326p+15, 0x1.51eb86p-2},
  {0x1.1b7b08p-1, 0x1.666666p+0},
  {0x1.3e5ddap+8, 0x1.19999ap+0},
  {0x1.fe95fap-1, 0x1.666666p+0},
  {0x1.ae340ap+2, 0x1.d1746p-1},
  {0x1.9a18bep-1, 0x1.af5c28p+2},
  {0x1.005436p+0, 0x1.51eb86p-2},
  {0x1p+0, 0x1.99999ap-2},
  {0x0p+0, 0x1.19999ap+0},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.9701eap+3, 0x1.51eb86p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.febf22p-3, 0x1.249236p-2},
  {0x1.0a0408p+0, 0x1.51eb86p-2},
  {0x1.f8a58cp-1, 0x1.666666p+0},
  {0x1.300fd2p+10, 0x1.d1746p-1},
  {0x1.b36cep-3, 0x1.249236p-2},
  {0x1.7ebcc4p+9, 0x1.51eb86p-2},
  {0x1.091cd2p-2, 0x1.666666p+0},
  {0x1.a79de6p+3, 0x1.51eb86p-2},
  {0x1.f80b88p-1, 0x1.666666p+0},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.959c06p-1, 0x1.666666p+0},
  {0x1.7f668p+2, 0x1.51eb86p-2},
  {0x1.2f8fbcp+0, 0x1.23bc4ep-2},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.cb633ep+5, 0x1.d1746p-1},
  {0x1.00a30ep+0, 0x1.d1746p-1},
  {0x1.55ab4cp+0, 0x1.d1746p-1},
  {0x1.0001d6p+0, 0x1.51eb86p-2},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.866e44p-1, 0x1.249236p-2},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.a67a1p-1, 0x1.666666p+0},
  {0x1.fbc1cep-1, 0x1.249236p-2},
  {0x1.b46e4cp-3, 0x1.249236p-2},
  {0x1.127514p+5, 0x1.51eb86p-2},
  {0x1.53c42ap-2, 0x1.666666p+0},
  {0x1.12018ap-8, 0x1.19999ap+0},
  {0x1.c821f2p-1, 0x1.666666p+0},
  {0x1.21086p+0, 0x1.d1746p-1},
  {0x1.7c3654p-2, 0x1.666666p+0},
  {0x1.2a0884p+28, 0x1.99999ap-2},
  {0x1.04f7cap+0, 0x1.249236p-2},
  {0x1.70344cp+0, 0x1.99999ap-2},
  {0x1.83fbfp+1, 0x1.d1746p-1},
  {0x1.c1131p+4, 0x1.451eb8p-1},
  {0x1.0004a8p+0, 0x1.51eb86p-2},
  {0x1.e0678cp-1, 0x1.666666p+0},
  {0x1.6a9884p+6, 0x1.51eb86p-2},
  {0x1.a42742p-1, 0x1.249236p-2},
  {0x1.2c396p+8, 0x1.99999ap-2},
  {0x1.d0c6f8p-1, 0x1.249236p-2},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.fa604ep-2, 0x1.249236p-2},
  {0x1.9de0b4p+0, 0x1.51eb86p-2},
  {0x1.8d5066p-2, 0x1.249236p-2},
  {0x1.00001p+0, 0x1.99999ap-2},
  {0x1.03f9e8p+0, 0x1.51eb86p-2},
  {0x1.0a392ep+0, 0x1.d1746p-1},
  {0x1.000acp+0, 0x1.51eb86p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.000c42p+0, 0x1.51eb86p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.000368p+0, 0x1.51eb86p-2},
  {0x1.c4bed8p+1, 0x1.51eb86p-2},
  {0x1.391a6p+9, 0x1.19999ap+0},
  {0x1.c641ep+18, 0x1.99999ap-2},
  {0x1.01ebb8p+0, 0x1.51eb86p-2},
  {0x1.272b24p-1, 0x1.70a3d8p+3},
  {0x1.5f7c02p+0, 0x1.51eb86p-2},
  {0x1.d86552p-3, 0x1.666666p+0},
  {0x1.0b5696p+0, 0x1.51eb86p-2},
  {0x1.74fdbp-2, 0x1.666666p+0},
  {0x1.0003bcp+0, 0x1.51eb86p-2},
  {0x1.eac86p-1, 0x1.666666p+0},
  {0x1.a57cd6p+15, 0x1.99999ap-2},
  {0x1.53b602p-2, 0x1.666666p+0},
  {0x1.4dfbe8p+0, 0x1.99999ap-2},
  {0x1.a79aaep-2, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.3cc9eap-1, 0x1.666666p+0},
  {0x1.00016p+0, 0x1.51eb86p-2},
  {0x1.c5c466p-2, 0x1.666666p+0},
  {0x1.071a4cp+0, 0x1.d1746p-1},
  {0x1.9d81f2p-3, 0x1.666666p+0},
  {0x1.c1286cp+1, 0x1.51eb86p-2},
  {0x1.67c06ep-3, 0x1.666666p+0},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.211b6p-1, 0x1.666666p+0},
  {0x1.57f68p+0, 0x1.51eb86p-2},
  {0x1.fc6412p-1, 0x1.666666p+0},
  {0x1.79009p+7, 0x1.51eb86p-2},
  {0x1.573472p-2, 0x1.249236p-2},
  {0x1.bb80ecp+0, 0x1.51eb86p-2},
  {0x1.65a576p-3, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.e6fe2ep-1, 0x1.249236p-2},
  {0x1.3ed034p+12, 0x1.51eb86p-2},
  {0x1.d002e2p-5, 0x1.249236p-2},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.fb24a6p-2, 0x1.249236p-2},
  {0x1.070f4ap+0, 0x1.d1746p-1},
  {0x1.0624dep-11, 0x1.4f5c28p+0},
  {0x1.46ded2p+7, 0x1.51eb86p-2},
  {0x1.7b95a2p-12, 0x1.a3d70ap-2},
  {0x1.37fb26p+0, 0x1.99999ap-2},
  {0x1.e6696ap-1, 0x1.249236p-2},
  {0x1.000852p+0, 0x1.51eb86p-2},
  {0x1.1f26dp-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.50f474p-1, 0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.f91be6p-1, 0x1.249236p-2},
  {0x1.006b38p+0, 0x1.99999ap-2},
  {0x1.d402d2p-3, 0x1.666666p+0},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.74810ap-1, 0x1.666666p+0},
  {0x1.87002ap+4, 0x1.51eb86p-2},
  {0x1.544decp-1, 0x1.249236p-2},
  {0x1.188bp+0, 0x1.51eb86p-2},
  {0x1.fb9p-1, 0x1.666666p+0},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.1b393ap-1, 0x1.666666p+0},
  {0x1.a8e8ecp+3, 0x1.d1746p-1},
  {0x1.7b002cp+6, 0x1.51eb86p-2},
  {0x1.e6206ep+5, 0x1.51eb86p-2},
  {0x1.3ab324p+1, 0x1.19999ap+0},
  {0x1.8d48ccp-2, 0x1.666666p+0},
  {0x1.711948p-17, 0x1.19999ap+0},
  {0x1.a2e48ep-2, 0x1.666666p+0},
  {0x1.0016bep+0, 0x1.51eb86p-2},
  {0x1.095422p-2, 0x1.666666p+0},
  {0x1.00c0ep+0, 0x1.51eb86p-2},
  {0x1.f68858p-1, 0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.eb630ap-1, 0x1.666666p+0},
  {0x1.f1a0aap+4, 0x1.51eb86p-2},
  {0x1.f98266p+0, 0x1.51eb86p-2},
  {0x1.4ec144p+4, 0x1.51eb86p-2},
  {0x1.5f88fcp-10, 0x1.19999ap+0},
  {0x1.10cbcp+0, 0x1.236e72p-2},
  {0x1.7eead2p+8, 0x1.51eb86p-2},
  {0x1.0b3312p-2, 0x1.666666p+0},
  {0x1.037a8p+0, 0x1.51eb86p-2},
  {0x1.3b3d08p-1, 0x1.666666p+0},
  {0x1.1ce79ap+0, 0x1.51eb86p-2},
  {0x1.82fcfp-1, 0x1.249236p-2},
  {0x1.41c992p+9, 0x1.51eb86p-2},
  {0x1.eb6bd2p-1, 0x1.666666p+0},
  {0x1.01f2ccp+0, 0x1.51eb86p-2},
  {0x1.05cabp-1, 0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.77114cp+12, 0x1.51eb86p-2},
  {0x1.4a0e62p-1, 0x1.b51eb8p+3},
  {0x1.7c5b96p+6, 0x1.51eb86p-2},
  {0x1.36d0b4p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.03bc2cp-1, 0x1.666666p+0},
  {0x1.1db456p+0, 0x1.51eb86p-2},
  {0x1.65f41ap-3, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.79fd36p-1, 0x1.666666p+0},
  {0x1.9e712ep+4, 0x1.51eb86p-2},
  {0x1.f31f46p-14, 0x1.a3d70ap-2},
  {0x1.4f0d9ap+4, 0x1.51eb86p-2},
  {0x1.02c798p-1, 0x1.249236p-2},
  {0x1.0354e2p+0, 0x1.51eb86p-2},
  {0x1.94f484p-5, 0x1.19999ap+0},
  {0x1.3ea4cap-1, 0x1.666666p+0},
  {0x1.0011c2p+0, 0x1.51eb86p-2},
  {0x1.0c3a42p-2, 0x1.666666p+0},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.b0f17p-3, 0x1.249236p-2},
  {0x1.0021f2p+0, 0x1.51eb86p-2},
  {0x1.e3d4aep-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.001d2ap+0, 0x1.51eb86p-2},
  {0x1.47557ap-1, 0x1.a1999ap+4},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.a60daap-1, 0x1.666666p+0},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.666cb2p-3, 0x1.666666p+0},
  {0x1.5132e8p+4, 0x1.51eb86p-2},
  {0x1.b10774p-4, 0x1.249236p-2},
  {0x1.802022p+7, 0x1.51eb86p-2},
  {0x1.fcd3ep-3, 0x1.249236p-2},
  {0x1.b7011p+2, 0x1.51eb86p-2},
  {0x1.ae70dp+3, 0x1.51eb86p-2},
  {0x1.fcfe7ap-1, 0x1.249236p-2},
  {0x1.d1985cp+3, 0x1.51eb86p-2},
  {0x1.d70de8p-3, 0x1.666666p+0},
  {0x1.7a5234p+9, 0x1.51eb86p-2},
  {0x1.ee9d0ep-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.b97354p-12, 0x1.4f5c28p+0},
  {0x1.000496p+0, 0x1.51eb86p-2},
  {0x1.32021p-3, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.4p+2, 0x1.51eb86p-2},
  {0x1.18b7f6p+0, 0x1.249236p-2},
  {0x1.000304p+0, 0x1.51eb86p-2},
  {0x1.ffc372p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.721bc2p-1, 0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.5a07b4p-11, 0x1.a3d70ap-2},
  {0x1.790194p+7, 0x1.51eb86p-2},
  {0x1.c5bc02p-2, 0x1.249236p-2},
  {0x1.97015p+3, 0x1.51eb86p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.f49c4ep-1, 0x1.666666p+0},
  {0x1.4c9e84p+5, 0x1.51eb86p-2},
  {0x1.ae008ep-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.b39864p-3, 0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.cf5b1cp-5, 0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.bef1bap-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.0001b4p+0, 0x1.51eb86p-2},
  {0x1.cf3fdap-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.bad5bep-1, 0x1.666666p+0},
  {0x1.b7b9f2p+2, 0x1.51eb86p-2},
  {0x1.b6d58cp-1, 0x1.666666p+0},
  {0x1.7f4544p+8, 0x1.51eb86p-2},
  {0x1.ed10b2p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.47b56cp-1, 0x1.249236p-2},
  {0x1.89a996p+5, 0x1.51eb86p-2},
  {0x1.ef689cp+1, 0x1.51eb86p-2},
  {0x1.d2c9f2p-1, 0x1.666666p+0},
  {0x1.3eed58p+11, 0x1.d1746p-1},
  {0x1.0042d8p+0, 0x1.666666p+0},
  {0x1.0001b4p+0, 0x1.51eb86p-2},
  {0x1.60525p-12, 0x1.99999ap-1},
  {0x1.b7b89ep+2, 0x1.51eb86p-2},
  {0x1.b37436p-3, 0x1.249236p-2},
  {0x1.403fe2p+8, 0x1.51eb86p-2},
  {0x1.ae746ap+3, 0x1.51eb86p-2},
  {0x1.5a6938p-1, 0x1.666666p+0},
  {0x1.0535fcp+0, 0x1.51eb86p-2},
  {0x1.b75b3ep-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.cf2496p-5, 0x1.249236p-2},
  {0x1.4134ap+15, 0x1.51eb86p-2},
  {0x1.f6bca6p-1, 0x1.666666p+0},
  {0x1.055a8ep+0, 0x1.51eb86p-2},
  {0x1.78029p+8, 0x1.51eb86p-2},
  {0x1.1a1cacp+0, 0x1.238de6p-2},
  {0x1.7abbe2p+8, 0x1.51eb86p-2},
  {0x1.d96e58p-2, 0x1.666666p+0},
  {0x1.000d9p+0, 0x1.51eb86p-2},
  {0x1.79207ep-1, 0x1.666666p+0},
  {0x1.f701b8p+1, 0x1.51eb86p-2},
  {0x1.fd330ap-1, 0x1.666666p+0},
  {0x1.0b8e34p+5, 0x1.51eb86p-2},
  {0x1.026752p+0, 0x1.249236p-2},
  {0x1.07ab1p+0, 0x1.51eb86p-2},
  {0x1.1afdcap+0, 0x1.51eb86p-2},
  {0x1.9a4fp-2, 0x1.666666p+0},
  {0x1.000076p+0, 0x1.d1746p-1},
  {0x1.ce3b26p-1, 0x1.666666p+0},
  {0x1.28244ep+1, 0x1.51eb86p-2},
  {0x1.8c5c9ap-13, 0x1.a3d70ap-2},
  {0x1.47376p+5, 0x1.51eb86p-2},
  {0x1.5640eap-2, 0x1.249236p-2},
  {0x1.0020b4p+0, 0x1.51eb86p-2},
  {0x1.64e27cp+9, 0x1.451eb8p-1},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.8702bep+4, 0x1.51eb86p-2},
  {0x1.f64ffcp-1, 0x1.666666p+0},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.c8474ep-1, 0x1.666666p+0},
  {0x1.794446p+4, 0x1.51eb86p-2},
  {0x1.9b0ab2p-11, 0x1.a3d70ap-2},
  {0x1.7b007cp+6, 0x1.51eb86p-2},
  {0x1.e9adc8p-1, 0x1.666666p+0},
  {0x1.96af1cp+1, 0x1.51eb86p-2},
  {0x1.c94d2p+4, 0x1.51eb86p-2},
  {0x1.965f1p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.0450cep-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.63a8e8p-4, 0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.d38da4p-1, 0x1.666666p+0},
  {0x1.4c687p+4, 0x1.51eb86p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.ae4086p-4, 0x1.d51eb8p+2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.f13512p-1, 0x1.666666p+0},
  {0x1.3f017ep+10, 0x1.51eb86p-2},
  {0x1.3b71fcp-3, 0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.67abfcp-3, 0x1.666666p+0},
  {0x1.77c84cp+11, 0x1.51eb86p-2},
  {0x1.f551d6p-2, 0x1.249236p-2},
  {0x1.29ce6cp+0, 0x1.51eb86p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.d6441p-2, 0x1.666666p+0},
  {0x1.bd3996p+0, 0x1.51eb86p-2},
  {0x1.99c9d6p-3, 0x1.666666p+0},
  {0x1.6c1672p+1, 0x1.51eb86p-2},
  {0x1.0624dep-11, 0x1.4f5c28p+0},
  {0x1.000314p+0, 0x1.51eb86p-2},
  {0x1.03bd16p-1, 0x1.249236p-2},
  {0x1.877e74p+4, 0x1.51eb86p-2},
  {0x1.786616p+2, 0x1.51eb86p-2},
  {0x1.36aa2ap-1, 0x1.666666p+0},
  {0x1.3ec82cp+13, 0x1.51eb86p-2},
  {0x1.fea3ep-2, 0x1.666666p+0},
  {0x1.3522b6p+5, 0x1.51eb86p-2},
  {0x1.013122p-2, 0x1.249236p-2},
  {0x1.89b86p+4, 0x1.51eb86p-2},
  {0x1.d02752p-1, 0x1.249236p-2},
  {0x1.3ee112p+11, 0x1.51eb86p-2},
  {0x1.8702e4p+4, 0x1.51eb86p-2},
  {0x1.34762ap-3, 0x1.666666p+0},
  {0x1.01fd6ap+0, 0x1.51eb86p-2},
  {0x1.071ac2p-3, 0x1.666666p+0},
  {0x1.87010cp+4, 0x1.51eb86p-2},
  {0x1.f06a9p-1, 0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.cd5f9ap-12, 0x1.4f5c28p+0},
  {0x1.e846fap+4, 0x1.51eb86p-2},
  {0x1.00635ap+0, 0x1.249236p-2},
  {0x1.7720d4p+11, 0x1.51eb86p-2},
  {0x1.d4bf0ap-6, 0x1.19999ap+0},
  {0x1.ac115ep-1, 0x1.666666p+0},
  {0x1.000edp+0, 0x1.51eb86p-2},
  {0x1.ce1bbp-1, 0x1.666666p+0},
  {0x1.99afbp+0, 0x1.51eb86p-2},
  {0x1.a12e84p-1, 0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.f129ccp-1, 0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.2f1094p+2, 0x1.51eb86p-2},
  {0x1.7a31a4p-2, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.32db1ep-3, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.a303cp-1, 0x1.249236p-2},
  {0x1.0b2fcap+0, 0x1.51eb86p-2},
  {0x1.f69b9ep-1, 0x1.666666p+0},
  {0x1.77d424p+9, 0x1.51eb86p-2},
  {0x1.000736p+0, 0x1.51eb86p-2},
  {0x1.de90bcp-1, 0x1.666666p+0},
  {0x1.5e3c0cp+2, 0x1.51eb86p-2},
  {0x1.9a6e76p-3, 0x1.666666p+0},
  {0x1.3aa8f4p+5, 0x1.51eb86p-2},
  {0x1.2188b2p-4, 0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.7a979ep-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.377836p+0, 0x1.51eb86p-2},
  {0x1.c9ab2ap-2, 0x1.d51eb8p+2},
  {0x1.0057f4p+0, 0x1.d1746p-1},
  {0x1.de18cep-1, 0x1.666666p+0},
  {0x1.7dc354p+7, 0x1.51eb86p-2},
  {0x1.3c2e78p-1, 0x1.666666p+0},
  {0x1.e99f7cp+3, 0x1.51eb86p-2},
  {0x1.2eb5f6p-2, 0x1.666666p+0},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.491bc6p-1, 0x1.249236p-2},
  {0x1.2f679p-1, 0x1.bp+3},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.caef92p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.d66f94p-2, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.c4fc1ep-16, 0x1.a3d70ap-2},
  {0x1.000e5ap+0, 0x1.51eb86p-2},
  {0x1.4bdab6p-1, 0x1.249236p-2},
  {0x1.186aacp+6, 0x1.51eb86p-2},
  {0x1.01b436p+0, 0x1.51eb86p-2},
  {0x1.cf1306p-1, 0x1.666666p+0},
  {0x1.ba6794p+0, 0x1.51eb86p-2},
  {0x1.2e718ap-2, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.069dfap-3, 0x1.666666p+0},
  {0x1.eb3ae6p+6, 0x1.51eb86p-2},
  {0x1.1d73eap-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.00c4fp+0, 0x1.51eb86p-2},
  {0x1.c872bp-2, 0x1.b51eb8p+3},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.f0e15p-1, 0x1.666666p+0},
  {0x1.b70226p+2, 0x1.51eb86p-2},
  {0x1.cc2892p-1, 0x1.666666p+0},
  {0x1.55692cp+0, 0x1.51eb86p-2},
  {0x1.7d1654p-1, 0x1.666666p+0},
  {0x1.781dbap+9, 0x1.51eb86p-2},
  {0x1.d77708p-1, 0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.3dfde2p+9, 0x1.19999ap+0},
  {0x1.aa5c1cp-1, 0x1.666666p+0},
  {0x1.931c18p+3, 0x1.51eb86p-2},
  {0x1.a25204p-2, 0x1.666666p+0},
  {0x1.05409ap+0, 0x1.51eb86p-2},
  {0x1.60525p-16, 0x1.99999ap-1},
  {0x1.fa083ap-1, 0x1.249236p-2},
  {0x1.34751cp-3, 0x1.249236p-2},
  {0x1.1ee8e2p+5, 0x1.51eb86p-2},
  {0x1.02eafap+0, 0x1.51eb86p-2},
  {0x1.d52652p-3, 0x1.666666p+0},
  {0x1.7740eep+10, 0x1.51eb86p-2},
  {0x1.e731f4p-1, 0x1.666666p+0},
  {0x1.7e3748p+12, 0x1.51eb86p-2},
  {0x1.abd1aap-15, 0x1.a3d70ap-2},
  {0x1.d75a54p+3, 0x1.51eb86p-2},
  {0x1.27cd46p-2, 0x1.249236p-2},
  {0x1.0014d8p+0, 0x1.51eb86p-2},
  {0x1.5940e2p+2, 0x1.51eb86p-2},
  {0x1.1e951p-1, 0x1.666666p+0},
  {0x1.3ee078p+11, 0x1.51eb86p-2},
  {0x1.670b06p-3, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.a36e2ep-14, 0x1.a3d70ap-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.cff1b6p-1, 0x1.249236p-2},
  {0x1.21d0bcp+3, 0x1.51eb86p-2},
  {0x1.00815ep+0, 0x1.51eb86p-2},
  {0x1.bb1316p-1, 0x1.666666p+0},
  {0x1.ae7168p+3, 0x1.51eb86p-2},
  {0x1.7cbea4p-2, 0x1.666666p+0},
  {0x1.452ea6p+6, 0x1.51eb86p-2},
  {0x1.5d5b04p-1, 0x1.249236p-2},
  {0x1.46c07ap+5, 0x1.51eb86p-2},
  {0x1.3a860ep-3, 0x1.249236p-2},
  {0x1.366f5cp+4, 0x1.51eb86p-2},
  {0x1.66682ep+9, 0x1.451eb8p-1},
  {0x1.02d612p+0, 0x1.51eb86p-2},
  {0x1.3fc2e8p+8, 0x1.51eb86p-2},
  {0x1.e4c188p-1, 0x1.666666p+0},
  {0x1.5ef72cp+0, 0x1.51eb86p-2},
  {0x1.03604ap-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.a5870ep-12, 0x1.4f5c28p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.db541ap-1, 0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.001f76p+0, 0x1.51eb86p-2},
  {0x1.2916p-1, 0x1.666666p+0},
  {0x1.24094ep+0, 0x1.51eb86p-2},
  {0x1.5221p-2, 0x1.666666p+0},
  {0x1.000076p+0, 0x1.51eb86p-2},
  {0x1.908e58p-12, 0x1.4f5c28p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.55377ep-1, 0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.01521ap+0, 0x1.51eb86p-2},
  {0x1.9bdc6ap-3, 0x1.666666p+0},
  {0x1.bef1bap+0, 0x1.51eb86p-2},
  {0x1.e4256cp-1, 0x1.666666p+0},
  {0x1.7b026ap+6, 0x1.51eb86p-2},
  {0x1.f75104p-15, 0x1.4f5c28p+0},
  {0x1.001e14p+0, 0x1.51eb86p-2},
  {0x1.f5330ap-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.5ec246p+3, 0x1.51eb86p-2},
  {0x1.9de376p-3, 0x1.666666p+0},
  {0x1.c1f738p+4, 0x1.51eb86p-2},
  {0x1.bd4b6ap-1, 0x1.666666p+0},
  {0x1.7dd4fp+6, 0x1.51eb86p-2},
  {0x1.6ef262p-1, 0x1.249236p-2},
  {0x1.0011b2p+0, 0x1.51eb86p-2},
  {0x1.a67104p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.502ddp+0, 0x1.51eb86p-2},
  {0x1.e7735cp-1, 0x1.666666p+0},
  {0x1.00ff64p+0, 0x1.51eb86p-2},
  {0x1.9e08aep-2, 0x1.666666p+0},
  {0x1.44d47p+12, 0x1.51eb86p-2},
  {0x1.ba4dd2p-1, 0x1.249236p-2},
  {0x1.b58b58p+1, 0x1.51eb86p-2},
  {0x1.f456d6p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.00257cp+0, 0x1.51eb86p-2},
  {0x1.005836p+0, 0x1.666666p+0},
  {0x1.3ed086p+12, 0x1.51eb86p-2},
  {0x1.971994p-1, 0x1.666666p+0},
  {0x1.00013ep+0, 0x1.51eb86p-2},
  {0x1.39a7c2p-3, 0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.1bdb8p-1, 0x1.666666p+0},
  {0x1.a9f66p+7, 0x1.51eb86p-2},
  {0x1.bdff6p-1, 0x1.249236p-2},
  {0x1.015dd4p+0, 0x1.51eb86p-2},
  {0x1.3f0262p+10, 0x1.51eb86p-2},
  {0x1.515fccp-2, 0x1.666666p+0},
  {0x1.ddb004p+0, 0x1.51eb86p-2},
  {0x1.f23cc8p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.e8e5e6p-1, 0x1.249236p-2},
  {0x1.6b50f2p+7, 0x1.51eb86p-2},
  {0x1.7cda6ep-2, 0x1.666666p+0},
  {0x1.4p+2, 0x1.51eb86p-2},
  {0x1.77428ap+10, 0x1.51eb86p-2},
  {0x1.fb24a6p-1, 0x1.666666p+0},
  {0x1.7fe282p+7, 0x1.51eb86p-2},
  {0x1.a7f3dp-1, 0x1.666666p+0},
  {0x1.f701b8p+1, 0x1.51eb86p-2},
  {0x1.049fd8p-3, 0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.e2656ap-1, 0x1.666666p+0},
  {0x1.040bfp+4, 0x1.51eb86p-2},
  {0x1.0013dcp+0, 0x1.d1746p-1},
  {0x1.7cd74ap-2, 0x1.666666p+0},
  {0x1.075bf6p+0, 0x1.51eb86p-2},
  {0x1.2a81dcp-2, 0x1.666666p+0},
  {0x1.2e62bap+0, 0x1.51eb86p-2},
  {0x1.cf2cfap-1, 0x1.249236p-2},
  {0x1.267946p+0, 0x1.51eb86p-2},
  {0x1.67b17cp-2, 0x1.666666p+0},
  {0x1.87017cp+4, 0x1.51eb86p-2},
  {0x1.ae33bap+2, 0x1.d1746p-1},
  {0x1.9e1fcp-3, 0x1.666666p+0},
  {0x1.0c17d8p+3, 0x1.51eb86p-2},
  {0x1.a735c2p-2, 0x1.666666p+0},
  {0x1.2d70d6p+0, 0x1.51eb86p-2},
  {0x1.965a9ap-3, 0x1.666666p+0},
  {0x1.7f72d2p+6, 0x1.51eb86p-2},
  {0x1.0725c4p-3, 0x1.666666p+0},
  {0x1.29406ap+4, 0x1.51eb86p-2},
  {0x1.00193cp+0, 0x1.51eb86p-2},
  {0x1.ae4086p-4, 0x1.d51eb8p+2},
  {0x1.6ffa14p+7, 0x1.51eb86p-2},
  {0x1.fc1616p-1, 0x1.666666p+0},
  {0x1.a46d82p+0, 0x1.51eb86p-2},
  {0x1.97d19ap-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.39e5cp-1, 0x1.666666p+0},
  {0x1.f9fcdep+2, 0x1.51eb86p-2},
  {0x1.f4202ep-1, 0x1.249236p-2},
  {0x1.cec7a8p-1, 0x1.328f5cp+2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.7d15aep-2, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.a67276p-2, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.214f06p-4, 0x1.249236p-2},
  {0x1.257abcp+0, 0x1.51eb86p-2},
  {0x1.51793ap-2, 0x1.666666p+0},
  {0x1.2893f4p+6, 0x1.51eb86p-2},
  {0x1.000582p+0, 0x1.51eb86p-2},
  {0x1.fcfb34p-1, 0x1.249236p-2},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.d96638p-3, 0x1.666666p+0},
  {0x1.000ef2p+0, 0x1.51eb86p-2},
  {0x1.0357c4p+0, 0x1.249236p-2},
  {0x1.034d1ep+1, 0x1.51eb86p-2},
  {0x1.941afp-1, 0x1.666666p+0},
  {0x1.231c54p+0, 0x1.51eb86p-2},
  {0x1.0014e8p+0, 0x1.51eb86p-2},
  {0x1.83211cp-2, 0x1.d51eb8p+2},
  {0x1.7724b8p+11, 0x1.51eb86p-2},
  {0x1.bf8f8ap-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.f1aed6p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.e5ce5cp-1, 0x1.666666p+0},
  {0x1.00140ep+0, 0x1.51eb86p-2},
  {0x1.f775f6p+2, 0x1.51eb86p-2},
  {0x1.fe9a4ep-1, -0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.fd27a2p-1, 0x1.666666p+0},
  {0x1.000746p+0, 0x1.51eb86p-2},
  {0x1.f90c4ep-1, 0x1.666666p+0},
  {0x1.426272p+8, 0x1.51eb86p-2},
  {0x1.f75104p-17, 0x1.99999ap-1},
  {0x1.facabep+5, 0x1.51eb86p-2},
  {0x1.e1db44p-1, 0x1.249236p-2},
  {0x1.42c0b4p+6, 0x1.51eb86p-2},
  {0x1.7744d4p+10, 0x1.51eb86p-2},
  {0x1.0739bp-3, 0x1.666666p+0},
  {0x1.25b1c8p+0, 0x1.51eb86p-2},
  {0x1.665732p-3, 0x1.666666p+0},
  {0x1.00010cp+0, 0x1.51eb86p-2},
  {0x1.3cab82p-12, 0x1.4f5c28p+0},
  {0x1.f856ccp+3, 0x1.51eb86p-2},
  {0x1.204d12p-4, 0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.13bb2p+0, 0x1.51eb86p-2},
  {0x1.0730c6p-3, 0x1.666666p+0},
  {0x1.3ee06ep+11, 0x1.51eb86p-2},
  {0x1.ba5722p-1, 0x1.666666p+0},
  {0x1.46bed6p+7, 0x1.51eb86p-2},
  {0x1.b14a2cp-1, 0x1.249236p-2},
  {0x1.0001e6p+0, 0x1.51eb86p-2},
  {0x1.26b11cp-2, 0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.f00beep-1, 0x1.666666p+0},
  {0x1.1f6bf4p+5, 0x1.51eb86p-2},
  {0x1.a59ab6p-2, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.7bf5d8p-2, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.f969e4p-13, 0x1.4f5c28p+0},
  {0x1.d74108p+1, 0x1.51eb86p-2},
  {0x1.f00c96p-1, 0x1.249236p-2},
  {0x1.ed68e8p-1, 0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.5a4fcap-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.fe2282p-1, 0x1.666666p+0},
  {0x1.e920ccp+7, 0x1.51eb86p-2},
  {0x1.0c6f7ap-17, 0x1.a3d70ap-2},
  {0x1.abfd2cp+3, 0x1.51eb86p-2},
  {0x1.c57f74p-2, 0x1.249236p-2},
  {0x1.b790f8p+2, 0x1.51eb86p-2},
  {0x1.bec1ap+1, 0x1.51eb86p-2},
  {0x1.5251c2p-2, 0x1.666666p+0},
  {0x1.79021cp+7, 0x1.51eb86p-2},
  {0x1.f503b8p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.af3d3ap-3, 0x1.249236p-2},
  {0x1.428256p+8, 0x1.51eb86p-2},
  {0x1.f8f3ecp-1, 0x1.249236p-2},
  {0x1.001334p+0, 0x1.51eb86p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.00e486p+0, 0x1.249236p-2},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.fc8dap-2, 0x1.666666p+0},
  {0x1.5755e6p+1, 0x1.51eb86p-2},
  {0x1.009d4ap-2, 0x1.249236p-2},
  {0x1.259c06p+0, 0x1.51eb86p-2},
  {0x1.377dd8p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.2a0f6ep+13, 0x1.99999ap-2},
  {0x1.139de4p-1, 0x1.dp+2},
  {0x1.5d0ad4p+1, 0x1.51eb86p-2},
  {0x1.ed133p-1, 0x1.666666p+0},
  {0x1.3374eep+0, 0x1.51eb86p-2},
  {0x1.21f3a6p-4, 0x1.249236p-2},
  {0x1.01618p+0, 0x1.51eb86p-2},
  {0x1.65553ep-3, 0x1.666666p+0},
  {0x1.88ffe2p+1, 0x1.51eb86p-2},
  {0x1.a56a38p-1, 0x1.249236p-2},
  {0x1.9df9fp+3, 0x1.51eb86p-2},
  {0x1.7e4fc4p+9, 0x1.51eb86p-2},
  {0x1.ffd156p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.a25354p-1, 0x1.666666p+0},
  {0x1.03f8bap+0, 0x1.51eb86p-2},
  {0x1.f9187ep-1, 0x1.666666p+0},
  {0x1.06bf66p+0, 0x1.51eb86p-2},
  {0x1.8ca57ap-2, 0x1.249236p-2},
  {0x1.4004a6p+8, 0x1.51eb86p-2},
  {0x1.00da6ep+0, 0x1.51eb86p-2},
  {0x1.3a6eap+1, 0x1.551eb8p+2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.7b2874p-1, 0x1.666666p+0},
  {0x1.0003eep+0, 0x1.51eb86p-2},
  {0x1.217d28p-4, 0x1.249236p-2},
  {0x1.12748p+5, 0x1.51eb86p-2},
  {0x1.060ccp-1, 0x1.666666p+0},
  {0x1.80bf9cp+3, 0x1.51eb86p-2},
  {0x1.a06e5cp-1, 0x1.249236p-2},
  {0x1.0014c6p+0, 0x1.51eb86p-2},
  {0x1.72be26p+8, 0x1.51eb86p-2},
  {0x1.ed51d6p-1, 0x1.666666p+0},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.5487fcp-1, 0x1.666666p+0},
  {0x1.376694p+0, 0x1.51eb86p-2},
  {0x1.0624dep-11, 0x1.4f5c28p+0},
  {0x1.7514bcp+7, 0x1.51eb86p-2},
  {0x1.afba02p-4, 0x1.249236p-2},
  {0x1.001798p+0, 0x1.51eb86p-2},
  {0x1.0000a8p+0, 0x1.51eb86p-2},
  {0x1.d3b42cp-3, 0x1.666666p+0},
  {0x1.0003dep+0, 0x1.51eb86p-2},
  {0x1.e28134p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.9efd22p-1, 0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.8df548p-2, 0x1.249236p-2},
  {0x1.20c89cp+0, 0x1.51eb86p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.fd786p-1, 0x1.666666p+0},
  {0x1.bef61ep+0, 0x1.51eb86p-2},
  {0x1.52ccb4p-2, 0x1.666666p+0},
  {0x1.5ec068p+3, 0x1.51eb86p-2},
  {0x1.9618acp-1, 0x1.249236p-2},
  {0x1.b60a44p+3, 0x1.51eb86p-2},
  {0x1.e728a6p-1, 0x1.666666p+0},
  {0x1.42c036p+6, 0x1.51eb86p-2},
  {0x1.00c73ap+0, 0x1.51eb86p-2},
  {0x1.9ecbb8p-3, 0x1.666666p+0},
  {0x1.2d7d66p+5, 0x1.51eb86p-2},
  {0x1.d6f4bep-2, 0x1.666666p+0},
  {0x1.7d5396p+7, 0x1.51eb86p-2},
  {0x1.76616cp-3, 0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.3bfb58p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.019f9p+0, 0x1.51eb86p-2},
  {0x1.d479e6p+0, 0x1.551eb8p+2},
  {0x1.002d5ap+0, 0x1.51eb86p-2},
  {0x1.9baf54p-1, 0x1.666666p+0},
  {0x1.46c138p+5, 0x1.51eb86p-2},
  {0x1.76ba8cp-2, 0x1.666666p+0},
  {0x1.79d43p+13, 0x1.51eb86p-2},
  {0x1.21ef74p-4, 0x1.249236p-2},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.9cd574p-3, 0x1.666666p+0},
  {0x1.12e636p+6, 0x1.51eb86p-2},
  {0x1.870302p+4, 0x1.51eb86p-2},
  {0x1.fba86p-1, 0x1.249236p-2},
  {0x1.000096p+0, 0x1.99999ap-2},
  {0x1.551938p-2, 0x1.666666p+0},
  {0x1.780188p+8, 0x1.51eb86p-2},
  {0x1.f81776p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.ba6bf8p-1, 0x1.666666p+0},
  {0x1.085826p+0, 0x1.51eb86p-2},
  {0x1.d3c382p-1, 0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.ba732ep-2, 0x1.666666p+0},
  {0x1.7ec812p+5, 0x1.51eb86p-2},
  {0x1.ecb4aep-1, 0x1.666666p+0},
  {0x1.84892p+5, 0x1.51eb86p-2},
  {0x1.8635e8p-1, 0x1.249236p-2},
  {0x1.7b4364p+0, 0x1.51eb86p-2},
  {0x1.05efeap-3, 0x1.249236p-2},
  {0x1.f9a16ep+2, 0x1.51eb86p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.11d92cp+0, 0x1.23a322p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.038b48p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.ed89acp-1, 0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.e27a42p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.0007dep+0, 0x1.51eb86p-2},
  {0x1.7aaf6p+1, 0x1.5p+2},
  {0x1.b45554p+0, 0x1.51eb86p-2},
  {0x1.a903a8p-2, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.a32d2cp-2, 0x1.666666p+0},
  {0x1.3ad024p+2, 0x1.19999ap+0},
  {0x1.f60dccp-1, 0x1.666666p+0},
  {0x1.040b8ep+4, 0x1.51eb86p-2},
  {0x1.23d35ep-2, 0x1.249236p-2},
  {0x1.c8d466p+0, 0x1.51eb86p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.f98d48p-1, 0x1.666666p+0},
  {0x1.5ec606p+3, 0x1.51eb86p-2},
  {0x1.f298ccp-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.ae76p-3, 0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.9f310ap-1, 0x1.249236p-2},
  {0x1.171db4p+0, 0x1.51eb86p-2},
  {0x1.a8c33p+5, 0x1.451eb8p-1},
  {0x1.54a9c2p+4, 0x1.51eb86p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.cfdbb2p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.0cb536p-2, 0x1.666666p+0},
  {0x1.5f8712p+2, 0x1.51eb86p-2},
  {0x1.c2511ap-1, 0x1.249236p-2},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.f84ee8p-1, 0x1.666666p+0},
  {0x1.2aca7ep+2, 0x1.51eb86p-2},
  {0x1.c621b8p-2, 0x1.249236p-2},
  {0x1.7b873ap+6, 0x1.51eb86p-2},
  {0x1.002278p+0, 0x1.51eb86p-2},
  {0x1.3a0902p-1, 0x1.666666p+0},
  {0x1.028522p+0, 0x1.51eb86p-2},
  {0x1.ed61b2p-1, 0x1.666666p+0},
  {0x1.50e05cp+7, 0x1.51eb86p-2},
  {0x1.cfe26p-1, 0x1.666666p+0},
  {0x1.9f234cp+3, 0x1.51eb86p-2},
  {0x1.cfa44p-1, 0x1.666666p+0},
  {0x1.f9c79cp+1, 0x1.51eb86p-2},
  {0x1.ee8d1p-2, 0x1.249236p-2},
  {0x1.0011b2p+0, 0x1.51eb86p-2},
  {0x1.92a738p-19, 0x1.19999ap+0},
  {0x1.599bf6p-1, 0x1.666666p+0},
  {0x1.bace3p+6, 0x1.51eb86p-2},
  {0x1.b19f3cp-1, 0x1.666666p+0},
  {0x1.46c118p+5, 0x1.51eb86p-2},
  {0x1.8a09aap-1, 0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.dbacf8p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.b1d92cp-4, 0x1.249236p-2},
  {0x1.566e34p+3, 0x1.51eb86p-2},
  {0x1.a83c34p+6, 0x1.51eb86p-2},
  {0x1.7df97ap-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.d53d64p-3, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.762f9cp-3, 0x1.249236p-2},
  {0x1.3ec6a2p+14, 0x1.51eb86p-2},
  {0x1.db293ep-1, 0x1.666666p+0},
  {0x1.0f9fdcp+0, 0x1.51eb86p-2},
  {0x1.c22d0ep-2, 0x1.249236p-2},
  {0x1.001494p+0, 0x1.51eb86p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.079896p-3, 0x1.666666p+0},
  {0x1.0000dap+0, 0x1.51eb86p-2},
  {0x1.ff6ec6p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.02528ap-1, 0x1.249236p-2},
  {0x1.029802p+0, 0x1.51eb86p-2},
  {0x1.f26784p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.2254a4p-2, 0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.28dde8p-2, 0x1.249236p-2},
  {0x1.1e354p+0, 0x1.51eb86p-2},
  {0x1.8880dap+14, 0x1.d1746p-1},
  {0x1.34db5ap-3, 0x1.666666p+0},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.0b9aep-2, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.3ba216p-1, 0x1.666666p+0},
  {0x1.01d93cp+0, 0x1.d1746p-1},
  {0x1.cef36ep-1, 0x1.249236p-2},
  {0x1.000e8cp+0, 0x1.51eb86p-2},
  {0x1.dfd7e4p-1, 0x1.666666p+0},
  {0x1.5cb568p+12, 0x1.d1746p-1},
  {0x1.694e5ep-3, 0x1.249236p-2},
  {0x1.779a84p+12, 0x1.51eb86p-2},
  {0x1.77829p+9, 0x1.51eb86p-2},
  {0x1.eceeep-2, 0x1.b51eb8p+3},
  {0x1.52bd6ep+1, 0x1.99999ap-2},
  {0x1.362de8p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.59bb8cp-1, 0x1.666666p+0},
  {0x1.46c56ep+5, 0x1.51eb86p-2},
  {0x1.78ec52p-1, 0x1.666666p+0},
  {0x1.41a93ap+9, 0x1.51eb86p-2},
  {0x1.8e757ap-13, 0x1.99999ap-1},
  {0x1.0004b8p+0, 0x1.51eb86p-2},
  {0x1.353cdep-3, 0x1.666666p+0},
  {0x1.016894p+0, 0x1.51eb86p-2},
  {0x1.4d104ep-1, 0x1.249236p-2},
  {0x1.8dd6e8p+3, 0x1.19999ap+0},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.7f707ap-1, 0x1.af5c28p+2},
  {0x1.848798p+2, 0x1.51eb86p-2},
  {0x1.df3084p-1, 0x1.666666p+0},
  {0x1.7800f2p+8, 0x1.51eb86p-2},
  {0x1.081ba8p-2, 0x1.666666p+0},
  {0x1.512bc2p+0, 0x1.51eb86p-2},
  {0x1.defb9p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.b00368p-13, 0x1.a3d70ap-2},
  {0x1.000182p+0, 0x1.51eb86p-2},
  {0x1.3c1fp-1, 0x1.666666p+0},
  {0x1.00a02cp+0, 0x1.99999ap-2},
  {0x1.0168f8p+0, 0x1.51eb86p-2},
  {0x1.0005c4p+0, 0x1.51eb86p-2},
  {0x1.4fae58p+0, 0x1.51eb86p-2},
  {0x1.c44242p-2, 0x1.b51eb8p+3},
  {0x1.890a52p+3, 0x1.51eb86p-2},
  {0x1.591dbcp-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.3ac9d2p-1, 0x1.666666p+0},
  {0x1.281b86p+0, 0x1.51eb86p-2},
  {0x1.50bd24p-1, 0x1.249236p-2},
  {0x1.0c240cp+3, 0x1.51eb86p-2},
  {0x1.3a0c6cp-11, 0x1.a3d70ap-2},
  {0x1.08cc9ap+0, 0x1.51eb86p-2},
  {0x1.2be48ap-12, 0x1.99999ap-1},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.b09a68p-3, 0x1.249236p-2},
  {0x1.002246p+0, 0x1.51eb86p-2},
  {0x1.000192p+0, 0x1.51eb86p-2},
  {0x1.00054ep+0, 0x1.51eb86p-2},
  {0x1.772292p+11, 0x1.51eb86p-2},
  {0x1.81c5dep+11, 0x1.99999ap-2},
  {0x1.b3e708p+0, 0x1.51eb86p-2},
  {0x1.3940ep+3, 0x1.51eb86p-2},
  {0x1.5f2cd8p+6, 0x1.51eb86p-2},
  {0x1.ae4086p-4, 0x1.d51eb8p+2},
  {0x1.85f58ap+3, 0x1.51eb86p-2},
  {0x1.0afbc2p-2, 0x1.666666p+0},
  {0x1.0000fcp+0, 0x1.51eb86p-2},
  {0x1.4da016p-1, 0x1.666666p+0},
  {0x1.0604bp+0, 0x1.51eb86p-2},
  {0x1.d1ca18p-1, 0x1.666666p+0},
  {0x1.3f0136p+10, 0x1.51eb86p-2},
  {0x1.dae77p-1, 0x1.666666p+0},
  {0x1.5dc066p+0, 0x1.51eb86p-2},
  {0x1.7e15a8p-1, 0x1.666666p+0},
  {0x1.0004dap+0, 0x1.d1746p-1},
  {0x1.bd3868p-1, 0x1.666666p+0},
  {0x1.3f41ccp+9, 0x1.51eb86p-2},
  {0x1.22717ap-4, 0x1.249236p-2},
  {0x1.24244ep+0, 0x1.51eb86p-2},
  {0x1.574d9cp-2, 0x1.249236p-2},
  {0x1.b047e2p+3, 0x1.d1746p-1},
  {0x1.d734d6p-1, 0x1.249236p-2},
  {0x1.422444p+8, 0x1.51eb86p-2},
  {0x1.f75104p-16, 0x1.99999ap-1},
  {0x1.ac0ef2p+3, 0x1.d1746p-1},
  {0x1.feb2f2p-1, 0x1.666666p+0},
  {0x1.1ee88cp+5, 0x1.51eb86p-2},
  {0x1.a4341ap-1, 0x1.249236p-2},
  {0x1.27cebp+1, 0x1.51eb86p-2},
  {0x1.c65776p-2, 0x1.249236p-2},
  {0x1.0f43a6p+0, 0x1.d1746p-1},
  {0x1.f1f46ep-1, 0x1.249236p-2},
  {0x1.3fc02cp+8, 0x1.51eb86p-2},
  {0x1.ae72f4p+3, 0x1.51eb86p-2},
  {0x1.0014f8p+0, 0x1.51eb86p-2},
  {0x1.27cd68p+0, 0x1.51eb86p-2},
  {0x1.0012aep+0, 0x1.51eb86p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.3d1c5cp+1, 0x1.551eb8p+2},
  {0x1.000778p+0, 0x1.51eb86p-2},
  {0x1.ae4086p-4, 0x1.d51eb8p+2},
  {0x1.3b8138p+1, 0x1.51eb86p-2},
  {0x1.014e3cp-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.52e44cp-2, 0x1.666666p+0},
  {0x1.9eb2e2p+0, 0x1.51eb86p-2},
  {0x1.6670e2p-3, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.b63348p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.7a2596p-2, 0x1.666666p+0},
  {0x1.bf64a6p+1, 0x1.51eb86p-2},
  {0x1.d709fap-2, 0x1.666666p+0},
  {0x1.3b80e4p+1, 0x1.51eb86p-2},
  {0x1.5452c6p-2, 0x1.666666p+0},
  {0x1.104524p+0, 0x1.51eb86p-2},
  {0x1.a445eep-2, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.e9d10cp-1, 0x1.666666p+0},
  {0x1.00ef24p+0, 0x1.51eb86p-2},
  {0x1.98769ep-3, 0x1.666666p+0},
  {0x1.000346p+0, 0x1.51eb86p-2},
  {0x1.a8c9fcp-2, 0x1.666666p+0},
  {0x1.2e38p+0, 0x1.51eb86p-2},
  {0x1.01c0a8p-1, 0x1.666666p+0},
  {0x1.9f60cp+0, 0x1.51eb86p-2},
  {0x1.a1e732p-1, 0x1.666666p+0},
  {0x1.bcabcep+1, 0x1.51eb86p-2},
  {0x1.1ca7f8p-1, 0x1.666666p+0},
  {0x1.f704ccp+1, 0x1.51eb86p-2},
  {0x1.04f312p-1, 0x1.666666p+0},
  {0x1.000358p+0, 0x1.51eb86p-2},
  {0x1.2cd184p-2, 0x1.666666p+0},
  {0x1.ce7a8cp+4, 0x1.51eb86p-2},
  {0x1.59d388p-1, 0x1.666666p+0},
  {0x1.b1fc54p+1, 0x1.51eb86p-2},
  {0x1.dac51ap-1, 0x1.666666p+0},
  {0x1.7225b8p-8, 0x1.19999ap+0},
  {0x1.a6c11ap-1, 0x1.666666p+0},
  {0x1.7f01ap+5, 0x1.51eb86p-2},
  {0x1.e6a29p-1, 0x1.666666p+0},
  {0x1.12ecaep+0, 0x1.51eb86p-2},
  {0x1.5dd852p-1, 0x1.666666p+0},
  {0x1.7851c6p+9, 0x1.51eb86p-2},
  {0x1.7aebe6p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.9d2e0ep-3, 0x1.666666p+0},
  {0x1.7b7596p+7, 0x1.51eb86p-2},
  {0x1.e1decep-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.7797ccp-1, 0x1.666666p+0},
  {0x1.42c15p+6, 0x1.51eb86p-2},
  {0x1.cfef7cp-2, 0x1.666666p+0},
  {0x1.bdf6cep+6, 0x1.51eb86p-2},
  {0x1.fbc4d2p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.d45bf2p-2, 0x1.666666p+0},
  {0x1.53eda6p+0, 0x1.51eb86p-2},
  {0x1.02abfp+0, 0x1.666666p+0},
  {0x1.78013cp+8, 0x1.51eb86p-2},
  {0x1.9d0d06p-3, 0x1.666666p+0},
  {0x1.5336dep-11, 0x1.19999ap+0},
  {0x1.6691eap-3, 0x1.666666p+0},
  {0x1.488ea4p+6, 0x1.51eb86p-2},
  {0x1.e42edcp-1, 0x1.666666p+0},
  {0x1.02b97p+0, 0x1.51eb86p-2},
  {0x1.39e98ep-1, 0x1.666666p+0},
  {0x1.9421f2p+2, 0x1.51eb86p-2},
  {0x1.ddfb72p-1, 0x1.666666p+0},
  {0x1.7b0224p+6, 0x1.51eb86p-2},
  {0x1.aeb32cp+1, 0x1.d1746p-1},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.51f7d8p-2, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.04767ep+0, 0x1.d1746p-1},
  {0x1.6f1402p+1, 0x1.51eb86p-2},
  {0x1.bd4862p+4, 0x1.d1746p-1},
  {0x1.4ec1eap+4, 0x1.51eb86p-2},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.df2da2p-1, 0x1.249236p-2},
  {0x1.8e61f2p+10, 0x1.99999ap-2},
  {0x1.c34e76p-1, 0x1.666666p+0},
  {0x1.00119p+0, 0x1.51eb86p-2},
  {0x1.f3213ep-1, 0x1.666666p+0},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.f1181ap-1, 0x1.249236p-2},
  {0x1.000e18p+0, 0x1.51eb86p-2},
  {0x1.ff2842p-2, 0x1.666666p+0},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.d2f3c2p-2, 0x1.666666p+0},
  {0x1.9701b6p+3, 0x1.51eb86p-2},
  {0x1.015592p+0, 0x1.666666p+0},
  {0x1.3e449ap+9, 0x1.19999ap+0},
  {0x1.58a82ap-1, 0x1.666666p+0},
  {0x1.970292p+3, 0x1.51eb86p-2},
  {0x1.975d56p-2, 0x1p-1},
  {0x1.7e0e04p+10, 0x1.51eb86p-2},
  {0x0p+0, 0x1.51eb86p-2},
  {0x1.02684cp+0, 0x1.51eb86p-2},
  {0x1.48f286p+4, 0x1.d1746p-1},
  {0x1.eb3f64p-1, 0x1.249236p-2},
  {0x1.0601f4p+8, 0x1.d1746p-1},
  {0x1.bd2ac8p-1, 0x1.249236p-2},
  {0x1.33354cp-4, 0x1.19999ap+0},
  {0x1.e7662p-1, 0x1.666666p+0},
  {0x1.3f02c8p+10, 0x1.51eb86p-2},
  {0x1.c4fc1ep-16, 0x1.4f5c28p+0},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.53ac5p-2, 0x1.249236p-2},
  {0x1.2f6014p+3, 0x1.19999ap+0},
  {0x1.9d07c8p-3, 0x1.666666p+0},
  {0x1.98d53p+0, 0x1.51eb86p-2},
  {0x1.e20792p-1, 0x1.666666p+0},
  {0x1.028a4p+0, 0x1.249236p-2},
  {0x1.7b9842p-2, 0x1.666666p+0},
  {0x1.fdf5fp+1, 0x1.51eb86p-2},
  {0x1.bcfc62p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.771258p+12, 0x1.51eb86p-2},
  {0x1.00057p+0, 0x1.51eb86p-2},
  {0x1.3ee1ecp+11, 0x1.51eb86p-2},
  {0x1.5c5292p+3, 0x1.d1746p-1},
  {0x1.aee41ap-4, 0x1.249236p-2},
  {0x1.7ec31ap+2, 0x1.51eb86p-2},
  {0x1.93b96ap-3, 0x1.666666p+0},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.e54994p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.30d49ap-3, 0x1.249236p-2},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.a9027ap-1, 0x1.666666p+0},
  {0x1.8621b8p+5, 0x1.51eb86p-2},
  {0x1.cba2ep-1, 0x1.666666p+0},
  {0x1.00a256p+0, 0x1.d1746p-1},
  {0x1.66d72p-3, 0x1.666666p+0},
  {0x1.000022p+0, 0x1.51eb86p-2},
  {0x1.a6bb98p-2, 0x1.666666p+0},
  {0x1.3e30b2p+6, 0x1.19999ap+0},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.8a85ep+4, 0x1.51eb86p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.8aa822p-2, 0x1.249236p-2},
  {0x1.a91de2p+4, 0x1.d1746p-1},
  {0x1.a36e2ep-16, 0x1.99999ap-1},
  {0x1.94e454p+0, 0x1.51eb86p-2},
  {0x1.5348f6p-2, 0x1.666666p+0},
  {0x1.b5b33p+5, 0x1.99999ap-2},
  {0x1.ea0dbap-1, 0x1.666666p+0},
  {0x1.728e92p-4, 0x1.19999ap+0},
  {0x1.d5cfeep-2, 0x1.666666p+0},
  {0x1.ce725cp+2, 0x1.51eb86p-2},
  {0x1.790186p+7, 0x1.51eb86p-2},
  {0x1.00062ap+0, 0x1.51eb86p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.5cc272p-1, 0x1.666666p+0},
  {0x1.395fd6p+8, 0x1.99999ap-2},
  {0x1.1fefcp-2, 0x1.249236p-2},
  {0x1.a8bf32p+4, 0x1.d1746p-1},
  {0x1.b3994ep-1, 0x1.666666p+0},
  {0x1.00727ep+0, 0x1.51eb86p-2},
  {0x1.d2cd3ap-2, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.768c48p-1, 0x1.d51eb8p+2},
  {0x1.813fep+4, 0x1.51eb86p-2},
  {0x1.17a55ep+6, 0x1.d1746p-1},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.86bc5cp+5, 0x1.99999ap-2},
  {0x1.06d8b2p-3, 0x1.666666p+0},
  {0x1.79049cp+7, 0x1.51eb86p-2},
  {0x1.f42c8p-1, 0x1.249236p-2},
  {0x1.a7297p-2, 0x1.19999ap+0},
  {0x1.eb8b26p-1, 0x1.666666p+0},
  {0x1.989286p+9, 0x1.99999ap-2},
  {0x1.9b54ap-3, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.03e864p+3, 0x1.d1746p-1},
  {0x1.014da4p+0, 0x1.51eb86p-2},
  {0x1.1613d4p-3, 0x1.19999ap+0},
  {0x1.00180ep+0, 0x1.51eb86p-2},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.cdd872p-1, 0x1.666666p+0},
  {0x1.3e7fcp+10, 0x1.19999ap+0},
  {0x1.c51b5p-2, 0x1.249236p-2},
  {0x1.08988p+0, 0x1.99999ap-2},
  {0x1.55ec3ep-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.9b706ap-3, 0x1.666666p+0},
  {0x1.dd566cp-3, 0x1.19999ap+0},
  {0x1.38c95ap+9, 0x1.19999ap+0},
  {0x1.0011c2p+0, 0x1.51eb86p-2},
  {0x1.51d54ep+0, 0x1.99999ap-2},
  {0x1.d902dep-1, 0x1.249236p-2},
  {0x1.508eb6p+3, 0x1.99999ap-2},
  {0x1.cdd7ecp-1, 0x1.666666p+0},
  {0x1.020b2cp+0, 0x1.51eb86p-2},
  {0x1.d10bc8p-1, 0x1.249236p-2},
  {0x1.870154p+4, 0x1.51eb86p-2},
  {0x1.7d6a9cp-1, 0x1.666666p+0},
  {0x1.7712p+12, 0x1.51eb86p-2},
  {0x1.bb4c8p-1, 0x1.666666p+0},
  {0x1.5c772ep+1, 0x1.99999ap-2},
  {0x1.000adp+0, 0x1.99999ap-2},
  {0x1.768e2ap+2, 0x1.51eb86p-2},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.50af1cp-1, 0x1.249236p-2},
  {0x1.00711ep+0, 0x1.51eb86p-2},
  {0x1.afb6dcp-4, 0x1.249236p-2},
  {0x1.571422p+6, 0x1.99999ap-2},
  {0x1.523358p-2, 0x1.666666p+0},
  {0x1.e9059ep+3, 0x1.99999ap-2},
  {0x1.5232f4p-1, 0x1.666666p+0},
  {0x1.221414p+7, 0x1.d1746p-1},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.3fc0e8p+8, 0x1.51eb86p-2},
  {0x1.1a7c18p-5, 0x1.19999ap+0},
  {0x1.bffde8p-2, 0x1.249236p-2},
  {0x1.42c3aep+6, 0x1.51eb86p-2},
  {0x1.df3776p-1, 0x1.249236p-2},
  {0x1.2eeca6p+1, 0x1.19999ap+0},
  {0x1.7b482cp-1, 0x1.666666p+0},
  {0x1.26e908p+4, 0x1.51eb86p-2},
  {0x1.3a5c1cp-1, 0x1.666666p+0},
  {0x1.6adf2ep+0, 0x1.51eb86p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.0069e8p+0, 0x1.99999ap-2},
  {0x1.3ac936p+2, 0x1.19999ap+0},
  {0x1.5a14cep-2, 0x1.249236p-2},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.1f0c34p-10, 0x1.a3d70ap-2},
  {0x1.d3b928p-2, 0x1.19999ap+0},
  {0x1.b85122p-1, 0x1.666666p+0},
  {0x1.76a5fp+1, 0x1.19999ap+0},
  {0x1.bacba8p-1, 0x1.666666p+0},
  {0x1.3e400ep+14, 0x1.19999ap+0},
  {0x1.05243ap+0, 0x1.249236p-2},
  {0x1.01cf36p+0, 0x1.d1746p-1},
  {0x1.7d4174p-5, 0x1.19999ap+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.efcb2ep-1, 0x1.666666p+0},
  {0x1.01cc2p+0, 0x1.d1746p-1},
  {0x1.861c36p-1, 0x1.666666p+0},
  {0x1.11d15ap+2, 0x1.d1746p-1},
  {0x1.cb267cp-1, 0x1.666666p+0},
  {0x1.0074c8p+0, 0x1.51eb86p-2},
  {0x1.7773ap-2, 0x1.d51eb8p+2},
  {0x1.000064p+0, 0x1.99999ap-2},
  {0x1.04669p+0, 0x1.d1746p-1},
  {0x1.4ec128p+4, 0x1.51eb86p-2},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.ed6d3cp-1, 0x1.666666p+0},
  {0x1.7711f2p+12, 0x1.51eb86p-2},
  {0x1.cebbfep-1, 0x1.249236p-2},
  {0x1.4115e2p+11, 0x1.d1746p-1},
  {0x1.03828p-1, 0x1.666666p+0},
  {0x1.774322p+10, 0x1.51eb86p-2},
  {0x1.7be1a8p-1, 0x1.666666p+0},
  {0x1.870414p+4, 0x1.51eb86p-2},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.1907bcp+3, 0x1.51eb86p-2},
  {0x1.00069ep+0, 0x1.51eb86p-2},
  {0x1.0aa4bap-2, 0x1.666666p+0},
  {0x1.001f1p+0, 0x1.99999ap-2},
  {0x1.b97c8p-1, 0x1.249236p-2},
  {0x1.adbcap+10, 0x1.99999ap-2},
  {0x1.ef29d4p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.34df8cp-3, 0x1.666666p+0},
  {0x1.b9ab88p+3, 0x1.d1746p-1},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.3ec5f4p+14, 0x1.51eb86p-2},
  {0x1.2a90e4p+3, 0x1.19999ap+0},
  {0x1.c9d798p-1, 0x1.666666p+0},
  {0x1.7a17dcp+5, 0x1.19999ap+0},
  {0x1.e4dd94p-1, 0x1.249236p-2},
  {0x1.007044p+0, 0x1.99999ap-2},
  {0x1.070196p-3, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.9a133cp-3, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.3f40cap+9, 0x1.51eb86p-2},
  {0x1.df6c9cp+0, 0x1.19999ap+0},
  {0x1.0ed528p+0, 0x1.99999ap-2},
  {0x1.064eaep-1, 0x1.249236p-2},
  {0x1.4940bcp-12, 0x1.19999ap+0},
  {0x1.b5e4c6p-1, 0x1.249236p-2},
  {0x1.00e5d6p+0, 0x1.d1746p-1},
  {0x1.66ce36p-3, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.3bf50ep-1, 0x1.666666p+0},
  {0x1.3ec8d4p+14, 0x1.51eb86p-2},
  {0x1.2c247cp+8, 0x1.99999ap-2},
  {0x1.510c14p+4, 0x1.51eb86p-2},
  {0x1.00c038p+0, 0x1.d1746p-1},
  {0x1.cf2192p-1, 0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.01f32p-11, 0x1.4f5c28p+0},
  {0x1.149796p+0, 0x1.99999ap-2},
  {0x1.39c13p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.92ef7p-1, 0x1.666666p+0},
  {0x1.b129a2p+2, 0x1.d1746p-1},
  {0x1.2f2644p+13, 0x1.99999ap-2},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.7f01b6p+5, 0x1.51eb86p-2},
  {0x1.b1012ap-3, 0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.a79fecp-13, 0x1.99999ap-1},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.2e008ep-2, 0x1.666666p+0},
  {0x1.33c1cep-8, 0x1.19999ap+0},
  {0x1.aa60d4p-1, 0x1.666666p+0},
  {0x1.3ad252p+11, 0x1.19999ap+0},
  {0x1.f7cd04p-1, -0x1.249236p-2},
  {0x1.b83e86p+1, 0x1.99999ap-2},
  {0x1.00050cp+0, 0x1.51eb86p-2},
  {0x1.8a13ap-1, 0x1.249236p-2},
  {0x1.7903bep+7, 0x1.51eb86p-2},
  {0x1.20f58p-1, 0x1.666666p+0},
  {0x1.20a02cp+0, 0x1.d1746p-1},
  {0x1.cf78fep-3, 0x1.666666p+0},
  {0x1.1c2f52p+2, 0x1.d1746p-1},
  {0x1.a849ecp-1, 0x1.666666p+0},
  {0x1.bd3b2ap+4, 0x1.d1746p-1},
  {0x1.ae4086p-4, 0x1.d51eb8p+2},
  {0x1.b93c7ep+10, 0x1.99999ap-2},
  {0x1.007304p+0, 0x1.51eb86p-2},
  {0x1.ec3222p-1, 0x1.249236p-2},
  {0x1.3e97c6p+5, 0x1.19999ap+0},
  {0x1.65dd9p-3, 0x1.666666p+0},
  {0x1.048f22p+0, 0x1.d1746p-1},
  {0x1.06b7aap-3, 0x1.666666p+0},
  {0x1.b958d8p+30, 0x1.99999ap-2},
  {0x1.f00842p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.696638p-2, 0x1.dp+2},
  {0x1.005718p+0, 0x1.51eb86p-2},
  {0x1.4ec176p+4, 0x1.51eb86p-2},
  {0x1.e82f94p-1, 0x1.249236p-2},
  {0x1.82a95p+0, 0x1.99999ap-2},
  {0x1.d5d91ap-3, 0x1.666666p+0},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.cf2cfap-5, 0x1.249236p-2},
  {0x1.00b33ep+0, 0x1.d1746p-1},
  {0x1.d230bap-2, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.7b9736p-2, 0x1.666666p+0},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.770a96p+13, 0x1.51eb86p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.000b34p+0, 0x1.51eb86p-2},
  {0x1.eba45p-1, 0x1.666666p+0},
  {0x1.017fb6p+0, 0x1.d1746p-1},
  {0x1.263348p-2, 0x1.249236p-2},
  {0x1.00ab72p+0, 0x1.51eb86p-2},
  {0x1.ed41d8p-1, 0x1.666666p+0},
  {0x1.05683p+0, 0x1.99999ap-2},
  {0x1.0cc74cp-2, 0x1.666666p+0},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.c22026p+0, 0x1.19999ap+0},
  {0x1.000208p+0, 0x1.51eb86p-2},
  {0x1.9eee2cp+4, 0x1.d1746p-1},
  {0x1.508aacp-2, 0x1.666666p+0},
  {0x1.31ffe6p+0, 0x1.19999ap+0},
  {0x1.cc63f2p-5, 0x1.249236p-2},
  {0x1.c718bp+8, 0x1.99999ap-2},
  {0x1.ab2e38p-1, 0x1.666666p+0},
  {0x1.126d9cp+0, 0x1.d1746p-1},
  {0x1.06f60ep-3, 0x1.666666p+0},
  {0x1.34b6b8p+8, 0x1.d1746p-1},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.771204p+12, 0x1.51eb86p-2},
  {0x1.38e07cp+6, 0x1.19999ap+0},
  {0x1.7bb01cp-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.387724p-3, 0x1.249236p-2},
  {0x1.0080b6p+0, 0x1.99999ap-2},
  {0x1.a9e6acp-2, 0x1.666666p+0},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.f2a3aep-1, 0x1.666666p+0},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.002364p+0, 0x1.51eb86p-2},
  {0x1.0009a2p+0, 0x1.51eb86p-2},
  {0x1.16df4ep+3, 0x1.19999ap+0},
  {0x1.8bd5fep-1, 0x1.249236p-2},
  {0x1.0d71bp+0, 0x1.99999ap-2},
  {0x1.6c588ap-1, 0x1.249236p-2},
  {0x1.56c7cap+1, 0x1.99999ap-2},
  {0x1.d7f6b2p-3, 0x1.666666p+0},
  {0x1.fff738p-1, 0x1.249236p-2},
  {0x1.7a9542p-2, 0x1.666666p+0},
  {0x1p+0, 0x1.d1746p-1},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.77218ep+11, 0x1.51eb86p-2},
  {0x1.30555p+8, 0x1.99999ap-2},
  {0x1.38f81ep-3, 0x1.249236p-2},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.232442p-1, 0x1.249236p-2},
  {0x1.001c5p+0, 0x1.51eb86p-2},
  {0x1.33f6c2p-3, 0x1.666666p+0},
  {0x1.015182p+0, 0x1.d1746p-1},
  {0x1.a39326p-2, 0x1.666666p+0},
  {0x1.8df676p+4, 0x1.51eb86p-2},
  {0x1.384adcp+28, 0x1.99999ap-2},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.3acb16p+11, 0x1.19999ap+0},
  {0x1.88891ap-1, 0x1.249236p-2},
  {0x1.06b638p+4, 0x1.d1746p-1},
  {0x1.ce6c0ap-12, 0x1.4f5c28p+0},
  {0x1.a8ae02p+6, 0x1.d1746p-1},
  {0x1.2ca46ep-2, 0x1.666666p+0},
  {0x1.5dc0a8p+0, 0x1.51eb86p-2},
  {0x1.ac200cp-1, 0x1.666666p+0},
  {0x1.73639p-1, 0x1.19999ap+0},
  {0x1.fac216p-1, -0x1.249236p-2},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.ac8a38p-8, 0x1.19999ap+0},
  {0x1.f22a0ap-1, 0x1.249236p-2},
  {0x1.cf8962p+0, 0x1.d1746p-1},
  {0x1.301b44p-2, 0x1.666666p+0},
  {0x1.b702b8p+2, 0x1.51eb86p-2},
  {0x1.3cea08p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.e19f5ep-1, 0x1.666666p+0},
  {0x1.d76fa6p+9, 0x1.99999ap-2},
  {0x1.ae4086p-4, 0x1.d51eb8p+2},
  {0x1.6d4212p+5, 0x1.19999ap+0},
  {0x1.05eabcp+0, 0x1.51eb86p-2},
  {0x1.000778p+0, 0x1.51eb86p-2},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.776c6ap-1, 0x1.666666p+0},
  {0x1.46dacap+0, 0x1.d1746p-1},
  {0x1.f6c28cp-1, 0x1.249236p-2},
  {0x1.2f6a4ap+4, 0x1.19999ap+0},
  {0x1.d760cp-3, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.1db1fap+0, 0x1.23586cp-2},
  {0x1.37d09p+33, 0x1.99999ap-2},
  {0x1.150374p+0, 0x1.99999ap-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.1b91d2p+4, 0x1.19999ap+0},
  {0x1.d64778p-2, 0x1.666666p+0},
  {0x1.2fc746p+33, 0x1.99999ap-2},
  {0x1.73f9a4p-2, 0x1.249236p-2},
  {0x1.010a24p+0, 0x1.51eb86p-2},
  {0x1.ea4314p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.04e336p-1, 0x1.666666p+0},
  {0x1.c12de4p+5, 0x1.99999ap-2},
  {0x1.3e75b2p+12, 0x1.19999ap+0},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.19111ap+4, 0x1.19999ap+0},
  {0x1.b481b2p-3, 0x1.249236p-2},
  {0x1.712c3p+13, 0x1.d1746p-1},
  {0x1.1904b4p-13, 0x1.99999ap-1},
  {0x1.40c14ap+7, 0x1.51eb86p-2},
  {0x1.3b7198p-1, 0x1.666666p+0},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.d06034p-2, 0x1.666666p+0},
  {0x1.05307ap+0, 0x1.51eb86p-2},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.01849p+0, 0x1.51eb86p-2},
  {0x1.12fc6cp+4, 0x1.51eb86p-2},
  {0x1.fc1e7ap-1, 0x1.249236p-2},
  {0x1.000f24p+0, 0x1.51eb86p-2},
  {0x1.9d3dc8p-3, 0x1.666666p+0},
  {0x1.3ac6fp-1, 0x1.19999ap+0},
  {0x1.cb34e8p-3, 0x1.666666p+0},
  {0x1.380f14p+13, 0x1.99999ap-2},
  {0x1.04611p-1, 0x1.666666p+0},
  {0x1.00051cp+0, 0x1.99999ap-2},
  {0x1.a6dd2ap+25, 0x1.99999ap-2},
  {0x1.2dedaep-4, 0x1.19999ap+0},
  {0x1.007768p+0, 0x1.d1746p-1},
  {0x1.97012ap+3, 0x1.51eb86p-2},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.e303cp-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.8a72eap-2, 0x1.249236p-2},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.50ae54p-2, 0x1.666666p+0},
  {0x1.8b9278p+4, 0x1.51eb86p-2},
  {0x1.056474p+0, -0x1.249236p-2},
  {0x1.77858ap+9, 0x1.51eb86p-2},
  {0x1.3ee07ep+11, 0x1.51eb86p-2},
  {0x1.0f11p+3, 0x1.51eb86p-2},
  {0x1.032f34p+0, 0x1.99999ap-2},
  {0x1.5b24a6p-2, 0x1.249236p-2},
  {0x1.2dfd6ap-12, 0x1.19999ap+0},
  {0x1.7c3c18p-1, 0x1.249236p-2},
  {0x1.07d392p+0, 0x1.d1746p-1},
  {0x1.cde00ep-3, 0x1.666666p+0},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.d7d8fp-1, 0x1.666666p+0},
  {0x1.b9eacp+2, 0x1.51eb86p-2},
  {0x1.38d998p+8, 0x1.19999ap+0},
  {0x1.05b26p+0, 0x1.51eb86p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.b01754p-4, 0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.358538p-3, 0x1.666666p+0},
  {0x1.1842dep+9, 0x1.d1746p-1},
  {0x1.e4016p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.a8ebccp-2, 0x1.666666p+0},
  {0x1.9efa1p+5, 0x1.99999ap-2},
  {0x1.ba088ep+0, 0x1.d1746p-1},
  {0x1.000bccp+0, 0x1.51eb86p-2},
  {0x1.3e8d88p+5, 0x1.19999ap+0},
  {0x1.46c16p+5, 0x1.51eb86p-2},
  {0x1.287dc4p+0, 0x1.d1746p-1},
  {0x1.4ab474p-1, 0x1.666666p+0},
  {0x1.32c51ap-4, 0x1.19999ap+0},
  {0x1.abe166p-1, 0x1.666666p+0},
  {0x1.070f8cp+0, 0x1.d1746p-1},
  {0x1.f75a54p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.2dd5d4p-2, 0x1.666666p+0},
  {0x1.0c5bbp+0, 0x1.51eb86p-2},
  {0x1.004674p+0, 0x1.51eb86p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.d594bp-1, 0x1.249236p-2},
  {0x1.0ea476p+0, 0x1.d1746p-1},
  {0x1.f7bf84p-1, 0x1.249236p-2},
  {0x1.1b2764p+2, 0x1.51eb86p-2},
  {0x1.0c675ap-2, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.fe0ac8p-1, 0x1.666666p+0},
  {0x1.737542p-5, 0x1.19999ap+0},
  {0x0p+0, 0x1.19999ap+0},
  {0x1p+0, 0x1.99999ap-2},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.352008p-3, 0x1.249236p-2},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.0624dep-11, 0x1.4f5c28p+0},
  {0x1.b703a8p+2, 0x1.51eb86p-2},
  {0x1.192c28p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.544028p-2, 0x1.666666p+0},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.804e4p-1, 0x1.af5c28p+2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.90b4fap+14, 0x1.d1746p-1},
  {0x1.00025cp+0, 0x1.51eb86p-2},
  {0x1.7f0292p+5, 0x1.51eb86p-2},
  {0x1.569446p-1, 0x1.666666p+0},
  {0x1.282c2cp+0, 0x1.d1746p-1},
  {0x1.211234p-4, 0x1.249236p-2},
  {0x1.3e69e6p+4, 0x1.19999ap+0},
  {0x1.cdde38p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.bb68aep-1, 0x1.666666p+0},
  {0x1.002fc6p+0, 0x1.d1746p-1},
  {0x1.0017p+0, 0x1.51eb86p-2},
  {0x1.00e26ep+0, 0x1.51eb86p-2},
  {0x1.36e9aep+3, 0x1.51eb86p-2},
  {0x1.284fb2p-1, 0x1.249236p-2},
  {0x1.e9aa68p+16, 0x1.99999ap-2},
  {0x1.cdfce4p-5, 0x1.249236p-2},
  {0x1.cf67b2p-6, 0x1.19999ap+0},
  {0x1.e4f638p-1, 0x1.666666p+0},
  {0x1.3ae36p+13, 0x1.19999ap+0},
  {0x1.fbc622p-1, 0x1.666666p+0},
  {0x1.004fap+0, 0x1.51eb86p-2},
  {0x1.0082aep+0, 0x1.249236p-2},
  {0x1.3e4086p-1, 0x1.19999ap+0},
  {0x1.10483cp+3, 0x1.51eb86p-2},
  {0x1.6e9a2cp-3, 0x1.249236p-2},
  {0x1.7543aep-4, 0x1.19999ap+0},
  {0x1.1f4fb6p-1, 0x1.666666p+0},
  {0x1.4fc866p+3, 0x1.99999ap-2},
  {0x1.013fdp-2, 0x1.249236p-2},
  {0x1.486e7ep-2, 0x1.19999ap+0},
  {0x1.2fa4a4p-1, 0x1.666666p+0},
  {0x1.00053ep+0, 0x1.99999ap-2},
  {0x1.f63f78p-1, 0x1.666666p+0},
  {0x1.771366p+12, 0x1.51eb86p-2},
  {0x1.007d4ep+0, 0x1.d1746p-1},
  {0x1.416ae2p+11, 0x1.d1746p-1},
  {0x1.0ab628p+0, 0x1.d1746p-1},
  {0x1.67297p-3, 0x1.666666p+0},
  {0x1.3e8e5p+2, 0x1.19999ap+0},
  {0x1.4f0542p-1, 0x1.249236p-2},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.7a03e6p-1, 0x1.666666p+0},
  {0x1.0515e6p+6, 0x1.d1746p-1},
  {0x1.a3443ep-2, 0x1.666666p+0},
  {0x1.72b452p-3, 0x1.19999ap+0},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.8f7fp+4, 0x1.51eb86p-2},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.fd3c36p-3, 0x1.249236p-2},
  {0x1.3445bap+0, 0x1.19999ap+0},
  {0x1.2be48ap-12, 0x1.4f5c28p+0},
  {0x1.5262acp+6, 0x1.19999ap+0},
  {0x1.fbc3c6p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.fcbfb2p-1, 0x1.666666p+0},
  {0x1.392556p+6, 0x1.19999ap+0},
  {0x1.fd22c8p-1, 0x1.249236p-2},
  {0x1.015572p+0, 0x1.d1746p-1},
  {0x1.5d17e8p+1, 0x1.99999ap-2},
  {0x1.8700f8p+4, 0x1.51eb86p-2},
  {0x1.0b19bcp+4, 0x1.d1746p-1},
  {0x1.7f4b4p-1, 0x1.666666p+0},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.c52ac8p-2, 0x1.249236p-2},
  {0x1.b146a6p+2, 0x1.d1746p-1},
  {0x1.be4474p-1, 0x1.666666p+0},
  {0x1.801afap+7, 0x1.51eb86p-2},
  {0x1.0d3f18p-2, 0x1.666666p+0},
  {0x1.0cc672p+0, 0x1.51eb86p-2},
  {0x1.0270f4p+0, 0x1.99999ap-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.c363f6p-2, 0x1.249236p-2},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.0c6f7ap-18, 0x1.4f5c28p+0},
  {0x1.349386p-6, 0x1.19999ap+0},
  {0x1.d78f8ap-1, 0x1.666666p+0},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.5680ep-1, 0x1.666666p+0},
  {0x1.3e472cp+2, 0x1.19999ap+0},
  {0x1.b70186p+2, 0x1.51eb86p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.7ec27ap+2, 0x1.51eb86p-2},
  {0x1.42c14cp+6, 0x1.51eb86p-2},
  {0x1.4ba366p+0, 0x1.51eb86p-2},
  {0x1.3af0cp-1, 0x1.666666p+0},
  {0x1.6a6a1ap+1, 0x1.51eb86p-2},
  {0x1.9de00ep-1, 0x1.249236p-2},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.a2b778p-2, 0x1.666666p+0},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.0095bp+0, 0x1.249236p-2},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.0011f4p+0, 0x1.d1746p-1},
  {0x1.1b8d92p+0, 0x1.51eb86p-2},
  {0x1.874774p-1, 0x1.19999ap+0},
  {0x1.dbbc0ap-1, 0x1.249236p-2},
  {0x1.0c52a4p+0, 0x1.99999ap-2},
  {0x1.29cbacp-10, 0x1.a3d70ap-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.f63de6p-1, 0x1.666666p+0},
  {0x1.55b308p+0, 0x1.d1746p-1},
  {0x1.973cb4p-1, 0x1.666666p+0},
  {0x1.bb80fep+0, 0x1.51eb86p-2},
  {0x1.3ac3fp+3, 0x1.19999ap+0},
  {0x1.000992p+0, 0x1.51eb86p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.fd5498p-2, 0x1.249236p-2},
  {0x1.88fc6ep+14, 0x1.d1746p-1},
  {0x1.d23c42p-3, 0x1.666666p+0},
  {0x1.27f4f4p+17, 0x1.99999ap-2},
  {0x1.c83794p-1, 0x1.666666p+0},
  {0x1.39218ap+9, 0x1.19999ap+0},
  {0x1.2d0072p-2, 0x1.666666p+0},
  {0x1.3f7836p+0, 0x1.51eb86p-2},
  {0x1.3a7654p-3, 0x1p-1},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.1f9ea6p+1, 0x1.d1746p-1},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.aee194p+2, 0x1.d1746p-1},
  {0x1.8a4cc6p-1, 0x1.249236p-2},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.64096p-4, 0x1.249236p-2},
  {0x1.1bb116p+9, 0x1.d1746p-1},
  {0x1.d83d7ap-3, 0x1.666666p+0},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.c5de9cp-3, 0x1.666666p+0},
  {0x1.001052p+0, 0x1.99999ap-2},
  {0x1.ba177p+10, 0x1.99999ap-2},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.97dd22p+0, 0x1.d1746p-1},
  {0x1.513404p-2, 0x1.249236p-2},
  {0x1.45fecap+0, 0x1.d1746p-1},
  {0x1.92a738p-19, 0x1.4f5c28p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.072218p-3, 0x1.666666p+0},
  {0x1.b0296cp+1, 0x1.d1746p-1},
  {0x1.a76d12p-2, 0x1.666666p+0},
  {0x1.7b02b2p+6, 0x1.51eb86p-2},
  {0x1.3cfa48p-1, 0x1.b51eb8p+3},
  {0x1.3e43ccp-1, 0x1.19999ap+0},
  {0x0p+0, 0x1.19999ap+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.168b3ap+9, 0x1.d1746p-1},
  {0x1.01a9dap+0, 0x1.666666p+0},
  {0x1.0008b8p+0, 0x1.99999ap-2},
  {0x1.24e3dep-1, 0x1.249236p-2},
  {0x1.62fdp+0, 0x1.99999ap-2},
  {0x1.15c7cep-1, 0x1.666666p+0},
  {0x1.12aee2p+0, 0x1.d1746p-1},
  {0x1.959b3ep-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.433c3ep-1, 0x1.19999ap+0},
  {0x1.007f66p+0, 0x1.51eb86p-2},
  {0x1.1848eep+9, 0x1.d1746p-1},
  {0x1.743a64p-3, 0x1.249236p-2},
  {0x1.771704p+12, 0x1.51eb86p-2},
  {0x1.c4fc1ep-14, 0x1.a3d70ap-2},
  {0x1.1b840ap+9, 0x1.d1746p-1},
  {0x1.c97daep-1, 0x1.666666p+0},
  {0x1.5e806cp+16, 0x1.99999ap-2},
  {0x1.cccfaep-1, 0x1.666666p+0},
  {0x1.7e173p+11, 0x1.51eb86p-2},
  {0x1.ab69dcp-2, 0x1.bp+3},
  {0x1.3acc74p+9, 0x1.19999ap+0},
  {0x1.46c2ep+5, 0x1.51eb86p-2},
  {0x1.630faep-1, 0x1.249236p-2},
  {0x1.4f5de6p+15, 0x1.99999ap-2},
  {0x1.3422ccp-3, 0x1.666666p+0},
  {0x1.855cfap-1, 0x1.19999ap+0},
  {0x1.bbab44p-1, 0x1.249236p-2},
  {0x1.00151ap+0, 0x1.d1746p-1},
  {0x1.d6277cp-2, 0x1.666666p+0},
  {0x1.7b5aeap-6, 0x1.19999ap+0},
  {0x1.51c9b4p-2, 0x1.666666p+0},
  {0x1.00028ep+0, 0x1.51eb86p-2},
  {0x1.001dbp+0, 0x1.51eb86p-2},
  {0x1.447e4ap-5, 0x1.19999ap+0},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.380992p-3, 0x1.249236p-2},
  {0x1.4fc0b2p+3, 0x1.99999ap-2},
  {0x1.f75104p-16, 0x1.a3d70ap-2},
  {0x1.47c18cp+0, 0x1.99999ap-2},
  {0x1.f7a1c2p-1, 0x1.666666p+0},
  {0x1.26d7a6p+0, 0x1.d1746p-1},
  {0x1.7d145ep-2, 0x1.666666p+0},
  {0x1.005e1cp+0, 0x1.99999ap-2},
  {0x1.6633fp-1, 0x1.90a3d8p+2},
  {0x1.3c2a78p+2, 0x1.19999ap+0},
  {0x1.79c5f8p+10, 0x1.99999ap-2},
  {0x1.b1b8aap-4, 0x1.249236p-2},
  {0x1.000b78p+0, 0x1.d1746p-1},
  {0x1.a65c0cp-1, 0x1.666666p+0},
  {0x1.265c7p+0, 0x1.19999ap+0},
  {0x1.c08df4p-1, 0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.4eeccp-2, 0x1.666666p+0},
  {0x1.002b84p+0, 0x1.51eb86p-2},
  {0x1.818b94p+1, 0x1.243808p-2},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.aecbacp+2, 0x1.d1746p-1},
  {0x1.3fc19cp+8, 0x1.51eb86p-2},
  {0x1.9a1912p+0, 0x1.d1746p-1},
  {0x1.00781p-2, 0x1.249236p-2},
  {0x1.8e448ep+15, 0x1.99999ap-2},
  {0x1.f4b556p-1, 0x1.249236p-2},
  {0x1.4ee8d2p-4, 0x1.19999ap+0},
  {0x1.b66948p-1, 0x1.666666p+0},
  {0x1.f7810ep+2, 0x1.d1746p-1},
  {0x1.d728a6p-3, 0x1.666666p+0},
  {0x1.9e1b2ap+1, 0x1.99999ap-2},
  {0x1.00c2f8p+0, 0x1.d1746p-1},
  {0x1.e92694p+4, 0x1.51eb86p-2},
  {0x1.5ec3d2p+3, 0x1.51eb86p-2},
  {0x1.cfa072p-1, 0x1.249236p-2},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.f9ea36p-1, 0x1.666666p+0},
  {0x1.012c38p+0, 0x1.99999ap-2},
  {0x1.b0ac3ap-4, 0x1.249236p-2},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.02f48cp-1, 0x1.666666p+0},
  {0x1.4b9a2p+3, 0x1.99999ap-2},
  {0x1.ae4086p-4, 0x1.d51eb8p+2},
  {0x1.d64c3cp+3, 0x1.51eb86p-2},
  {0x1.7d0054p+4, 0x1.19999ap+0},
  {0x1.fb73f4p-1, 0x1.249236p-2},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.217f42p-4, 0x1.249236p-2},
  {0x1.bec29cp+1, 0x1.51eb86p-2},
  {0x1.c15098p-11, 0x1.a3d70ap-2},
  {0x1.1f61ccp+1, 0x1.51eb86p-2},
  {0x1.5a02fcp-1, 0x1.666666p+0},
  {0x1.4cd49p+5, 0x1.51eb86p-2},
  {0x1.9a964ep-3, 0x1.666666p+0},
  {0x1.40c1b4p+7, 0x1.51eb86p-2},
  {0x1.45a44cp+11, 0x1.d1746p-1},
  {0x1.46c16ep+5, 0x1.51eb86p-2},
  {0x1.0953ecp+8, 0x1.d1746p-1},
  {0x1.b07d0ap-4, 0x1.249236p-2},
  {0x1.79035ap+7, 0x1.51eb86p-2},
  {0x1.f2e276p-1, 0x1.666666p+0},
  {0x1.3b81d8p+1, 0x1.51eb86p-2},
  {0x1.4ec8d6p-2, 0x1.666666p+0},
  {0x1.3e3582p+0, 0x1.d1746p-1},
  {0x1.77ee2cp-1, 0x1.666666p+0},
  {0x1.000314p+0, 0x1.51eb86p-2},
  {0x1.bf5ba2p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.00001p+0, 0x1.99999ap-2},
  {0x1.1d8876p+4, 0x1.51eb86p-2},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.f8d5a6p-1, 0x1.249236p-2},
  {0x1.16d7fap+0, 0x1.99999ap-2},
  {0x1.aaed9ap-3, 0x1.249236p-2},
  {0x1.029446p+0, 0x1.d1746p-1},
  {0x1.0cf0b6p-2, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.e6f9fcp-1, 0x1.666666p+0},
  {0x1.32b074p+0, 0x1.d1746p-1},
  {0x1.2a9e6p+18, 0x1.99999ap-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.4f36acp+0, 0x1.d1746p-1},
  {0x1.a7659p+15, 0x1.99999ap-2},
  {0x1.b91298p-1, 0x1.19999ap+0},
  {0x1.058b6p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.f6d9bep-1, 0x1.666666p+0},
  {0x1.4f8b58p-10, 0x1.19999ap+0},
  {0x1.fdb2b4p-3, 0x1.666666p+0},
  {0x1.003e86p+0, 0x1.d1746p-1},
  {0x1.1ec4e8p-1, 0x1.666666p+0},
  {0x1.001c82p+0, 0x1.99999ap-2},
  {0x1.870276p+4, 0x1.51eb86p-2},
  {0x1.000f66p+0, 0x1.51eb86p-2},
  {0x1.000d5ep+0, 0x1.51eb86p-2},
  {0x1.1ba3ecp-1, 0x1.666666p+0},
  {0x1.03eb4ap+0, 0x1.99999ap-2},
  {0x1.190b64p-1, 0x1.249236p-2},
  {0x1.3e8d38p+3, 0x1.19999ap+0},
  {0x1.9cba3p-3, 0x1.666666p+0},
  {0x1.00001p+0, 0x1.99999ap-2},
  {0x1.38c0aep-1, 0x1.666666p+0},
  {0x1.a8082cp+4, 0x1.19999ap+0},
  {0x1.507704p+1, 0x1.d1746p-1},
  {0x1.90646cp+14, 0x1.d1746p-1},
  {0x1.00ae74p+0, 0x1.99999ap-2},
  {0x1.c5714cp-2, 0x1.249236p-2},
  {0x1.00577ep+0, 0x1.d1746p-1},
  {0x1.d87012p-2, 0x1.666666p+0},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.05aa2ep-3, 0x1.249236p-2},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.f548ccp-1, 0x1.666666p+0},
  {0x1.51c5c6p-8, 0x1.19999ap+0},
  {0x1.f2717ap-1, 0x1.666666p+0},
  {0x1.0ca148p+1, 0x1.51eb86p-2},
  {0x1.3884c4p+18, 0x1.99999ap-2},
  {0x1.000fecp+0, 0x1.51eb86p-2},
  {0x1.000022p+0, 0x1.99999ap-2},
  {0x1.292428p-2, 0x1.249236p-2},
  {0x1.ad8caap+25, 0x1.99999ap-2},
  {0x1.a5b27p-1, 0x1.249236p-2},
  {0x1.f1886ep-2, 0x1.19999ap+0},
  {0x1.b87486p-1, 0x1.666666p+0},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.bda598p-1, 0x1.666666p+0},
  {0x1.29f40ap-2, 0x1.19999ap+0},
  {0x1.c2d2bcp-2, 0x1.d51eb8p+2},
  {0x1.019568p+0, 0x1.d1746p-1},
  {0x1.062318p+0, 0x1.d1746p-1},
  {0x1.b23a2ap-3, 0x1.249236p-2},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.0432a8p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.0642cp-3, 0x1.249236p-2},
  {0x1.00463p+0, 0x1.51eb86p-2},
  {0x1.651ap-3, 0x1.666666p+0},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.142adcp+0, 0x1.23ea2ep-2},
  {0x0p+0, 0x1.51eb86p-2},
  {0x1.000608p+0, 0x1.51eb86p-2},
  {0x1.0008b8p+0, 0x1.51eb86p-2},
  {0x1.b702acp+2, 0x1.51eb86p-2},
  {0x1.50eb24p-1, 0x1.249236p-2},
  {0x1.0581ecp+3, 0x1.d1746p-1},
  {0x1.6f5cbp-3, 0x1.249236p-2},
  {0x1.12cdf2p+0, 0x1.d1746p-1},
  {0x1.6678cp-3, 0x1.666666p+0},
  {0x1.032faap+0, 0x1.d1746p-1},
  {0x1.a112fep-2, 0x1.666666p+0},
  {0x1.594296p+2, 0x1.51eb86p-2},
  {0x1.262026p-8, 0x1.19999ap+0},
  {0x1.02bdc2p+0, 0x1.51eb86p-2},
  {0x1.c400aep+3, 0x1.d1746p-1},
  {0x1.da454ep-1, 0x1.249236p-2},
  {0x1.184adap+9, 0x1.d1746p-1},
  {0x1.5c5a3ep-1, 0x1.666666p+0},
  {0x1.ceada6p+5, 0x1.d1746p-1},
  {0x1.8cf03p-1, 0x1.249236p-2},
  {0x1.569b5ep+12, 0x1.d1746p-1},
  {0x1.7d028ap-2, 0x1.666666p+0},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.4a7b4ep-1, 0x1.8f5c28p+3},
  {0x1.031972p+0, 0x1.51eb86p-2},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.b701dap+2, 0x1.51eb86p-2},
  {0x1.3ed14p+12, 0x1.51eb86p-2},
  {0x1.04052ep+0, 0x1.249236p-2},
  {0x1.00521ep+0, 0x1.51eb86p-2},
  {0x1.d094e6p-1, 0x1.249236p-2},
  {0x1.1715cp+5, 0x1.d1746p-1},
  {0x1.3a08cp-1, 0x1.666666p+0},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.661c7ap-3, 0x1.666666p+0},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.017e02p+0, 0x1.d1746p-1},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.ae8e8ep+2, 0x1.d1746p-1},
  {0x1.d58212p-1, 0x1.249236p-2},
  {0x1.7abca6p+7, 0x1.d1746p-1},
  {0x1.f0eb68p-1, 0x1.666666p+0},
  {0x1.2c3a1ep+10, 0x1.d1746p-1},
  {0x1.09af18p-2, 0x1.666666p+0},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.543e1p-2, 0x1.666666p+0},
  {0x1.3e5f32p+9, 0x1.19999ap+0},
  {0x1.4d3112p-1, 0x1.8f5c28p+3},
  {0x1.000874p+0, 0x1.51eb86p-2},
  {0x1.7f7af6p-1, 0x1.19999ap+0},
  {0x1.7ca2p+3, 0x1.51eb86p-2},
  {0x1.56a6e4p+1, 0x1.99999ap-2},
  {0x1.3bedfap-1, 0x1.666666p+0},
  {0x1.00a2ap+1, 0x1.51eb86p-2},
  {0x1.8a0b1cp-1, 0x1.249236p-2},
  {0x1.744728p+5, 0x1.19999ap+0},
  {0x1.071f7ap-3, 0x1.666666p+0},
  {0x1.97d2a6p+0, 0x1.d1746p-1},
  {0x1.a52c9ep-2, 0x1.666666p+0},
  {0x1.4p+2, 0x1.51eb86p-2},
  {0x1.0f6b1ap+0, 0x1.d1746p-1},
  {0x1.0e630ep+0, 0x1.51eb86p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.6a2d72p-1, 0x1.249236p-2},
  {0x1.0001a4p+0, 0x1.51eb86p-2},
  {0x1.a5c358p-3, 0x1.249236p-2},
  {0x1.2fb7c8p+28, 0x1.99999ap-2},
  {0x1.65eaacp-3, 0x1.666666p+0},
  {0x1.59a30ap-8, 0x1.19999ap+0},
  {0x1.3539fcp-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.fb851ep-1, -0x1.249236p-2},
  {0x1.000032p+0, 0x1.99999ap-2},
  {0x1.358666p+0, 0x1.99999ap-2},
  {0x1.0014c6p+0, 0x1.51eb86p-2},
  {0x1.02eeb8p+0, 0x1.d1746p-1},
  {0x1.348776p-3, 0x1.666666p+0},
  {0x1.3293d2p-9, 0x1.19999ap+0},
  {0x1.00d1d8p+0, 0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.796bdcp-1, 0x1.666666p+0},
  {0x1.006888p+0, 0x1.d1746p-1},
  {0x1.396872p-1, 0x1.666666p+0},
  {0x1.6318c2p+2, 0x1.d1746p-1},
  {0x1.001398p+0, 0x1.51eb86p-2},
  {0x1.e37a7p+0, 0x1.d1746p-1},
  {0x1.99413ap+1, 0x1.51eb86p-2},
  {0x1.29fep-1, 0x1.249236p-2},
  {0x1.3ae404p+8, 0x1.19999ap+0},
  {0x1.06937ep-3, 0x1.249236p-2},
  {0x1.208dacp+13, 0x1.99999ap-2},
  {0x1.d4039ap-2, 0x1.666666p+0},
  {0x1.7e5aaap+6, 0x1.19999ap+0},
  {0x1.5385c6p-2, 0x1.666666p+0},
  {0x1.00042p+0, 0x1.51eb86p-2},
  {0x1.fca516p-1, -0x1.249236p-2},
  {0x1.713616p+13, 0x1.d1746p-1},
  {0x1.0030c2p+0, 0x1.99999ap-2},
  {0x1.cee0f4p-1, 0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.071ac2p-3, 0x1.666666p+0},
  {0x1.970316p+3, 0x1.51eb86p-2},
  {0x1.284f0ap-2, 0x1.249236p-2},
  {0x1.8bd418p+14, 0x1.d1746p-1},
  {0x1.94432cp-1, 0x1.666666p+0},
  {0x1.398fd6p+0, 0x1.51eb86p-2},
  {0x1.33aa36p-3, 0x1.666666p+0},
  {0x1.8f27bcp+1, 0x1.51eb86p-2},
  {0x1.36dfb6p+5, 0x1.99999ap-2},
  {0x1.5ea8b8p+1, 0x1.51eb86p-2},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.e5dbfcp-1, 0x1.249236p-2},
  {0x1.778264p+9, 0x1.51eb86p-2},
  {0x1.53bd16p-13, 0x1.99999ap-1},
  {0x1.968e32p+3, 0x1.d1746p-1},
  {0x1.e38066p-1, 0x1.666666p+0},
  {0x1.1bcf06p+13, 0x1.99999ap-2},
  {0x1.5c5308p-1, 0x1.666666p+0},
  {0x1.00096p+0, 0x1.51eb86p-2},
  {0x1.0494e6p+0, 0x1.249236p-2},
  {0x1.001b32p+0, 0x1.51eb86p-2},
  {0x1.3ee508p+11, 0x1.51eb86p-2},
  {0x1.af2d8p-4, 0x1.249236p-2},
  {0x1.00547ap+0, 0x1.d1746p-1},
  {0x1.eaa5e8p-1, 0x1.666666p+0},
  {0x1.ae62a6p+8, 0x1.99999ap-2},
  {0x1.013c04p-1, 0x1.249236p-2},
  {0x1.3e527p+12, 0x1.19999ap+0},
  {0x1.754f5ap-1, 0x1.666666p+0},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.1f05eap+0, 0x1.2360dp-2},
  {0x1.f7037ep+1, 0x1.51eb86p-2},
  {0x1.2fd448p+10, 0x1.d1746p-1},
  {0x1.001cd6p+0, 0x1.51eb86p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.289daep-2, 0x1.249236p-2},
  {0x1.1f6d34p+0, 0x1.d1746p-1},
  {0x1.3cab82p-13, 0x1.99999ap-1},
  {0x1.ba54e4p+20, 0x1.99999ap-2},
  {0x1.2ce1c6p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.8af3c2p-1, 0x1.666666p+0},
  {0x1.d57ffap-8, 0x1.19999ap+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.a7290ep+30, 0x1.99999ap-2},
  {0x1.02c1b2p+0, 0x1.99999ap-2},
  {0x1.fc2706p+1, 0x1.d1746p-1},
  {0x1.06ba4ap-3, 0x1.666666p+0},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.f30036p-1, 0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.4f34d6p-2, 0x1.666666p+0},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.7b431p-2, 0x1.666666p+0},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.a72726p+15, 0x1.99999ap-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.4f92bp-4, 0x1.19999ap+0},
  {0x1.f740a2p-1, 0x1.249236p-2},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.7b6aa4p-1, 0x1.666666p+0},
  {0x1.4e0382p+0, 0x1.99999ap-2},
  {0x1.e80b46p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.b4c122p-1, 0x1.666666p+0},
  {0x1.391bc6p+1, 0x1.19999ap+0},
  {0x1.02e4cp+0, 0x1.249236p-2},
  {0x1.cc610ep+8, 0x1.99999ap-2},
  {0x1.0017dap+0, 0x1.51eb86p-2},
  {0x1.0005c4p+0, 0x1.51eb86p-2},
  {0x1.4d716ep-4, 0x1.19999ap+0},
  {0x1.29746p-2, 0x1.666666p+0},
  {0x1.3aefeap+13, 0x1.19999ap+0},
  {0x1.8e395p-1, 0x1.249236p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.d4727ep-3, 0x1.666666p+0},
  {0x1.eb4cfep+1, 0x1.51eb86p-2},
  {0x1.fb3a48p-1, 0x1.666666p+0},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.39092ap+5, 0x1.19999ap+0},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.003904p+0, 0x1.d1746p-1},
  {0x1.ce50c6p-5, 0x1.249236p-2},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.52b0a6p-12, 0x1.4f5c28p+0},
  {0x1.2f8d58p+13, 0x1.99999ap-2},
  {0x1.d28178p-3, 0x1.666666p+0},
  {0x1.3ee4a4p+11, 0x1.51eb86p-2},
  {0x1.3cb38p-1, 0x1.666666p+0},
  {0x1.6847c4p+0, 0x1.d1746p-1},
  {0x1.dd7d3ap-2, 0x1.b51eb8p+3},
  {0x1.b704a2p+2, 0x1.51eb86p-2},
  {0x1.40c324p+7, 0x1.51eb86p-2},
  {0x1.7900dep+7, 0x1.51eb86p-2},
  {0x1.000758p+0, 0x1.51eb86p-2},
  {0x1.65460ap-3, 0x1.666666p+0},
  {0x1.7e1fcp-3, 0x1.19999ap+0},
  {0x1.649d38p-4, 0x1.249236p-2},
  {0x1.186cbp+9, 0x1.d1746p-1},
  {0x1.d63886p-3, 0x1.666666p+0},
  {0x1.3b814p+1, 0x1.51eb86p-2},
  {0x1.d5c854p-3, 0x1.666666p+0},
  {0x1.11e27ap+0, 0x1.d1746p-1},
  {0x1.aed4ep+5, 0x1.99999ap-2},
  {0x1.7f023cp+5, 0x1.51eb86p-2},
  {0x1.000032p+0, 0x1.99999ap-2},
  {0x1.22089ep-4, 0x1.249236p-2},
  {0x1.ad8b4p+4, 0x1.d1746p-1},
  {0x1.6ee41ap-3, 0x1.249236p-2},
  {0x1.1e27f2p+0, 0x1.d1746p-1},
  {0x1.fa8a62p-1, 0x1.666666p+0},
  {0x1.38c468p+8, 0x1.d1746p-1},
  {0x1.d6ce36p-2, 0x1.666666p+0},
  {0x1.037ec4p+0, 0x1.51eb86p-2},
  {0x1.16d1cp-1, 0x1.70a3d8p+3},
  {0x1.25c456p+4, 0x1.19999ap+0},
  {0x1.870122p+4, 0x1.51eb86p-2},
  {0x1.365fd8p-3, 0x1.249236p-2},
  {0x1.fbdc8cp-1, 0x1.19999ap+0},
  {0x1.d56756p-3, 0x1.666666p+0},
  {0x1.cf888p+5, 0x1.d1746p-1},
  {0x1.70b9bap-1, 0x1.249236p-2},
  {0x1.391ddep-3, 0x1.19999ap+0},
  {0x1.a7a9e2p-1, 0x1.666666p+0},
  {0x1.a6de18p+4, 0x1.d1746p-1},
  {0x1.02ad6p-1, 0x1.666666p+0},
  {0x1.06e01ap+0, 0x1.51eb86p-2},
  {0x1.3fb284p+3, 0x1.d1746p-1},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.00062ap+0, 0x1.51eb86p-2},
  {0x1.f41e14p-1, 0x1.666666p+0},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.fa07b4p-3, 0x1.249236p-2},
  {0x0p+0, 0x1.19999ap+0},
  {0x1.d84ad8p-2, 0x1.666666p+0},
  {0x1.bec366p+1, 0x1.51eb86p-2},
  {0x1.e7d6d8p-1, 0x1.666666p+0},
  {0x1.3e5eaap-3, 0x1.19999ap+0},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.001d7ep+0, 0x1.51eb86p-2},
  {0x1p+0, 0x1.99999ap-2},
  {0x1.05681ep-3, 0x1.249236p-2},
  {0x1.01a05ap+0, 0x1.99999ap-2},
  {0x1.355f78p-3, 0x1.666666p+0},
  {0x1.3ae4e6p+12, 0x1.19999ap+0},
  {0x1.06d938p-3, 0x1.249236p-2},
  {0x1p+0, 0x1.d1746p-1},
  {0x1.e50fe8p-1, 0x1.666666p+0},
  {0x1.631f36p+0, 0x1.51eb86p-2},
  {0x1.39a36ep+0, 0x1.23e9a6p-2},
  {0x1p+0, 0x1.51eb86p-2},
  {0x1.01d0d8p+0, 0x1.51eb86p-2},
  {0x1.a94b56p+3, 0x1.d1746p-1},
  {0x1.1a689p+1, 0x1.99999ap-2},
};
