/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

static data_1_1_t<float, float> g_atanf_intel_data[] = {
  { // Entry 0
    -0x1.dc2c98008d535c517dd9d371c44a6151p-2,
    -0x1.00e0p-1
  },
  { // Entry 1
    0x1.dc2c98008d535c517dd9d371c44a6151p-2,
    0x1.00e0p-1
  },
  { // Entry 2
    -0x1.93d63bfce467ef12745bcaf164c988cdp-1,
    -0x1.01b8p0
  },
  { // Entry 3
    0x1.93d63bfce467ef12745bcaf164c988cdp-1,
    0x1.01b8p0
  },
  { // Entry 4
    -0x1.93e6bcfcbf2868bf3d227ad52cc06775p-1,
    -0x1.01c89ep0
  },
  { // Entry 5
    0x1.93e6bcfcbf2868bf3d227ad52cc06775p-1,
    0x1.01c89ep0
  },
  { // Entry 6
    -0x1.e4353f004481a69e0d97136cd8302508p-2,
    -0x1.05ec48p-1
  },
  { // Entry 7
    0x1.e4353f004481a69e0d97136cd8302508p-2,
    0x1.05ec48p-1
  },
  { // Entry 8
    -0x1.980dd942c58931ccfa88aa5714d9589bp-1,
    -0x1.06p0
  },
  { // Entry 9
    0x1.980dd942c58931ccfa88aa5714d9589bp-1,
    0x1.06p0
  },
  { // Entry 10
    -0x1.e4e7050041fea5e474bc42bb3e9598edp-2,
    -0x1.065c78p-1
  },
  { // Entry 11
    0x1.e4e7050041fea5e474bc42bb3e9598edp-2,
    0x1.065c78p-1
  },
  { // Entry 12
    -0x1.fd08daffe290e806775f8df4ed63331fp-2,
    -0x1.15c8e2p-1
  },
  { // Entry 13
    0x1.fd08daffe290e806775f8df4ed63331fp-2,
    0x1.15c8e2p-1
  },
  { // Entry 14
    -0x1.12d0910000acd3796043ce397dc0aaf0p-1,
    -0x1.30a612p-1
  },
  { // Entry 15
    0x1.12d0910000acd3796043ce397dc0aaf0p-1,
    0x1.30a612p-1
  },
  { // Entry 16
    -0x1.8501defc40a94bd69a326f6f4efc3cabp0,
    -0x1.3801p4
  },
  { // Entry 17
    0x1.8501defc40a94bd69a326f6f4efc3cabp0,
    0x1.3801p4
  },
  { // Entry 18
    -0x1.1dbfdb002aafa34d56d4efdeb875d7ccp-1,
    -0x1.3fa5d0p-1
  },
  { // Entry 19
    0x1.1dbfdb002aafa34d56d4efdeb875d7ccp-1,
    0x1.3fa5d0p-1
  },
  { // Entry 20
    -0x1.91c7f6fffff6a5eef58d32a20cb76586p0,
    -0x1.7573fep9
  },
  { // Entry 21
    0x1.91c7f6fffff6a5eef58d32a20cb76586p0,
    0x1.7573fep9
  },
  { // Entry 22
    -0x1.f31d35b81259f5f45badc8b774241b15p-1,
    -0x1.79743ep0
  },
  { // Entry 23
    0x1.f31d35b81259f5f45badc8b774241b15p-1,
    0x1.79743ep0
  },
  { // Entry 24
    -0x1.f54b76ff8c8f4020ccc4dfba5f1dcfc4p-1,
    -0x1.7cefc8p0
  },
  { // Entry 25
    0x1.f54b76ff8c8f4020ccc4dfba5f1dcfc4p-1,
    0x1.7cefc8p0
  },
  { // Entry 26
    -0x1.921fa2ffefea1a475fc6364331e98c0fp0,
    -0x1.c07630p19
  },
  { // Entry 27
    0x1.921fa2ffefea1a475fc6364331e98c0fp0,
    0x1.c07630p19
  },
  { // Entry 28
    -0x1.c8d37cfff9732aae565e96c9ab1ae3p-4,
    -0x1.cabad0p-4
  },
  { // Entry 29
    0x1.c8d37cfff9732aae565e96c9ab1ae3p-4,
    0x1.cabad0p-4
  },
  { // Entry 30
    -0x1.8455816cd8b17910d5fb42c54a7a3f6ap-1,
    -0x1.e52326p-1
  },
  { // Entry 31
    0x1.8455816cd8b17910d5fb42c54a7a3f6ap-1,
    0x1.e52326p-1
  },
  { // Entry 32
    -0x1.87ce6ca38f66951f7d176d27e4cc7114p-1,
    -0x1.ebc518p-1
  },
  { // Entry 33
    0x1.87ce6ca38f66951f7d176d27e4cc7114p-1,
    0x1.ebc518p-1
  },
  { // Entry 34
    0x1.ffd55bba97624a84ef3aeedbb518c427p-6,
    0x1.p-5
  },
  { // Entry 35
    -0x1.ffd55bba97624a84ef3aeedbb518c427p-6,
    -0x1.p-5
  },
  { // Entry 36
    0x1.ff55bf6ed3da98798265cc3f27c896c7p-5,
    0x1.000002p-4
  },
  { // Entry 37
    -0x1.ff55bf6ed3da98798265cc3f27c896c7p-5,
    -0x1.000002p-4
  },
  { // Entry 38
    0x1.ff5632fb474b2bdff859ee6421a12d48p-5,
    0x1.00003cp-4
  },
  { // Entry 39
    -0x1.ff5632fb474b2bdff859ee6421a12d48p-5,
    -0x1.00003cp-4
  },
  { // Entry 40
    0x1.9220654406519246dee218750f6118e0p-1,
    0x1.0000b0p0
  },
  { // Entry 41
    -0x1.9220654406519246dee218750f6118e0p-1,
    -0x1.0000b0p0
  },
  { // Entry 42
    0x1.f5b8c8fc218568d2548c390de7a3dfcep-3,
    0x1.0000c0p-2
  },
  { // Entry 43
    -0x1.f5b8c8fc218568d2548c390de7a3dfcep-3,
    -0x1.0000c0p-2
  },
  { // Entry 44
    0x1.fd64d4fccffaeeedba9c9564a6730d18p-4,
    0x1.0004a8p-3
  },
  { // Entry 45
    -0x1.fd64d4fccffaeeedba9c9564a6730d18p-4,
    -0x1.0004a8p-3
  },
  { // Entry 46
    0x1.9227b5244326d9bed87bdeb00908aeb7p-1,
    0x1.0008p0
  },
  { // Entry 47
    -0x1.9227b5244326d9bed87bdeb00908aeb7p-1,
    -0x1.0008p0
  },
  { // Entry 48
    0x1.922b76ff245e6de6345559ddb2fcf536p-1,
    0x1.000bc2p0
  },
  { // Entry 49
    -0x1.922b76ff245e6de6345559ddb2fcf536p-1,
    -0x1.000bc2p0
  },
  { // Entry 50
    0x1.922b82fe9701aeaffb73a1443c0c83d0p-1,
    0x1.000bcep0
  },
  { // Entry 51
    -0x1.922b82fe9701aeaffb73a1443c0c83d0p-1,
    -0x1.000bcep0
  },
  { // Entry 52
    0x1.923faf44d816daa54d425d8045e2887dp-1,
    0x1.001ffcp0
  },
  { // Entry 53
    -0x1.923faf44d816daa54d425d8045e2887dp-1,
    -0x1.001ffcp0
  },
  { // Entry 54
    0x1.fe2484fd31d3cf098219a2af1d986eedp-4,
    0x1.0066p-3
  },
  { // Entry 55
    -0x1.fe2484fd31d3cf098219a2af1d986eedp-4,
    -0x1.0066p-3
  },
  { // Entry 56
    0x1.92939b003b069b3e275950af80cd63fcp-1,
    0x1.0074p0
  },
  { // Entry 57
    -0x1.92939b003b069b3e275950af80cd63fcp-1,
    -0x1.0074p0
  },
  { // Entry 58
    0x1.1b9d3b002159e2945b595dab6488de5bp0,
    0x1.0076p1
  },
  { // Entry 59
    -0x1.1b9d3b002159e2945b595dab6488de5bp0,
    -0x1.0076p1
  },
  { // Entry 60
    0x1.dc2c98008d535c517dd9d371c44a6151p-2,
    0x1.00e0p-1
  },
  { // Entry 61
    -0x1.dc2c98008d535c517dd9d371c44a6151p-2,
    -0x1.00e0p-1
  },
  { // Entry 62
    0x1.93d63bfce467ef12745bcaf164c988cdp-1,
    0x1.01b8p0
  },
  { // Entry 63
    -0x1.93d63bfce467ef12745bcaf164c988cdp-1,
    -0x1.01b8p0
  },
  { // Entry 64
    0x1.94167efccbc0fa6d4577f69f61e031d2p-1,
    0x1.01f8bap0
  },
  { // Entry 65
    -0x1.94167efccbc0fa6d4577f69f61e031d2p-1,
    -0x1.01f8bap0
  },
  { // Entry 66
    0x1.9672428abad4ced3d0a6e349e9bf2b3ep-1,
    0x1.045cp0
  },
  { // Entry 67
    -0x1.9672428abad4ced3d0a6e349e9bf2b3ep-1,
    -0x1.045cp0
  },
  { // Entry 68
    0x1.fe8abeff0d857adea735e07cdc25f45cp-3,
    0x1.04b198p-2
  },
  { // Entry 69
    -0x1.fe8abeff0d857adea735e07cdc25f45cp-3,
    -0x1.04b198p-2
  },
  { // Entry 70
    0x1.e3ee99003632acbd63018dcd998b0a66p-2,
    0x1.05bfb8p-1
  },
  { // Entry 71
    -0x1.e3ee99003632acbd63018dcd998b0a66p-2,
    -0x1.05bfb8p-1
  },
  { // Entry 72
    0x1.980dd942c58931ccfa88aa5714d9589bp-1,
    0x1.06p0
  },
  { // Entry 73
    -0x1.980dd942c58931ccfa88aa5714d9589bp-1,
    -0x1.06p0
  },
  { // Entry 74
    0x1.e4c00f0040fd5558135d221fc95d855ep-2,
    0x1.0643e0p-1
  },
  { // Entry 75
    -0x1.e4c00f0040fd5558135d221fc95d855ep-2,
    -0x1.0643e0p-1
  },
  { // Entry 76
    0x1.e4e7050041fea5e474bc42bb3e9598edp-2,
    0x1.065c78p-1
  },
  { // Entry 77
    -0x1.e4e7050041fea5e474bc42bb3e9598edp-2,
    -0x1.065c78p-1
  },
  { // Entry 78
    0x1.067fe90007689d48fb39791c0a809723p-9,
    0x1.0680p-9
  },
  { // Entry 79
    -0x1.067fe90007689d48fb39791c0a809723p-9,
    -0x1.0680p-9
  },
  { // Entry 80
    0x1.e5f6450041f31d7a1b1ffc6626e3a3a9p-2,
    0x1.0707ccp-1
  },
  { // Entry 81
    -0x1.e5f6450041f31d7a1b1ffc6626e3a3a9p-2,
    -0x1.0707ccp-1
  },
  { // Entry 82
    0x1.9a000a935bd8e2b2823be1b99de9aa6dp-1,
    0x1.08p0
  },
  { // Entry 83
    -0x1.9a000a935bd8e2b2823be1b99de9aa6dp-1,
    -0x1.08p0
  },
  { // Entry 84
    0x1.e7e095003c972c47c7b484d1174ef8f1p-2,
    0x1.083df4p-1
  },
  { // Entry 85
    -0x1.e7e095003c972c47c7b484d1174ef8f1p-2,
    -0x1.083df4p-1
  },
  { // Entry 86
    0x1.9b95d2027f3b51c408badd232447fca7p-1,
    0x1.09a4p0
  },
  { // Entry 87
    -0x1.9b95d2027f3b51c408badd232447fca7p-1,
    -0x1.09a4p0
  },
  { // Entry 88
    0x1.9bf2349c2fe1915b2ba951f4d90c2346p-1,
    0x1.0a04p0
  },
  { // Entry 89
    -0x1.9bf2349c2fe1915b2ba951f4d90c2346p-1,
    -0x1.0a04p0
  },
  { // Entry 90
    0x1.9c0d202ee6cadb3368d0bc3bc61620f7p-1,
    0x1.0a20p0
  },
  { // Entry 91
    -0x1.9c0d202ee6cadb3368d0bc3bc61620f7p-1,
    -0x1.0a20p0
  },
  { // Entry 92
    0x1.9c0e9ebf9ee6f339b8d4eb3e3659c70ep-1,
    0x1.0a218ep0
  },
  { // Entry 93
    -0x1.9c0e9ebf9ee6f339b8d4eb3e3659c70ep-1,
    -0x1.0a218ep0
  },
  { // Entry 94
    0x1.9d252e659267619beef68e8773dc6ec3p-1,
    0x1.0b44p0
  },
  { // Entry 95
    -0x1.9d252e659267619beef68e8773dc6ec3p-1,
    -0x1.0b44p0
  },
  { // Entry 96
    0x1.ee39fb000821b1a9c00089e135f069d2p-2,
    0x1.0c4670p-1
  },
  { // Entry 97
    -0x1.ee39fb000821b1a9c00089e135f069d2p-2,
    -0x1.0c4670p-1
  },
  { // Entry 98
    0x1.eff285034b3ca346fbed2f996a1534f1p-2,
    0x1.0d5f6ep-1
  },
  { // Entry 99
    -0x1.eff285034b3ca346fbed2f996a1534f1p-2,
    -0x1.0d5f6ep-1
  },
  { // Entry 100
    0x1.f33837034c37141c6ee6c4c215ebe879p-2,
    0x1.0f771ep-1
  },
  { // Entry 101
    -0x1.f33837034c37141c6ee6c4c215ebe879p-2,
    -0x1.0f771ep-1
  },
  { // Entry 102
    0x1.a169ad8725b3aa57831d5cea9cf84a45p-1,
    0x1.0fc3aep0
  },
  { // Entry 103
    -0x1.a169ad8725b3aa57831d5cea9cf84a45p-1,
    -0x1.0fc3aep0
  },
  { // Entry 104
    0x1.a199a5013b67a3668024b5fdba537ffbp-1,
    0x1.0ff6b6p0
  },
  { // Entry 105
    -0x1.a199a5013b67a3668024b5fdba537ffbp-1,
    -0x1.0ff6b6p0
  },
  { // Entry 106
    0x1.f9ef110001fb3099dbc032baff8a7c9cp-2,
    0x1.13c8p-1
  },
  { // Entry 107
    -0x1.f9ef110001fb3099dbc032baff8a7c9cp-2,
    -0x1.13c8p-1
  },
  { // Entry 108
    0x1.fb05f2d09a4dc6b31f91eaed3651aa0fp-2,
    0x1.147cp-1
  },
  { // Entry 109
    -0x1.fb05f2d09a4dc6b31f91eaed3651aa0fp-2,
    -0x1.147cp-1
  },
  { // Entry 110
    0x1.166210ff1f27419bd56d7ad58a532203p-4,
    0x1.16d0p-4
  },
  { // Entry 111
    -0x1.166210ff1f27419bd56d7ad58a532203p-4,
    -0x1.16d0p-4
  },
  { // Entry 112
    0x1.ff14479ea0d08b305667ea1e6b71efa9p-2,
    0x1.171cp-1
  },
  { // Entry 113
    -0x1.ff14479ea0d08b305667ea1e6b71efa9p-2,
    -0x1.171cp-1
  },
  { // Entry 114
    0x1.aa655941c2ed237529659b26a6d40360p-1,
    0x1.1980p0
  },
  { // Entry 115
    -0x1.aa655941c2ed237529659b26a6d40360p-1,
    -0x1.1980p0
  },
  { // Entry 116
    0x1.1ac3c9559802914487a1a7e1b563dc42p-4,
    0x1.1b37p-4
  },
  { // Entry 117
    -0x1.1ac3c9559802914487a1a7e1b563dc42p-4,
    -0x1.1b37p-4
  },
  { // Entry 118
    0x1.ace31afd63c618792d7f004a5f20bf53p-1,
    0x1.1c443ep0
  },
  { // Entry 119
    -0x1.ace31afd63c618792d7f004a5f20bf53p-1,
    -0x1.1c443ep0
  },
  { // Entry 120
    0x1.aefd63ceeeba596e1d377ed9501f9f2dp-1,
    0x1.1ea0p0
  },
  { // Entry 121
    -0x1.aefd63ceeeba596e1d377ed9501f9f2dp-1,
    -0x1.1ea0p0
  },
  { // Entry 122
    0x1.31e3ddfffbe9c81c178270bc759875e9p-3,
    0x1.342f6cp-3
  },
  { // Entry 123
    -0x1.31e3ddfffbe9c81c178270bc759875e9p-3,
    -0x1.342f6cp-3
  },
  { // Entry 124
    0x1.30f588fffee141782f61de3b913cc344p-2,
    0x1.3a4e82p-2
  },
  { // Entry 125
    -0x1.30f588fffee141782f61de3b913cc344p-2,
    -0x1.3a4e82p-2
  },
  { // Entry 126
    0x1.26c384fe95d5e24c9c60adf93f531182p-1,
    0x1.4c50e8p-1
  },
  { // Entry 127
    -0x1.26c384fe95d5e24c9c60adf93f531182p-1,
    -0x1.4c50e8p-1
  },
  { // Entry 128
    0x1.e42856fffdaf1e270f502c72bfe272b0p-1,
    0x1.62b140p0
  },
  { // Entry 129
    -0x1.e42856fffdaf1e270f502c72bfe272b0p-1,
    -0x1.62b140p0
  },
  { // Entry 130
    0x1.6703fefed06b914b99e3124ca0c2cb58p-2,
    0x1.767caap-2
  },
  { // Entry 131
    -0x1.6703fefed06b914b99e3124ca0c2cb58p-2,
    -0x1.767caap-2
  },
  { // Entry 132
    0x1.75cb06fffffebc09be37493223d1436ap-4,
    0x1.76d58ep-4
  },
  { // Entry 133
    -0x1.75cb06fffffebc09be37493223d1436ap-4,
    -0x1.76d58ep-4
  },
  { // Entry 134
    0x1.43fdd1a6959aa989f50575cf45455d64p-1,
    0x1.7780f2p-1
  },
  { // Entry 135
    -0x1.43fdd1a6959aa989f50575cf45455d64p-1,
    -0x1.7780f2p-1
  },
  { // Entry 136
    0x1.481bba0215fb04f66252d5b8f4a0299ap-1,
    0x1.7ddf62p-1
  },
  { // Entry 137
    -0x1.481bba0215fb04f66252d5b8f4a0299ap-1,
    -0x1.7ddf62p-1
  },
  { // Entry 138
    0x1.6f946595578bf7edcadbbe6e816838dap-2,
    0x1.8039f8p-2
  },
  { // Entry 139
    -0x1.6f946595578bf7edcadbbe6e816838dap-2,
    -0x1.8039f8p-2
  },
  { // Entry 140
    0x1.6f9d299cc53084feaeb4a89dd538984cp-2,
    0x1.8043f8p-2
  },
  { // Entry 141
    -0x1.6f9d299cc53084feaeb4a89dd538984cp-2,
    -0x1.8043f8p-2
  },
  { // Entry 142
    0x1.6fa461634385621a7b4a1f3f39e69e88p-2,
    0x1.804c34p-2
  },
  { // Entry 143
    -0x1.6fa461634385621a7b4a1f3f39e69e88p-2,
    -0x1.804c34p-2
  },
  { // Entry 144
    0x1.6fedbe03cf0b00cdb648f3f58822f3c8p-2,
    0x1.809fe8p-2
  },
  { // Entry 145
    -0x1.6fedbe03cf0b00cdb648f3f58822f3c8p-2,
    -0x1.809fe8p-2
  },
  { // Entry 146
    0x1.738c297a78e8c603048015fdc8bcf4c9p-2,
    0x1.84c270p-2
  },
  { // Entry 147
    -0x1.738c297a78e8c603048015fdc8bcf4c9p-2,
    -0x1.84c270p-2
  },
  { // Entry 148
    0x1.98f0340002c61b1d33f8d1e2c1af5581p-4,
    0x1.9a4d6ep-4
  },
  { // Entry 149
    -0x1.98f0340002c61b1d33f8d1e2c1af5581p-4,
    -0x1.9a4d6ep-4
  },
  { // Entry 150
    0x1.9f8b4300038b239eb63e7be822591b5fp-4,
    0x1.a0f9bcp-4
  },
  { // Entry 151
    -0x1.9f8b4300038b239eb63e7be822591b5fp-4,
    -0x1.a0f9bcp-4
  },
  { // Entry 152
    0x1.a0fd9d00039a60bddbfddc10b05c56a3p-4,
    0x1.a26ff0p-4
  },
  { // Entry 153
    -0x1.a0fd9d00039a60bddbfddc10b05c56a3p-4,
    -0x1.a26ff0p-4
  },
  { // Entry 154
    0x1.a4728900556fc2b8a5a530e3d999b1d7p-4,
    0x1.a5ee2cp-4
  },
  { // Entry 155
    -0x1.a4728900556fc2b8a5a530e3d999b1d7p-4,
    -0x1.a5ee2cp-4
  },
  { // Entry 156
    0x1.a4728afaf537b57369dd1613673f2757p-4,
    0x1.a5ee2ep-4
  },
  { // Entry 157
    -0x1.a4728afaf537b57369dd1613673f2757p-4,
    -0x1.a5ee2ep-4
  },
  { // Entry 158
    0x1.915e19aa098cba6ef178411ea4174f67p-2,
    0x1.a744d8p-2
  },
  { // Entry 159
    -0x1.915e19aa098cba6ef178411ea4174f67p-2,
    -0x1.a744d8p-2
  },
  { // Entry 160
    0x1.a95d5effffee8dfa2a44af912ff5c6bdp-4,
    0x1.aae686p-4
  },
  { // Entry 161
    -0x1.a95d5effffee8dfa2a44af912ff5c6bdp-4,
    -0x1.aae686p-4
  },
  { // Entry 162
    0x1.b0f897fdea5769efb43b734c6f5d38fdp-4,
    0x1.b29748p-4
  },
  { // Entry 163
    -0x1.b0f897fdea5769efb43b734c6f5d38fdp-4,
    -0x1.b29748p-4
  },
  { // Entry 164
    0x1.b6fd68fffbf33784a8e129606c5a3fd4p-4,
    0x1.b8adb0p-4
  },
  { // Entry 165
    -0x1.b6fd68fffbf33784a8e129606c5a3fd4p-4,
    -0x1.b8adb0p-4
  },
  { // Entry 166
    0x1.a205342c457ac3a056abcfe7527a4453p-2,
    0x1.bae68ep-2
  },
  { // Entry 167
    -0x1.a205342c457ac3a056abcfe7527a4453p-2,
    -0x1.bae68ep-2
  },
  { // Entry 168
    0x1.a64efd063370b5e3a708b2a37ddab223p-2,
    0x1.c00014p-2
  },
  { // Entry 169
    -0x1.a64efd063370b5e3a708b2a37ddab223p-2,
    -0x1.c00014p-2
  },
  { // Entry 170
    0x1.ad00f396db03faa7f9d7e3221d4552adp-2,
    0x1.c7fffep-2
  },
  { // Entry 171
    -0x1.ad00f396db03faa7f9d7e3221d4552adp-2,
    -0x1.c7fffep-2
  },
  { // Entry 172
    0x1.6e6d5d27bd08154a6349dd2d9a311e10p0,
    0x1.c7fffep2
  },
  { // Entry 173
    -0x1.6e6d5d27bd08154a6349dd2d9a311e10p0,
    -0x1.c7fffep2
  },
  { // Entry 174
    0x1.769885e484d0999ef07a0c7cc0ce73f5p-1,
    0x1.cbb484p-1
  },
  { // Entry 175
    -0x1.769885e484d0999ef07a0c7cc0ce73f5p-1,
    -0x1.cbb484p-1
  },
  { // Entry 176
    0x1.7805f5ed5a7d34cf922043471c74eecfp-1,
    0x1.ce4a36p-1
  },
  { // Entry 177
    -0x1.7805f5ed5a7d34cf922043471c74eecfp-1,
    -0x1.ce4a36p-1
  },
  { // Entry 178
    0x1.c85b2ebda13e4f781ea65e5aa1b8b9e1p-3,
    0x1.d00ffep-3
  },
  { // Entry 179
    -0x1.c85b2ebda13e4f781ea65e5aa1b8b9e1p-3,
    -0x1.d00ffep-3
  },
  { // Entry 180
    0x1.c8df373eebdbd7d2983d9c074687b3b1p-3,
    0x1.d09ad0p-3
  },
  { // Entry 181
    -0x1.c8df373eebdbd7d2983d9c074687b3b1p-3,
    -0x1.d09ad0p-3
  },
  { // Entry 182
    0x1.8108f7001b7ce9d26ea2a770acd41044p0,
    0x1.deaa38p3
  },
  { // Entry 183
    -0x1.8108f7001b7ce9d26ea2a770acd41044p0,
    -0x1.deaa38p3
  },
  { // Entry 184
    0x1.82d6b687d8692e9aefc611be6b1d44a8p-1,
    0x1.e24eaep-1
  },
  { // Entry 185
    -0x1.82d6b687d8692e9aefc611be6b1d44a8p-1,
    -0x1.e24eaep-1
  },
  { // Entry 186
    0x1.921fb5011d0bff02f51322a08f435689p0,
    0x1.e7fffep25
  },
  { // Entry 187
    -0x1.921fb5011d0bff02f51322a08f435689p0,
    -0x1.e7fffep25
  },
  { // Entry 188
    0x1.8755f7204b35fedd69304c014ba9193ap-1,
    0x1.eaddb6p-1
  },
  { // Entry 189
    -0x1.8755f7204b35fedd69304c014ba9193ap-1,
    -0x1.eaddb6p-1
  },
  { // Entry 190
    0x1.921facfffe4d525869adf36453ac0045p0,
    0x1.ef7bd0p20
  },
  { // Entry 191
    -0x1.921facfffe4d525869adf36453ac0045p0,
    -0x1.ef7bd0p20
  },
  { // Entry 192
    0x1.f14041fffc6f93742ff15942783907eep-4,
    0x1.f3b552p-4
  },
  { // Entry 193
    -0x1.f14041fffc6f93742ff15942783907eep-4,
    -0x1.f3b552p-4
  },
  { // Entry 194
    0x1.f4bb0afed7559483e5805dd4879465bcp-6,
    0x1.f4e2f8p-6
  },
  { // Entry 195
    -0x1.f4bb0afed7559483e5805dd4879465bcp-6,
    -0x1.f4e2f8p-6
  },
  { // Entry 196
    0x1.d45aeb02a07ca4b711c2193329425c78p-2,
    0x1.f7fffep-2
  },
  { // Entry 197
    -0x1.d45aeb02a07ca4b711c2193329425c78p-2,
    -0x1.f7fffep-2
  },
  { // Entry 198
    0x1.d539bcffd5888dca7deceba8a3f2d041p-2,
    0x1.f914e8p-2
  },
  { // Entry 199
    -0x1.d539bcffd5888dca7deceba8a3f2d041p-2,
    -0x1.f914e8p-2
  },
  { // Entry 200
    0x1.8ee84f1478a25b9bfacdabb49fcea6d5p-1,
    0x1.f99b76p-1
  },
  { // Entry 201
    -0x1.8ee84f1478a25b9bfacdabb49fcea6d5p-1,
    -0x1.f99b76p-1
  },
  { // Entry 202
    0x1.fadbf0ff486b15e264c02ca39b8e6e46p-6,
    0x1.fb055ap-6
  },
  { // Entry 203
    -0x1.fadbf0ff486b15e264c02ca39b8e6e46p-6,
    -0x1.fb055ap-6
  },
  { // Entry 204
    0x1.9044df034b8d943327bee5c633b3f31cp-1,
    0x1.fc4dc0p-1
  },
  { // Entry 205
    -0x1.9044df034b8d943327bee5c633b3f31cp-1,
    -0x1.fc4dc0p-1
  },
  { // Entry 206
    0x1.921f74fffa03e701accc9d1ee3bd2f43p0,
    0x1.fddffep17
  },
  { // Entry 207
    -0x1.921f74fffa03e701accc9d1ee3bd2f43p0,
    -0x1.fddffep17
  },
  { // Entry 208
    0x1.91af9bc0400e0e21fb44692a41829c5dp-1,
    0x1.ff1ffep-1
  },
  { // Entry 209
    -0x1.91af9bc0400e0e21fb44692a41829c5dp-1,
    -0x1.ff1ffep-1
  },
  { // Entry 210
    0x1.91bfa241a2bf1c8f33e7aee3a38362fap-1,
    0x1.ff3ffep-1
  },
  { // Entry 211
    -0x1.91bfa241a2bf1c8f33e7aee3a38362fap-1,
    -0x1.ff3ffep-1
  },
  { // Entry 212
    0x1.f502a50008dcfa3d1252e8256297aa16p-3,
    0x1.ff3ffep-3
  },
  { // Entry 213
    -0x1.f502a50008dcfa3d1252e8256297aa16p-3,
    -0x1.ff3ffep-3
  },
  { // Entry 214
    0x1.1b6c658f57d1e4435c946530e7d0415cp0,
    0x1.fff77ep0
  },
  { // Entry 215
    -0x1.1b6c658f57d1e4435c946530e7d0415cp0,
    -0x1.fff77ep0
  },
  { // Entry 216
    0x1.f5b0a8fac8ee3b2a0997552183bbaf86p-3,
    0x1.fff8dep-3
  },
  { // Entry 217
    -0x1.f5b0a8fac8ee3b2a0997552183bbaf86p-3,
    -0x1.fff8dep-3
  },
  { // Entry 218
    0x1.f5b0c8fad63b565edaa4205b5787d234p-3,
    0x1.fff9p-3
  },
  { // Entry 219
    -0x1.f5b0c8fad63b565edaa4205b5787d234p-3,
    -0x1.fff9p-3
  },
  { // Entry 220
    0x1.ffd048ff42ff02270154618cac768f98p-6,
    0x1.fffaecp-6
  },
  { // Entry 221
    -0x1.ffd048ff42ff02270154618cac768f98p-6,
    -0x1.fffaecp-6
  },
  { // Entry 222
    0x1.921de5429e50865c34386a247dc4ee4ep-1,
    0x1.fffc60p-1
  },
  { // Entry 223
    -0x1.921de5429e50865c34386a247dc4ee4ep-1,
    -0x1.fffc60p-1
  },
  { // Entry 224
    0x1.921f84443e21041cf1621a6d2e90a3cap-1,
    0x1.ffff9ep-1
  },
  { // Entry 225
    -0x1.921f84443e21041cf1621a6d2e90a3cap-1,
    -0x1.ffff9ep-1
  },
  { // Entry 226
    0x1.1b6e0d95213d8e5e8acacf6ee3b5dda1p0,
    0x1.ffffc6p0
  },
  { // Entry 227
    -0x1.1b6e0d95213d8e5e8acacf6ee3b5dda1p0,
    -0x1.ffffc6p0
  },
  { // Entry 228
    0x1.5368c551e98fc9a0436ff6aed5a43bfep0,
    0x1.ffffdep1
  },
  { // Entry 229
    -0x1.5368c551e98fc9a0436ff6aed5a43bfep0,
    -0x1.ffffdep1
  },
  { // Entry 230
    0x1.1b6e15952230c1a76e364414327ae250p0,
    0x1.ffffeep0
  },
  { // Entry 231
    -0x1.1b6e15952230c1a76e364414327ae250p0,
    -0x1.ffffeep0
  },
  { // Entry 232
    0x1.921fb14442c984697ee21a6c570dc22ap-1,
    0x1.fffff8p-1
  },
  { // Entry 233
    -0x1.921fb14442c984697ee21a6c570dc22ap-1,
    -0x1.fffff8p-1
  },
  { // Entry 234
    -0.0f,
    -0x1.p-149
  },
  { // Entry 235
    0.0f,
    0x1.p-149
  },
  { // Entry 236
    0.0,
    0.0
  },
  { // Entry 237
    0.0f,
    0x1.p-149
  },
  { // Entry 238
    -0.0f,
    -0x1.p-149
  },
  { // Entry 239
    -0x1.000001ffffffffffffffffffffffffffp-126,
    -0x1.000002p-126
  },
  { // Entry 240
    0x1.000001ffffffffffffffffffffffffffp-126,
    0x1.000002p-126
  },
  { // Entry 241
    -0x1.ffffffffffffffffffffffffffffffffp-127,
    -0x1.p-126
  },
  { // Entry 242
    0x1.ffffffffffffffffffffffffffffffffp-127,
    0x1.p-126
  },
  { // Entry 243
    -0x1.fffffbffffffffffffffffffffffffffp-127,
    -0x1.fffffcp-127
  },
  { // Entry 244
    0x1.fffffbffffffffffffffffffffffffffp-127,
    0x1.fffffcp-127
  },
  { // Entry 245
    0x1.fffffbffffffffffffffffffffffffffp-127,
    0x1.fffffcp-127
  },
  { // Entry 246
    -0x1.fffffbffffffffffffffffffffffffffp-127,
    -0x1.fffffcp-127
  },
  { // Entry 247
    0x1.ffffffffffffffffffffffffffffffffp-127,
    0x1.p-126
  },
  { // Entry 248
    -0x1.ffffffffffffffffffffffffffffffffp-127,
    -0x1.p-126
  },
  { // Entry 249
    0x1.000001ffffffffffffffffffffffffffp-126,
    0x1.000002p-126
  },
  { // Entry 250
    -0x1.000001ffffffffffffffffffffffffffp-126,
    -0x1.000002p-126
  },
  { // Entry 251
    0x1.999999a89e60d0512d6b0b39bd2a565ap-13,
    0x1.99999ap-13
  },
  { // Entry 252
    -0x1.999999a89e60d0512d6b0b39bd2a565ap-13,
    -0x1.99999ap-13
  },
  { // Entry 253
    0x1.999998a27984d3ebeb1c3290cc2c5caap-12,
    0x1.99999ap-12
  },
  { // Entry 254
    -0x1.999998a27984d3ebeb1c3290cc2c5caap-12,
    -0x1.99999ap-12
  },
  { // Entry 255
    0x1.333331b22d11b0ccb2bb7ba6f63b4d3cp-11,
    0x1.333334p-11
  },
  { // Entry 256
    -0x1.333331b22d11b0ccb2bb7ba6f63b4d3cp-11,
    -0x1.333334p-11
  },
  { // Entry 257
    0x1.99999489e62c7a2256e05c49880d23d9p-11,
    0x1.99999ap-11
  },
  { // Entry 258
    -0x1.99999489e62c7a2256e05c49880d23d9p-11,
    -0x1.99999ap-11
  },
  { // Entry 259
    0x1.fffff55555bbbbb72972d00cfde752f9p-11,
    0x1.p-10
  },
  { // Entry 260
    -0x1.fffff55555bbbbb72972d00cfde752f9p-11,
    -0x1.p-10
  },
  { // Entry 261
    0x1.33332ac8b4a6505aad1a5539202df4f4p-10,
    0x1.333334p-10
  },
  { // Entry 262
    -0x1.33332ac8b4a6505aad1a5539202df4f4p-10,
    -0x1.333334p-10
  },
  { // Entry 263
    0x1.6666595d875d6f587e4d878a7b492f47p-10,
    0x1.666668p-10
  },
  { // Entry 264
    -0x1.6666595d875d6f587e4d878a7b492f47p-10,
    -0x1.666668p-10
  },
  { // Entry 265
    0x1.9999862799f2a4104ba8c411863e71f7p-10,
    0x1.99999cp-10
  },
  { // Entry 266
    -0x1.9999862799f2a4104ba8c411863e71f7p-10,
    -0x1.99999cp-10
  },
  { // Entry 267
    0x1.ccccace5643276ecd8ffae54b28b87ffp-10,
    0x1.ccccccp-10
  },
  { // Entry 268
    -0x1.ccccace5643276ecd8ffae54b28b87ffp-10,
    -0x1.ccccccp-10
  },
  { // Entry 269
    0x1.0664f66f7cfd482cf0ff4582bbeef478p-7,
    0x1.066666p-7
  },
  { // Entry 270
    -0x1.0664f66f7cfd482cf0ff4582bbeef478p-7,
    -0x1.066666p-7
  },
  { // Entry 271
    0x1.ccc505948fe7a3b8e0837445c2136897p-7,
    0x1.ccccccp-7
  },
  { // Entry 272
    -0x1.ccc505948fe7a3b8e0837445c2136897p-7,
    -0x1.ccccccp-7
  },
  { // Entry 273
    0x1.498e36c4f385d5af3b6b6480a8ebfe14p-6,
    0x1.499998p-6
  },
  { // Entry 274
    -0x1.498e36c4f385d5af3b6b6480a8ebfe14p-6,
    -0x1.499998p-6
  },
  { // Entry 275
    0x1.acb3be5be013930205335e91f230ec8bp-6,
    0x1.acccccp-6
  },
  { // Entry 276
    -0x1.acb3be5be013930205335e91f230ec8bp-6,
    -0x1.acccccp-6
  },
  { // Entry 277
    0x1.07e89e3abee7df5bc22b883856e5d802p-5,
    0x1.08p-5
  },
  { // Entry 278
    -0x1.07e89e3abee7df5bc22b883856e5d802p-5,
    -0x1.08p-5
  },
  { // Entry 279
    0x1.39726b6fab059b66dd740ae83fb565b7p-5,
    0x1.39999ap-5
  },
  { // Entry 280
    -0x1.39726b6fab059b66dd740ae83fb565b7p-5,
    -0x1.39999ap-5
  },
  { // Entry 281
    0x1.6af65a41908039c267674f356f997d4dp-5,
    0x1.6b3334p-5
  },
  { // Entry 282
    -0x1.6af65a41908039c267674f356f997d4dp-5,
    -0x1.6b3334p-5
  },
  { // Entry 283
    0x1.9c737ecdb90a7c4f9d8682bc2815635bp-5,
    0x1.9ccccep-5
  },
  { // Entry 284
    -0x1.9c737ecdb90a7c4f9d8682bc2815635bp-5,
    -0x1.9ccccep-5
  },
  { // Entry 285
    0x1.cde8ebf5a33a269c5529c53e853ce492p-5,
    0x1.ce6666p-5
  },
  { // Entry 286
    -0x1.cde8ebf5a33a269c5529c53e853ce492p-5,
    -0x1.ce6666p-5
  },
  { // Entry 287
    0x1.3359bcc32e58c6de203f8b6c19fa5ff9p-1,
    0x1.5e7fc4p-1
  },
  { // Entry 288
    -0x1.3359bcc32e58c6de203f8b6c19fa5ff9p-1,
    -0x1.5e7fc4p-1
  },
  { // Entry 289
    0x1.d5ca705d09beeec558a5b8db2d657192p-1,
    0x1.4e7fc4p0
  },
  { // Entry 290
    -0x1.d5ca705d09beeec558a5b8db2d657192p-1,
    -0x1.4e7fc4p0
  },
  { // Entry 291
    0x1.17ac440d8febeb7a1d19a5ae8faa7d7ep0,
    0x1.edbfa6p0
  },
  { // Entry 292
    -0x1.17ac440d8febeb7a1d19a5ae8faa7d7ep0,
    -0x1.edbfa6p0
  },
  { // Entry 293
    0x1.3279e84703fc9c8f702a678693102c47p0,
    0x1.467fc4p1
  },
  { // Entry 294
    -0x1.3279e84703fc9c8f702a678693102c47p0,
    -0x1.467fc4p1
  },
  { // Entry 295
    0x1.43f64467a5781271582ce61ccc6b0199p0,
    0x1.961fb4p1
  },
  { // Entry 296
    -0x1.43f64467a5781271582ce61ccc6b0199p0,
    -0x1.961fb4p1
  },
  { // Entry 297
    0x1.502a1cf082c199f85892b1763efa6c61p0,
    0x1.e5bfa4p1
  },
  { // Entry 298
    -0x1.502a1cf082c199f85892b1763efa6c61p0,
    -0x1.e5bfa4p1
  },
  { // Entry 299
    0x1.592066563d61378c65a8ef7d091bdc95p0,
    0x1.1aafcap2
  },
  { // Entry 300
    -0x1.592066563d61378c65a8ef7d091bdc95p0,
    -0x1.1aafcap2
  },
  { // Entry 301
    0x1.5ff8e21f712f9ee4424bbc711e1ef6f3p0,
    0x1.427fc2p2
  },
  { // Entry 302
    -0x1.5ff8e21f712f9ee4424bbc711e1ef6f3p0,
    -0x1.427fc2p2
  },
  { // Entry 303
    0x1.655d64f377c9e58e727f460133ed97a3p0,
    0x1.6a4fbap2
  },
  { // Entry 304
    -0x1.655d64f377c9e58e727f460133ed97a3p0,
    -0x1.6a4fbap2
  },
  { // Entry 305
    0x1.65711d6dd7ca878481fcb2ec4f9f9341p0,
    0x1.6af2f0p2
  },
  { // Entry 306
    -0x1.65711d6dd7ca878481fcb2ec4f9f9341p0,
    -0x1.6af2f0p2
  },
  { // Entry 307
    0x1.602a2a92bb3778489bbc165a7d25fb68p0,
    0x1.43c62ap2
  },
  { // Entry 308
    -0x1.602a2a92bb3778489bbc165a7d25fb68p0,
    -0x1.43c62ap2
  },
  { // Entry 309
    0x1.597f46a19f06d53bf1df42bfaedc5c4dp0,
    0x1.1c9964p2
  },
  { // Entry 310
    -0x1.597f46a19f06d53bf1df42bfaedc5c4dp0,
    -0x1.1c9964p2
  },
  { // Entry 311
    0x1.50d201d4d8188bc950ce239cd4991bb9p0,
    0x1.ead93cp1
  },
  { // Entry 312
    -0x1.50d201d4d8188bc950ce239cd4991bb9p0,
    -0x1.ead93cp1
  },
  { // Entry 313
    0x1.45190b163719c828307d6a3d0cf0b54cp0,
    0x1.9c7fb0p1
  },
  { // Entry 314
    -0x1.45190b163719c828307d6a3d0cf0b54cp0,
    -0x1.9c7fb0p1
  },
  { // Entry 315
    0x1.34794bb84d2baa02953a0a72b717f0ebp0,
    0x1.4e2624p1
  },
  { // Entry 316
    -0x1.34794bb84d2baa02953a0a72b717f0ebp0,
    -0x1.4e2624p1
  },
  { // Entry 317
    0x1.1b59864724a10efac8597e77461bc3f1p0,
    0x1.ff9932p0
  },
  { // Entry 318
    -0x1.1b59864724a10efac8597e77461bc3f1p0,
    -0x1.ff9932p0
  },
  { // Entry 319
    0x1.e44c89086d1aecac1cbe2b3941c67a0fp-1,
    0x1.62e61cp0
  },
  { // Entry 320
    -0x1.e44c89086d1aecac1cbe2b3941c67a0fp-1,
    -0x1.62e61cp0
  },
  { // Entry 321
    0x1.5150f28aee7aa819cb475b4a85ae7569p-1,
    0x1.8c662cp-1
  },
  { // Entry 322
    -0x1.5150f28aee7aa819cb475b4a85ae7569p-1,
    -0x1.8c662cp-1
  },
  { // Entry 323
    -0x1.073ea11368f7a47972c7a90fc77e3c33p0,
    -0x1.a8aa1cp0
  },
  { // Entry 324
    0x1.073ea11368f7a47972c7a90fc77e3c33p0,
    0x1.a8aa1cp0
  },
  { // Entry 325
    -0x1.021548e71bb3457d648c1924de4f5d65p0,
    -0x1.95ec8ap0
  },
  { // Entry 326
    0x1.021548e71bb3457d648c1924de4f5d65p0,
    0x1.95ec8ap0
  },
  { // Entry 327
    -0x1.f92364ca1fa2dabc63ba7f6e8a68d3f6p-1,
    -0x1.832ef8p0
  },
  { // Entry 328
    0x1.f92364ca1fa2dabc63ba7f6e8a68d3f6p-1,
    0x1.832ef8p0
  },
  { // Entry 329
    -0x1.ed577ea7517c28cbc891c018438dac11p-1,
    -0x1.707166p0
  },
  { // Entry 330
    0x1.ed577ea7517c28cbc891c018438dac11p-1,
    0x1.707166p0
  },
  { // Entry 331
    -0x1.e0b5226ef36d67e005a0eb9cfdb9b51ap-1,
    -0x1.5db3d4p0
  },
  { // Entry 332
    0x1.e0b5226ef36d67e005a0eb9cfdb9b51ap-1,
    0x1.5db3d4p0
  },
  { // Entry 333
    -0x1.d3290427f1d17e30a6993fbe96cc1fdfp-1,
    -0x1.4af642p0
  },
  { // Entry 334
    0x1.d3290427f1d17e30a6993fbe96cc1fdfp-1,
    0x1.4af642p0
  },
  { // Entry 335
    -0x1.c49e4505cff7e9f58be9c60ef08b794dp-1,
    -0x1.3838b0p0
  },
  { // Entry 336
    0x1.c49e4505cff7e9f58be9c60ef08b794dp-1,
    0x1.3838b0p0
  },
  { // Entry 337
    -0x1.b4fe80019a190ceb39c7cce2f0847082p-1,
    -0x1.257b1ep0
  },
  { // Entry 338
    0x1.b4fe80019a190ceb39c7cce2f0847082p-1,
    0x1.257b1ep0
  },
  { // Entry 339
    -0x1.a431f41e221ee2993e28481f34f7c822p-1,
    -0x1.12bd92p0
  },
  { // Entry 340
    0x1.a431f41e221ee2993e28481f34f7c822p-1,
    0x1.12bd92p0
  },
  { // Entry 341
    -0x1.8712787339dc1bb28aacdbb75d0eda49p-1,
    -0x1.ea5c3ep-1
  },
  { // Entry 342
    0x1.8712787339dc1bb28aacdbb75d0eda49p-1,
    0x1.ea5c3ep-1
  },
  { // Entry 343
    -0x1.7b8b3af8b9278dd5c80bf4f386dc5503p-1,
    -0x1.d4b87cp-1
  },
  { // Entry 344
    0x1.7b8b3af8b9278dd5c80bf4f386dc5503p-1,
    0x1.d4b87cp-1
  },
  { // Entry 345
    -0x1.6f851d6a4f403a71ef874dcc9ed9d59ap-1,
    -0x1.bf14bap-1
  },
  { // Entry 346
    0x1.6f851d6a4f403a71ef874dcc9ed9d59ap-1,
    0x1.bf14bap-1
  },
  { // Entry 347
    -0x1.62fb625437af22ec34ce96b17c5ac9ecp-1,
    -0x1.a970f8p-1
  },
  { // Entry 348
    0x1.62fb625437af22ec34ce96b17c5ac9ecp-1,
    0x1.a970f8p-1
  },
  { // Entry 349
    -0x1.55e98421ee9465b922d19e78004b9e96p-1,
    -0x1.93cd36p-1
  },
  { // Entry 350
    0x1.55e98421ee9465b922d19e78004b9e96p-1,
    0x1.93cd36p-1
  },
  { // Entry 351
    -0x1.484b4edaf8871846261a76bd33d9f049p-1,
    -0x1.7e2974p-1
  },
  { // Entry 352
    0x1.484b4edaf8871846261a76bd33d9f049p-1,
    0x1.7e2974p-1
  },
  { // Entry 353
    -0x1.3a1cfde1e590471ac2ff5eefe745a249p-1,
    -0x1.6885b2p-1
  },
  { // Entry 354
    0x1.3a1cfde1e590471ac2ff5eefe745a249p-1,
    0x1.6885b2p-1
  },
  { // Entry 355
    -0x1.2b5b5dbe8467930df24be6b9046ddfaep-1,
    -0x1.52e1f0p-1
  },
  { // Entry 356
    0x1.2b5b5dbe8467930df24be6b9046ddfaep-1,
    0x1.52e1f0p-1
  },
  { // Entry 357
    -0x1.1c03f7900131c7cb3fbfbb5e6c5115eap-1,
    -0x1.3d3e36p-1
  },
  { // Entry 358
    0x1.1c03f7900131c7cb3fbfbb5e6c5115eap-1,
    0x1.3d3e36p-1
  },
  { // Entry 359
    -0x1.eab7b26f955752e78c062cb6087064d9p-2,
    -0x1.0a0b02p-1
  },
  { // Entry 360
    0x1.eab7b26f955752e78c062cb6087064d9p-2,
    0x1.0a0b02p-1
  },
  { // Entry 361
    -0x1.bb12f2d65df13ff36b74e12066022236p-2,
    -0x1.d8f720p-2
  },
  { // Entry 362
    0x1.bb12f2d65df13ff36b74e12066022236p-2,
    0x1.d8f720p-2
  },
  { // Entry 363
    -0x1.894ae05fefe6ee1164c3e769b2b1a84ep-2,
    -0x1.9dd83cp-2
  },
  { // Entry 364
    0x1.894ae05fefe6ee1164c3e769b2b1a84ep-2,
    0x1.9dd83cp-2
  },
  { // Entry 365
    -0x1.5579fd644a1a2d96faf5bb8844656d0cp-2,
    -0x1.62b958p-2
  },
  { // Entry 366
    0x1.5579fd644a1a2d96faf5bb8844656d0cp-2,
    0x1.62b958p-2
  },
  { // Entry 367
    -0x1.1fc79ca9ca92823d01375328ac472eedp-2,
    -0x1.279a74p-2
  },
  { // Entry 368
    0x1.1fc79ca9ca92823d01375328ac472eedp-2,
    0x1.279a74p-2
  },
  { // Entry 369
    -0x1.d0d0f7d861c753c31fa29e74145dc127p-3,
    -0x1.d8f720p-3
  },
  { // Entry 370
    0x1.d0d0f7d861c753c31fa29e74145dc127p-3,
    0x1.d8f720p-3
  },
  { // Entry 371
    -0x1.5f3d40f500501f80bba7a781b1619b85p-3,
    -0x1.62b958p-3
  },
  { // Entry 372
    0x1.5f3d40f500501f80bba7a781b1619b85p-3,
    0x1.62b958p-3
  },
  { // Entry 373
    -0x1.d6e1429159f6f0290cf9f2fb24bc26bdp-4,
    -0x1.d8f720p-4
  },
  { // Entry 374
    0x1.d6e1429159f6f0290cf9f2fb24bc26bdp-4,
    0x1.d8f720p-4
  },
  { // Entry 375
    -0x1.d870dc6f0c1b3da66fb282eb78c47134p-5,
    -0x1.d8f720p-5
  },
  { // Entry 376
    0x1.d870dc6f0c1b3da66fb282eb78c47134p-5,
    0x1.d8f720p-5
  },
  { // Entry 377
    0x1.d870dc6f0c1b3da66fb282eb78c47134p-5,
    0x1.d8f720p-5
  },
  { // Entry 378
    -0x1.d870dc6f0c1b3da66fb282eb78c47134p-5,
    -0x1.d8f720p-5
  },
  { // Entry 379
    0x1.d6e1429159f6f0290cf9f2fb24bc26bdp-4,
    0x1.d8f720p-4
  },
  { // Entry 380
    -0x1.d6e1429159f6f0290cf9f2fb24bc26bdp-4,
    -0x1.d8f720p-4
  },
  { // Entry 381
    0x1.5f3d40f500501f80bba7a781b1619b85p-3,
    0x1.62b958p-3
  },
  { // Entry 382
    -0x1.5f3d40f500501f80bba7a781b1619b85p-3,
    -0x1.62b958p-3
  },
  { // Entry 383
    0x1.d0d0f7d861c753c31fa29e74145dc127p-3,
    0x1.d8f720p-3
  },
  { // Entry 384
    -0x1.d0d0f7d861c753c31fa29e74145dc127p-3,
    -0x1.d8f720p-3
  },
  { // Entry 385
    0x1.1fc79ca9ca92823d01375328ac472eedp-2,
    0x1.279a74p-2
  },
  { // Entry 386
    -0x1.1fc79ca9ca92823d01375328ac472eedp-2,
    -0x1.279a74p-2
  },
  { // Entry 387
    0x1.5579fd644a1a2d96faf5bb8844656d0cp-2,
    0x1.62b958p-2
  },
  { // Entry 388
    -0x1.5579fd644a1a2d96faf5bb8844656d0cp-2,
    -0x1.62b958p-2
  },
  { // Entry 389
    0x1.894ae05fefe6ee1164c3e769b2b1a84ep-2,
    0x1.9dd83cp-2
  },
  { // Entry 390
    -0x1.894ae05fefe6ee1164c3e769b2b1a84ep-2,
    -0x1.9dd83cp-2
  },
  { // Entry 391
    0x1.bb12f2d65df13ff36b74e12066022236p-2,
    0x1.d8f720p-2
  },
  { // Entry 392
    -0x1.bb12f2d65df13ff36b74e12066022236p-2,
    -0x1.d8f720p-2
  },
  { // Entry 393
    0x1.eab7b26f955752e78c062cb6087064d9p-2,
    0x1.0a0b02p-1
  },
  { // Entry 394
    -0x1.eab7b26f955752e78c062cb6087064d9p-2,
    -0x1.0a0b02p-1
  },
  { // Entry 395
    0x1.1c03f7900131c7cb3fbfbb5e6c5115eap-1,
    0x1.3d3e36p-1
  },
  { // Entry 396
    -0x1.1c03f7900131c7cb3fbfbb5e6c5115eap-1,
    -0x1.3d3e36p-1
  },
  { // Entry 397
    0x1.2b5b634ea20bdc86ee2a005916e6440ap-1,
    0x1.52e1f8p-1
  },
  { // Entry 398
    -0x1.2b5b634ea20bdc86ee2a005916e6440ap-1,
    -0x1.52e1f8p-1
  },
  { // Entry 399
    0x1.3a1d033b0b8af99ba311a5b2b61923fdp-1,
    0x1.6885bap-1
  },
  { // Entry 400
    -0x1.3a1d033b0b8af99ba311a5b2b61923fdp-1,
    -0x1.6885bap-1
  },
  { // Entry 401
    0x1.484b53fe3670095a8de580bd37b09834p-1,
    0x1.7e297cp-1
  },
  { // Entry 402
    -0x1.484b53fe3670095a8de580bd37b09834p-1,
    -0x1.7e297cp-1
  },
  { // Entry 403
    0x1.55e989109067d04fb47f38831112284ep-1,
    0x1.93cd3ep-1
  },
  { // Entry 404
    -0x1.55e989109067d04fb47f38831112284ep-1,
    -0x1.93cd3ep-1
  },
  { // Entry 405
    0x1.62fb670fb893cf191d38ab2f1067b2dep-1,
    0x1.a971p-1
  },
  { // Entry 406
    -0x1.62fb670fb893cf191d38ab2f1067b2dep-1,
    -0x1.a971p-1
  },
  { // Entry 407
    0x1.6f8521f44dc815420fa612edb64cbde6p-1,
    0x1.bf14c2p-1
  },
  { // Entry 408
    -0x1.6f8521f44dc815420fa612edb64cbde6p-1,
    -0x1.bf14c2p-1
  },
  { // Entry 409
    0x1.7b8b3f52ed1004e7b2fde26964f1ce72p-1,
    0x1.d4b884p-1
  },
  { // Entry 410
    -0x1.7b8b3f52ed1004e7b2fde26964f1ce72p-1,
    -0x1.d4b884p-1
  },
  { // Entry 411
    0x1.8712787339dc1bb28aacdbb75d0eda49p-1,
    0x1.ea5c3ep-1
  },
  { // Entry 412
    -0x1.8712787339dc1bb28aacdbb75d0eda49p-1,
    -0x1.ea5c3ep-1
  },
  { // Entry 413
    0x1.a431f41e221ee2993e28481f34f7c822p-1,
    0x1.12bd92p0
  },
  { // Entry 414
    -0x1.a431f41e221ee2993e28481f34f7c822p-1,
    -0x1.12bd92p0
  },
  { // Entry 415
    0x1.b4fe853106c1ee9ed92061a86abea8fbp-1,
    0x1.257b24p0
  },
  { // Entry 416
    -0x1.b4fe853106c1ee9ed92061a86abea8fbp-1,
    -0x1.257b24p0
  },
  { // Entry 417
    0x1.c49e49d8ce799df605c0c3754f12c804p-1,
    0x1.3838b6p0
  },
  { // Entry 418
    -0x1.c49e49d8ce799df605c0c3754f12c804p-1,
    -0x1.3838b6p0
  },
  { // Entry 419
    0x1.d32908a5e902e2f9d1bdd644edec4fecp-1,
    0x1.4af648p0
  },
  { // Entry 420
    -0x1.d32908a5e902e2f9d1bdd644edec4fecp-1,
    -0x1.4af648p0
  },
  { // Entry 421
    0x1.e0b5269ed18eb6e8f1b485483f950e69p-1,
    0x1.5db3dap0
  },
  { // Entry 422
    -0x1.e0b5269ed18eb6e8f1b485483f950e69p-1,
    -0x1.5db3dap0
  },
  { // Entry 423
    0x1.ed57828f84cacdec44b29eaeb9138ae7p-1,
    0x1.70716cp0
  },
  { // Entry 424
    -0x1.ed57828f84cacdec44b29eaeb9138ae7p-1,
    -0x1.70716cp0
  },
  { // Entry 425
    0x1.f9236870954c3910ae46db78e8dab4a1p-1,
    0x1.832efep0
  },
  { // Entry 426
    -0x1.f9236870954c3910ae46db78e8dab4a1p-1,
    -0x1.832efep0
  },
  { // Entry 427
    0x1.02154a9c2f5c8c14720789b394a8d71ep0,
    0x1.95ec90p0
  },
  { // Entry 428
    -0x1.02154a9c2f5c8c14720789b394a8d71ep0,
    -0x1.95ec90p0
  },
  { // Entry 429
    0x1.073ea11368f7a47972c7a90fc77e3c33p0,
    0x1.a8aa1cp0
  },
  { // Entry 430
    -0x1.073ea11368f7a47972c7a90fc77e3c33p0,
    -0x1.a8aa1cp0
  },
  { // Entry 431
    0x1.96c4c21383607ec90510b32aa175fe13p-1,
    0x1.04aff8p0
  },
  { // Entry 432
    -0x1.96c4c21383607ec90510b32aa175fe13p-1,
    -0x1.04aff8p0
  },
  { // Entry 433
    0x1.96c5670707d079f967bde56724a1508cp-1,
    0x1.04b0a0p0
  },
  { // Entry 434
    -0x1.96c5670707d079f967bde56724a1508cp-1,
    -0x1.04b0a0p0
  },
  { // Entry 435
    0x1.96c60bfa20055aa638999dba9d5b9ba4p-1,
    0x1.04b148p0
  },
  { // Entry 436
    -0x1.96c60bfa20055aa638999dba9d5b9ba4p-1,
    -0x1.04b148p0
  },
  { // Entry 437
    0x1.96c6b0eccbff69175eae7d730f2d63c8p-1,
    0x1.04b1f0p0
  },
  { // Entry 438
    -0x1.96c6b0eccbff69175eae7d730f2d63c8p-1,
    -0x1.04b1f0p0
  },
  { // Entry 439
    0x1.96c755df0bbeed94bc0a76fe6f6efe03p-1,
    0x1.04b298p0
  },
  { // Entry 440
    -0x1.96c755df0bbeed94bc0a76fe6f6efe03p-1,
    -0x1.04b298p0
  },
  { // Entry 441
    0x1.96c7fad0df4430662dbe23a125fdf4dcp-1,
    0x1.04b340p0
  },
  { // Entry 442
    -0x1.96c7fad0df4430662dbe23a125fdf4dcp-1,
    -0x1.04b340p0
  },
  { // Entry 443
    0x1.96c89fc2468f79d38bdc192ed1b15eadp-1,
    0x1.04b3e8p0
  },
  { // Entry 444
    -0x1.96c89fc2468f79d38bdc192ed1b15eadp-1,
    -0x1.04b3e8p0
  },
  { // Entry 445
    0x1.96c944b341a11224a9783fc55088730ap-1,
    0x1.04b490p0
  },
  { // Entry 446
    -0x1.96c944b341a11224a9783fc55088730ap-1,
    -0x1.04b490p0
  },
  { // Entry 447
    0x1.96c9e5b678ff391c2d3fa2849c0a25d4p-1,
    0x1.04b534p0
  },
  { // Entry 448
    -0x1.96c9e5b678ff391c2d3fa2849c0a25d4p-1,
    -0x1.04b534p0
  },
  { // Entry 449
    -0.0f,
    -0x1.p-149
  },
  { // Entry 450
    0.0f,
    0x1.p-149
  },
  { // Entry 451
    0.0,
    0.0
  },
  { // Entry 452
    0.0f,
    0x1.p-149
  },
  { // Entry 453
    -0.0f,
    -0x1.p-149
  },
  { // Entry 454
    0x1.0c1521c014d01f8a9ddecc36f1430940p-1,
    0x1.279a72p-1
  },
  { // Entry 455
    -0x1.0c1521c014d01f8a9ddecc36f1430940p-1,
    -0x1.279a72p-1
  },
  { // Entry 456
    0x1.0c15234014d0ffa236d9926a680fd817p-1,
    0x1.279a74p-1
  },
  { // Entry 457
    -0x1.0c15234014d0ffa236d9926a680fd817p-1,
    -0x1.279a74p-1
  },
  { // Entry 458
    0x1.0c1524c014d0932c0cf0350674c305cap-1,
    0x1.279a76p-1
  },
  { // Entry 459
    -0x1.0c1524c014d0932c0cf0350674c305cap-1,
    -0x1.279a76p-1
  },
  { // Entry 460
    0x1.0c1522e17602fe431351c1c08ae51ff7p0,
    0x1.bb67acp0
  },
  { // Entry 461
    -0x1.0c1522e17602fe431351c1c08ae51ff7p0,
    -0x1.bb67acp0
  },
  { // Entry 462
    0x1.0c1523617603a6edb72557e634b4b8e0p0,
    0x1.bb67aep0
  },
  { // Entry 463
    -0x1.0c1523617603a6edb72557e634b4b8e0p0,
    -0x1.bb67aep0
  },
  { // Entry 464
    0x1.0c1523e1760371e48330a6db47968a93p0,
    0x1.bb67b0p0
  },
  { // Entry 465
    -0x1.0c1523e1760371e48330a6db47968a93p0,
    -0x1.bb67b0p0
  },
  { // Entry 466
    0x1.a64eea8f03b7833c1b78f9cef282cf0fp-2,
    0x1.bffffep-2
  },
  { // Entry 467
    -0x1.a64eea8f03b7833c1b78f9cef282cf0fp-2,
    -0x1.bffffep-2
  },
  { // Entry 468
    0x1.a64eec3cc23fcb6c84f92bd2003ce26cp-2,
    0x1.c0p-2
  },
  { // Entry 469
    -0x1.a64eec3cc23fcb6c84f92bd2003ce26cp-2,
    -0x1.c0p-2
  },
  { // Entry 470
    0x1.a64eedea80c775ce2723b37d5f27788dp-2,
    0x1.c00002p-2
  },
  { // Entry 471
    -0x1.a64eedea80c775ce2723b37d5f27788dp-2,
    -0x1.c00002p-2
  },
  { // Entry 472
    0x1.345f007137aead7202d87adc5e70e53ep-1,
    0x1.5ffffep-1
  },
  { // Entry 473
    -0x1.345f007137aead7202d87adc5e70e53ep-1,
    -0x1.5ffffep-1
  },
  { // Entry 474
    0x1.345f01cce37bb440844df1c4409fe779p-1,
    0x1.60p-1
  },
  { // Entry 475
    -0x1.345f01cce37bb440844df1c4409fe779p-1,
    -0x1.60p-1
  },
  { // Entry 476
    0x1.345f03288f477671552f403f77363c6ep-1,
    0x1.600002p-1
  },
  { // Entry 477
    -0x1.345f03288f477671552f403f77363c6ep-1,
    -0x1.600002p-1
  },
  { // Entry 478
    0x1.bde70d2b5b9861800016d24f37e1f182p-1,
    0x1.2ffffep0
  },
  { // Entry 479
    -0x1.bde70d2b5b9861800016d24f37e1f182p-1,
    -0x1.2ffffep0
  },
  { // Entry 480
    0x1.bde70ed439fe6cba95391a7f421b3821p-1,
    0x1.30p0
  },
  { // Entry 481
    -0x1.bde70ed439fe6cba95391a7f421b3821p-1,
    -0x1.30p0
  },
  { // Entry 482
    0x1.bde7107d1861329d77f85e21c5cf991dp-1,
    0x1.300002p0
  },
  { // Entry 483
    -0x1.bde7107d1861329d77f85e21c5cf991dp-1,
    -0x1.300002p0
  },
  { // Entry 484
    0x1.2e7571f4ae6251e5ddb771325105495ep0,
    0x1.37fffep1
  },
  { // Entry 485
    -0x1.2e7571f4ae6251e5ddb771325105495ep0,
    -0x1.37fffep1
  },
  { // Entry 486
    0x1.2e75728833a54116e3ef7326bd9839p0,
    0x1.38p1
  },
  { // Entry 487
    -0x1.2e75728833a54116e3ef7326bd9839p0,
    -0x1.38p1
  },
  { // Entry 488
    0x1.2e75731bb8e691dca788c02332d288f0p0,
    0x1.380002p1
  },
  { // Entry 489
    -0x1.2e75731bb8e691dca788c02332d288f0p0,
    -0x1.380002p1
  },
  { // Entry 490
    0x1.0640a805eb5ac8d45f6e626469cfd37cp-4,
    0x1.069c8cp-4
  },
  { // Entry 491
    -0x1.0640a805eb5ac8d45f6e626469cfd37cp-4,
    -0x1.069c8cp-4
  },
  { // Entry 492
    0x1.052fabecdb3192006601da57b9f185bbp-3,
    0x1.069c8cp-3
  },
  { // Entry 493
    -0x1.052fabecdb3192006601da57b9f185bbp-3,
    -0x1.069c8cp-3
  },
  { // Entry 494
    0x1.852a2293776e3c2cf4b7a237dfbcac9cp-3,
    0x1.89ead2p-3
  },
  { // Entry 495
    -0x1.852a2293776e3c2cf4b7a237dfbcac9cp-3,
    -0x1.89ead2p-3
  },
  { // Entry 496
    0x1.01123c6ee78df9fddeaeaac0f651fffdp-2,
    0x1.069c8cp-2
  },
  { // Entry 497
    -0x1.01123c6ee78df9fddeaeaac0f651fffdp-2,
    -0x1.069c8cp-2
  },
  { // Entry 498
    0x1.3daa74f913ef98bebdaf6ff5fe9ed93ep-2,
    0x1.4843b0p-2
  },
  { // Entry 499
    -0x1.3daa74f913ef98bebdaf6ff5fe9ed93ep-2,
    -0x1.4843b0p-2
  },
  { // Entry 500
    0x1.780c486991daa5d72fdda5ce57d44289p-2,
    0x1.89ead4p-2
  },
  { // Entry 501
    -0x1.780c486991daa5d72fdda5ce57d44289p-2,
    -0x1.89ead4p-2
  },
  { // Entry 502
    0x1.affab023fe5819ab1f4cad60051a8345p-2,
    0x1.cb91f8p-2
  },
  { // Entry 503
    -0x1.affab023fe5819ab1f4cad60051a8345p-2,
    -0x1.cb91f8p-2
  },
  { // Entry 504
    0x1.e54c83edcc5caaa7a074644b3d2183a2p-2,
    0x1.069c8ep-1
  },
  { // Entry 505
    -0x1.e54c83edcc5caaa7a074644b3d2183a2p-2,
    -0x1.069c8ep-1
  },
  { // Entry 506
    0x1.0bf5631d21b59bea6037065bd184c7fdp-1,
    0x1.277020p-1
  },
  { // Entry 507
    -0x1.0bf5631d21b59bea6037065bd184c7fdp-1,
    -0x1.277020p-1
  },
  { // Entry 508
    0x1.23e71a9565cd2e40ee391514bdb4e6d5p-1,
    0x1.4843b2p-1
  },
  { // Entry 509
    -0x1.23e71a9565cd2e40ee391514bdb4e6d5p-1,
    -0x1.4843b2p-1
  },
  { // Entry 510
    0x1.3a7e42481b7080ceeca06ac375e2af5bp-1,
    0x1.691744p-1
  },
  { // Entry 511
    -0x1.3a7e42481b7080ceeca06ac375e2af5bp-1,
    -0x1.691744p-1
  },
  { // Entry 512
    0x1.4fc2c891491b52874ce2931f24e4b619p-1,
    0x1.89ead6p-1
  },
  { // Entry 513
    -0x1.4fc2c891491b52874ce2931f24e4b619p-1,
    -0x1.89ead6p-1
  },
  { // Entry 514
    0x1.63c0625215a8fafdacb65eebcc76d090p-1,
    0x1.aabe68p-1
  },
  { // Entry 515
    -0x1.63c0625215a8fafdacb65eebcc76d090p-1,
    -0x1.aabe68p-1
  },
  { // Entry 516
    0x1.768565c528c1c7512181ef021a9befe5p-1,
    0x1.cb91fap-1
  },
  { // Entry 517
    -0x1.768565c528c1c7512181ef021a9befe5p-1,
    -0x1.cb91fap-1
  },
  { // Entry 518
    0x1.8821d517853a9293101e345ad74f6492p-1,
    0x1.ec658cp-1
  },
  { // Entry 519
    -0x1.8821d517853a9293101e345ad74f6492p-1,
    -0x1.ec658cp-1
  },
  { // Entry 520
    0x1.98a6983a1f69e2ba7830d45b9caa2847p-1,
    0x1.069c8ep0
  },
  { // Entry 521
    -0x1.98a6983a1f69e2ba7830d45b9caa2847p-1,
    -0x1.069c8ep0
  },
  { // Entry 522
    0x1.a824e7446479e89c28c3c93afc5c60a3p-1,
    0x1.170656p0
  },
  { // Entry 523
    -0x1.a824e7446479e89c28c3c93afc5c60a3p-1,
    -0x1.170656p0
  },
  { // Entry 524
    0x1.b6add56905c11877985184b1ee5d353ap-1,
    0x1.27701ep0
  },
  { // Entry 525
    -0x1.b6add56905c11877985184b1ee5d353ap-1,
    -0x1.27701ep0
  },
  { // Entry 526
    0x1.c4520084d880847dda367ba8b7a8b21dp-1,
    0x1.37d9e6p0
  },
  { // Entry 527
    -0x1.c4520084d880847dda367ba8b7a8b21dp-1,
    -0x1.37d9e6p0
  },
  { // Entry 528
    0x1.d121598ed50fface6324aa1c21a74d23p-1,
    0x1.4843aep0
  },
  { // Entry 529
    -0x1.d121598ed50fface6324aa1c21a74d23p-1,
    -0x1.4843aep0
  },
  { // Entry 530
    0x1.dd2b014fde35d165c474a1122825802dp-1,
    0x1.58ad76p0
  },
  { // Entry 531
    -0x1.dd2b014fde35d165c474a1122825802dp-1,
    -0x1.58ad76p0
  },
  { // Entry 532
    0x1.e87d3481ac8dd5621a3b3c4f921c44fap-1,
    0x1.69173ep0
  },
  { // Entry 533
    -0x1.e87d3481ac8dd5621a3b3c4f921c44fap-1,
    -0x1.69173ep0
  },
  { // Entry 534
    0x1.f32543520ef9c5f5810f6db85d7aaf28p-1,
    0x1.798106p0
  },
  { // Entry 535
    -0x1.f32543520ef9c5f5810f6db85d7aaf28p-1,
    -0x1.798106p0
  },
  { // Entry 536
    0x1.fd2f9116e59cee8a040e62d4b5243e1ap-1,
    0x1.89eacep0
  },
  { // Entry 537
    -0x1.fd2f9116e59cee8a040e62d4b5243e1ap-1,
    -0x1.89eacep0
  },
  { // Entry 538
    0x1.0353ccda2d644d7938c482410bb91bb1p0,
    0x1.9a5496p0
  },
  { // Entry 539
    -0x1.0353ccda2d644d7938c482410bb91bb1p0,
    -0x1.9a5496p0
  },
  { // Entry 540
    0x1.07cbfd6728be1d728e6efaa566962a31p0,
    0x1.aabe5ep0
  },
  { // Entry 541
    -0x1.07cbfd6728be1d728e6efaa566962a31p0,
    -0x1.aabe5ep0
  },
  { // Entry 542
    0x1.0c053fac5615bd33ea669091fc7a90bcp0,
    0x1.bb2826p0
  },
  { // Entry 543
    -0x1.0c053fac5615bd33ea669091fc7a90bcp0,
    -0x1.bb2826p0
  },
  { // Entry 544
    0x1.1004163d82000593e7df6bce3d8cab10p0,
    0x1.cb91eep0
  },
  { // Entry 545
    -0x1.1004163d82000593e7df6bce3d8cab10p0,
    -0x1.cb91eep0
  },
  { // Entry 546
    0x1.13cca783c7bd2088b900b4113ba87852p0,
    0x1.dbfbb6p0
  },
  { // Entry 547
    -0x1.13cca783c7bd2088b900b4113ba87852p0,
    -0x1.dbfbb6p0
  },
  { // Entry 548
    0x1.1762c47f210f545ac9a8a7e0241e7259p0,
    0x1.ec657ep0
  },
  { // Entry 549
    -0x1.1762c47f210f545ac9a8a7e0241e7259p0,
    -0x1.ec657ep0
  },
  { // Entry 550
    0x1.1ac9ef601c2f97f7b0f0a6d93dd834eep0,
    0x1.fccf46p0
  },
  { // Entry 551
    -0x1.1ac9ef601c2f97f7b0f0a6d93dd834eep0,
    -0x1.fccf46p0
  },
  { // Entry 552
    0x1.1e05623dfb4cc3c6baa62e4bc279a9a4p0,
    0x1.069c88p1
  },
  { // Entry 553
    -0x1.1e05623dfb4cc3c6baa62e4bc279a9a4p0,
    -0x1.069c88p1
  },
  { // Entry 554
    0x1.21181384588be60732d01848bc71700bp0,
    0x1.0ed16cp1
  },
  { // Entry 555
    -0x1.21181384588be60732d01848bc71700bp0,
    -0x1.0ed16cp1
  },
  { // Entry 556
    0x1.2404bde8e2552de3cc50334d78b5dc4ap0,
    0x1.170650p1
  },
  { // Entry 557
    -0x1.2404bde8e2552de3cc50334d78b5dc4ap0,
    -0x1.170650p1
  },
  { // Entry 558
    0x1.26cde4061c757738e2ce7f21522b89dap0,
    0x1.1f3b34p1
  },
  { // Entry 559
    -0x1.26cde4061c757738e2ce7f21522b89dap0,
    -0x1.1f3b34p1
  },
  { // Entry 560
    0x1.2975d58f5e9bdfe1899ef21d99c49b2bp0,
    0x1.277018p1
  },
  { // Entry 561
    -0x1.2975d58f5e9bdfe1899ef21d99c49b2bp0,
    -0x1.277018p1
  },
  { // Entry 562
    0x1.2bfeb3b9bbea83cde56fbf951e871487p0,
    0x1.2fa4fcp1
  },
  { // Entry 563
    -0x1.2bfeb3b9bbea83cde56fbf951e871487p0,
    -0x1.2fa4fcp1
  },
  { // Entry 564
    0x1.2e6a7545ba88692a48d56e5581873211p0,
    0x1.37d9e0p1
  },
  { // Entry 565
    -0x1.2e6a7545ba88692a48d56e5581873211p0,
    -0x1.37d9e0p1
  },
  { // Entry 566
    0x1.30baea2f60c5a59cc6d2e94130f95768p0,
    0x1.400ec4p1
  },
  { // Entry 567
    -0x1.30baea2f60c5a59cc6d2e94130f95768p0,
    -0x1.400ec4p1
  },
  { // Entry 568
    0x1.32f1bf0aa92c8a65a6948643fdcfd255p0,
    0x1.4843a8p1
  },
  { // Entry 569
    -0x1.32f1bf0aa92c8a65a6948643fdcfd255p0,
    -0x1.4843a8p1
  },
  { // Entry 570
    0x1.35108012a113c05aaab2d146f1393f5cp0,
    0x1.50788cp1
  },
  { // Entry 571
    -0x1.35108012a113c05aaab2d146f1393f5cp0,
    -0x1.50788cp1
  },
  { // Entry 572
    0x1.37189bf16a71201adaf5b8708459828ep0,
    0x1.58ad70p1
  },
  { // Entry 573
    -0x1.37189bf16a71201adaf5b8708459828ep0,
    -0x1.58ad70p1
  },
  { // Entry 574
    0x1.390b6647268e4ff7a7fc9ad3d315ca68p0,
    0x1.60e254p1
  },
  { // Entry 575
    -0x1.390b6647268e4ff7a7fc9ad3d315ca68p0,
    -0x1.60e254p1
  },
  { // Entry 576
    0x1.3aea19f582cfb2fc7f01e690b9e61c32p0,
    0x1.691738p1
  },
  { // Entry 577
    -0x1.3aea19f582cfb2fc7f01e690b9e61c32p0,
    -0x1.691738p1
  },
  { // Entry 578
    0x1.3cb5db3545a9577b9d057ce82dc608c6p0,
    0x1.714c1cp1
  },
  { // Entry 579
    -0x1.3cb5db3545a9577b9d057ce82dc608c6p0,
    -0x1.714c1cp1
  },
  { // Entry 580
    0x1.3e6fb97ad7a66ba04c7b01d1646602e1p0,
    0x1.7981p1
  },
  { // Entry 581
    -0x1.3e6fb97ad7a66ba04c7b01d1646602e1p0,
    -0x1.7981p1
  },
  { // Entry 582
    0x1.4018b12e603d690dfd89144ca355ad7cp0,
    0x1.81b5e4p1
  },
  { // Entry 583
    -0x1.4018b12e603d690dfd89144ca355ad7cp0,
    -0x1.81b5e4p1
  },
  { // Entry 584
    0x1.41b1ad3bab8b579c71ceb89cb23a4191p0,
    0x1.89eac8p1
  },
  { // Entry 585
    -0x1.41b1ad3bab8b579c71ceb89cb23a4191p0,
    -0x1.89eac8p1
  },
  { // Entry 586
    -0x1.6807a9ecb61e7179d47b86a3d7d89614p0,
    -0x1.81b5eep2
  },
  { // Entry 587
    0x1.6807a9ecb61e7179d47b86a3d7d89614p0,
    0x1.81b5eep2
  },
  { // Entry 588
    -0x1.6631e1e590c8943bb980827585841401p0,
    -0x1.714c26p2
  },
  { // Entry 589
    0x1.6631e1e590c8943bb980827585841401p0,
    0x1.714c26p2
  },
  { // Entry 590
    -0x1.6431bbdbbb23b05a6294690cc8fe4afbp0,
    -0x1.60e25ep2
  },
  { // Entry 591
    0x1.6431bbdbbb23b05a6294690cc8fe4afbp0,
    0x1.60e25ep2
  },
  { // Entry 592
    -0x1.620149ba05b3abd7c744898b395ff078p0,
    -0x1.507896p2
  },
  { // Entry 593
    0x1.620149ba05b3abd7c744898b395ff078p0,
    0x1.507896p2
  },
  { // Entry 594
    -0x1.5f99784c16ae6ade09784989de90f9cep0,
    -0x1.400ecep2
  },
  { // Entry 595
    0x1.5f99784c16ae6ade09784989de90f9cep0,
    0x1.400ecep2
  },
  { // Entry 596
    -0x1.5cf1c615f954a1c183fa9df874538ee9p0,
    -0x1.2fa506p2
  },
  { // Entry 597
    0x1.5cf1c615f954a1c183fa9df874538ee9p0,
    0x1.2fa506p2
  },
  { // Entry 598
    -0x1.59ffe38b71898ed7998b335085e65964p0,
    -0x1.1f3b3ep2
  },
  { // Entry 599
    0x1.59ffe38b71898ed7998b335085e65964p0,
    0x1.1f3b3ep2
  },
  { // Entry 600
    -0x1.56b7343ee6671bf137c3060d6bbac90bp0,
    -0x1.0ed176p2
  },
  { // Entry 601
    0x1.56b7343ee6671bf137c3060d6bbac90bp0,
    0x1.0ed176p2
  },
  { // Entry 602
    -0x1.530824ba9228f906cf6fbbb114073212p0,
    -0x1.fccf5ap1
  },
  { // Entry 603
    0x1.530824ba9228f906cf6fbbb114073212p0,
    0x1.fccf5ap1
  },
  { // Entry 604
    -0x1.4edf449b38ca3a22476f62c7349bb773p0,
    -0x1.dbfbc8p1
  },
  { // Entry 605
    0x1.4edf449b38ca3a22476f62c7349bb773p0,
    0x1.dbfbc8p1
  },
  { // Entry 606
    -0x1.4a2408f508131a351e75bd65a563180ap0,
    -0x1.bb2836p1
  },
  { // Entry 607
    0x1.4a2408f508131a351e75bd65a563180ap0,
    0x1.bb2836p1
  },
  { // Entry 608
    -0x1.44b712953f85f723e8b9348c9f600a8cp0,
    -0x1.9a54a4p1
  },
  { // Entry 609
    0x1.44b712953f85f723e8b9348c9f600a8cp0,
    0x1.9a54a4p1
  },
  { // Entry 610
    -0x1.3e6fbd3122418ea0ac307a2ed17c0d28p0,
    -0x1.798112p1
  },
  { // Entry 611
    0x1.3e6fbd3122418ea0ac307a2ed17c0d28p0,
    0x1.798112p1
  },
  { // Entry 612
    -0x1.37189fd23f9a7ac18ff4e4c5821e80bfp0,
    -0x1.58ad80p1
  },
  { // Entry 613
    0x1.37189fd23f9a7ac18ff4e4c5821e80bfp0,
    0x1.58ad80p1
  },
  { // Entry 614
    -0x1.2e6a794f37529d7b8c78438094df8560p0,
    -0x1.37d9eep1
  },
  { // Entry 615
    0x1.2e6a794f37529d7b8c78438094df8560p0,
    0x1.37d9eep1
  },
  { // Entry 616
    -0x1.2404c2150e76f6d23e4a514c77839926p0,
    -0x1.17065cp1
  },
  { // Entry 617
    0x1.2404c2150e76f6d23e4a514c77839926p0,
    0x1.17065cp1
  },
  { // Entry 618
    -0x1.1762c92d89f7b516e38b1fadbc7c1725p0,
    -0x1.ec6594p0
  },
  { // Entry 619
    0x1.1762c92d89f7b516e38b1fadbc7c1725p0,
    0x1.ec6594p0
  },
  { // Entry 620
    -0x1.07cc022a998cd36350736775629f7411p0,
    -0x1.aabe70p0
  },
  { // Entry 621
    0x1.07cc022a998cd36350736775629f7411p0,
    0x1.aabe70p0
  },
  { // Entry 622
    -0x1.e87d3ddf5d974d08f4dd58fe2cb62a75p-1,
    -0x1.69174cp0
  },
  { // Entry 623
    0x1.e87d3ddf5d974d08f4dd58fe2cb62a75p-1,
    0x1.69174cp0
  },
  { // Entry 624
    -0x1.b6adddfcb60791bdfa29e43ae237526cp-1,
    -0x1.277028p0
  },
  { // Entry 625
    0x1.b6adddfcb60791bdfa29e43ae237526cp-1,
    0x1.277028p0
  },
  { // Entry 626
    -0x1.76856ea18da195176e0ece2cba9470a9p-1,
    -0x1.cb920ap-1
  },
  { // Entry 627
    0x1.76856ea18da195176e0ece2cba9470a9p-1,
    0x1.cb920ap-1
  },
  { // Entry 628
    -0x1.23e72757057c5809379a3139ba87791dp-1,
    -0x1.4843c4p-1
  },
  { // Entry 629
    0x1.23e72757057c5809379a3139ba87791dp-1,
    0x1.4843c4p-1
  },
  { // Entry 630
    -0x1.780c6b4190a4c02ec686d865d59869c8p-2,
    -0x1.89eafcp-2
  },
  { // Entry 631
    0x1.780c6b4190a4c02ec686d865d59869c8p-2,
    0x1.89eafcp-2
  },
  { // Entry 632
    -0x1.052ffe90feb23c1016d89c3f01bc9e1fp-3,
    -0x1.069ce0p-3
  },
  { // Entry 633
    0x1.052ffe90feb23c1016d89c3f01bc9e1fp-3,
    0x1.069ce0p-3
  },
  { // Entry 634
    0x1.052f5948b6d5f860bd33815fb4292679p-3,
    0x1.069c38p-3
  },
  { // Entry 635
    -0x1.052f5948b6d5f860bd33815fb4292679p-3,
    -0x1.069c38p-3
  },
  { // Entry 636
    0x1.780c22159221d1976cc58c067c712c12p-2,
    0x1.89eaa8p-2
  },
  { // Entry 637
    -0x1.780c22159221d1976cc58c067c712c12p-2,
    -0x1.89eaa8p-2
  },
  { // Entry 638
    0x1.23e709933aec019daf9a653afa37bd56p-1,
    0x1.48439ap-1
  },
  { // Entry 639
    -0x1.23e709933aec019daf9a653afa37bd56p-1,
    -0x1.48439ap-1
  },
  { // Entry 640
    0x1.7685575f043fc937570fbcd679218a9ep-1,
    0x1.cb91e0p-1
  },
  { // Entry 641
    -0x1.7685575f043fc937570fbcd679218a9ep-1,
    -0x1.cb91e0p-1
  },
  { // Entry 642
    0x1.b6adccd55525b9c5503e0cdc8d37e90ep-1,
    0x1.277014p0
  },
  { // Entry 643
    -0x1.b6adccd55525b9c5503e0cdc8d37e90ep-1,
    -0x1.277014p0
  },
  { // Entry 644
    0x1.e87d307e1763e6189f33adfb0e8068c9p-1,
    0x1.691738p0
  },
  { // Entry 645
    -0x1.e87d307e1763e6189f33adfb0e8068c9p-1,
    -0x1.691738p0
  },
  { // Entry 646
    0x1.07cbfcdfaa6996b12b44434dca3635e9p0,
    0x1.aabe5cp0
  },
  { // Entry 647
    -0x1.07cbfcdfaa6996b12b44434dca3635e9p0,
    -0x1.aabe5cp0
  },
  { // Entry 648
    0x1.1762c4ec13567bd7f5f799b650139ef2p0,
    0x1.ec6580p0
  },
  { // Entry 649
    -0x1.1762c4ec13567bd7f5f799b650139ef2p0,
    -0x1.ec6580p0
  },
  { // Entry 650
    0x1.2404be9ae9b56a1e7b93aab429a437dcp0,
    0x1.170652p1
  },
  { // Entry 651
    -0x1.2404be9ae9b56a1e7b93aab429a437dcp0,
    -0x1.170652p1
  },
  { // Entry 652
    0x1.2e6a766d02ca49766b8c5e064edd330ap0,
    0x1.37d9e4p1
  },
  { // Entry 653
    -0x1.2e6a766d02ca49766b8c5e064edd330ap0,
    -0x1.37d9e4p1
  },
  { // Entry 654
    0x1.37189d65ba6a203671b78263ea59150ep0,
    0x1.58ad76p1
  },
  { // Entry 655
    -0x1.37189d65ba6a203671b78263ea59150ep0,
    -0x1.58ad76p1
  },
  { // Entry 656
    0x1.3e6fbb2131bc83fb7bb1680528d88125p0,
    0x1.798108p1
  },
  { // Entry 657
    -0x1.3e6fbb2131bc83fb7bb1680528d88125p0,
    -0x1.798108p1
  },
  { // Entry 658
    0x1.44b710cf357eefd513350249454692fep0,
    0x1.9a549ap1
  },
  { // Entry 659
    -0x1.44b710cf357eefd513350249454692fep0,
    -0x1.9a549ap1
  },
  { // Entry 660
    0x1.4a24076ac744c5d206c4362f0a81c539p0,
    0x1.bb282cp1
  },
  { // Entry 661
    -0x1.4a24076ac744c5d206c4362f0a81c539p0,
    -0x1.bb282cp1
  },
  { // Entry 662
    0x1.4edf4341eeb190f38d0f628df7c0f39cp0,
    0x1.dbfbbep1
  },
  { // Entry 663
    -0x1.4edf4341eeb190f38d0f628df7c0f39cp0,
    -0x1.dbfbbep1
  },
  { // Entry 664
    0x1.53082389d4de0bf0033c96e02e4ce915p0,
    0x1.fccf50p1
  },
  { // Entry 665
    -0x1.53082389d4de0bf0033c96e02e4ce915p0,
    -0x1.fccf50p1
  },
  { // Entry 666
    0x1.56b732f9ebf592c0c94096bc1ed28a6bp0,
    0x1.0ed170p2
  },
  { // Entry 667
    -0x1.56b732f9ebf592c0c94096bc1ed28a6bp0,
    -0x1.0ed170p2
  },
  { // Entry 668
    0x1.59ffe268d6801ace03f3d195dcfe7b03p0,
    0x1.1f3b38p2
  },
  { // Entry 669
    -0x1.59ffe268d6801ace03f3d195dcfe7b03p0,
    -0x1.1f3b38p2
  },
  { // Entry 670
    0x1.5cf1c510a2c51231c77aeb5bcfdb18f6p0,
    0x1.2fa5p2
  },
  { // Entry 671
    -0x1.5cf1c510a2c51231c77aeb5bcfdb18f6p0,
    -0x1.2fa5p2
  },
  { // Entry 672
    0x1.5f99775fdcea19d02889374d890664b5p0,
    0x1.400ec8p2
  },
  { // Entry 673
    -0x1.5f99775fdcea19d02889374d890664b5p0,
    -0x1.400ec8p2
  },
  { // Entry 674
    0x1.620148e37eeeed056aad41e79a62c2c1p0,
    0x1.507890p2
  },
  { // Entry 675
    -0x1.620148e37eeeed056aad41e79a62c2c1p0,
    -0x1.507890p2
  },
  { // Entry 676
    0x1.6431bb181361216275b0d203a9331c13p0,
    0x1.60e258p2
  },
  { // Entry 677
    -0x1.6431bb181361216275b0d203a9331c13p0,
    -0x1.60e258p2
  },
  { // Entry 678
    0x1.6631e1326b64f0282c465af90d9d3bd9p0,
    0x1.714c20p2
  },
  { // Entry 679
    -0x1.6631e1326b64f0282c465af90d9d3bd9p0,
    -0x1.714c20p2
  },
  { // Entry 680
    0x1.6807a948166caac881ad676127631903p0,
    0x1.81b5e8p2
  },
  { // Entry 681
    -0x1.6807a948166caac881ad676127631903p0,
    -0x1.81b5e8p2
  },
  { // Entry 682
    0x1.ef652bd0a90c724b11a56d2fd671af31p-5,
    0x1.effffep-5
  },
  { // Entry 683
    -0x1.ef652bd0a90c724b11a56d2fd671af31p-5,
    -0x1.effffep-5
  },
  { // Entry 684
    0x1.ef652dceca4dbeb14ee907159dd1c369p-5,
    0x1.f0p-5
  },
  { // Entry 685
    -0x1.ef652dceca4dbeb14ee907159dd1c369p-5,
    -0x1.f0p-5
  },
  { // Entry 686
    0x1.ef652fcceb8f073ec7ec4e0d20bb7bfbp-5,
    0x1.f00002p-5
  },
  { // Entry 687
    -0x1.ef652fcceb8f073ec7ec4e0d20bb7bfbp-5,
    -0x1.f00002p-5
  },
  { // Entry 688
    0x1.f57aae2e668fcd953f95c1400b66f69ap-4,
    0x1.f7fffep-4
  },
  { // Entry 689
    -0x1.f57aae2e668fcd953f95c1400b66f69ap-4,
    -0x1.f7fffep-4
  },
  { // Entry 690
    0x1.f57ab026c3a8fc7b278a06e9d0c43e3ap-4,
    0x1.f8p-4
  },
  { // Entry 691
    -0x1.f57ab026c3a8fc7b278a06e9d0c43e3ap-4,
    -0x1.f8p-4
  },
  { // Entry 692
    0x1.f57ab21f20c21c186f960384371cb174p-4,
    0x1.f80002p-4
  },
  { // Entry 693
    -0x1.f57ab21f20c21c186f960384371cb174p-4,
    -0x1.f80002p-4
  },
  { // Entry 694
    0x1.49230059e7c45adb8ec67bfb8e8a656bp-3,
    0x1.4bfffep-3
  },
  { // Entry 695
    -0x1.49230059e7c45adb8ec67bfb8e8a656bp-3,
    -0x1.4bfffep-3
  },
  { // Entry 696
    0x1.4923024ccb780f5a7e2ead4e2bd24d33p-3,
    0x1.4cp-3
  },
  { // Entry 697
    -0x1.4923024ccb780f5a7e2ead4e2bd24d33p-3,
    -0x1.4cp-3
  },
  { // Entry 698
    0x1.4923043faf2b9c728ca66011aefa5d95p-3,
    0x1.4c0002p-3
  },
  { // Entry 699
    -0x1.4923043faf2b9c728ca66011aefa5d95p-3,
    -0x1.4c0002p-3
  },
  { // Entry 700
    0x1.2a73a5481536bc5af06b6df4531f2c45p-2,
    0x1.333332p-2
  },
  { // Entry 701
    -0x1.2a73a5481536bc5af06b6df4531f2c45p-2,
    -0x1.333332p-2
  },
  { // Entry 702
    0x1.2a73a71dcec15ae5ead00add4294e754p-2,
    0x1.333334p-2
  },
  { // Entry 703
    -0x1.2a73a71dcec15ae5ead00add4294e754p-2,
    -0x1.333334p-2
  },
  { // Entry 704
    0x1.2a73a8f3884b7828b0c0111255103dc3p-2,
    0x1.333336p-2
  },
  { // Entry 705
    -0x1.2a73a8f3884b7828b0c0111255103dc3p-2,
    -0x1.333336p-2
  },
  { // Entry 706
    0x1.2fc480fa0e88570eda20090113e29e36p-1,
    0x1.594316p-1
  },
  { // Entry 707
    -0x1.2fc480fa0e88570eda20090113e29e36p-1,
    -0x1.594316p-1
  },
  { // Entry 708
    0x1.2fc4825a02d3f974157fe3c500a7defbp-1,
    0x1.594318p-1
  },
  { // Entry 709
    -0x1.2fc4825a02d3f974157fe3c500a7defbp-1,
    -0x1.594318p-1
  },
  { // Entry 710
    0x1.2fc483b9f71e558d99929cc8e5da29dfp-1,
    0x1.59431ap-1
  },
  { // Entry 711
    -0x1.2fc483b9f71e558d99929cc8e5da29dfp-1,
    -0x1.59431ap-1
  },
  { // Entry 712
    0x1.538f567a9ef925d9ba9a4231046e7f2cp-1,
    0x1.8ffffep-1
  },
  { // Entry 713
    -0x1.538f567a9ef925d9ba9a4231046e7f2cp-1,
    -0x1.8ffffep-1
  },
  { // Entry 714
    0x1.538f57b89061eb9122d5096b7cf267ebp-1,
    0x1.90p-1
  },
  { // Entry 715
    -0x1.538f57b89061eb9122d5096b7cf267ebp-1,
    -0x1.90p-1
  },
  { // Entry 716
    0x1.538f58f681c97cc9bd5a1277e9e2f0fbp-1,
    0x1.900002p-1
  },
  { // Entry 717
    -0x1.538f58f681c97cc9bd5a1277e9e2f0fbp-1,
    -0x1.900002p-1
  },
  { // Entry 718
    -0.0f,
    -0x1.p-149
  },
  { // Entry 719
    0.0f,
    0x1.p-149
  },
  { // Entry 720
    0.0,
    0.0
  },
  { // Entry 721
    0.0f,
    0x1.p-149
  },
  { // Entry 722
    -0.0f,
    -0x1.p-149
  },
  { // Entry 723
    0x1.91cd2399d43fabf90187544276a9fdd6p-5,
    0x1.921fb4p-5
  },
  { // Entry 724
    -0x1.91cd2399d43fabf90187544276a9fdd6p-5,
    -0x1.921fb4p-5
  },
  { // Entry 725
    0x1.91cd2598992e3959b33089adc931af1bp-5,
    0x1.921fb6p-5
  },
  { // Entry 726
    -0x1.91cd2598992e3959b33089adc931af1bp-5,
    -0x1.921fb6p-5
  },
  { // Entry 727
    0x1.91cd27975e1cc39a020e1155956c974ep-5,
    0x1.921fb8p-5
  },
  { // Entry 728
    -0x1.91cd27975e1cc39a020e1155956c974ep-5,
    -0x1.921fb8p-5
  },
  { // Entry 729
    0x1.90d6de7dda04008932bb9dc6d6663dffp-4,
    0x1.921fb4p-4
  },
  { // Entry 730
    -0x1.90d6de7dda04008932bb9dc6d6663dffp-4,
    -0x1.921fb4p-4
  },
  { // Entry 731
    0x1.90d6e078f6c425534a52900d55c07c08p-4,
    0x1.921fb6p-4
  },
  { // Entry 732
    -0x1.90d6e078f6c425534a52900d55c07c08p-4,
    -0x1.921fb6p-4
  },
  { // Entry 733
    0x1.90d6e27413843dc984d6d696c18f157ap-4,
    0x1.921fb8p-4
  },
  { // Entry 734
    -0x1.90d6e27413843dc984d6d696c18f157ap-4,
    -0x1.921fb8p-4
  },
  { // Entry 735
    0x1.8d128d765c163bb2a4684b359bc37b4ap-3,
    0x1.921fb4p-3
  },
  { // Entry 736
    -0x1.8d128d765c163bb2a4684b359bc37b4ap-3,
    -0x1.921fb4p-3
  },
  { // Entry 737
    0x1.8d128f635a6f85e06f888e0887f9908fp-3,
    0x1.921fb6p-3
  },
  { // Entry 738
    -0x1.8d128f635a6f85e06f888e0887f9908fp-3,
    -0x1.921fb6p-3
  },
  { // Entry 739
    0x1.8d12915058c8a173e6b2d7c8cf5f012ap-3,
    0x1.921fb8p-3
  },
  { // Entry 740
    -0x1.8d12915058c8a173e6b2d7c8cf5f012ap-3,
    -0x1.921fb8p-3
  },
  { // Entry 741
    0x1.7f2d690b879f26b1634350104478a209p-2,
    0x1.921fb4p-2
  },
  { // Entry 742
    -0x1.7f2d690b879f26b1634350104478a209p-2,
    -0x1.921fb4p-2
  },
  { // Entry 743
    0x1.7f2d6ac71f4b19b38cf78bbadec1435ap-2,
    0x1.921fb6p-2
  },
  { // Entry 744
    -0x1.7f2d6ac71f4b19b38cf78bbadec1435ap-2,
    -0x1.921fb6p-2
  },
  { // Entry 745
    0x1.7f2d6c82b6f675c92c9dfa635f318ed7p-2,
    0x1.921fb8p-2
  },
  { // Entry 746
    -0x1.7f2d6c82b6f675c92c9dfa635f318ed7p-2,
    -0x1.921fb8p-2
  },
  { // Entry 747
    0x1.54e04b3d43589d0cc0bd332c6a822ecfp-1,
    0x1.921fb4p-1
  },
  { // Entry 748
    -0x1.54e04b3d43589d0cc0bd332c6a822ecfp-1,
    -0x1.921fb4p-1
  },
  { // Entry 749
    0x1.54e04c79ed9a93b01c6a9062dbd8e0ffp-1,
    0x1.921fb6p-1
  },
  { // Entry 750
    -0x1.54e04c79ed9a93b01c6a9062dbd8e0ffp-1,
    -0x1.921fb6p-1
  },
  { // Entry 751
    0x1.54e04db697db56ae489f89986a14a1b7p-1,
    0x1.921fb8p-1
  },
  { // Entry 752
    -0x1.54e04db697db56ae489f89986a14a1b7p-1,
    -0x1.921fb8p-1
  },
  { // Entry 753
    0x1.00fe98214bd47b0727cef70af68aceeep0,
    0x1.921fb4p0
  },
  { // Entry 754
    -0x1.00fe98214bd47b0727cef70af68aceeep0,
    -0x1.921fb4p0
  },
  { // Entry 755
    0x1.00fe98b4f50d8b3c36b9e2a180d97eeap0,
    0x1.921fb6p0
  },
  { // Entry 756
    -0x1.00fe98b4f50d8b3c36b9e2a180d97eeap0,
    -0x1.921fb6p0
  },
  { // Entry 757
    0x1.00fe99489e458fdeaf9be968cab6da63p0,
    0x1.921fb8p0
  },
  { // Entry 758
    -0x1.00fe99489e458fdeaf9be968cab6da63p0,
    -0x1.921fb8p0
  },
  { // Entry 759
    0x1.433b89f683ed7fa5817d865f4f40b772p0,
    0x1.921fb4p1
  },
  { // Entry 760
    -0x1.433b89f683ed7fa5817d865f4f40b772p0,
    -0x1.921fb4p1
  },
  { // Entry 761
    0x1.433b8a54b916d7eb27cee6293066e9f6p0,
    0x1.921fb6p1
  },
  { // Entry 762
    -0x1.433b8a54b916d7eb27cee6293066e9f6p0,
    -0x1.921fb6p1
  },
  { // Entry 763
    0x1.433b8ab2ee3f565d04344459852fbcf4p0,
    0x1.921fb8p1
  },
  { // Entry 764
    -0x1.433b8ab2ee3f565d04344459852fbcf4p0,
    -0x1.921fb8p1
  },
  { // Entry 765
    0x1.69b8152ba44a49cab381a82d3efbf702p0,
    0x1.921fb4p2
  },
  { // Entry 766
    -0x1.69b8152ba44a49cab381a82d3efbf702p0,
    -0x1.921fb4p2
  },
  { // Entry 767
    0x1.69b8155e3c934e6ce63a344b2956ab50p0,
    0x1.921fb6p2
  },
  { // Entry 768
    -0x1.69b8155e3c934e6ce63a344b2956ab50p0,
    -0x1.921fb6p2
  },
  { // Entry 769
    0x1.69b81590d4dbd567331c0dc4b7fd047bp0,
    0x1.921fb8p2
  },
  { // Entry 770
    -0x1.69b81590d4dbd567331c0dc4b7fd047bp0,
    -0x1.921fb8p2
  },
  { // Entry 771
    0x1.7dcb7c4be6b4be644d7db098c68e6e5ep0,
    0x1.921fb4p3
  },
  { // Entry 772
    -0x1.7dcb7c4be6b4be644d7db098c68e6e5ep0,
    -0x1.921fb4p3
  },
  { // Entry 773
    0x1.7dcb7c65ad1b3ccb7360f1b9b77bc510p0,
    0x1.921fb6p3
  },
  { // Entry 774
    -0x1.7dcb7c65ad1b3ccb7360f1b9b77bc510p0,
    -0x1.921fb6p3
  },
  { // Entry 775
    0x1.7dcb7c7f738179f9a5848bd2f6ea74p0,
    0x1.921fb8p3
  },
  { // Entry 776
    -0x1.7dcb7c7f738179f9a5848bd2f6ea74p0,
    -0x1.921fb8p3
  },
  { // Entry 777
    0x1.87f17cf56d5854572d8ed4b6d7629cb7p0,
    0x1.921fb4p4
  },
  { // Entry 778
    -0x1.87f17cf56d5854572d8ed4b6d7629cb7p0,
    -0x1.921fb4p4
  },
  { // Entry 779
    0x1.87f17d026030951388edff604c5b31acp0,
    0x1.921fb6p4
  },
  { // Entry 780
    -0x1.87f17d026030951388edff604c5b31acp0,
    -0x1.921fb6p4
  },
  { // Entry 781
    0x1.87f17d0f5308b4e40d66884bfda71f16p0,
    0x1.921fb8p4
  },
  { // Entry 782
    -0x1.87f17d0f5308b4e40d66884bfda71f16p0,
    -0x1.921fb8p4
  },
  { // Entry 783
    0x1.8d08152ac2c9f80510b67fe8688fe00bp0,
    0x1.921fb4p5
  },
  { // Entry 784
    -0x1.8d08152ac2c9f80510b67fe8688fe00bp0,
    -0x1.921fb4p5
  },
  { // Entry 785
    0x1.8d0815313e2db1236b7416aaf31784edp0,
    0x1.921fb6p5
  },
  { // Entry 786
    -0x1.8d0815313e2db1236b7416aaf31784edp0,
    -0x1.921fb6p5
  },
  { // Entry 787
    0x1.8d081537b99159c1d87b49089b46259bp0,
    0x1.921fb8p5
  },
  { // Entry 788
    -0x1.8d081537b99159c1d87b49089b46259bp0,
    -0x1.921fb8p5
  },
  { // Entry 789
    0x1.8f93d4b57dde1ae888776df959240a29p0,
    0x1.921fb4p6
  },
  { // Entry 790
    -0x1.8f93d4b57dde1ae888776df959240a29p0,
    -0x1.921fb4p6
  },
  { // Entry 791
    0x1.8f93d4b8bbcf027a20c8f2f1496ed581p0,
    0x1.921fb6p6
  },
  { // Entry 792
    -0x1.8f93d4b8bbcf027a20c8f2f1496ed581p0,
    -0x1.921fb6p6
  },
  { // Entry 793
    0x1.8f93d4bbf9bfe1ca81404ffb114601efp0,
    0x1.921fb8p6
  },
  { // Entry 794
    -0x1.8f93d4bbf9bfe1ca81404ffb114601efp0,
    -0x1.921fb8p6
  },
  { // Entry 795
    0x1.90d9c2ec819f17b4d8062df65c79686ep0,
    0x1.921fb4p7
  },
  { // Entry 796
    -0x1.90d9c2ec819f17b4d8062df65c79686ep0,
    -0x1.921fb4p7
  },
  { // Entry 797
    0x1.90d9c2ee209f6d9d910babe7f62e7a71p0,
    0x1.921fb6p7
  },
  { // Entry 798
    -0x1.90d9c2ee209f6d9d910babe7f62e7a71p0,
    -0x1.921fb6p7
  },
  { // Entry 799
    0x1.90d9c2efbf9fbf6585fe7f879e30cb27p0,
    0x1.921fb8p7
  },
  { // Entry 800
    -0x1.90d9c2efbf9fbf6585fe7f879e30cb27p0,
    -0x1.921fb8p7
  },
  { // Entry 801
    0x1.2b5f4a1f186a4f4cce84633d4e88c6e3p0,
    0x1.2d97c4p1
  },
  { // Entry 802
    -0x1.2b5f4a1f186a4f4cce84633d4e88c6e3p0,
    -0x1.2d97c4p1
  },
  { // Entry 803
    0x1.2b5f4abb6450cfe394b11d0190b012a2p0,
    0x1.2d97c6p1
  },
  { // Entry 804
    -0x1.2b5f4abb6450cfe394b11d0190b012a2p0,
    -0x1.2d97c6p1
  },
  { // Entry 805
    0x1.2b5f4b57b0358ecd5c4ef2cf8eeca8b5p0,
    0x1.2d97c8p1
  },
  { // Entry 806
    -0x1.2b5f4b57b0358ecd5c4ef2cf8eeca8b5p0,
    -0x1.2d97c8p1
  },
  { // Entry 807
    0x1.524a69ac739be8aa44819da2c46ddeffp0,
    0x1.f6a7a0p1
  },
  { // Entry 808
    -0x1.524a69ac739be8aa44819da2c46ddeffp0,
    -0x1.f6a7a0p1
  },
  { // Entry 809
    0x1.524a69eacf4f30dd7930094c2c5422fap0,
    0x1.f6a7a2p1
  },
  { // Entry 810
    -0x1.524a69eacf4f30dd7930094c2c5422fap0,
    -0x1.f6a7a2p1
  },
  { // Entry 811
    0x1.524a6a292b0201c41df76f9856ea793ep0,
    0x1.f6a7a4p1
  },
  { // Entry 812
    -0x1.524a6a292b0201c41df76f9856ea793ep0,
    -0x1.f6a7a4p1
  },
  { // Entry 813
    0x1.5c97d2cf4d47c39e1d3362c5c6cb465ep0,
    0x1.2d97c4p2
  },
  { // Entry 814
    -0x1.5c97d2cf4d47c39e1d3362c5c6cb465ep0,
    -0x1.2d97c4p2
  },
  { // Entry 815
    0x1.5c97d3278d78828714e1db373c01c428p0,
    0x1.2d97c6p2
  },
  { // Entry 816
    -0x1.5c97d3278d78828714e1db373c01c428p0,
    -0x1.2d97c6p2
  },
  { // Entry 817
    0x1.5c97d37fcda822b612cc305acdb3719ap0,
    0x1.2d97c8p2
  },
  { // Entry 818
    -0x1.5c97d37fcda822b612cc305acdb3719ap0,
    -0x1.2d97c8p2
  },
  { // Entry 819
    0x1.64102f6fe89978879ec1eb938127f347p0,
    0x1.5fdbbcp2
  },
  { // Entry 820
    -0x1.64102f6fe89978879ec1eb938127f347p0,
    -0x1.5fdbbcp2
  },
  { // Entry 821
    0x1.64102fb17ee4bd784c0bc3c4b87b12dbp0,
    0x1.5fdbbep2
  },
  { // Entry 822
    -0x1.64102fb17ee4bd784c0bc3c4b87b12dbp0,
    -0x1.5fdbbep2
  },
  { // Entry 823
    0x1.64102ff3152f49a5b25bbbed0e298789p0,
    0x1.5fdbc0p2
  },
  { // Entry 824
    -0x1.64102ff3152f49a5b25bbbed0e298789p0,
    -0x1.5fdbc0p2
  },
  { // Entry 825
    0x1.6e256157f08af28f8fbcb2f100b427b2p0,
    0x1.c463a8p2
  },
  { // Entry 826
    -0x1.6e256157f08af28f8fbcb2f100b427b2p0,
    -0x1.c463a8p2
  },
  { // Entry 827
    0x1.6e2561801fc98949e471b87dd9e165adp0,
    0x1.c463aap2
  },
  { // Entry 828
    -0x1.6e2561801fc98949e471b87dd9e165adp0,
    -0x1.c463aap2
  },
  { // Entry 829
    0x1.6e2561a84f07c6d78f351f778ca48ee1p0,
    0x1.c463acp2
  },
  { // Entry 830
    -0x1.6e2561a84f07c6d78f351f778ca48ee1p0,
    -0x1.c463acp2
  },
  { // Entry 831
    0x1.71b40fe4d6264f6dcb5aa93d81eee334p0,
    0x1.f6a7a0p2
  },
  { // Entry 832
    -0x1.71b40fe4d6264f6dcb5aa93d81eee334p0,
    -0x1.f6a7a0p2
  },
  { // Entry 833
    0x1.71b4100581ff6df4d0e43adc1c6df394p0,
    0x1.f6a7a2p2
  },
  { // Entry 834
    -0x1.71b4100581ff6df4d0e43adc1c6df394p0,
    -0x1.f6a7a2p2
  },
  { // Entry 835
    0x1.71b410262dd84afcf6128b00223864d4p0,
    0x1.f6a7a4p2
  },
  { // Entry 836
    -0x1.71b410262dd84afcf6128b00223864d4p0,
    -0x1.f6a7a4p2
  },
  { // Entry 837
    0x1.749f95c28655e27185bdf7611bf6dabap0,
    0x1.1475cap3
  },
  { // Entry 838
    -0x1.749f95c28655e27185bdf7611bf6dabap0,
    -0x1.1475cap3
  },
  { // Entry 839
    0x1.749f95f8ad42bfc84cd821638d05272ep0,
    0x1.1475ccp3
  },
  { // Entry 840
    -0x1.749f95f8ad42bfc84cd821638d05272ep0,
    -0x1.1475ccp3
  },
  { // Entry 841
    0x1.749f962ed42ed732156103090043fe20p0,
    0x1.1475cep3
  },
  { // Entry 842
    -0x1.749f962ed42ed732156103090043fe20p0,
    -0x1.1475cep3
  },
  { // Entry 843
    0x1.77100a61d11bd3683ef7f13e0e2d3714p0,
    0x1.2d97c4p3
  },
  { // Entry 844
    -0x1.77100a61d11bd3683ef7f13e0e2d3714p0,
    -0x1.2d97c4p3
  },
  { // Entry 845
    0x1.77100a8f6a77d25e60c8ac6b368ced7cp0,
    0x1.2d97c6p3
  },
  { // Entry 846
    -0x1.77100a8f6a77d25e60c8ac6b368ced7cp0,
    -0x1.2d97c6p3
  },
  { // Entry 847
    0x1.77100abd03d3383b200c349a288d0858p0,
    0x1.2d97c8p3
  },
  { // Entry 848
    -0x1.77100abd03d3383b200c349a288d0858p0,
    -0x1.2d97c8p3
  },
  { // Entry 849
    0x1.79216b54e7690f5dc60c9f9ad18c2fe4p0,
    0x1.46b9c0p3
  },
  { // Entry 850
    -0x1.79216b54e7690f5dc60c9f9ad18c2fe4p0,
    -0x1.46b9c0p3
  },
  { // Entry 851
    0x1.79216b7bd2590ebc8160a2e2288b213cp0,
    0x1.46b9c2p3
  },
  { // Entry 852
    -0x1.79216b7bd2590ebc8160a2e2288b213cp0,
    -0x1.46b9c2p3
  },
  { // Entry 853
    0x1.79216ba2bd48954acc47fb24366389dcp0,
    0x1.46b9c4p3
  },
  { // Entry 854
    -0x1.79216ba2bd48954acc47fb24366389dcp0,
    -0x1.46b9c4p3
  },
  { // Entry 855
    0x1.7ae7d7b9fff1b8fc1a190cb09ec19212p0,
    0x1.5fdbbcp3
  },
  { // Entry 856
    -0x1.7ae7d7b9fff1b8fc1a190cb09ec19212p0,
    -0x1.5fdbbcp3
  },
  { // Entry 857
    0x1.7ae7d7db99b1b48f74a47550dd2775fbp0,
    0x1.5fdbbep3
  },
  { // Entry 858
    -0x1.7ae7d7db99b1b48f74a47550dd2775fbp0,
    -0x1.5fdbbep3
  },
  { // Entry 859
    0x1.7ae7d7fd33714f26d256bae7b8da269cp0,
    0x1.5fdbc0p3
  },
  { // Entry 860
    -0x1.7ae7d7fd33714f26d256bae7b8da269cp0,
    -0x1.5fdbc0p3
  },
  { // Entry 861
    0x1.7c72243c821084a80ce5911f6e3dea5dp0,
    0x1.78fdb6p3
  },
  { // Entry 862
    -0x1.7c72243c821084a80ce5911f6e3dea5dp0,
    -0x1.78fdb6p3
  },
  { // Entry 863
    0x1.7c722459cf137ac258c3b7237604e08ep0,
    0x1.78fdb8p3
  },
  { // Entry 864
    -0x1.7c722459cf137ac258c3b7237604e08ep0,
    -0x1.78fdb8p3
  },
  { // Entry 865
    0x1.7c7224771c1621d7d010891cc6cbd91ep0,
    0x1.78fdbap3
  },
  { // Entry 866
    -0x1.7c7224771c1621d7d010891cc6cbd91ep0,
    -0x1.78fdbap3
  },
  { // Entry 867
    0x1.7efc70fef0079d0f48b6d9402b26d905p0,
    0x1.ab41aep3
  },
  { // Entry 868
    -0x1.7efc70fef0079d0f48b6d9402b26d905p0,
    -0x1.ab41aep3
  },
  { // Entry 869
    0x1.7efc7115c92ed7b4199c4707127cb54bp0,
    0x1.ab41b0p3
  },
  { // Entry 870
    -0x1.7efc7115c92ed7b4199c4707127cb54bp0,
    -0x1.ab41b0p3
  },
  { // Entry 871
    0x1.7efc712ca255dbe487b8a2707e7c0319p0,
    0x1.ab41b2p3
  },
  { // Entry 872
    -0x1.7efc712ca255dbe487b8a2707e7c0319p0,
    -0x1.ab41b2p3
  },
  { // Entry 873
    0x1.800bb137f9715ad622aff2aea130dce0p0,
    0x1.c463a8p3
  },
  { // Entry 874
    -0x1.800bb137f9715ad622aff2aea130dce0p0,
    -0x1.c463a8p3
  },
  { // Entry 875
    0x1.800bb14c5de3a50924516807a2acf3fep0,
    0x1.c463aap3
  },
  { // Entry 876
    -0x1.800bb14c5de3a50924516807a2acf3fep0,
    -0x1.c463aap3
  },
  { // Entry 877
    0x1.800bb160c255c14e4e27ff1409d422e3p0,
    0x1.c463acp3
  },
  { // Entry 878
    -0x1.800bb160c255c14e4e27ff1409d422e3p0,
    -0x1.c463acp3
  },
  { // Entry 879
    0x1.80fe86936790bcf875c5fe2fb547d565p0,
    0x1.dd85a4p3
  },
  { // Entry 880
    -0x1.80fe86936790bcf875c5fe2fb547d565p0,
    -0x1.dd85a4p3
  },
  { // Entry 881
    0x1.80fe86a5b758117d0d5619d06ab27318p0,
    0x1.dd85a6p3
  },
  { // Entry 882
    -0x1.80fe86a5b758117d0d5619d06ab27318p0,
    -0x1.dd85a6p3
  },
  { // Entry 883
    0x1.80fe86b8071f3eea18b5b73ff7f2e4a9p0,
    0x1.dd85a8p3
  },
  { // Entry 884
    -0x1.80fe86b8071f3eea18b5b73ff7f2e4a9p0,
    -0x1.dd85a8p3
  },
  { // Entry 885
    0x1.81d92dd9caf1328bc6b375143237cb0fp0,
    0x1.f6a7a0p3
  },
  { // Entry 886
    -0x1.81d92dd9caf1328bc6b375143237cb0fp0,
    -0x1.f6a7a0p3
  },
  { // Entry 887
    0x1.81d92dea5381d18436c91dc15fbc646dp0,
    0x1.f6a7a2p3
  },
  { // Entry 888
    -0x1.81d92dea5381d18436c91dc15fbc646dp0,
    -0x1.f6a7a2p3
  },
  { // Entry 889
    0x1.81d92dfadc124ef0f2477e36e6f68f74p0,
    0x1.f6a7a4p3
  },
  { // Entry 890
    -0x1.81d92dfadc124ef0f2477e36e6f68f74p0,
    -0x1.f6a7a4p3
  },
  { // Entry 891
    0x1.829f168f2426e5aaade6af4c5fde890ap0,
    0x1.07e4ccp4
  },
  { // Entry 892
    -0x1.829f168f2426e5aaade6af4c5fde890ap0,
    -0x1.07e4ccp4
  },
  { // Entry 893
    0x1.829f16ad2528616b825b97261b82b069p0,
    0x1.07e4cep4
  },
  { // Entry 894
    -0x1.829f16ad2528616b825b97261b82b069p0,
    -0x1.07e4cep4
  },
  { // Entry 895
    0x1.829f16cb2629692c853c96842a0be987p0,
    0x1.07e4d0p4
  },
  { // Entry 896
    -0x1.829f16cb2629692c853c96842a0be987p0,
    -0x1.07e4d0p4
  },
  { // Entry 897
    0x1.835311a12459455ac82eb15660927ea8p0,
    0x1.1475cap4
  },
  { // Entry 898
    -0x1.835311a12459455ac82eb15660927ea8p0,
    -0x1.1475cap4
  },
  { // Entry 899
    0x1.835311bc7d3a944a470489a7e4d79c89p0,
    0x1.1475ccp4
  },
  { // Entry 900
    -0x1.835311bc7d3a944a470489a7e4d79c89p0,
    -0x1.1475ccp4
  },
  { // Entry 901
    0x1.835311d7d61b7e454afbda6fc3780f9bp0,
    0x1.1475cep4
  },
  { // Entry 902
    -0x1.835311d7d61b7e454afbda6fc3780f9bp0,
    -0x1.1475cep4
  },
  { // Entry 903
    0x1.83f772fb8c656bf286bfb98e1b6c2297p0,
    0x1.2106c8p4
  },
  { // Entry 904
    -0x1.83f772fb8c656bf286bfb98e1b6c2297p0,
    -0x1.2106c8p4
  },
  { // Entry 905
    0x1.83f77314938eb6f209e9d6f162ceb218p0,
    0x1.2106cap4
  },
  { // Entry 906
    -0x1.83f77314938eb6f209e9d6f162ceb218p0,
    -0x1.2106cap4
  },
  { // Entry 907
    0x1.83f7732d9ab7a98acc60db819db81050p0,
    0x1.2106ccp4
  },
  { // Entry 908
    -0x1.83f7732d9ab7a98acc60db819db81050p0,
    -0x1.2106ccp4
  },
  { // Entry 909
    0x1.848e2bbf112b7c2876657a2a86df9912p0,
    0x1.2d97c4p4
  },
  { // Entry 910
    -0x1.848e2bbf112b7c2876657a2a86df9912p0,
    -0x1.2d97c4p4
  },
  { // Entry 911
    0x1.848e2bd60efe2b9612b5fc806fd418d9p0,
    0x1.2d97c6p4
  },
  { // Entry 912
    -0x1.848e2bd60efe2b9612b5fc806fd418d9p0,
    -0x1.2d97c6p4
  },
  { // Entry 913
    0x1.848e2bed0cd08d2b9a9efc0954153c48p0,
    0x1.2d97c8p4
  },
  { // Entry 914
    -0x1.848e2bed0cd08d2b9a9efc0954153c48p0,
    -0x1.2d97c8p4
  },
  { // Entry 915
    0x1.8518de24fb5e23b2ff0cc417b338f410p0,
    0x1.3a28c2p4
  },
  { // Entry 916
    -0x1.8518de24fb5e23b2ff0cc417b338f410p0,
    -0x1.3a28c2p4
  },
  { // Entry 917
    0x1.8518de3a2cef8f1d8eb840c195f7aec6p0,
    0x1.3a28c4p4
  },
  { // Entry 918
    -0x1.8518de3a2cef8f1d8eb840c195f7aec6p0,
    -0x1.3a28c4p4
  },
  { // Entry 919
    0x1.8518de4f5e80b5a144ccb442286993f2p0,
    0x1.3a28c6p4
  },
  { // Entry 920
    -0x1.8518de4f5e80b5a144ccb442286993f2p0,
    -0x1.3a28c6p4
  },
  { // Entry 921
    0x1.8598ec14f4559fb7ce6f97f8b0ce9772p0,
    0x1.46b9c0p4
  },
  { // Entry 922
    -0x1.8598ec14f4559fb7ce6f97f8b0ce9772p0,
    -0x1.46b9c0p4
  },
  { // Entry 923
    0x1.8598ec288d8e61a24f31637379503fc5p0,
    0x1.46b9c2p4
  },
  { // Entry 924
    -0x1.8598ec288d8e61a24f31637379503fc5p0,
    -0x1.46b9c2p4
  },
  { // Entry 925
    0x1.8598ec3c26c6e645d117b0b4d0b90716p0,
    0x1.46b9c4p4
  },
  { // Entry 926
    -0x1.8598ec3c26c6e645d117b0b4d0b90716p0,
    -0x1.46b9c4p4
  },
  { // Entry 927
    0x1.860f835398d37040ddc2d7017bf92099p0,
    0x1.534abep4
  },
  { // Entry 928
    -0x1.860f835398d37040ddc2d7017bf92099p0,
    -0x1.534abep4
  },
  { // Entry 929
    0x1.860f8365c617d586a14b44930af2704ap0,
    0x1.534ac0p4
  },
  { // Entry 930
    -0x1.860f8365c617d586a14b44930af2704ap0,
    -0x1.534ac0p4
  },
  { // Entry 931
    0x1.860f8377f35c040fc41230db2834a379p0,
    0x1.534ac2p4
  },
  { // Entry 932
    -0x1.860f8377f35c040fc41230db2834a379p0,
    -0x1.534ac2p4
  },
  { // Entry 933
    0x1.867da6b26f9ac2fa4c1d70b7532cb6aep0,
    0x1.5fdbbcp4
  },
  { // Entry 934
    -0x1.867da6b26f9ac2fa4c1d70b7532cb6aep0,
    -0x1.5fdbbcp4
  },
  { // Entry 935
    0x1.867da6c3571aaf0e97b75fd8102e312ap0,
    0x1.5fdbbep4
  },
  { // Entry 936
    -0x1.867da6c3571aaf0e97b75fd8102e312ap0,
    -0x1.5fdbbep4
  },
  { // Entry 937
    0x1.867da6d43e9a6a0ab844221559e0ca4ep0,
    0x1.5fdbc0p4
  },
  { // Entry 938
    -0x1.867da6d43e9a6a0ab844221559e0ca4ep0,
    -0x1.5fdbc0p4
  },
  { // Entry 939
    0x1.86e4356f9805898eff739bee09b0eb2bp0,
    0x1.6c6cbap4
  },
  { // Entry 940
    -0x1.86e4356f9805898eff739bee09b0eb2bp0,
    -0x1.6c6cbap4
  },
  { // Entry 941
    0x1.86e4357f5ac86b81453a4b9f1ab42ac2p0,
    0x1.6c6cbcp4
  },
  { // Entry 942
    -0x1.86e4357f5ac86b81453a4b9f1ab42ac2p0,
    -0x1.6c6cbcp4
  },
  { // Entry 943
    0x1.86e4358f1d8b21400c5273ab23322cc4p0,
    0x1.6c6cbep4
  },
  { // Entry 944
    -0x1.86e4358f1d8b21400c5273ab23322cc4p0,
    -0x1.6c6cbep4
  },
  { // Entry 945
    0x1.8743f10efa639eaaf405e83f84a991bbp0,
    0x1.78fdb6p4
  },
  { // Entry 946
    -0x1.8743f10efa639eaaf405e83f84a991bbp0,
    -0x1.78fdb6p4
  },
  { // Entry 947
    0x1.8743f11db5201e00fba3693129ceaaadp0,
    0x1.78fdb8p4
  },
  { // Entry 948
    -0x1.8743f11db5201e00fba3693129ceaaadp0,
    -0x1.78fdb8p4
  },
  { // Entry 949
    0x1.8743f12c6fdc75672ff29ccd6d6423ccp0,
    0x1.78fdbap4
  },
  { // Entry 950
    -0x1.8743f12c6fdc75672ff29ccd6d6423ccp0,
    -0x1.78fdbap4
  },
  { // Entry 951
    0x1.879d825ab3fe49f711b2fa09df2c5726p0,
    0x1.858eb4p4
  },
  { // Entry 952
    -0x1.879d825ab3fe49f711b2fa09df2c5726p0,
    -0x1.858eb4p4
  },
  { // Entry 953
    0x1.879d82687fc876212b8475e64de596a4p0,
    0x1.858eb6p4
  },
  { // Entry 954
    -0x1.879d82687fc876212b8475e64de596a4p0,
    -0x1.858eb6p4
  },
  { // Entry 955
    0x1.879d82764b927e1728ed144f2db217ebp0,
    0x1.858eb8p4
  },
  { // Entry 956
    -0x1.879d82764b927e1728ed144f2db217ebp0,
    -0x1.858eb8p4
  },
  { // Entry 957
    0x1.921fb54442d18467898cc31701b639a2p0,
    0x1.fffffep62
  },
  { // Entry 958
    -0x1.921fb54442d18467898cc31701b639a2p0,
    -0x1.fffffep62
  },
  { // Entry 959
    0x1.921fb54442d18467898cc51701b839a2p0,
    0x1.p63
  },
  { // Entry 960
    -0x1.921fb54442d18467898cc51701b839a2p0,
    -0x1.p63
  },
  { // Entry 961
    0x1.921fb54442d18467898cc91701b039a2p0,
    0x1.000002p63
  },
  { // Entry 962
    -0x1.921fb54442d18467898cc91701b039a2p0,
    -0x1.000002p63
  },
  { // Entry 963
    0x1.921fb52442d16469896cefc18ce2e42dp0,
    0x1.fffffep26
  },
  { // Entry 964
    -0x1.921fb52442d16469896cefc18ce2e42dp0,
    -0x1.fffffep26
  },
  { // Entry 965
    0x1.921fb52442d18469898cefc1ac62e44cp0,
    0x1.p27
  },
  { // Entry 966
    -0x1.921fb52442d18469898cefc1ac62e44cp0,
    -0x1.p27
  },
  { // Entry 967
    0x1.921fb52442d1c469890cefc2ab62e250p0,
    0x1.000002p27
  },
  { // Entry 968
    -0x1.921fb52442d1c469890cefc2ab62e250p0,
    -0x1.000002p27
  },
  { // Entry 969
    0x1.921fb44442d0846988e21a6c570d8fc4p0,
    0x1.fffffep23
  },
  { // Entry 970
    -0x1.921fb44442d0846988e21a6c570d8fc4p0,
    -0x1.fffffep23
  },
  { // Entry 971
    0x1.921fb44442d1846989e21a6c570d8ec4p0,
    0x1.p24
  },
  { // Entry 972
    -0x1.921fb44442d1846989e21a6c570d8ec4p0,
    -0x1.p24
  },
  { // Entry 973
    0x1.921fb44442d3846985e21a72570d86c4p0,
    0x1.000002p24
  },
  { // Entry 974
    -0x1.921fb44442d3846985e21a72570d86c4p0,
    -0x1.000002p24
  },
  { // Entry 975
    0x1.5368c915ad9354b6c80847a9f514bb75p0,
    0x1.fffffep1
  },
  { // Entry 976
    -0x1.5368c915ad9354b6c80847a9f514bb75p0,
    -0x1.fffffep1
  },
  { // Entry 977
    0x1.5368c951e9cfc9a42e1add5983cfb3a8p0,
    0x1.p2
  },
  { // Entry 978
    -0x1.5368c951e9cfc9a42e1add5983cfb3a8p0,
    -0x1.p2
  },
  { // Entry 979
    0x1.5368c9ca62475f5801ace2839c235895p0,
    0x1.000002p2
  },
  { // Entry 980
    -0x1.5368c9ca62475f5801ace2839c235895p0,
    -0x1.000002p2
  },
  { // Entry 981
    0x1.1b6e18c8557d8e74e5d9704acf91aa45p0,
    0x1.fffffep0
  },
  { // Entry 982
    -0x1.1b6e18c8557d8e74e5d9704acf91aa45p0,
    -0x1.fffffep0
  },
  { // Entry 983
    0x1.1b6e192ebbe446c6d19aa220a39af320p0,
    0x1.p1
  },
  { // Entry 984
    -0x1.1b6e192ebbe446c6d19aa220a39af320p0,
    -0x1.p1
  },
  { // Entry 985
    0x1.1b6e19fb88afcbe58bcd268e23897be3p0,
    0x1.000002p1
  },
  { // Entry 986
    -0x1.1b6e19fb88afcbe58bcd268e23897be3p0,
    -0x1.000002p1
  },
  { // Entry 987
    0x1.921fb44442d1046989621a6c570d8f04p-1,
    0x1.fffffep-1
  },
  { // Entry 988
    -0x1.921fb44442d1046989621a6c570d8f04p-1,
    -0x1.fffffep-1
  },
  { // Entry 989
    0x1.921fb54442d18469898cc51701b839a2p-1,
    0x1.p0
  },
  { // Entry 990
    -0x1.921fb54442d18469898cc51701b839a2p-1,
    -0x1.p0
  },
  { // Entry 991
    0x1.921fb74442cf84698ae21a6c570d8d5ep-1,
    0x1.000002p0
  },
  { // Entry 992
    -0x1.921fb74442cf84698ae21a6c570d8d5ep-1,
    -0x1.000002p0
  },
  { // Entry 993
    0x1.dac66ebc821b0b05c115b007ee262f78p-2,
    0x1.fffffep-2
  },
  { // Entry 994
    -0x1.dac66ebc821b0b05c115b007ee262f78p-2,
    -0x1.fffffep-2
  },
  { // Entry 995
    0x1.dac670561bb4f68adfc88bd978751a06p-2,
    0x1.p-1
  },
  { // Entry 996
    -0x1.dac670561bb4f68adfc88bd978751a06p-2,
    -0x1.p-1
  },
  { // Entry 997
    0x1.dac673894ee6e20ffe552cf613035e41p-2,
    0x1.000002p-1
  },
  { // Entry 998
    -0x1.dac673894ee6e20ffe552cf613035e41p-2,
    -0x1.000002p-1
  },
  { // Entry 999
    0x1.f5b75db0e62bd7f064e3887809ade7efp-3,
    0x1.fffffep-3
  },
  { // Entry 1000
    -0x1.f5b75db0e62bd7f064e3887809ade7efp-3,
    -0x1.fffffep-3
  },
  { // Entry 1001
    0x1.f5b75f92c80dd62adb8f3debef442fcbp-3,
    0x1.p-2
  },
  { // Entry 1002
    -0x1.f5b75f92c80dd62adb8f3debef442fcbp-3,
    -0x1.p-2
  },
  { // Entry 1003
    0x1.f5b763568bd1288c4bd4fecdaee28fb5p-3,
    0x1.000002p-2
  },
  { // Entry 1004
    -0x1.f5b763568bd1288c4bd4fecdaee28fb5p-3,
    -0x1.000002p-2
  },
  { // Entry 1005
    0x1.fd5ba7b2a374dc8497123b64b398aae2p-4,
    0x1.fffffep-4
  },
  { // Entry 1006
    -0x1.fd5ba7b2a374dc8497123b64b398aae2p-4,
    -0x1.fffffep-4
  },
  { // Entry 1007
    0x1.fd5ba9aac2f6dc65912f313e7d111defp-4,
    0x1.p-3
  },
  { // Entry 1008
    -0x1.fd5ba9aac2f6dc65912f313e7d111defp-4,
    -0x1.p-3
  },
  { // Entry 1009
    0x1.fd5bad9b01faad9eb46ef9bda99d4fdap-4,
    0x1.000002p-3
  },
  { // Entry 1010
    -0x1.fd5bad9b01faad9eb46ef9bda99d4fdap-4,
    -0x1.000002p-3
  },
  { // Entry 1011
    0x1.ff55b974cde098738e59c07aa48dd110p-5,
    0x1.fffffep-5
  },
  { // Entry 1012
    -0x1.ff55b974cde098738e59c07aa48dd110p-5,
    -0x1.fffffep-5
  },
  { // Entry 1013
    0x1.ff55bb72cfde9c6d964f25b81c5c1aa2p-5,
    0x1.p-4
  },
  { // Entry 1014
    -0x1.ff55bb72cfde9c6d964f25b81c5c1aa2p-5,
    -0x1.p-4
  },
  { // Entry 1015
    0x1.ff55bf6ed3da98798265cc3f27c896c7p-5,
    0x1.000002p-4
  },
  { // Entry 1016
    -0x1.ff55bf6ed3da98798265cc3f27c896c7p-5,
    -0x1.000002p-4
  },
  { // Entry 1017
    0x1.ffd559bb174252032fa3014c0671336cp-6,
    0x1.fffffep-6
  },
  { // Entry 1018
    -0x1.ffd559bb174252032fa3014c0671336cp-6,
    -0x1.fffffep-6
  },
  { // Entry 1019
    0x1.ffd55bba97624a84ef3aeedbb518c427p-6,
    0x1.p-5
  },
  { // Entry 1020
    -0x1.ffd55bba97624a84ef3aeedbb518c427p-6,
    -0x1.p-5
  },
  { // Entry 1021
    0x1.ffd55fb997a23889edd9fb6b2758a63ep-6,
    0x1.000002p-5
  },
  { // Entry 1022
    -0x1.ffd55fb997a23889edd9fb6b2758a63ep-6,
    -0x1.000002p-5
  },
  { // Entry 1023
    0x1.fff553bbd727ab77d118772cd6b96490p-7,
    0x1.fffffep-7
  },
  { // Entry 1024
    -0x1.fff553bbd727ab77d118772cd6b96490p-7,
    -0x1.fffffep-7
  },
  { // Entry 1025
    0x1.fff555bbb729ab77cf18ac802beec090p-7,
    0x1.p-6
  },
  { // Entry 1026
    -0x1.fff555bbb729ab77cf18ac802beec090p-7,
    -0x1.p-6
  },
  { // Entry 1027
    0x1.fff559bb772daab7e316976eceda5473p-7,
    0x1.000002p-6
  },
  { // Entry 1028
    -0x1.fff559bb772daab7e316976eceda5473p-7,
    -0x1.000002p-6
  },
  { // Entry 1029
    0x1.fffffdf5555575bbbb99b72981620cfcp-15,
    0x1.fffffep-15
  },
  { // Entry 1030
    -0x1.fffffdf5555575bbbb99b72981620cfcp-15,
    -0x1.fffffep-15
  },
  { // Entry 1031
    0x1.fffffff5555555bbbbbbb72972976256p-15,
    0x1.p-14
  },
  { // Entry 1032
    -0x1.fffffff5555555bbbbbbb72972976256p-15,
    -0x1.p-14
  },
  { // Entry 1033
    0x1.000001faaaaa8adddd9fdb949681068fp-14,
    0x1.000002p-14
  },
  { // Entry 1034
    -0x1.000001faaaaa8adddd9fdb949681068fp-14,
    -0x1.000002p-14
  },
  { // Entry 1035
    0x1.fffffdfffffffd55555d55554d5bbbbep-28,
    0x1.fffffep-28
  },
  { // Entry 1036
    -0x1.fffffdfffffffd55555d55554d5bbbbep-28,
    -0x1.fffffep-28
  },
  { // Entry 1037
    0x1.fffffffffffffd5555555555555bbbbbp-28,
    0x1.p-27
  },
  { // Entry 1038
    -0x1.fffffffffffffd5555555555555bbbbbp-28,
    -0x1.p-27
  },
  { // Entry 1039
    0x1.000001fffffffeaaaaa2aaaa9aadddd3p-27,
    0x1.000002p-27
  },
  { // Entry 1040
    -0x1.000001fffffffeaaaaa2aaaa9aadddd3p-27,
    -0x1.000002p-27
  },
  { // Entry 1041
    0x1.fffffdfffffffff555557555553555bbp-31,
    0x1.fffffep-31
  },
  { // Entry 1042
    -0x1.fffffdfffffffff555557555553555bbp-31,
    -0x1.fffffep-31
  },
  { // Entry 1043
    0x1.fffffffffffffff555555555555555bbp-31,
    0x1.p-30
  },
  { // Entry 1044
    -0x1.fffffffffffffff555555555555555bbp-31,
    -0x1.p-30
  },
  { // Entry 1045
    0x1.000001fffffffffaaaaa8aaaaa6aaaddp-30,
    0x1.000002p-30
  },
  { // Entry 1046
    -0x1.000001fffffffffaaaaa8aaaaa6aaaddp-30,
    -0x1.000002p-30
  },
  { // Entry 1047
    -0x1.921fb54442d18469898cc51701b839a1p0,
    -0x1.fffffep127
  },
  { // Entry 1048
    0x1.921fb54442d18469898cc51701b839a1p0,
    0x1.fffffep127
  },
  { // Entry 1049
    0x1.921fb54442d18469898cc51701b839a1p0,
    0x1.fffffep127
  },
  { // Entry 1050
    -0x1.921fb54442d18469898cc51701b839a1p0,
    -0x1.fffffep127
  },
  { // Entry 1051
    0x1.921fb54442d18469898cc51701b839a2p0,
    HUGE_VALF
  },
  { // Entry 1052
    -0x1.921fb54442d18469898cc51701b839a2p0,
    -HUGE_VALF
  },
  { // Entry 1053
    0x1.921fb54442d18469898cc51701b839a1p0,
    0x1.fffffep127
  },
  { // Entry 1054
    -0x1.921fb54442d18469898cc51701b839a1p0,
    -0x1.fffffep127
  },
  { // Entry 1055
    0x1.921fb54442d18469898cc51701b839a1p0,
    0x1.fffffcp127
  },
  { // Entry 1056
    -0x1.921fb54442d18469898cc51701b839a1p0,
    -0x1.fffffcp127
  },
  { // Entry 1057
    0x1.433b8a54b916d7eb27cee6293066e9f6p0,
    0x1.921fb6p1
  },
  { // Entry 1058
    -0x1.433b8a54b916d7eb27cee6293066e9f6p0,
    -0x1.921fb6p1
  },
  { // Entry 1059
    0x1.00fe98b4f50d8b3c36b9e2a180d97eeap0,
    0x1.921fb6p0
  },
  { // Entry 1060
    -0x1.00fe98b4f50d8b3c36b9e2a180d97eeap0,
    -0x1.921fb6p0
  },
  { // Entry 1061
    0x1.921fb74442cf84698ae21a6c570d8d5ep-1,
    0x1.000002p0
  },
  { // Entry 1062
    -0x1.921fb74442cf84698ae21a6c570d8d5ep-1,
    -0x1.000002p0
  },
  { // Entry 1063
    0x1.921fb54442d18469898cc51701b839a2p-1,
    0x1.p0
  },
  { // Entry 1064
    -0x1.921fb54442d18469898cc51701b839a2p-1,
    -0x1.p0
  },
  { // Entry 1065
    0x1.921fb44442d1046989621a6c570d8f04p-1,
    0x1.fffffep-1
  },
  { // Entry 1066
    -0x1.921fb44442d1046989621a6c570d8f04p-1,
    -0x1.fffffep-1
  },
  { // Entry 1067
    0x1.54e04c79ed9a93b01c6a9062dbd8e0ffp-1,
    0x1.921fb6p-1
  },
  { // Entry 1068
    -0x1.54e04c79ed9a93b01c6a9062dbd8e0ffp-1,
    -0x1.921fb6p-1
  },
  { // Entry 1069
    0x1.000001ffffffffffffffffffffffffffp-126,
    0x1.000002p-126
  },
  { // Entry 1070
    -0x1.000001ffffffffffffffffffffffffffp-126,
    -0x1.000002p-126
  },
  { // Entry 1071
    0x1.ffffffffffffffffffffffffffffffffp-127,
    0x1.p-126
  },
  { // Entry 1072
    -0x1.ffffffffffffffffffffffffffffffffp-127,
    -0x1.p-126
  },
  { // Entry 1073
    0x1.fffffbffffffffffffffffffffffffffp-127,
    0x1.fffffcp-127
  },
  { // Entry 1074
    -0x1.fffffbffffffffffffffffffffffffffp-127,
    -0x1.fffffcp-127
  },
  { // Entry 1075
    0x1.fffff7ffffffffffffffffffffffffffp-127,
    0x1.fffff8p-127
  },
  { // Entry 1076
    -0x1.fffff7ffffffffffffffffffffffffffp-127,
    -0x1.fffff8p-127
  },
  { // Entry 1077
    0x1.ffffffffffffffffffffffffffffffffp-149,
    0x1.p-148
  },
  { // Entry 1078
    -0x1.ffffffffffffffffffffffffffffffffp-149,
    -0x1.p-148
  },
  { // Entry 1079
    0.0f,
    0x1.p-149
  },
  { // Entry 1080
    -0.0f,
    -0x1.p-149
  },
  { // Entry 1081
    0.0,
    0.0f
  },
  { // Entry 1082
    -0.0,
    -0.0f
  }
};
