/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

static data_1_1_t<float, float> g_asinf_intel_data[] = {
  { // Entry 0
    -0x1.p-149,
    -0x1.p-149
  },
  { // Entry 1
    0x1.p-149,
    0x1.p-149
  },
  { // Entry 2
    -0x1.0cad8e66f6fb487cf1df9ed091e4a72ep-1,
    -0x1.0083f4p-1
  },
  { // Entry 3
    0x1.0cad8e66f6fb487cf1df9ed091e4a72ep-1,
    0x1.0083f4p-1
  },
  { // Entry 4
    -0x1.103565dad7e2002283a3fac2b1d6311dp-1,
    -0x1.03909cp-1
  },
  { // Entry 5
    0x1.103565dad7e2002283a3fac2b1d6311dp-1,
    0x1.03909cp-1
  },
  { // Entry 6
    -0x1.1c66b9ffd666cc7518f5aeee38193508p-1,
    -0x1.0ep-1
  },
  { // Entry 7
    0x1.1c66b9ffd666cc7518f5aeee38193508p-1,
    0x1.0ep-1
  },
  { // Entry 8
    -0x1.311900012958ac30f09a111b838a00c4p-1,
    -0x1.1f5cp-1
  },
  { // Entry 9
    0x1.311900012958ac30f09a111b838a00c4p-1,
    0x1.1f5cp-1
  },
  { // Entry 10
    -0x1.246f5c0000a72022c39c255ede1512d3p-3,
    -0x1.237138p-3
  },
  { // Entry 11
    0x1.246f5c0000a72022c39c255ede1512d3p-3,
    0x1.237138p-3
  },
  { // Entry 12
    -0x1.3db0900000395b4211afefffc6915c36p-3,
    -0x1.3c6acap-3
  },
  { // Entry 13
    0x1.3db0900000395b4211afefffc6915c36p-3,
    0x1.3c6acap-3
  },
  { // Entry 14
    -0x1.5e2e4b551d68af4d88152d62976726c4p-1,
    -0x1.4382c8p-1
  },
  { // Entry 15
    0x1.5e2e4b551d68af4d88152d62976726c4p-1,
    0x1.4382c8p-1
  },
  { // Entry 16
    -0x1.7be252f6f0a776a93608351ae10eb974p0,
    -0x1.fe11b4p-1
  },
  { // Entry 17
    0x1.7be252f6f0a776a93608351ae10eb974p0,
    0x1.fe11b4p-1
  },
  { // Entry 18
    -0x1.00ab00ffe5d68ab742fd93647ec0a67bp-3,
    -0x1.fffe44p-4
  },
  { // Entry 19
    0x1.00ab00ffe5d68ab742fd93647ec0a67bp-3,
    0x1.fffe44p-4
  },
  { // Entry 20
    -0x1.0c15110930220c79eb624ae419c8836cp-1,
    -0x1.ffffe0p-2
  },
  { // Entry 21
    0x1.0c15110930220c79eb624ae419c8836cp-1,
    0x1.ffffe0p-2
  },
  { // Entry 22
    0x1.p-149,
    0x1.p-149
  },
  { // Entry 23
    -0x1.p-149,
    -0x1.p-149
  },
  { // Entry 24
    0x1.02be9ef183114fc560988306f887ac74p-2,
    0x1.000002p-2
  },
  { // Entry 25
    -0x1.02be9ef183114fc560988306f887ac74p-2,
    -0x1.000002p-2
  },
  { // Entry 26
    0x1.02bea1024da614265a59c002ae0c56a0p-2,
    0x1.000004p-2
  },
  { // Entry 27
    -0x1.02bea1024da614265a59c002ae0c56a0p-2,
    -0x1.000004p-2
  },
  { // Entry 28
    0x1.0c152a7075f75bf85c1ca9191b19a5afp-1,
    0x1.000006p-1
  },
  { // Entry 29
    -0x1.0c152a7075f75bf85c1ca9191b19a5afp-1,
    -0x1.000006p-1
  },
  { // Entry 30
    0x1.0c15315e14c63ae876f9313819157a92p-1,
    0x1.00000cp-1
  },
  { // Entry 31
    -0x1.0c15315e14c63ae876f9313819157a92p-1,
    -0x1.00000cp-1
  },
  { // Entry 32
    0x1.00ac0101ec72f1a878790d17bb281556p-3,
    0x1.000020p-3
  },
  { // Entry 33
    -0x1.00ac0101ec72f1a878790d17bb281556p-3,
    -0x1.000020p-3
  },
  { // Entry 34
    0x1.0c154ac55b88a3af9035a28322fdd9a3p-1,
    0x1.000022p-1
  },
  { // Entry 35
    -0x1.0c154ac55b88a3af9035a28322fdd9a3p-1,
    -0x1.000022p-1
  },
  { // Entry 36
    0x1.02bebffe2c7ea2805320dec66ca7844cp-2,
    0x1.000022p-2
  },
  { // Entry 37
    -0x1.02bebffe2c7ea2805320dec66ca7844cp-2,
    -0x1.000022p-2
  },
  { // Entry 38
    0x1.0c15565164aa3a55958458405a1c1e98p-1,
    0x1.00002cp-1
  },
  { // Entry 39
    -0x1.0c15565164aa3a55958458405a1c1e98p-1,
    -0x1.00002cp-1
  },
  { // Entry 40
    0x1.0c155aefcec270c5a31b3e016614b676p-1,
    0x1.000030p-1
  },
  { // Entry 41
    -0x1.0c155aefcec270c5a31b3e016614b676p-1,
    -0x1.000030p-1
  },
  { // Entry 42
    0x1.0c15667bd819ea5190d64e1eecd9d3ffp-1,
    0x1.00003ap-1
  },
  { // Entry 43
    -0x1.0c15667bd819ea5190d64e1eecd9d3ffp-1,
    -0x1.00003ap-1
  },
  { // Entry 44
    0x1.0c16deeaf496378cb0c17601a82b3ef7p-1,
    0x1.000180p-1
  },
  { // Entry 45
    -0x1.0c16deeaf496378cb0c17601a82b3ef7p-1,
    -0x1.000180p-1
  },
  { // Entry 46
    0x1.0c1772b884fb0853488f82c8eab22f06p-1,
    0x1.0002p-1
  },
  { // Entry 47
    -0x1.0c1772b884fb0853488f82c8eab22f06p-1,
    -0x1.0002p-1
  },
  { // Entry 48
    0x1.0c189a53efac87369bf73699b02aa09ep-1,
    0x1.0003p-1
  },
  { // Entry 49
    -0x1.0c189a53efac87369bf73699b02aa09ep-1,
    -0x1.0003p-1
  },
  { // Entry 50
    0x1.00aefcfffff563634fb095cc9e40dda3p-3,
    0x1.000316p-3
  },
  { // Entry 51
    -0x1.00aefcfffff563634fb095cc9e40dda3p-3,
    -0x1.000316p-3
  },
  { // Entry 52
    0x1.0c190240aa98557da9d4fe206ae66279p-1,
    0x1.00035ap-1
  },
  { // Entry 53
    -0x1.0c190240aa98557da9d4fe206ae66279p-1,
    -0x1.00035ap-1
  },
  { // Entry 54
    0x1.0c19c1efbce926ca14cb3e0b0fcfe46cp-1,
    0x1.0004p-1
  },
  { // Entry 55
    -0x1.0c19c1efbce926ca14cb3e0b0fcfe46cp-1,
    -0x1.0004p-1
  },
  { // Entry 56
    0x1.000b2b01e4072831138943d51020c3f5p-6,
    0x1.000880p-6
  },
  { // Entry 57
    -0x1.000b2b01e4072831138943d51020c3f5p-6,
    -0x1.000880p-6
  },
  { // Entry 58
    0x1.0c30da6ca06846115bb5e8040cd163a5p-1,
    0x1.0018p-1
  },
  { // Entry 59
    -0x1.0c30da6ca06846115bb5e8040cd163a5p-1,
    -0x1.0018p-1
  },
  { // Entry 60
    0x1.0c3578fe7d748ef467902185b57079a1p-1,
    0x1.001cp-1
  },
  { // Entry 61
    -0x1.0c3578fe7d748ef467902185b57079a1p-1,
    -0x1.001cp-1
  },
  { // Entry 62
    0x1.0c3a17968466fa128c82b047d29e1a81p-1,
    0x1.0020p-1
  },
  { // Entry 63
    -0x1.0c3a17968466fa128c82b047d29e1a81p-1,
    -0x1.0020p-1
  },
  { // Entry 64
    0x1.0c3b1a489846ab8835c530f3c925e48dp-1,
    0x1.0020e0p-1
  },
  { // Entry 65
    -0x1.0c3b1a489846ab8835c530f3c925e48dp-1,
    -0x1.0020e0p-1
  },
  { // Entry 66
    0x1.0c3c8bd9c9f36a99f8039f99249719a7p-1,
    0x1.002220p-1
  },
  { // Entry 67
    -0x1.0c3c8bd9c9f36a99f8039f99249719a7p-1,
    -0x1.002220p-1
  },
  { // Entry 68
    0x1.0c3eb634b570d95017c1efd1196f0188p-1,
    0x1.0024p-1
  },
  { // Entry 69
    -0x1.0c3eb634b570d95017c1efd1196f0188p-1,
    -0x1.0024p-1
  },
  { // Entry 70
    0x1.0c502e329b76cbc90d2bc2d8a46fd894p-1,
    0x1.003320p-1
  },
  { // Entry 71
    -0x1.0c502e329b76cbc90d2bc2d8a46fd894p-1,
    -0x1.003320p-1
  },
  { // Entry 72
    0x1.0c7f6563138d8ff3289425afc29cf2e4p-1,
    0x1.005cp-1
  },
  { // Entry 73
    -0x1.0c7f6563138d8ff3289425afc29cf2e4p-1,
    -0x1.005cp-1
  },
  { // Entry 74
    0x1.0c8d4265d9ee207b3dc21f1db76ede7cp-1,
    0x1.0068p-1
  },
  { // Entry 75
    -0x1.0c8d4265d9ee207b3dc21f1db76ede7cp-1,
    -0x1.0068p-1
  },
  { // Entry 76
    0x1.0c91e1732197e2a5d4dca63deb68090ap-1,
    0x1.006cp-1
  },
  { // Entry 77
    -0x1.0c91e1732197e2a5d4dca63deb68090ap-1,
    -0x1.006cp-1
  },
  { // Entry 78
    0x1.035dad0091daa5df1fc0e0e0a9fe4ed4p-2,
    0x1.009ap-2
  },
  { // Entry 79
    -0x1.035dad0091daa5df1fc0e0e0a9fe4ed4p-2,
    -0x1.009ap-2
  },
  { // Entry 80
    0x1.0d403226a827880e2ff8226ddebdcb2bp-1,
    0x1.0102d2p-1
  },
  { // Entry 81
    -0x1.0d403226a827880e2ff8226ddebdcb2bp-1,
    -0x1.0102d2p-1
  },
  { // Entry 82
    0x1.0d9488ef7d93f71e126a87e6a4df2604p-1,
    0x1.014bc0p-1
  },
  { // Entry 83
    -0x1.0d9488ef7d93f71e126a87e6a4df2604p-1,
    -0x1.014bc0p-1
  },
  { // Entry 84
    0x1.0db5367f9e64f3f50a2f70dbcc5b7254p-1,
    0x1.0168p-1
  },
  { // Entry 85
    -0x1.0db5367f9e64f3f50a2f70dbcc5b7254p-1,
    -0x1.0168p-1
  },
  { // Entry 86
    0x1.0de005001105becff3be2f022c424727p-1,
    0x1.018dp-1
  },
  { // Entry 87
    -0x1.0de005001105becff3be2f022c424727p-1,
    -0x1.018dp-1
  },
  { // Entry 88
    0x1.0f8db1c47d54f959ab0145145c67ac7cp-1,
    0x1.03p-1
  },
  { // Entry 89
    -0x1.0f8db1c47d54f959ab0145145c67ac7cp-1,
    -0x1.03p-1
  },
  { // Entry 90
    0x1.17df11023b00b60e566bcc34452d8efcp-1,
    0x1.0a24p-1
  },
  { // Entry 91
    -0x1.17df11023b00b60e566bcc34452d8efcp-1,
    -0x1.0a24p-1
  },
  { // Entry 92
    0x1.188a13003e2d6673f8b1137ddefa7ff6p-1,
    0x1.0ab608p-1
  },
  { // Entry 93
    -0x1.188a13003e2d6673f8b1137ddefa7ff6p-1,
    -0x1.0ab608p-1
  },
  { // Entry 94
    0x1.0c310bfed8146bab3eccd1f36ad598dfp-4,
    0x1.0cp-4
  },
  { // Entry 95
    -0x1.0c310bfed8146bab3eccd1f36ad598dfp-4,
    -0x1.0cp-4
  },
  { // Entry 96
    0x1.1ab071a6a6495483fb202832876267b1p-1,
    0x1.0c8b3ap-1
  },
  { // Entry 97
    -0x1.1ab071a6a6495483fb202832876267b1p-1,
    -0x1.0c8b3ap-1
  },
  { // Entry 98
    0x1.1ae03117af7650c7036eeb7f258539aep-1,
    0x1.0cb3e0p-1
  },
  { // Entry 99
    -0x1.1ae03117af7650c7036eeb7f258539aep-1,
    -0x1.0cb3e0p-1
  },
  { // Entry 100
    0x1.1c66b9ffd666cc7518f5aeee38193508p-1,
    0x1.0ep-1
  },
  { // Entry 101
    -0x1.1c66b9ffd666cc7518f5aeee38193508p-1,
    -0x1.0ep-1
  },
  { // Entry 102
    0x1.0e0321004f7f95de7df856f46276d32cp-6,
    0x1.0ep-6
  },
  { // Entry 103
    -0x1.0e0321004f7f95de7df856f46276d32cp-6,
    -0x1.0ep-6
  },
  { // Entry 104
    0x1.1d19b3000a8c63dbb9cd3aa26cb93af8p-1,
    0x1.0e98p-1
  },
  { // Entry 105
    -0x1.1d19b3000a8c63dbb9cd3aa26cb93af8p-1,
    -0x1.0e98p-1
  },
  { // Entry 106
    0x1.0f37e6ffffffcadf5403653d968a2680p-5,
    0x1.0f2b38p-5
  },
  { // Entry 107
    -0x1.0f37e6ffffffcadf5403653d968a2680p-5,
    -0x1.0f2b38p-5
  },
  { // Entry 108
    0x1.1ecf67bb91057e1a4092f0d0eaea1701p-1,
    0x1.100b32p-1
  },
  { // Entry 109
    -0x1.1ecf67bb91057e1a4092f0d0eaea1701p-1,
    -0x1.100b32p-1
  },
  { // Entry 110
    0x1.1f4b64fffffffa0c91291e1431281f37p-1,
    0x1.107434p-1
  },
  { // Entry 111
    -0x1.1f4b64fffffffa0c91291e1431281f37p-1,
    -0x1.107434p-1
  },
  { // Entry 112
    0x1.1903930006f8309241827585b2c80661p-2,
    0x1.1580p-2
  },
  { // Entry 113
    -0x1.1903930006f8309241827585b2c80661p-2,
    -0x1.1580p-2
  },
  { // Entry 114
    0x1.172493fffee5a2507f132613cadeccccp-5,
    0x1.1716c0p-5
  },
  { // Entry 115
    -0x1.172493fffee5a2507f132613cadeccccp-5,
    -0x1.1716c0p-5
  },
  { // Entry 116
    0x1.1c7d46fd7b1ac4ded1655c5206e6e630p-2,
    0x1.18d8p-2
  },
  { // Entry 117
    -0x1.1c7d46fd7b1ac4ded1655c5206e6e630p-2,
    -0x1.18d8p-2
  },
  { // Entry 118
    0x1.29647a7e646f32008c8601ac04967bfcp-1,
    0x1.18f32ep-1
  },
  { // Entry 119
    -0x1.29647a7e646f32008c8601ac04967bfcp-1,
    -0x1.18f32ep-1
  },
  { // Entry 120
    0x1.311900012958ac30f09a111b838a00c4p-1,
    0x1.1f5cp-1
  },
  { // Entry 121
    -0x1.311900012958ac30f09a111b838a00c4p-1,
    -0x1.1f5cp-1
  },
  { // Entry 122
    0x1.23fee9057a799bd52740b1ae1d1e9685p-2,
    0x1.200ep-2
  },
  { // Entry 123
    -0x1.23fee9057a799bd52740b1ae1d1e9685p-2,
    -0x1.200ep-2
  },
  { // Entry 124
    0x1.3cdf26fdd7f39ef9b6df17e306cf9247p-1,
    0x1.2906fcp-1
  },
  { // Entry 125
    -0x1.3cdf26fdd7f39ef9b6df17e306cf9247p-1,
    -0x1.2906fcp-1
  },
  { // Entry 126
    0x1.45311906dbb495a038edf78f3481fba9p-1,
    0x1.2fc3c2p-1
  },
  { // Entry 127
    -0x1.45311906dbb495a038edf78f3481fba9p-1,
    -0x1.2fc3c2p-1
  },
  { // Entry 128
    0x1.3644eaffff7a7a503708b5792101243fp-2,
    0x1.318b20p-2
  },
  { // Entry 129
    -0x1.3644eaffff7a7a503708b5792101243fp-2,
    -0x1.318b20p-2
  },
  { // Entry 130
    0x1.34360affff7ab0ac1a44f15312908de9p-5,
    0x1.34236ep-5
  },
  { // Entry 131
    -0x1.34360affff7ab0ac1a44f15312908de9p-5,
    -0x1.34236ep-5
  },
  { // Entry 132
    0x1.380134f73a1260de2e6015aa3c882e11p-7,
    0x1.38p-7
  },
  { // Entry 133
    -0x1.380134f73a1260de2e6015aa3c882e11p-7,
    -0x1.38p-7
  },
  { // Entry 134
    0x1.4014d8ffaf8aeb3dbd2dcdaae835ffefp-5,
    0x1.40p-5
  },
  { // Entry 135
    -0x1.4014d8ffaf8aeb3dbd2dcdaae835ffefp-5,
    -0x1.40p-5
  },
  { // Entry 136
    0x1.59ad15042743d036220b033a43e33a33p-1,
    0x1.4001c0p-1
  },
  { // Entry 137
    -0x1.59ad15042743d036220b033a43e33a33p-1,
    -0x1.4001c0p-1
  },
  { // Entry 138
    0x1.5ff1acffefe1ce301daaa4f72cee5d3ap-1,
    0x1.44e026p-1
  },
  { // Entry 139
    -0x1.5ff1acffefe1ce301daaa4f72cee5d3ap-1,
    -0x1.44e026p-1
  },
  { // Entry 140
    0x1.6eafa6f9f2763aaeabf6311f88ed3ce1p-1,
    0x1.502232p-1
  },
  { // Entry 141
    -0x1.6eafa6f9f2763aaeabf6311f88ed3ce1p-1,
    -0x1.502232p-1
  },
  { // Entry 142
    0x1.7423d70007f86d1c5c92cd2399d33f4cp-1,
    0x1.543a76p-1
  },
  { // Entry 143
    -0x1.7423d70007f86d1c5c92cd2399d33f4cp-1,
    -0x1.543a76p-1
  },
  { // Entry 144
    0x1.583dff000083fab9afb8092f68183a9fp-5,
    0x1.582410p-5
  },
  { // Entry 145
    -0x1.583dff000083fab9afb8092f68183a9fp-5,
    -0x1.582410p-5
  },
  { // Entry 146
    0x1.8f10290841d65bfd313e02877a87a22ep-1,
    0x1.67de32p-1
  },
  { // Entry 147
    -0x1.8f10290841d65bfd313e02877a87a22ep-1,
    -0x1.67de32p-1
  },
  { // Entry 148
    0x1.68ab6efc047d3ad046bd8183ec5c4d46p-4,
    0x1.68342ap-4
  },
  { // Entry 149
    -0x1.68ab6efc047d3ad046bd8183ec5c4d46p-4,
    -0x1.68342ap-4
  },
  { // Entry 150
    0x1.958d3affedd648f35110cf87a747e43dp-1,
    0x1.6c7452p-1
  },
  { // Entry 151
    -0x1.958d3affedd648f35110cf87a747e43dp-1,
    -0x1.6c7452p-1
  },
  { // Entry 152
    0x1.980272fff139547fa5ad822694b7159fp-1,
    0x1.6e2d2ep-1
  },
  { // Entry 153
    -0x1.980272fff139547fa5ad822694b7159fp-1,
    -0x1.6e2d2ep-1
  },
  { // Entry 154
    0x1.8101cefb4b74963084b66c2235b48567p-2,
    0x1.77fffep-2
  },
  { // Entry 155
    -0x1.8101cefb4b74963084b66c2235b48567p-2,
    -0x1.77fffep-2
  },
  { // Entry 156
    0x1.800001000001ccccd115f16ac09c2c1dp-10,
    0x1.7ffff8p-10
  },
  { // Entry 157
    -0x1.800001000001ccccd115f16ac09c2c1dp-10,
    -0x1.7ffff8p-10
  },
  { // Entry 158
    0x1.81f272fdf7b31c16d324f90717ad9849p-4,
    0x1.816050p-4
  },
  { // Entry 159
    -0x1.81f272fdf7b31c16d324f90717ad9849p-4,
    -0x1.816050p-4
  },
  { // Entry 160
    0x1.bce4ceffee2656af653f471f22502ccbp-1,
    0x1.86fbe6p-1
  },
  { // Entry 161
    -0x1.bce4ceffee2656af653f471f22502ccbp-1,
    -0x1.86fbe6p-1
  },
  { // Entry 162
    0x1.bd56d0ffebe6415a921b526b10cc09edp-1,
    0x1.874578p-1
  },
  { // Entry 163
    -0x1.bd56d0ffebe6415a921b526b10cc09edp-1,
    -0x1.874578p-1
  },
  { // Entry 164
    0x1.bd866affeb83a8ebf25b7e0c9b453091p-1,
    0x1.87642ap-1
  },
  { // Entry 165
    -0x1.bd866affeb83a8ebf25b7e0c9b453091p-1,
    -0x1.87642ap-1
  },
  { // Entry 166
    0x1.bdeae8ffefe79fe29894af8440b888bdp-1,
    0x1.87a4ecp-1
  },
  { // Entry 167
    -0x1.bdeae8ffefe79fe29894af8440b888bdp-1,
    -0x1.87a4ecp-1
  },
  { // Entry 168
    0x1.c0ffa2ffef29ead18ae6ab673811f725p-1,
    0x1.899f22p-1
  },
  { // Entry 169
    -0x1.c0ffa2ffef29ead18ae6ab673811f725p-1,
    -0x1.899f22p-1
  },
  { // Entry 170
    0x1.c257fb0004ddb2849076737a53acb2a8p-1,
    0x1.8a7afep-1
  },
  { // Entry 171
    -0x1.c257fb0004ddb2849076737a53acb2a8p-1,
    -0x1.8a7afep-1
  },
  { // Entry 172
    0x1.cc9d2b00116cbcf4625a1bbb3b5b4e78p-1,
    0x1.90f29cp-1
  },
  { // Entry 173
    -0x1.cc9d2b00116cbcf4625a1bbb3b5b4e78p-1,
    -0x1.90f29cp-1
  },
  { // Entry 174
    0x1.cdddf100135cb2e8716e639bb3b5249fp-1,
    0x1.91b9cap-1
  },
  { // Entry 175
    -0x1.cdddf100135cb2e8716e639bb3b5249fp-1,
    -0x1.91b9cap-1
  },
  { // Entry 176
    0x1.9dd80f000084e0c3df1946aed6d959bfp-7,
    0x1.9dd53ep-7
  },
  { // Entry 177
    -0x1.9dd80f000084e0c3df1946aed6d959bfp-7,
    -0x1.9dd53ep-7
  },
  { // Entry 178
    0x1.e5e6ecedd795023dfa3c7dc241f10438p-1,
    0x1.a02dccp-1
  },
  { // Entry 179
    -0x1.e5e6ecedd795023dfa3c7dc241f10438p-1,
    -0x1.a02dccp-1
  },
  { // Entry 180
    0x1.aa8363fe050a48c7238e23364d019995p-4,
    0x1.a9be2ep-4
  },
  { // Entry 181
    -0x1.aa8363fe050a48c7238e23364d019995p-4,
    -0x1.a9be2ep-4
  },
  { // Entry 182
    0x1.bf42d6021ad1ba9c3760e8c7cccdb6a5p-2,
    0x1.b12cd0p-2
  },
  { // Entry 183
    -0x1.bf42d6021ad1ba9c3760e8c7cccdb6a5p-2,
    -0x1.b12cd0p-2
  },
  { // Entry 184
    0x1.c43c42fc467765267b2bce544d70b0edp-2,
    0x1.b5ad60p-2
  },
  { // Entry 185
    -0x1.c43c42fc467765267b2bce544d70b0edp-2,
    -0x1.b5ad60p-2
  },
  { // Entry 186
    0x1.1094910e7fcd16c9764b4e1b76b737f6p0,
    0x1.bfd588p-1
  },
  { // Entry 187
    -0x1.1094910e7fcd16c9764b4e1b76b737f6p0,
    -0x1.bfd588p-1
  },
  { // Entry 188
    0x1.10c02f0e93e8632e646d67e9015374c9p0,
    0x1.bfffcap-1
  },
  { // Entry 189
    -0x1.10c02f0e93e8632e646d67e9015374c9p0,
    -0x1.bfffcap-1
  },
  { // Entry 190
    0x1.10c066d3e6931b76a13df3a689971ba5p0,
    0x1.c0p-1
  },
  { // Entry 191
    -0x1.10c066d3e6931b76a13df3a689971ba5p0,
    -0x1.c0p-1
  },
  { // Entry 192
    0x1.c7006b02966adf6a3df6650579596d38p-3,
    0x1.c3448ep-3
  },
  { // Entry 193
    -0x1.c7006b02966adf6a3df6650579596d38p-3,
    -0x1.c3448ep-3
  },
  { // Entry 194
    0x1.cced1cffffffead2e67aff2ed34f68fbp-4,
    0x1.cbf43cp-4
  },
  { // Entry 195
    -0x1.cced1cffffffead2e67aff2ed34f68fbp-4,
    -0x1.cbf43cp-4
  },
  { // Entry 196
    0x1.d194fd0297f56d654d767460f12bbd70p-3,
    0x1.cd95p-3
  },
  { // Entry 197
    -0x1.d194fd0297f56d654d767460f12bbd70p-3,
    -0x1.cd95p-3
  },
  { // Entry 198
    0x1.2d46e9003819962ec438e47416ebe356p0,
    0x1.d8c8c0p-1
  },
  { // Entry 199
    -0x1.2d46e9003819962ec438e47416ebe356p0,
    -0x1.d8c8c0p-1
  },
  { // Entry 200
    0x1.de1b0901f98eac7553f0e8195ad077fcp-3,
    0x1.d9c654p-3
  },
  { // Entry 201
    -0x1.de1b0901f98eac7553f0e8195ad077fcp-3,
    -0x1.d9c654p-3
  },
  { // Entry 202
    0x1.3722d2feb24c7d9ccc847f53a3a4ee80p0,
    0x1.e0p-1
  },
  { // Entry 203
    -0x1.3722d2feb24c7d9ccc847f53a3a4ee80p0,
    -0x1.e0p-1
  },
  { // Entry 204
    0x1.e481c0fce71340393796f56e26562981p-3,
    0x1.e0p-3
  },
  { // Entry 205
    -0x1.e481c0fce71340393796f56e26562981p-3,
    -0x1.e0p-3
  },
  { // Entry 206
    0x1.e2579e00010e16a23389c5d2d04cb016p-6,
    0x1.e245c8p-6
  },
  { // Entry 207
    -0x1.e2579e00010e16a23389c5d2d04cb016p-6,
    -0x1.e245c8p-6
  },
  { // Entry 208
    0x1.ebf1570082616eec6d62ca4bbe98a80ep-3,
    0x1.e739c0p-3
  },
  { // Entry 209
    -0x1.ebf1570082616eec6d62ca4bbe98a80ep-3,
    -0x1.e739c0p-3
  },
  { // Entry 210
    0x1.ec0b2efe45213aa2a5913be53fba2675p-3,
    0x1.e752dap-3
  },
  { // Entry 211
    -0x1.ec0b2efe45213aa2a5913be53fba2675p-3,
    -0x1.e752dap-3
  },
  { // Entry 212
    0x1.ed3b16ffff7cb9709229934808bd086bp-3,
    0x1.e87a02p-3
  },
  { // Entry 213
    -0x1.ed3b16ffff7cb9709229934808bd086bp-3,
    -0x1.e87a02p-3
  },
  { // Entry 214
    0x1.ffeaecffff817ca1af5df7aff71f98c6p-3,
    0x1.fa9a82p-3
  },
  { // Entry 215
    -0x1.ffeaecffff817ca1af5df7aff71f98c6p-3,
    -0x1.fa9a82p-3
  },
  { // Entry 216
    0x1.7d60c2f47c8167d9affdf68d4fdbc5d9p0,
    0x1.fe51d8p-1
  },
  { // Entry 217
    -0x1.7d60c2f47c8167d9affdf68d4fdbc5d9p0,
    -0x1.fe51d8p-1
  },
  { // Entry 218
    0x1.901f34fea94ed8bf7d5ce1e00256bec5p0,
    0x1.fffbfep-1
  },
  { // Entry 219
    -0x1.901f34fea94ed8bf7d5ce1e00256bec5p0,
    -0x1.fffbfep-1
  },
  { // Entry 220
    0x1.00ab7efcdc7e3da7637e617c6307c133p-3,
    0x1.ffff3ep-4
  },
  { // Entry 221
    -0x1.00ab7efcdc7e3da7637e617c6307c133p-3,
    -0x1.ffff3ep-4
  },
  { // Entry 222
    0x1.0c15110930220c79eb624ae419c8836cp-1,
    0x1.ffffe0p-2
  },
  { // Entry 223
    -0x1.0c15110930220c79eb624ae419c8836cp-1,
    -0x1.ffffe0p-2
  },
  { // Entry 224
    0x1.0c152382d73658465bb32e0f567ad116p-1,
    0x1.p-1
  },
  { // Entry 225
    -0x1.0c152382d73658465bb32e0f567ad116p-1,
    -0x1.p-1
  },
  { // Entry 226
    0x1.0c152382d73658465bb32e0f567ad116p-1,
    0x1.p-1
  },
  { // Entry 227
    -0x1.0c152382d73658465bb32e0f567ad116p-1,
    -0x1.p-1
  },
  { // Entry 228
    0x1.4a1ce5633729b4831c0f2de50b199161p-1,
    0x1.33b646p-1
  },
  { // Entry 229
    -0x1.4a1ce5633729b4831c0f2de50b199161p-1,
    -0x1.33b646p-1
  },
  { // Entry 230
    0x1.921fb4b1402384698984b09966f96de6p-1,
    0x1.6a09e6p-1
  },
  { // Entry 231
    -0x1.921fb4b1402384698984b09966f96de6p-1,
    -0x1.6a09e6p-1
  },
  { // Entry 232
    0x1.921fb4b1402384698984b09966f96de6p-1,
    0x1.6a09e6p-1
  },
  { // Entry 233
    -0x1.921fb4b1402384698984b09966f96de6p-1,
    -0x1.6a09e6p-1
  },
  { // Entry 234
    -0x1.b235315c680dc081583db360d5e1fa18p-1,
    -0x1.80p-1
  },
  { // Entry 235
    0x1.b235315c680dc081583db360d5e1fa18p-1,
    0x1.80p-1
  },
  { // Entry 236
    0x1.0c1522fd526bed5a0f7cb328ba5c3991p0,
    0x1.bb67aep-1
  },
  { // Entry 237
    -0x1.0c1522fd526bed5a0f7cb328ba5c3991p0,
    -0x1.bb67aep-1
  },
  { // Entry 238
    0x1.0c1522fd526bed5a0f7cb328ba5c3991p0,
    0x1.bb67aep-1
  },
  { // Entry 239
    -0x1.0c1522fd526bed5a0f7cb328ba5c3991p0,
    -0x1.bb67aep-1
  },
  { // Entry 240
    0x1.9080f0a242e636c8b158046e622390bep0,
    0x1.fffd60p-1
  },
  { // Entry 241
    -0x1.9080f0a242e636c8b158046e622390bep0,
    -0x1.fffd60p-1
  },
  { // Entry 242
    0x1.p-82,
    0x1.p-82
  },
  { // Entry 243
    -0x1.p-82,
    -0x1.p-82
  },
  { // Entry 244
    0x1.0000000000000000000000000000000ap-61,
    0x1.p-61
  },
  { // Entry 245
    -0x1.0000000000000000000000000000000ap-61,
    -0x1.p-61
  },
  { // Entry 246
    0x1.0000000000000000000002aaaaaaaaaap-42,
    0x1.p-42
  },
  { // Entry 247
    -0x1.0000000000000000000002aaaaaaaaaap-42,
    -0x1.p-42
  },
  { // Entry 248
    0x1.000000000002aaaaaaaaaabdddddddddp-22,
    0x1.p-22
  },
  { // Entry 249
    -0x1.000000000002aaaaaaaaaabdddddddddp-22,
    -0x1.p-22
  },
  { // Entry 250
    0x1.6a0a022b840dccf66e0b6ec9289f36b5p-9,
    0x1.6a09e4p-9
  },
  { // Entry 251
    -0x1.6a0a022b840dccf66e0b6ec9289f36b5p-9,
    -0x1.6a09e4p-9
  },
  { // Entry 252
    0x1.6a0a042b848dcd256f98664210471010p-9,
    0x1.6a09e6p-9
  },
  { // Entry 253
    -0x1.6a0a042b848dcd256f98664210471010p-9,
    -0x1.6a09e6p-9
  },
  { // Entry 254
    0x1.6a0a062b850dcd55db3053430d8801dep-9,
    0x1.6a09e8p-9
  },
  { // Entry 255
    -0x1.6a0a062b850dcd55db3053430d8801dep-9,
    -0x1.6a09e8p-9
  },
  { // Entry 256
    0x1.6a0a5cae61ad17ce4db740441bff4264p-8,
    0x1.6a09e4p-8
  },
  { // Entry 257
    -0x1.6a0a5cae61ad17ce4db740441bff4264p-8,
    -0x1.6a09e4p-8
  },
  { // Entry 258
    0x1.6a0a5eae63ad1aca589233f046ef6f98p-8,
    0x1.6a09e6p-8
  },
  { // Entry 259
    -0x1.6a0a5eae63ad1aca589233f046ef6f98p-8,
    -0x1.6a09e6p-8
  },
  { // Entry 260
    0x1.6a0a60ae65ad1dcc0ba5b83d9dac8608p-8,
    0x1.6a09e8p-8
  },
  { // Entry 261
    -0x1.6a0a60ae65ad1dcc0ba5b83d9dac8608p-8,
    -0x1.6a09e8p-8
  },
  { // Entry 262
    0x1.6a0bc6be9e29599e77d42647891c84e9p-7,
    0x1.6a09e4p-7
  },
  { // Entry 263
    -0x1.6a0bc6be9e29599e77d42647891c84e9p-7,
    -0x1.6a09e4p-7
  },
  { // Entry 264
    0x1.6a0bc8bea629898fceb95fb04958a217p-7,
    0x1.6a09e6p-7
  },
  { // Entry 265
    -0x1.6a0bc8bea629898fceb95fb04958a217p-7,
    -0x1.6a09e6p-7
  },
  { // Entry 266
    0x1.6a0bcabeae29b997c74c8b209ada2625p-7,
    0x1.6a09e8p-7
  },
  { // Entry 267
    -0x1.6a0bcabeae29b997c74c8b209ada2625p-7,
    -0x1.6a09e8p-7
  },
  { // Entry 268
    0x1.6a116f4bf5a44da64d89fa35a6ebac04p-6,
    0x1.6a09e4p-6
  },
  { // Entry 269
    -0x1.6a116f4bf5a44da64d89fa35a6ebac04p-6,
    -0x1.6a09e4p-6
  },
  { // Entry 270
    0x1.6a11714c15a74db6a8c862c053ff5c47p-6,
    0x1.6a09e6p-6
  },
  { // Entry 271
    -0x1.6a11714c15a74db6a8c862c053ff5c47p-6,
    -0x1.6a09e6p-6
  },
  { // Entry 272
    0x1.6a11734c35aa4e21977b693edb0fbfedp-6,
    0x1.6a09e8p-6
  },
  { // Entry 273
    -0x1.6a11734c35aa4e21977b693edb0fbfedp-6,
    -0x1.6a09e8p-6
  },
  { // Entry 274
    0x1.6a28164912c9ea8249262954f1ae1a22p-5,
    0x1.6a09e4p-5
  },
  { // Entry 275
    -0x1.6a28164912c9ea8249262954f1ae1a22p-5,
    -0x1.6a09e4p-5
  },
  { // Entry 276
    0x1.6a28184992f9fd8bc772026d91605dcap-5,
    0x1.6a09e6p-5
  },
  { // Entry 277
    -0x1.6a28184992f9fd8bc772026d91605dcap-5,
    -0x1.6a09e6p-5
  },
  { // Entry 278
    0x1.6a281a4a132a12005fd55f43d2bf81a6p-5,
    0x1.6a09e8p-5
  },
  { // Entry 279
    -0x1.6a281a4a132a12005fd55f43d2bf81a6p-5,
    -0x1.6a09e8p-5
  },
  { // Entry 280
    0x1.6a82ff139c02609620ef4694ee627b57p-4,
    0x1.6a09e4p-4
  },
  { // Entry 281
    -0x1.6a82ff139c02609620ef4694ee627b57p-4,
    -0x1.6a09e4p-4
  },
  { // Entry 282
    0x1.6a8301159f07655fd879480b5cbcf5cbp-4,
    0x1.6a09e6p-4
  },
  { // Entry 283
    -0x1.6a8301159f07655fd879480b5cbcf5cbp-4,
    -0x1.6a09e6p-4
  },
  { // Entry 284
    0x1.6a830317a20c6fe2dae30fe5babe63f8p-4,
    0x1.6a09e8p-4
  },
  { // Entry 285
    -0x1.6a830317a20c6fe2dae30fe5babe63f8p-4,
    -0x1.6a09e8p-4
  },
  { // Entry 286
    0x1.6bf386a4733dc9584317633d590964f4p-3,
    0x1.6a09e4p-3
  },
  { // Entry 287
    -0x1.6bf386a4733dc9584317633d590964f4p-3,
    -0x1.6a09e4p-3
  },
  { // Entry 288
    0x1.6bf388aca486b9850c50cf9f457667f2p-3,
    0x1.6a09e6p-3
  },
  { // Entry 289
    -0x1.6bf388aca486b9850c50cf9f457667f2p-3,
    -0x1.6a09e6p-3
  },
  { // Entry 290
    0x1.6bf38ab4d5cfc16cfd39ac77e07b6048p-3,
    0x1.6a09e8p-3
  },
  { // Entry 291
    -0x1.6bf38ab4d5cfc16cfd39ac77e07b6048p-3,
    -0x1.6a09e8p-3
  },
  { // Entry 292
    0x1.720a3699a2940f93106e8a7ed729b32ap-2,
    0x1.6a09e4p-2
  },
  { // Entry 293
    -0x1.720a3699a2940f93106e8a7ed729b32ap-2,
    -0x1.6a09e4p-2
  },
  { // Entry 294
    0x1.720a38bcfc706dd98b8488a3c1523d31p-2,
    0x1.6a09e6p-2
  },
  { // Entry 295
    -0x1.720a38bcfc706dd98b8488a3c1523d31p-2,
    -0x1.6a09e6p-2
  },
  { // Entry 296
    0x1.720a3ae0564d3ab4ea8b987564d202e2p-2,
    0x1.6a09e8p-2
  },
  { // Entry 297
    -0x1.720a3ae0564d3ab4ea8b987564d202e2p-2,
    -0x1.6a09e8p-2
  },
  { // Entry 298
    0x1.bb67e36d07936cca0afecdde8822ac92p-9,
    0x1.bb67acp-9
  },
  { // Entry 299
    -0x1.bb67e36d07936cca0afecdde8822ac92p-9,
    -0x1.bb67acp-9
  },
  { // Entry 300
    0x1.bb67e56d08536d34b9eb8cded8ea25b3p-9,
    0x1.bb67aep-9
  },
  { // Entry 301
    -0x1.bb67e56d08536d34b9eb8cded8ea25b3p-9,
    -0x1.bb67aep-9
  },
  { // Entry 302
    0x1.bb67e76d09136da12441ecb59fee2493p-9,
    0x1.bb67b0p-9
  },
  { // Entry 303
    -0x1.bb67e76d09136da12441ecb59fee2493p-9,
    -0x1.bb67b0p-9
  },
  { // Entry 304
    0x1.bb6889b4fec8ebcca61c46f455ae5d4fp-8,
    0x1.bb67acp-8
  },
  { // Entry 305
    -0x1.bb6889b4fec8ebcca61c46f455ae5d4fp-8,
    -0x1.bb67acp-8
  },
  { // Entry 306
    0x1.bb688bb501c8f287718fa43e6142902dp-8,
    0x1.bb67aep-8
  },
  { // Entry 307
    -0x1.bb688bb501c8f287718fa43e6142902dp-8,
    -0x1.bb67aep-8
  },
  { // Entry 308
    0x1.bb688db504c8f9492ac0e747817f22a8p-8,
    0x1.bb67b0p-8
  },
  { // Entry 309
    -0x1.bb688db504c8f9492ac0e747817f22a8p-8,
    -0x1.bb67b0p-8
  },
  { // Entry 310
    0x1.bb6b22e203353028e079513a11cbbab3p-7,
    0x1.bb67acp-7
  },
  { // Entry 311
    -0x1.bb6b22e203353028e079513a11cbbab3p-7,
    -0x1.bb67acp-7
  },
  { // Entry 312
    0x1.bb6b24e20f359c1801d5ae434ae75b2dp-7,
    0x1.bb67aep-7
  },
  { // Entry 313
    -0x1.bb6b24e20f359c1801d5ae434ae75b2dp-7,
    -0x1.bb67aep-7
  },
  { // Entry 314
    0x1.bb6b26e21b360822db9fdd2b265541b5p-7,
    0x1.bb67b0p-7
  },
  { // Entry 315
    -0x1.bb6b26e21b360822db9fdd2b265541b5p-7,
    -0x1.bb67b0p-7
  },
  { // Entry 316
    0x1.bb758868a56d6f7d82a704d6da78e2fdp-6,
    0x1.bb67acp-6
  },
  { // Entry 317
    -0x1.bb758868a56d6f7d82a704d6da78e2fdp-6,
    -0x1.bb67acp-6
  },
  { // Entry 318
    0x1.bb758a68d574303741eb85efe34dac9ap-6,
    0x1.bb67aep-6
  },
  { // Entry 319
    -0x1.bb758a68d574303741eb85efe34dac9ap-6,
    -0x1.bb67aep-6
  },
  { // Entry 320
    0x1.bb758c69057af15ffa5021690b86d6e5p-6,
    0x1.bb67b0p-6
  },
  { // Entry 321
    -0x1.bb758c69057af15ffa5021690b86d6e5p-6,
    -0x1.bb67b0p-6
  },
  { // Entry 322
    0x1.bb9f2bb2025df5b5a01f890e267acbf6p-5,
    0x1.bb67acp-5
  },
  { // Entry 323
    -0x1.bb9f2bb2025df5b5a01f890e267acbf6p-5,
    -0x1.bb67acp-5
  },
  { // Entry 324
    0x1.bb9f2db2c2ca380f37f00e10c34f3f4ep-5,
    0x1.bb67aep-5
  },
  { // Entry 325
    -0x1.bb9f2db2c2ca380f37f00e10c34f3f4ep-5,
    -0x1.bb67aep-5
  },
  { // Entry 326
    0x1.bb9f2fb383367c262c18778b11ce72cap-5,
    0x1.bb67b0p-5
  },
  { // Entry 327
    -0x1.bb9f2fb383367c262c18778b11ce72cap-5,
    -0x1.bb67b0p-5
  },
  { // Entry 328
    0x1.bc468d3a974cd6c6f353f238e6ee9635p-4,
    0x1.bb67acp-4
  },
  { // Entry 329
    -0x1.bc468d3a974cd6c6f353f238e6ee9635p-4,
    -0x1.bb67acp-4
  },
  { // Entry 330
    0x1.bc468f3d9e1dde2e7296f0680c8b5cf1p-4,
    0x1.bb67aep-4
  },
  { // Entry 331
    -0x1.bc468f3d9e1dde2e7296f0680c8b5cf1p-4,
    -0x1.bb67aep-4
  },
  { // Entry 332
    0x1.bc469140a4eeeca3346497225181070ep-4,
    0x1.bb67b0p-4
  },
  { // Entry 333
    -0x1.bc469140a4eeeca3346497225181070ep-4,
    -0x1.bb67b0p-4
  },
  { // Entry 334
    0x1.bef1ba1b54f2e517608d497eda81f13ep-3,
    0x1.bb67acp-3
  },
  { // Entry 335
    -0x1.bef1ba1b54f2e517608d497eda81f13ep-3,
    -0x1.bb67acp-3
  },
  { // Entry 336
    0x1.bef1bc27c5590e551667836f44b8240bp-3,
    0x1.bb67aep-3
  },
  { // Entry 337
    -0x1.bef1bc27c5590e551667836f44b8240bp-3,
    -0x1.bb67aep-3
  },
  { // Entry 338
    0x1.bef1be3435bf555b062c6b933968f858p-3,
    0x1.bb67b0p-3
  },
  { // Entry 339
    -0x1.bef1be3435bf555b062c6b933968f858p-3,
    -0x1.bb67b0p-3
  },
  { // Entry 340
    0x1.ca94909f751f880a004b5b2d1358c7d8p-2,
    0x1.bb67acp-2
  },
  { // Entry 341
    -0x1.ca94909f751f880a004b5b2d1358c7d8p-2,
    -0x1.bb67acp-2
  },
  { // Entry 342
    0x1.ca9492d778731c60ad6f2198bec11118p-2,
    0x1.bb67aep-2
  },
  { // Entry 343
    -0x1.ca9492d778731c60ad6f2198bec11118p-2,
    -0x1.bb67aep-2
  },
  { // Entry 344
    0x1.ca94950f7bc7481303f6206eb55e6063p-2,
    0x1.bb67b0p-2
  },
  { // Entry 345
    -0x1.ca94950f7bc7481303f6206eb55e6063p-2,
    -0x1.bb67b0p-2
  },
  { // Entry 346
    0x1.fffff8p-128,
    0x1.fffff8p-128
  },
  { // Entry 347
    -0x1.fffff8p-128,
    -0x1.fffff8p-128
  },
  { // Entry 348
    0x1.p-127,
    0x1.p-127
  },
  { // Entry 349
    -0x1.p-127,
    -0x1.p-127
  },
  { // Entry 350
    0x1.000004p-127,
    0x1.000004p-127
  },
  { // Entry 351
    -0x1.000004p-127,
    -0x1.000004p-127
  },
  { // Entry 352
    0x1.fffffcp-127,
    0x1.fffffcp-127
  },
  { // Entry 353
    -0x1.fffffcp-127,
    -0x1.fffffcp-127
  },
  { // Entry 354
    0x1.p-126,
    0x1.p-126
  },
  { // Entry 355
    -0x1.p-126,
    -0x1.p-126
  },
  { // Entry 356
    0x1.000002p-126,
    0x1.000002p-126
  },
  { // Entry 357
    -0x1.000002p-126,
    -0x1.000002p-126
  },
  { // Entry 358
    -0x1.000002p-126,
    -0x1.000002p-126
  },
  { // Entry 359
    0x1.000002p-126,
    0x1.000002p-126
  },
  { // Entry 360
    -0x1.p-126,
    -0x1.p-126
  },
  { // Entry 361
    0x1.p-126,
    0x1.p-126
  },
  { // Entry 362
    -0x1.fffffcp-127,
    -0x1.fffffcp-127
  },
  { // Entry 363
    0x1.fffffcp-127,
    0x1.fffffcp-127
  },
  { // Entry 364
    -0x1.p-149,
    -0x1.p-149
  },
  { // Entry 365
    0x1.p-149,
    0x1.p-149
  },
  { // Entry 366
    0.0,
    0.0
  },
  { // Entry 367
    0x1.p-149,
    0x1.p-149
  },
  { // Entry 368
    -0x1.p-149,
    -0x1.p-149
  },
  { // Entry 369
    0x1.fffffcp-127,
    0x1.fffffcp-127
  },
  { // Entry 370
    -0x1.fffffcp-127,
    -0x1.fffffcp-127
  },
  { // Entry 371
    0x1.p-126,
    0x1.p-126
  },
  { // Entry 372
    -0x1.p-126,
    -0x1.p-126
  },
  { // Entry 373
    0x1.000002p-126,
    0x1.000002p-126
  },
  { // Entry 374
    -0x1.000002p-126,
    -0x1.000002p-126
  },
  { // Entry 375
    0x1.fffffe0000000005555545555565557bp-31,
    0x1.fffffep-31
  },
  { // Entry 376
    -0x1.fffffe0000000005555545555565557bp-31,
    -0x1.fffffep-31
  },
  { // Entry 377
    0x1.0000000000000002aaaaaaaaaaaaaabdp-30,
    0x1.p-30
  },
  { // Entry 378
    -0x1.0000000000000002aaaaaaaaaaaaaabdp-30,
    -0x1.p-30
  },
  { // Entry 379
    0x1.0000020000000002aaaabaaaaacaaabdp-30,
    0x1.000002p-30
  },
  { // Entry 380
    -0x1.0000020000000002aaaabaaaaacaaabdp-30,
    -0x1.000002p-30
  },
  { // Entry 381
    0x1.fffffe0000000155555155555957bbbap-28,
    0x1.fffffep-28
  },
  { // Entry 382
    -0x1.fffffe0000000155555155555957bbbap-28,
    -0x1.fffffep-28
  },
  { // Entry 383
    0x1.00000000000000aaaaaaaaaaaaabddddp-27,
    0x1.p-27
  },
  { // Entry 384
    -0x1.00000000000000aaaaaaaaaaaaabddddp-27,
    -0x1.p-27
  },
  { // Entry 385
    0x1.00000200000000aaaaaeaaaab2abdde3p-27,
    0x1.000002p-27
  },
  { // Entry 386
    -0x1.00000200000000aaaaaeaaaab2abdde3p-27,
    -0x1.000002p-27
  },
  { // Entry 387
    0x1.fffffe00000015555515555597bbbb9ap-26,
    0x1.fffffep-26
  },
  { // Entry 388
    -0x1.fffffe00000015555515555597bbbb9ap-26,
    -0x1.fffffep-26
  },
  { // Entry 389
    0x1.0000000000000aaaaaaaaaaaabddddddp-25,
    0x1.p-25
  },
  { // Entry 390
    -0x1.0000000000000aaaaaaaaaaaabddddddp-25,
    -0x1.p-25
  },
  { // Entry 391
    0x1.0000020000000aaaaaeaaaab2bddde3fp-25,
    0x1.000002p-25
  },
  { // Entry 392
    -0x1.0000020000000aaaaaeaaaab2bddde3fp-25,
    -0x1.000002p-25
  },
  { // Entry 393
    0x1.fffffe055555457bbbcafd296eb7e3aap-15,
    0x1.fffffep-15
  },
  { // Entry 394
    -0x1.fffffe055555457bbbcafd296eb7e3aap-15,
    -0x1.fffffep-15
  },
  { // Entry 395
    0x1.00000002aaaaaabdddddde94b94b9c80p-14,
    0x1.p-14
  },
  { // Entry 396
    -0x1.00000002aaaaaabdddddde94b94b9c80p-14,
    -0x1.p-14
  },
  { // Entry 397
    0x1.00000202aaaababdddfe9e94d1aaf1dbp-14,
    0x1.000002p-14
  },
  { // Entry 398
    -0x1.00000202aaaababdddfe9e94d1aaf1dbp-14,
    -0x1.000002p-14
  },
  { // Entry 399
    0x1.0002a9bdd69461160d4c75451704a3b7p-6,
    0x1.fffffep-7
  },
  { // Entry 400
    -0x1.0002a9bdd69461160d4c75451704a3b7p-6,
    -0x1.fffffep-7
  },
  { // Entry 401
    0x1.0002aabdde94c1130cd26cdfa377f967p-6,
    0x1.p-6
  },
  { // Entry 402
    -0x1.0002aabdde94c1130cd26cdfa377f967p-6,
    -0x1.p-6
  },
  { // Entry 403
    0x1.0002acbdee95813d105ec61fcd6ae2fap-6,
    0x1.000002p-6
  },
  { // Entry 404
    -0x1.0002acbdee95813d105ec61fcd6ae2fap-6,
    -0x1.000002p-6
  },
  { // Entry 405
    0x1.000aaaddeb9680b69f39448305c87741p-5,
    0x1.fffffep-6
  },
  { // Entry 406
    -0x1.000aaaddeb9680b69f39448305c87741p-5,
    -0x1.fffffep-6
  },
  { // Entry 407
    0x1.000aabde0b9c81d6d94551be3e924e2ap-5,
    0x1.p-5
  },
  { // Entry 408
    -0x1.000aabde0b9c81d6d94551be3e924e2ap-5,
    -0x1.p-5
  },
  { // Entry 409
    0x1.000aadde4ba884d79574330eaeb7d132p-5,
    0x1.000002p-5
  },
  { // Entry 410
    -0x1.000aadde4ba884d79574330eaeb7d132p-5,
    -0x1.000002p-5
  },
  { // Entry 411
    0x1.002abce8d301449b3a6e1375645eb853p-4,
    0x1.fffffep-5
  },
  { // Entry 412
    -0x1.002abce8d301449b3a6e1375645eb853p-4,
    -0x1.fffffep-5
  },
  { // Entry 413
    0x1.002abde953619460b8b71b77bb495f57p-4,
    0x1.p-4
  },
  { // Entry 414
    -0x1.002abde953619460b8b71b77bb495f57p-4,
    -0x1.p-4
  },
  { // Entry 415
    0x1.002abfea542236f03af0c770006184e0p-4,
    0x1.000002p-4
  },
  { // Entry 416
    -0x1.002abfea542236f03af0c770006184e0p-4,
    -0x1.000002p-4
  },
  { // Entry 417
    0x1.00abdfbf23cd9bcb0908b67c29bd1d84p-3,
    0x1.fffffep-4
  },
  { // Entry 418
    -0x1.00abdfbf23cd9bcb0908b67c29bd1d84p-3,
    -0x1.fffffep-4
  },
  { // Entry 419
    0x1.00abe0c129e1e0be7587724ea14e03b1p-3,
    0x1.p-3
  },
  { // Entry 420
    -0x1.00abe0c129e1e0be7587724ea14e03b1p-3,
    -0x1.p-3
  },
  { // Entry 421
    0x1.00abe2c5360a76eebd374087e13d0778p-3,
    0x1.000002p-3
  },
  { // Entry 422
    -0x1.00abe2c5360a76eebd374087e13d0778p-3,
    -0x1.000002p-3
  },
  { // Entry 423
    0x1.02be9bd85332ad669015b48f1281cd8ep-2,
    0x1.fffffep-3
  },
  { // Entry 424
    -0x1.02be9bd85332ad669015b48f1281cd8ep-2,
    -0x1.fffffep-3
  },
  { // Entry 425
    0x1.02be9ce0b87cd1e5d09da2e0f0423bfap-2,
    0x1.p-2
  },
  { // Entry 426
    -0x1.02be9ce0b87cd1e5d09da2e0f0423bfap-2,
    -0x1.p-2
  },
  { // Entry 427
    0x1.02be9ef183114fc560988306f887ac74p-2,
    0x1.000002p-2
  },
  { // Entry 428
    -0x1.02be9ef183114fc560988306f887ac74p-2,
    -0x1.000002p-2
  },
  { // Entry 429
    0x1.0c15225b3cc2308792870438ebfd5814p-1,
    0x1.fffffep-2
  },
  { // Entry 430
    -0x1.0c15225b3cc2308792870438ebfd5814p-1,
    -0x1.fffffep-2
  },
  { // Entry 431
    0x1.0c152382d73658465bb32e0f567ad116p-1,
    0x1.p-1
  },
  { // Entry 432
    -0x1.0c152382d73658465bb32e0f567ad116p-1,
    -0x1.p-1
  },
  { // Entry 433
    0x1.0c1525d20c1fcf5e632996922f28dbf4p-1,
    0x1.000002p-1
  },
  { // Entry 434
    -0x1.0c1525d20c1fcf5e632996922f28dbf4p-1,
    -0x1.000002p-1
  },
  { // Entry 435
    0x1.920914a5da6f90beac755cf81add3707p0,
    0x1.fffffep-1
  },
  { // Entry 436
    -0x1.920914a5da6f90beac755cf81add3707p0,
    -0x1.fffffep-1
  },
  { // Entry 437
    0x1.921fb54442d18469898cc51701b839a2p0,
    0x1.p0
  },
  { // Entry 438
    -0x1.921fb54442d18469898cc51701b839a2p0,
    -0x1.p0
  },
  { // Entry 439
    0x1.921faf0918938469613a406686d325fbp-1,
    0x1.6a09e2p-1
  },
  { // Entry 440
    -0x1.921faf0918938469613a406686d325fbp-1,
    -0x1.6a09e2p-1
  },
  { // Entry 441
    0x1.921fb1dd2c59846982fbd21e12b62957p-1,
    0x1.6a09e4p-1
  },
  { // Entry 442
    -0x1.921fb1dd2c59846982fbd21e12b62957p-1,
    -0x1.6a09e4p-1
  },
  { // Entry 443
    0x1.921fb4b1402384698984b09966f96de6p-1,
    0x1.6a09e6p-1
  },
  { // Entry 444
    -0x1.921fb4b1402384698984b09966f96de6p-1,
    -0x1.6a09e6p-1
  },
  { // Entry 445
    0x1.921fb78553f184698b7579b807754fb1p-1,
    0x1.6a09e8p-1
  },
  { // Entry 446
    -0x1.921fb78553f184698b7579b807754fb1p-1,
    -0x1.6a09e8p-1
  },
  { // Entry 447
    0x1.921fba5967c384699f6ecc197800562dp-1,
    0x1.6a09eap-1
  },
  { // Entry 448
    -0x1.921fba5967c384699f6ecc197800562dp-1,
    -0x1.6a09eap-1
  },
  { // Entry 449
    0x1.0c151efd527d65a2625f3b65877af5c1p0,
    0x1.bb67aap-1
  },
  { // Entry 450
    -0x1.0c151efd527d65a2625f3b65877af5c1p0,
    -0x1.bb67aap-1
  },
  { // Entry 451
    0x1.0c1520fd527132af0e514af5d776d861p0,
    0x1.bb67acp-1
  },
  { // Entry 452
    -0x1.0c1520fd527132af0e514af5d776d861p0,
    -0x1.bb67acp-1
  },
  { // Entry 453
    0x1.0c1522fd526bed5a0f7cb328ba5c3991p0,
    0x1.bb67aep-1
  },
  { // Entry 454
    -0x1.0c1522fd526bed5a0f7cb328ba5c3991p0,
    -0x1.bb67aep-1
  },
  { // Entry 455
    0x1.0c1524fd526d95a3b5e16f8bb09d2428p0,
    0x1.bb67b0p-1
  },
  { // Entry 456
    -0x1.0c1524fd526d95a3b5e16f8bb09d2428p0,
    -0x1.bb67b0p-1
  },
  { // Entry 457
    0x1.0c1526fd52762b8c517f8184b870bf6dp0,
    0x1.bb67b2p-1
  },
  { // Entry 458
    -0x1.0c1526fd52762b8c517f8184b870bf6dp0,
    -0x1.bb67b2p-1
  },
  { // Entry 459
    0x1.921fb54442d18469898cc51701b839a2p0,
    0x1.p0
  },
  { // Entry 460
    -0x1.921fb54442d18469898cc51701b839a2p0,
    -0x1.p0
  },
  { // Entry 461
    0x1.920914a5da6f90beac755cf81add3707p0,
    0x1.fffffep-1
  },
  { // Entry 462
    -0x1.920914a5da6f90beac755cf81add3707p0,
    -0x1.fffffep-1
  },
  { // Entry 463
    0x1.ce8277f32da2c5ee7ea325793fd7ccd1p-1,
    0x1.921fb6p-1
  },
  { // Entry 464
    -0x1.ce8277f32da2c5ee7ea325793fd7ccd1p-1,
    -0x1.921fb6p-1
  },
  { // Entry 465
    0x1.000002p-126,
    0x1.000002p-126
  },
  { // Entry 466
    -0x1.000002p-126,
    -0x1.000002p-126
  },
  { // Entry 467
    0x1.p-126,
    0x1.p-126
  },
  { // Entry 468
    -0x1.p-126,
    -0x1.p-126
  },
  { // Entry 469
    0x1.fffffcp-127,
    0x1.fffffcp-127
  },
  { // Entry 470
    -0x1.fffffcp-127,
    -0x1.fffffcp-127
  },
  { // Entry 471
    0x1.fffff8p-127,
    0x1.fffff8p-127
  },
  { // Entry 472
    -0x1.fffff8p-127,
    -0x1.fffff8p-127
  },
  { // Entry 473
    0x1.p-148,
    0x1.p-148
  },
  { // Entry 474
    -0x1.p-148,
    -0x1.p-148
  },
  { // Entry 475
    0x1.p-149,
    0x1.p-149
  },
  { // Entry 476
    -0x1.p-149,
    -0x1.p-149
  },
  { // Entry 477
    0.0,
    0.0f
  },
  { // Entry 478
    -0.0,
    -0.0f
  }
};
