/*
 * Copyright (C) 2018 The Android Open Source Project
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

// Reduced trace based on 2.8 billion samples extracted from specpu2017
// 521.wrf_r benchmark.
static const std::vector<float> logf_input = {
  0x1.fe4c3p-1,
  0x1.0e33e6p+1,
  0x1.00000ap+0,
  0x1.900028p+4,
  0x1.f8cdeep+0,
  0x1.332986p+7,
  0x1.493696p+0,
  0x1p+0,
  0x1.38c67p+7,
  0x1.029046p+1,
  0x1.1bd31cp+4,
  0x1.bb3e3ep+12,
  0x1.000098p+0,
  0x1.a7971p+7,
  0x1p+0,
  0x1.0001a8p+0,
  0x1.00004ep+0,
  0x1p+0,
  0x1.0606f2p+0,
  0x1.3e54a8p+11,
  0x1.3a0662p+3,
  0x1.000c72p+0,
  0x1p+0,
  0x1.0bf8b6p+0,
  0x1.000204p+0,
  0x1.500ad2p+0,
  0x1p+0,
  0x1.3e4cfp+8,
  0x1.00006cp+0,
  0x1.54f7fp+0,
  0x1.267858p+0,
  0x1.191ccp+0,
  0x1.0cdb18p+1,
  0x1.29bf1ep+15,
  0x1.64bd92p+1,
  0x1.255534p+0,
  0x1p+0,
  0x1.93bb82p+3,
  0x1.1348ep+1,
  0x1.00456ep+0,
  0x1.08afbcp+8,
  0x1.32c37ep+0,
  0x1.3437cep-1,
  0x1.000214p+0,
  0x1.03d5ap+0,
  0x1.172378p+6,
  0x1p+0,
  0x1.330f22p-1,
  0x1.00b91p+0,
  0x1.e831f2p+15,
  0x1.092318p+9,
  0x1p+0,
  0x1.e80902p+7,
  0x1.71ec54p+2,
  0x1.1935dcp+0,
  0x1.651082p+14,
  0x1p+0,
  0x1.0f41d8p+8,
  0x1.17f4p+0,
  0x1.7cf946p+9,
  0x1.b14396p+0,
  0x1.92f94p+1,
  0x1.2f3784p-1,
  0x1p+0,
  0x1.305ad4p-1,
  0x1.002a08p+0,
  0x1.3e338p+5,
  0x1.1863f6p+8,
  0x1p+0,
  0x1.ed8fd8p+58,
  0x1p+0,
  0x1p+0,
  0x1.215fc8p+9,
  0x1.1965bep+16,
  0x1.00031cp+0,
  0x1.00011p+0,
  0x1p+0,
  0x1.e384fep-20,
  0x1p+0,
  0x1.00020cp+0,
  0x1.007e24p+0,
  0x1.b14346p+0,
  0x1.243ff8p+0,
  0x1.3f6ac2p+3,
  0x1.816ff6p+5,
  0x1.0115ap+8,
  0x1.162028p+16,
  0x1.62692cp+0,
  0x1.0227c8p+1,
  0x1.4dda3ep+0,
  0x1.418696p+0,
  0x1.0272f4p+2,
  0x1.62c6ecp+5,
  0x1.3cd07ap+18,
  0x1.0191eap+0,
  0x1.21c3a2p+8,
  0x1p+0,
  0x1.000bf6p+0,
  0x1.a4b51cp+7,
  0x1.04d1f8p+0,
  0x1.8de2b8p+0,
  0x1.7b7a4ep+8,
  0x1.1928acp+5,
  0x1.305a8p-1,
  0x1.ba8662p+5,
  0x1p+0,
  0x1.ab75a2p-12,
  0x1.7cc13cp+9,
  0x1.505306p+0,
  0x1.63085p+0,
  0x1.000064p+0,
  0x1.b3f16ap+7,
  0x1.1348f8p+1,
  0x1.71fe88p+1,
  0x1.0b7132p+4,
  0x1.470316p+1,
  0x1.3228b6p-1,
  0x1.8dd666p+0,
  0x1.38ed88p+12,
  0x1.432218p+0,
  0x1.00e0cap+0,
  0x1.73eb44p+2,
  0x1p+0,
  0x1p+0,
  0x1.bda15ep+7,
  0x1.0272fep+2,
  0x1.00171ep+0,
  0x1p+0,
  0x1.3faa86p+3,
  0x1.33c2a2p-1,
  0x1.3e48e2p+7,
  0x1.017ef2p+0,
  0x1.30115ap-1,
  0x1.587444p+0,
  0x1.3efed8p+8,
  0x1.8a5526p+0,
  0x1.cb1ecap+15,
  0x1.1f5cp+0,
  0x1.0001a4p+0,
  0x1.1a20dap+7,
  0x1.376e6p+0,
  0x1.0001aap+0,
  0x1.9182f6p-1,
  0x1.000292p+0,
  0x1.3d46a2p+12,
  0x1.e177b6p+7,
  0x1.3f5646p+1,
  0x1.2ab784p+9,
  0x1.dc81b4p+1,
  0x1.0ef326p+0,
  0x1.996588p-12,
  0x1.740848p+3,
  0x1.00016p+0,
  0x1.ffd51ap+52,
  0x1p+0,
  0x1.4461ap+4,
  0x1.08e7bcp+51,
  0x1p+0,
  0x1.106e98p+3,
  0x1.5490e4p+0,
  0x1.46703cp+4,
  0x1.6b1e86p-29,
  0x1.324caap+0,
  0x1.0467ccp+0,
  0x1.424574p+0,
  0x1p+0,
  0x1.001da4p+0,
  0x1.364604p+0,
  0x1p+0,
  0x1.0951e2p+8,
  0x1.408994p+0,
  0x1.0003ap+0,
  0x1.619e92p+12,
  0x1.313e72p+2,
  0x1.8b47p-6,
  0x1.2190fp+2,
  0x1.20aaacp+0,
  0x1.f0059cp-1,
  0x1p+0,
  0x1.018e78p+0,
  0x1.313e1p+2,
  0x1p+0,
  0x1.2efce4p-1,
  0x1.5ebdap+0,
  0x1p+0,
  0x1.5e2488p+51,
  0x1.bf95f2p+5,
  0x1.5a1124p+16,
  0x1.73bad6p+1,
  0x1.00048ap+0,
  0x1.0c9beap+8,
  0x1p+0,
  0x1.358c08p+7,
  0x1.7f834ep-26,
  0x1.3e56bcp+15,
  0x1.52d8b2p+15,
  0x1p+0,
  0x1.00109cp+0,
  0x1.0a0bb2p+0,
  0x1p+0,
  0x1.026908p+6,
  0x1.370f22p+0,
  0x1.5c6c5ap+1,
  0x1.7fe4bcp+2,
  0x1p+0,
  0x1p+0,
  0x1.42be68p+49,
  0x1.0000d8p+0,
  0x1.3abdf8p+12,
  0x1.370a44p-12,
  0x1.aef9f4p+0,
  0x1.00001ep+2,
  0x1.017c2p+0,
  0x1.00b614p+0,
  0x1.32f9f8p-1,
  0x1p+0,
  0x1.00ebf2p+0,
  0x1.0c3116p+0,
  0x1.00004p+0,
  0x1.03b992p+0,
  0x1p+0,
  0x1.24eb3cp+0,
  0x1.4c73ecp+51,
  0x1.fad3ep+1,
  0x1p+0,
  0x1.32368ap-1,
  0x1.000908p+0,
  0x1.5ea59ep+12,
  0x1.1928ccp+5,
  0x1p+0,
  0x1.21a93cp+8,
  0x1p+0,
  0x1.0001e8p+0,
  0x1.95b6c2p-12,
  0x1.00002p+0,
  0x1.2399fap+9,
  0x1.449b44p+0,
  0x1p+0,
  0x1.64a766p+15,
  0x1.06ccecp+0,
  0x1p+0,
  0x1p+0,
  0x1p+0,
  0x1.c81f9cp+1,
  0x1.5ef196p+0,
  0x1.022822p+1,
  0x1.99beep+3,
  0x1.1f417p+8,
  0x1p+0,
  0x1.c08726p+5,
  0x1.397d9ep+0,
  0x1.88e748p+18,
  0x1.3b319p+9,
  0x1.2fd3b6p-1,
  0x1.0001aep+0,
  0x1.4a0562p+5,
  0x1.4e5f1ap+0,
  0x1p+0,
  0x1.017fbp+0,
  0x1.acaf56p+57,
  0x1.ef7d66p+8,
  0x1.736c3cp+1,
  0x1.12ddbep+0,
  0x1.b85ebcp+6,
  0x1.0e259p+1,
  0x1.5cc2c4p+2,
  0x1.99e614p+3,
  0x1.f30aa6p+2,
  0x1.3911c6p+15,
  0x1.119b92p+1,
  0x1.352a3p-1,
  0x1.0001b2p+0,
  0x1.00b26p+0,
  0x1.bd730ep+60,
  0x1.54fc5p+0,
  0x1.5a4804p+0,
  0x1.ff7eaep-1,
  0x1.5cc268p+2,
  0x1.1077aap+2,
  0x1.1723d6p+0,
  0x1p+0,
  0x1p+0,
  0x1.30c17p-1,
  0x1.000648p+0,
  0x1.91aa4cp+6,
  0x1.17234p+6,
  0x1p+0,
  0x1.6d5b18p+2,
  0x1.00027ap+0,
  0x1.dc8224p+1,
  0x1.a9eabep-6,
  0x1.099edcp+1,
  0x1.004118p+1,
  0x1.58d5fcp+60,
  0x1.000098p+0,
  0x1.004e8p+0,
  0x1.f32edap-1,
  0x1.0394aep+0,
  0x1.0689bp+2,
  0x1.124e5cp+0,
  0x1.71fe86p+1,
  0x1.025ce2p+0,
  0x1.46107cp+0,
  0x1.047c74p+2,
  0x1.a57e74p+15,
  0x1.18bbcep+0,
  0x1p+0,
  0x1.65b9a4p+0,
  0x1.0000eep+0,
  0x1.08a4a4p+0,
  0x1.0fe774p+1,
  0x1.000128p+0,
  0x1.3e95fp+12,
  0x1.b14e3ap-56,
  0x1.00007cp+0,
  0x1.5619c2p+1,
  0x1.4ac958p+0,
  0x1.00031p+0,
  0x1.003064p+0,
  0x1.e119eap-1,
  0x1.577b36p+0,
  0x1p+0,
  0x1.26ff2ap+0,
  0x1.004ap+0,
  0x1.0000a2p+0,
  0x1.1fcc7ep+4,
  0x1.6f959p+16,
  0x1.000064p+0,
  0x1.375c6ap+0,
  0x1.6a806ep+2,
  0x1p+0,
  0x1.8e27aep+1,
  0x1p+0,
  0x1.000b22p+0,
  0x1.8f0c12p+0,
  0x1.192892p+5,
  0x1.2bcaacp+1,
  0x1.984264p+2,
  0x1.0034cp+0,
  0x1p+0,
  0x1.abf4dp+0,
  0x1.001044p+0,
  0x1.0d26f4p+0,
  0x1.626906p+0,
  0x1.8bf0c2p+5,
  0x1.02d288p+0,
  0x1.900128p+4,
  0x1.bbbbcp+12,
  0x1.45fa5p+0,
  0x1p+0,
  0x1.01bef2p+0,
  0x1.524f26p+2,
  0x1.083b0ep+0,
  0x1.4811e4p+0,
  0x1.0163a8p+0,
  0x1.9570fap+15,
  0x1.3022f2p-1,
  0x1.14c73ap+0,
  0x1.0009d8p+0,
  0x1.056b92p+63,
  0x1.0025a4p+0,
  0x1.36aad4p+17,
  0x1.05c244p+8,
  0x1.d00886p+17,
  0x1.001188p+0,
  0x1.3376ecp-1,
  0x1.6719c8p+16,
  0x1.02495p+0,
  0x1.fd9bacp-1,
  0x1.3882c6p+6,
  0x1.3cb358p+0,
  0x1.0ec93ep+0,
  0x1.4fd2bap+1,
  0x1.f8b68p+1,
  0x1.33b1f2p-1,
  0x1.ba7f4cp+1,
  0x1p+0,
  0x1.44a3d2p-17,
  0x1.9a6a8p+2,
  0x1.00918ap+6,
  0x1.30d50ep-1,
  0x1p+0,
  0x1.0001bep+0,
  0x1.05b93ep+0,
  0x1.aa9d98p+0,
  0x1.039b74p+0,
  0x1.1ac25ep+8,
  0x1p+0,
  0x1.12b23ap+1,
  0x1.4c5c52p+0,
  0x1.07de64p+0,
  0x1.950f94p+1,
  0x1.001caap+47,
  0x1.0a9448p+0,
  0x1.01026cp+0,
  0x1.03d74ap+0,
  0x1p+0,
  0x1.0032dap+0,
  0x1.380922p-1,
  0x1.c0e7ccp+15,
  0x1.a35e4p+4,
  0x1.25b1e6p+0,
  0x1.000044p+2,
  0x1.05ac24p+7,
  0x1.1fa744p+44,
  0x1.0007b2p+0,
  0x1.2cca62p+2,
  0x1.04be3ap+6,
  0x1.00065p+0,
  0x1.2b9f3ap+1,
  0x1.74085p+3,
  0x1p+0,
  0x1.01fc4cp+0,
  0x1.e137bcp+2,
  0x1.097ac8p+0,
  0x1.ad1458p+4,
  0x1.c8587cp+1,
  0x1.31d172p-1,
  0x1.0b414ap+1,
  0x1.664e36p+1,
  0x1.30ae16p-1,
  0x1p+0,
  0x1.3b7e3cp+2,
  0x1.9cc348p+64,
  0x1p+0,
  0x1p+0,
  0x1.cdb384p-32,
  0x1p+0,
  0x1.00b998p+0,
  0x1.36b69ep-1,
  0x1.939538p+4,
  0x1.dc9deep+4,
  0x1.36f86ep+2,
  0x1.02113cp+0,
  0x1.035852p+0,
  0x1.9de428p+2,
  0x1.369814p+1,
  0x1.147f44p+3,
  0x1.031bc8p+0,
  0x1.03f7cp+0,
  0x1.000924p+0,
  0x1.145e14p+2,
  0x1.0000d4p+0,
  0x1p+0,
  0x1.54fdfp+2,
  0x1.07c0ep+0,
  0x1.829aeep+1,
  0x1.000f08p+0,
  0x1.34dcdp-1,
  0x1p+0,
  0x1.cd56e4p+1,
  0x1.16400ap+8,
  0x1p+0,
  0x1.00000ap+2,
  0x1.00a21p+0,
  0x1.8d6286p+6,
  0x1.de4f28p+1,
  0x1.9f55b6p+48,
  0x1.01c802p+0,
  0x1.0327cp+0,
  0x1.32fb52p-1,
  0x1p+0,
  0x1.2525dcp+0,
  0x1.91da28p-6,
  0x1.5a23a8p+0,
  0x1.5f024ap+1,
  0x1p+0,
  0x1.0008f2p+0,
  0x1.05563cp+0,
  0x1.89381cp+0,
  0x1.8bb056p+16,
  0x1.7cc93ep+1,
  0x1.8bf0acp+5,
  0x1.1722bap+6,
  0x1p+0,
  0x1.00238ep+0,
  0x1.ebb8d2p-1,
  0x1.001194p+0,
  0x1.6cd388p+1,
  0x1.08e4bp+8,
  0x1.00002p+0,
  0x1.01a0bep+0,
  0x1.00e7cep+8,
  0x1.1193p+0,
  0x1.06a9c8p+0,
  0x1.11c7fep+0,
  0x1.5ef17cp+0,
  0x1.4ae72cp+0,
  0x1.e0df4cp+41,
  0x1.7e5468p+1,
  0x1.8dd478p+0,
  0x1.3c2784p+51,
  0x1p+0,
  0x1p+0,
  0x1.b9d454p+12,
  0x1.011a58p+0,
  0x1.3efb48p+4,
  0x1.000208p+0,
  0x1.57b3eep+7,
  0x1.000004p+0,
  0x1.1cd6b8p+0,
  0x1.c366fap+9,
  0x1.466d2cp+0,
  0x1p+0,
  0x1.300096p-1,
  0x1p+0,
  0x1.bef388p+0,
  0x1.0c20e8p+8,
  0x1.397f2p+4,
  0x1.037596p+2,
  0x1.62a0a4p+52,
  0x1.37269ap+0,
  0x1.81fe24p+2,
  0x1.dd4196p+56,
  0x1.b143ep+0,
  0x1p+0,
  0x1.b8c2fp+1,
  0x1.056b3ep+1,
  0x1.3b6cbp+0,
  0x1.3ffb2p+0,
  0x1p+0,
  0x1.3c21cp+0,
  0x1.00312cp+0,
  0x1p+0,
  0x1.3822f8p+0,
  0x1.02734p+2,
  0x1.05a7dap+0,
  0x1.6df1b4p+5,
  0x1.0006f4p+0,
  0x1.31aebep-1,
  0x1p+0,
  0x1p+0,
  0x1.b997fap+18,
  0x1.0570d8p+0,
  0x1p+0,
  0x1.0a9216p+42,
  0x1.ef16f2p+1,
  0x1p+0,
  0x1.31269ep-1,
  0x1.a9954ap+2,
  0x1.1cc5e8p+0,
  0x1.01d334p+0,
  0x1.905f98p+4,
  0x1.0310d4p+0,
  0x1.16a62ap+0,
  0x1.8dd6b2p+0,
  0x1.395dcep+7,
  0x1.ef5f92p+0,
  0x1.000868p+0,
  0x1p+0,
  0x1.844a16p+2,
  0x1.452efcp+0,
  0x1p+0,
  0x1.1c5da2p+6,
  0x1.31ac3ap-1,
  0x1.cc1bfp+2,
  0x1p+0,
  0x1.08215ap+0,
  0x1.3b4306p+0,
  0x1.71fe6p+1,
  0x1.192bd8p+0,
  0x1.262f78p+0,
  0x1.00013cp+0,
  0x1.33c486p-1,
  0x1.000014p+0,
  0x1.b8f4fp+1,
  0x1.5f9f5ap-1,
  0x1.059872p+0,
  0x1p+0,
  0x1.58168p+1,
  0x1.826d5cp+0,
  0x1p+0,
  0x1.032a04p+0,
  0x1p+0,
  0x1.0c0a5cp+0,
  0x1.668d9p+0,
  0x1.2f9644p-1,
  0x1p+0,
  0x1.1821b8p+6,
  0x1.b22e8ep+7,
  0x1.4f7a78p+0,
  0x1.52df24p+0,
  0x1.48c612p+0,
  0x1.93a19ap+4,
  0x1.8bf102p+5,
  0x1.122d94p+0,
  0x1p+0,
  0x1.00018p+0,
  0x1.30083ap-1,
  0x1p+0,
  0x1p+0,
  0x1.30d20ep-1,
  0x1p+0,
  0x1.0000dcp+0,
  0x1.285bb4p+0,
  0x1p+0,
  0x1.0003a4p+0,
  0x1p+0,
  0x1.2ffcfcp-1,
  0x1.093d96p+0,
  0x1.239bfcp+0,
  0x1.f7c33cp-27,
  0x1.a9982ep+2,
  0x1.1969f4p+4,
  0x1.ff5c88p-1,
  0x1.04db6ep+2,
  0x1p+0,
  0x1.f010dap-1,
  0x1.13647p+7,
  0x1p+0,
  0x1.ea6e18p-10,
  0x1.2d16eap+0,
  0x1.02b668p+0,
  0x1.191704p+4,
  0x1.18f2b4p+0,
  0x1.b186eap+0,
  0x1.24c01ap+2,
  0x1.6a3adap+16,
  0x1p+0,
  0x1p+0,
  0x1.2f9f28p-1,
  0x1.4b5da4p+0,
  0x1.004054p+0,
  0x1.002616p+8,
  0x1.561954p+1,
  0x1p+0,
  0x1.4c4394p+0,
  0x1.1eed34p+1,
  0x1.a702eap+5,
  0x1.ee054p+7,
  0x1.1156a8p+0,
  0x1.9a81fcp+2,
  0x1.10ce16p-28,
  0x1.b18b88p+0,
  0x1.d9c4a8p+1,
  0x1.0e275cp+0,
  0x1.905f58p+4,
  0x1p+0,
  0x1.02f774p+0,
  0x1.7ce226p+1,
  0x1.0002bcp+0,
  0x1.010f58p+0,
  0x1p+0,
  0x1.000198p+0,
  0x1p+0,
  0x1.4aa832p+0,
  0x1.0006c2p+0,
  0x1.358ca4p+7,
  0x1.1edc64p+0,
  0x1.003508p+0,
  0x1.fdb69p+1,
  0x1.0ff4fep+0,
  0x1p+0,
  0x1.b8c2fp+1,
  0x1.284c16p+0,
  0x1.00a228p+0,
  0x1.03080cp+0,
  0x1.91a8f4p+48,
  0x1p+0,
  0x1.2080fep+1,
  0x1.0002f8p+0,
  0x1.b14338p+0,
  0x1.081288p+0,
  0x1.71b9bep+0,
  0x1.09c368p+0,
  0x1.35ed64p+0,
  0x1.8dd68cp+0,
  0x1.d2cc42p+0,
  0x1.9be0ecp+3,
  0x1.7407fcp+3,
  0x1.313ecp-1,
  0x1.cdc978p+0,
  0x1.0ed538p+1,
  0x1.159af4p+8,
  0x1p+0,
  0x1.128694p+0,
  0x1.2f1b06p-1,
  0x1.19c0d8p+0,
  0x1.dcc7c8p+1,
  0x1.a33f8ap+7,
  0x1.000158p+0,
  0x1p+0,
  0x1.28bdaep-16,
  0x1.74086cp+3,
  0x1.ea297cp+1,
  0x1.5d87fp+2,
  0x1.0e2658p+1,
  0x1.621c14p+1,
  0x1.9d8a8cp+3,
  0x1p+0,
  0x1.7807e8p+3,
  0x1.74c924p+0,
  0x1.a484e4p+53,
  0x1.771c44p+0,
  0x1.13d1e4p+2,
  0x1.2fa402p-1,
  0x1p+0,
  0x1.024d72p+2,
  0x1.064c6ap+8,
  0x1.15d2dep+0,
  0x1.9c004ep+3,
  0x1.bc2fcap+12,
  0x1.befdbep+0,
  0x1.36461p+0,
  0x1.6db7b8p+5,
  0x1.0000cp+0,
  0x1p+0,
  0x1.02f354p+0,
  0x1p+0,
  0x1.000228p+0,
  0x1.013fep+0,
  0x1.213782p+0,
  0x1p+0,
  0x1.000204p+0,
  0x1.a69cccp+7,
  0x1.0036acp+0,
  0x1.0982b8p+0,
  0x1.81693cp-22,
  0x1.1e5d64p+6,
  0x1.0009f2p+0,
  0x1.2fe96p-1,
  0x1.0368f8p+0,
  0x1.2d2cbep+0,
  0x1.37bc04p-1,
  0x1p+0,
  0x1.d45d88p+1,
  0x1.000694p+0,
  0x1.000272p+0,
  0x1p+0,
  0x1.d0b2e6p+1,
  0x1.2598a4p+3,
  0x1p+0,
  0x1.8b7d3p+2,
  0x1.192902p+5,
  0x1.3d5386p+0,
  0x1.9c779ap+1,
  0x1.08257cp+0,
  0x1.0b8a4p+2,
  0x1.01afa4p+3,
  0x1.e48b7ap-1,
  0x1.f30a5cp+2,
  0x1.0df814p+0,
  0x1.2f28p-1,
  0x1.983f46p+3,
  0x1.009094p+6,
  0x1.326a3ep-1,
  0x1.9767e6p+0,
  0x1.1027fp+0,
  0x1.3274f8p-1,
  0x1.197a9cp+1,
  0x1.3807p+2,
  0x1.90533p+4,
  0x1.0332ecp+0,
  0x1.3ca37p+0,
  0x1p+0,
  0x1p+0,
  0x1.3ff4dcp+0,
  0x1p+0,
  0x1.900046p+0,
  0x1p+0,
  0x1.195576p+5,
  0x1.aec2ecp+7,
  0x1.65b984p+0,
  0x1.74677p+3,
  0x1.423322p+0,
  0x1.aeef9ep+16,
  0x1.0338c4p+0,
  0x1.1ae22ap+8,
  0x1.cc4adcp+0,
  0x1.d20a9ep+0,
  0x1.cdbefcp-45,
  0x1.03b23cp+0,
  0x1.25970cp+3,
  0x1.e6b02ep-1,
  0x1p+0,
  0x1p+0,
  0x1p+0,
  0x1p+0,
  0x1.000aa8p+0,
  0x1.0054a4p+0,
  0x1.06600ap+0,
  0x1.b8601cp+6,
  0x1.fea92cp+5,
  0x1.6p+5,
  0x1.c76586p+0,
  0x1.90007ap+0,
  0x1.ef2d1p-84,
  0x1.03d5b6p+0,
  0x1.0164ecp+0,
  0x1.4441d8p+0,
  0x1.005c42p+0,
  0x1.046838p+0,
  0x1.51f04ap+0,
  0x1.cf822cp+0,
  0x1.033b4ap+0,
  0x1p+0,
  0x1.091bep+0,
  0x1p+0,
  0x1.5bb2a4p+0,
  0x1.01fe2cp+0,
  0x1.2b96p+1,
  0x1.242d9p+0,
  0x1.42ade4p+0,
  0x1p+0,
  0x1.689714p+2,
  0x1.4ac756p+0,
  0x1p+0,
  0x1.101ad8p+0,
  0x1.6208e8p+41,
  0x1.47091p+0,
  0x1.3e28p+3,
  0x1.04b70ep+0,
  0x1p+0,
  0x1.086c9p+0,
  0x1.70eb62p+54,
  0x1.dfb744p+4,
  0x1p+0,
  0x1.f302bcp-8,
  0x1.8d5fd4p+6,
  0x1.12d9a8p+0,
  0x1.00a39p+0,
  0x1p+0,
  0x1.00003cp+0,
  0x1.00031p+0,
  0x1.58743ep+0,
  0x1.003ae4p+0,
  0x1.7de5cep+2,
  0x1.096c7ep+0,
  0x1.57e436p+1,
  0x1.21fcb4p+2,
  0x1.31297ap-1,
  0x1p+0,
  0x1.ab5fcp+16,
  0x1.91e912p+42,
  0x1.5cb206p+1,
  0x1.000072p+0,
  0x1.00f4d2p+0,
  0x1.0ee52p+0,
  0x1.000014p+0,
  0x1.2f3a5ep-1,
  0x1.3fc07cp+1,
  0x1.64bd36p+1,
  0x1.f48f56p-1,
  0x1.0115f4p+0,
  0x1.1650bcp+2,
  0x1.013494p+0,
  0x1p+0,
  0x1.684e92p+0,
  0x1.0063a4p+0,
  0x1.3ca364p+0,
  0x1.197a48p+1,
  0x1.00a6f4p+0,
  0x1.31ce92p-1,
  0x1.fea91ep+5,
  0x1.6dd5cep+5,
  0x1.05035ep+8,
  0x1.6d6acep+5,
  0x1.8c4fa2p+5,
  0x1.f4e59cp-12,
  0x1.6330e4p+0,
  0x1.01a9fep+0,
  0x1.4f48e4p+0,
  0x1.d589c6p+1,
  0x1.5be04ap+15,
  0x1.f9e2f2p-1,
  0x1.294bdp+1,
  0x1.8bf1p+5,
  0x1.967eb8p-9,
  0x1.018d04p+0,
  0x1.00032cp+0,
  0x1p+0,
  0x1.ba21bcp+14,
  0x1.8dd6bp+0,
  0x1.7455a8p+3,
  0x1p+0,
  0x1.8e8a02p+15,
  0x1.015f06p+0,
  0x1.04a26p+8,
  0x1.000c58p+0,
  0x1.26a58cp+3,
  0x1.2719bap-19,
  0x1p+0,
  0x1.05194cp+7,
  0x1.34d9f4p+0,
  0x1p+0,
  0x1.029fa2p+0,
  0x1.99a9dap+0,
  0x1.cee06ep+0,
  0x1.3e921ap+0,
  0x1.9f8eep+0,
  0x1p+0,
  0x1p+0,
  0x1p+0,
  0x1.13f606p+0,
  0x1p+0,
  0x1.0a176ep+2,
  0x1.aa9c94p+7,
  0x1.1211ep+0,
  0x1.122594p+0,
  0x1.b39642p+47,
  0x1p+0,
  0x1.000068p+0,
  0x1.6600aep-12,
  0x1.e0d6ecp+1,
  0x1.0019ep+0,
  0x1.34b8f4p-1,
  0x1.581728p+2,
  0x1.00016p+0,
  0x1.12b1ep+8,
  0x1.a679fp+14,
  0x1.90005ap+4,
  0x1.837996p-1,
  0x1p+0,
  0x1.0e2552p+1,
  0x1.22160cp+9,
  0x1p+0,
  0x1.57e4b4p+1,
  0x1p+0,
  0x1.bf8d0cp+0,
  0x1.d7e10ep+16,
  0x1.06bcc8p+0,
  0x1.133b12p+0,
  0x1.1b6542p+6,
  0x1p+0,
  0x1.feddbcp-1,
  0x1p+0,
  0x1p+0,
  0x1.2fd98ep-1,
  0x1.03d5b6p+0,
  0x1p+0,
  0x1.db8a46p-1,
  0x1.42e588p+0,
  0x1.0ee1p+1,
  0x1.361fep+0,
  0x1.2f74a8p+0,
  0x1p+0,
  0x1.31596cp-1,
  0x1.740a2p+3,
  0x1p+0,
  0x1.8dd672p+0,
  0x1.00011cp+0,
  0x1p+0,
  0x1.000102p+0,
  0x1.5cc2b2p+2,
  0x1p+0,
  0x1.17f4b4p+0,
  0x1.619318p+12,
  0x1.b14362p+0,
  0x1.c1004ep+0,
  0x1.318578p-1,
  0x1.9728ecp+2,
  0x1.25bdbcp+3,
  0x1.37ac8ap+63,
  0x1p+0,
  0x1.41ef56p+2,
  0x1.e65866p-1,
  0x1p+0,
  0x1.307e0ap+0,
  0x1.ef570ep+54,
  0x1.0290fap+1,
  0x1.9dd308p+0,
  0x1.21db9p+0,
  0x1.00003cp+0,
  0x1.eabf94p+0,
  0x1.386614p+10,
  0x1.f244dap+16,
  0x1p+0,
  0x1.00e094p+0,
  0x1.5605e6p+1,
  0x1.b16374p+2,
  0x1.9a2d88p+0,
  0x1.48748ap+9,
  0x1p+0,
  0x1.28e674p+0,
  0x1.bf4324p+7,
  0x1.2598c6p+3,
  0x1.215484p+1,
  0x1.05fb5p+51,
  0x1.0000d8p+0,
  0x1.f389dcp+6,
  0x1.41a1bp+0,
  0x1.001582p+0,
  0x1.1928ecp+5,
  0x1.00ff3ep+0,
  0x1.3883c4p+13,
  0x1.98b044p+2,
  0x1.8a43eep+0,
  0x1.733e8p+14,
  0x1.73ebfcp+2,
  0x1.0cd1fp+0,
  0x1p+0,
  0x1.af357p+5,
  0x1.b2c586p+5,
  0x1.470f58p+0,
  0x1p+0,
  0x1p+0,
  0x1.0ffddep+0,
  0x1.02c422p+1,
  0x1.56c4a6p+1,
  0x1.492014p-47,
  0x1.192862p+5,
  0x1p+0,
  0x1.c7e222p+7,
  0x1p+0,
  0x1p+0,
  0x1.1a0d3p+49,
  0x1.946148p+0,
  0x1.524f6ap+2,
  0x1.31566ep-1,
  0x1.000198p+0,
  0x1.3d7efcp+3,
  0x1.000264p+0,
  0x1.4ed7ccp+0,
  0x1.b667ecp+0,
  0x1.81940ep+1,
  0x1p+0,
  0x1.088e6cp+0,
  0x1.065bbcp+1,
  0x1.009ae4p+1,
  0x1.008bfp+6,
  0x1.e9f5acp+7,
  0x1.1e1c44p+8,
  0x1.992348p+0,
  0x1.3162fp+0,
  0x1.fb0e1ap+48,
  0x1.8bf0acp+5,
  0x1p+0,
  0x1.1f57b2p+60,
  0x1.011f3p+0,
  0x1.3af642p+0,
  0x1.ccae9p+46,
  0x1.21325cp+0,
  0x1.07743p+7,
  0x1.1ae49ep+8,
  0x1.00006ap+0,
  0x1.1928aap+5,
  0x1.838206p-1,
  0x1p+0,
  0x1.00e9e8p+0,
  0x1.4684cap+0,
  0x1.02568p+0,
  0x1.5efc62p+1,
  0x1p+0,
  0x1.000352p+0,
  0x1.0578cap+0,
  0x1.0039ecp+0,
  0x1.2fc412p-1,
  0x1.4a939ap+1,
  0x1.ff27ep+5,
  0x1.091a62p+0,
  0x1.08c012p+0,
  0x1.67c8p+4,
  0x1.e26b74p-48,
  0x1p+0,
  0x1.283076p+3,
  0x1.2fe494p-1,
  0x1.4dcd9ep+5,
  0x1p+0,
  0x1.cdf4e4p+7,
  0x1p+0,
  0x1.c77d16p+1,
  0x1.fccf76p-1,
  0x1p+0,
  0x1.120a84p+0,
  0x1.054cdep+0,
  0x1.002a0cp+0,
  0x1.063b76p+0,
  0x1.0000d8p+0,
  0x1.30cedep-1,
  0x1.003884p+0,
  0x1p+0,
  0x1.e0065cp-1,
  0x1.693bd2p+15,
  0x1.0fadc2p+0,
  0x1.415d06p+0,
  0x1.0002ecp+0,
  0x1.27ce08p+0,
  0x1.3b9762p+0,
  0x1.2fb36p+2,
  0x1.02c8f8p+0,
  0x1.629facp+50,
  0x1.281c56p+3,
  0x1.4a93c8p+1,
  0x1.0e6cacp-1,
  0x1.f9ef4ap+0,
  0x1.44f78ap+2,
  0x1.9a1e18p+0,
  0x1p+0,
  0x1.3e566p+3,
  0x1.000128p+0,
  0x1p+0,
  0x1.112c38p+0,
  0x1.03d2dap+0,
  0x1.5fb222p+12,
  0x1.1f4b96p+0,
  0x1.01422p+1,
  0x1.ee5728p+63,
  0x1.4bcdd8p+1,
  0x1p+0,
  0x1.30e0e4p-1,
  0x1.6a36b2p+0,
  0x1.00016cp+0,
  0x1.04b966p+0,
  0x1.106e16p+16,
  0x1p+0,
  0x1.1233d2p+0,
  0x1p+0,
  0x1.15d1cap+1,
  0x1.137c02p+8,
  0x1.00001ap+0,
  0x1.07ab74p+0,
  0x1.800b4ep-1,
  0x1.55047p+0,
  0x1.90017ap+4,
  0x1.5c9898p+1,
  0x1.8ce4ccp+6,
  0x1p+0,
  0x1.6ee34p+0,
  0x1.bf600cp+0,
  0x1.f13a7ep+8,
  0x1.00015cp+0,
  0x1.b9c51ep+12,
  0x1.740826p+3,
  0x1.c29e5p+1,
  0x1.f56ba8p-1,
  0x1.37fe18p+2,
  0x1.190eap+0,
  0x1.419f1cp+0,
  0x1p+0,
  0x1p+0,
  0x1.20687ep+8,
  0x1.938ecap+4,
  0x1.01dd1cp+0,
  0x1.bbe888p+7,
  0x1.09d802p+0,
  0x1.cf3b8p+0,
  0x1.ea0d98p-1,
  0x1.172472p+6,
  0x1p+0,
  0x1.61dce4p+1,
  0x1.20b4fcp+0,
  0x1.00038cp+0,
  0x1p+0,
  0x1.0822p+0,
  0x1.9966ep+2,
  0x1.21f47cp+0,
  0x1.3a9762p+0,
  0x1.8c4e0cp+5,
  0x1p+0,
  0x1.61878cp+12,
  0x1.3ca348p+0,
  0x1.289028p+0,
  0x1.06e004p+0,
  0x1.02b4b4p+0,
  0x1.144eeep+1,
  0x1.30a14ap-1,
  0x1.07652p+0,
  0x1p+0,
  0x1.2ef288p+0,
  0x1.1ba73cp+5,
  0x1.48c714p+2,
  0x1.25c508p+3,
  0x1.b14382p+0,
  0x1.b39acep+0,
  0x1.0001c2p+0,
  0x1.996938p+3,
  0x1p+0,
  0x1.e49b2ep+7,
  0x1.000436p+0,
  0x1.34712p+0,
  0x1.47089p+0,
  0x1.0353b8p-49,
  0x1.2a818p+2,
  0x1.00058p+0,
  0x1.8a5a7ep+51,
  0x1p+0,
  0x1.8dbf04p+0,
  0x1.5004d8p+61,
  0x1.9557b2p+1,
  0x1.0fa92cp+0,
  0x1.16984ep+8,
  0x1.72bd7ap+1,
  0x1.980f0cp+1,
  0x1.ae63fp+14,
  0x1p+0,
  0x1.085224p+0,
  0x1.d8889ap-1,
  0x1.1d3ff6p+4,
  0x1.02c6ecp+1,
  0x1.73eb4ep+2,
  0x1.1916fp+4,
  0x1.4a04e8p+5,
  0x1.134906p+1,
  0x1.0002dp+0,
  0x1p+0,
  0x1.32db7p+0,
  0x1.0105b8p+0,
  0x1.09f78p+0,
  0x1.1d3e78p+4,
  0x1.41b184p+0,
  0x1.134914p+1,
  0x1.410e6ep+1,
  0x1.312a4ap-1,
  0x1.7308f4p+1,
  0x1p+0,
  0x1.0afbe8p+0,
  0x1p+0,
  0x1.00026ap+0,
  0x1.2ee012p+0,
  0x1.001318p+0,
  0x1.af1034p+4,
  0x1.687b1cp-24,
  0x1.a93ap+2,
  0x1.084598p+0,
  0x1.37031ap-1,
  0x1.c046ep+5,
  0x1.79a75ep+2,
  0x1.46a9c8p+1,
  0x1.000766p+0,
  0x1.245d98p+0,
  0x1.19287ap+5,
  0x1.6a0fbep+0,
  0x1p+0,
  0x1.011424p+0,
  0x1.879f4cp+0,
  0x1p+0,
  0x1p+0,
  0x1.4ca7ecp-51,
  0x1.5818c6p+2,
  0x1p+0,
  0x1.b4c9fap+7,
  0x1.b14384p+0,
  0x1.082fdp+0,
  0x1.085672p+8,
  0x1.918f3cp+6,
  0x1p+0,
  0x1.45623ep+0,
  0x1.95515cp+2,
  0x1.000068p+0,
  0x1.31f33ap-1,
  0x1.f9eed8p+0,
  0x1.91b218p+6,
  0x1.331446p-1,
  0x1.000202p+0,
  0x1p+0,
  0x1.3cdfb8p-1,
  0x1p+0,
  0x1.08fb58p+7,
  0x1.4dde38p+5,
  0x1p+0,
  0x1.0053a4p+0,
  0x1p+0,
  0x1.31e138p+7,
  0x1p+0,
  0x1.01c35cp+0,
  0x1.dba85cp+7,
  0x1.03682cp+2,
  0x1.000108p+0,
  0x1.bff348p+55,
  0x1.582dbp+1,
  0x1.31158p+0,
  0x1.760bep+44,
  0x1.e43226p+7,
  0x1.082008p+0,
  0x1.a03e4cp+7,
  0x1.00b984p+0,
  0x1.20c58ep+1,
  0x1.221c1p+0,
  0x1.594056p+7,
  0x1.aabf58p+2,
  0x1p+0,
  0x1.b142e4p+0,
  0x1.8bf166p+5,
  0x1p+0,
  0x1.000168p+0,
  0x1.06c69cp+0,
  0x1.900166p+4,
  0x1.621b64p+12,
  0x1.b142eep+0,
  0x1p+0,
  0x1.31c642p-1,
  0x1p+0,
  0x1.65b9cap+0,
  0x1.4adbbep+0,
  0x1p+0,
  0x1.858ea2p+0,
  0x1.076d06p+0,
  0x1.000dap+0,
  0x1.70cd96p+2,
  0x1.347a2p-1,
  0x1.73c75cp+2,
  0x1p+0,
  0x1.180c6ep+8,
  0x1p+0,
  0x1.1a32dcp+5,
  0x1.342abp-1,
  0x1.4a08p+5,
  0x1.000484p+0,
  0x1.e498b4p+7,
  0x1.91e072p+0,
  0x1p+0,
  0x1.9ab2a8p+0,
  0x1.0001dp+0,
  0x1.6ab22p+0,
  0x1.00036p+0,
  0x1.00042cp+0,
  0x1.0012a2p+0,
  0x1.f2b45cp+0,
  0x1.31b8fep-1,
  0x1.2a3f48p+1,
  0x1p+0,
  0x1.d8ecc8p+49,
  0x1.b143b2p+0,
  0x1.4f7516p+0,
  0x1.09a35cp+0,
  0x1.000ap+0,
  0x1.ad259ap+5,
  0x1.8d9b38p-18,
  0x1.92ef44p+0,
  0x1.7407ep+3,
  0x1.bcb74cp+7,
  0x1.57d22p+0,
  0x1.610e16p+0,
  0x1.2ff3fap-1,
  0x1.00aefcp+0,
  0x1.6aaf1cp+0,
  0x1.000298p+0,
  0x1.10b236p+0,
  0x1.2b6a4p+0,
  0x1.25c852p+3,
  0x1.000354p+0,
  0x1p+0,
  0x1.4fe4c2p+2,
  0x1.8ea358p+6,
  0x1.cd77f6p+2,
  0x1.0000aap+0,
  0x1.8c2a1ep-19,
  0x1.000264p+0,
  0x1.03001p+0,
  0x1.0c772cp+0,
  0x1.daea4p+4,
  0x1p+0,
  0x1.0f2d5ep+0,
  0x1p+0,
  0x1.1604d6p+0,
  0x1.2f7b08p-1,
  0x1.0002f4p+0,
  0x1p+0,
  0x1.91aaf8p+1,
  0x1.896624p+0,
  0x1.0024c2p+0,
  0x1.0fde8cp+1,
  0x1.3a7214p+16,
  0x1.01ff8p+0,
  0x1.02458p+1,
  0x1.1d3f4cp+4,
  0x1p+0,
  0x1.c0d546p+1,
  0x1.0ac2d4p+54,
  0x1p+0,
  0x1p+0,
  0x1.75e65p+55,
  0x1p+0,
  0x1.010256p+0,
  0x1.68165p+53,
  0x1p+0,
  0x1.013c3p+0,
  0x1.bc712ep+13,
  0x1p+0,
  0x1.71d1cp+5,
  0x1.49c482p+0,
  0x1.00665p+0,
  0x1.386324p+1,
  0x1.385c4ap-1,
  0x1p+0,
  0x1.379e5p+0,
  0x1.232592p+8,
  0x1p+0,
  0x1.000338p+0,
  0x1p+0,
  0x1p+0,
  0x1.055404p+0,
  0x1.208ef8p+1,
  0x1p+0,
  0x1p+0,
  0x1p+0,
  0x1p+0,
  0x1.015d52p+0,
  0x1.9ea35cp+1,
  0x1.dc7eb4p+18,
  0x1p+0,
  0x1p+0,
  0x1.b3d24ep+7,
  0x1.fba328p+8,
  0x1.00c7fp+0,
  0x1.0d1acep+8,
  0x1.779a24p+2,
  0x1p+0,
  0x1.19499ep+0,
  0x1.25ddcep+3,
  0x1.78346cp+3,
  0x1.428e7ap+49,
  0x1.003dp+0,
  0x1p+0,
  0x1.313dbcp-1,
  0x1.6fef7p+1,
  0x1p+0,
  0x1.2ff116p-1,
  0x1.00f598p+0,
  0x1.45ab88p+0,
  0x1p+0,
  0x1.a93a36p+2,
  0x1p+0,
  0x1.54bb7p+2,
  0x1p+0,
  0x1.00004cp+0,
  0x1.edac12p+0,
  0x1.40f4fap+0,
  0x1.45c0bcp+0,
  0x1.0a2626p+0,
  0x1.bfa67ap+51,
  0x1.933f18p+0,
  0x1p+0,
  0x1.3f3fe8p+0,
  0x1.006fc8p+0,
  0x1.c04aecp+1,
  0x1.0afc4p+0,
  0x1.9b2f1ep+3,
  0x1.11a134p+3,
  0x1.0624dep-11,
  0x1.eabf94p+0,
  0x1.8950d8p+1,
  0x1.35eba2p-1,
  0x1.11c438p+0,
  0x1.02073p+0,
  0x1.483096p+0,
  0x1.484bf4p+2,
  0x1.1b86dcp+0,
  0x1.0d3c56p+0,
  0x1.0000e4p+0,
  0x1.a93b64p+2,
  0x1.b8db1cp+1,
  0x1.308c0ep-1,
  0x1p+0,
  0x1.1e84fp+0,
  0x1.3fc808p+0,
  0x1.19179ap+4,
  0x1p+0,
  0x1.f1d3a4p+7,
  0x1.273d1ep+1,
  0x1.000a16p+0,
  0x1.42ead6p+0,
  0x1.b8c318p+1,
  0x1.7226dp+1,
  0x1.43af5cp+0,
  0x1.450224p+0,
  0x1.000234p+0,
  0x1.358bc4p-1,
  0x1.0000acp+0,
  0x1.02ef5cp+0,
  0x1.1d16fap+8,
  0x1p+0,
  0x1.0a9be6p+0,
  0x1.2221d2p+8,
  0x1.45abbp+0,
  0x1p+0,
  0x1.b787f6p-12,
  0x1.960416p+0,
  0x1.0af8b6p+1,
  0x1.232048p+64,
  0x1.f6b2fp+0,
  0x1p+0,
  0x1.02fc3ep+0,
  0x1.19292ep+5,
  0x1.00fdcap+0,
  0x1.51ac2p+1,
  0x1.020b04p+0,
  0x1.3fe772p+1,
  0x1p+0,
  0x1.3a87dap+0,
  0x1.00dbf8p+0,
  0x1.dc825cp+1,
  0x1.051eap+0,
  0x1p+0,
  0x1p+0,
  0x1p+0,
  0x1p+0,
  0x1p+0,
  0x1.000bp+0,
  0x1.004874p+0,
  0x1.ed7906p+14,
  0x1.ba64fcp+12,
  0x1.03e86ap+0,
  0x1.5cdd2p+2,
  0x1.2fc1c6p-1,
  0x1.08a1b8p+0,
  0x1p+0,
  0x1.4e97bp+62,
  0x1.364392p+0,
  0x1.000236p+0,
  0x1.32f478p-1,
  0x1.362732p+4,
  0x1.1d3f0ep+4,
  0x1.205236p+44,
  0x1p+0,
  0x1.93afd4p+2,
  0x1.2f40ecp-1,
  0x1p+0,
  0x1.0fe4a4p+1,
  0x1.9975e8p+64,
  0x1.4a93fap+1,
  0x1.259756p+3,
  0x1.1e1e64p+8,
  0x1.000048p+0,
  0x1p+0,
  0x1.2f1f74p-1,
  0x1.7a124ap+0,
  0x1.5e3f8ep+2,
  0x1.e58cd8p-1,
  0x1.b3857ep+0,
  0x1.6f4da4p+0,
  0x1p+0,
  0x1.44caaep+0,
  0x1.6831b2p+0,
  0x1.7537bep+1,
  0x1p+0,
  0x1.003054p+0,
  0x1.4934p+2,
  0x1.00005p+0,
  0x1.000098p+0,
  0x1.091ebcp+0,
  0x1.465e2cp+9,
  0x1.00017p+0,
  0x1p+0,
  0x1.31ab6cp-1,
  0x1p+0,
  0x1p+0,
  0x1.f2386ep+57,
  0x1.147d32p+3,
  0x1.e480eep+7,
  0x1.03b3b2p+0,
  0x1.02035cp+0,
  0x1.11d934p+3,
  0x1.5776d8p+53,
  0x1.2c73p+0,
  0x1.63073ap+9,
  0x1.2041aep+8,
  0x1p+0,
  0x1.00594cp+0,
  0x1.3ee136p+0,
  0x1p+0,
  0x1.09548p+1,
  0x1.05f1f4p-11,
  0x1.0002a4p+0,
  0x1.16ac18p+3,
  0x1.b8531ep+7,
  0x1.0fd73cp+1,
  0x1.011f64p+0,
  0x1.0ff65ep+0,
  0x1.b1ecfp+4,
  0x1.8f0888p+0,
  0x1.f95e02p-1,
  0x1p+0,
  0x1.9000cep+0,
  0x1.e9b4fep+52,
  0x1.009838p+0,
  0x1.5ef598p+1,
  0x1.a6ad24p+7,
  0x1.4913c6p+0,
  0x1p+0,
  0x1.3d7314p+0,
  0x1p+0,
  0x1.a591c8p+0,
  0x1.017966p-13,
  0x1.9825cep+3,
  0x1.192898p+5,
  0x1.cddc2p+42,
  0x1p+0,
  0x1p+0,
  0x1.0dde0ap+8,
  0x1.0e56e8p+1,
  0x1.a6fbcep+3,
  0x1.b92cc8p+7,
  0x1.d57268p+0,
  0x1.b8f132p+1,
  0x1.4c257ap+0,
  0x1.00000ap+0,
  0x1.38635p+1,
  0x1.1cc07ap+45,
  0x1.71ff7ep+1,
  0x1.ef8b44p+0,
  0x1.6cf93ep+51,
  0x1p+0,
  0x1p+0,
  0x1.11f506p+8,
  0x1.77844ap+0,
  0x1p+0,
  0x1.bdd978p+7,
  0x1.00006ap+0,
  0x1.0e2602p+1,
  0x1.045486p+0,
  0x1.0002c8p+0,
  0x1.4d67c8p+1,
  0x1.e5b314p-1,
  0x1.6a374cp+0,
  0x1.99db52p+0,
  0x1.f9eeap-1,
  0x1.bf7f2cp+5,
  0x1.da61b4p+4,
  0x1.488ff4p+0,
  0x1.003p+0,
  0x1p+0,
  0x1.02ffcp+0,
  0x1.d09a76p+1,
  0x1.225a2cp+0,
  0x1.0637f2p+0,
  0x1.b3893p+0,
  0x1.00005p+0,
  0x1.bcc5ccp+59,
  0x1p+0,
  0x1.01f38ep+0,
  0x1.a720ecp+7,
  0x1.05390cp+1,
  0x1.bf3ffep+2,
  0x1.6b9574p+0,
  0x1.388f0cp+11,
  0x1.29a6aap+0,
  0x1.31e90ep-1,
  0x1p+0,
  0x1p+0,
  0x1.2f1498p-1,
  0x1.0000eep+0,
  0x1p+0,
  0x1.3190e2p-1,
  0x1p+0,
  0x1.7703c2p+1,
  0x1.0ffd1cp-24,
  0x1p+0,
  0x1p+0,
  0x1.f5c25p-24,
  0x1.7407c8p+3,
  0x1.45abd2p+0,
  0x1.1304ecp+0,
  0x1p+0,
  0x1.0002f4p+0,
  0x1.cd1cdap+1,
  0x1.6ef2fp+15,
  0x1.0002cap+0,
  0x1.dc83cp+1,
  0x1.0000ccp+0,
  0x1.0093cep+0,
  0x1.0066bap+0,
  0x1.002dp+0,
  0x1.0e6c8p+0,
  0x1.7be50ap+16,
  0x1.00b348p+0,
  0x1.089b3p+16,
  0x1.98b07cp+2,
  0x1.3389b2p+0,
  0x1.a41e1ep+7,
  0x1.7195dep+5,
  0x1.08b45cp+0,
  0x1.29c1eap+56,
  0x1.740b96p+3,
  0x1.71fef4p+1,
  0x1.07ba2cp+0,
  0x1.5ee4a2p+1,
  0x1p+0,
  0x1.f9599cp-1,
  0x1.b9154ep+14,
  0x1.f8911cp+0,
  0x1p+0,
  0x1.373e1p+4,
  0x1p+0,
  0x1.00146cp+0,
  0x1.4a05acp+5,
  0x1.1928aap+5,
  0x1.060cecp+0,
  0x1.773996p+0,
  0x1.af11c2p-11,
  0x1p+0,
  0x1.3f7d98p+7,
  0x1.1361ep+52,
  0x1.f9f064p+0,
  0x1p+0,
  0x1.a9b908p+7,
  0x1.c55b46p+0,
  0x1p+0,
  0x1.682ec4p+46,
  0x1.00003p+0,
  0x1p+0,
  0x1.2fdba4p-1,
  0x1.9beca4p+0,
  0x1.0004a8p+0,
  0x1.2fb262p-1,
  0x1.8bf118p+5,
  0x1.0001aap+0,
  0x1.31a74p-1,
  0x1.25db7ep+3,
  0x1p+0,
  0x1.197a7cp+1,
  0x1p+0,
  0x1.2d315cp+0,
  0x1.0024f8p+0,
  0x1.2a7f04p+1,
  0x1p+0,
  0x1p+0,
  0x1.01211cp+0,
  0x1.f11d7ep-1,
  0x1.d4f718p+2,
  0x1.b233dep+0,
  0x1.6d6b1cp+5,
  0x1.7724fep+15,
  0x1p+0,
  0x1.a86fbap+7,
  0x1p+0,
  0x1p+0,
  0x1.4aa984p+49,
  0x1.000054p+0,
  0x1p+0,
  0x1.33d3f4p-1,
  0x1p+0,
  0x1.1b0cd8p+6,
  0x1.000958p+0,
  0x1p+0,
  0x1.49ef4ep+4,
  0x1.7cc648p+1,
  0x1p+0,
  0x1.23470ap+0,
  0x1.3223a4p+0,
  0x1p+0,
  0x1.4d6912p+0,
  0x1.51e25p+0,
  0x1p+0,
  0x1.34962cp+0,
  0x1.0fdd0cp+1,
  0x1.0001d8p+0,
  0x1.38637cp+1,
  0x1.9de754p+3,
  0x1.8e020cp+5,
  0x1.ad9158p+4,
  0x1.094afap+0,
  0x1.ea949ep+52,
  0x1.ec6aa4p+1,
  0x1.1a5e6cp+4,
  0x1.07ed56p+0,
  0x1.711ffp+0,
  0x1p+0,
  0x1.062702p+8,
  0x1.233ffap+18,
  0x1.10c252p+7,
  0x1.002a14p+0,
  0x1.98f468p+0,
  0x1.833884p+0,
  0x1p+0,
  0x1.9179acp+4,
  0x1.d944c4p-1,
  0x1.00bc84p+0,
  0x1p+0,
  0x1.46c0aep+0,
  0x1.ad157p+4,
  0x1.13492cp+1,
  0x1.4b0ceep+0,
  0x1.000246p+0,
  0x1p+0,
  0x1p+0,
  0x1.176dbep+0,
  0x1.52e1b8p+0,
  0x1.050ab8p+0,
  0x1p+0,
  0x1.ef2d1p-84,
  0x1.d0999p+1,
  0x1.00b594p+0,
  0x1.19ae42p+54,
  0x1p+0,
  0x1p+0,
  0x1.bf05cap-56,
  0x1.fba48p+0,
  0x1.19a5ecp+4,
  0x1.000518p+0,
  0x1.cd1cc6p+1,
  0x1.0008d2p+0,
  0x1.00291cp+0,
  0x1.01ae5cp+0,
  0x1.18229cp+0,
  0x1.0000d6p+0,
  0x1.00017p+0,
  0x1.1083fep-25,
  0x1p+0,
  0x1.7d379ap+9,
  0x1.2f5e0ep-1,
  0x1.365e38p+0,
  0x1.000912p+0,
  0x1.8p+3,
  0x1.13e39cp+1,
  0x1p+0,
  0x1.0ba4aep+0,
  0x1.9deafcp+3,
  0x1.2fead4p-1,
  0x1p+0,
  0x1.11a49cp+16,
  0x1.968f3ap+62,
  0x1p+0,
  0x1p+0,
  0x1p+0,
  0x1.b85f8ep+6,
  0x1.141a8ep+8,
  0x1.0564ecp+0,
  0x1.c6b168p+2,
  0x1.05b106p+8,
  0x1.000298p+0,
  0x1p+0,
  0x1.0001fap+0,
  0x1.000164p+0,
  0x1.31a84p+0,
  0x1p+0,
  0x1.403f5cp+5,
  0x1.ea62dep-1,
  0x1p+0,
  0x1.131eeep+1,
  0x1.3625d8p+4,
  0x1.066f0cp+0,
  0x1.e7a64p+7,
  0x1.047e06p+0,
  0x1p+0,
  0x1.32aad8p-1,
  0x1p+0,
  0x1.000118p+0,
  0x1.1b0d0cp+6,
  0x1.a11c9p+0,
  0x1.a2588ep+54,
  0x1p+0,
  0x1p+0,
  0x1.09ffa8p+8,
  0x1.bb2a7cp+5,
  0x1p+0,
  0x1.a1f9p+0,
  0x1p+0,
  0x1.f3d4b4p-1,
  0x1.4dc16ap+5,
  0x1.3b2274p+4,
  0x1.457d56p+0,
  0x1.01cfcp+0,
  0x1p+0,
  0x1.a93982p+2,
  0x1.04054cp+0,
  0x1.0080fap+0,
  0x1.dc801cp+0,
  0x1.0b77bep+1,
  0x1.013094p+0,
  0x1.0001e8p+0,
  0x1.02e2ep+0,
  0x1p+0,
  0x1.000094p+0,
  0x1.fb4382p-1,
  0x1.00019p+0,
  0x1.0007b8p+0,
  0x1.127e1ap+8,
  0x1p+0,
  0x1p+0,
  0x1.0e25cp+1,
  0x1.2f4b78p+1,
  0x1.015b26p+8,
  0x1.0eb20cp+0,
  0x1.081558p+7,
  0x1.42ff58p+0,
  0x1.1c5d1p+6,
  0x1.887b42p+14,
  0x1.02904p+1,
  0x1.7ce25ap+1,
  0x1.f96d6p-1,
  0x1.5c64f4p+0,
  0x1.0005c8p+0,
  0x1.78e9d4p-33,
  0x1.da628ep+4,
  0x1.003634p+0,
  0x1.3184d6p-1,
  0x1.bd96f4p+6,
  0x1.ba5156p+12,
  0x1.8df4acp+0,
  0x1p+0,
  0x1.a3b92p+7,
  0x1.3e4f26p+11,
  0x1.543868p+4,
  0x1.eabfe6p+0,
  0x1.0073e6p+0,
  0x1.0f2bdep+8,
  0x1.3e3c3ep+13,
  0x1.3884dp+6,
  0x1p+0,
  0x1.690fecp+0,
  0x1.dfa074p-1,
  0x1.000638p+0,
  0x1.4a93acp+1,
  0x1.8dd68ap+0,
  0x1.0048dcp+0,
  0x1.002f8ep+0,
  0x1.00015p+0,
  0x1.45abbcp+0,
  0x1.f3f306p-1,
  0x1.1b639p+0,
  0x1.ef2d1p-84,
  0x1.abd54p+0,
  0x1.36f8aap+2,
  0x1.e317cep-1,
  0x1.36f9cap+2,
  0x1.530ddp+0,
  0x1.2f74bp+0,
  0x1.3c4448p+0,
  0x1.0718dcp+0,
  0x1.0001bp+0,
  0x1p+0,
  0x1.1d3ebap+4,
  0x1.42e55ap+0,
  0x1.3ace3ep+50,
  0x1.5b5108p+1,
  0x1.13527cp+3,
  0x1.0002ap+0,
  0x1.6f3ebcp+2,
  0x1.b0af06p+7,
  0x1.016c28p+0,
  0x1p+0,
  0x1.4542a6p+0,
  0x1p+0,
  0x1.6120cep+55,
  0x1.02a2p+0,
  0x1.0714d6p+15,
  0x1.21293ep+0,
  0x1.023b38p+0,
  0x1.000d12p+0,
  0x1.4d9f06p+15,
  0x1p+0,
  0x1.dd3bb4p-1,
  0x1p+0,
  0x1.00029ep+0,
  0x1.eabfa8p+0,
  0x1.362a2ep+0,
  0x1.000a5ap+48,
  0x1.dfbac8p+4,
  0x1.259742p+3,
  0x1.0000acp+0,
  0x1.00cc58p+1,
  0x1.49155ep+0,
  0x1p+0,
  0x1p+0,
  0x1.30d9ap-1,
  0x1.02fc6p+0,
  0x1.3cac76p+0,
  0x1.b8c472p+1,
  0x1.8bf1bcp+5,
  0x1.2cd56p+0,
  0x1.1d37a6p+0,
  0x1p+0,
  0x1.6b03dep+2,
  0x1p+0,
  0x1.4bc794p+0,
  0x1.dc56e6p+1,
  0x1.b1432ap+0,
  0x1.5a6574p+2,
  0x1.a21356p+4,
  0x1.6269ep+64,
  0x1.0000dp+0,
  0x1.10766cp+7,
  0x1.0096e6p+0,
  0x1.adf486p+0,
  0x1.309de8p-1,
  0x1.085fb4p+0,
  0x1.3afb0ep+0,
  0x1.0002a2p+0,
  0x1.085208p+0,
  0x1.213daap+8,
  0x1.000a5ap+0,
  0x1.503f0cp+0,
  0x1.000428p+0,
  0x1.7ee7d4p+16,
  0x1.8e5064p+61,
  0x1.3f6054p+7,
  0x1.3a78a6p+0,
  0x1.0a197ap+0,
  0x1.016ea8p+0,
  0x1.0bbb28p+8,
  0x1.000014p+0,
  0x1.0010d4p+0,
  0x1.5983f8p-26,
  0x1.2dddep+0,
  0x1.3f4af4p+0,
  0x1.15f078p+0,
  0x1p+0,
  0x1.8ffae8p-20,
  0x1.0000a4p+0,
  0x1.4f32a8p+0,
  0x1.8bf1f2p+5,
  0x1.0000fp+0,
  0x1.1e9612p+0,
  0x1.000512p+0,
  0x1.000184p+0,
  0x1p+0,
  0x1.4a071ap+5,
  0x1.316586p-1,
  0x1.026922p+0,
  0x1.9323dcp+3,
  0x1.0530acp+0,
  0x1.18125p+0,
  0x1.e39054p-1,
  0x1.3ad2p+11,
  0x1.005ad4p+0,
  0x1.000208p+0,
  0x1.b85f4cp+6,
  0x1.002d02p+0,
  0x1p+0,
  0x1p+0,
  0x1.da3556p+8,
  0x1p+0,
  0x1.02c298p+0,
  0x1.11a35ep+3,
  0x1.4a0a02p+1,
  0x1.02741p+2,
  0x1p+0,
  0x1.2749a2p+0,
  0x1.45abacp+0,
  0x1p+0,
  0x1.3920bcp+13,
  0x1.000054p+0,
  0x1.4ceda8p+0,
  0x1p+0,
  0x1.390b2p+7,
  0x1.66764ep+7,
  0x1p+0,
  0x1.e11478p+7,
  0x1.0f264cp+0,
  0x1p+0,
  0x1.2f7ec2p-1,
  0x1p+0,
  0x1.0ac6fcp+8,
  0x1.3ca396p+0,
  0x1.9ad138p+5,
  0x1.e5b8acp+7,
  0x1.0000b8p+0,
  0x1.f14fd6p-11,
  0x1.00009p+0,
  0x1.01571ep+0,
  0x1.17c726p+0,
  0x1.00019p+0,
  0x1.362514p+4,
  0x1.004efp+0,
  0x1.003f5cp+0,
  0x1.43c41cp+0,
  0x1p+0,
  0x1.3e6c78p+12,
  0x1.000c5cp+0,
  0x1.3e795cp+6,
  0x1.b825a6p+7,
  0x1.ace64p+1,
  0x1.36f8dp+2,
  0x1.587484p+0,
  0x1.94967ap+14,
  0x1.af98e6p+17,
  0x1.6488b6p+0,
  0x1.1d3e98p+4,
  0x1.009978p+0,
  0x1.377d08p+0,
  0x1.2fdc0ep+0,
  0x1.045768p+0,
  0x1.f9ef1ap+0,
  0x1.003e4ap+0,
  0x1.3e825p+9,
  0x1.38da1p+0,
  0x1p+0,
  0x1p+0,
  0x1.00d4a2p+0,
  0x1.3e6838p+12,
  0x1.0c24a8p+0,
  0x1.00012cp+0,
  0x1p+0,
  0x1p+0,
  0x1.001188p+0,
  0x1.30be32p-1,
  0x1.d20bfcp+0,
  0x1.000314p+0,
  0x1.467b6ap+1,
  0x1.b14436p+0,
  0x1.be3eccp+7,
  0x1.035cc4p+0,
  0x1p+0,
  0x1.358ca4p+7,
  0x1p+0,
  0x1.052ef8p+8,
  0x1.08ac7ep+0,
  0x1p+0,
  0x1.ef2d1p-84,
  0x1p+0,
  0x1.388d04p+56,
  0x1.003836p+0,
  0x1.65f1ecp+0,
  0x1.5b141p+47,
  0x1.fadea2p+0,
  0x1.d1e872p+59,
  0x1p+0,
  0x1.acd704p+0,
  0x1.d46c0ap-34,
  0x1p+0,
  0x1.015a84p+0,
  0x1p+0,
  0x1p+0,
  0x1.02161ep+0,
  0x1p+0,
  0x1.02283cp+0,
  0x1.2fb3d8p+2,
  0x1.3b1854p+4,
  0x1.9a69d8p+48,
  0x1.f9ef08p+0,
  0x1.7e849cp+3,
  0x1.eabffp+0,
  0x1.054884p+0,
  0x1.9faadcp+7,
  0x1.01dbfep+0,
  0x1.a9a6aap+1,
  0x1p+0,
  0x1.ae82b2p+5,
  0x1.423f6p-20,
  0x1.42e57p+0,
  0x1.41466p+2,
  0x1p+0,
  0x1.49ef3ep+4,
  0x1.f264ccp-1,
  0x1.0084dap+0,
  0x1.07aabap+0,
  0x1p+0,
  0x1p+0,
  0x1.009f06p+0,
  0x1.008b44p+0,
  0x1.3e2b8cp+5,
  0x1.000324p+0,
  0x1.0c4158p+0,
  0x1.32644cp-1,
  0x1.1929dp+5,
  0x1.8ac548p+4,
  0x1.01b036p+0,
  0x1.7e3a98p+5,
  0x1.34bc8p-1,
  0x1.b14336p+0,
  0x1.0cb4e2p+0,
  0x1.b931bp+12,
  0x1.2358fp+1,
  0x1.f23b6cp+51,
  0x1p+0,
  0x1.16fa4cp+4,
  0x1.0baf84p+0,
  0x1.a856a8p+5,
  0x1.066f6p+0,
  0x1p+0,
  0x1p+0,
  0x1.20b7bp+0,
  0x1.3fe392p+0,
  0x1.388ae2p+0,
  0x1.00035cp+0,
  0x1.3adcf2p+12,
  0x1.30393p-1,
  0x1.e17338p+1,
  0x1.aa6b1ap+7,
  0x1.0000b6p+0,
  0x1p+0,
  0x1.345b46p-1,
  0x1.74921cp+8,
  0x1.b29bd6p+7,
  0x1p+0,
  0x1.77c706p+2,
  0x1.c4d8ecp+65,
  0x1.8d98bp+0,
  0x1.8b8002p-6,
  0x1.3881ecp+15,
  0x1.010cd4p+0,
  0x1.c8fdaap+7,
  0x1.72b958p+2,
  0x1.965c1cp+3,
  0x1p+0,
  0x1p+0,
  0x1.2a515cp+0,
  0x1.cd1e9p+1,
  0x1.006674p+0,
  0x1p+0,
  0x1.66e4cp+2,
  0x1.13aa9ep+8,
  0x1p+0,
  0x1.13101cp+1,
  0x1.0004ecp+0,
  0x1p+0,
  0x1.c51ad2p+7,
  0x1p+0,
  0x1.2a0908p+8,
  0x1.000182p+0,
  0x1.ac40fcp+2,
  0x1.30f308p-1,
  0x1p+0,
  0x1p+0,
  0x1.1ceeaep+7,
  0x1.0000a4p+0,
  0x1.f407acp+7,
  0x1.36f98ep+2,
  0x1.1c60a8p+10,
  0x1.617238p+12,
  0x1p+0,
  0x1.48fb3ap+0,
  0x1p+0,
  0x1.000d5p+0,
  0x1.33833cp-1,
  0x1p+0,
  0x1.41be46p+51,
  0x1.238e58p+0,
  0x1.00266cp+0,
  0x1.9fc4bp+58,
  0x1.000618p+0,
  0x1.88a592p+48,
  0x1.0001c8p+0,
  0x1p+0,
  0x1.51c89cp+0,
  0x1.317344p+7,
  0x1.308e8ap-1,
  0x1p+0,
  0x1.0387e6p+0,
  0x1.454a32p+0,
  0x1.74a828p+7,
  0x1.f57daep-8,
  0x1.287a44p+0,
  0x1.b84b08p+2,
  0x1.27fc5ap+0,
  0x1p+0,
  0x1.0e423p+1,
  0x1p+0,
  0x1.079ddp+0,
  0x1.f49a74p+14,
  0x1.0f47bp+0,
  0x1.9000bap+4,
  0x1.000244p+0,
  0x1p+0,
  0x1.4a38ep+0,
  0x1.36f8bp+2,
  0x1.6bf43cp+0,
  0x1.a3a9f4p+1,
  0x1.001d24p+0,
  0x1.106f8ap+0,
  0x1.0003ep+0,
  0x1.00025p+0,
  0x1.89be24p+0,
  0x1.3d65b4p+6,
  0x1.44b46ep+0,
  0x1.5caecap+1,
  0x1.00327cp+2,
  0x1.54bbep+2,
  0x1.2597aap+3,
  0x1.059a5ap-11,
  0x1.43884ep+2,
  0x1p+0,
  0x1.c04628p+9,
  0x1p+0,
  0x1.c1b9bp-49,
  0x1.73ed24p+2,
  0x1.000598p+0,
  0x1.44105p+0,
  0x1.b7c192p+5,
  0x1.312178p-1,
  0x1p+0,
  0x1.f9efc2p+0,
  0x1.014252p-51,
  0x1.017a66p+0,
  0x1.1f3de4p+8,
  0x1.02b182p+0,
  0x1.257372p+0,
  0x1.93944ap+48,
  0x1.e2305cp+1,
  0x1.3e0ee6p-8,
  0x1.00011ep+0,
  0x1.a31448p+5,
  0x1.8c9ca6p+48,
  0x1.194216p+0,
  0x1p+0,
  0x1.5cc2ap+2,
  0x1p+0,
  0x1.506fe6p+49,
  0x1.2588fp+0,
  0x1.26ffaep+1,
  0x1p+0,
  0x1p+0,
  0x1.4ff01ap+66,
  0x1.00009cp+0,
  0x1.000f38p+0,
  0x1.00e4d6p+0,
  0x1.001d5cp+0,
  0x1.02b29cp+50,
  0x1.358d1p+7,
  0x1.3eff02p+8,
  0x1.900058p+4,
  0x1.3ae0bcp+13,
  0x1.034d3ep+0,
  0x1.b9346p+5,
  0x1p+0,
  0x1.71b9cp+0,
  0x1.2f7456p+0,
  0x1.47ccf2p+0,
  0x1.498974p+0,
  0x1.046cb8p+0,
  0x1.458c62p+1,
  0x1.a93bf4p+2,
  0x1.0f113ap+8,
  0x1p+0,
  0x1.04ae52p+0,
  0x1.7c2a68p+0,
  0x1.3b24fep+9,
  0x1.04ef5p-11,
  0x1.11a28ap+3,
  0x1p+0,
  0x1.056b24p+1,
  0x1.0000e4p+0,
  0x1.2c01cap+0,
  0x1p+0,
  0x1p+0,
  0x1.c61f72p+15,
  0x1p+0,
  0x1.02fc2ap+0,
  0x1p+0,
  0x1.093acep+0,
  0x1.5643eap+53,
  0x1p+0,
  0x1.0087a8p-47,
  0x1.2f5868p+0,
  0x1.38e848p+10,
  0x1.e5c11cp+7,
  0x1p+0,
  0x1.129e64p+8,
  0x1.5c6c98p+1,
  0x1.00015ap+0,
  0x1.b745e2p+48,
  0x1.1bfb08p+0,
  0x1.a92b86p+5,
  0x1.7c2a54p+0,
  0x1p+0,
  0x1.3334b6p+0,
  0x1.b5c006p+5,
  0x1p+0,
  0x1.bec8c6p+16,
  0x1p+0,
  0x1.dc5496p-1,
  0x1.0a88ep+0,
  0x1.f95e78p+1,
  0x1p+0,
  0x1.0037b4p+0,
  0x1.1eaf62p+8,
  0x1p+0,
  0x1.43bfcp+5,
  0x1.3af986p+15,
  0x1.03dbf4p+0,
  0x1.b1b5a8p-12,
  0x1p+0,
  0x1.90007ep+0,
  0x1.0003b4p+0,
  0x1p+0,
  0x1.f8f086p-12,
  0x1.dd7178p+4,
  0x1.00207p+0,
  0x1.118916p+0,
  0x1p+0,
  0x1.a298c4p+7,
  0x1.006a6cp+0,
  0x1.1dfa5p+0,
  0x1.327c54p-1,
  0x1p+0,
  0x1.f7e922p-1,
  0x1.3e365ap+13,
  0x1p+0,
  0x1.04318ap+0,
  0x1.52381cp+0,
  0x1.60a298p-1,
  0x1.000076p+0,
  0x1.977c42p+14,
  0x1.a8cb5cp+7,
  0x1.1b0d18p+6,
  0x1.29cedp+0,
  0x1.15a46ap+1,
  0x1p+0,
  0x1.639aaep-12,
  0x1.004a8cp+0,
  0x1.0ab1bcp+1,
  0x1.b85ecp+6,
  0x1.36279ep+4,
  0x1.22ae32p+8,
  0x1.615228p+1,
  0x1.000898p+0,
  0x1.001968p+0,
  0x1p+0,
  0x1.2f791ap-1,
  0x1.00001cp+0,
  0x1p+0,
  0x1.0627aep+0,
  0x1.0e38d4p+5,
  0x1.490936p+57,
  0x1p+0,
  0x1.000358p+0,
  0x1.57b4bp+7,
  0x1.4b4766p+0,
  0x1.26da06p+0,
  0x1.cd1ec6p+1,
  0x1.38ee44p+15,
  0x1.c0ffbcp+15,
  0x1.01caacp+0,
  0x1.e2a336p-1,
  0x1p+0,
  0x1.0c69f4p+2,
  0x1.50a08cp+55,
  0x1.10d0b8p+0,
  0x1.1eed7p+1,
  0x1.b14428p+0,
  0x1.004f94p+0,
  0x1.31c2acp-1,
  0x1p+0,
  0x1p+0,
  0x1p+0,
  0x1.b47948p+0,
  0x1.78d5eap+51,
  0x1.01316ep+0,
  0x1.4a937cp+0,
  0x1.1ba54ap+1,
  0x1.6ba304p+0,
  0x1.3591c6p-1,
  0x1p+0,
  0x1.08a91ap+8,
  0x1.19ade8p+0,
  0x1.01535ap+0,
  0x1.317184p-1,
  0x1.36f9a4p+2,
  0x1.7f08a8p+0,
  0x1p+0,
  0x1.00013p+0,
  0x1.ff478p-1,
  0x1.27e0d2p+0,
  0x1.0ecbacp+7,
  0x1.8dd6acp+0,
  0x1.100ecep+0,
  0x1.25edd8p+8,
  0x1.198a9p+0,
  0x1p+0,
  0x1.5c6cc2p+1,
  0x1.016276p+0,
  0x1.329f88p-1,
  0x1.9e35ap+0,
  0x1.004612p+0,
  0x1.fb9b82p-1,
  0x1.000d84p+0,
  0x1.43e8a8p+0,
  0x1.57e548p+1,
  0x1.057f18p+0,
  0x1.a6dfbep+7,
  0x1p+0,
  0x1.341ce2p-1,
  0x1p+0,
  0x1p+0,
  0x1.fcbce2p+56,
  0x1.004454p+0,
  0x1.909ec2p-6,
  0x1p+0,
  0x1.58649p+9,
  0x1.4b96e6p+49,
  0x1.3ca38cp+0,
  0x1.00033ep+0,
  0x1.0099f4p+0,
  0x1p+0,
  0x1.21869p+8,
  0x1p+0,
  0x1.65b514p+16,
  0x1p+0,
  0x1.740878p+3,
  0x1.a4cea2p+43,
  0x1.b143fep+0,
  0x1.25ed36p+4,
  0x1.003d7ap+0,
  0x1.0d82d4p+1,
  0x1.3389ap-1,
  0x1p+0,
  0x1.11a222p+3,
  0x1.983f38p+3,
  0x1.000162p+0,
  0x1.46b986p+0,
  0x1.3e3e9cp+8,
  0x1.58747p+0,
  0x1.45632cp+0,
  0x1.3f738cp+3,
  0x1.00d0bp+0,
  0x1.5dca1p+0,
  0x1p+0,
  0x1.43257p+0,
  0x1.0b38fap+0,
  0x1.1ca4aep+8,
  0x1p+0,
  0x1p+0,
  0x1.319a2p-1,
  0x1.2d4fd4p+5,
  0x1.02f006p+0,
  0x1.e0c05ap+4,
  0x1.98f464p+0,
  0x1.05db3ap+8,
  0x1.a2bd9ep+2,
  0x1.a05a58p+0,
  0x1.8bf254p+5,
  0x1.3eb04cp+4,
  0x1.3140a6p-1,
  0x1.011d98p+0,
  0x1p+0,
  0x1.000ac8p+0,
  0x1.3b2774p+10,
  0x1.44d29p+0,
  0x1p+0,
  0x1.009f9ep+0,
  0x1.0a8702p+2,
  0x1.1349bep+1,
  0x1.a585b4p+7,
  0x1.00f23cp+0,
  0x1.338168p+0,
  0x1p+0,
  0x1.3e7816p+14,
  0x1.0e9d14p+0,
  0x1.8f53ccp+1,
  0x1.28c922p+0,
  0x1.6bb30ep+15,
  0x1.b58932p+14,
  0x1.1c682p+0,
  0x1.00846p+0,
  0x1.00240cp+0,
  0x1.000674p+0,
  0x1.2c71ep+3,
  0x1.750298p+67,
  0x1.364684p+0,
  0x1.134676p+16,
  0x1.47a244p+0,
  0x1p+0,
  0x1.dee22ep-1,
  0x1.3e8204p+9,
  0x1.00007p+0,
  0x1.31f1e6p-1,
  0x1p+0,
  0x1.a187f8p+7,
  0x1.0097e4p+0,
  0x1.08e1b2p+0,
  0x1.0e3e7ap+0,
  0x1.0006fap+0,
  0x1p+0,
  0x1.358ca6p+7,
  0x1.83bcacp+3,
  0x1.4603f4p+0,
  0x1.3093c8p+0,
  0x1.5c6cap+1,
  0x1.1f5efcp+0,
  0x1.6ba3e8p+0,
  0x1.cba7b2p+7,
  0x1.015e1ep+0,
  0x1.b85f58p+6,
  0x1.dc835ep+1,
  0x1.000598p+0,
  0x1.f9551ap-1,
  0x1p+0,
  0x1p+0,
  0x1.0a67fp+0,
  0x1.1bdf58p+0,
  0x1.f75026p-1,
  0x1.5e3b5p+1,
  0x1.3f9b72p+0,
  0x1.8ff798p-51,
  0x1.0115bap+0,
  0x1.4e13fcp+0,
  0x1.6d6c54p+5,
  0x1.0e7538p+0,
  0x1.dcf5d8p-12,
  0x1.134aa6p+1,
  0x1.b7cc8p+12,
  0x1.3e46dap+12,
  0x1p+0,
  0x1.3fb2fep+0,
  0x1p+0,
  0x1p+0,
  0x1.0f8834p+0,
  0x1p+0,
  0x1.2f8fc8p-1,
  0x1.0032aap+0,
  0x1.0134d4p+0,
  0x1.0006ecp+0,
  0x1.36f9b8p+2,
  0x1.d32d7p+43,
  0x1.65f516p+1,
  0x1.a71662p+5,
  0x1.02731cp+2,
  0x1.00002cp+0,
  0x1.090ap+0,
  0x1.8ce46ep+6,
  0x1.0001bp+0,
  0x1.003c82p+0,
  0x1.a2cb78p+5,
  0x1.1b3cc6p+0,
  0x1p+0,
  0x1.000698p+0,
  0x1p+0,
  0x1p+0,
  0x1.0a01d2p+50,
  0x1.000b52p+0,
  0x1.63092ep+0,
  0x1.0011fcp+0,
  0x1.684b74p+2,
  0x1.782834p+49,
  0x1.213286p+0,
  0x1.2b13b6p+9,
  0x1.383ep+0,
  0x1.f91f5cp+2,
  0x1.bf1f3cp+7,
  0x1.3e44f4p+7,
  0x1p+0,
  0x1.4637a4p+0,
  0x1.3e8c48p+12,
  0x1.192a3cp+8,
  0x1.0008c2p+0,
  0x1p+0,
  0x1.01a4b6p+8,
  0x1.0002d8p+0,
  0x1.001054p-6,
  0x1p+0,
  0x1.275d2cp+0,
  0x1.320582p-1,
  0x1.02643ep+0,
  0x1.aa4074p+5,
  0x1.02528cp+0,
  0x1.0adc1p+7,
  0x1.e25f42p-1,
  0x1p+0,
  0x1.0076ap+0,
  0x1.0008acp+0,
  0x1.783ba4p+3,
  0x1.01af66p+0,
  0x1.192eep+0,
  0x1.132ea6p+7,
  0x1.a93964p+2,
  0x1.9bc85p+14,
  0x1.1e3f46p+8,
  0x1.1d8db6p+13,
  0x1.0007cap+0,
  0x1.2fa568p-1,
  0x1.3e8fd4p+12,
  0x1.2f5bf6p-1,
  0x1.a0994cp+14,
  0x1.7ed6b2p+0,
  0x1.0f2b1ap+0,
  0x1.4ab6e6p+1,
  0x1.04c838p+8,
  0x1.000034p+0,
  0x1p+0,
  0x1.eadcd6p-1,
  0x1.00008p+0,
  0x1.12103cp-1,
  0x1p+0,
  0x1p+0,
  0x1.2f93bp-1,
  0x1.7b4b16p+5,
  0x1.38fe8cp+6,
  0x1p+0,
  0x1.36f96cp+2,
  0x1.716462p+39,
  0x1.000048p+0,
  0x1.7c680ep+4,
  0x1p+0,
  0x1.28cbfap+0,
  0x1.a416eap+41,
  0x1p+0,
  0x1.57e51p+1,
  0x1.0004f4p+0,
  0x1p+0,
  0x1.3167b6p-1,
  0x1.984032p+3,
  0x1.04f21ep+0,
  0x1p+0,
  0x1.73ed4p+2,
  0x1.0f4eb8p+8,
  0x1p+0,
  0x1.2df9p+5,
  0x1.54bbf8p+2,
  0x1.0bf9a4p+0,
  0x1.a91d34p+63,
  0x1.130ed8p+0,
  0x1p+0,
  0x1.00036ap+0,
  0x1.3ae7aep+8,
  0x1.16524ap+8,
  0x1.9f774ap+0,
  0x1.ba601cp+2,
  0x1.bb2f0cp+12,
  0x1.a93bd4p+2,
  0x1.32e318p+0,
  0x1.0ab44ap+0,
  0x1p+0,
  0x1.2f871ep-1,
  0x1p+0,
  0x1.a78356p+7,
  0x1.001e8cp+0,
  0x1.4a08dap+5,
  0x1.069e1cp+0,
  0x1.e3e184p+1,
  0x1.f60012p+18,
  0x1p+0,
  0x1.b8600ep+6,
  0x1.300bc6p-1,
  0x1.76f83cp+6,
  0x1.16f978p+0,
  0x1.0003a4p+0,
  0x1.0b4f22p+7,
  0x1.37409cp+0,
  0x1p+0,
  0x1.3e95dp+12,
  0x1.00098p+0,
  0x1.004038p+0,
  0x1.301bfep-1,
  0x1p+0,
  0x1.9c872ep+0,
  0x1.378344p+16,
  0x1.18c55cp+0,
  0x1.274a0ep-20,
  0x1.2811b2p+0,
  0x1p+0,
  0x1.ba668cp+12,
  0x1.7f2c8ap+13,
  0x1.0f72fcp+8,
  0x1.6308a6p+0,
  0x1.b0cac6p+13,
  0x1.4837p+0,
  0x1p+0,
  0x1.40bd6cp+0,
  0x1p+0,
  0x1.39133p+12,
  0x1.c62f4cp+46,
  0x1.0004bcp+0,
  0x1.12257ap+8,
  0x1p+0,
  0x1.85645cp+9,
  0x1.4cb85ep+0,
  0x1p+0,
  0x1.a234a8p-1,
  0x1p+0,
  0x1p+0,
  0x1.3cf408p-27,
  0x1.0e263ep+1,
  0x1.00026p+0,
  0x1p+0,
  0x1p+0,
  0x1.332f2cp-1,
  0x1.04bb28p+0,
  0x1.4a67cap+0,
  0x1.0003dcp+0,
  0x1p+0,
  0x1.3482d4p-1,
  0x1.134a04p+1,
  0x1p+0,
  0x1.9000ecp+4,
  0x1p+0,
  0x1.2f4e26p-1,
  0x1.0395dp+9,
  0x1.38dbb4p+11,
  0x1p+0,
  0x1.049432p+0,
  0x1.1a9a96p+8,
  0x1.54bcd2p+2,
  0x1.14487cp+0,
  0x1.020458p+0,
  0x1.000b9p+0,
  0x1.32254cp-1,
  0x1.73ed2ep+2,
  0x1p+0,
  0x1.3d8be4p+0,
  0x1.3e96d4p+15,
  0x1.ffa44cp-1,
  0x1.11a334p+3,
  0x1.08317p+0,
  0x1.000238p+0,
  0x1.3e498p+9,
  0x1.3389eap-1,
  0x1.36f9ccp+2,
  0x1.0bbe0ap+0,
  0x1.0b53f4p+8,
  0x1p+0,
  0x1.0e42d2p+0,
  0x1.d22332p+18,
  0x1p+0,
  0x1.05197ep+0,
  0x1.205a74p+1,
  0x1p+0,
  0x1.0086dp+0,
  0x1p+0,
  0x1.296a6cp+0,
  0x1.7ced1p+2,
  0x1p+0,
  0x1p+0,
  0x1.0053eep+0,
  0x1.09c5dcp+0,
  0x1p+0,
  0x1.a07194p+9,
  0x1.0a151ap+0,
  0x1.01e6ccp+0,
  0x1.ef2d1p-84,
  0x1.8eb89cp+3,
  0x1.15dbb6p+0,
  0x1.00307ap+0,
  0x1.03571ep+0,
  0x1.f5292ep-1,
  0x1.59f064p+0,
  0x1.0e26a8p+1,
  0x1.6d6ab4p+5,
  0x1.7ad0fcp+6,
  0x1.40fc28p+0,
  0x1.c6b9p+14,
  0x1.071bfcp+0,
  0x1.b0cb28p+7,
  0x1.1614b2p+1,
  0x1.4bdc7ep+0,
  0x1.358db8p+7,
  0x1.405dp+3,
  0x1.0461d4p+0,
  0x1p+0,
  0x1.a8b5b2p+7,
  0x1.130dbap+7,
  0x1.259792p+3,
  0x1.2fcf92p-1,
  0x1.0092d2p+0,
  0x1.0fea96p+0,
  0x1.000024p+0,
  0x1.a0abccp+5,
  0x1.3b1076p+0,
  0x1.192914p+5,
  0x1.85f5dap-9,
  0x1.0b2ae8p+0,
  0x1.dc84ap+1,
  0x1.2121acp+8,
  0x1.b144fep+0,
  0x1.131a68p+1,
  0x1.28131p+0,
  0x1.35dc48p+5,
  0x1.b81b5p-51,
  0x1.0a1caep+0,
  0x1.f9ef34p+0,
  0x1.95da52p+0,
  0x1p+0,
  0x1.3032a2p-1,
  0x1.1cc56ep+0,
  0x1.c77bfcp+0,
  0x1.05370ep+0,
  0x1.d6d0c6p+2,
  0x1.2fbfap-1,
  0x1p+0,
  0x1.0000b8p+2,
  0x1.b8c316p+1,
  0x1.00010cp+0,
  0x1.028104p+0,
  0x1p+0,
  0x1.13f12cp+0,
  0x1p+0,
  0x1p+0,
  0x1.fb7e4ep+53,
  0x1p+0,
  0x1.780d04p+9,
  0x1.1973c4p+6,
  0x1.b09184p+0,
  0x1.b4ed32p+51,
  0x1p+0,
  0x1.00b82p+0,
  0x1.198ba4p+0,
  0x1.57b63cp+7,
  0x1.0016d4p+0,
  0x1p+0,
  0x1.01a3e4p+0,
  0x1.e8d11ep+44,
  0x1.b7e5d4p+13,
  0x1.00667cp+0,
  0x1.06ed08p+0,
  0x1.05f47ap+0,
  0x1.4aa86ap+0,
  0x1.04aeap+0,
  0x1p+0,
  0x1p+0,
  0x1.3b13a8p+11,
  0x1.596846p+47,
  0x1.0d8c64p+0,
  0x1.0012aap+0,
  0x1p+0,
};
