/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

static data_1_1_t<double, double> g_log10_intel_data[] = {
  { // Entry 0
    -0x1.a7d9a8edb47be8052ee10d61f72bedb3p3,
    0x1.0000000000001p-44
  },
  { // Entry 1
    -0x1.b64cb76a2c1767fe0cb381da5b9ce962p6,
    0x1.0000000000001p-364
  },
  { // Entry 2
    -0x1.ce61cf8e9227b7ffbbc2258f06b00848p-1,
    0x1.000000007p-3
  },
  { // Entry 3
    -0x1.ce61cf8e9227b7ffd109efcb25d89632p0,
    0x1.00000000ep-6
  },
  { // Entry 4
    0x1.dd4f85658431780003c8d7bebe51f836p-33,
    0x1.0000000225863p0
  },
  { // Entry 5
    -0x1.815182473f60d80043383683153332aap3,
    0x1.0000006p-40
  },
  { // Entry 6
    -0x1.c4bfc5e08f300001961133d67a8ae8f8p5,
    0x1.000001cp-188
  },
  { // Entry 7
    -0x1.3428e5a6db26b002262970cb294f81p0,
    0x1.00380p-4
  },
  { // Entry 8
    -0x1.8a593abb7a102800f94e99ea178864eep7,
    0x1.00380p-655
  },
  { // Entry 9
    0x1.e1a95d2d9ba1dfa58b2f8e5fdf0a1b54p4,
    0x1.0080402010080p100
  },
  { // Entry 10
    0x1.fdc9fc7b9d3258675b494256b7928fc6p-11,
    0x1.0092e4b92e4a0p0
  },
  { // Entry 11
    0x1.159c1712e74c68277fba58fe711f8027p-10,
    0x1.00ap0
  },
  { // Entry 12
    0x1.bd94e520279af862fe39c005f4682635p-10,
    0x1.01010p0
  },
  { // Entry 13
    0x1.828f82071564e84adb4af8ee9eed7b5ep-9,
    0x1.01be8f10cdap0
  },
  { // Entry 14
    0x1.9fb8cdcda6c2645e174538ea88aed24ap-9,
    0x1.01e05e9614213p0
  },
  { // Entry 15
    0x1.a37a0053a01f959dff9d7ed8c0738223p-9,
    0x1.01e4b95a8d930p0
  },
  { // Entry 16
    0x1.a605801cb85f27525bcda3da5f201ad1p-9,
    0x1.01e7acfc057dap0
  },
  { // Entry 17
    0x1.a619cc7168fac569791c99d75180265dp-9,
    0x1.01e7c4870a56dp0
  },
  { // Entry 18
    0x1.bafb8ddcf618275fe4ba979af560a660p-9,
    0x1.01fffe0p0
  },
  { // Entry 19
    0x1.cf3f4e32847f4ffcdca9e1a8a08a4547p0,
    0x1.020p6
  },
  { // Entry 20
    0x1.bafd4774dbc9b71fc01c9b281b1290d1p-9,
    0x1.020000006p0
  },
  { // Entry 21
    0x1.bbaa41582bd4b75516bf1e86eef4bba8p-9,
    0x1.0200c8b461357p0
  },
  { // Entry 22
    0x1.ec0d5a07492628986cc18f5d6a668867p-9,
    0x1.0238f392a2110p0
  },
  { // Entry 23
    0x1.4c9795fd1f7e88009e3273bf7835f084p-7,
    0x1.060dae8131baap0
  },
  { // Entry 24
    0x1.78b4ee43af1c080139a43926058a6e46p-7,
    0x1.06ddf6ab94edcp0
  },
  { // Entry 25
    -0x1.93ca96452c85680041ebe338f63d139ap2,
    0x1.076899d38cc30p-21
  },
  { // Entry 26
    0x1.ab09f93221f40000194c663bebd78f55p-7,
    0x1.07cc640f96a18p0
  },
  { // Entry 27
    0x1.6671b365d15bb76f5080cc3658e2519ep-6,
    0x1.0d39f5fc24fa3p0
  },
  { // Entry 28
    0x1.671a9b1bc6da7fffc947cfdb4dd24e3ap-6,
    0x1.0d405a1bfe7p0
  },
  { // Entry 29
    0x1.dd9de2ebee648801272900e785c996b3p-6,
    0x1.11c602d8a1b64p0
  },
  { // Entry 30
    0x1.4b55b84c74ca87ff3d23b3b83347c50fp-1,
    0x1.1c0p2
  },
  { // Entry 31
    -0x1.9897e85148d75fffff988e06dd8eae5ep4,
    0x1.1f8b0260ccc08p-85
  },
  { // Entry 32
    -0x1.ffbfc2bbc780375837c4b0b84f38a14ap-3,
    0x1.2p-1
  },
  { // Entry 33
    0x1.de288434c35c582817ddb245949a59a7p-5,
    0x1.24d3540217b15p0
  },
  { // Entry 34
    -0x1.ee30e065377edd211ae67f49d114a8dep-3,
    0x1.25bde8b09bc9fp-1
  },
  { // Entry 35
    -0x1.bef28412a9d80800871c59a8425d3aa6p0,
    0x1.262p-6
  },
  { // Entry 36
    0x1.f25d629171aaeb2276907167a9aecd6ep-5,
    0x1.267e4cfc99f93p0
  },
  { // Entry 37
    -0x1.9080890e2f1798003a7f3166289a2555p2,
    0x1.288p-21
  },
  { // Entry 38
    -0x1.e561065b019c7c8d498e8c78464330bap-3,
    0x1.28aa9f2515f87p-1
  },
  { // Entry 39
    -0x1.acdc65a935a5e7fbeb2a0414dae29db6p-1,
    0x1.29a74a135d178p-3
  },
  { // Entry 40
    -0x1.ef0c55090466e7fc5d2be8b017aa1eb5p4,
    0x1.29ba33c33bb58p-103
  },
  { // Entry 41
    -0x1.d8d9a2cfb79d0b2ce6db09b403fbdef1p-3,
    0x1.2cep-1
  },
  { // Entry 42
    0x1.44538ea06035a000000e7cc1825ca422p-4,
    0x1.33333353c89c5p0
  },
  { // Entry 43
    0x1.p0,
    0x1.4p3
  },
  { // Entry 44
    0x1.9c899ddb7cc3a80106bd92d9f30607adp-4,
    0x1.42d14b4da920cp0
  },
  { // Entry 45
    -0x1.7ddfc5b2002037feab4460e64664b09dp3,
    0x1.480p-40
  },
  { // Entry 46
    0x1.a8eec6065bd99ffffff2293a34b1917dp-2,
    0x1.4cccccd6ceda7p1
  },
  { // Entry 47
    0x1.d2b644665f10c7fffff2e1d2418998f5p-4,
    0x1.4ccccceca919dp0
  },
  { // Entry 48
    0x1.d3bdb9847bf709c43457968ca6e28646p-4,
    0x1.4cfe1a8c30ed4p0
  },
  { // Entry 49
    0x1.d6cf13653b91464319282088eeff4c97p-4,
    0x1.4d913e35aea4ep0
  },
  { // Entry 50
    -0x1.f1225ac4366237fdb303a0597a3c8f4ap-2,
    0x1.4ed318236c85ap-2
  },
  { // Entry 51
    0x1.f37196430c2beec26b1c31bf38d57f48p-4,
    0x1.52faf510e022dp0
  },
  { // Entry 52
    0x1.f38c0c8325d85ad659b2174a3ebf6f55p-4,
    0x1.530p0
  },
  { // Entry 53
    0x1.ffedeac4d176f7d2cde344b7ec70f166p-4,
    0x1.555e30bbda69fp0
  },
  { // Entry 54
    0x1.ef35aa1c6b1a77fd9de45a1e172b02c6p0,
    0x1.57ee98247d966p6
  },
  { // Entry 55
    -0x1.e280fe9b8cf857fdc3ad0dc812e58d1dp-2,
    0x1.5a05d853c77c9p-2
  },
  { // Entry 56
    -0x1.dae3311da4c40884648c41a830dfe372p-2,
    0x1.6p-2
  },
  { // Entry 57
    -0x1.cbac8ba352de3be2a5cca8fb96402862p-2,
    0x1.6c4p-2
  },
  { // Entry 58
    0x1.d97edc6cb096a800000c666995420256p-2,
    0x1.7333334217b9ap1
  },
  { // Entry 59
    0x1.4fb68838ccfa27ff2311eecb508d5928p-3,
    0x1.7563c3887db28p0
  },
  { // Entry 60
    0x1.f8871c174778c7fff5731acf2ea4467cp0,
    0x1.76000000040p6
  },
  { // Entry 61
    -0x1.f2c14c2f6c5c9dbe7c8284b15fe01787p-4,
    0x1.82d0b42d0b428p-1
  },
  { // Entry 62
    -0x1.db1d990e111ee766e962104fbbf0f003p-4,
    0x1.87fd6da61c3dbp-1
  },
  { // Entry 63
    -0x1.88bdca024f32e80a1de6671b22560759p2,
    0x1.880p-21
  },
  { // Entry 64
    -0x1.d03b8ce6051c97fdd425647f3739d7a7p-4,
    0x1.8a653d99282aap-1
  },
  { // Entry 65
    -0x1.c2d826f6ad5fe8162592cc036e069cedp-4,
    0x1.8d6p-1
  },
  { // Entry 66
    -0x1.c02618e0447d27f9ebb51462d6978f25p-4,
    0x1.8dfa43fe5c91dp-1
  },
  { // Entry 67
    -0x1.eeaa19fc34f817fda340aeb7b652075bp3,
    0x1.915c782e20b7cp-52
  },
  { // Entry 68
    -0x1.977d95879da08ffffff16749a9bc1021p-2,
    0x1.999999f61e1aap-2
  },
  { // Entry 69
    -0x1.65df6512f76d17ffffefc71689395abep-1,
    0x1.99999a5944542p-3
  },
  { // Entry 70
    -0x1.65df64c430555800001074b613f83508p-1,
    0x1.99999aea617cep-3
  },
  { // Entry 71
    -0x1.fffffec8e4ad680000105809fee7c68cp-1,
    0x1.99999bd6ae073p-4
  },
  { // Entry 72
    0x1.b88245f86df8afffff2313af8a910f6bp0,
    0x1.a48f51c27f3efp5
  },
  { // Entry 73
    0x1.c03ec805c52c92447268d7949588e608p-3,
    0x1.a7cp0
  },
  { // Entry 74
    0x1.e37abe09539ad7fdb2cbb9c1975d1fc2p5,
    0x1.b1af286bca208p200
  },
  { // Entry 75
    0x1.d7f59ab2bcd057ffffffb4bb61effb6fp-3,
    0x1.b33333398e9e6p0
  },
  { // Entry 76
    0x1.d7f59ae8908aa7ffffef7f3f17823162p-3,
    0x1.b3333353e507cp0
  },
  { // Entry 77
    0x1.e67b44ba485188898012c0536c604a15p-3,
    0x1.ba5d2e974bap0
  },
  { // Entry 78
    -0x1.d51e74e2235f9001c902f49b3d39be88p-5,
    0x1.c0cp-1
  },
  { // Entry 79
    -0x1.c250b537e74bc8265c7b1b0eb3cb7541p-5,
    0x1.c320c8320c832p-1
  },
  { // Entry 80
    0x1.c1497aa3ee77f7fcf0bc96c7418f04b6p0,
    0x1.c71c71c71c71ep5
  },
  { // Entry 81
    0x1.78d835115ae9f7ff0c0680783889e6a1p0,
    0x1.da6d369b4dap4
  },
  { // Entry 82
    -0x1.ee844d23120e6ff4b9d27f8ce30b3cc2p-6,
    0x1.ddap-1
  },
  { // Entry 83
    -0x1.af7bceba1050d7feead6ef91625b91dfp-6,
    0x1.e1dff861891p-1
  },
  { // Entry 84
    0x1.e3dbd09431d0d7fdf2755b85be8a1676p5,
    0x1.e3b21bc1779ecp200
  },
  { // Entry 85
    -0x1.7aea2aab13a0480729dec748658b34fdp-6,
    0x1.e572b95cae540p-1
  },
  { // Entry 86
    0x1.c8de2fbafe18580003cdaa774a73d0c0p0,
    0x1.e739ce739ce70p5
  },
  { // Entry 87
    -0x1.0ce446e3ca10c004d63fb70fab6a26ffp-6,
    0x1.ed0340d0340d0p-1
  },
  { // Entry 88
    -0x1.fcf458f6faa4380097af1db4b2910c7dp-7,
    0x1.ee033092fe620p-1
  },
  { // Entry 89
    -0x1.fbe09900f2e9d7e3bbbe0bd455c92038p-7,
    0x1.ee0cc330cc347p-1
  },
  { // Entry 90
    -0x1.f9454ad8c58a6801723d48914bdbc81bp-7,
    0x1.ee23ee5df745dp-1
  },
  { // Entry 91
    0x1.2c858a2326ced800dd3ed3ad03e0efedp-1,
    0x1.ee8p1
  },
  { // Entry 92
    0x1.7f694cc35a4da800fb6e6f17a5903e17p1,
    0x1.eebbaeebbaee8p9
  },
  { // Entry 93
    -0x1.e2cfbb4934806fe698638d9325ce0de6p-7,
    0x1.eeebbaeebbaeep-1
  },
  { // Entry 94
    -0x1.c3d0837783cac8005374209e6248fb22p-7,
    0x1.f00000000008bp-1
  },
  { // Entry 95
    -0x1.51824c7587ecc4cae0ebe2a8eae894b0p-7,
    0x1.f3fffffffffffp-1
  },
  { // Entry 96
    -0x1.d0ef7d83c50a77fdf0a9df7625174df6p0,
    0x1.f46p-7
  },
  { // Entry 97
    -0x1.3cad2633010287ec521f3fb1b0e16c34p-7,
    0x1.f4bb83ff25408p-1
  },
  { // Entry 98
    -0x1.30260ecbe5e48801930721a2e427895ap-7,
    0x1.f52c691251919p-1
  },
  { // Entry 99
    0x1.6937e0674dae37fec020473dcad8c7e5p7,
    0x1.f5a814afd69f4p599
  },
  { // Entry 100
    -0x1.f78887a8d70da00092ac096e0c2a748dp-8,
    0x1.f70588f144d4ep-1
  },
  { // Entry 101
    -0x1.f6f8472e06512801501371ceeb6902c1p-8,
    0x1.f708159aab0fep-1
  },
  { // Entry 102
    -0x1.c575bc711f57f7bcd5e65219b01c819cp-8,
    0x1.f7e849868c907p-1
  },
  { // Entry 103
    -0x1.c03a80ae608087bcec4b95b43cc7cf68p-8,
    0x1.f7fffffffff4cp-1
  },
  { // Entry 104
    0x1.2d536e42845f97fe560fa7b450804b26p8,
    0x1.f9fe7f9fe7f9cp1000
  },
  { // Entry 105
    -0x1.f568e77ed84b1372c94cff5e7e38e985p-10,
    0x1.fdcp-1
  },
  { // Entry 106
    -0x1.be202babd38921235652db287907f634p-10,
    0x1.fdff6245a12f2p-1
  },
  { // Entry 107
    -0x1.bd96a1d7da0391520e1595e0904768ffp-10,
    0x1.fdffffffffffcp-1
  },
  { // Entry 108
    -0x1.bd96a1d7d9d9b63e5aa7d082a140d738p-10,
    0x1.fdfffffffffffp-1
  },
  { // Entry 109
    -0x1.bd27045bfd1e24767eb1fadda38b82e2p-11,
    0x1.fefffffffffffp-1
  },
  { // Entry 110
    -0x1.bd27045bc77c779853b6fc7b419acb49p-11,
    0x1.ff000000001ecp-1
  },
  { // Entry 111
    -0x1.bd25e056b638d812a81d48bf2dd5c055p-11,
    0x1.ff0000a7c5b2ap-1
  },
  { // Entry 112
    -0x1.bd226529bffa7801b54d1e695f9cf46ap-11,
    0x1.ff0002a7c5b2ap-1
  },
  { // Entry 113
    -0x1.d8c1f8f29d862387133a7814cb061b6dp-12,
    0x1.ff77fffffffffp-1
  },
  { // Entry 114
    -0x1.7c85657289fbe8275c1971e953a6ae71p-12,
    0x1.ff9285e1ae9c8p-1
  },
  { // Entry 115
    -0x1.ea7ebec511a69b37b972d41a517cd884p-13,
    0x1.ffb96e5b96e40p-1
  },
  { // Entry 116
    -0x1.c4e293b148cec847b4e214c76642cd73p-13,
    0x1.ffbed73ec264ep-1
  },
  { // Entry 117
    -0x1.bcd37f1eb06ff7cc110a8bd0efc2804bp-13,
    0x1.ffbffffffffffp-1
  },
  { // Entry 118
    -0x1.bcd37f1eb000bbf841f514e78b0bec67p-13,
    0x1.ffcp-1
  },
  { // Entry 119
    -0x1.8536047fb9d4f3b5cba95cabacae22aep-13,
    0x1.ffc7fffffffffp-1
  },
  { // Entry 120
    0x1.343573efa4c4c000047648d4f349dfcep-1,
    0x1.ffe4effffffffp1
  },
  { // Entry 121
    -0x1.85236427a08717efc89ebcb159b0b578p-16,
    0x1.fff8fffffffffp-1
  },
  { // Entry 122
    -0x1.e8df7421f041fffffe5b0949761ec657p5,
    0x1.fffa3bfffffffp-204
  },
  { // Entry 123
    -0x1.e2efbc1dc92337d7a679ab6c98fab739p-20,
    0x1.ffff74fffffffp-1
  },
  { // Entry 124
    -0x1.34413657816577fd436fcbc4aa32de88p-2,
    0x1.fffffe7ffffffp-2
  },
  { // Entry 125
    -0x1.d0ca51f95ac197fe1add64b6119cb454p7,
    0x1.ffffff3ffffffp-773
  },
  { // Entry 126
    -0x1.f018f15c0ab6094209fcfe083ebc306ep4,
    0x1.fffffffff1fffp-104
  },
  { // Entry 127
    0x1.465107258d1d1800062fee82bffbff4cp6,
    0x1.fffffffff9fffp270
  },
  { // Entry 128
    -0x1.9a9adba646d8e7ff39ebe5c5b651ecbcp7,
    0x1.fffffffffdfffp-683
  },
  { // Entry 129
    -0x1.16c0f776836d8ffe515d679ed8a253b1p8,
    0x1.fffffffffdfffp-927
  },
  { // Entry 130
    0x1.d59b56cd2f3cc80209ce8056d3477a08p7,
    0x1.fffffffffdfffp779
  },
  { // Entry 131
    -0x1.ce61cf8ef372f7fe03b197d05decff0ep-1,
    0x1.fffffffffff8fp-4
  },
  { // Entry 132
    -0x1.c85c8985c199c7fc14d958ba92e399dbp7,
    0x1.fffffffffffe0p-759
  },
  { // Entry 133
    -0x1.bcb7b1526e511ac160e1a3298010d96dp-52,
    0x1.ffffffffffff8p-1
  },
  { // Entry 134
    -0x1.34413509f7a00562d2bf0506ef44e3a5p-3,
    0x1.6a09e667f3bccp-1
  },
  { // Entry 135
    -0x1.8e271da4056a43993fdb13487031fbd4p-4,
    0x1.995255f2d00abp-1
  },
  { // Entry 136
    -0x1.9762be26c2c57dcae0118e0cced6e75ap-5,
    0x1.c89ac57dac58ap-1
  },
  { // Entry 137
    -0x1.c694ace08e5124f7327cd5da1fc480f6p-8,
    0x1.f7e3350888a69p-1
  },
  { // Entry 138
    0x1.064664d0dd47cb0784b117d2efb0afb2p-5,
    0x1.1395d249b27a4p0
  },
  { // Entry 139
    0x1.158bee1e56be974c17844d0736925a83p-4,
    0x1.2b3a0a0f20a14p0
  },
  { // Entry 140
    0x1.9cd10b008ddd739de9e6d843b8ff4092p-4,
    0x1.42de41d48ec84p0
  },
  { // Entry 141
    0x1.0d42f84798b4be1db02431f73c710b5fp-3,
    0x1.5a827999fcef4p0
  },
  { // Entry 142
    0x1.47f70647644a538dd717c3f0c99b4f52p-3,
    0x1.7226b15f6b164p0
  },
  { // Entry 143
    0x1.7f08548e0992552054c82deff65c5a7ep-3,
    0x1.89cae924d93d4p0
  },
  { // Entry 144
    0x1.b2e37bef02ca65a6b69ef0ef6045fca9p-3,
    0x1.a16f20ea47644p0
  },
  { // Entry 145
    0x1.e3e31eb5585d6defbecf1003ed8586ddp-3,
    0x1.b91358afb58b4p0
  },
  { // Entry 146
    0x1.0929d506851b759ac8b971a365bb53bfp-2,
    0x1.d0b7907523b24p0
  },
  { // Entry 147
    0x1.1f3b144d2903aa0e15b5d3c67d53f91bp-2,
    0x1.e85bc83a91d94p0
  },
  { // Entry 148
    0x1.34413509f79fef311f12b35816f922f0p-2,
    0x1.0p1
  },
  { // Entry 149
    -0x1.34413509f7a00562d2bf0506ef44e3a5p-3,
    0x1.6a09e667f3bccp-1
  },
  { // Entry 150
    -0x1.edc7b28c1cdff646afa1bdcd4e6a02f0p-4,
    0x1.83e609263c011p-1
  },
  { // Entry 151
    -0x1.7af97358b9e0a424fa702e69d4ac3a8cp-4,
    0x1.9dc22be484456p-1
  },
  { // Entry 152
    -0x1.0f218eacb6487dd0c606c3e816e7c3dap-4,
    0x1.b79e4ea2cc89bp-1
  },
  { // Entry 153
    -0x1.52e84950d4c307d9bedea47d3987c01bp-5,
    0x1.d17a716114ce0p-1
  },
  { // Entry 154
    -0x1.2519b7f1cb3d94d33244a6c708ffaefcp-6,
    0x1.eb56941f5d125p-1
  },
  { // Entry 155
    0x1.1f8102faa9fd301aa54cd13599ef1980p-8,
    0x1.02995b6ed2ab5p0
  },
  { // Entry 156
    0x1.a30a9d609efc4751d9d20363fa852e63p-6,
    0x1.0f876ccdf6cd8p0
  },
  { // Entry 157
    0x1.7706e100e01d4da13cc59446df5969d9p-5,
    0x1.1c757e2d1aefbp0
  },
  { // Entry 158
    0x1.0a965ca3c59fa6843ec39c17298b1aaap-4,
    0x1.29638f8c3f11ep0
  },
  { // Entry 159
    0x1.564b9e135d1f0f233bd67e02bc5bf6eap-4,
    0x1.3651a0eb63341p0
  },
  { // Entry 160
    0x1.9ee993b80f2136ca6bfb66b9c7b25428p-4,
    0x1.433fb24a87564p0
  },
  { // Entry 161
    0x1.e4ae53ebbcefbd04882f10aaa3de86b7p-4,
    0x1.502dc3a9ab787p0
  },
  { // Entry 162
    0x1.13e87661d64f5246b5a8d69214746331p-3,
    0x1.5d1bd508cf9aap0
  },
  { // Entry 163
    0x1.34413509f79fd8ff6b6661a93ead623bp-3,
    0x1.6a09e667f3bccp0
  },
  { // Entry 164
    -0x1.ffbfc2bbc780375837c4b0b84f38a14ap-4,
    0x1.8p-1
  },
  { // Entry 165
    -0x1.5634626b0211c48738b33f07d1594431p-4,
    0x1.a666666666666p-1
  },
  { // Entry 166
    -0x1.76d869b02a035a10797953f058b52ecap-5,
    0x1.cccccccccccccp-1
  },
  { // Entry 167
    -0x1.684bf7fda98a1c59efaac6272939dcd6p-7,
    0x1.f333333333332p-1
  },
  { // Entry 168
    0x1.5b2a5ca1f47b15b644b33c640923bf35p-6,
    0x1.0ccccccccccccp0
  },
  { // Entry 169
    0x1.a30a9d609efdd6812008dfbb8239bf8cp-5,
    0x1.1ffffffffffffp0
  },
  { // Entry 170
    0x1.44538de3b27e4c8bcd11e934e41583aap-4,
    0x1.3333333333332p0
  },
  { // Entry 171
    0x1.b02b728fb6168040e2c4e5e7fb3809b1p-4,
    0x1.4666666666665p0
  },
  { // Entry 172
    0x1.0aec6e4a00fec3048feb505070bb4f14p-3,
    0x1.5999999999998p0
  },
  { // Entry 173
    0x1.3b03499ffcc7d7b28a254f6122a6a4d4p-3,
    0x1.6cccccccccccbp0
  },
  { // Entry 174
    0x1.68a288b60b7f789784b55146880d9ce1p-3,
    0x1.7fffffffffffep0
  },
  { // Entry 175
    0.0,
    0x1.0p0
  },
  { // Entry 176
    0x1.e1a5e2df92e9e5bcc08d3839a3e54697p4,
    0x1.0p100
  },
  { // Entry 177
    0x1.e24f6e3fe3af5472f332ca85bdbb9d77p4,
    0x1.199999999999ap100
  },
  { // Entry 178
    0x1.e2ea366d769c64c298e42c7b7a7f4693p4,
    0x1.3333333333334p100
  },
  { // Entry 179
    0x1.e37899234efc355b9919ffe367a51209p4,
    0x1.4cccccccccccep100
  },
  { // Entry 180
    0x1.e3fc6d39772e858d4b8607d59bb8d0ddp4,
    0x1.6666666666668p100
  },
  { // Entry 181
    0x1.e47727f0ff00e5d66a0cd9d066e228c3p4,
    0x1.8000000000002p100
  },
  { // Entry 182
    0x1.e4e9f6303263e5569760e25883a23773p4,
    0x1.999999999999cp100
  },
  { // Entry 183
    0x1.e555ce14de677da58c6cbe260334cf1bp4,
    0x1.b333333333336p100
  },
  { // Entry 184
    0x1.e5bb7b7ee2b364c38d849ed338fa804dp4,
    0x1.cccccccccccd0p100
  },
  { // Entry 185
    0x1.e61ba9358eaaf702959b2a4bfffdca28p4,
    0x1.e66666666666ap100
  },
  { // Entry 186
    0x1.e676e7b3bac865798509830704412b23p4,
    0x1.0p101
  },
  { // Entry 187
    0x1.e1a5e2df92e9e5bcc08d3839a3e54697p5,
    0x1.0p200
  },
  { // Entry 188
    0x1.e1faa88fbb4c9d17d9e0015fb0d07207p5,
    0x1.199999999999ap200
  },
  { // Entry 189
    0x1.e2480ca684c3253facb8b25a8f324695p5,
    0x1.3333333333334p200
  },
  { // Entry 190
    0x1.e28f3e0170f30d8c2cd39c0e85c52c50p5,
    0x1.4cccccccccccep200
  },
  { // Entry 191
    0x1.e2d1280c850c35a50609a0079fcf0bbap5,
    0x1.6666666666668p200
  },
  { // Entry 192
    0x1.e30e856848f565c9954d09050563b7adp5,
    0x1.8000000000002p200
  },
  { // Entry 193
    0x1.e347ec87e2a6e589abf70d4913c3bf05p5,
    0x1.999999999999cp200
  },
  { // Entry 194
    0x1.e37dd87a38a8b1b1267cfb2fd38d0ad9p5,
    0x1.b333333333336p200
  },
  { // Entry 195
    0x1.e3b0af2f3acea5402708eb866e6fe372p5,
    0x1.cccccccccccd0p200
  },
  { // Entry 196
    0x1.e3e0c60a90ca6e5fab143142d1f18860p5,
    0x1.e66666666666ap200
  },
  { // Entry 197
    0x1.e40e6549a6d9259b22cb5da0541338ddp5,
    0x1.0p201
  },
  { // Entry 198
    0x1.2d07adcbbbd22f95f8584324066f4c1ep8,
    0x1.0p1000
  },
  { // Entry 199
    0x1.2d124681c0de86815b829c48c80cb18cp8,
    0x1.199999999999ap1000
  },
  { // Entry 200
    0x1.2d1bf3049a0d578655ddb26823d8ec1ep8,
    0x1.3333333333334p1000
  },
  { // Entry 201
    0x1.2d24d92ff793548fe5e10f9ea2ab48d5p8,
    0x1.4cccccccccccep1000
  },
  { // Entry 202
    0x1.2d2d16715a1679930107d01dc5ec84c3p8,
    0x1.6666666666668p1000
  },
  { // Entry 203
    0x1.2d34c21cd2939f9792f03d3d729f1a41p8,
    0x1.8000000000002p1000
  },
  { // Entry 204
    0x1.2d3bef00c5c9cf8f95c57dc5f46b1b2cp8,
    0x1.999999999999cp1000
  },
  { // Entry 205
    0x1.2d42ac7f108a091485163b82cc6444a6p8,
    0x1.b333333333336p1000
  },
  { // Entry 206
    0x1.2d490755b0cec7866527b98d9fc09fbap8,
    0x1.cccccccccccd0p1000
  },
  { // Entry 207
    0x1.2d4f0a311b8e40aa55a922452c30d457p8,
    0x1.e66666666666ap1000
  },
  { // Entry 208
    0x1.2d54be18fe501791c4a007d0dc750a67p8,
    0x1.0p1001
  },
  { // Entry 209
    -0x1.bcb7bf382c6fb3df0029e1e6c04e5b04p-22,
    0x1.ffffep-1
  },
  { // Entry 210
    -0x1.287a794e24640de79fb5dd39033f1c3ap-23,
    0x1.fffff55555555p-1
  },
  { // Entry 211
    0x1.287a731f2fe08fea55a78b1501306850p-23,
    0x1.0000055555555p0
  },
  { // Entry 212
    0x1.bcb7a36cb15a8cec0c39b0a7cf2d7858p-22,
    0x1.00001p0
  },
  { // Entry 213
    -0x1.bcb7b155e7c045d88b2ccd879d00dedap-32,
    0x1.fffffff80p-1
  },
  { // Entry 214
    -0x1.287a7888aec95740a166efaf8756eaa1p-33,
    0x1.fffffffd55555p-1
  },
  { // Entry 215
    0x1.287a719444b61daa0968ca1f55a6be9ap-33,
    0x1.0000000155555p0
  },
  { // Entry 216
    0x1.bcb7b14ef4e1808ed1e940a65b2d5f0fp-32,
    0x1.000000040p0
  },
  { // Entry 217
    -0x1.bcb7b1526f2f3f0313ef120e2ab88e99p-42,
    0x1.fffffffffe0p-1
  },
  { // Entry 218
    -0x1.2883ba0aa61efb4b5ec5882d1426a118p-43,
    0x1.ffffffffff555p-1
  },
  { // Entry 219
    0x1.2867ee8f909545d6cd4484a582495a1fp-43,
    0x1.0000000000555p0
  },
  { // Entry 220
    0x1.bcb7b1526d728751c180c12b004dd665p-42,
    0x1.00000000010p0
  },
  { // Entry 221
    -0x1.bcb7b1526e511ac160e1a3298010d96dp-52,
    0x1.ffffffffffff8p-1
  },
  { // Entry 222
    -0x1.4d89c4fdd2bcba02454565e85cc46f5fp-53,
    0x1.ffffffffffffdp-1
  },
  { // Entry 223
    0x1.bcb7b1526e50d544ad2cc1ecd3e2a249p-54,
    0x1.0000000000001p0
  },
  { // Entry 224
    0x1.bcb7b1526e50ab93748d079547463ebfp-52,
    0x1.0000000000004p0
  },
  { // Entry 225
    0x1.34413509f79fef2da5a350b33a574eb5p8,
    0x1.fffffffffffffp1023
  },
  { // Entry 226
    -0x1.434e6420f4373e5f05171d19e4184d25p8,
    0x1.0p-1074
  },
  { // Entry 227
    -0x1.34413509f7a02cb1a1f65baf60cb15dfp-3,
    0x1.6a09e667f3bcbp-1
  },
  { // Entry 228
    -0x1.34413509f7a00562d2bf0506ef44e3a5p-3,
    0x1.6a09e667f3bccp-1
  },
  { // Entry 229
    -0x1.34413509f79fde140387ae5e7f7b691dp-3,
    0x1.6a09e667f3bcdp-1
  },
  { // Entry 230
    0x1.34413509f79fb1b09c2f0b00cd273001p-3,
    0x1.6a09e667f3bcbp0
  },
  { // Entry 231
    0x1.34413509f79fd8ff6b6661a93ead623bp-3,
    0x1.6a09e667f3bccp0
  },
  { // Entry 232
    0x1.34413509f7a0004e3a9db851ae76dcc3p-3,
    0x1.6a09e667f3bcdp0
  },
  { // Entry 233
    -0x1.34413509f79ffd16dc9d46ca9e4a0d3cp-2,
    0x1.fffffffffffffp-2
  },
  { // Entry 234
    -0x1.34413509f79fef311f12b35816f922f0p-2,
    0x1.0p-1
  },
  { // Entry 235
    -0x1.34413509f79fd365a3fd8c7309a4d81dp-2,
    0x1.0000000000001p-1
  },
  { // Entry 236
    -0x1.ffbfc2bbc7808176d5526dc5cbf5abb0p-4,
    0x1.7ffffffffffffp-1
  },
  { // Entry 237
    -0x1.ffbfc2bbc780375837c4b0b84f38a14ap-4,
    0x1.8p-1
  },
  { // Entry 238
    -0x1.ffbfc2bbc77fed399a36f3aad59232c9p-4,
    0x1.8000000000001p-1
  },
  { // Entry 239
    0x1.68a288b60b7f9da6d37c2fcd47f77008p-3,
    0x1.7ffffffffffffp0
  },
  { // Entry 240
    0x1.68a288b60b7fc2b622430e540655f53bp-3,
    0x1.8p0
  },
  { // Entry 241
    0x1.68a288b60b7fe7c57109ecdac3292c7bp-3,
    0x1.8000000000001p0
  },
  { // Entry 242
    0x1.2817ce90842c0e5d9ca444ee93c2f2b2p-10,
    0x1.00aaaaaaaaaaap0
  },
  { // Entry 243
    0x1.2817ce908447c75d5ca081d47714bc4cp-10,
    0x1.00aaaaaaaaaabp0
  },
  { // Entry 244
    0x1.2817ce908463805d1c9cbeb89ffd7a98p-10,
    0x1.00aaaaaaaaaacp0
  },
  { // Entry 245
    0x1.34413509f79fe83e404d699ed350adcap-1,
    0x1.fffffffffffffp1
  },
  { // Entry 246
    0x1.34413509f79fef311f12b35816f922f0p-1,
    0x1.0p2
  },
  { // Entry 247
    0x1.34413509f79ffd16dc9d46ca9da34859p-1,
    0x1.0000000000001p2
  },
  { // Entry 248
    0x1.34413509f79fe14b61881fe58fa838a4p-2,
    0x1.fffffffffffffp0
  },
  { // Entry 249
    0x1.34413509f79fef311f12b35816f922f0p-2,
    0x1.0p1
  },
  { // Entry 250
    0x1.34413509f7a00afc9a27da3d244d6dc3p-2,
    0x1.0000000000001p1
  },
  { // Entry 251
    -0x1.bcb7b1526e50ea1d497c9f189e19715ep-55,
    0x1.fffffffffffffp-1
  },
  { // Entry 252
    0.0,
    0x1.0p0
  },
  { // Entry 253
    0x1.bcb7b1526e50d544ad2cc1ecd3e2a249p-54,
    0x1.0000000000001p0
  },
  { // Entry 254
    -0x1.34413509f79ffd16dc9d46ca9e4a0d3cp-2,
    0x1.fffffffffffffp-2
  },
  { // Entry 255
    -0x1.34413509f79fef311f12b35816f922f0p-2,
    0x1.0p-1
  },
  { // Entry 256
    -0x1.34413509f79fd365a3fd8c7309a4d81dp-2,
    0x1.0000000000001p-1
  },
  { // Entry 257
    -0x1.34413509f79ff623fdd7fd115aa19816p-1,
    0x1.fffffffffffffp-3
  },
  { // Entry 258
    -0x1.34413509f79fef311f12b35816f922f0p-1,
    0x1.0p-2
  },
  { // Entry 259
    -0x1.34413509f79fe14b61881fe5904efd86p-1,
    0x1.0000000000001p-2
  },
  { // Entry 260
    -0x1.ce61cf8ef36fedbc8d6156bd661e298ep-1,
    0x1.fffffffffffffp-4
  },
  { // Entry 261
    -0x1.ce61cf8ef36fe6c9ae9c0d042275b468p-1,
    0x1.0p-3
  },
  { // Entry 262
    -0x1.ce61cf8ef36fd8e3f11179919bcb8effp-1,
    0x1.0000000000001p-3
  },
  { // Entry 263
    -0x1.34413509f79ff2aa8e755834b8cd5d83p0,
    0x1.fffffffffffffp-5
  },
  { // Entry 264
    -0x1.34413509f79fef311f12b35816f922f0p0,
    0x1.0p-4
  },
  { // Entry 265
    -0x1.34413509f79fe83e404d699ed3a4103bp0,
    0x1.0000000000001p-4
  },
  { // Entry 266
    -0x1.8151824c7587ee76d63a050abe8ba63fp0,
    0x1.fffffffffffffp-6
  },
  { // Entry 267
    -0x1.8151824c7587eafd66d7602e1cb76bacp0,
    0x1.0p-5
  },
  { // Entry 268
    -0x1.8151824c7587e40a88121674d96258f7p0,
    0x1.0000000000001p-5
  },
  { // Entry 269
    -0x1.ce61cf8ef36fea431dfeb1e0c449eefbp0,
    0x1.fffffffffffffp-7
  },
  { // Entry 270
    -0x1.ce61cf8ef36fe6c9ae9c0d042275b468p0,
    0x1.0p-6
  },
  { // Entry 271
    -0x1.ce61cf8ef36fdfd6cfd6c34adf20a1b3p0,
    0x1.0000000000001p-6
  },
  { // Entry 272
    -0x1.0db90e68b8abf307b2e1af5b65041bdbp1,
    0x1.fffffffffffffp-8
  },
  { // Entry 273
    -0x1.0db90e68b8abf14afb305ced1419fe92p1,
    0x1.0p-7
  },
  { // Entry 274
    -0x1.0db90e68b8abedd18bcdb810726f7537p1,
    0x1.0000000000001p-7
  },
  { // Entry 275
    -0x1.34413509f79ff0edd6c405c667e34039p1,
    0x1.fffffffffffffp-9
  },
  { // Entry 276
    -0x1.34413509f79fef311f12b35816f922f0p1,
    0x1.0p-8
  },
  { // Entry 277
    -0x1.34413509f79febb7afb00e7b754e9995p1,
    0x1.0000000000001p-8
  },
  { // Entry 278
    -0x1.5ac95bab3693eed3faa65c316ac26497p1,
    0x1.fffffffffffffp-10
  },
  { // Entry 279
    -0x1.5ac95bab3693ed1742f509c319d8474ep1,
    0x1.0p-9
  },
  { // Entry 280
    -0x1.5ac95bab3693e99dd39264e6782dbdf3p1,
    0x1.0000000000001p-9
  },
  { // Entry 281
    -0x1.8151824c7587ecba1e88b29c6da188f5p1,
    0x1.fffffffffffffp-11
  },
  { // Entry 282
    -0x1.8151824c7587eafd66d7602e1cb76bacp1,
    0x1.0p-10
  },
  { // Entry 283
    -0x1.8151824c7587e783f774bb517b0ce252p1,
    0x1.0000000000001p-10
  },
  { // Entry 284
    -0x1.f4e9f6303263e66c8a2fb5dd763ef60fp1,
    0x1.fffffffffffffp-14
  },
  { // Entry 285
    -0x1.f4e9f6303263e4afd27e636f2554d8c6p1,
    0x1.0p-13
  },
  { // Entry 286
    -0x1.f4e9f6303263e136631bbe9283aa4f6cp1,
    0x1.0000000000001p-13
  },
  { // Entry 287
    -0x1.f4e9f6303263e66c8a2fb5dd763ef60fp1,
    0x1.fffffffffffffp-14
  },
  { // Entry 288
    -0x1.f4e9f6303263e4afd27e636f2554d8c6p1,
    0x1.0p-13
  },
  { // Entry 289
    -0x1.f4e9f6303263e136631bbe9283aa4f6cp1,
    0x1.0000000000001p-13
  },
  { // Entry 290
    -0x1.ce61cf8ef36fedbc8d6156bd661e298ep-1,
    0x1.fffffffffffffp-4
  },
  { // Entry 291
    -0x1.ce61cf8ef36fe6c9ae9c0d042275b468p-1,
    0x1.0p-3
  },
  { // Entry 292
    -0x1.ce61cf8ef36fd8e3f11179919bcb8effp-1,
    0x1.0000000000001p-3
  },
  { // Entry 293
    -0x1.db11ed766abfc23dad46ff588641095dp-5,
    0x1.bffffffffffffp-1
  },
  { // Entry 294
    -0x1.db11ed766abf432dc3c1bb4167a6eb47p-5,
    0x1.cp-1
  },
  { // Entry 295
    -0x1.db11ed766abec41dda3c772a4d96833ep-5,
    0x1.c000000000001p-1
  },
  { // Entry 296
    -0x1.34413509f79ff2aa8e755834b8cd5d83p0,
    0x1.fffffffffffffp-5
  },
  { // Entry 297
    -0x1.34413509f79fef311f12b35816f922f0p0,
    0x1.0p-4
  },
  { // Entry 298
    -0x1.34413509f79fe83e404d699ed3a4103bp0,
    0x1.0000000000001p-4
  },
  { // Entry 299
    -0x1.cb38fccd8bfea3c5778d26c3e6929b36p-6,
    0x1.dffffffffffffp-1
  },
  { // Entry 300
    -0x1.cb38fccd8bfdb696b29463658b991237p-6,
    0x1.ep-1
  },
  { // Entry 301
    -0x1.cb38fccd8bfcc967ed9ba00738877eb7p-6,
    0x1.e000000000001p-1
  },
  { // Entry 302
    -0x1.8151824c7587ee76d63a050abe8ba63fp0,
    0x1.fffffffffffffp-6
  },
  { // Entry 303
    -0x1.8151824c7587eafd66d7602e1cb76bacp0,
    0x1.0p-5
  },
  { // Entry 304
    -0x1.8151824c7587e40a88121674d96258f7p0,
    0x1.0000000000001p-5
  },
  { // Entry 305
    -0x1.c3d0837784c5d4dc2b470a089b8b6137p-7,
    0x1.effffffffffffp-1
  },
  { // Entry 306
    -0x1.c3d0837784c409cbf85d4dd61d426e1bp-7,
    0x1.fp-1
  },
  { // Entry 307
    -0x1.c3d0837784c23ebbc57391a3adc87461p-7,
    0x1.f000000000001p-1
  },
  { // Entry 308
    -0x1.ce61cf8ef36fea431dfeb1e0c449eefbp0,
    0x1.fffffffffffffp-7
  },
  { // Entry 309
    -0x1.ce61cf8ef36fe6c9ae9c0d042275b468p0,
    0x1.0p-6
  },
  { // Entry 310
    -0x1.ce61cf8ef36fdfd6cfd6c34adf20a1b3p0,
    0x1.0000000000001p-6
  },
  { // Entry 311
    -0x1.c03a80ae5e08bfbaeb001bb3cc0e0020p-8,
    0x1.f7fffffffffffp-1
  },
  { // Entry 312
    -0x1.c03a80ae5e05382d51f71b0f6602c76ap-8,
    0x1.f80p-1
  },
  { // Entry 313
    -0x1.c03a80ae5e01b09fb8ee1a6b1ca6b823p-8,
    0x1.f800000000001p-1
  },
  { // Entry 314
    -0x1.0db90e68b8abf307b2e1af5b65041bdbp1,
    0x1.fffffffffffffp-8
  },
  { // Entry 315
    -0x1.0db90e68b8abf14afb305ced1419fe92p1,
    0x1.0p-7
  },
  { // Entry 316
    -0x1.0db90e68b8abedd18bcdb810726f7537p1,
    0x1.0000000000001p-7
  },
  { // Entry 317
    -0x1.be76bd77b50331b751b4d8af88fb07ecp-9,
    0x1.fbfffffffffffp-1
  },
  { // Entry 318
    -0x1.be76bd77b4fc30d6cb5e729fc0bd5fa5p-9,
    0x1.fc0p-1
  },
  { // Entry 319
    -0x1.be76bd77b4f52ff645080c9030f7ab79p-9,
    0x1.fc00000000001p-1
  },
  { // Entry 320
    -0x1.34413509f79ff0edd6c405c667e34039p1,
    0x1.fffffffffffffp-9
  },
  { // Entry 321
    -0x1.34413509f79fef311f12b35816f922f0p1,
    0x1.0p-8
  },
  { // Entry 322
    -0x1.34413509f79febb7afb00e7b754e9995p1,
    0x1.0000000000001p-8
  },
  { // Entry 323
    -0x1.bd96a1d7d9d9b63e5aa7d082a140d738p-10,
    0x1.fdfffffffffffp-1
  },
  { // Entry 324
    -0x1.bd96a1d7d9cbc28d1ed88eb987048038p-10,
    0x1.fe0p-1
  },
  { // Entry 325
    -0x1.bd96a1d7d9bdcedbe3094cf0dcd5c0adp-10,
    0x1.fe00000000001p-1
  },
  { // Entry 326
    -0x1.5ac95bab3693eed3faa65c316ac26497p1,
    0x1.fffffffffffffp-10
  },
  { // Entry 327
    -0x1.5ac95bab3693ed1742f509c319d8474ep1,
    0x1.0p-9
  },
  { // Entry 328
    -0x1.5ac95bab3693e99dd39264e6782dbdf3p1,
    0x1.0000000000001p-9
  },
  { // Entry 329
    -0x1.bd27045bfd1e24767eb1fadda38b82e2p-11,
    0x1.fefffffffffffp-1
  },
  { // Entry 330
    -0x1.bd27045bfd024b0eb5a690199f7d311fp-11,
    0x1.ff0p-1
  },
  { // Entry 331
    -0x1.bd27045bfce671a6ec9b25567aa9bb13p-11,
    0x1.ff00000000001p-1
  },
  { // Entry 332
    -0x1.8151824c7587ecba1e88b29c6da188f5p1,
    0x1.fffffffffffffp-11
  },
  { // Entry 333
    -0x1.8151824c7587eafd66d7602e1cb76bacp1,
    0x1.0p-10
  },
  { // Entry 334
    -0x1.8151824c7587e783f774bb517b0ce252p1,
    0x1.0000000000001p-10
  },
  { // Entry 335
    -0x1.bcef518e2998bf2fcdeca6d0c7d243c3p-12,
    0x1.ff7ffffffffffp-1
  },
  { // Entry 336
    -0x1.bcef518e29611a506bc6531e97655414p-12,
    0x1.ff8p-1
  },
  { // Entry 337
    -0x1.bcef518e29297571099fff6e248ec50ep-12,
    0x1.ff80000000001p-1
  },
  { // Entry 338
    -0x1.f4e9f6303263e66c8a2fb5dd763ef60fp1,
    0x1.fffffffffffffp-14
  },
  { // Entry 339
    -0x1.f4e9f6303263e4afd27e636f2554d8c6p1,
    0x1.0p-13
  },
  { // Entry 340
    -0x1.f4e9f6303263e136631bbe9283aa4f6cp1,
    0x1.0000000000001p-13
  },
  { // Entry 341
    -0x1.bcbea45645848a4be42e2d4ac91c6d9fp-15,
    0x1.ffeffffffffffp-1
  },
  { // Entry 342
    -0x1.bcbea45643c7c4b46503e30e59b7dd28p-15,
    0x1.fffp-1
  },
  { // Entry 343
    -0x1.bcbea456420aff1ce5d998dfd0ef3d8bp-15,
    0x1.fff0000000001p-1
  },
  { // Entry 344
    HUGE_VAL,
    HUGE_VAL
  },
  { // Entry 345
    0x1.34413509f79fef2da5a350b33a574eb5p8,
    0x1.fffffffffffffp1023
  },
  { // Entry 346
    0x1.34413509f79fef2a2c33ee0e5db55eafp8,
    0x1.ffffffffffffep1023
  },
  { // Entry 347
    0x1.fd14db31ba3bab2b91a5ae782f204d4fp-2,
    0x1.921fb54442d18p1
  },
  { // Entry 348
    0x1.91a74c4f853777f4e525f640304e54bep-3,
    0x1.921fb54442d18p0
  },
  { // Entry 349
    0x1.bcb7b1526e50d544ad2cc1ecd3e2a249p-54,
    0x1.0000000000001p0
  },
  { // Entry 350
    0.0,
    0x1.0p0
  },
  { // Entry 351
    -0x1.bcb7b1526e50ea1d497c9f189e19715ep-55,
    0x1.fffffffffffffp-1
  },
  { // Entry 352
    -0x1.adb63b88d410ccdab1fee0dffb47e244p-4,
    0x1.921fb54442d18p-1
  },
  { // Entry 353
    -0x1.33a7146f72a41f3293a464b4b1aa514cp8,
    0x1.0000000000001p-1022
  },
  { // Entry 354
    -0x1.33a7146f72a41f39868329fe6aeda65ep8,
    0x1.0p-1022
  },
  { // Entry 355
    -0x1.33a7146f72a41f407961ef4824316a9fp8,
    0x1.ffffffffffffep-1023
  },
  { // Entry 356
    -0x1.33a7146f72a41f476c40b491dd759e0ep8,
    0x1.ffffffffffffcp-1023
  },
  { // Entry 357
    -0x1.430153d3b1b9566338cf586d0e128edcp8,
    0x1.0p-1073
  },
  { // Entry 358
    -0x1.434e6420f4373e5f05171d19e4184d25p8,
    0x1.0p-1074
  },
  { // Entry 359
    -HUGE_VAL,
    0.0
  },
  { // Entry 360
    -HUGE_VAL,
    -0.0
  },
  { // Entry 361
    0x1.p0,
    0x1.4p3
  },
  { // Entry 362
    0x1.p1,
    0x1.9p6
  },
  { // Entry 363
    0x1.80p1,
    0x1.f40p9
  }
};
