/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <math.h>

#include <fenv.h>

#include <gtest/gtest.h>

#if defined(__BIONIC__)
typedef struct {
  float expected;
  float call_data;
} cosf_intel_data_t;

static cosf_intel_data_t g_cosf_intel_data[] = {
  { // Entry 0
    0x1.bc7b66ffb7689d646dd1af83e9661d2dp-1,
    -0x1.09ebacp-1
  },
  { // Entry 1
    0x1.bc7b66ffb7689d646dd1af83e9661d2dp-1,
    0x1.09ebacp-1
  },
  { // Entry 2
    0x1.dee8d0fffcd997ce5cfbab0a5a336c14p-5,
    -0x1.156564p4
  },
  { // Entry 3
    0x1.dee8d0fffcd997ce5cfbab0a5a336c14p-5,
    0x1.156564p4
  },
  { // Entry 4
    -0x1.c11bb2f056552ca4cdb6c5a0cf71509dp-8,
    -0x1.406a40p6
  },
  { // Entry 5
    -0x1.c11bb2f056552ca4cdb6c5a0cf71509dp-8,
    0x1.406a40p6
  },
  { // Entry 6
    0x1.ff836cff97077bf489aadc5f349a9fb9p-1,
    -0x1.653078p-5
  },
  { // Entry 7
    0x1.ff836cff97077bf489aadc5f349a9fb9p-1,
    0x1.653078p-5
  },
  { // Entry 8
    0x1.b29cd4f9da2964e8c6bb5693387d3f3bp-5,
    -0x1.6c0008p5
  },
  { // Entry 9
    0x1.b29cd4f9da2964e8c6bb5693387d3f3bp-5,
    0x1.6c0008p5
  },
  { // Entry 10
    0x1.df40d3f650f6c94390a3ca5d8d9b48c1p-1,
    -0x1.703824p-2
  },
  { // Entry 11
    0x1.df40d3f650f6c94390a3ca5d8d9b48c1p-1,
    0x1.703824p-2
  },
  { // Entry 12
    0x1.f76316f541e10ef15d57c5a23775329cp-1,
    -0x1.782e2ep-3
  },
  { // Entry 13
    0x1.f76316f541e10ef15d57c5a23775329cp-1,
    0x1.782e2ep-3
  },
  { // Entry 14
    0x1.cfab0ec2fc95382986fa511648bd4e6fp-24,
    -0x1.8e3266p9
  },
  { // Entry 15
    0x1.cfab0ec2fc95382986fa511648bd4e6fp-24,
    0x1.8e3266p9
  },
  { // Entry 16
    0x1.92e66b5920a85d6083e9cc85568ceaa3p-21,
    -0x1.c6ac02p14
  },
  { // Entry 17
    0x1.92e66b5920a85d6083e9cc85568ceaa3p-21,
    0x1.c6ac02p14
  },
  { // Entry 18
    0x1.d1ceb4ffff6ed05b5ef5fc618231214ap-2,
    -0x1.e513fcp4
  },
  { // Entry 19
    0x1.d1ceb4ffff6ed05b5ef5fc618231214ap-2,
    0x1.e513fcp4
  },
  { // Entry 20
    0x1.c27e049dfeab38e1b8ea6a09631829fep-1,
    -0x1.fb1904p-2
  },
  { // Entry 21
    0x1.c27e049dfeab38e1b8ea6a09631829fep-1,
    0x1.fb1904p-2
  },
  { // Entry 22
    0x1.b4bf2c79bdfcdaa53ed6c013f65e0963p-1,
    -0x1.fffffep127
  },
  { // Entry 23
    0x1.b4bf2c79bdfcdaa53ed6c013f65e0963p-1,
    0x1.fffffep127
  },
  { // Entry 24
    0x1.ffffff000000155555549f49f4a28a28p-1,
    0x1.p-12
  },
  { // Entry 25
    0x1.ffffff000000155555549f49f4a28a28p-1,
    -0x1.p-12
  },
  { // Entry 26
    0x1.ffffffffffc000000000015555555555p-1,
    0x1.p-21
  },
  { // Entry 27
    0x1.ffffffffffc000000000015555555555p-1,
    -0x1.p-21
  },
  { // Entry 28
    0x1.fffffffffff000000000001555555555p-1,
    0x1.p-22
  },
  { // Entry 29
    0x1.fffffffffff000000000001555555555p-1,
    -0x1.p-22
  },
  { // Entry 30
    0x1.fffffefffffc155551ff49f696c4aecap-1,
    0x1.000002p-12
  },
  { // Entry 31
    0x1.fffffefffffc155551ff49f696c4aecap-1,
    -0x1.000002p-12
  },
  { // Entry 32
    0x1.882d606ba07505a7a09ae74d713f9788p-1,
    0x1.000002p51
  },
  { // Entry 33
    0x1.882d606ba07505a7a09ae74d713f9788p-1,
    -0x1.000002p51
  },
  { // Entry 34
    0x1.fc0154f7f5b6422f7794bf156ee98b7ep-1,
    0x1.000006p-3
  },
  { // Entry 35
    0x1.fc0154f7f5b6422f7794bf156ee98b7ep-1,
    -0x1.000006p-3
  },
  { // Entry 36
    0x1.34e976ef67d60a3de814ad3d0203ba21p-10,
    0x1.000006p121
  },
  { // Entry 37
    0x1.34e976ef67d60a3de814ad3d0203ba21p-10,
    -0x1.000006p121
  },
  { // Entry 38
    -0x1.ffffa2cf59398dc6180801e9ea3120c8p-1,
    0x1.000006p122
  },
  { // Entry 39
    -0x1.ffffa2cf59398dc6180801e9ea3120c8p-1,
    -0x1.000006p122
  },
  { // Entry 40
    0x1.ffc0014453315d47e2a318bf63e4caa7p-1,
    0x1.000022p-5
  },
  { // Entry 41
    0x1.ffc0014453315d47e2a318bf63e4caa7p-1,
    -0x1.000022p-5
  },
  { // Entry 42
    0x1.c15215015f3d916a0019a39e3acc7364p-1,
    0x1.0000e0p-1
  },
  { // Entry 43
    0x1.c15215015f3d916a0019a39e3acc7364p-1,
    -0x1.0000e0p-1
  },
  { // Entry 44
    0x1.ff001394e93085c7cce53915893af765p-1,
    0x1.0000e0p-4
  },
  { // Entry 45
    0x1.ff001394e93085c7cce53915893af765p-1,
    -0x1.0000e0p-4
  },
  { // Entry 46
    0x1.90b0c97de2370587a68aeae2b6943953p-15,
    0x1.000322p23
  },
  { // Entry 47
    0x1.90b0c97de2370587a68aeae2b6943953p-15,
    -0x1.000322p23
  },
  { // Entry 48
    -0x1.8b90c67677565874f44d9314ca2ba634p-6,
    0x1.000402p8
  },
  { // Entry 49
    -0x1.8b90c67677565874f44d9314ca2ba634p-6,
    -0x1.000402p8
  },
  { // Entry 50
    0x1.14735fffd55120a4480b7c91a1d78d6ep-1,
    0x1.001cp0
  },
  { // Entry 51
    0x1.14735fffd55120a4480b7c91a1d78d6ep-1,
    -0x1.001cp0
  },
  { // Entry 52
    0x1.c0b6d10005468a3a3eb056eb59b58ce2p-1,
    0x1.0144p-1
  },
  { // Entry 53
    0x1.c0b6d10005468a3a3eb056eb59b58ce2p-1,
    -0x1.0144p-1
  },
  { // Entry 54
    -0x1.c403d90006509b0762642d0bea40e4b1p-2,
    0x1.0394c8p1
  },
  { // Entry 55
    -0x1.c403d90006509b0762642d0bea40e4b1p-2,
    -0x1.0394c8p1
  },
  { // Entry 56
    -0x1.270da18b198e6ebfc8782082902bf2d4p-25,
    0x1.04ccbcp18
  },
  { // Entry 57
    -0x1.270da18b198e6ebfc8782082902bf2d4p-25,
    -0x1.04ccbcp18
  },
  { // Entry 58
    0x1.ee0f67015b9fb39ba6eb91d47829c913p-1,
    0x1.07b518p99
  },
  { // Entry 59
    0x1.ee0f67015b9fb39ba6eb91d47829c913p-1,
    -0x1.07b518p99
  },
  { // Entry 60
    0x1.fef05d000666cb47f1632c478a6282a8p-1,
    0x1.07bf80p-4
  },
  { // Entry 61
    0x1.fef05d000666cb47f1632c478a6282a8p-1,
    -0x1.07bf80p-4
  },
  { // Entry 62
    0x1.16f4330000b44c8288679f8c79d36c4fp-6,
    0x1.07c1f0p5
  },
  { // Entry 63
    0x1.16f4330000b44c8288679f8c79d36c4fp-6,
    -0x1.07c1f0p5
  },
  { // Entry 64
    0x1.cfb404557277d85bf149496d46c2fa9fp-18,
    0x1.0bd21ep9
  },
  { // Entry 65
    0x1.cfb404557277d85bf149496d46c2fa9fp-18,
    -0x1.0bd21ep9
  },
  { // Entry 66
    0x1.bb543efffd6cacac12698b8a94ed2c3ep-1,
    0x1.0c3cp-1
  },
  { // Entry 67
    0x1.bb543efffd6cacac12698b8a94ed2c3ep-1,
    -0x1.0c3cp-1
  },
  { // Entry 68
    0x1.bb0a22c13b616cdcad32c7fca58e6643p-1,
    0x1.0cd0p-1
  },
  { // Entry 69
    0x1.bb0a22c13b616cdcad32c7fca58e6643p-1,
    -0x1.0cd0p-1
  },
  { // Entry 70
    0x1.f98f9b1d05e7c922ac5e5c6b6ac86876p-2,
    0x1.0df0p0
  },
  { // Entry 71
    0x1.f98f9b1d05e7c922ac5e5c6b6ac86876p-2,
    -0x1.0df0p0
  },
  { // Entry 72
    0x1.ee15181830c25b0b10ce671e8f7a3289p-1,
    0x1.0fb4p-2
  },
  { // Entry 73
    0x1.ee15181830c25b0b10ce671e8f7a3289p-1,
    -0x1.0fb4p-2
  },
  { // Entry 74
    0x1.edf6cc16defe6361f38ffa60ece3944cp-1,
    0x1.109ab2p-2
  },
  { // Entry 75
    0x1.edf6cc16defe6361f38ffa60ece3944cp-1,
    -0x1.109ab2p-2
  },
  { // Entry 76
    0x1.dee8d0fffcd997ce5cfbab0a5a336c14p-5,
    0x1.156564p4
  },
  { // Entry 77
    0x1.dee8d0fffcd997ce5cfbab0a5a336c14p-5,
    -0x1.156564p4
  },
  { // Entry 78
    0x1.b656d60000155bacb4aa874b28de2ff9p-1,
    0x1.160cp-1
  },
  { // Entry 79
    0x1.b656d60000155bacb4aa874b28de2ff9p-1,
    -0x1.160cp-1
  },
  { // Entry 80
    0x1.ffb275967c191ee95f862efb4f790cecp-1,
    0x1.19ccp-5
  },
  { // Entry 81
    0x1.ffb275967c191ee95f862efb4f790cecp-1,
    -0x1.19ccp-5
  },
  { // Entry 82
    0x1.c59c50ffe542233b7ea21100df87bb60p-2,
    0x1.1ca4p0
  },
  { // Entry 83
    0x1.c59c50ffe542233b7ea21100df87bb60p-2,
    -0x1.1ca4p0
  },
  { // Entry 84
    0x1.af630f86b77571b9de2f17fee2b6c5cep-5,
    0x1.1ffffep79
  },
  { // Entry 85
    0x1.af630f86b77571b9de2f17fee2b6c5cep-5,
    -0x1.1ffffep79
  },
  { // Entry 86
    0x1.b1493ef1fbc62673ec140c12adc5a134p-6,
    0x1.2620p10
  },
  { // Entry 87
    0x1.b1493ef1fbc62673ec140c12adc5a134p-6,
    -0x1.2620p10
  },
  { // Entry 88
    -0x1.ad00b6f15c6ac5c3e79ef55d2fec70bdp-5,
    0x1.2a3d62p2
  },
  { // Entry 89
    -0x1.ad00b6f15c6ac5c3e79ef55d2fec70bdp-5,
    -0x1.2a3d62p2
  },
  { // Entry 90
    -0x1.ab9984f283f114cf13cc6df38c67955fp-6,
    0x1.2bec22p2
  },
  { // Entry 91
    -0x1.ab9984f283f114cf13cc6df38c67955fp-6,
    -0x1.2bec22p2
  },
  { // Entry 92
    0x1.99bc5b961b1acaca18d971f68ae99da9p-27,
    0x1.2d97c8p2
  },
  { // Entry 93
    0x1.99bc5b961b1acaca18d971f68ae99da9p-27,
    -0x1.2d97c8p2
  },
  { // Entry 94
    -0x1.ffffffffffffd703498c3b8288563915p-1,
    0x1.2d97c8p3
  },
  { // Entry 95
    -0x1.ffffffffffffd703498c3b8288563915p-1,
    -0x1.2d97c8p3
  },
  { // Entry 96
    0x1.ffffffffffff5c0d2630ee0a27e8d6d1p-1,
    0x1.2d97c8p4
  },
  { // Entry 97
    0x1.ffffffffffff5c0d2630ee0a27e8d6d1p-1,
    -0x1.2d97c8p4
  },
  { // Entry 98
    -0x1.99b69cf0c4a2c8ddad3f4cf29453e509p-6,
    0x1.2fefc4p9
  },
  { // Entry 99
    -0x1.99b69cf0c4a2c8ddad3f4cf29453e509p-6,
    -0x1.2fefc4p9
  },
  { // Entry 100
    0x1.e92148328d620fc186df9d6ce1088fd9p-1,
    0x1.333724p-2
  },
  { // Entry 101
    0x1.e92148328d620fc186df9d6ce1088fd9p-1,
    -0x1.333724p-2
  },
  { // Entry 102
    0x1.a1caab00002d3189e0699f2aaf20d9fcp-1,
    0x1.3b90f8p-1
  },
  { // Entry 103
    0x1.a1caab00002d3189e0699f2aaf20d9fcp-1,
    -0x1.3b90f8p-1
  },
  { // Entry 104
    0x1.fc33baffffffbb055ce03690bd392531p-1,
    0x1.41c470p16
  },
  { // Entry 105
    0x1.fc33baffffffbb055ce03690bd392531p-1,
    -0x1.41c470p16
  },
  { // Entry 106
    0x1.4798b30672f21602a21aaf471e8259a0p-19,
    0x1.442f74p15
  },
  { // Entry 107
    0x1.4798b30672f21602a21aaf471e8259a0p-19,
    -0x1.442f74p15
  },
  { // Entry 108
    0x1.e2b5ecffffa49c8c68d743c47f624633p-1,
    0x1.5c09dap-2
  },
  { // Entry 109
    0x1.e2b5ecffffa49c8c68d743c47f624633p-1,
    -0x1.5c09dap-2
  },
  { // Entry 110
    0x1.10591094ac58a270d9ad91802df49fd0p-11,
    0x1.5fe0p3
  },
  { // Entry 111
    0x1.10591094ac58a270d9ad91802df49fd0p-11,
    -0x1.5fe0p3
  },
  { // Entry 112
    -0x1.fffe580ee141c0225b44281c1c6f7ff1p-1,
    0x1.665982p119
  },
  { // Entry 113
    -0x1.fffe580ee141c0225b44281c1c6f7ff1p-1,
    -0x1.665982p119
  },
  { // Entry 114
    -0x1.e2b8ecffed91ce3a4b9dc5a592fb0b14p-1,
    0x1.66a0bap1
  },
  { // Entry 115
    -0x1.e2b8ecffed91ce3a4b9dc5a592fb0b14p-1,
    -0x1.66a0bap1
  },
  { // Entry 116
    -0x1.a08c6cfdbe04b859c0e16d478ff81f7bp-5,
    0x1.6bee42p12
  },
  { // Entry 117
    -0x1.a08c6cfdbe04b859c0e16d478ff81f7bp-5,
    -0x1.6bee42p12
  },
  { // Entry 118
    0x1.ff7c719a18439c4267075e2df688343ap-1,
    0x1.6f1070p-5
  },
  { // Entry 119
    0x1.ff7c719a18439c4267075e2df688343ap-1,
    -0x1.6f1070p-5
  },
  { // Entry 120
    0x1.ff7c3b997d6bea661ef0d1e69e222bfep-1,
    0x1.6f5bc2p-5
  },
  { // Entry 121
    0x1.ff7c3b997d6bea661ef0d1e69e222bfep-1,
    -0x1.6f5bc2p-5
  },
  { // Entry 122
    -0x1.6a0a0ee68da131091e29e055226a1bd9p-1,
    0x1.72b53cp5
  },
  { // Entry 123
    -0x1.6a0a0ee68da131091e29e055226a1bd9p-1,
    -0x1.72b53cp5
  },
  { // Entry 124
    0x1.ff777b9a218985c1a191c92b2d11ffbap-1,
    0x1.75ec1ap-5
  },
  { // Entry 125
    0x1.ff777b9a218985c1a191c92b2d11ffbap-1,
    -0x1.75ec1ap-5
  },
  { // Entry 126
    0x1.6d487f92427920e81dc5ae34e0e8d7bap-2,
    0x1.78b3fap100
  },
  { // Entry 127
    0x1.6d487f92427920e81dc5ae34e0e8d7bap-2,
    -0x1.78b3fap100
  },
  { // Entry 128
    0x1.4949c2fffa0cd336dfda998216dae393p-4,
    0x1.7d8568p0
  },
  { // Entry 129
    0x1.4949c2fffa0cd336dfda998216dae393p-4,
    -0x1.7d8568p0
  },
  { // Entry 130
    -0x1.b9ed9eb33eacbfac8151cda113734c29p-1,
    0x1.830688p57
  },
  { // Entry 131
    -0x1.b9ed9eb33eacbfac8151cda113734c29p-1,
    -0x1.830688p57
  },
  { // Entry 132
    0x1.c7349af06d61394cae1912233f64a04ep-5,
    0x1.83e430p0
  },
  { // Entry 133
    0x1.c7349af06d61394cae1912233f64a04ep-5,
    -0x1.83e430p0
  },
  { // Entry 134
    0x1.ab73f0f0fe04403e6a7fdde141a38a8ep-5,
    0x1.84c288p0
  },
  { // Entry 135
    0x1.ab73f0f0fe04403e6a7fdde141a38a8ep-5,
    -0x1.84c288p0
  },
  { // Entry 136
    0x1.ff6c2799dcf0d6c8f7acaf5b0a46e6e2p-1,
    0x1.852140p-5
  },
  { // Entry 137
    0x1.ff6c2799dcf0d6c8f7acaf5b0a46e6e2p-1,
    -0x1.852140p-5
  },
  { // Entry 138
    0x1.ff69ed99de70e51f519f30bad247a4d9p-1,
    0x1.880cb6p-5
  },
  { // Entry 139
    0x1.ff69ed99de70e51f519f30bad247a4d9p-1,
    -0x1.880cb6p-5
  },
  { // Entry 140
    -0x1.fd76c57f872f85bc4b0e1bf591b3b5b0p-1,
    0x1.9364eap119
  },
  { // Entry 141
    -0x1.fd76c57f872f85bc4b0e1bf591b3b5b0p-1,
    -0x1.9364eap119
  },
  { // Entry 142
    -0x1.f87c1ceec5fd5811c9c089cdaeeff13cp-8,
    0x1.979e28p9
  },
  { // Entry 143
    -0x1.f87c1ceec5fd5811c9c089cdaeeff13cp-8,
    -0x1.979e28p9
  },
  { // Entry 144
    -0x1.16ae29144d3b1ea8d907b8776f704157p-26,
    0x1.9a48dep15
  },
  { // Entry 145
    -0x1.16ae29144d3b1ea8d907b8776f704157p-26,
    -0x1.9a48dep15
  },
  { // Entry 146
    -0x1.977552f8e6ab3c01cb29ec77803007cfp-13,
    0x1.9cbc1ap50
  },
  { // Entry 147
    -0x1.977552f8e6ab3c01cb29ec77803007cfp-13,
    -0x1.9cbc1ap50
  },
  { // Entry 148
    0x1.ff58c5ffffffc7266a9df4e921726771p-1,
    0x1.9ddb06p-5
  },
  { // Entry 149
    0x1.ff58c5ffffffc7266a9df4e921726771p-1,
    -0x1.9ddb06p-5
  },
  { // Entry 150
    0x1.fffffffffffff5700019fffff0094c15p-1,
    0x1.9ffffep-27
  },
  { // Entry 151
    0x1.fffffffffffff5700019fffff0094c15p-1,
    -0x1.9ffffep-27
  },
  { // Entry 152
    0x1.31bd63004b1ff4d722c745044706d517p-1,
    0x1.ac129cp24
  },
  { // Entry 153
    0x1.31bd63004b1ff4d722c745044706d517p-1,
    -0x1.ac129cp24
  },
  { // Entry 154
    -0x1.f1ad0f000009e06ce449f5bde03d5d1ap-1,
    0x1.b078f8p1
  },
  { // Entry 155
    -0x1.f1ad0f000009e06ce449f5bde03d5d1ap-1,
    -0x1.b078f8p1
  },
  { // Entry 156
    0x1.ff4776ffe324ba2958aca8d73cf8b839p-1,
    0x1.b2c03cp-5
  },
  { // Entry 157
    0x1.ff4776ffe324ba2958aca8d73cf8b839p-1,
    -0x1.b2c03cp-5
  },
  { // Entry 158
    0x1.ff437f00005e500d29bd8103a8e769e9p-1,
    0x1.b766f6p-5
  },
  { // Entry 159
    0x1.ff437f00005e500d29bd8103a8e769e9p-1,
    -0x1.b766f6p-5
  },
  { // Entry 160
    -0x1.99663da94db7348bcbb257ed16b7227cp-24,
    0x1.beeeeep79
  },
  { // Entry 161
    -0x1.99663da94db7348bcbb257ed16b7227cp-24,
    -0x1.beeeeep79
  },
  { // Entry 162
    0x1.f3d620ffffff860e49bbab8963dcc42ep-1,
    0x1.bf4e1cp-3
  },
  { // Entry 163
    0x1.f3d620ffffff860e49bbab8963dcc42ep-1,
    -0x1.bf4e1cp-3
  },
  { // Entry 164
    0x1.81ff79ed9201755f7ad18b533aa99d18p-1,
    0x1.c0p2
  },
  { // Entry 165
    0x1.81ff79ed9201755f7ad18b533aa99d18p-1,
    -0x1.c0p2
  },
  { // Entry 166
    -0x1.af3c6108887730fcecedf61d2d81ceabp-15,
    0x1.c20ec8p23
  },
  { // Entry 167
    -0x1.af3c6108887730fcecedf61d2d81ceabp-15,
    -0x1.c20ec8p23
  },
  { // Entry 168
    -0x1.b1656ef91447fa6a546cbd81034cafabp-14,
    0x1.c79d20p17
  },
  { // Entry 169
    -0x1.b1656ef91447fa6a546cbd81034cafabp-14,
    -0x1.c79d20p17
  },
  { // Entry 170
    0x1.2da1d3007a57461f6f67f2d3e983f798p-1,
    0x1.ca7ce0p24
  },
  { // Entry 171
    0x1.2da1d3007a57461f6f67f2d3e983f798p-1,
    -0x1.ca7ce0p24
  },
  { // Entry 172
    0x1.ffdd37888387ce3c9828144676f2ab0dp-1,
    0x1.cc31b8p18
  },
  { // Entry 173
    0x1.ffdd37888387ce3c9828144676f2ab0dp-1,
    -0x1.cc31b8p18
  },
  { // Entry 174
    0x1.395ba4ffffa061223f7304299be0aad8p-1,
    0x1.d30892p-1
  },
  { // Entry 175
    0x1.395ba4ffffa061223f7304299be0aad8p-1,
    -0x1.d30892p-1
  },
  { // Entry 176
    0x1.cb27c6ffd8e9d51a0605b57fd02ee483p-1,
    0x1.d5574cp-2
  },
  { // Entry 177
    0x1.cb27c6ffd8e9d51a0605b57fd02ee483p-1,
    -0x1.d5574cp-2
  },
  { // Entry 178
    0x1.a0a09cfd2b2b23476f09aa3eb631351cp-5,
    0x1.d7557ap12
  },
  { // Entry 179
    0x1.a0a09cfd2b2b23476f09aa3eb631351cp-5,
    -0x1.d7557ap12
  },
  { // Entry 180
    0x1.38ae6d000c49df5001baf701b1a2a564p-1,
    0x1.dbe75cp24
  },
  { // Entry 181
    0x1.38ae6d000c49df5001baf701b1a2a564p-1,
    -0x1.dbe75cp24
  },
  { // Entry 182
    0x1.ffff1f00125abf3d1765781b64e6fe07p-1,
    0x1.dffffep-9
  },
  { // Entry 183
    0x1.ffff1f00125abf3d1765781b64e6fe07p-1,
    -0x1.dffffep-9
  },
  { // Entry 184
    -0x1.9abc76f7eb1d15a727e0be7ab16400a7p-1,
    0x1.e02a42p108
  },
  { // Entry 185
    -0x1.9abc76f7eb1d15a727e0be7ab16400a7p-1,
    -0x1.e02a42p108
  },
  { // Entry 186
    0x1.5a1429044eb087032dbee719cdd30226p-1,
    0x1.e701eap100
  },
  { // Entry 187
    0x1.5a1429044eb087032dbee719cdd30226p-1,
    -0x1.e701eap100
  },
  { // Entry 188
    -0x1.94ffc0f8d888f6f46c6d55a2efa1083fp-1,
    0x1.edf188p24
  },
  { // Entry 189
    -0x1.94ffc0f8d888f6f46c6d55a2efa1083fp-1,
    -0x1.edf188p24
  },
  { // Entry 190
    -0x1.27c6d300d8756e78846b84a1fa3b12a2p-1,
    0x1.f4c63ap24
  },
  { // Entry 191
    -0x1.27c6d300d8756e78846b84a1fa3b12a2p-1,
    -0x1.f4c63ap24
  },
  { // Entry 192
    0x1.da54ecefb1cd39510555126a76cb20d4p-7,
    0x1.f5ba76p2
  },
  { // Entry 193
    0x1.da54ecefb1cd39510555126a76cb20d4p-7,
    -0x1.f5ba76p2
  },
  { // Entry 194
    0x1.fc28da000006bc4f0b0cd3c8ab10fc57p-1,
    0x1.f5ff4ep-4
  },
  { // Entry 195
    0x1.fc28da000006bc4f0b0cd3c8ab10fc57p-1,
    -0x1.f5ff4ep-4
  },
  { // Entry 196
    -0x1.ffffffffffea396ab8aee509392c755dp-1,
    0x1.f6a7a2p3
  },
  { // Entry 197
    -0x1.ffffffffffea396ab8aee509392c755dp-1,
    -0x1.f6a7a2p3
  },
  { // Entry 198
    0x1.a4f1d4fd0ea286f32f3cb3092b4ced14p-5,
    0x1.f6bff2p12
  },
  { // Entry 199
    0x1.a4f1d4fd0ea286f32f3cb3092b4ced14p-5,
    -0x1.f6bff2p12
  },
  { // Entry 200
    -0x1.fffffffffffffaf33de290ca99e2faf3p-1,
    0x1.f9cbe2p8
  },
  { // Entry 201
    -0x1.fffffffffffffaf33de290ca99e2faf3p-1,
    -0x1.f9cbe2p8
  },
  { // Entry 202
    0x1.fdd40d6d912ce2594f200104570ac1b3p-3,
    0x1.fc767ep12
  },
  { // Entry 203
    0x1.fdd40d6d912ce2594f200104570ac1b3p-3,
    -0x1.fc767ep12
  },
  { // Entry 204
    -0x1.752de2ffffb1a5e227bf2c12f4083203p-1,
    0x1.ff5352p8
  },
  { // Entry 205
    -0x1.752de2ffffb1a5e227bf2c12f4083203p-1,
    -0x1.ff5352p8
  },
  { // Entry 206
    -0x1.4ed4c5ffc8018741870949767ff8dafap-1,
    0x1.fff1fep1
  },
  { // Entry 207
    -0x1.4ed4c5ffc8018741870949767ff8dafap-1,
    -0x1.fff1fep1
  },
  { // Entry 208
    -0x1.28406a0025545c9a568dacd45518dd65p-3,
    0x1.fff1fep2
  },
  { // Entry 209
    -0x1.28406a0025545c9a568dacd45518dd65p-3,
    -0x1.fff1fep2
  },
  { // Entry 210
    0x1.f015c8c24ca5e99c7c65599c8d60976ep-1,
    0x1.fff7fep-3
  },
  { // Entry 211
    0x1.f015c8c24ca5e99c7c65599c8d60976ep-1,
    -0x1.fff7fep-3
  },
  { // Entry 212
    0x1.aff9b45e94d32d8e5bde25dec6f357d6p-9,
    0x1.fffe3ep41
  },
  { // Entry 213
    0x1.aff9b45e94d32d8e5bde25dec6f357d6p-9,
    -0x1.fffe3ep41
  },
  { // Entry 214
    -0x1.ea5464fff571f6ff335004eade301b56p-1,
    0x1.ffff8ep3
  },
  { // Entry 215
    -0x1.ea5464fff571f6ff335004eade301b56p-1,
    -0x1.ffff8ep3
  },
  { // Entry 216
    0x1.fffd4e735df6db6a7ca7cb0436e6ef48p-1,
    0x1.ffff8ep40
  },
  { // Entry 217
    0x1.fffd4e735df6db6a7ca7cb0436e6ef48p-1,
    -0x1.ffff8ep40
  },
  { // Entry 218
    -0x1.88e527ffedd85d2e2429166f795d9788p-7,
    0x1.ffff9ep45
  },
  { // Entry 219
    -0x1.88e527ffedd85d2e2429166f795d9788p-7,
    -0x1.ffff9ep45
  },
  { // Entry 220
    -0x1.db8fa0e071f98061f27ef67161511437p-3,
    0x1.ffffbap23
  },
  { // Entry 221
    -0x1.db8fa0e071f98061f27ef67161511437p-3,
    -0x1.ffffbap23
  },
  { // Entry 222
    -0x1.fe5b337f4cfe25d468defe65d5c524adp-1,
    0x1.ffffdcp8
  },
  { // Entry 223
    -0x1.fe5b337f4cfe25d468defe65d5c524adp-1,
    -0x1.ffffdcp8
  },
  { // Entry 224
    -0x1.f59038f4c2dd33d159171ee80bb64886p-5,
    0x1.fffff8p118
  },
  { // Entry 225
    -0x1.f59038f4c2dd33d159171ee80bb64886p-5,
    -0x1.fffff8p118
  },
  { // Entry 226
    0x1.fffffc00001155553a7d27f4a289f319p-1,
    0x1.fffffcp-12
  },
  { // Entry 227
    0x1.fffffc00001155553a7d27f4a289f319p-1,
    -0x1.fffffcp-12
  },
  { // Entry 228
    -0x1.f9d6bdd62473cd2b729fe3a67a4e9157p-4,
    0x1.fffffcp22
  },
  { // Entry 229
    -0x1.f9d6bdd62473cd2b729fe3a67a4e9157p-4,
    -0x1.fffffcp22
  },
  { // Entry 230
    0x1.eb408300005d91b9814cada88f5fc596p-1,
    0x1.24836cp-2
  },
  { // Entry 231
    0x1.eb408300005d91b9814cada88f5fc596p-1,
    -0x1.24836cp-2
  },
  { // Entry 232
    0x1.ffffffffffffffffffffffffffffffffp-1,
    -0x1.p-149
  },
  { // Entry 233
    0x1.ffffffffffffffffffffffffffffffffp-1,
    0x1.p-149
  },
  { // Entry 234
    0x1.p0,
    0.0
  },
  { // Entry 235
    0x1.ffffffffffffffffffffffffffffffffp-1,
    0x1.p-149
  },
  { // Entry 236
    0x1.ffffffffffffffffffffffffffffffffp-1,
    -0x1.p-149
  },
  { // Entry 237
    0x1.ffffffffffffffffffffffffffffffffp-1,
    -0x1.000002p-126
  },
  { // Entry 238
    0x1.ffffffffffffffffffffffffffffffffp-1,
    0x1.000002p-126
  },
  { // Entry 239
    0x1.ffffffffffffffffffffffffffffffffp-1,
    -0x1.p-126
  },
  { // Entry 240
    0x1.ffffffffffffffffffffffffffffffffp-1,
    0x1.p-126
  },
  { // Entry 241
    0x1.ffffffffffffffffffffffffffffffffp-1,
    -0x1.fffffcp-127
  },
  { // Entry 242
    0x1.ffffffffffffffffffffffffffffffffp-1,
    0x1.fffffcp-127
  },
  { // Entry 243
    0x1.ffffffffffffffffffffffffffffffffp-1,
    0x1.fffffcp-127
  },
  { // Entry 244
    0x1.ffffffffffffffffffffffffffffffffp-1,
    -0x1.fffffcp-127
  },
  { // Entry 245
    0x1.ffffffffffffffffffffffffffffffffp-1,
    0x1.p-126
  },
  { // Entry 246
    0x1.ffffffffffffffffffffffffffffffffp-1,
    -0x1.p-126
  },
  { // Entry 247
    0x1.ffffffffffffffffffffffffffffffffp-1,
    0x1.000002p-126
  },
  { // Entry 248
    0x1.ffffffffffffffffffffffffffffffffp-1,
    -0x1.000002p-126
  },
  { // Entry 249
    0x1.ffffff5c28f57960cd56ebfe9482a61fp-1,
    0x1.99999ap-13
  },
  { // Entry 250
    0x1.ffffff5c28f57960cd56ebfe9482a61fp-1,
    -0x1.99999ap-13
  },
  { // Entry 251
    0x1.fffffd70a3d64e5ec165cd4307ad1326p-1,
    0x1.99999ap-12
  },
  { // Entry 252
    0x1.fffffd70a3d64e5ec165cd4307ad1326p-1,
    -0x1.99999ap-12
  },
  { // Entry 253
    0x1.fffffa3d709eecbfb5a385b0f3e0cb8fp-1,
    0x1.333334p-11
  },
  { // Entry 254
    0x1.fffffa3d709eecbfb5a385b0f3e0cb8fp-1,
    -0x1.333334p-11
  },
  { // Entry 255
    0x1.fffff5c28f5fc733c4202aa0bda92f97p-1,
    0x1.99999ap-11
  },
  { // Entry 256
    0x1.fffff5c28f5fc733c4202aa0bda92f97p-1,
    -0x1.99999ap-11
  },
  { // Entry 257
    0x1.fffff0000015555549f49f4d34d34ca0p-1,
    0x1.p-10
  },
  { // Entry 258
    0x1.fffff0000015555549f49f4d34d34ca0p-1,
    -0x1.p-10
  },
  { // Entry 259
    0x1.ffffe8f5c29ce07640bd5f6d8bb1ea6bp-1,
    0x1.333334p-10
  },
  { // Entry 260
    0x1.ffffe8f5c29ce07640bd5f6d8bb1ea6bp-1,
    -0x1.333334p-10
  },
  { // Entry 261
    0x1.ffffe0a3d714839f3601147ada73f8d9p-1,
    0x1.666668p-10
  },
  { // Entry 262
    0x1.ffffe0a3d714839f3601147ada73f8d9p-1,
    -0x1.666668p-10
  },
  { // Entry 263
    0x1.ffffd70a3d8191f66de5408fb2b995a0p-1,
    0x1.99999cp-10
  },
  { // Entry 264
    0x1.ffffd70a3d8191f66de5408fb2b995a0p-1,
    -0x1.99999cp-10
  },
  { // Entry 265
    0x1.ffffcc28f6d096b87d6d19a06e96999bp-1,
    0x1.ccccccp-10
  },
  { // Entry 266
    0x1.ffffcc28f6d096b87d6d19a06e96999bp-1,
    -0x1.ccccccp-10
  },
  { // Entry 267
    0x1.fffbcc2a71ceaabf5582b6da1fc30531p-1,
    0x1.066666p-7
  },
  { // Entry 268
    0x1.fffbcc2a71ceaabf5582b6da1fc30531p-1,
    -0x1.066666p-7
  },
  { // Entry 269
    0x1.fff30a4b7b5119d8e299f717ec0ece16p-1,
    0x1.ccccccp-7
  },
  { // Entry 270
    0x1.fff30a4b7b5119d8e299f717ec0ece16p-1,
    -0x1.ccccccp-7
  },
  { // Entry 271
    0x1.ffe57a785123226c1e2efb411353edc9p-1,
    0x1.499998p-6
  },
  { // Entry 272
    0x1.ffe57a785123226c1e2efb411353edc9p-1,
    -0x1.499998p-6
  },
  { // Entry 273
    0x1.ffd31cd10cb632d9733ac5f5f327a5f9p-1,
    0x1.acccccp-6
  },
  { // Entry 274
    0x1.ffd31cd10cb632d9733ac5f5f327a5f9p-1,
    -0x1.acccccp-6
  },
  { // Entry 275
    0x1.ffbbf18207542ef81390d73c3ba89c1ap-1,
    0x1.08p-5
  },
  { // Entry 276
    0x1.ffbbf18207542ef81390d73c3ba89c1ap-1,
    -0x1.08p-5
  },
  { // Entry 277
    0x1.ff9ff8c2eaeaee30fb211765af835171p-1,
    0x1.39999ap-5
  },
  { // Entry 278
    0x1.ff9ff8c2eaeaee30fb211765af835171p-1,
    -0x1.39999ap-5
  },
  { // Entry 279
    0x1.ff7f32d6eb1f9cf90226ec291c9e0922p-1,
    0x1.6b3334p-5
  },
  { // Entry 280
    0x1.ff7f32d6eb1f9cf90226ec291c9e0922p-1,
    -0x1.6b3334p-5
  },
  { // Entry 281
    0x1.ff59a00cc4ad492ca2597495412998edp-1,
    0x1.9ccccep-5
  },
  { // Entry 282
    0x1.ff59a00cc4ad492ca2597495412998edp-1,
    -0x1.9ccccep-5
  },
  { // Entry 283
    0x1.ff2f40c08acf4580a8d13380d9073398p-1,
    0x1.ce6666p-5
  },
  { // Entry 284
    0x1.ff2f40c08acf4580a8d13380d9073398p-1,
    -0x1.ce6666p-5
  },
  { // Entry 285
    0x1.8ca46ca011771bfae0d9edbf1dacb402p-1,
    0x1.5e7fc4p-1
  },
  { // Entry 286
    0x1.8ca46ca011771bfae0d9edbf1dacb402p-1,
    -0x1.5e7fc4p-1
  },
  { // Entry 287
    0x1.0b5d38d5d82e4a7624dac4e10ce159c2p-2,
    0x1.4e7fc4p0
  },
  { // Entry 288
    0x1.0b5d38d5d82e4a7624dac4e10ce159c2p-2,
    -0x1.4e7fc4p0
  },
  { // Entry 289
    -0x1.66b96e204e69cda8e9cf50996432539ep-2,
    0x1.edbfa6p0
  },
  { // Entry 290
    -0x1.66b96e204e69cda8e9cf50996432539ep-2,
    -0x1.edbfa6p0
  },
  { // Entry 291
    -0x1.a935540edeca4c220ed91dc5481e4d9bp-1,
    0x1.467fc4p1
  },
  { // Entry 292
    -0x1.a935540edeca4c220ed91dc5481e4d9bp-1,
    -0x1.467fc4p1
  },
  { // Entry 293
    -0x1.ffc0017dd9209dd8891f17fe4c9eee46p-1,
    0x1.961fb4p1
  },
  { // Entry 294
    -0x1.ffc0017dd9209dd8891f17fe4c9eee46p-1,
    -0x1.961fb4p1
  },
  { // Entry 295
    -0x1.969082007733d787f4c36ba0f9425694p-1,
    0x1.e5bfa4p1
  },
  { // Entry 296
    -0x1.969082007733d787f4c36ba0f9425694p-1,
    -0x1.e5bfa4p1
  },
  { // Entry 297
    -0x1.2a1e74223d9bddb7db59f781f96b65ecp-2,
    0x1.1aafcap2
  },
  { // Entry 298
    -0x1.2a1e74223d9bddb7db59f781f96b65ecp-2,
    -0x1.1aafcap2
  },
  { // Entry 299
    0x1.4894d50b84dbc981134a591ac4165d9ep-2,
    0x1.427fc2p2
  },
  { // Entry 300
    0x1.4894d50b84dbc981134a591ac4165d9ep-2,
    -0x1.427fc2p2
  },
  { // Entry 301
    0x1.a016dd7480a1eea4d49efb585fa49c86p-1,
    0x1.6a4fbap2
  },
  { // Entry 302
    0x1.a016dd7480a1eea4d49efb585fa49c86p-1,
    -0x1.6a4fbap2
  },
  { // Entry 303
    0x1.a30a6a3bf4a3e2b7e27666d3a9c3b74bp-1,
    0x1.6af2f0p2
  },
  { // Entry 304
    0x1.a30a6a3bf4a3e2b7e27666d3a9c3b74bp-1,
    -0x1.6af2f0p2
  },
  { // Entry 305
    0x1.5bd625504015ccc101e4f4340d4b762bp-2,
    0x1.43c62ap2
  },
  { // Entry 306
    0x1.5bd625504015ccc101e4f4340d4b762bp-2,
    -0x1.43c62ap2
  },
  { // Entry 307
    -0x1.0cb733448c30ee3ddffb4da69f0b3842p-2,
    0x1.1c9964p2
  },
  { // Entry 308
    -0x1.0cb733448c30ee3ddffb4da69f0b3842p-2,
    -0x1.1c9964p2
  },
  { // Entry 309
    -0x1.89d874ad30e3fb46244daa24451690d7p-1,
    0x1.ead93cp1
  },
  { // Entry 310
    -0x1.89d874ad30e3fb46244daa24451690d7p-1,
    -0x1.ead93cp1
  },
  { // Entry 311
    -0x1.fe51ae09f0d39ed554e68bef3e2f8a03p-1,
    0x1.9c7fb0p1
  },
  { // Entry 312
    -0x1.fe51ae09f0d39ed554e68bef3e2f8a03p-1,
    -0x1.9c7fb0p1
  },
  { // Entry 313
    -0x1.b97bf76ae765eb69cf55e80aae977303p-1,
    0x1.4e2624p1
  },
  { // Entry 314
    -0x1.b97bf76ae765eb69cf55e80aae977303p-1,
    -0x1.4e2624p1
  },
  { // Entry 315
    -0x1.a8ac5793e32629b131984ecffd2d0f31p-2,
    0x1.ff9932p0
  },
  { // Entry 316
    -0x1.a8ac5793e32629b131984ecffd2d0f31p-2,
    -0x1.ff9932p0
  },
  { // Entry 317
    0x1.77a92ca01bc79c195dda33736807f986p-3,
    0x1.62e61cp0
  },
  { // Entry 318
    0x1.77a92ca01bc79c195dda33736807f986p-3,
    -0x1.62e61cp0
  },
  { // Entry 319
    0x1.6e1060282c1488d9abd83da1d68cd0f7p-1,
    0x1.8c662cp-1
  },
  { // Entry 320
    0x1.6e1060282c1488d9abd83da1d68cd0f7p-1,
    -0x1.8c662cp-1
  },
  { // Entry 321
    -0x1.682f2bb87a8f5011735094176c9b6dacp-4,
    -0x1.a8aa1cp0
  },
  { // Entry 322
    -0x1.682f2bb87a8f5011735094176c9b6dacp-4,
    0x1.a8aa1cp0
  },
  { // Entry 323
    -0x1.e665cb2af842be5ba5f65960599a97ecp-7,
    -0x1.95ec8ap0
  },
  { // Entry 324
    -0x1.e665cb2af842be5ba5f65960599a97ecp-7,
    0x1.95ec8ap0
  },
  { // Entry 325
    0x1.ddd231501b12fcf2bc20633be4d51e51p-5,
    -0x1.832ef8p0
  },
  { // Entry 326
    0x1.ddd231501b12fcf2bc20633be4d51e51p-5,
    0x1.832ef8p0
  },
  { // Entry 327
    0x1.0caba6997691ab1970d43c7419ed51e1p-3,
    -0x1.707166p0
  },
  { // Entry 328
    0x1.0caba6997691ab1970d43c7419ed51e1p-3,
    0x1.707166p0
  },
  { // Entry 329
    0x1.a072541fd6eaf8b65a874c58d6cc5739p-3,
    -0x1.5db3d4p0
  },
  { // Entry 330
    0x1.a072541fd6eaf8b65a874c58d6cc5739p-3,
    0x1.5db3d4p0
  },
  { // Entry 331
    0x1.18fef8106bea63b9e96a7adf538c6194p-2,
    -0x1.4af642p0
  },
  { // Entry 332
    0x1.18fef8106bea63b9e96a7adf538c6194p-2,
    0x1.4af642p0
  },
  { // Entry 333
    0x1.60437277d48067e85230bce1883eaabap-2,
    -0x1.3838b0p0
  },
  { // Entry 334
    0x1.60437277d48067e85230bce1883eaabap-2,
    0x1.3838b0p0
  },
  { // Entry 335
    0x1.a5a4ded492bedfe8cf5c34cadd78df75p-2,
    -0x1.257b1ep0
  },
  { // Entry 336
    0x1.a5a4ded492bedfe8cf5c34cadd78df75p-2,
    0x1.257b1ep0
  },
  { // Entry 337
    0x1.e8c4040678d2ef736333a4537a1113a1p-2,
    -0x1.12bd92p0
  },
  { // Entry 338
    0x1.e8c4040678d2ef736333a4537a1113a1p-2,
    0x1.12bd92p0
  },
  { // Entry 339
    0x1.26976b1b16d19091c09259765c4b3872p-1,
    -0x1.ea5c3ep-1
  },
  { // Entry 340
    0x1.26976b1b16d19091c09259765c4b3872p-1,
    0x1.ea5c3ep-1
  },
  { // Entry 341
    0x1.3805a2dafda7f8554aec65dab348a714p-1,
    -0x1.d4b87cp-1
  },
  { // Entry 342
    0x1.3805a2dafda7f8554aec65dab348a714p-1,
    0x1.d4b87cp-1
  },
  { // Entry 343
    0x1.48e52ff5bbe794618b85190b86411824p-1,
    -0x1.bf14bap-1
  },
  { // Entry 344
    0x1.48e52ff5bbe794618b85190b86411824p-1,
    0x1.bf14bap-1
  },
  { // Entry 345
    0x1.592e5b615ef5ae463976d31141dbacf0p-1,
    -0x1.a970f8p-1
  },
  { // Entry 346
    0x1.592e5b615ef5ae463976d31141dbacf0p-1,
    0x1.a970f8p-1
  },
  { // Entry 347
    0x1.68d9b2d657e4307d331eb7bd35ee1879p-1,
    -0x1.93cd36p-1
  },
  { // Entry 348
    0x1.68d9b2d657e4307d331eb7bd35ee1879p-1,
    0x1.93cd36p-1
  },
  { // Entry 349
    0x1.77e00c3718528c36f722e63096c2646bp-1,
    -0x1.7e2974p-1
  },
  { // Entry 350
    0x1.77e00c3718528c36f722e63096c2646bp-1,
    0x1.7e2974p-1
  },
  { // Entry 351
    0x1.863a88d6b064f36f34370722d361ce9fp-1,
    -0x1.6885b2p-1
  },
  { // Entry 352
    0x1.863a88d6b064f36f34370722d361ce9fp-1,
    0x1.6885b2p-1
  },
  { // Entry 353
    0x1.93e2989cee6084e34b533b1eb92746dap-1,
    -0x1.52e1f0p-1
  },
  { // Entry 354
    0x1.93e2989cee6084e34b533b1eb92746dap-1,
    0x1.52e1f0p-1
  },
  { // Entry 355
    0x1.a0d1f8613ebc60c7ee6502ee183c89e7p-1,
    -0x1.3d3e36p-1
  },
  { // Entry 356
    0x1.a0d1f8613ebc60c7ee6502ee183c89e7p-1,
    0x1.3d3e36p-1
  },
  { // Entry 357
    0x1.bc6bd889a8a59dbb56e546a37ae798f5p-1,
    -0x1.0a0b02p-1
  },
  { // Entry 358
    0x1.bc6bd889a8a59dbb56e546a37ae798f5p-1,
    0x1.0a0b02p-1
  },
  { // Entry 359
    0x1.ca59c719f96075dd6b7a0ff443ad59dcp-1,
    -0x1.d8f720p-2
  },
  { // Entry 360
    0x1.ca59c719f96075dd6b7a0ff443ad59dcp-1,
    0x1.d8f720p-2
  },
  { // Entry 361
    0x1.d6c0b13df99613a49306b4dc6c57aa03p-1,
    -0x1.9dd83cp-2
  },
  { // Entry 362
    0x1.d6c0b13df99613a49306b4dc6c57aa03p-1,
    0x1.9dd83cp-2
  },
  { // Entry 363
    0x1.e1960273a4aaa1bd19ef0ccaa8874183p-1,
    -0x1.62b958p-2
  },
  { // Entry 364
    0x1.e1960273a4aaa1bd19ef0ccaa8874183p-1,
    0x1.62b958p-2
  },
  { // Entry 365
    0x1.ead07cd2e0f7f19679646362bbc0eb80p-1,
    -0x1.279a74p-2
  },
  { // Entry 366
    0x1.ead07cd2e0f7f19679646362bbc0eb80p-1,
    0x1.279a74p-2
  },
  { // Entry 367
    0x1.f26840efd86ceea23f388b6a1102ea4dp-1,
    -0x1.d8f720p-3
  },
  { // Entry 368
    0x1.f26840efd86ceea23f388b6a1102ea4dp-1,
    0x1.d8f720p-3
  },
  { // Entry 369
    0x1.f856d49251bd37c54f0094270eecbd18p-1,
    -0x1.62b958p-3
  },
  { // Entry 370
    0x1.f856d49251bd37c54f0094270eecbd18p-1,
    0x1.62b958p-3
  },
  { // Entry 371
    0x1.fc97283c4f5bd1f793201972b8db551fp-1,
    -0x1.d8f720p-4
  },
  { // Entry 372
    0x1.fc97283c4f5bd1f793201972b8db551fp-1,
    0x1.d8f720p-4
  },
  { // Entry 373
    0x1.ff259b7b3d721edf063a5bf6e7a1f93cp-1,
    -0x1.d8f720p-5
  },
  { // Entry 374
    0x1.ff259b7b3d721edf063a5bf6e7a1f93cp-1,
    0x1.d8f720p-5
  },
  { // Entry 375
    0x1.ff259b7b3d721edf063a5bf6e7a1f93cp-1,
    0x1.d8f720p-5
  },
  { // Entry 376
    0x1.ff259b7b3d721edf063a5bf6e7a1f93cp-1,
    -0x1.d8f720p-5
  },
  { // Entry 377
    0x1.fc97283c4f5bd1f793201972b8db551fp-1,
    0x1.d8f720p-4
  },
  { // Entry 378
    0x1.fc97283c4f5bd1f793201972b8db551fp-1,
    -0x1.d8f720p-4
  },
  { // Entry 379
    0x1.f856d49251bd37c54f0094270eecbd18p-1,
    0x1.62b958p-3
  },
  { // Entry 380
    0x1.f856d49251bd37c54f0094270eecbd18p-1,
    -0x1.62b958p-3
  },
  { // Entry 381
    0x1.f26840efd86ceea23f388b6a1102ea4dp-1,
    0x1.d8f720p-3
  },
  { // Entry 382
    0x1.f26840efd86ceea23f388b6a1102ea4dp-1,
    -0x1.d8f720p-3
  },
  { // Entry 383
    0x1.ead07cd2e0f7f19679646362bbc0eb80p-1,
    0x1.279a74p-2
  },
  { // Entry 384
    0x1.ead07cd2e0f7f19679646362bbc0eb80p-1,
    -0x1.279a74p-2
  },
  { // Entry 385
    0x1.e1960273a4aaa1bd19ef0ccaa8874183p-1,
    0x1.62b958p-2
  },
  { // Entry 386
    0x1.e1960273a4aaa1bd19ef0ccaa8874183p-1,
    -0x1.62b958p-2
  },
  { // Entry 387
    0x1.d6c0b13df99613a49306b4dc6c57aa03p-1,
    0x1.9dd83cp-2
  },
  { // Entry 388
    0x1.d6c0b13df99613a49306b4dc6c57aa03p-1,
    -0x1.9dd83cp-2
  },
  { // Entry 389
    0x1.ca59c719f96075dd6b7a0ff443ad59dcp-1,
    0x1.d8f720p-2
  },
  { // Entry 390
    0x1.ca59c719f96075dd6b7a0ff443ad59dcp-1,
    -0x1.d8f720p-2
  },
  { // Entry 391
    0x1.bc6bd889a8a59dbb56e546a37ae798f5p-1,
    0x1.0a0b02p-1
  },
  { // Entry 392
    0x1.bc6bd889a8a59dbb56e546a37ae798f5p-1,
    -0x1.0a0b02p-1
  },
  { // Entry 393
    0x1.a0d1f8613ebc60c7ee6502ee183c89e7p-1,
    0x1.3d3e36p-1
  },
  { // Entry 394
    0x1.a0d1f8613ebc60c7ee6502ee183c89e7p-1,
    -0x1.3d3e36p-1
  },
  { // Entry 395
    0x1.93e293b23a6aa1ae5373214eb8fb9e96p-1,
    0x1.52e1f8p-1
  },
  { // Entry 396
    0x1.93e293b23a6aa1ae5373214eb8fb9e96p-1,
    -0x1.52e1f8p-1
  },
  { // Entry 397
    0x1.863a83a8d9826c6135509406ebe05c0fp-1,
    0x1.6885bap-1
  },
  { // Entry 398
    0x1.863a83a8d9826c6135509406ebe05c0fp-1,
    -0x1.6885bap-1
  },
  { // Entry 399
    0x1.77e006c87cbaded66ec5b960c93c568ap-1,
    0x1.7e297cp-1
  },
  { // Entry 400
    0x1.77e006c87cbaded66ec5b960c93c568ap-1,
    -0x1.7e297cp-1
  },
  { // Entry 401
    0x1.68d9ad29736c1704caea6a2db6e71223p-1,
    0x1.93cd3ep-1
  },
  { // Entry 402
    0x1.68d9ad29736c1704caea6a2db6e71223p-1,
    -0x1.93cd3ep-1
  },
  { // Entry 403
    0x1.592e5578c9ec66acceddd4dc6ce66b26p-1,
    0x1.a971p-1
  },
  { // Entry 404
    0x1.592e5578c9ec66acceddd4dc6ce66b26p-1,
    -0x1.a971p-1
  },
  { // Entry 405
    0x1.48e529d429e721ec8bb1e014f94d48f1p-1,
    0x1.bf14c2p-1
  },
  { // Entry 406
    0x1.48e529d429e721ec8bb1e014f94d48f1p-1,
    -0x1.bf14c2p-1
  },
  { // Entry 407
    0x1.38059c833c58ea970f7b96d6ada3d9c4p-1,
    0x1.d4b884p-1
  },
  { // Entry 408
    0x1.38059c833c58ea970f7b96d6ada3d9c4p-1,
    -0x1.d4b884p-1
  },
  { // Entry 409
    0x1.26976b1b16d19091c09259765c4b3872p-1,
    0x1.ea5c3ep-1
  },
  { // Entry 410
    0x1.26976b1b16d19091c09259765c4b3872p-1,
    -0x1.ea5c3ep-1
  },
  { // Entry 411
    0x1.e8c4040678d2ef736333a4537a1113a1p-2,
    0x1.12bd92p0
  },
  { // Entry 412
    0x1.e8c4040678d2ef736333a4537a1113a1p-2,
    -0x1.12bd92p0
  },
  { // Entry 413
    0x1.a5a4c8f598fa0078971316eb4907f97bp-2,
    0x1.257b24p0
  },
  { // Entry 414
    0x1.a5a4c8f598fa0078971316eb4907f97bp-2,
    -0x1.257b24p0
  },
  { // Entry 415
    0x1.60435beed10ca05769f0a3d86a5a20f3p-2,
    0x1.3838b6p0
  },
  { // Entry 416
    0x1.60435beed10ca05769f0a3d86a5a20f3p-2,
    -0x1.3838b6p0
  },
  { // Entry 417
    0x1.18fee0fc45c31a79b2b9478b1f72a9ebp-2,
    0x1.4af648p0
  },
  { // Entry 418
    0x1.18fee0fc45c31a79b2b9478b1f72a9ebp-2,
    -0x1.4af648p0
  },
  { // Entry 419
    0x1.a072252090c33828767aee3e040ccddfp-3,
    0x1.5db3dap0
  },
  { // Entry 420
    0x1.a072252090c33828767aee3e040ccddfp-3,
    -0x1.5db3dap0
  },
  { // Entry 421
    0x1.0cab7703a8e9dacc4ad01188b443cfeep-3,
    0x1.70716cp0
  },
  { // Entry 422
    0x1.0cab7703a8e9dacc4ad01188b443cfeep-3,
    -0x1.70716cp0
  },
  { // Entry 423
    0x1.ddd171a3c9851e7819b5e4f6f90e763dp-5,
    0x1.832efep0
  },
  { // Entry 424
    0x1.ddd171a3c9851e7819b5e4f6f90e763dp-5,
    -0x1.832efep0
  },
  { // Entry 425
    -0x1.e668cb154eea68bbc7f8154f46b2e536p-7,
    0x1.95ec90p0
  },
  { // Entry 426
    -0x1.e668cb154eea68bbc7f8154f46b2e536p-7,
    -0x1.95ec90p0
  },
  { // Entry 427
    -0x1.682f2bb87a8f5011735094176c9b6dacp-4,
    0x1.a8aa1cp0
  },
  { // Entry 428
    -0x1.682f2bb87a8f5011735094176c9b6dacp-4,
    -0x1.a8aa1cp0
  },
  { // Entry 429
    0x1.0cb3449a0d0a9e0643d41f4a5b0f7db7p-1,
    0x1.04aff8p0
  },
  { // Entry 430
    0x1.0cb3449a0d0a9e0643d41f4a5b0f7db7p-1,
    -0x1.04aff8p0
  },
  { // Entry 431
    0x1.0cb22697153bcf1f8a63acddd96c54cbp-1,
    0x1.04b0a0p0
  },
  { // Entry 432
    0x1.0cb22697153bcf1f8a63acddd96c54cbp-1,
    -0x1.04b0a0p0
  },
  { // Entry 433
    0x1.0cb10893a9b5471a44356072cb33b395p-1,
    0x1.04b148p0
  },
  { // Entry 434
    0x1.0cb10893a9b5471a44356072cb33b395p-1,
    -0x1.04b148p0
  },
  { // Entry 435
    0x1.0cafea8fca7781236a57e5b1c8aed39cp-1,
    0x1.04b1f0p0
  },
  { // Entry 436
    0x1.0cafea8fca7781236a57e5b1c8aed39cp-1,
    -0x1.04b1f0p0
  },
  { // Entry 437
    0x1.0caecc8b7782f86827af92b0b2374510p-1,
    0x1.04b298p0
  },
  { // Entry 438
    0x1.0caecc8b7782f86827af92b0b2374510p-1,
    -0x1.04b298p0
  },
  { // Entry 439
    0x1.0cadae86b0d82815d8f632e67c7e1a99p-1,
    0x1.04b340p0
  },
  { // Entry 440
    0x1.0cadae86b0d82815d8f632e67c7e1a99p-1,
    -0x1.04b340p0
  },
  { // Entry 441
    0x1.0cac908176778b5a0cbad21ee75ce765p-1,
    0x1.04b3e8p0
  },
  { // Entry 442
    0x1.0cac908176778b5a0cbad21ee75ce765p-1,
    -0x1.04b3e8p0
  },
  { // Entry 443
    0x1.0cab727bc8619d628361876e1f30a633p-1,
    0x1.04b490p0
  },
  { // Entry 444
    0x1.0cab727bc8619d628361876e1f30a633p-1,
    -0x1.04b490p0
  },
  { // Entry 445
    0x1.0caa5b450a4324f204a556b072da124ap-1,
    0x1.04b534p0
  },
  { // Entry 446
    0x1.0caa5b450a4324f204a556b072da124ap-1,
    -0x1.04b534p0
  },
  { // Entry 447
    0x1.ffffffffffffffffffffffffffffffffp-1,
    -0x1.p-149
  },
  { // Entry 448
    0x1.ffffffffffffffffffffffffffffffffp-1,
    0x1.p-149
  },
  { // Entry 449
    0x1.p0,
    0.0
  },
  { // Entry 450
    0x1.ffffffffffffffffffffffffffffffffp-1,
    0x1.p-149
  },
  { // Entry 451
    0x1.ffffffffffffffffffffffffffffffffp-1,
    -0x1.p-149
  },
  { // Entry 452
    0x1.ad02c8b9cc93f448ef4eb068a88922a3p-1,
    0x1.279a72p-1
  },
  { // Entry 453
    0x1.ad02c8b9cc93f448ef4eb068a88922a3p-1,
    -0x1.279a72p-1
  },
  { // Entry 454
    0x1.ad02c7a258bfb362abbe86fb48f4e98bp-1,
    0x1.279a74p-1
  },
  { // Entry 455
    0x1.ad02c7a258bfb362abbe86fb48f4e98bp-1,
    -0x1.279a74p-1
  },
  { // Entry 456
    0x1.ad02c68ae4e9c579a08c04ce59be4002p-1,
    0x1.279a76p-1
  },
  { // Entry 457
    0x1.ad02c68ae4e9c579a08c04ce59be4002p-1,
    -0x1.279a76p-1
  },
  { // Entry 458
    -0x1.48d1c9e98b6c08784f10040f47a12191p-3,
    0x1.bb67acp0
  },
  { // Entry 459
    -0x1.48d1c9e98b6c08784f10040f47a12191p-3,
    -0x1.bb67acp0
  },
  { // Entry 460
    -0x1.48d1d9b467e37955337311decd09fc74p-3,
    0x1.bb67aep0
  },
  { // Entry 461
    -0x1.48d1d9b467e37955337311decd09fc74p-3,
    -0x1.bb67aep0
  },
  { // Entry 462
    -0x1.48d1e97f4455c6eab1048022238b2bd0p-3,
    0x1.bb67b0p0
  },
  { // Entry 463
    -0x1.48d1e97f4455c6eab1048022238b2bd0p-3,
    -0x1.bb67b0p0
  },
  { // Entry 464
    0x1.cfc6d011a0e5d0fcebb54b5fed672940p-1,
    0x1.bffffep-2
  },
  { // Entry 465
    0x1.cfc6d011a0e5d0fcebb54b5fed672940p-1,
    -0x1.bffffep-2
  },
  { // Entry 466
    0x1.cfc6cfa52ad9f62d6d5423ca8339a00ap-1,
    0x1.c0p-2
  },
  { // Entry 467
    0x1.cfc6cfa52ad9f62d6d5423ca8339a00ap-1,
    -0x1.c0p-2
  },
  { // Entry 468
    0x1.cfc6cf38b4cda76c3b09b17e9deb19eap-1,
    0x1.c00002p-2
  },
  { // Entry 469
    0x1.cfc6cf38b4cda76c3b09b17e9deb19eap-1,
    -0x1.c00002p-2
  },
  { // Entry 470
    0x1.8bb106eac7c75d33fbb19446313ecc2fp-1,
    0x1.5ffffep-1
  },
  { // Entry 471
    0x1.8bb106eac7c75d33fbb19446313ecc2fp-1,
    -0x1.5ffffep-1
  },
  { // Entry 472
    0x1.8bb105a5dc900618f80fa51d303c69p-1,
    0x1.60p-1
  },
  { // Entry 473
    0x1.8bb105a5dc900618f80fa51d303c69p-1,
    -0x1.60p-1
  },
  { // Entry 474
    0x1.8bb10460f157234ceec7d9644a1a78e5p-1,
    0x1.600002p-1
  },
  { // Entry 475
    0x1.8bb10460f157234ceec7d9644a1a78e5p-1,
    -0x1.600002p-1
  },
  { // Entry 476
    0x1.7ef48b9a6fd5c24f5ec39839e1729b78p-2,
    0x1.2ffffep0
  },
  { // Entry 477
    0x1.7ef48b9a6fd5c24f5ec39839e1729b78p-2,
    -0x1.2ffffep0
  },
  { // Entry 478
    0x1.7ef4842f0bccd60d4a501dc8bc4b57b3p-2,
    0x1.30p0
  },
  { // Entry 479
    0x1.7ef4842f0bccd60d4a501dc8bc4b57b3p-2,
    -0x1.30p0
  },
  { // Entry 480
    0x1.7ef47cc3a7bdedf9252074263d8a4596p-2,
    0x1.300002p0
  },
  { // Entry 481
    0x1.7ef47cc3a7bdedf9252074263d8a4596p-2,
    -0x1.300002p0
  },
  { // Entry 482
    -0x1.863ef5085bcc358d2ae8525bf39f0c40p-1,
    0x1.37fffep1
  },
  { // Entry 483
    -0x1.863ef5085bcc358d2ae8525bf39f0c40p-1,
    -0x1.37fffep1
  },
  { // Entry 484
    -0x1.863efa361dc252bca1eaeed39749bed7p-1,
    0x1.38p1
  },
  { // Entry 485
    -0x1.863efa361dc252bca1eaeed39749bed7p-1,
    -0x1.38p1
  },
  { // Entry 486
    -0x1.863eff63dfa00bfc758baf469469d741p-1,
    0x1.380002p1
  },
  { // Entry 487
    -0x1.863eff63dfa00bfc758baf469469d741p-1,
    -0x1.380002p1
  },
  { // Entry 488
    0x1.fef2b2d0a10e2739c566936480a1479bp-1,
    0x1.069c8cp-4
  },
  { // Entry 489
    0x1.fef2b2d0a10e2739c566936480a1479bp-1,
    -0x1.069c8cp-4
  },
  { // Entry 490
    0x1.fbcbe68dd10bad0a229ccbb580cc5436p-1,
    0x1.069c8cp-3
  },
  { // Entry 491
    0x1.fbcbe68dd10bad0a229ccbb580cc5436p-1,
    -0x1.069c8cp-3
  },
  { // Entry 492
    0x1.f68eebef72e7f6126b3f3dde646a755cp-1,
    0x1.89ead2p-3
  },
  { // Entry 493
    0x1.f68eebef72e7f6126b3f3dde646a755cp-1,
    -0x1.89ead2p-3
  },
  { // Entry 494
    0x1.ef41459d2e90ea1b7faad7fabd1fd444p-1,
    0x1.069c8cp-2
  },
  { // Entry 495
    0x1.ef41459d2e90ea1b7faad7fabd1fd444p-1,
    -0x1.069c8cp-2
  },
  { // Entry 496
    0x1.e5eaa23a27fe8d6890a3edace1c61998p-1,
    0x1.4843b0p-2
  },
  { // Entry 497
    0x1.e5eaa23a27fe8d6890a3edace1c61998p-1,
    -0x1.4843b0p-2
  },
  { // Entry 498
    0x1.da94d4b99c3a9a5e0d1fc86d53369a84p-1,
    0x1.89ead4p-2
  },
  { // Entry 499
    0x1.da94d4b99c3a9a5e0d1fc86d53369a84p-1,
    -0x1.89ead4p-2
  },
  { // Entry 500
    0x1.cd4bc9afc01230b2f982f6968dab7f05p-1,
    0x1.cb91f8p-2
  },
  { // Entry 501
    0x1.cd4bc9afc01230b2f982f6968dab7f05p-1,
    -0x1.cb91f8p-2
  },
  { // Entry 502
    0x1.be1d7adf077def2a360fec23dbbcef09p-1,
    0x1.069c8ep-1
  },
  { // Entry 503
    0x1.be1d7adf077def2a360fec23dbbcef09p-1,
    -0x1.069c8ep-1
  },
  { // Entry 504
    0x1.ad19e0847d25f3aa142289dab557bf96p-1,
    0x1.277020p-1
  },
  { // Entry 505
    0x1.ad19e0847d25f3aa142289dab557bf96p-1,
    -0x1.277020p-1
  },
  { // Entry 506
    0x1.9a52e08b191bd55512c8365074f1987fp-1,
    0x1.4843b2p-1
  },
  { // Entry 507
    0x1.9a52e08b191bd55512c8365074f1987fp-1,
    -0x1.4843b2p-1
  },
  { // Entry 508
    0x1.85dc3bb7c2e9abb5cccb6d96d12d39c4p-1,
    0x1.691744p-1
  },
  { // Entry 509
    0x1.85dc3bb7c2e9abb5cccb6d96d12d39c4p-1,
    -0x1.691744p-1
  },
  { // Entry 510
    0x1.6fcb78e1cd65d2e4fde7118caac79d6dp-1,
    0x1.89ead6p-1
  },
  { // Entry 511
    0x1.6fcb78e1cd65d2e4fde7118caac79d6dp-1,
    -0x1.89ead6p-1
  },
  { // Entry 512
    0x1.5837ce4dc835d4a5454ec0a1bb394081p-1,
    0x1.aabe68p-1
  },
  { // Entry 513
    0x1.5837ce4dc835d4a5454ec0a1bb394081p-1,
    -0x1.aabe68p-1
  },
  { // Entry 514
    0x1.3f3a09427966e9518802dee3bf443a95p-1,
    0x1.cb91fap-1
  },
  { // Entry 515
    0x1.3f3a09427966e9518802dee3bf443a95p-1,
    -0x1.cb91fap-1
  },
  { // Entry 516
    0x1.24ec73f1aeef4940bb8da19a82bbc49fp-1,
    0x1.ec658cp-1
  },
  { // Entry 517
    0x1.24ec73f1aeef4940bb8da19a82bbc49fp-1,
    -0x1.ec658cp-1
  },
  { // Entry 518
    0x1.096abb862f9bd5515982c2818c332ff9p-1,
    0x1.069c8ep0
  },
  { // Entry 519
    0x1.096abb862f9bd5515982c2818c332ff9p-1,
    -0x1.069c8ep0
  },
  { // Entry 520
    0x1.d9a39c0dddc654c717e3036da5dd685cp-2,
    0x1.170656p0
  },
  { // Entry 521
    0x1.d9a39c0dddc654c717e3036da5dd685cp-2,
    -0x1.170656p0
  },
  { // Entry 522
    0x1.9e7f81840c0bbd0f1b13733061062d34p-2,
    0x1.27701ep0
  },
  { // Entry 523
    0x1.9e7f81840c0bbd0f1b13733061062d34p-2,
    -0x1.27701ep0
  },
  { // Entry 524
    0x1.61a75e2deb596731c8cd45e3d9794526p-2,
    0x1.37d9e6p0
  },
  { // Entry 525
    0x1.61a75e2deb596731c8cd45e3d9794526p-2,
    -0x1.37d9e6p0
  },
  { // Entry 526
    0x1.235b337b091cdd8ac06390abc6816b82p-2,
    0x1.4843aep0
  },
  { // Entry 527
    0x1.235b337b091cdd8ac06390abc6816b82p-2,
    -0x1.4843aep0
  },
  { // Entry 528
    0x1.c7b9146d6d10824ff652dc390ba2d7f9p-3,
    0x1.58ad76p0
  },
  { // Entry 529
    0x1.c7b9146d6d10824ff652dc390ba2d7f9p-3,
    -0x1.58ad76p0
  },
  { // Entry 530
    0x1.46dc5b2f1de977efff7c278b5adb2a75p-3,
    0x1.69173ep0
  },
  { // Entry 531
    0x1.46dc5b2f1de977efff7c278b5adb2a75p-3,
    -0x1.69173ep0
  },
  { // Entry 532
    0x1.894f93ef49c4575800bbd646a3a31d2ap-4,
    0x1.798106p0
  },
  { // Entry 533
    0x1.894f93ef49c4575800bbd646a3a31d2ap-4,
    -0x1.798106p0
  },
  { // Entry 534
    0x1.069164e3f5cee94d865fb52e316dff6bp-5,
    0x1.89eacep0
  },
  { // Entry 535
    0x1.069164e3f5cee94d865fb52e316dff6bp-5,
    -0x1.89eacep0
  },
  { // Entry 536
    -0x1.069093eec0ed066ec83dd034498ef8bfp-5,
    0x1.9a5496p0
  },
  { // Entry 537
    -0x1.069093eec0ed066ec83dd034498ef8bfp-5,
    -0x1.9a5496p0
  },
  { // Entry 538
    -0x1.894f2be2979dd9ced83ccc60cf49cd44p-4,
    0x1.aabe5ep0
  },
  { // Entry 539
    -0x1.894f2be2979dd9ced83ccc60cf49cd44p-4,
    -0x1.aabe5ep0
  },
  { // Entry 540
    -0x1.46dc2796735195a15c80e5b719e2fc42p-3,
    0x1.bb2826p0
  },
  { // Entry 541
    -0x1.46dc2796735195a15c80e5b719e2fc42p-3,
    -0x1.bb2826p0
  },
  { // Entry 542
    -0x1.c7b8e178b7e8c01d9f320466cc7a68d4p-3,
    0x1.cb91eep0
  },
  { // Entry 543
    -0x1.c7b8e178b7e8c01d9f320466cc7a68d4p-3,
    -0x1.cb91eep0
  },
  { // Entry 544
    -0x1.235b1a6d767e4b362c64571ac97b4a1cp-2,
    0x1.dbfbb6p0
  },
  { // Entry 545
    -0x1.235b1a6d767e4b362c64571ac97b4a1cp-2,
    -0x1.dbfbb6p0
  },
  { // Entry 546
    -0x1.61a745a77b7e83c2f8a2f9b091e89aaap-2,
    0x1.ec657ep0
  },
  { // Entry 547
    -0x1.61a745a77b7e83c2f8a2f9b091e89aaap-2,
    -0x1.ec657ep0
  },
  { // Entry 548
    -0x1.9e7f699e8b9aaf8ed51c71c8f73b0b74p-2,
    0x1.fccf46p0
  },
  { // Entry 549
    -0x1.9e7f699e8b9aaf8ed51c71c8f73b0b74p-2,
    -0x1.fccf46p0
  },
  { // Entry 550
    -0x1.d9a38bfa3195ba1caa7fb69bc1d04e42p-2,
    0x1.069c88p1
  },
  { // Entry 551
    -0x1.d9a38bfa3195ba1caa7fb69bc1d04e42p-2,
    -0x1.069c88p1
  },
  { // Entry 552
    -0x1.096ab3c55c91f36e2359ed1c5a8342dfp-1,
    0x1.0ed16cp1
  },
  { // Entry 553
    -0x1.096ab3c55c91f36e2359ed1c5a8342dfp-1,
    -0x1.0ed16cp1
  },
  { // Entry 554
    -0x1.24ec6c8206e744322d99f47e9e41becep-1,
    0x1.170650p1
  },
  { // Entry 555
    -0x1.24ec6c8206e744322d99f47e9e41becep-1,
    -0x1.170650p1
  },
  { // Entry 556
    -0x1.3f3a009b82b5b8234e1296dd73cff49dp-1,
    0x1.1f3b34p1
  },
  { // Entry 557
    -0x1.3f3a009b82b5b8234e1296dd73cff49dp-1,
    -0x1.1f3b34p1
  },
  { // Entry 558
    -0x1.5837c4a184ccf7ed57c189f2addf32c5p-1,
    0x1.277018p1
  },
  { // Entry 559
    -0x1.5837c4a184ccf7ed57c189f2addf32c5p-1,
    -0x1.277018p1
  },
  { // Entry 560
    -0x1.6fcb6e6685e72fb4074e70cd3162d3bap-1,
    0x1.2fa4fcp1
  },
  { // Entry 561
    -0x1.6fcb6e6685e72fb4074e70cd3162d3bap-1,
    -0x1.2fa4fcp1
  },
  { // Entry 562
    -0x1.85dc30a79f26754ab1370338ee7bfd11p-1,
    0x1.37d9e0p1
  },
  { // Entry 563
    -0x1.85dc30a79f26754ab1370338ee7bfd11p-1,
    -0x1.37d9e0p1
  },
  { // Entry 564
    -0x1.9a52d523b1532e4ed477e27dc6051c12p-1,
    0x1.400ec4p1
  },
  { // Entry 565
    -0x1.9a52d523b1532e4ed477e27dc6051c12p-1,
    -0x1.400ec4p1
  },
  { // Entry 566
    -0x1.ad19d50664abf0c0141137d2ca509f21p-1,
    0x1.4843a8p1
  },
  { // Entry 567
    -0x1.ad19d50664abf0c0141137d2ca509f21p-1,
    -0x1.4843a8p1
  },
  { // Entry 568
    -0x1.be1d6f8d517db5c2cf7de0faf0808d30p-1,
    0x1.50788cp1
  },
  { // Entry 569
    -0x1.be1d6f8d517db5c2cf7de0faf0808d30p-1,
    -0x1.50788cp1
  },
  { // Entry 570
    -0x1.cd4bbecf7f2705d4fd00dd463780f45ep-1,
    0x1.58ad70p1
  },
  { // Entry 571
    -0x1.cd4bbecf7f2705d4fd00dd463780f45ep-1,
    -0x1.58ad70p1
  },
  { // Entry 572
    -0x1.da94ca915da3cdd1fff839d85eec39e2p-1,
    0x1.60e254p1
  },
  { // Entry 573
    -0x1.da94ca915da3cdd1fff839d85eec39e2p-1,
    -0x1.60e254p1
  },
  { // Entry 574
    -0x1.e5ea99116b39361ac926dd9fdc2089d1p-1,
    0x1.691738p1
  },
  { // Entry 575
    -0x1.e5ea99116b39361ac926dd9fdc2089d1p-1,
    -0x1.691738p1
  },
  { // Entry 576
    -0x1.ef413dbbda2859ffb0d1ab84342fd235p-1,
    0x1.714c1cp1
  },
  { // Entry 577
    -0x1.ef413dbbda2859ffb0d1ab84342fd235p-1,
    -0x1.714c1cp1
  },
  { // Entry 578
    -0x1.f68ee5b5bf356b10230944a18e70925cp-1,
    0x1.7981p1
  },
  { // Entry 579
    -0x1.f68ee5b5bf356b10230944a18e70925cp-1,
    -0x1.7981p1
  },
  { // Entry 580
    -0x1.fbcbe23296fc61b96f382f35ea15c768p-1,
    0x1.81b5e4p1
  },
  { // Entry 581
    -0x1.fbcbe23296fc61b96f382f35ea15c768p-1,
    -0x1.81b5e4p1
  },
  { // Entry 582
    -0x1.fef2b08943197cd3a8ba861095227c48p-1,
    0x1.89eac8p1
  },
  { // Entry 583
    -0x1.fef2b08943197cd3a8ba861095227c48p-1,
    -0x1.89eac8p1
  },
  { // Entry 584
    0x1.ef41489fc2fe801a6fc8ae791438eb78p-1,
    -0x1.81b5eep2
  },
  { // Entry 585
    0x1.ef41489fc2fe801a6fc8ae791438eb78p-1,
    0x1.81b5eep2
  },
  { // Entry 586
    0x1.be1d849ec649b797320e985d0b82ae85p-1,
    -0x1.714c26p2
  },
  { // Entry 587
    0x1.be1d849ec649b797320e985d0b82ae85p-1,
    0x1.714c26p2
  },
  { // Entry 588
    0x1.6fcb8c44bd30dd668148605969b1c161p-1,
    -0x1.60e25ep2
  },
  { // Entry 589
    0x1.6fcb8c44bd30dd668148605969b1c161p-1,
    0x1.60e25ep2
  },
  { // Entry 590
    0x1.096ad87c326622c42de34f92814cfa84p-1,
    -0x1.507896p2
  },
  { // Entry 591
    0x1.096ad87c326622c42de34f92814cfa84p-1,
    0x1.507896p2
  },
  { // Entry 592
    0x1.235b746a2a2eff2bf640dd8c04d35a5bp-2,
    -0x1.400ecep2
  },
  { // Entry 593
    0x1.235b746a2a2eff2bf640dd8c04d35a5bp-2,
    0x1.400ecep2
  },
  { // Entry 594
    0x1.0693827b46cee3b661ac17114b5fe0fbp-5,
    -0x1.2fa506p2
  },
  { // Entry 595
    0x1.0693827b46cee3b661ac17114b5fe0fbp-5,
    0x1.2fa506p2
  },
  { // Entry 596
    -0x1.c7b85d668e2abcc46542ca8527f0b801p-3,
    -0x1.1f3b3ep2
  },
  { // Entry 597
    -0x1.c7b85d668e2abcc46542ca8527f0b801p-3,
    0x1.1f3b3ep2
  },
  { // Entry 598
    -0x1.d9a348d4f4363ba4562110db01ee84e8p-2,
    -0x1.0ed176p2
  },
  { // Entry 599
    -0x1.d9a348d4f4363ba4562110db01ee84e8p-2,
    0x1.0ed176p2
  },
  { // Entry 600
    -0x1.5837ae8569c95846e6164d9636546120p-1,
    -0x1.fccf5ap1
  },
  { // Entry 601
    -0x1.5837ae8569c95846e6164d9636546120p-1,
    0x1.fccf5ap1
  },
  { // Entry 602
    -0x1.ad19c918883000b0b702ec080cf0122ep-1,
    -0x1.dbfbc8p1
  },
  { // Entry 603
    -0x1.ad19c918883000b0b702ec080cf0122ep-1,
    0x1.dbfbc8p1
  },
  { // Entry 604
    -0x1.e5ea94b2cf07add3d0d95ab3a30ad4abp-1,
    -0x1.bb2836p1
  },
  { // Entry 605
    -0x1.e5ea94b2cf07add3d0d95ab3a30ad4abp-1,
    0x1.bb2836p1
  },
  { // Entry 606
    -0x1.fef2b02908559f92de892d240a2b0b49p-1,
    -0x1.9a54a4p1
  },
  { // Entry 607
    -0x1.fef2b02908559f92de892d240a2b0b49p-1,
    0x1.9a54a4p1
  },
  { // Entry 608
    -0x1.f68ef3792e592c3cefbce1d5ded64a92p-1,
    -0x1.798112p1
  },
  { // Entry 609
    -0x1.f68ef3792e592c3cefbce1d5ded64a92p-1,
    0x1.798112p1
  },
  { // Entry 610
    -0x1.cd4bda943eea13630f8e508f8744f2f2p-1,
    -0x1.58ad80p1
  },
  { // Entry 611
    -0x1.cd4bda943eea13630f8e508f8744f2f2p-1,
    0x1.58ad80p1
  },
  { // Entry 612
    -0x1.85dc54f49f324bdfc71d5749483b3318p-1,
    -0x1.37d9eep1
  },
  { // Entry 613
    -0x1.85dc54f49f324bdfc71d5749483b3318p-1,
    0x1.37d9eep1
  },
  { // Entry 614
    -0x1.24ec93e04d4bdb54e20beaf383519af8p-1,
    -0x1.17065cp1
  },
  { // Entry 615
    -0x1.24ec93e04d4bdb54e20beaf383519af8p-1,
    0x1.17065cp1
  },
  { // Entry 616
    -0x1.61a7983d4c16c451b68bf2f5b70f3b6ap-2,
    -0x1.ec6594p0
  },
  { // Entry 617
    -0x1.61a7983d4c16c451b68bf2f5b70f3b6ap-2,
    0x1.ec6594p0
  },
  { // Entry 618
    -0x1.89504a8de6c9ecac663e67583cab47e8p-4,
    -0x1.aabe70p0
  },
  { // Entry 619
    -0x1.89504a8de6c9ecac663e67583cab47e8p-4,
    0x1.aabe70p0
  },
  { // Entry 620
    0x1.46dbec9ea3a5f08ba73aa69e7e22de1cp-3,
    -0x1.69174cp0
  },
  { // Entry 621
    0x1.46dbec9ea3a5f08ba73aa69e7e22de1cp-3,
    0x1.69174cp0
  },
  { // Entry 622
    0x1.9e7f5cf075d1ec4ef69c9c67b62c27cbp-2,
    -0x1.277028p0
  },
  { // Entry 623
    0x1.9e7f5cf075d1ec4ef69c9c67b62c27cbp-2,
    0x1.277028p0
  },
  { // Entry 624
    0x1.3f39fcc017653d2636837a55fdf6d2d4p-1,
    -0x1.cb920ap-1
  },
  { // Entry 625
    0x1.3f39fcc017653d2636837a55fdf6d2d4p-1,
    0x1.cb920ap-1
  },
  { // Entry 626
    0x1.9a52d5c700daa3dc8cf8f5a71f2df289p-1,
    -0x1.4843c4p-1
  },
  { // Entry 627
    0x1.9a52d5c700daa3dc8cf8f5a71f2df289p-1,
    0x1.4843c4p-1
  },
  { // Entry 628
    0x1.da94cd383dd7a3b91a2fc88ff905a6a0p-1,
    -0x1.89eafcp-2
  },
  { // Entry 629
    0x1.da94cd383dd7a3b91a2fc88ff905a6a0p-1,
    0x1.89eafcp-2
  },
  { // Entry 630
    0x1.fbcbe3de58e66c3283bc810d16c45833p-1,
    -0x1.069ce0p-3
  },
  { // Entry 631
    0x1.fbcbe3de58e66c3283bc810d16c45833p-1,
    0x1.069ce0p-3
  },
  { // Entry 632
    0x1.fbcbe93d48563d51b6e9d6efdb62495cp-1,
    0x1.069c38p-3
  },
  { // Entry 633
    0x1.fbcbe93d48563d51b6e9d6efdb62495cp-1,
    -0x1.069c38p-3
  },
  { // Entry 634
    0x1.da94dcfb1cd15853ce848ffb0264ad08p-1,
    0x1.89eaa8p-2
  },
  { // Entry 635
    0x1.da94dcfb1cd15853ce848ffb0264ad08p-1,
    -0x1.89eaa8p-2
  },
  { // Entry 636
    0x1.9a52eee5e35377d554ace881bdc4725bp-1,
    0x1.48439ap-1
  },
  { // Entry 637
    0x1.9a52eee5e35377d554ace881bdc4725bp-1,
    -0x1.48439ap-1
  },
  { // Entry 638
    0x1.3f3a1d9657ff6aa498c46f6faaf03b90p-1,
    0x1.cb91e0p-1
  },
  { // Entry 639
    0x1.3f3a1d9657ff6aa498c46f6faaf03b90p-1,
    -0x1.cb91e0p-1
  },
  { // Entry 640
    0x1.9e7fa617a1a3a400a7f59aa879088e31p-2,
    0x1.277014p0
  },
  { // Entry 641
    0x1.9e7fa617a1a3a400a7f59aa879088e31p-2,
    -0x1.277014p0
  },
  { // Entry 642
    0x1.46dc8a919b27840cda6e18a079da459cp-3,
    0x1.691738p0
  },
  { // Entry 643
    0x1.46dc8a919b27840cda6e18a079da459cp-3,
    -0x1.691738p0
  },
  { // Entry 644
    -0x1.894f0c0872415663b7f9e4e4801deaf0p-4,
    0x1.aabe5cp0
  },
  { // Entry 645
    -0x1.894f0c0872415663b7f9e4e4801deaf0p-4,
    -0x1.aabe5cp0
  },
  { // Entry 646
    -0x1.61a74d29774ae4e3bc5533a2ea08a14ap-2,
    0x1.ec6580p0
  },
  { // Entry 647
    -0x1.61a74d29774ae4e3bc5533a2ea08a14ap-2,
    -0x1.ec6580p0
  },
  { // Entry 648
    -0x1.24ec7311bd7b2255f9b890b3ff5899f4p-1,
    0x1.170652p1
  },
  { // Entry 649
    -0x1.24ec7311bd7b2255f9b890b3ff5899f4p-1,
    -0x1.170652p1
  },
  { // Entry 650
    -0x1.85dc3b06c435f524c873d9b5eba3def8p-1,
    0x1.37d9e4p1
  },
  { // Entry 651
    -0x1.85dc3b06c435f524c873d9b5eba3def8p-1,
    -0x1.37d9e4p1
  },
  { // Entry 652
    -0x1.cd4bc93947e86671ac7f0eacd9521377p-1,
    0x1.58ad76p1
  },
  { // Entry 653
    -0x1.cd4bc93947e86671ac7f0eacd9521377p-1,
    -0x1.58ad76p1
  },
  { // Entry 654
    -0x1.f68eebd3b8f12f9433e6d7224989c10ep-1,
    0x1.798108p1
  },
  { // Entry 655
    -0x1.f68eebd3b8f12f9433e6d7224989c10ep-1,
    -0x1.798108p1
  },
  { // Entry 656
    -0x1.fef2b2b91e40021a2fee74fc61812157p-1,
    0x1.9a549ap1
  },
  { // Entry 657
    -0x1.fef2b2b91e40021a2fee74fc61812157p-1,
    -0x1.9a549ap1
  },
  { // Entry 658
    -0x1.e5eaa14d86168b69918c22f3716a67eap-1,
    0x1.bb282cp1
  },
  { // Entry 659
    -0x1.e5eaa14d86168b69918c22f3716a67eap-1,
    -0x1.bb282cp1
  },
  { // Entry 660
    -0x1.ad19deead0eae2f72d04165e09e4a43dp-1,
    0x1.dbfbbep1
  },
  { // Entry 661
    -0x1.ad19deead0eae2f72d04165e09e4a43dp-1,
    -0x1.dbfbbep1
  },
  { // Entry 662
    -0x1.5837cc21dda44f3ab7fd96f57c014e19p-1,
    0x1.fccf50p1
  },
  { // Entry 663
    -0x1.5837cc21dda44f3ab7fd96f57c014e19p-1,
    -0x1.fccf50p1
  },
  { // Entry 664
    -0x1.d9a39df207139f99ebe9b56dafb234b7p-2,
    0x1.0ed170p2
  },
  { // Entry 665
    -0x1.d9a39df207139f99ebe9b56dafb234b7p-2,
    -0x1.0ed170p2
  },
  { // Entry 666
    -0x1.c7b9189638128bc0ae33fdf2729cc987p-3,
    0x1.1f3b38p2
  },
  { // Entry 667
    -0x1.c7b9189638128bc0ae33fdf2729cc987p-3,
    -0x1.1f3b38p2
  },
  { // Entry 668
    0x1.069082e04b25e9d2ea9e263b50d08b34p-5,
    0x1.2fa5p2
  },
  { // Entry 669
    0x1.069082e04b25e9d2ea9e263b50d08b34p-5,
    -0x1.2fa5p2
  },
  { // Entry 670
    0x1.235b1861f21aa86dce259e4e5b4ef395p-2,
    0x1.400ec8p2
  },
  { // Entry 671
    0x1.235b1861f21aa86dce259e4e5b4ef395p-2,
    -0x1.400ec8p2
  },
  { // Entry 672
    0x1.096aaf70341485062f443c80a90a3be3p-1,
    0x1.507890p2
  },
  { // Entry 673
    0x1.096aaf70341485062f443c80a90a3be3p-1,
    -0x1.507890p2
  },
  { // Entry 674
    0x1.6fcb6ae03107be458d07361371efabb4p-1,
    0x1.60e258p2
  },
  { // Entry 675
    0x1.6fcb6ae03107be458d07361371efabb4p-1,
    -0x1.60e258p2
  },
  { // Entry 676
    0x1.be1d6d10d5c8ceeb8bf9aeb7a9f690b9p-1,
    0x1.714c20p2
  },
  { // Entry 677
    0x1.be1d6d10d5c8ceeb8bf9aeb7a9f690b9p-1,
    -0x1.714c20p2
  },
  { // Entry 678
    0x1.ef413c72d988bb53937975e4fd4fcc7ap-1,
    0x1.81b5e8p2
  },
  { // Entry 679
    0x1.ef413c72d988bb53937975e4fd4fcc7ap-1,
    -0x1.81b5e8p2
  },
  { // Entry 680
    0x1.ff0fd2cb5a9228cfa1e01605d0626c84p-1,
    0x1.effffep-5
  },
  { // Entry 681
    0x1.ff0fd2cb5a9228cfa1e01605d0626c84p-1,
    -0x1.effffep-5
  },
  { // Entry 682
    0x1.ff0fd2c96adfbad5f904a71b2d210a2ap-1,
    0x1.f0p-5
  },
  { // Entry 683
    0x1.ff0fd2c96adfbad5f904a71b2d210a2ap-1,
    -0x1.f0p-5
  },
  { // Entry 684
    0x1.ff0fd2c77b2d4add40566ec5aa24fc6ep-1,
    0x1.f00002p-5
  },
  { // Entry 685
    0x1.ff0fd2c77b2d4add40566ec5aa24fc6ep-1,
    -0x1.f00002p-5
  },
  { // Entry 686
    0x1.fc21005d216a89de55b192096fc6b7bap-1,
    0x1.f7fffep-4
  },
  { // Entry 687
    0x1.fc21005d216a89de55b192096fc6b7bap-1,
    -0x1.f7fffep-4
  },
  { // Entry 688
    0x1.fc210055467fe58a20193399b3bc0dd2p-1,
    0x1.f8p-4
  },
  { // Entry 689
    0x1.fc210055467fe58a20193399b3bc0dd2p-1,
    -0x1.f8p-4
  },
  { // Entry 690
    0x1.fc21004d6b953945667f800ff81de0ebp-1,
    0x1.f80002p-4
  },
  { // Entry 691
    0x1.fc21004d6b953945667f800ff81de0ebp-1,
    -0x1.f80002p-4
  },
  { // Entry 692
    0x1.f94984c6fdf1be6168509ff1e35f62dep-1,
    0x1.4bfffep-3
  },
  { // Entry 693
    0x1.f94984c6fdf1be6168509ff1e35f62dep-1,
    -0x1.4bfffep-3
  },
  { // Entry 694
    0x1.f94984b2552e1941ec766c6a82ece4a3p-1,
    0x1.4cp-3
  },
  { // Entry 695
    0x1.f94984b2552e1941ec766c6a82ece4a3p-1,
    -0x1.4cp-3
  },
  { // Entry 696
    0x1.f949849dac6a548dd851139041106316p-1,
    0x1.4c0002p-3
  },
  { // Entry 697
    0x1.f949849dac6a548dd851139041106316p-1,
    -0x1.4c0002p-3
  },
  { // Entry 698
    0x1.e921dd7054ef5d4f727d938ce10a053cp-1,
    0x1.333332p-2
  },
  { // Entry 699
    0x1.e921dd7054ef5d4f727d938ce10a053cp-1,
    -0x1.333332p-2
  },
  { // Entry 700
    0x1.e921dd24adb9129efc053f9acd4d2444p-1,
    0x1.333334p-2
  },
  { // Entry 701
    0x1.e921dd24adb9129efc053f9acd4d2444p-1,
    -0x1.333334p-2
  },
  { // Entry 702
    0x1.e921dcd906824da60e43c03a7774b171p-1,
    0x1.333336p-2
  },
  { // Entry 703
    0x1.e921dcd906824da60e43c03a7774b171p-1,
    -0x1.333336p-2
  },
  { // Entry 704
    0x1.8feedc92764bfbdcb41389e82063ed6ep-1,
    0x1.594316p-1
  },
  { // Entry 705
    0x1.8feedc92764bfbdcb41389e82063ed6ep-1,
    -0x1.594316p-1
  },
  { // Entry 706
    0x1.8feedb52c750087c5f8727e0279e5f66p-1,
    0x1.594318p-1
  },
  { // Entry 707
    0x1.8feedb52c750087c5f8727e0279e5f66p-1,
    -0x1.594318p-1
  },
  { // Entry 708
    0x1.8feeda131852852d2fa7fe8847b05973p-1,
    0x1.59431ap-1
  },
  { // Entry 709
    0x1.8feeda131852852d2fa7fe8847b05973p-1,
    -0x1.59431ap-1
  },
  { // Entry 710
    0x1.6b8991127859fd9b43ca1d08b92aa401p-1,
    0x1.8ffffep-1
  },
  { // Entry 711
    0x1.6b8991127859fd9b43ca1d08b92aa401p-1,
    -0x1.8ffffep-1
  },
  { // Entry 712
    0x1.6b898fa9efb5d22b58f0d99e9634931ap-1,
    0x1.90p-1
  },
  { // Entry 713
    0x1.6b898fa9efb5d22b58f0d99e9634931ap-1,
    -0x1.90p-1
  },
  { // Entry 714
    0x1.6b898e4167103b31de6da67ebf5e9fe6p-1,
    0x1.900002p-1
  },
  { // Entry 715
    0x1.6b898e4167103b31de6da67ebf5e9fe6p-1,
    -0x1.900002p-1
  },
  { // Entry 716
    0x1.ffffffffffffffffffffffffffffffffp-1,
    -0x1.p-149
  },
  { // Entry 717
    0x1.ffffffffffffffffffffffffffffffffp-1,
    0x1.p-149
  },
  { // Entry 718
    0x1.p0,
    0.0
  },
  { // Entry 719
    0x1.ffffffffffffffffffffffffffffffffp-1,
    0x1.p-149
  },
  { // Entry 720
    0x1.ffffffffffffffffffffffffffffffffp-1,
    -0x1.p-149
  },
  { // Entry 721
    0x1.ff621e38956a3b3be920256ddb6034cdp-1,
    0x1.921fb4p-5
  },
  { // Entry 722
    0x1.ff621e38956a3b3be920256ddb6034cdp-1,
    -0x1.921fb4p-5
  },
  { // Entry 723
    0x1.ff621e370373dc6f3963d42896ede078p-1,
    0x1.921fb6p-5
  },
  { // Entry 724
    0x1.ff621e370373dc6f3963d42896ede078p-1,
    -0x1.921fb6p-5
  },
  { // Entry 725
    0x1.ff621e35717d7ba327894bdfde9f4787p-1,
    0x1.921fb8p-5
  },
  { // Entry 726
    0x1.ff621e35717d7ba327894bdfde9f4787p-1,
    -0x1.921fb8p-5
  },
  { // Entry 727
    0x1.fd88da410b61cd55221d9beb996d4d99p-1,
    0x1.921fb4p-4
  },
  { // Entry 728
    0x1.fd88da410b61cd55221d9beb996d4d99p-1,
    -0x1.921fb4p-4
  },
  { // Entry 729
    0x1.fd88da3ac5781f5a6fc32e40ed5122b0p-1,
    0x1.921fb6p-4
  },
  { // Entry 730
    0x1.fd88da3ac5781f5a6fc32e40ed5122b0p-1,
    -0x1.921fb6p-4
  },
  { // Entry 731
    0x1.fd88da347f8e696999ffd58060ba3569p-1,
    0x1.921fb8p-4
  },
  { // Entry 732
    0x1.fd88da347f8e696999ffd58060ba3569p-1,
    -0x1.921fb8p-4
  },
  { // Entry 733
    0x1.f6297d0f4671da580dfecdd4db29f473p-1,
    0x1.921fb4p-3
  },
  { // Entry 734
    0x1.f6297d0f4671da580dfecdd4db29f473p-1,
    -0x1.921fb4p-3
  },
  { // Entry 735
    0x1.f6297cf64db9a21d98ab3940fc8a86f0p-1,
    0x1.921fb6p-3
  },
  { // Entry 736
    0x1.f6297cf64db9a21d98ab3940fc8a86f0p-1,
    -0x1.921fb6p-3
  },
  { // Entry 737
    0x1.f6297cdd55014a808b883fd183f318acp-1,
    0x1.921fb8p-3
  },
  { // Entry 738
    0x1.f6297cdd55014a808b883fd183f318acp-1,
    -0x1.921fb8p-3
  },
  { // Entry 739
    0x1.d906bd313443007dcb0bd4e3d63284c0p-1,
    0x1.921fb4p-2
  },
  { // Entry 740
    0x1.d906bd313443007dcb0bd4e3d63284c0p-1,
    -0x1.921fb4p-2
  },
  { // Entry 741
    0x1.d906bccf3cb875874da3da4c01104bafp-1,
    0x1.921fb6p-2
  },
  { // Entry 742
    0x1.d906bccf3cb875874da3da4c01104bafp-1,
    -0x1.921fb6p-2
  },
  { // Entry 743
    0x1.d906bc6d452d744f210810861102f2dap-1,
    0x1.921fb8p-2
  },
  { // Entry 744
    0x1.d906bc6d452d744f210810861102f2dap-1,
    -0x1.921fb8p-2
  },
  { // Entry 745
    0x1.6a09e74d3d3fbb94d94274f37769f6eap-1,
    0x1.921fb4p-1
  },
  { // Entry 746
    0x1.6a09e74d3d3fbb94d94274f37769f6eap-1,
    -0x1.921fb4p-1
  },
  { // Entry 747
    0x1.6a09e5e3335983e5ac92e733e3f24b42p-1,
    0x1.921fb6p-1
  },
  { // Entry 748
    0x1.6a09e5e3335983e5ac92e733e3f24b42p-1,
    -0x1.921fb6p-1
  },
  { // Entry 749
    0x1.6a09e4792971e22c9a00261aeac070dap-1,
    0x1.921fb8p-1
  },
  { // Entry 750
    0x1.6a09e4792971e22c9a00261aeac070dap-1,
    -0x1.921fb8p-1
  },
  { // Entry 751
    0x1.4442d18469893610281a0f9b0e8d0eefp-24,
    0x1.921fb4p0
  },
  { // Entry 752
    0x1.4442d18469893610281a0f9b0e8d0eefp-24,
    -0x1.921fb4p0
  },
  { // Entry 753
    -0x1.777a5cf72cecc4cde3a31e7d5a026142p-25,
    0x1.921fb6p0
  },
  { // Entry 754
    -0x1.777a5cf72cecc4cde3a31e7d5a026142p-25,
    -0x1.921fb6p0
  },
  { // Entry 755
    -0x1.5dde973dcb3985f4a8e76a1feca29e1dp-23,
    0x1.921fb8p0
  },
  { // Entry 756
    -0x1.5dde973dcb3985f4a8e76a1feca29e1dp-23,
    -0x1.921fb8p0
  },
  { // Entry 757
    -0x1.fffffffffff9951b30e084732e60bb85p-1,
    0x1.921fb4p1
  },
  { // Entry 758
    -0x1.fffffffffff9951b30e084732e60bb85p-1,
    -0x1.921fb4p1
  },
  { // Entry 759
    -0x1.fffffffffffdd94849271d08eecf54a1p-1,
    0x1.921fb6p1
  },
  { // Entry 760
    -0x1.fffffffffffdd94849271d08eecf54a1p-1,
    -0x1.921fb6p1
  },
  { // Entry 761
    -0x1.ffffffffffe21d75616db5ebc56405f5p-1,
    0x1.921fb8p1
  },
  { // Entry 762
    -0x1.ffffffffffe21d75616db5ebc56405f5p-1,
    -0x1.921fb8p1
  },
  { // Entry 763
    0x1.ffffffffffe6546cc38211f5e8deeb97p-1,
    0x1.921fb4p2
  },
  { // Entry 764
    0x1.ffffffffffe6546cc38211f5e8deeb97p-1,
    -0x1.921fb4p2
  },
  { // Entry 765
    0x1.fffffffffff76521249c74285bf73c07p-1,
    0x1.921fb6p2
  },
  { // Entry 766
    0x1.fffffffffff76521249c74285bf73c07p-1,
    -0x1.921fb6p2
  },
  { // Entry 767
    0x1.ffffffffff8875d585b6db2c31711004p-1,
    0x1.921fb8p2
  },
  { // Entry 768
    0x1.ffffffffff8875d585b6db2c31711004p-1,
    -0x1.921fb8p2
  },
  { // Entry 769
    0x1.ffffffffff9951b30e084a6a993b8675p-1,
    0x1.921fb4p3
  },
  { // Entry 770
    0x1.ffffffffff9951b30e084a6a993b8675p-1,
    -0x1.921fb4p3
  },
  { // Entry 771
    0x1.ffffffffffdd94849271d0eb7b7b884bp-1,
    0x1.921fb6p3
  },
  { // Entry 772
    0x1.ffffffffffdd94849271d0eb7b7b884bp-1,
    -0x1.921fb6p3
  },
  { // Entry 773
    0x1.fffffffffe21d75616dba48283d3c2f7p-1,
    0x1.921fb8p3
  },
  { // Entry 774
    0x1.fffffffffe21d75616dba48283d3c2f7p-1,
    -0x1.921fb8p3
  },
  { // Entry 775
    0x1.fffffffffe6546cc382152d9c0eb9b47p-1,
    0x1.921fb4p4
  },
  { // Entry 776
    0x1.fffffffffe6546cc382152d9c0eb9b47p-1,
    -0x1.921fb4p4
  },
  { // Entry 777
    0x1.ffffffffff76521249c7484ea7d7a409p-1,
    0x1.921fb6p4
  },
  { // Entry 778
    0x1.ffffffffff76521249c7484ea7d7a409p-1,
    -0x1.921fb6p4
  },
  { // Entry 779
    0x1.fffffffff8875d585b720f25f0473943p-1,
    0x1.921fb8p4
  },
  { // Entry 780
    0x1.fffffffff8875d585b720f25f0473943p-1,
    -0x1.921fb8p4
  },
  { // Entry 781
    0x1.fffffffff9951b30e087de5cc38683b8p-1,
    0x1.921fb4p5
  },
  { // Entry 782
    0x1.fffffffff9951b30e087de5cc38683b8p-1,
    -0x1.921fb4p5
  },
  { // Entry 783
    0x1.fffffffffdd94849271d6b463df6bddfp-1,
    0x1.921fb6p5
  },
  { // Entry 784
    0x1.fffffffffdd94849271d6b463df6bddfp-1,
    -0x1.921fb6p5
  },
  { // Entry 785
    0x1.ffffffffe21d75616e000e55d09f8757p-1,
    0x1.921fb8p5
  },
  { // Entry 786
    0x1.ffffffffe21d75616e000e55d09f8757p-1,
    -0x1.921fb8p5
  },
  { // Entry 787
    0x1.ffffffffe6546cc38248a8cf0b9b5795p-1,
    0x1.921fb4p6
  },
  { // Entry 788
    0x1.ffffffffe6546cc38248a8cf0b9b5795p-1,
    -0x1.921fb4p6
  },
  { // Entry 789
    0x1.fffffffff76521249c7a4dd2e15dd1c4p-1,
    0x1.921fb6p6
  },
  { // Entry 790
    0x1.fffffffff76521249c7a4dd2e15dd1c4p-1,
    -0x1.921fb6p6
  },
  { // Entry 791
    0x1.ffffffff8875d585bb7d55383a9b39a4p-1,
    0x1.921fb8p6
  },
  { // Entry 792
    0x1.ffffffff8875d585bb7d55383a9b39a4p-1,
    -0x1.921fb8p6
  },
  { // Entry 793
    0x1.ffffffff9951b30e0bb598fc0679a6f7p-1,
    0x1.921fb4p7
  },
  { // Entry 794
    0x1.ffffffff9951b30e0bb598fc0679a6f7p-1,
    -0x1.921fb4p7
  },
  { // Entry 795
    0x1.ffffffffdd948492723342ea1da49bacp-1,
    0x1.921fb6p7
  },
  { // Entry 796
    0x1.ffffffffdd948492723342ea1da49bacp-1,
    -0x1.921fb6p7
  },
  { // Entry 797
    0x1.fffffffe21d7561725c712f068fc9718p-1,
    0x1.921fb8p7
  },
  { // Entry 798
    0x1.fffffffe21d7561725c712f068fc9718p-1,
    -0x1.921fb8p7
  },
  { // Entry 799
    -0x1.6a09db3bdba0868a31e766359a8406cap-1,
    0x1.2d97c4p1
  },
  { // Entry 800
    -0x1.6a09db3bdba0868a31e766359a8406cap-1,
    -0x1.2d97c4p1
  },
  { // Entry 801
    -0x1.6a09e0e4035b86694c16534e42fbe111p-1,
    0x1.2d97c6p1
  },
  { // Entry 802
    -0x1.6a09e0e4035b86694c16534e42fbe111p-1,
    -0x1.2d97c6p1
  },
  { // Entry 803
    -0x1.6a09e68c2affe5aa58050accb05c6248p-1,
    0x1.2d97c8p1
  },
  { // Entry 804
    -0x1.6a09e68c2affe5aa58050accb05c6248p-1,
    -0x1.2d97c8p1
  },
  { // Entry 805
    -0x1.6a09edb67706e0997121d12a0c87bae8p-1,
    0x1.f6a7a0p1
  },
  { // Entry 806
    -0x1.6a09edb67706e0997121d12a0c87bae8p-1,
    -0x1.f6a7a0p1
  },
  { // Entry 807
    -0x1.6a09e80e4f7f2a88debed37faa93e8c8p-1,
    0x1.f6a7a2p1
  },
  { // Entry 808
    -0x1.6a09e80e4f7f2a88debed37faa93e8c8p-1,
    -0x1.f6a7a2p1
  },
  { // Entry 809
    -0x1.6a09e26627e0d3d9cb76de00cb902becp-1,
    0x1.f6a7a4p1
  },
  { // Entry 810
    -0x1.6a09e26627e0d3d9cb76de00cb902becp-1,
    -0x1.f6a7a4p1
  },
  { // Entry 811
    -0x1.f9990e91a74168b90bd68dfab775c9cap-21,
    0x1.2d97c4p2
  },
  { // Entry 812
    -0x1.f9990e91a74168b90bd68dfab775c9cap-21,
    -0x1.2d97c4p2
  },
  { // Entry 813
    -0x1.f3321d234f1363d187dd09528b67b215p-22,
    0x1.2d97c6p2
  },
  { // Entry 814
    -0x1.f3321d234f1363d187dd09528b67b215p-22,
    -0x1.2d97c6p2
  },
  { // Entry 815
    0x1.99bc5b961b1acaca18d971f68ae99da9p-27,
    0x1.2d97c8p2
  },
  { // Entry 816
    0x1.99bc5b961b1acaca18d971f68ae99da9p-27,
    -0x1.2d97c8p2
  },
  { // Entry 817
    0x1.6a09d7a6b572c2c824d137d0405d8188p-1,
    0x1.5fdbbcp2
  },
  { // Entry 818
    0x1.6a09d7a6b572c2c824d137d0405d8188p-1,
    -0x1.5fdbbcp2
  },
  { // Entry 819
    0x1.6a09e2f704eecb181e3f5ece9be0ca0fp-1,
    0x1.5fdbbep2
  },
  { // Entry 820
    0x1.6a09e2f704eecb181e3f5ece9be0ca0fp-1,
    -0x1.5fdbbep2
  },
  { // Entry 821
    0x1.6a09ee47541050ef59ec4bfce935cc1ap-1,
    0x1.5fdbc0p2
  },
  { // Entry 822
    0x1.6a09ee47541050ef59ec4bfce935cc1ap-1,
    -0x1.5fdbc0p2
  },
  { // Entry 823
    0x1.6a09fc9bebaba208c81ec0b1cd307589p-1,
    0x1.c463a8p2
  },
  { // Entry 824
    0x1.6a09fc9bebaba208c81ec0b1cd307589p-1,
    -0x1.c463a8p2
  },
  { // Entry 825
    0x1.6a09f14b9cfcc0f6227d386cc3704a05p-1,
    0x1.c463aap2
  },
  { // Entry 826
    0x1.6a09f14b9cfcc0f6227d386cc3704a05p-1,
    -0x1.c463aap2
  },
  { // Entry 827
    0x1.6a09e5fb4df35d6729f472da3413e404p-1,
    0x1.c463acp2
  },
  { // Entry 828
    0x1.6a09e5fb4df35d6729f472da3413e404p-1,
    -0x1.c463acp2
  },
  { // Entry 829
    0x1.4aa9c2f2c1defb8728f0d2da1217aae1p-21,
    0x1.f6a7a0p2
  },
  { // Entry 830
    0x1.4aa9c2f2c1defb8728f0d2da1217aae1p-21,
    -0x1.f6a7a0p2
  },
  { // Entry 831
    0x1.2aa70bcb07d6d0f36b777cb380a845d9p-23,
    0x1.f6a7a2p2
  },
  { // Entry 832
    0x1.2aa70bcb07d6d0f36b777cb380a845d9p-23,
    -0x1.f6a7a2p2
  },
  { // Entry 833
    -0x1.6aac7a1a7c0c7afc5fcb2313a7eca229p-22,
    0x1.f6a7a4p2
  },
  { // Entry 834
    -0x1.6aac7a1a7c0c7afc5fcb2313a7eca229p-22,
    -0x1.f6a7a4p2
  },
  { // Entry 835
    -0x1.6a09c8c13f48b7aad851f9d6474bcb31p-1,
    0x1.1475cap3
  },
  { // Entry 836
    -0x1.6a09c8c13f48b7aad851f9d6474bcb31p-1,
    -0x1.1475cap3
  },
  { // Entry 837
    -0x1.6a09df61ded49d1ee4fca4ba6140d179p-1,
    0x1.1475ccp3
  },
  { // Entry 838
    -0x1.6a09df61ded49d1ee4fca4ba6140d179p-1,
    -0x1.1475ccp3
  },
  { // Entry 839
    -0x1.6a09f6027cf678b38fc8992cd9990302p-1,
    0x1.1475cep3
  },
  { // Entry 840
    -0x1.6a09f6027cf678b38fc8992cd9990302p-1,
    -0x1.1475cep3
  },
  { // Entry 841
    -0x1.fffffffffc1972c902ef31c37cb54817p-1,
    0x1.2d97c4p3
  },
  { // Entry 842
    -0x1.fffffffffc1972c902ef31c37cb54817p-1,
    -0x1.2d97c4p3
  },
  { // Entry 843
    -0x1.ffffffffff0ca4e6263d27a0204389dfp-1,
    0x1.2d97c6p3
  },
  { // Entry 844
    -0x1.ffffffffff0ca4e6263d27a0204389dfp-1,
    -0x1.2d97c6p3
  },
  { // Entry 845
    -0x1.ffffffffffffd703498c3b8288563915p-1,
    0x1.2d97c8p3
  },
  { // Entry 846
    -0x1.ffffffffffffd703498c3b8288563915p-1,
    -0x1.2d97c8p3
  },
  { // Entry 847
    -0x1.6a0a0b815fb37b2d01551e07cb3009d1p-1,
    0x1.46b9c0p3
  },
  { // Entry 848
    -0x1.6a0a0b815fb37b2d01551e07cb3009d1p-1,
    -0x1.46b9c0p3
  },
  { // Entry 849
    -0x1.6a09f4e0c2e98deb78642b6032a73d46p-1,
    0x1.46b9c2p3
  },
  { // Entry 850
    -0x1.6a09f4e0c2e98deb78642b6032a73d46p-1,
    -0x1.46b9c2p3
  },
  { // Entry 851
    -0x1.6a09de4024b596b50eb06d562db8c777p-1,
    0x1.46b9c4p3
  },
  { // Entry 852
    -0x1.6a09de4024b596b50eb06d562db8c777p-1,
    -0x1.46b9c4p3
  },
  { // Entry 853
    -0x1.4ddd3ba9edcd898b9946fdd20af22a68p-20,
    0x1.5fdbbcp3
  },
  { // Entry 854
    -0x1.4ddd3ba9edcd898b9946fdd20af22a68p-20,
    -0x1.5fdbbcp3
  },
  { // Entry 855
    -0x1.3774eea7b8abe8fa8c380142b97af4b6p-22,
    0x1.5fdbbep3
  },
  { // Entry 856
    -0x1.3774eea7b8abe8fa8c380142b97af4b6p-22,
    -0x1.5fdbbep3
  },
  { // Entry 857
    0x1.644588ac238ae493fa32435ba51329bfp-21,
    0x1.5fdbc0p3
  },
  { // Entry 858
    0x1.644588ac238ae493fa32435ba51329bfp-21,
    -0x1.5fdbc0p3
  },
  { // Entry 859
    0x1.6a09b9dbc881c458e747908caf2aa5e1p-1,
    0x1.78fdb6p3
  },
  { // Entry 860
    0x1.6a09b9dbc881c458e747908caf2aa5e1p-1,
    -0x1.78fdb6p3
  },
  { // Entry 861
    0x1.6a09d07c68fc010ffcfd3b19f1ee4f44p-1,
    0x1.78fdb8p3
  },
  { // Entry 862
    0x1.6a09d07c68fc010ffcfd3b19f1ee4f44p-1,
    -0x1.78fdb8p3
  },
  { // Entry 863
    0x1.6a09e71d080c33f6964a07d1a0bf5980p-1,
    0x1.78fdbap3
  },
  { // Entry 864
    0x1.6a09e71d080c33f6964a07d1a0bf5980p-1,
    -0x1.78fdbap3
  },
  { // Entry 865
    0x1.6a0a03c63742d62802d163d5cfb3b7d5p-1,
    0x1.ab41aep3
  },
  { // Entry 866
    0x1.6a0a03c63742d62802d163d5cfb3b7d5p-1,
    -0x1.ab41aep3
  },
  { // Entry 867
    0x1.6a09ed2599fd364c97660cca6652c0a3p-1,
    0x1.ab41b0p3
  },
  { // Entry 868
    0x1.6a09ed2599fd364c97660cca6652c0a3p-1,
    -0x1.ab41b0p3
  },
  { // Entry 869
    0x1.6a09d684fb4d8c840660d6b42ec83039p-1,
    0x1.ab41b2p3
  },
  { // Entry 870
    0x1.6a09d684fb4d8c840660d6b42ec83039p-1,
    -0x1.ab41b2p3
  },
  { // Entry 871
    0x1.f66595da7a1ae308d26a18de4c2ed3a3p-20,
    0x1.c463a8p3
  },
  { // Entry 872
    0x1.f66595da7a1ae308d26a18de4c2ed3a3p-20,
    -0x1.c463a8p3
  },
  { // Entry 873
    0x1.eccb2bb4f66ea861241fa09ca9d8a034p-21,
    0x1.c463aap3
  },
  { // Entry 874
    0x1.eccb2bb4f66ea861241fa09ca9d8a034p-21,
    -0x1.c463aap3
  },
  { // Entry 875
    -0x1.334d44b0945407b118b361ab78171f67p-25,
    0x1.c463acp3
  },
  { // Entry 876
    -0x1.334d44b0945407b118b361ab78171f67p-25,
    -0x1.c463acp3
  },
  { // Entry 877
    -0x1.6a09c196f2867cc916ae2b7e6c9d99c1p-1,
    0x1.dd85a4p3
  },
  { // Entry 878
    -0x1.6a09c196f2867cc916ae2b7e6c9d99c1p-1,
    -0x1.dd85a4p3
  },
  { // Entry 879
    -0x1.6a09d837928506f7cff76f094b4e0377p-1,
    0x1.dd85a6p3
  },
  { // Entry 880
    -0x1.6a09d837928506f7cff76f094b4e0377p-1,
    -0x1.dd85a6p3
  },
  { // Entry 881
    -0x1.6a09eed83119874e51ae4bb8aeddc1f2p-1,
    0x1.dd85a8p3
  },
  { // Entry 882
    -0x1.6a09eed83119874e51ae4bb8aeddc1f2p-1,
    -0x1.dd85a8p3
  },
  { // Entry 883
    -0x1.fffffffffe54e5e4d32b3453166060b3p-1,
    0x1.f6a7a0p3
  },
  { // Entry 884
    -0x1.fffffffffe54e5e4d32b3453166060b3p-1,
    -0x1.f6a7a0p3
  },
  { // Entry 885
    -0x1.ffffffffffea396ab8aee509392c755dp-1,
    0x1.f6a7a2p3
  },
  { // Entry 886
    -0x1.ffffffffffea396ab8aee509392c755dp-1,
    -0x1.f6a7a2p3
  },
  { // Entry 887
    -0x1.ffffffffff7f8cf09e32d6309bea85cap-1,
    0x1.f6a7a4p3
  },
  { // Entry 888
    -0x1.ffffffffff7f8cf09e32d6309bea85cap-1,
    -0x1.f6a7a4p3
  },
  { // Entry 889
    -0x1.6a0a294c45ec747a47711a4994d2c5e4p-1,
    0x1.07e4ccp4
  },
  { // Entry 890
    -0x1.6a0a294c45ec747a47711a4994d2c5e4p-1,
    -0x1.07e4ccp4
  },
  { // Entry 891
    -0x1.6a09fc0b0ea7ed9fb5dd50a0c8af19cbp-1,
    0x1.07e4cep4
  },
  { // Entry 892
    -0x1.6a09fc0b0ea7ed9fb5dd50a0c8af19cbp-1,
    -0x1.07e4cep4
  },
  { // Entry 893
    -0x1.6a09cec9d1bb3ed4f810c9f9786d610ep-1,
    0x1.07e4d0p4
  },
  { // Entry 894
    -0x1.6a09cec9d1bb3ed4f810c9f9786d610ep-1,
    -0x1.07e4d0p4
  },
  { // Entry 895
    -0x1.4f76f80582c73fc0cc0903ed8ca7d6b3p-19,
    0x1.1475cap4
  },
  { // Entry 896
    -0x1.4f76f80582c73fc0cc0903ed8ca7d6b3p-19,
    -0x1.1475cap4
  },
  { // Entry 897
    -0x1.3ddbe0161108b690eed70a7f59de751cp-21,
    0x1.1475ccp4
  },
  { // Entry 898
    -0x1.3ddbe0161108b690eed70a7f59de751cp-21,
    -0x1.1475ccp4
  },
  { // Entry 899
    0x1.61120ff4f70180b0d55c3ae0f69585cap-20,
    0x1.1475cep4
  },
  { // Entry 900
    0x1.61120ff4f70180b0d55c3ae0f69585cap-20,
    -0x1.1475cep4
  },
  { // Entry 901
    0x1.6a09b2b17b741050a6cfd64b81c76485p-1,
    0x1.2106c8p4
  },
  { // Entry 902
    0x1.6a09b2b17b741050a6cfd64b81c76485p-1,
    -0x1.2106c8p4
  },
  { // Entry 903
    0x1.6a09dff2bbe3c9616a3576c55e773207p-1,
    0x1.2106cap4
  },
  { // Entry 904
    0x1.6a09dff2bbe3c9616a3576c55e773207p-1,
    -0x1.2106cap4
  },
  { // Entry 905
    0x1.6a0a0d33f6ab5af262ad6ad18ac1ce9fp-1,
    0x1.2106ccp4
  },
  { // Entry 906
    0x1.6a0a0d33f6ab5af262ad6ad18ac1ce9fp-1,
    -0x1.2106ccp4
  },
  { // Entry 907
    0x1.fffffffff065cb240bcbfdff4977ddf8p-1,
    0x1.2d97c4p4
  },
  { // Entry 908
    0x1.fffffffff065cb240bcbfdff4977ddf8p-1,
    -0x1.2d97c4p4
  },
  { // Entry 909
    0x1.fffffffffc32939898f585d6948cf2d1p-1,
    0x1.2d97c6p4
  },
  { // Entry 910
    0x1.fffffffffc32939898f585d6948cf2d1p-1,
    -0x1.2d97c6p4
  },
  { // Entry 911
    0x1.ffffffffffff5c0d2630ee0a27e8d6d1p-1,
    0x1.2d97c8p4
  },
  { // Entry 912
    0x1.ffffffffffff5c0d2630ee0a27e8d6d1p-1,
    -0x1.2d97c8p4
  },
  { // Entry 913
    0x1.6a0a3831b81d94966ad8df4d378824f9p-1,
    0x1.3a28c2p4
  },
  { // Entry 914
    0x1.6a0a3831b81d94966ad8df4d378824f9p-1,
    -0x1.3a28c2p4
  },
  { // Entry 915
    0x1.6a0a0af082b5bca7f5569f4da6883f64p-1,
    0x1.3a28c4p4
  },
  { // Entry 916
    0x1.6a0a0af082b5bca7f5569f4da6883f64p-1,
    -0x1.3a28c4p4
  },
  { // Entry 917
    0x1.6a09ddaf47a5bc8dbdcb6b13844902aep-1,
    0x1.3a28c6p4
  },
  { // Entry 918
    0x1.6a09ddaf47a5bc8dbdcb6b13844902aep-1,
    -0x1.3a28c6p4
  },
  { // Entry 919
    0x1.a3bb251dc7efaa1e2137bb37ed6654dbp-19,
    0x1.46b9c0p4
  },
  { // Entry 920
    0x1.a3bb251dc7efaa1e2137bb37ed6654dbp-19,
    -0x1.46b9c0p4
  },
  { // Entry 921
    0x1.47764a3b9566758e5baa2e3029f1abbap-20,
    0x1.46b9c2p4
  },
  { // Entry 922
    0x1.47764a3b9566758e5baa2e3029f1abbap-20,
    -0x1.46b9c2p4
  },
  { // Entry 923
    -0x1.71136b88d4608490f2ddfe90101112aep-21,
    0x1.46b9c4p4
  },
  { // Entry 924
    -0x1.71136b88d4608490f2ddfe90101112aep-21,
    -0x1.46b9c4p4
  },
  { // Entry 925
    -0x1.6a09a3cc03c4bbad2222dfe5be317565p-1,
    0x1.534abep4
  },
  { // Entry 926
    -0x1.6a09a3cc03c4bbad2222dfe5be317565p-1,
    -0x1.534abep4
  },
  { // Entry 927
    -0x1.6a09d10d46112335d0e43d738387de8cp-1,
    0x1.534ac0p4
  },
  { // Entry 928
    -0x1.6a09d10d46112335d0e43d738387de8cp-1,
    -0x1.534ac0p4
  },
  { // Entry 929
    -0x1.6a09fe4e82b5637a4a8f392c3301be94p-1,
    0x1.534ac2p4
  },
  { // Entry 930
    -0x1.6a09fe4e82b5637a4a8f392c3301be94p-1,
    -0x1.534ac2p4
  },
  { // Entry 931
    -0x1.fffffffff9325ace5f682bbb8b122a09p-1,
    0x1.5fdbbcp4
  },
  { // Entry 932
    -0x1.fffffffff9325ace5f682bbb8b122a09p-1,
    -0x1.5fdbbcp4
  },
  { // Entry 933
    -0x1.ffffffffffa144abaed5b4aab880635dp-1,
    0x1.5fdbbep4
  },
  { // Entry 934
    -0x1.ffffffffffa144abaed5b4aab880635dp-1,
    -0x1.5fdbbep4
  },
  { // Entry 935
    -0x1.fffffffffe102e88fe476331e1ddefafp-1,
    0x1.5fdbc0p4
  },
  { // Entry 936
    -0x1.fffffffffe102e88fe476331e1ddefafp-1,
    -0x1.5fdbc0p4
  },
  { // Entry 937
    -0x1.6a0a19d5f626a35ee112a34638e07808p-1,
    0x1.6c6cbap4
  },
  { // Entry 938
    -0x1.6a0a19d5f626a35ee112a34638e07808p-1,
    -0x1.6c6cbap4
  },
  { // Entry 939
    -0x1.6a09ec94bcf35208ccd030684d5ddd9cp-1,
    0x1.6c6cbcp4
  },
  { // Entry 940
    -0x1.6a09ec94bcf35208ccd030684d5ddd9cp-1,
    -0x1.6c6cbcp4
  },
  { // Entry 941
    -0x1.6a09bf537e17d900659bd2fa24c3a8c8p-1,
    0x1.6c6cbep4
  },
  { // Entry 942
    -0x1.6a09bf537e17d900659bd2fa24c3a8c8p-1,
    -0x1.6c6cbep4
  },
  { // Entry 943
    -0x1.f7ff52360c622b3f94d9c7250bfad8d4p-19,
    0x1.78fdb6p4
  },
  { // Entry 944
    -0x1.f7ff52360c622b3f94d9c7250bfad8d4p-19,
    -0x1.78fdb6p4
  },
  { // Entry 945
    -0x1.effea46c21baa3da7c266c953a013598p-20,
    0x1.78fdb8p4
  },
  { // Entry 946
    -0x1.effea46c21baa3da7c266c953a013598p-20,
    -0x1.78fdb8p4
  },
  { // Entry 947
    0x1.0015b93dd0f095be1eb0a5b87fe5e33ep-24,
    0x1.78fdbap4
  },
  { // Entry 948
    0x1.0015b93dd0f095be1eb0a5b87fe5e33ep-24,
    -0x1.78fdbap4
  },
  { // Entry 949
    0x1.6a0994e68b787ee4fd6830b288225745p-1,
    0x1.858eb4p4
  },
  { // Entry 950
    0x1.6a0994e68b787ee4fd6830b288225745p-1,
    -0x1.858eb4p4
  },
  { // Entry 951
    0x1.6a09c227cfa194d1fa7ab9909de5083cp-1,
    0x1.858eb6p4
  },
  { // Entry 952
    0x1.6a09c227cfa194d1fa7ab9909de5083cp-1,
    -0x1.858eb6p4
  },
  { // Entry 953
    0x1.6a09ef690e2283b658509ed319483839p-1,
    0x1.858eb8p4
  },
  { // Entry 954
    0x1.6a09ef690e2283b658509ed319483839p-1,
    -0x1.858eb8p4
  },
  { // Entry 955
    -0x1.f3957bad70e0741f1d3d6751246ce21ap-1,
    0x1.fffffep62
  },
  { // Entry 956
    -0x1.f3957bad70e0741f1d3d6751246ce21ap-1,
    -0x1.fffffep62
  },
  { // Entry 957
    0x1.82aa375b3c33e70663731bab4beb6ed3p-7,
    0x1.p63
  },
  { // Entry 958
    0x1.82aa375b3c33e70663731bab4beb6ed3p-7,
    -0x1.p63
  },
  { // Entry 959
    0x1.945e6c69a580fb7bb27d02c0fe0f8a71p-2,
    0x1.000002p63
  },
  { // Entry 960
    0x1.945e6c69a580fb7bb27d02c0fe0f8a71p-2,
    -0x1.000002p63
  },
  { // Entry 961
    -0x1.b2d255f2bd0423e29e2a548728f034abp-1,
    0x1.fffffep26
  },
  { // Entry 962
    -0x1.b2d255f2bd0423e29e2a548728f034abp-1,
    -0x1.fffffep26
  },
  { // Entry 963
    0x1.4ab6511a7d39ad3cc88ded1e775ca147p-1,
    0x1.p27
  },
  { // Entry 964
    0x1.4ab6511a7d39ad3cc88ded1e775ca147p-1,
    -0x1.p27
  },
  { // Entry 965
    -0x1.ad3d80c82f4452b076581de24648435bp-1,
    0x1.000002p27
  },
  { // Entry 966
    -0x1.ad3d80c82f4452b076581de24648435bp-1,
    -0x1.000002p27
  },
  { // Entry 967
    -0x1.4532c3721ed4343ad88eea8908a988cbp-2,
    0x1.fffffep23
  },
  { // Entry 968
    -0x1.4532c3721ed4343ad88eea8908a988cbp-2,
    -0x1.fffffep23
  },
  { // Entry 969
    0x1.40ad67f3f0c9a143963c9c96dbce3f8ap-1,
    0x1.p24
  },
  { // Entry 970
    0x1.40ad67f3f0c9a143963c9c96dbce3f8ap-1,
    -0x1.p24
  },
  { // Entry 971
    0x1.caf8537c3e442ca8aca86c156773853ap-2,
    0x1.000002p24
  },
  { // Entry 972
    0x1.caf8537c3e442ca8aca86c156773853ap-2,
    -0x1.000002p24
  },
  { // Entry 973
    -0x1.4eaa667ba0b90dfb05ab3d9c247cdee7p-1,
    0x1.fffffep1
  },
  { // Entry 974
    -0x1.4eaa667ba0b90dfb05ab3d9c247cdee7p-1,
    -0x1.fffffep1
  },
  { // Entry 975
    -0x1.4eaa606db24c0c466da1c2dc7baa2b32p-1,
    0x1.p2
  },
  { // Entry 976
    -0x1.4eaa606db24c0c466da1c2dc7baa2b32p-1,
    -0x1.p2
  },
  { // Entry 977
    -0x1.4eaa5451d53348eb89dc478d4d11be02p-1,
    0x1.000002p2
  },
  { // Entry 978
    -0x1.4eaa5451d53348eb89dc478d4d11be02p-1,
    -0x1.000002p2
  },
  { // Entry 979
    -0x1.aa225e2ef96241915b6fd217522814f5p-2,
    0x1.fffffep0
  },
  { // Entry 980
    -0x1.aa225e2ef96241915b6fd217522814f5p-2,
    -0x1.fffffep0
  },
  { // Entry 981
    -0x1.aa22657537204a4332f8acbb72b0d768p-2,
    0x1.p1
  },
  { // Entry 982
    -0x1.aa22657537204a4332f8acbb72b0d768p-2,
    -0x1.p1
  },
  { // Entry 983
    -0x1.aa227401b288620a0372d5a96084915dp-2,
    0x1.000002p1
  },
  { // Entry 984
    -0x1.aa227401b288620a0372d5a96084915dp-2,
    -0x1.000002p1
  },
  { // Entry 985
    0x1.14a282aa25b11f6312a7a65180e7c3d4p-1,
    0x1.fffffep-1
  },
  { // Entry 986
    0x1.14a282aa25b11f6312a7a65180e7c3d4p-1,
    -0x1.fffffep-1
  },
  { // Entry 987
    0x1.14a280fb5068b923848cdb2ed0e37a53p-1,
    0x1.p0
  },
  { // Entry 988
    0x1.14a280fb5068b923848cdb2ed0e37a53p-1,
    -0x1.p0
  },
  { // Entry 989
    0x1.14a27d9da5d4aebce71428f9057b08dap-1,
    0x1.000002p0
  },
  { // Entry 990
    0x1.14a27d9da5d4aebce71428f9057b08dap-1,
    -0x1.000002p0
  },
  { // Entry 991
    0x1.c15280e0737692dd436908fdc8e6e2e1p-1,
    0x1.fffffep-2
  },
  { // Entry 992
    0x1.c15280e0737692dd436908fdc8e6e2e1p-1,
    -0x1.fffffep-2
  },
  { // Entry 993
    0x1.c1528065b7d4f9db7bbb3b45f5f5b30ap-1,
    0x1.p-1
  },
  { // Entry 994
    0x1.c1528065b7d4f9db7bbb3b45f5f5b30ap-1,
    -0x1.p-1
  },
  { // Entry 995
    0x1.c1527f70409076da0c3204df1e099a83p-1,
    0x1.000002p-1
  },
  { // Entry 996
    0x1.c1527f70409076da0c3204df1e099a83p-1,
    -0x1.000002p-1
  },
  { // Entry 997
    0x1.f0154a1789d8dcc172cd2092d05f6394p-1,
    0x1.fffffep-3
  },
  { // Entry 998
    0x1.f0154a1789d8dcc172cd2092d05f6394p-1,
    -0x1.fffffep-3
  },
  { // Entry 999
    0x1.f01549f7deea174f07a67972bf29f148p-1,
    0x1.p-2
  },
  { // Entry 1000
    0x1.f01549f7deea174f07a67972bf29f148p-1,
    -0x1.p-2
  },
  { // Entry 1001
    0x1.f01549b8890c2f66337cac15a7237c8ep-1,
    0x1.000002p-2
  },
  { // Entry 1002
    0x1.f01549b8890c2f66337cac15a7237c8ep-1,
    -0x1.000002p-2
  },
  { // Entry 1003
    0x1.fc01552fd068ee83f5b742c05245e8b2p-1,
    0x1.fffffep-4
  },
  { // Entry 1004
    0x1.fc01552fd068ee83f5b742c05245e8b2p-1,
    -0x1.fffffep-4
  },
  { // Entry 1005
    0x1.fc015527d5bd36da3cd4253bede319cap-1,
    0x1.p-3
  },
  { // Entry 1006
    0x1.fc015527d5bd36da3cd4253bede319cap-1,
    -0x1.p-3
  },
  { // Entry 1007
    0x1.fc015517e065afb6bb102c18f5919820p-1,
    0x1.000002p-3
  },
  { // Entry 1008
    0x1.fc015517e065afb6bb102c18f5919820p-1,
    -0x1.000002p-3
  },
  { // Entry 1009
    0x1.ff0015569ef7e2b96301e6f752c019d4p-1,
    0x1.fffffep-5
  },
  { // Entry 1010
    0x1.ff0015569ef7e2b96301e6f752c019d4p-1,
    -0x1.fffffep-5
  },
  { // Entry 1011
    0x1.ff0015549f4d34ca0e1ee6509bc42b71p-1,
    0x1.p-4
  },
  { // Entry 1012
    0x1.ff0015549f4d34ca0e1ee6509bc42b71p-1,
    -0x1.p-4
  },
  { // Entry 1013
    0x1.ff0015509ff7d2ee6418e924f0de5e97p-1,
    0x1.000002p-4
  },
  { // Entry 1014
    0x1.ff0015509ff7d2ee6418e924f0de5e97p-1,
    -0x1.000002p-4
  },
  { // Entry 1015
    0x1.ffc00155d277d58e727cd95c43f759cfp-1,
    0x1.fffffep-6
  },
  { // Entry 1016
    0x1.ffc00155d277d58e727cd95c43f759cfp-1,
    -0x1.fffffep-6
  },
  { // Entry 1017
    0x1.ffc00155527d2b12aedb49d92928df72p-1,
    0x1.p-5
  },
  { // Entry 1018
    0x1.ffc00155527d2b12aedb49d92928df72p-1,
    -0x1.p-5
  },
  { // Entry 1019
    0x1.ffc001545287d49b57972af5145663a0p-1,
    0x1.000002p-5
  },
  { // Entry 1020
    0x1.ffc001545287d49b57972af5145663a0p-1,
    -0x1.000002p-5
  },
  { // Entry 1021
    0x1.fff0001575499f3d7996e2da11cdeb24p-1,
    0x1.fffffep-7
  },
  { // Entry 1022
    0x1.fff0001575499f3d7996e2da11cdeb24p-1,
    -0x1.fffffep-7
  },
  { // Entry 1023
    0x1.fff000155549f4a28a280e97bcd59c8ap-1,
    0x1.p-6
  },
  { // Entry 1024
    0x1.fff000155549f4a28a280e97bcd59c8ap-1,
    -0x1.p-6
  },
  { // Entry 1025
    0x1.fff00015154a9f0cae4a62151501cd0ap-1,
    0x1.000002p-6
  },
  { // Entry 1026
    0x1.fff00015154a9f0cae4a62151501cd0ap-1,
    -0x1.000002p-6
  },
  { // Entry 1027
    0x1.fffffff0000020155544fff49fca38e6p-1,
    0x1.fffffep-15
  },
  { // Entry 1028
    0x1.fffffff0000020155544fff49fca38e6p-1,
    -0x1.fffffep-15
  },
  { // Entry 1029
    0x1.fffffff00000001555555549f49f49f7p-1,
    0x1.p-14
  },
  { // Entry 1030
    0x1.fffffff00000001555555549f49f49f7p-1,
    -0x1.p-14
  },
  { // Entry 1031
    0x1.ffffffefffffc0155515fff4a1496c1cp-1,
    0x1.000002p-14
  },
  { // Entry 1032
    0x1.ffffffefffffc0155515fff4a1496c1cp-1,
    -0x1.000002p-14
  },
  { // Entry 1033
    0x1.fffffffffffffc000007fffffc015555p-1,
    0x1.fffffep-28
  },
  { // Entry 1034
    0x1.fffffffffffffc000007fffffc015555p-1,
    -0x1.fffffep-28
  },
  { // Entry 1035
    0x1.fffffffffffffc000000000000015555p-1,
    0x1.p-27
  },
  { // Entry 1036
    0x1.fffffffffffffc000000000000015555p-1,
    -0x1.p-27
  },
  { // Entry 1037
    0x1.fffffffffffffbffffeffffff0015555p-1,
    0x1.000002p-27
  },
  { // Entry 1038
    0x1.fffffffffffffbffffeffffff0015555p-1,
    -0x1.000002p-27
  },
  { // Entry 1039
    0x1.fffffffffffffff000001ffffff00015p-1,
    0x1.fffffep-31
  },
  { // Entry 1040
    0x1.fffffffffffffff000001ffffff00015p-1,
    -0x1.fffffep-31
  },
  { // Entry 1041
    0x1.fffffffffffffff00000000000000015p-1,
    0x1.p-30
  },
  { // Entry 1042
    0x1.fffffffffffffff00000000000000015p-1,
    -0x1.p-30
  },
  { // Entry 1043
    0x1.ffffffffffffffefffffbfffffc00015p-1,
    0x1.000002p-30
  },
  { // Entry 1044
    0x1.ffffffffffffffefffffbfffffc00015p-1,
    -0x1.000002p-30
  },
  { // Entry 1045
    0x1.b4bf2c79bdfcdaa53ed6c013f65e0963p-1,
    -0x1.fffffep127
  },
  { // Entry 1046
    0x1.b4bf2c79bdfcdaa53ed6c013f65e0963p-1,
    0x1.fffffep127
  },
  { // Entry 1047
    0x1.b4bf2c79bdfcdaa53ed6c013f65e0963p-1,
    0x1.fffffep127
  },
  { // Entry 1048
    0x1.b4bf2c79bdfcdaa53ed6c013f65e0963p-1,
    -0x1.fffffep127
  },
  { // Entry 1049
    0x1.b4bf2c79bdfcdaa53ed6c013f65e0963p-1,
    0x1.fffffep127
  },
  { // Entry 1050
    0x1.b4bf2c79bdfcdaa53ed6c013f65e0963p-1,
    -0x1.fffffep127
  },
  { // Entry 1051
    -0x1.8877a29e3d7b6defcb528e86f4c3e09ap-1,
    0x1.fffffcp127
  },
  { // Entry 1052
    -0x1.8877a29e3d7b6defcb528e86f4c3e09ap-1,
    -0x1.fffffcp127
  },
  { // Entry 1053
    -0x1.fffffffffffdd94849271d08eecf54a1p-1,
    0x1.921fb6p1
  },
  { // Entry 1054
    -0x1.fffffffffffdd94849271d08eecf54a1p-1,
    -0x1.921fb6p1
  },
  { // Entry 1055
    -0x1.777a5cf72cecc4cde3a31e7d5a026142p-25,
    0x1.921fb6p0
  },
  { // Entry 1056
    -0x1.777a5cf72cecc4cde3a31e7d5a026142p-25,
    -0x1.921fb6p0
  },
  { // Entry 1057
    0x1.14a27d9da5d4aebce71428f9057b08dap-1,
    0x1.000002p0
  },
  { // Entry 1058
    0x1.14a27d9da5d4aebce71428f9057b08dap-1,
    -0x1.000002p0
  },
  { // Entry 1059
    0x1.14a280fb5068b923848cdb2ed0e37a53p-1,
    0x1.p0
  },
  { // Entry 1060
    0x1.14a280fb5068b923848cdb2ed0e37a53p-1,
    -0x1.p0
  },
  { // Entry 1061
    0x1.14a282aa25b11f6312a7a65180e7c3d4p-1,
    0x1.fffffep-1
  },
  { // Entry 1062
    0x1.14a282aa25b11f6312a7a65180e7c3d4p-1,
    -0x1.fffffep-1
  },
  { // Entry 1063
    0x1.6a09e5e3335983e5ac92e733e3f24b42p-1,
    0x1.921fb6p-1
  },
  { // Entry 1064
    0x1.6a09e5e3335983e5ac92e733e3f24b42p-1,
    -0x1.921fb6p-1
  },
  { // Entry 1065
    0x1.ffffffffffffffffffffffffffffffffp-1,
    0x1.000002p-126
  },
  { // Entry 1066
    0x1.ffffffffffffffffffffffffffffffffp-1,
    -0x1.000002p-126
  },
  { // Entry 1067
    0x1.ffffffffffffffffffffffffffffffffp-1,
    0x1.p-126
  },
  { // Entry 1068
    0x1.ffffffffffffffffffffffffffffffffp-1,
    -0x1.p-126
  },
  { // Entry 1069
    0x1.ffffffffffffffffffffffffffffffffp-1,
    0x1.fffffcp-127
  },
  { // Entry 1070
    0x1.ffffffffffffffffffffffffffffffffp-1,
    -0x1.fffffcp-127
  },
  { // Entry 1071
    0x1.ffffffffffffffffffffffffffffffffp-1,
    0x1.fffff8p-127
  },
  { // Entry 1072
    0x1.ffffffffffffffffffffffffffffffffp-1,
    -0x1.fffff8p-127
  },
  { // Entry 1073
    0x1.ffffffffffffffffffffffffffffffffp-1,
    0x1.p-148
  },
  { // Entry 1074
    0x1.ffffffffffffffffffffffffffffffffp-1,
    -0x1.p-148
  },
  { // Entry 1075
    0x1.ffffffffffffffffffffffffffffffffp-1,
    0x1.p-149
  },
  { // Entry 1076
    0x1.ffffffffffffffffffffffffffffffffp-1,
    -0x1.p-149
  },
  { // Entry 1077
    0x1.p0,
    0.0f
  },
  { // Entry 1078
    0x1.p0,
    -0.0f
  },
};
#endif // __BIONIC__

TEST(math_cosf, cosf_intel) {
#if defined(__BIONIC__)
  fesetenv(FE_DFL_ENV);
  for (size_t i = 0; i < sizeof(g_cosf_intel_data)/sizeof(cosf_intel_data_t); i++) {
    EXPECT_FLOAT_EQ(g_cosf_intel_data[i].expected, cosf(g_cosf_intel_data[i].call_data)) << "Failed on element " << i;
  }
#else // __BIONIC__
  GTEST_LOG_(INFO) << "This test does nothing.";
#endif // __BIONIC__
}
